(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1653761,      47501]*)
(*NotebookOutlinePosition[   1654783,      47534]*)
(*  CellTagsIndexPosition[   1654739,      47530]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
1. Rie\[SHacek]te diferenci\[AAcute]lnu rovnicu x-yy'=0. 
   N\[AAcute]jdite partikul\[AAcute]rne rie\[SHacek]enie, ktor\[EAcute] sp\
\:013a\:0148a za\[CHacek]. podmienku:
   \ta)y(2)=3
   \tb)y(-3)=-1.
   Nakreslite integr\[AAcute]lne krivky partikl\[AAcute]rnych rie\[SHacek]en\
\[IAcute].
------------------------------------------------------------------------------\
------------\
\>", "Section",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Arial CE",
  FontColor->RGBColor[0, 0.500008, 0],
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["LSR=Integrate[x,x]-Integrate[y,y]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(x\^2\/2 - y\^2\/2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["r=Solve[LSR==c,y]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{y \[Rule] \(-\@\(\(-2\)\ c + x\^2\)\)}, {y \[Rule] \@\(\(-2\)\ c + \
x\^2\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["y1[x_]=y/.r[[1]]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(\(-\@\(\(-2\)\ c + x\^2\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["y2[x_]=y/.r[[2]]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(\@\(\(-2\)\ c + x\^2\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["pr1=Solve[y2[2]==3,c]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{c \[Rule] \(-\(5\/2\)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["yP1[x_]=y2[x]/.pr1[[1]]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(\@\(5 + x\^2\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
kp1=Plot[yP1[x],{x,-5,5},PlotRange->{0,6},
PlotStyle->Thickness[0.009]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 0 0.103006 [
[.11905 -0.0125 -6 -9 ]
[.11905 -0.0125 6 0 ]
[.30952 -0.0125 -6 -9 ]
[.30952 -0.0125 6 0 ]
[.69048 -0.0125 -3 -9 ]
[.69048 -0.0125 3 0 ]
[.88095 -0.0125 -3 -9 ]
[.88095 -0.0125 3 0 ]
[.4875 .10301 -6 -4.5 ]
[.4875 .10301 0 4.5 ]
[.4875 .20601 -6 -4.5 ]
[.4875 .20601 0 4.5 ]
[.4875 .30902 -6 -4.5 ]
[.4875 .30902 0 4.5 ]
[.4875 .41202 -6 -4.5 ]
[.4875 .41202 0 4.5 ]
[.4875 .51503 -6 -4.5 ]
[.4875 .51503 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 0 m
.11905 .00625 L
s
[(-4)] .11905 -0.0125 0 1 Mshowa
.30952 0 m
.30952 .00625 L
s
[(-2)] .30952 -0.0125 0 1 Mshowa
.69048 0 m
.69048 .00625 L
s
[(2)] .69048 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(4)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.16667 0 m
.16667 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.07143 0 m
.07143 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.5 .10301 m
.50625 .10301 L
s
[(1)] .4875 .10301 1 0 Mshowa
.5 .20601 m
.50625 .20601 L
s
[(2)] .4875 .20601 1 0 Mshowa
.5 .30902 m
.50625 .30902 L
s
[(3)] .4875 .30902 1 0 Mshowa
.5 .41202 m
.50625 .41202 L
s
[(4)] .4875 .41202 1 0 Mshowa
.5 .51503 m
.50625 .51503 L
s
[(5)] .4875 .51503 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(6)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .0206 m
.50375 .0206 L
s
.5 .0412 m
.50375 .0412 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .0824 m
.50375 .0824 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .14421 m
.50375 .14421 L
s
.5 .16481 m
.50375 .16481 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .22661 m
.50375 .22661 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26781 m
.50375 .26781 L
s
.5 .28842 m
.50375 .28842 L
s
.5 .32962 m
.50375 .32962 L
s
.5 .35022 m
.50375 .35022 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .39142 m
.50375 .39142 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .45322 m
.50375 .45322 L
s
.5 .47383 m
.50375 .47383 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .53563 m
.50375 .53563 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57683 m
.50375 .57683 L
s
.5 .59743 m
.50375 .59743 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.009 w
.02381 .56419 m
.06244 .52632 L
.10458 .48575 L
.14415 .44853 L
.18221 .41375 L
.22272 .37814 L
.26171 .34565 L
.30316 .31365 L
.34309 .2861 L
.3815 .26359 L
.40095 .25402 L
.42237 .24516 L
.44268 .23852 L
.45178 .23616 L
.46172 .23402 L
.4671 .23306 L
.4721 .2323 L
.47727 .23164 L
.48196 .23115 L
.48658 .23078 L
.4887 .23065 L
.49093 .23054 L
.49332 .23044 L
.49438 .23041 L
.49552 .23038 L
.49675 .23035 L
.49789 .23034 L
.49859 .23033 L
.49925 .23033 L
.50049 .23033 L
.50163 .23033 L
.50286 .23035 L
.50401 .23037 L
.50508 .23039 L
.50754 .23047 L
.51014 .23059 L
.51268 .23074 L
.51504 .2309 L
.5204 .23138 L
.5293 .2325 L
.53882 .23412 L
.54906 .23636 L
.56016 .23934 L
.58032 .24616 L
.62123 .26504 L
.66064 .28851 L
.69852 .31489 L
.73886 .34611 L
.77769 .37849 L
.81897 .4148 L
Mistroke
.85873 .4512 L
.89697 .48723 L
.93767 .52643 L
.97619 .56419 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`00<03oool0103Z^W8000000000LP2jj_l]0?ooo`060?oDV`00000000000000000009/0e?oo
GP3oool01P3oe9/00000000000000000002K0=Coobl0oooo00@0j[Yb000000000780^^[o;03oool0
0340oooo00<0omBK07:jjP3oool0;P3oool00`2jLP00002K0=Coo`1Q0?ooo`030;Yb000009/0e?oo
0380oooo00<0omBK07:jjP3oool0;03oool002h0oooo00H0oooD09/00000000000000000LP2jj_l_
0?ooo`030?oDV`000000VmCo0640oooo00<0omBK0000002Ke?l0;P3oool01P3oom@0V`0000000000
0000001b0;[Zob`0oooo000X0?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3DV`00VmCo
0?oDV`1b^^XX0?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3oool0oooo0?ooe03De?mR
0?ooo`030?ooe03De?l0oooo02h0oooo00@0e9/009_Do`3oe9/0L[[Z;@3oool002l0oooo00@0oooD
09/0LP2j^Y/0L[[Z;P3oool01P3oj[X0LW:j0?ooo`3oom@0V`2K0=Cooeh0oooo00H0onZj079b^P3o
ool0oooD09/0V`3Dool^0?ooo`040?ooe02K0780^[ZK07:jjRd0oooo000`0?ooo`030?oZ^P1b0000
L[[Z02l0oooo00@0j[Yb000000000000L[[ZH03oool0103Z^W8000000000001b^^X`0?ooo`030?oZ
^P1b0000L[[Z02d0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0
oooo003o0?ooob/0oooo000>0?ooool000003`00000>0?ooo`00503oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool04P3oool002h0oooo00<000000?oo
o`3oool0<03oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0340oooo00<000000?oo
o`3oool0<03oool00`000000oooo0?ooo`0/0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00
U03oool00`000000oooo0?ooo`2C0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00U03oool2
000009@0oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?ooo`030000003oool0oooo09<0
oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?ooo`030000003oool0oooo09<0oooo002D
0?ooo`800000U03oool009@0oooo00<000000?ooo`3oool0T`3oool009@0oooo00<000000?ooo`3o
ool0T`3oool009@0oooo00<000000?ooo`3oool0T`3oool009@0oooo00<000000?ooo`3oool0T`3o
ool009@0oooo00<000000?ooo`3oool0T`3oool009@0oooo0P00002D0?ooo`00U03oool00`000000
oooo0?ooo`2C0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00U03oool00`000000oooo0?oo
o`2C0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00U03oool00`000000oooo0?ooo`2C0?oo
o`00U03oool2000009@0oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?ooo`030000003o
ool0oooo09<0oooo002;0?ooo`060?ooe02K00000000000000000780^^[o0`3oool00`000000oooo
0?ooo`2C0?ooo`00S@3oool00`3oe9/0L[[Z0?ooo`040?ooo`030000003oool0oooo09<0oooo002=
0?ooo`030?oDV`1b^^X0oooo00@0oooo0`00002C0?ooo`00S@3oool00`3oe9/0L[[Z0?ooo`040?oo
o`030000003oool0oooo09<0oooo002<0?ooo`030;YbV`3De9/0L[[Z00D0oooo00<000000?ooo`3o
ool0T`3oool008`0oooo00<0omBK0000001b^^X01@3oool00`000000oooo0?ooo`2C0?ooo`00U03o
ool00`000000oooo0?ooo`2C0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00U03oool20000
09@0oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?ooo`030000003oool0oooo09<0oooo
002D0?ooo`030000003oool0oooo09<0oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?oo
o`800000U03oool009@0oooo00<000000?ooo`3oool0T`3oool009@0oooo00<000000?ooo`3oool0
T`3oool009@0oooo00<000000?ooo`3oool0T`3oool009@0oooo00<000000?ooo`3oool0T`3oool0
09@0oooo00<000000?ooo`3oool0T`3oool009@0oooo0P00002D0?ooo`00U03oool00`000000oooo
0?ooo`2C0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00U03oool00`000000oooo0?ooo`2C
0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00U03oool2000009@0oooo002D0?ooo`030000
003oool0oooo09<0oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?ooo`030000003oool0
oooo09<0oooo002;0?ooo`060?oDV`00000000000000000009/0e?oo0`3oool00`000000oooo0?oo
o`2C0?ooo`00S03oool00`2jLP00002K0=Coo`050?ooo`030000003oool0oooo09<0oooo002=0?oo
o`030?oDV`000000VmCo00@0oooo0`00002C0?ooo`00SP3oool00`3oom@0e=Co0?ooo`030?ooo`03
0000003oool0oooo09<0oooo002;0?ooo`060?oZ^P1bL[X0oooo0?ooe02K09/0e?oo0`3oool00`00
0000oooo0?ooo`2C0?ooo`00S03oool0103Z^W8000000000001b^^X40?ooo`030000003oool0oooo
09<0oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?ooo`800000U03oool00980oooo1@00
002C0?ooo`00Q`3ooolL000008L0oooo00250?ooo`h0000000<0oooo000000000000400000240?oo
o`00O`3oool9000000`0oooo00<000000?ooo`3oool02`3oool600000880oooo001m0?ooo`P00000
3`3oool00`000000oooo0?ooo`0>0?ooo`H00000O`3oool007`0oooo1000000D0?ooo`8000004@3o
ool6000007d0oooo001j0?ooo`@000005P3oool00`000000oooo0?ooo`0C0?ooo`D00000N`3oool0
07L0oooo1P00000G0?ooo`030000003oool0oooo01D0oooo1P00001h0?ooo`00M03oool7000001T0
oooo00<000000?ooo`3oool05`3oool6000007H0oooo001c0?ooo`D00000703oool00`000000oooo
0?ooo`0J0?ooo`D00000M03oool00740oooo1000000O0?ooo`030000003oool0oooo01`0oooo1@00
001b0?ooo`00L03oool400000200oooo0P00000O0?ooo`D00000L03oool006h0oooo1000000R0?oo
o`030000003oool0oooo0200oooo1000001_0?ooo`00K@3oool4000002<0oooo00<000000?ooo`3o
ool08P3oool4000006d0oooo001[0?ooo`@000009@3oool00`000000oooo0?ooo`0S0?ooo`D00000
J`3oool006X0oooo1000000V0?ooo`030000003oool0oooo02D0oooo1@00001Y0?ooo`00J03oool4
000002P0oooo0P00000X0?ooo`@00000J03oool006L0oooo1000000Y0?ooo`030000003oool0oooo
02T0oooo1000001V0?ooo`00I@3oool4000002/0oooo00<000000?ooo`3oool0:P3oool4000006D0
oooo001T0?ooo`@00000;03oool00`000000oooo0?ooo`0/0?ooo`@00000H`3oool00680oooo1000
000V0?ooo`040>ZjLP0000000000002Ke0@0oooo00<000000?ooo`3oool0;@3oool400000680oooo
001Q0?ooo`@000009P3oool01P3oj[X0LW:j0?ooo`3oom@0V`1b0;[Zo`<0oooo00<000000?ooo`3o
ool0;`3oool400000600oooo001O0?ooo`@00000:P3oool00`3DV`00000009_Do`040?ooo`<00000
<03oool4000005l0oooo001N0?ooo`@00000;03oool00`3oom@0Vg:j0?ooo`030?ooo`030000003o
ool0oooo0380oooo0`00001N0?ooo`00G@3oool3000002/0oooo00H0oooD09/0LP2jj_l0oooD09/0
V`3Dool30?ooo`030000003oool0oooo03<0oooo0`00001M0?ooo`00F`3oool4000002d0oooo00@0
onZj078000000000VmCo103oool00`000000oooo0?ooo`0d0?ooo`@00000F`3oool005X0oooo1000
000f0?ooo`030000003oool0oooo03D0oooo1000001J0?ooo`00F@3oool3000003P0oooo0P00000h
0?ooo`<00000F@3oool005P0oooo0`00000i0?ooo`030000003oool0oooo03P0oooo0`00001H0?oo
o`00EP3oool4000003X0oooo00<000000?ooo`3oool0>@3oool4000005H0oooo001E0?ooo`@00000
>`3oool00`000000oooo0?ooo`0j0?ooo`@00000E@3oool005@0oooo0`00000m0?ooo`030000003o
ool0oooo03`0oooo0`00001D0?ooo`00D`3oool3000003h0oooo00<000000?ooo`3oool0?@3oool3
000005<0oooo001A0?ooo`@00000?`3oool2000003l0oooo0`00001B0?ooo`00D03oool400000400
oooo00<000000?ooo`3oool0?`3oool400000500oooo001?0?ooo`<00000@P3oool00`000000oooo
0?ooo`100?ooo`@00000C`3oool004h0oooo0`0000130?ooo`030000003oool0oooo0480oooo0`00
001>0?ooo`00C03oool4000004@0oooo00<000000?ooo`3oool0@`3oool3000004d0oooo001;0?oo
o`@00000A@3oool2000004D0oooo1000001;0?ooo`00BP3oool3000004L0oooo00<000000?ooo`3o
ool0A@3oool4000004X0oooo00190?ooo`<00000B03oool00`000000oooo0?ooo`170?ooo`<00000
B@3oool004P0oooo0`0000190?ooo`030000003oool0oooo04P0oooo0`0000180?ooo`00A`3oool3
000004X0oooo00<000000?ooo`3oool0B@3oool3000004L0oooo00160?ooo`<00000B`3oool00`00
0000oooo0?ooo`1:0?ooo`<00000AP3oool004@0oooo1000001<0?ooo`800000C03oool3000004D0
oooo00130?ooo`@00000C@3oool00`000000oooo0?ooo`1<0?ooo`@00000@`3oool00480oooo0`00
001?0?ooo`030000003oool0oooo04d0oooo100000120?ooo`00@@3oool3000004T0oooo00@0j[Yb
000000000780^^[o0`3oool00`000000oooo0?ooo`1?0?ooo`<00000@@3oool00400oooo0`00001;
0?ooo`030?oDV`1b^^X0oooo00<0oooo00<000000?ooo`3oool0D03oool300000400oooo000o0?oo
o`<00000B@3oool01P3oom@0V`00000000000000001b0;[Zo`<0oooo0`00001A0?ooo`<00000?`3o
ool003h0oooo0`00001;0?ooo`040=BK002Ke?l0omBK07:jjP@0oooo00<000000?ooo`3oool0DP3o
ool3000003h0oooo000m0?ooo`<00000C03oool0103oom@0V`1b0;ZjV`1b^^X40?ooo`030000003o
ool0oooo05<0oooo0`00000m0?ooo`00>`3oool4000004h0oooo00<0onZj0780001b^^X0103oool0
0`000000oooo0?ooo`1D0?ooo`<00000?03oool003X0oooo1000001F0?ooo`030000003oool0oooo
05D0oooo0`00000k0?ooo`00>@3oool3000005P0oooo00<000000?ooo`3oool0EP3oool4000003T0
oooo000h0?ooo`<00000F@3oool2000005P0oooo1000000h0?ooo`00=P3oool4000005X0oooo00<0
00000?ooo`3oool0F@3oool3000003L0oooo000e0?ooo`@00000F`3oool00`000000oooo0?ooo`1J
0?ooo`<00000=P3oool003@0oooo0`00001M0?ooo`030000003oool0oooo05/0oooo0`00000e0?oo
o`00<`3oool3000005h0oooo00<000000?ooo`3oool0G03oool3000003@0oooo000b0?ooo`<00000
G`3oool00`000000oooo0?ooo`1M0?ooo`<00000<`3oool00340oooo0`00001P0?ooo`800000G`3o
ool300000380oooo000`0?ooo`<00000H@3oool00`000000oooo0?ooo`1O0?ooo`<00000<@3oool0
02l0oooo0`00001R0?ooo`030000003oool0oooo0600oooo0`00000`0?ooo`00;P3oool3000006<0
oooo00<000000?ooo`3oool0H@3oool3000002l0oooo000]0?ooo`<00000I03oool00`000000oooo
0?ooo`1R0?ooo`<00000;P3oool002`0oooo0`00001U0?ooo`800000I03oool3000002d0oooo000[
0?ooo`<00000IP3oool00`000000oooo0?ooo`1T0?ooo`<00000;03oool002X0oooo0`00001W0?oo
o`030000003oool0oooo06D0oooo0`00000[0?ooo`00:@3oool3000006P0oooo00<000000?ooo`3o
ool0IP3oool3000002X0oooo000X0?ooo`<00000J@3oool00`000000oooo0?ooo`1W0?ooo`<00000
:@3oool002L0oooo0`00001Z0?ooo`030000003oool0oooo06P0oooo0`00000X0?ooo`009P3oool3
000006/0oooo0P00001Z0?ooo`<000009`3oool002D0oooo0`00001/0?ooo`030000003oool0oooo
06X0oooo0`00000V0?ooo`008`3oool4000006d0oooo00<000000?ooo`3oool0J`3oool3000002D0
oooo000R0?ooo`@00000IP3oool0103Z^W8000000000001b^^X40?ooo`030000003oool0oooo06`0
oooo1000000S0?ooo`008@3oool3000006L0oooo00H0onZj079b^P3oool0oooo0;YbLP2jj_l30?oo
o`030000003oool0oooo06d0oooo1000000R0?ooo`00803oool3000006`0oooo00<0e9]b0;[Zo`3o
ool00P3oool3000006l0oooo0`00000Q0?ooo`007`3oool3000006X0oooo00@0e9/0000000000000
09_D103oool00`000000oooo0?ooo`1`0?ooo`<00000803oool001h0oooo0`00001[0?ooo`030=BK
LP2jj_l0oooo00D0oooo00<000000?ooo`3oool0L@3oool3000001l0oooo000M0?ooo`<00000K03o
ool0103DV`00000000000000Vm@40?ooo`030000003oool0oooo0780oooo0`00000N0?ooo`00703o
ool3000007D0oooo00<000000?ooo`3oool0L`3oool3000001d0oooo000K0?ooo`<00000MP3oool0
0`000000oooo0?ooo`1d0?ooo`<00000703oool001X0oooo0`00001g0?ooo`800000MP3oool30000
01/0oooo000I0?ooo`<00000N03oool00`000000oooo0?ooo`1f0?ooo`<000006P3oool001P0oooo
0`00001i0?ooo`030000003oool0oooo07L0oooo1000000H0?ooo`005`3oool3000007X0oooo00<0
00000?ooo`3oool0N03oool4000001L0oooo000F0?ooo`<00000N`3oool00`000000oooo0?ooo`1j
0?ooo`<000005P3oool001D0oooo0`00001l0?ooo`800000O03oool3000001D0oooo000D0?ooo`<0
0000O@3oool00`000000oooo0?ooo`1l0?ooo`<00000503oool001<0oooo0`00001n0?ooo`030000
003oool0oooo07d0oooo0`00000C0?ooo`00503oool00`000000oooo0?ooo`1m0?ooo`030000003o
ool0oooo07h0oooo00<000000?ooo`3oool04P3oool009@0oooo00<000000?ooo`3oool0T`3oool0
09@0oooo00<000000?ooo`3oool0T`3oool009@0oooo0P00002D0?ooo`00U03oool00`000000oooo
0?ooo`2C0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00U03oool00`000000oooo0?ooo`2C
0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00U03oool2000009@0oooo002D0?ooo`030000
003oool0oooo09<0oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?ooo`030000003oool0
oooo09<0oooo002<0?ooo`050?ooe02K000000000000LP2jj_l00`3oool00`000000oooo0?ooo`2C
0?ooo`00S03oool01@3DV`00VmCo0?ooo`3oom@0e=Co00<0oooo00<000000?ooo`3oool0T`3oool0
08/0oooo00H0oooD09/0001b^^X0oooo0>ZjLP2Ke?l30?ooo`<00000T`3oool008`0oooo00@0^W:K
079b0000000007:jVP3oool008`0oooo00<0omBK001b^P3oool0V`3oool008d0oooo00@0j[Yb0000
00000000VmCoV@3oool00?l0oooo:`3oool00001\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {661, 514.438}} -> {-12.4903, \
22.7493, 0.039013, 0.036071}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["pr2=Solve[y1[-3]==-1,c]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{c \[Rule] 4}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["yP2[x_]=y1[x]/.pr2[[1]]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(\(-\@\(\(-8\) + x\^2\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
kp2=Plot[yP2[x],{x,-5,-Sqrt[8]},
PlotStyle->Thickness[0.01]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
2.21665 0.438567 0.603319 0.142757 [
[.24309 .59082 -12 -9 ]
[.24309 .59082 12 0 ]
[.46238 .59082 -6 -9 ]
[.46238 .59082 6 0 ]
[.68166 .59082 -12 -9 ]
[.68166 .59082 12 0 ]
[.90094 .59082 -6 -9 ]
[.90094 .59082 6 0 ]
[.01131 .03229 -12 -4.5 ]
[.01131 .03229 0 4.5 ]
[.01131 .17505 -12 -4.5 ]
[.01131 .17505 0 4.5 ]
[.01131 .3178 -12 -4.5 ]
[.01131 .3178 0 4.5 ]
[.01131 .46056 -12 -4.5 ]
[.01131 .46056 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.24309 .60332 m
.24309 .60957 L
s
[(-4.5)] .24309 .59082 0 1 Mshowa
.46238 .60332 m
.46238 .60957 L
s
[(-4)] .46238 .59082 0 1 Mshowa
.68166 .60332 m
.68166 .60957 L
s
[(-3.5)] .68166 .59082 0 1 Mshowa
.90094 .60332 m
.90094 .60957 L
s
[(-3)] .90094 .59082 0 1 Mshowa
.125 Mabswid
.06767 .60332 m
.06767 .60707 L
s
.11152 .60332 m
.11152 .60707 L
s
.15538 .60332 m
.15538 .60707 L
s
.19924 .60332 m
.19924 .60707 L
s
.28695 .60332 m
.28695 .60707 L
s
.33081 .60332 m
.33081 .60707 L
s
.37466 .60332 m
.37466 .60707 L
s
.41852 .60332 m
.41852 .60707 L
s
.50623 .60332 m
.50623 .60707 L
s
.55009 .60332 m
.55009 .60707 L
s
.59395 .60332 m
.59395 .60707 L
s
.6378 .60332 m
.6378 .60707 L
s
.72552 .60332 m
.72552 .60707 L
s
.76937 .60332 m
.76937 .60707 L
s
.81323 .60332 m
.81323 .60707 L
s
.85709 .60332 m
.85709 .60707 L
s
.9448 .60332 m
.9448 .60707 L
s
.98866 .60332 m
.98866 .60707 L
s
.25 Mabswid
0 .60332 m
1 .60332 L
s
.02381 .03229 m
.03006 .03229 L
s
[(-4)] .01131 .03229 1 0 Mshowa
.02381 .17505 m
.03006 .17505 L
s
[(-3)] .01131 .17505 1 0 Mshowa
.02381 .3178 m
.03006 .3178 L
s
[(-2)] .01131 .3178 1 0 Mshowa
.02381 .46056 m
.03006 .46056 L
s
[(-1)] .01131 .46056 1 0 Mshowa
.125 Mabswid
.02381 .06084 m
.02756 .06084 L
s
.02381 .08939 m
.02756 .08939 L
s
.02381 .11794 m
.02756 .11794 L
s
.02381 .1465 m
.02756 .1465 L
s
.02381 .2036 m
.02756 .2036 L
s
.02381 .23215 m
.02756 .23215 L
s
.02381 .2607 m
.02756 .2607 L
s
.02381 .28925 m
.02756 .28925 L
s
.02381 .34636 m
.02756 .34636 L
s
.02381 .37491 m
.02756 .37491 L
s
.02381 .40346 m
.02756 .40346 L
s
.02381 .43201 m
.02756 .43201 L
s
.02381 .48911 m
.02756 .48911 L
s
.02381 .51766 m
.02756 .51766 L
s
.02381 .54622 m
.02756 .54622 L
s
.02381 .57477 m
.02756 .57477 L
s
.02381 .00374 m
.02756 .00374 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.01 w
.02381 .01472 m
.06244 .03003 L
.10458 .04689 L
.14415 .06289 L
.18221 .07843 L
.22272 .09517 L
.26171 .11148 L
.30316 .12907 L
.34309 .14627 L
.3815 .1631 L
.42237 .18132 L
.46172 .19924 L
.49955 .21684 L
.53984 .23606 L
.57861 .2551 L
.61984 .27601 L
.65954 .29695 L
.69774 .31799 L
.73838 .34159 L
.77751 .36581 L
.81909 .39377 L
.85916 .42384 L
.89771 .45743 L
.91726 .47739 L
.93871 .50332 L
.94807 .51685 L
.9581 .5341 L
.96296 .54418 L
.96756 .55561 L
.97169 .56891 L
.97283 .57356 L
.97403 .57948 L
.97506 .58605 L
.97619 .60322 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`00o`3oool[0?ooo`003`3oool00`000000oooo0?ooo`3o0?oooaT0oooo000?0?ooo`030000
003oool0oooo0?l0oooo6@3oool000l0oooo0P00003o0?oooaX0oooo000?0?ooo`030000003oool0
oooo0?l0oooo6@3oool000l0oooo00<000000?ooo`3oool0o`3ooolI0?ooo`003P3oool500000?l0
oooo603oool000l0oooo1P00003o0?oooaH0oooo000?0?ooo`030000003oool0oooo00H00000o`3o
oolC0?ooo`00203oool0103Z^W8000000000LP2jj_l30?ooo`030000003oool0oooo0080oooo1`00
003o0?oooa00oooo00090?ooo`030?oDV`1b^^X0oooo00<0oooo00<000000?ooo`3oool01@3oool6
00000?l0oooo3P3oool000H0oooo00H0oooD09/00000000000000000LP2jj_l30?ooo`<00000203o
ool600000?l0oooo2`3oool000030?oDV`00000000000080000000H0VmCo0?ooo`3DV`00VmCo0?oD
V`1b^^X40?ooo`030000003oool0oooo00X0oooo1P00003o0?ooo`T0oooo00070?ooo`040?ooe02K
0780^[ZK07:jjP@0oooo00<000000?ooo`3oool03@3oool600000?l0oooo1P3oool000P0oooo00<0
onZj0780001b^^X0103oool00`000000oooo0?ooo`0?0?ooo`H00000o`3oool40?ooo`003`3oool0
0`000000oooo0?ooo`0B0?ooo`D00000o`3oool20?ooo`003`3oool00`000000oooo0?ooo`0D0?oo
o`H00000oP3oool000l0oooo00<000000?ooo`3oool05P3oool600000?`0oooo000?0?ooo`030000
003oool0oooo01T0oooo1P00003i0?ooo`003`3oool2000001`0oooo1P00003g0?ooo`003`3oool0
0`000000oooo0?ooo`0N0?ooo`H00000m03oool000l0oooo00<000000?ooo`3oool0803oool60000
0?80oooo000?0?ooo`030000003oool0oooo02<0oooo1P00003_0?ooo`003`3oool00`000000oooo
0?ooo`0U0?ooo`L00000k03oool000l0oooo00<000000?ooo`3oool0:03oool600000>X0oooo000?
0?ooo`030000003oool0oooo02/0oooo1P00003W0?ooo`003`3oool00`000000oooo0?ooo`0]0?oo
o`H00000i@3oool000l0oooo0P00000a0?ooo`H00000hP3oool000l0oooo00<000000?ooo`3oool0
<P3oool600000>00oooo000?0?ooo`030000003oool0oooo03D0oooo1@00003N0?ooo`003`3oool0
0`000000oooo0?ooo`0g0?ooo`D00000g03oool000l0oooo00<000000?ooo`3oool0>@3oool60000
0=T0oooo000?0?ooo`030000003oool0oooo03/0oooo1P00003G0?ooo`003`3oool00`000000oooo
0?ooo`0n0?ooo`D00000e@3oool000l0oooo00<000000?ooo`3oool0@03oool500000=<0oooo000?
0?ooo`030000003oool0oooo0480oooo1P00003@0?ooo`003`3oool2000004D0oooo1P00003>0?oo
o`003`3oool00`000000oooo0?ooo`170?ooo`H00000b`3oool000l0oooo00<000000?ooo`3oool0
B@3oool600000<T0oooo000?0?ooo`030000003oool0oooo04`0oooo1@0000370?ooo`003`3oool0
0`000000oooo0?ooo`1>0?ooo`D00000a@3oool000l0oooo00<000000?ooo`3oool0D03oool60000
0<80oooo000?0?ooo`030000003oool0oooo0580oooo1P0000300?ooo`003`3oool00`000000oooo
0?ooo`1E0?ooo`D00000_P3oool000l0oooo0P00001H0?ooo`D00000_03oool000l0oooo00<00000
0?ooo`3oool0F@3oool500000;X0oooo000?0?ooo`030000003oool0oooo05/0oooo1P00002g0?oo
o`003`3oool00`000000oooo0?ooo`1M0?ooo`H00000]@3oool000l0oooo00<000000?ooo`3oool0
H03oool500000;<0oooo000?0?ooo`030000003oool0oooo0680oooo1@00002a0?ooo`001`3oool0
103Z^W80000000000000Vm@40?ooo`030000003oool0oooo06@0oooo1P00002^0?ooo`001P3oool0
1P3oj[X0LW:j0?ooo`3oom@0V`1b0;[Zo`<0oooo00<000000?ooo`3oool0IP3oool600000:`0oooo
00080?ooo`030=BK00000000VmCo00@0oooo0`00001Y0?ooo`H00000Z@3oool000030?oDV`000000
00000080000000H0VmCo0?ooo`3oool0oooo0?ooe02KL[X40?ooo`030000003oool0oooo06/0oooo
1P00002W0?ooo`001P3oool01P3oom@0V`1b0;[Zo`3oom@0V`2K0=Coo`<0oooo00<000000?ooo`3o
ool0KP3oool500000:D0oooo00070?ooo`040?oZ^P1b0000000009_Do`@0oooo00<000000?ooo`3o
ool0L03oool600000:80oooo000?0?ooo`030000003oool0oooo0780oooo1P00002P0?ooo`003`3o
ool00`000000oooo0?ooo`1e0?ooo`H00000W@3oool000l0oooo00<000000?ooo`3oool0M`3oool6
000009/0oooo000?0?ooo`030000003oool0oooo07X0oooo1@00002I0?ooo`003`3oool2000007d0
oooo1@00002G0?ooo`003`3oool00`000000oooo0?ooo`1n0?ooo`H00000U03oool000l0oooo00<0
00000?ooo`3oool0P03oool600000980oooo000?0?ooo`030000003oool0oooo08<0oooo1@00002@
0?ooo`003`3oool00`000000oooo0?ooo`250?ooo`D00000SP3oool000l0oooo00<000000?ooo`3o
ool0Q`3oool5000008`0oooo000?0?ooo`030000003oool0oooo08T0oooo1000002;0?ooo`003`3o
ool00`000000oooo0?ooo`2;0?ooo`@00000R@3oool000l0oooo00<000000?ooo`3oool0S03oool5
000008L0oooo000?0?ooo`800000S`3oool5000008D0oooo000?0?ooo`030000003oool0oooo0900
oooo1@0000230?ooo`003`3oool00`000000oooo0?ooo`2B0?ooo`D00000P@3oool000l0oooo00<0
00000?ooo`3oool0U03oool6000007h0oooo000?0?ooo`030000003oool0oooo09H0oooo1P00001l
0?ooo`003`3oool00`000000oooo0?ooo`2I0?ooo`D00000NP3oool000l0oooo00<000000?ooo`3o
ool0V`3oool5000007P0oooo000?0?ooo`030000003oool0oooo09d0oooo1@00001f0?ooo`003`3o
ool200000:00oooo1@00001d0?ooo`003`3oool00`000000oooo0?ooo`2Q0?ooo`D00000LP3oool0
00l0oooo00<000000?ooo`3oool0X`3oool500000700oooo000?0?ooo`030000003oool0oooo0:D0
oooo1@00001^0?ooo`003`3oool00`000000oooo0?ooo`2W0?ooo`D00000K03oool000l0oooo00<0
00000?ooo`3oool0Z@3oool5000006X0oooo000?0?ooo`030000003oool0oooo0:/0oooo1@00001X
0?ooo`003`3oool00`000000oooo0?ooo`2]0?ooo`D00000IP3oool000l0oooo0P00002`0?ooo`D0
0000I03oool000l0oooo00<000000?ooo`3oool0/@3oool500000680oooo000?0?ooo`030000003o
ool0oooo0;<0oooo1@00001P0?ooo`003`3oool00`000000oooo0?ooo`2e0?ooo`D00000GP3oool0
00l0oooo00<000000?ooo`3oool0]`3oool4000005d0oooo000?0?ooo`030000003oool0oooo0;T0
oooo1000001K0?ooo`001P3oool01P3oe9/00000000000000000002K0=Coo`<0oooo00<000000?oo
o`3oool0^P3oool5000005T0oooo00070?ooo`030;Yb000009/0e?oo00D0oooo00<000000?ooo`3o
ool0_03oool5000005L0oooo00080?ooo`030?oDV`000000VmCo00@0oooo0`00002n0?ooo`D00000
E@3oool000030?oDV`00000000000080000000H0VmCo0?ooo`3oool0oooo0?ooe03De?l40?ooo`03
0000003oool0oooo0<00oooo1000001D0?ooo`001P3oool01P3oj[X0LW:j0?ooo`3oom@0V`2K0=Co
o`<0oooo00<000000?ooo`3oool0`P3oool400000580oooo00070?ooo`040>ZjLP000000000007:j
jP@0oooo00<000000?ooo`3oool0``3oool500000500oooo000?0?ooo`030000003oool0oooo0<D0
oooo1@00001>0?ooo`003`3oool00`000000oooo0?ooo`370?ooo`@00000C@3oool000l0oooo00<0
00000?ooo`3oool0b@3oool4000004/0oooo000?0?ooo`030000003oool0oooo0<X0oooo1@000019
0?ooo`003`3oool00`000000oooo0?ooo`3<0?ooo`@00000B03oool000l0oooo0P00003?0?ooo`@0
0000AP3oool000l0oooo00<000000?ooo`3oool0c`3oool4000004D0oooo000?0?ooo`030000003o
ool0oooo0=40oooo100000130?ooo`003`3oool00`000000oooo0?ooo`3B0?ooo`@00000@P3oool0
00l0oooo00<000000?ooo`3oool0e03oool400000400oooo000?0?ooo`030000003oool0oooo0=D0
oooo1000000o0?ooo`003`3oool00`000000oooo0?ooo`3G0?ooo`@00000?@3oool000l0oooo00<0
00000?ooo`3oool0f03oool4000003`0oooo000?0?ooo`800000f`3oool4000003X0oooo000?0?oo
o`030000003oool0oooo0=/0oooo1000000i0?ooo`003`3oool00`000000oooo0?ooo`3M0?ooo`@0
0000=`3oool000l0oooo00<000000?ooo`3oool0gP3oool4000003H0oooo000?0?ooo`030000003o
ool0oooo0>00oooo1000000d0?ooo`003`3oool00`000000oooo0?ooo`3Q0?ooo`@00000<`3oool0
00l0oooo00<000000?ooo`3oool0h`3oool300000380oooo000?0?ooo`030000003oool0oooo0>@0
oooo1000000`0?ooo`003`3oool200000>H0oooo1000000_0?ooo`003`3oool00`000000oooo0?oo
o`3W0?ooo`<00000;P3oool000l0oooo00<000000?ooo`3oool0j03oool3000002d0oooo000?0?oo
o`030000003oool0oooo0>T0oooo1000000[0?ooo`003`3oool00`000000oooo0?ooo`3Z0?ooo`@0
0000:P3oool000l0oooo00<000000?ooo`3oool0k03oool3000002T0oooo000?0?ooo`030000003o
ool0oooo0>d0oooo0`00000X0?ooo`003`3oool00`000000oooo0?ooo`3^0?ooo`<000009`3oool0
00l0oooo0P00003`0?ooo`@000009@3oool000l0oooo00<000000?ooo`3oool0l03oool4000002@0
oooo000?0?ooo`030000003oool0oooo0?80oooo0`00000S0?ooo`003`3oool00`000000oooo0?oo
o`3c0?ooo`<000008P3oool000l0oooo00<000000?ooo`3oool0m03oool300000240oooo000?0?oo
o`030000003oool0oooo0?D0oooo1000000O0?ooo`003`3oool00`000000oooo0?ooo`3f0?ooo`@0
00007P3oool000H0oooo00H0oooD09/00000000000000000LP2jj_l30?ooo`030000003oool0oooo
0?P0oooo0`00000M0?ooo`00203oool00`3oe9/0L[[Z0?ooo`040?ooo`030000003oool0oooo0?T0
oooo0`00000L0?ooo`00203oool00`3oe9/0L[[Z0?ooo`040?ooo`<00000nP3oool3000001/0oooo
00000`3oe9/00000000000020000000509_Do`3oool0oooo0?oDV`1b^^X01@3oool00`000000oooo
0?ooo`3k0?ooo`<000006P3oool000L0oooo00<0^W:K0=CDV`1b^^X01@3oool00`000000oooo0?oo
o`3l0?ooo`<000006@3oool000L0oooo00<0omBK0000001b^^X01@3oool00`000000oooo0?ooo`3m
0?ooo`<00000603oool000l0oooo00<000000?ooo`3oool0oP3oool2000001P0oooo000?0?ooo`03
0000003oool0oooo0?l0oooo0P00000G0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`40oooo
0P00000F0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`80oooo0P00000E0?ooo`003`3oool2
00000?l0oooo103oool00`000000oooo0?ooo`0C0?ooo`003`3oool00`000000oooo0?ooo`3o0?oo
o`<0oooo0P00000D0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`@0oooo0P00000C0?ooo`00
3`3oool00`000000oooo0?ooo`3o0?ooo`D0oooo0P00000B0?ooo`003`3oool00`000000oooo0?oo
o`3o0?ooo`H0oooo00<000000?ooo`3oool0403oool000l0oooo00<000000?ooo`3oool0o`3oool6
0?ooo`8000004@3oool000l0oooo00<000000?ooo`3oool0o`3oool70?ooo`800000403oool000l0
oooo00<000000?ooo`3oool0o`3oool80?ooo`8000003`3oool000l0oooo0P00003o0?ooo`X0oooo
00<000000?ooo`3oool03@3oool000l0oooo00<000000?ooo`3oool0o`3oool90?ooo`8000003P3o
ool000l0oooo00<000000?ooo`3oool0o`3oool:0?ooo`030000003oool0oooo00`0oooo000?0?oo
o`030000003oool0oooo0?l0oooo2P3oool2000000d0oooo000?0?ooo`030000003oool0oooo0?l0
oooo2`3oool2000000`0oooo000?0?ooo`030000003oool0oooo0?l0oooo303oool00`000000oooo
0?ooo`0:0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo``0oooo0P00000;0?ooo`003`3oool0
0`000000oooo0?ooo`3o0?ooo``0oooo0P00000;0?ooo`003`3oool200000?l0oooo3P3oool00`00
0000oooo0?ooo`090?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`d0oooo0P00000:0?ooo`00
3`3oool00`000000oooo0?ooo`3o0?ooo`h0oooo0P0000090?ooo`003`3oool00`000000oooo0?oo
o`3o0?ooo`l0oooo00<000000?ooo`3oool01`3oool000l0oooo00<000000?ooo`3oool0o`3oool?
0?ooo`800000203oool000l0oooo00<000000?ooo`3oool0>03oool0203Z^W8000000000LP2jj_l0
oooo0?ooe02K000007:j0`3oool0103Z^W8000000000001b^^Xg0?ooo`040>ZjLP000000001b0;[Z
oc@0oooo00@0j[Yb00000000000009_D0P3oool00`3oom@0V`00001b^P030?ooo`040>ZjLP000000
000007:jjSH0oooo00@0j[Yb00000000000009_D3P3oool2000000P0oooo000?0?ooo`030000003o
ool0oooo03T0oooo00<0omBK07:jjP3oool01P3oool01P3oj[X0LW:j0?ooo`3oool0^W9b0;[ZocL0
oooo00<0omBK07:jjP3oool0<`3oool01P3oj[X0LW:j0?ooo`3oom@0V`1b0;[Zo`H0oooo00H0onZj
079b^P3oool0oooo0;YbLP2jj_ld0?ooo`060?oZ^P1bL[X0oooo0?ooe02K0780^^[o3@3oool20000
00P0oooo000?0?ooo`030000003oool0oooo03H0oooo00H0oooD09/00000000000000000LP2jj_l:
0?ooo`030=BKLP2jj_l0oooo03<0oooo00H0oooD09/00000000000000000LP2jj_le0?ooo`030=BK
00000000VmCo00/0oooo00<0e9]b0;[Zo`3oool0=@3oool00`3DV`00000009_Do`0>0?ooo`800000
203oool000l0oooo00<000000?ooo`3oool0<03oool00`3oe9/00000000000020000000609_Do`3o
ool0e9/009_Do`3oe9/0L[[Z203oool0103DV`00000000000000Vm@_0?ooo`030?oDV`0000000000
0080000000H0VmCo0?ooo`3DV`00VmCo0?oDV`1b^^X^0?ooo`030?oDV`00000000000080000000H0
VmCo0?ooo`3oool0oooo0?ooe02KL[X80?ooo`040=BK000000000000002Ke2l0oooo00<0omBK0000
000000000P0000001P2Ke?l0oooo0?ooo`3oool0oooD09]b^Pl0oooo00<000000?ooo`3oool01P3o
ool000l0oooo0P00000h0?ooo`040?ooe02K0780^[ZK07:jjPP0oooo00<0e9]b0;[Zo`3oool0=`3o
ool0103oom@0V`1b0;ZjV`1b^^Xd0?ooo`060?ooe02K0780^^[o0?ooe02K09/0e?oo1`3oool00`3D
Vg80^^[o0?ooo`0f0?ooo`060?ooe02K0780^^[o0?ooe02K09/0e?oo3P3oool2000000L0oooo000?
0?ooo`030000003oool0oooo03P0oooo00<0onZj0780001b^^X0203oool0103DV`00000000000000
Vm@g0?ooo`030?oZ^P1b0000L[[Z03D0oooo00@0onZj078000000000VmCo203oool0103DV`000000
00000000Vm@f0?ooo`040?oZ^P1b0000000009_Doa00oooo00<000000?ooo`3oool01@3oool000l0
oooo00<000000?ooo`3oool0o`3oool@0?ooo`8000001`3oool000l0oooo00<000000?ooo`3oool0
o`3oool@0?ooo`8000001`3oool000l0oooo00<000000?ooo`3oool0o`3oool@0?ooo`8000001`3o
ool000l0oooo00<000000?ooo`3oool0o`3oool@0?ooo`8000001`3oool000l0oooo00<000000?oo
o`3oool0o`3oool@0?ooo`8000001`3oool000l0oooo00<000000?ooo`3oool0o`3oool@0?ooo`80
00001`3oool000P0ooooo`00000S000000003`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`050?ooo`8000000`3o
ool00`000000oooo0?ooo`010?ooo`003`3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0
oooo03d0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0m0?ooo`030000003oool0
oooo01X0oooo000?0?ooo`030000003oool0oooo0?l0oooo6@3oool000l0oooo00<000000?ooo`3o
ool0o`3ooolI0?ooo`00o`3oool[0?ooo`00o`3oool[0?ooo`00\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {238.813, 92.25}} -> {-6.47816, \
-1.48607, 0.0079006, 0.0242716}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"],

Cell["obl1=Table[Plot[y1[x],{x,-4,4}],{c,1,5}];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show[%]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.603319 0.157311 [
[.02381 .59082 -6 -9 ]
[.02381 .59082 6 0 ]
[.2619 .59082 -6 -9 ]
[.2619 .59082 6 0 ]
[.7381 .59082 -3 -9 ]
[.7381 .59082 3 0 ]
[.97619 .59082 -3 -9 ]
[.97619 .59082 3 0 ]
[.4875 .05273 -24 -4.5 ]
[.4875 .05273 0 4.5 ]
[.4875 .13139 -12 -4.5 ]
[.4875 .13139 0 4.5 ]
[.4875 .21004 -24 -4.5 ]
[.4875 .21004 0 4.5 ]
[.4875 .2887 -12 -4.5 ]
[.4875 .2887 0 4.5 ]
[.4875 .36735 -24 -4.5 ]
[.4875 .36735 0 4.5 ]
[.4875 .44601 -12 -4.5 ]
[.4875 .44601 0 4.5 ]
[.4875 .52466 -24 -4.5 ]
[.4875 .52466 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .60332 m
.02381 .60957 L
s
[(-4)] .02381 .59082 0 1 Mshowa
.2619 .60332 m
.2619 .60957 L
s
[(-2)] .2619 .59082 0 1 Mshowa
.7381 .60332 m
.7381 .60957 L
s
[(2)] .7381 .59082 0 1 Mshowa
.97619 .60332 m
.97619 .60957 L
s
[(4)] .97619 .59082 0 1 Mshowa
.125 Mabswid
.08333 .60332 m
.08333 .60707 L
s
.14286 .60332 m
.14286 .60707 L
s
.20238 .60332 m
.20238 .60707 L
s
.32143 .60332 m
.32143 .60707 L
s
.38095 .60332 m
.38095 .60707 L
s
.44048 .60332 m
.44048 .60707 L
s
.55952 .60332 m
.55952 .60707 L
s
.61905 .60332 m
.61905 .60707 L
s
.67857 .60332 m
.67857 .60707 L
s
.79762 .60332 m
.79762 .60707 L
s
.85714 .60332 m
.85714 .60707 L
s
.91667 .60332 m
.91667 .60707 L
s
.25 Mabswid
0 .60332 m
1 .60332 L
s
.5 .05273 m
.50625 .05273 L
s
[(-3.5)] .4875 .05273 1 0 Mshowa
.5 .13139 m
.50625 .13139 L
s
[(-3)] .4875 .13139 1 0 Mshowa
.5 .21004 m
.50625 .21004 L
s
[(-2.5)] .4875 .21004 1 0 Mshowa
.5 .2887 m
.50625 .2887 L
s
[(-2)] .4875 .2887 1 0 Mshowa
.5 .36735 m
.50625 .36735 L
s
[(-1.5)] .4875 .36735 1 0 Mshowa
.5 .44601 m
.50625 .44601 L
s
[(-1)] .4875 .44601 1 0 Mshowa
.5 .52466 m
.50625 .52466 L
s
[(-0.5)] .4875 .52466 1 0 Mshowa
.125 Mabswid
.5 .06846 m
.50375 .06846 L
s
.5 .08419 m
.50375 .08419 L
s
.5 .09992 m
.50375 .09992 L
s
.5 .11565 m
.50375 .11565 L
s
.5 .14712 m
.50375 .14712 L
s
.5 .16285 m
.50375 .16285 L
s
.5 .17858 m
.50375 .17858 L
s
.5 .19431 m
.50375 .19431 L
s
.5 .22577 m
.50375 .22577 L
s
.5 .2415 m
.50375 .2415 L
s
.5 .25723 m
.50375 .25723 L
s
.5 .27297 m
.50375 .27297 L
s
.5 .30443 m
.50375 .30443 L
s
.5 .32016 m
.50375 .32016 L
s
.5 .33589 m
.50375 .33589 L
s
.5 .35162 m
.50375 .35162 L
s
.5 .38308 m
.50375 .38308 L
s
.5 .39881 m
.50375 .39881 L
s
.5 .41455 m
.50375 .41455 L
s
.5 .43028 m
.50375 .43028 L
s
.5 .46174 m
.50375 .46174 L
s
.5 .47747 m
.50375 .47747 L
s
.5 .4932 m
.50375 .4932 L
s
.5 .50893 m
.50375 .50893 L
s
.5 .54039 m
.50375 .54039 L
s
.5 .55613 m
.50375 .55613 L
s
.5 .57186 m
.50375 .57186 L
s
.5 .58759 m
.50375 .58759 L
s
.5 .037 m
.50375 .037 L
s
.5 .02127 m
.50375 .02127 L
s
.5 .00554 m
.50375 .00554 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .06964 L
.10458 .13053 L
.14415 .18905 L
.18221 .24716 L
.22272 .31218 L
.26171 .38048 L
.28326 .42295 L
.30316 .46854 L
.31304 .49589 L
.3223 .5282 L
.32481 .5393 L
.3271 .55131 L
.32832 .55892 L
.32965 .569 L
.33038 .57602 L
.33105 .58473 L
s
.66843 .59668 m
.66859 .59168 L
.66928 .58005 L
.66992 .57298 L
.67137 .56105 L
.67378 .5464 L
.67597 .53566 L
.68089 .5159 L
.70244 .45477 L
.74229 .37308 L
.78227 .30394 L
.82073 .24258 L
.86165 .18037 L
.90106 .12232 L
.93894 .06765 L
.97619 .01472 L
s
.02381 .05838 m
.06244 .11822 L
.10458 .18615 L
.14415 .25386 L
.18221 .32519 L
.20342 .36964 L
.22272 .41553 L
.23233 .4417 L
.24276 .47464 L
.24754 .49241 L
.25261 .51457 L
.25694 .53875 L
.25813 .54706 L
.2594 .5576 L
.26061 .57044 L
.26171 .59058 L
s
.73849 .58517 m
.73955 .56844 L
.74072 .55648 L
.74197 .54636 L
.74683 .51734 L
.75552 .48078 L
.7751 .42122 L
.8153 .33018 L
.8568 .25217 L
.89678 .18389 L
.93525 .12186 L
.97617 .05841 L
.97619 .05838 L
s
.02381 .10586 m
.06244 .17225 L
.10458 .25042 L
.14415 .33382 L
.16408 .38296 L
.18221 .43639 L
.19227 .47341 L
.19689 .494 L
.20178 .52078 L
.20426 .53824 L
.20568 .55059 L
.20636 .55767 L
.207 .5656 L
.20821 .58972 L
s
.79167 .59494 m
.79183 .58835 L
.79254 .57239 L
.79322 .56271 L
.79457 .54824 L
.79603 .53593 L
.80106 .50442 L
.81095 .46066 L
.82007 .42896 L
.85782 .3293 L
.89722 .2469 L
.93511 .17659 L
.97545 .10709 L
.97619 .10586 L
s
.02381 .15838 m
.06244 .23409 L
.10458 .32937 L
.1253 .3861 L
.14415 .45122 L
.15367 .49625 L
.15639 .51285 L
.15891 .53134 L
.16003 .54137 L
.16128 .5547 L
.16253 .57352 L
.16321 .59426 L
s
.83683 .59182 m
.83802 .56408 L
.83871 .55479 L
.83937 .54741 L
.84058 .5357 L
.84332 .51479 L
.84824 .48591 L
.85942 .43719 L
.87826 .37557 L
.89869 .32122 L
.93961 .22986 L
.97619 .15838 L
s
.02381 .21799 m
.06244 .30864 L
.08426 .37022 L
.09408 .4027 L
.10458 .44347 L
.10966 .46702 L
.11447 .49347 L
.11878 .524 L
.11996 .53461 L
.12122 .548 L
.12229 .56273 L
.12347 .59354 L
s
.87666 .587 m
.87779 .56142 L
.87904 .54504 L
.8804 .53116 L
.88316 .50906 L
.88811 .47863 L
.89929 .42748 L
.91976 .35797 L
.93891 .30514 L
.97619 .21799 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oU03oool0
0`000000oooo0?ooo`2C0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00U03oool2000009@0
oooo002D0?ooo`030000003oool0oooo09<0oooo00070?ooo`030000003oool0oooo08X0oooo00<0
00000?ooo`3oool0R`3oool00`000000oooo0?ooo`050?ooo`00203oool00`000000oooo0?ooo`29
0?ooo`030000003oool0oooo08X0oooo00<000000?ooo`3oool01P3oool000P0oooo00<000000?oo
o`3oool0R@3oool2000008/0oooo00<000000?ooo`3oool01P3oool000T0oooo00<000000?ooo`3o
ool0R03oool00`000000oooo0?ooo`290?ooo`030000003oool0oooo00L0oooo000:0?ooo`030000
003oool0oooo08L0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`080?ooo`002P3o
ool00`000000oooo0?ooo`270?ooo`030000003oool0oooo08P0oooo00<000000?ooo`3oool0203o
ool000/0oooo00<000000?ooo`3oool0QP3oool00`000000oooo0?ooo`270?ooo`030000003oool0
oooo00T0oooo000<0?ooo`030000003oool0oooo08D0oooo0P0000270?ooo`030000003oool0oooo
00X0oooo000<0?ooo`030000003oool0oooo08D0oooo00<000000?ooo`3oool0Q@3oool00`000000
oooo0?ooo`0;0?ooo`003@3oool00`000000oooo0?ooo`240?ooo`030000003oool0oooo08D0oooo
00<000000?ooo`3oool02`3oool000d0oooo00<000000?ooo`3oool0L03oool0103Z^W8000000000
0000Vm@20?ooo`030?ooe02K000007:j00<0oooo00@0j[Yb000000000000L[[Z103oool00`000000
oooo0?ooo`240?ooo`030000003oool0oooo00`0oooo000>0?ooo`030000003oool0oooo06h0oooo
00H0onZj079b^P3oool0oooD09/0LP2jj_l60?ooo`060?oZ^P1bL[X0oooo0?ooo`2jLW80^^[o0`3o
ool00`000000oooo0?ooo`230?ooo`030000003oool0oooo00d0oooo000?0?ooo`030000003oool0
oooo06l0oooo00<0e9/00000002Ke?l02`3oool00`3DVg80^^[o0?ooo`020?ooo`<00000P`3oool0
0`000000oooo0?ooo`0=0?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
06L0oooo00<0omBK0000000000000P0000001P2Ke?l0oooo0?ooo`3oool0oooD09]b^PP0oooo00@0
e9/000000000000009_D103oool00`000000oooo0?ooo`220?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01@3oool000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`1/0?ooo`060?ooe02K0780^^[o0?ooe02K09/0e?oo1`3oool00`3DVg80^^[o0?ooo`050?ooo`03
0000003oool0oooo0840oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`00
203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo06`0oooo00@0onZj078000000000
VmCo203oool0103DV`00000000000000Vm@40?ooo`030000003oool0oooo0840oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`060?ooo`002@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0800oooo0P0000210?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01`3oool000T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1o0?ooo`030000
003oool0oooo07l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`002P3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo07h0oooo00<000000?ooo`3oool0OP3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo000;0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0OP3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool02@3oool000/0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`1m0?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`090?ooo`00303oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo07`0
oooo0P00001m0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool000`0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1k0?ooo`030000003oool0oooo07/0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0;0?ooo`003@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo07/0oooo00<000000?ooo`3oool0N`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00/0oooo000>0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0NP3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0303oool000h0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1i0?oo
o`030000003oool0oooo07T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0=0?oo
o`003`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo07T0oooo0P00001i0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool03@3oool000L0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo07P0oooo00<000000?ooo`3oool0
N03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1@3oool000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo07L0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01P3oool000P0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo07H0oooo00<000000?ooo`3oool0MP3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool0
00T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
07H0oooo0P00001f0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`070?ooo`002@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0M@3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`002P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0M03oool00`000000oooo
0?ooo`1d0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`080?ooo`002P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0J`3oool0103Z^W80000000000000Vm@40?ooo`030000003oool0oooo07<0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo
000;0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`1Z0?ooo`060?oZ^P1bL[X0oooo0?ooe02K0780^^[o0`3oool00`000000oooo0?ooo`1c0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`00
2`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
J`3oool00`3DV`00000009_Do`040?ooo`<00000LP3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool02P3oool000`0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0680oooo00<0omBK0000000000000P00
00001P2Ke?l0oooo0?ooo`3oool0oooD09]b^P@0oooo00<000000?ooo`3oool0LP3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool000`0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo06P0oooo
00H0oooD09/0LP2jj_l0oooD09/0V`3Dool30?ooo`030000003oool0oooo0740oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00/0oooo000=0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1X0?ooo`04
0?oZ^P1b0000000009_Do`@0oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0303oool000h0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3o
ool0L03oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0303oool000h0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo06h0oooo0P00001`0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0=0?ooo`003`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?ooo`1^0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0=0?ooo`003`3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0K@3oool0
0`000000oooo0?ooo`1^0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0>0?ooo`001`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1/0?ooo`030000003oool0oooo
06d0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01@3oool000L0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0K03oool2000006h0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01P3oool000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0J`3oool00`000000oooo
0?ooo`1/0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00H0oooo00080?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo06X0oooo00<0
00000?ooo`3oool0J`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`002@3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1Z
0?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool000T0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0J@3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo000:0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo06P0oooo0P00001[0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo000:0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo06L0oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`002`3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3o
ool000/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0IP3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00X0oooo000<0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo06D0oooo00<000000?ooo`3oool0I`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0:0?ooo`00303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1U0?ooo`800000I`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0;0?ooo`003@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1T0?ooo`030000003oool0oooo06H0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool02`3oool000d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0CP3oool02P3oe9/000000000
00000000002K0=Coo`3oool0oooD09/00000L[X30?ooo`040>ZjLP000000000007:jjP@0oooo00<0
00000?ooo`3oool0I@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`003P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1?
0?ooo`030;Yb000009/0e?oo00P0oooo00H0onZj079b^P3oool0oooo0;YbLP2jj_l30?ooo`030000
003oool0oooo06@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0303oool000h0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0C`3o
ool00`3oe9/0000009_Do`0;0?ooo`030=BKLP2jj_l0oooo0080oooo0`00001T0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00d0oooo000?0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo04H0oooo00<0omBK0000000000000P000000
1P2Ke?l0oooo0?ooo`3oool0oooD0=CDo`P0oooo00@0e9/000000000000009_D103oool00`000000
oooo0?ooo`1S0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00d0oooo000?0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo04`0oooo
00H0onZj079b^P3oool0oooD09/0V`3Dool70?ooo`030=BKLP2jj_l0oooo00D0oooo00<000000?oo
o`3oool0HP3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0>0?ooo`001`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo04`0oooo00@0j[Yb000000000000L[[Z203oool0103DV`00000000000000Vm@4
0?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`05
0?ooo`001`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0600oooo00<000000?oo
o`3oool0H@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00080?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool0G`3oool200000640oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`060?ooo`00203oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo05h0oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00H0oooo00090?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0GP3o
ool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3o
ool000T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1M0?ooo`030000003oool0
oooo05h0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`002@3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool0GP3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo000:0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0G03oool2000005h0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`080?ooo`002P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo05/0oooo
00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo
000;0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?oo
o`1L0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool000/0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05/0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`002`3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo05T0oooo0P00001K0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool02P3oool000`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1I0?ooo`03
0000003oool0oooo05X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`00
303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo05P0oooo00<000000?ooo`3oool0
F@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00/0oooo000=0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`1H0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool02`3oool000d0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`1G0?ooo`030000003oool0oooo05P0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`0;0?ooo`003P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
05H0oooo0P00001H0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0303oool000h0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo05H0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`003P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0EP3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00d0oooo000?0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0B`3oool01P3oe9/00000000000000000002K0=Coo`<0oooo00<000000?ooo`3o
ool0E@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00d0oooo000?0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0C03oool00`2jLP00002K0=Coo`050?ooo`030000
003oool0oooo05@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0=0?ooo`00403o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo04`0oooo00<0omBK0000002Ke?l0103o
ool3000005@0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0>0?ooo`00403oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo04@0oooo00<0omBK0000000000000P000000
1P2Ke?l0oooo0?ooo`3oool0oooD0=CDo`@0oooo00<000000?ooo`3oool0D`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00h0oooo000@0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0B@3oool01P3oj[X0LW:j0?ooo`3oom@0V`2K0=Coo`<0oooo00<000000?ooo`3o
ool0DP3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00l0oooo000A0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0B@3oool0103Z^W8000000000001b^^X40?ooo`03
0000003oool0oooo0580oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0?0?ooo`00
4@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0540oooo0P00001B0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0403oool00180oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0@0?ooo`004P3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo0500oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo0100oooo000B0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0C`3oool00`00
0000oooo0?ooo`1?0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool04@3oool001<0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo04l0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo04h0oooo0P00001?0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool04P3oool001@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`1=0?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0B0?ooo`00503oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo04d0oooo00<00000
0?ooo`3oool0C@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0180oooo000D0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`1<0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool04`3oool001D0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0C0?ooo`005@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo04/0oooo0P00001<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
503oool001D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1:0?ooo`030000003o
ool0oooo04/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0D0?ooo`005P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo04X0oooo00<000000?ooo`3oool0BP3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo01@0oooo000F0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool05@3oool001L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`180?ooo`800000BP3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01D0
oooo000G0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`180?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05P3oool001L0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo04P0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`00603oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo0380oooo00X0oooD09/00000000000000000LP2jj_l0oooo0?ooe02K
000007:j0`3oool0103Z^W8000000000001b^^X40?ooo`030000003oool0oooo04L0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`00603oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo03<0oooo00<0omBK07:jjP3oool01`3oool01P3oj[X0LW:j0?ooo`3oool0
^W9b0;[Zo`<0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo01L0oooo000I0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0<P3oool0
0`3oe9/0L[[Z0?ooo`0;0?ooo`030=BKLP2jj_l0oooo0080oooo0`0000160?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool05`3oool001T0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0Z0?ooo`030?oDV`00000000000080000000D0VmCo0?ooo`3oool0omBK07:jjP09
0?ooo`040=BK000000000000002Ke0@0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo01L0oooo000I0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool0<03oool00`2jLY/0e=BK07:jjP090?ooo`030=BKLP2jj_l0oooo00D0oooo00<00000
0?ooo`3oool0A@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo000J0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool0<03oool00`3oe9/0000007:jjP090?oo
o`040=BK000000000000002Ke0@0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo01P0oooo000J0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0@`3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0603oool001X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`130?ooo`80
0000A03oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01P0oooo000J0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`130?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool06@3oool001/0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`120?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0I0?ooo`006`3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo0440oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo01T0oooo000K0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0@@3oool20000
0480oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0I0?ooo`00703oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0@@3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo01X0oooo000L0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool06P3oool001`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0o0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0J0?ooo`00703oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03l0oooo00<00000
0?ooo`3oool0?`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01/0oooo000M0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool0?P3oool200000400oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0K0?ooo`007@3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo03h0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo01/0oooo000M0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
?@3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
6`3oool001d0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0m0?ooo`030000003o
ool0oooo03d0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0L0?ooo`007P3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0?@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo01`0oooo000N0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool0?03oool2000003d0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0L0?ooo`007P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03`0
oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01`0
oooo000N0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0<P3oool01P3oom@0V`00
000000000000001b0;[Zo`<0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo01d0oooo000O0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool0=03oool00`3oe9/0L[[Z0?ooo`040?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0M0?ooo`007`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo03<0oooo00<0omBK07:jjP3oool0103oool3000003X0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0M0?ooo`007`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo02/0oooo00<0omBK0000000000000P0000001@2Ke?l0oooo0?ooo`3oe9/0L[[Z00D0oooo
00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01d0oooo
000O0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0<@3oool00`2jLY/0e=BK07:j
jP050?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0M0?ooo`007`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0340oooo00<0omBK
0000001b^^X01@3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool07P3oool00200oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0h0?oo
o`030000003oool0oooo03T0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0N0?oo
o`00803oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03P0oooo0P00000i0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool07P3oool00200oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0N0?ooo`00803oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo03L0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo01h0oooo000P0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0=`3oool0
0`000000oooo0?ooo`0g0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool07`3oool0
0200oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo
03L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0O0?ooo`008@3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo03H0oooo0P00000h0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool07`3oool00240oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0f0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0O0?ooo`008@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03D0oooo00<0
00000?ooo`3oool0=P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01l0oooo000Q
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0f
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0803oool00280oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0d0?ooo`800000=P3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo0200oooo000R0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool0=03oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0803oool00280oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0d0?ooo`030000
003oool0oooo03D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0P0?ooo`008P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0=03o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0240oooo000R0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool08@3oool00280oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0c0?ooo`800000=@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
0240oooo000S0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0<`3oool00`000000
oooo0?ooo`0c0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool08@3oool002<0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo03<0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0Q0?ooo`008`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo01h0oooo00@0j[Yb000000000000L[[Z0P3oool00`3oom@0V`00
001b^P030?ooo`040>ZjLP000000000007:jjP@0oooo00<000000?ooo`3oool0<`3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo0240oooo000S0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool07P3oool01@2jVkX0oooo0?ooo`2jLY/0e?oo00H0oooo00H0onZj079b^P3o
ool0oooo0;YbLP2jj_l30?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0R0?ooo`008`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
01`0oooo00H0oooD09]b^P3oool0oooo0=BKLP2jj_l:0?ooo`030=BKLP2jj_l0oooo0080oooo0`00
000b0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool08P3oool002<0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0F0?ooo`030?oDV`00000000000080000000<0VmCo
0?ooe02KL[X00P3oool00`3DVg80^^[o0?ooo`060?ooo`040=BK000000000000002Ke0@0oooo00<0
00000?ooo`3oool0<P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0280oooo000S
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool07@3oool01@2jLW80^^[o0?ooe02K
09/0e?oo00L0oooo00<0e9]b0;[Zo`3oool01@3oool00`000000oooo0?ooo`0b0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool08P3oool002<0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0M0?ooo`040?oZ^P1b0000000009_Do`P0oooo00@0e9/000000000000009_D
103oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
8P3oool002<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0a0?ooo`800000<`3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0280oooo000S0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool08P3oool002@0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0a0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0R0?ooo`00903oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0300
oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0280
oooo000T0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0<03oool00`000000oooo
0?ooo`0a0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool08P3oool002@0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0`0?ooo`800000<@3oool00`000000oooo0?oo
o`0B0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo02<0oooo000T0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool0<03oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool08`3oool000T0oooo00@0j[Yb000000000780^^[o5`3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool00`000000omBK00000002
000000030000V`3Dool0oooo00`0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0`
0?ooo`030000003oool0oooo00h0oooo00H0omBK00000000000000000000V`3Dool=0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0J0?ooo`040>Zj
LP000000001b0;[Zo`D0oooo000:0?ooo`030?oDV`1b^^X0oooo01L0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00d0oooo00D000000?ooo`2jLP00
002K0=Coo`0@0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0<03oool00`000000
oooo0?ooo`0?0?ooo`030;Yb000009/0000000l0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo01/0oooo00<0omBK07:jjP3oool01@3oool000L0oooo
00H0oooD09/00000000000000000LP2jj_lG0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0=0?ooo`060000003oool0oooo0?oDV`000000VmCo3`3o
ool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0403o
ool00`3oe9/0000009_Do`0>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0H0?ooo`060?ooe02K00000000000000000780^^[o1@3oool000030?oo
o`3oe9/0000000<0000000H0VmCo0?ooo`3DV`00VmCo0?oDV`1b^^XH0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030?oDV`0000000000
00<000000`3oool00`3oom@0e=Co0?ooo`0>0?ooo`030000003oool0oooo02l0oooo0P00000a0?oo
o`030000003oool0oooo0140oooo00<000000=CDo`3oool03@3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool06@3oool0103DV`00VmCo0?oDV`1b^^X6
0?ooo`00203oool0103oom@0V`1b0;ZjV`1b^^XH0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0=0?ooo`070000003oj[X0LW:j0?ooo`3oom@0V`2K
0=Coo`0>0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0<03oool00`000000oooo
0?ooo`0>0?ooo`060?oZ^P1bL[X0oooo0000002K09/0e?oo3@3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool06@3oool0103oom@0V`1b0;ZjV`1b^^X6
0?ooo`002@3oool00`3oj[X0LP0007:jjP0I0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0j[Yb0080000000<0L[[Z0?oo
o`3oool03@3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0300oooo00<000000?oo
o`3oool03`3oool0103Z^W8000000000001b^^X>0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0J0?ooo`030?oZ^P1b0000L[[Z00H0oooo000U0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool08`3oool002D0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0_0?ooo`800000<03oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo02<0oooo000U0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0
;`3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
;`3oool002D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1Q0?ooo`030000003o
ool0oooo02l0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo02l0oooo002D0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool08P3oool0
0`000000oooo0?ooo`0l0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00o`00000[00000000
1`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00D0oooo00070?ooo`030000003o
ool0oooo04@0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`140?ooo`030000003o
ool0oooo04@0oooo00<000000?ooo`3oool01@3oool009@0oooo00<000000?ooo`3oool0T`3oool0
09@0oooo00<000000?ooo`3oool0T`3oool00001\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {458.75, 312.188}} -> {-9.07237, \
4.53328, 0.0283373, 0.0214448}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["obl2=Table[Plot[y1[x],{x,-4,4}],{c,-5,-1}];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Show[%]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.829224 0.159738 [
[.02381 .01803 -6 -9 ]
[.02381 .01803 6 0 ]
[.2619 .01803 -6 -9 ]
[.2619 .01803 6 0 ]
[.7381 .01803 -3 -9 ]
[.7381 .01803 3 0 ]
[.97619 .01803 -3 -9 ]
[.97619 .01803 3 0 ]
[.4875 .1104 -24 -4.5 ]
[.4875 .1104 0 4.5 ]
[.4875 .19027 -12 -4.5 ]
[.4875 .19027 0 4.5 ]
[.4875 .27014 -24 -4.5 ]
[.4875 .27014 0 4.5 ]
[.4875 .35001 -12 -4.5 ]
[.4875 .35001 0 4.5 ]
[.4875 .42988 -24 -4.5 ]
[.4875 .42988 0 4.5 ]
[.4875 .50975 -12 -4.5 ]
[.4875 .50975 0 4.5 ]
[.4875 .58962 -24 -4.5 ]
[.4875 .58962 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .03053 m
.02381 .03678 L
s
[(-4)] .02381 .01803 0 1 Mshowa
.2619 .03053 m
.2619 .03678 L
s
[(-2)] .2619 .01803 0 1 Mshowa
.7381 .03053 m
.7381 .03678 L
s
[(2)] .7381 .01803 0 1 Mshowa
.97619 .03053 m
.97619 .03678 L
s
[(4)] .97619 .01803 0 1 Mshowa
.125 Mabswid
.08333 .03053 m
.08333 .03428 L
s
.14286 .03053 m
.14286 .03428 L
s
.20238 .03053 m
.20238 .03428 L
s
.32143 .03053 m
.32143 .03428 L
s
.38095 .03053 m
.38095 .03428 L
s
.44048 .03053 m
.44048 .03428 L
s
.55952 .03053 m
.55952 .03428 L
s
.61905 .03053 m
.61905 .03428 L
s
.67857 .03053 m
.67857 .03428 L
s
.79762 .03053 m
.79762 .03428 L
s
.85714 .03053 m
.85714 .03428 L
s
.91667 .03053 m
.91667 .03428 L
s
.25 Mabswid
0 .03053 m
1 .03053 L
s
.5 .1104 m
.50625 .1104 L
s
[(-4.5)] .4875 .1104 1 0 Mshowa
.5 .19027 m
.50625 .19027 L
s
[(-4)] .4875 .19027 1 0 Mshowa
.5 .27014 m
.50625 .27014 L
s
[(-3.5)] .4875 .27014 1 0 Mshowa
.5 .35001 m
.50625 .35001 L
s
[(-3)] .4875 .35001 1 0 Mshowa
.5 .42988 m
.50625 .42988 L
s
[(-2.5)] .4875 .42988 1 0 Mshowa
.5 .50975 m
.50625 .50975 L
s
[(-2)] .4875 .50975 1 0 Mshowa
.5 .58962 m
.50625 .58962 L
s
[(-1.5)] .4875 .58962 1 0 Mshowa
.125 Mabswid
.5 .04651 m
.50375 .04651 L
s
.5 .06248 m
.50375 .06248 L
s
.5 .07845 m
.50375 .07845 L
s
.5 .09443 m
.50375 .09443 L
s
.5 .12638 m
.50375 .12638 L
s
.5 .14235 m
.50375 .14235 L
s
.5 .15832 m
.50375 .15832 L
s
.5 .1743 m
.50375 .1743 L
s
.5 .20624 m
.50375 .20624 L
s
.5 .22222 m
.50375 .22222 L
s
.5 .23819 m
.50375 .23819 L
s
.5 .25417 m
.50375 .25417 L
s
.5 .28611 m
.50375 .28611 L
s
.5 .30209 m
.50375 .30209 L
s
.5 .31806 m
.50375 .31806 L
s
.5 .33404 m
.50375 .33404 L
s
.5 .36598 m
.50375 .36598 L
s
.5 .38196 m
.50375 .38196 L
s
.5 .39793 m
.50375 .39793 L
s
.5 .4139 m
.50375 .4139 L
s
.5 .44585 m
.50375 .44585 L
s
.5 .46183 m
.50375 .46183 L
s
.5 .4778 m
.50375 .4778 L
s
.5 .49377 m
.50375 .49377 L
s
.5 .52572 m
.50375 .52572 L
s
.5 .54169 m
.50375 .54169 L
s
.5 .55767 m
.50375 .55767 L
s
.5 .57364 m
.50375 .57364 L
s
.5 .01456 m
.50375 .01456 L
s
.5 .60559 m
.50375 .60559 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .05471 L
.10458 .09664 L
.14415 .13414 L
.18221 .16817 L
.22272 .20186 L
.26171 .2314 L
.30316 .2592 L
.34309 .28196 L
.3815 .29965 L
.40095 .30689 L
.42237 .31346 L
.44268 .31827 L
.45178 .31996 L
.46172 .32148 L
.4671 .32216 L
.4721 .3227 L
.47727 .32317 L
.48196 .32351 L
.48658 .32377 L
.4887 .32386 L
.49093 .32394 L
.49332 .32401 L
.49438 .32403 L
.49552 .32405 L
.49675 .32407 L
.49789 .32408 L
.49859 .32408 L
.49925 .32409 L
.50049 .32409 L
.50163 .32408 L
.50286 .32407 L
.50401 .32406 L
.50508 .32404 L
.50754 .32399 L
.51014 .3239 L
.51268 .3238 L
.51504 .32368 L
.5204 .32335 L
.5293 .32256 L
.53882 .32141 L
.54906 .31982 L
.56016 .31768 L
.58032 .31272 L
.62123 .29854 L
.66064 .28002 L
.69852 .25815 L
.73886 .23099 L
.77769 .20153 L
.81897 .16715 L
Mistroke
.85873 .13148 L
.89697 .09514 L
.93767 .0546 L
.97619 .01472 L
Mfstroke
.02381 .04667 m
.06244 .08839 L
.10458 .13234 L
.14415 .17187 L
.18221 .20797 L
.22272 .24394 L
.26171 .27572 L
.30316 .30588 L
.34309 .33076 L
.3815 .35025 L
.40095 .35827 L
.42237 .36556 L
.44268 .37092 L
.45178 .37281 L
.46172 .3745 L
.4671 .37526 L
.4721 .37587 L
.47727 .37639 L
.48196 .37677 L
.48658 .37706 L
.4887 .37716 L
.49093 .37725 L
.49332 .37733 L
.49438 .37735 L
.49552 .37738 L
.49675 .37739 L
.49789 .37741 L
.49859 .37741 L
.49925 .37741 L
.50049 .37742 L
.50163 .37741 L
.50286 .3774 L
.50401 .37738 L
.50508 .37736 L
.50754 .3773 L
.51014 .37721 L
.51268 .3771 L
.51504 .37697 L
.5204 .37659 L
.5293 .37571 L
.53882 .37442 L
.54906 .37265 L
.56016 .37026 L
.58032 .36474 L
.62123 .34902 L
.66064 .32863 L
.69852 .30473 L
.73886 .27528 L
.77769 .24359 L
.81897 .20689 L
Mistroke
.85873 .16906 L
.89697 .13076 L
.93767 .08827 L
.97619 .04667 L
Mfstroke
.02381 .07998 m
.06244 .12368 L
.10458 .16998 L
.14415 .2119 L
.18221 .2505 L
.22272 .28929 L
.26171 .32392 L
.30316 .35714 L
.34309 .38489 L
.3815 .40687 L
.40095 .41599 L
.42237 .42432 L
.44268 .43046 L
.45178 .43263 L
.46172 .43459 L
.4671 .43546 L
.4721 .43616 L
.47727 .43676 L
.48196 .4372 L
.48658 .43753 L
.4887 .43765 L
.49093 .43776 L
.49332 .43784 L
.49438 .43787 L
.49552 .4379 L
.49675 .43792 L
.49789 .43794 L
.49859 .43794 L
.49925 .43795 L
.50049 .43795 L
.50163 .43794 L
.50286 .43793 L
.50401 .43791 L
.50508 .43789 L
.50754 .43782 L
.51014 .43771 L
.51268 .43758 L
.51504 .43743 L
.5204 .43699 L
.5293 .43598 L
.53882 .43449 L
.54906 .43245 L
.56016 .42971 L
.58032 .42338 L
.62123 .40548 L
.66064 .38251 L
.69852 .35588 L
.73886 .32343 L
.77769 .28892 L
.81897 .24933 L
Mistroke
.85873 .20891 L
.89697 .1683 L
.93767 .12355 L
.97619 .07998 L
Mfstroke
.02381 .11485 m
.06244 .16082 L
.10458 .20989 L
.14415 .25472 L
.18221 .29641 L
.22272 .33882 L
.26171 .37723 L
.30316 .4147 L
.34309 .44661 L
.3815 .47237 L
.40095 .4832 L
.42237 .49319 L
.44268 .50062 L
.45178 .50326 L
.46172 .50564 L
.4671 .50671 L
.4721 .50756 L
.47727 .50829 L
.48196 .50883 L
.48658 .50924 L
.4887 .50939 L
.49093 .50952 L
.49332 .50962 L
.49438 .50966 L
.49552 .50969 L
.49675 .50972 L
.49789 .50973 L
.49859 .50974 L
.49925 .50975 L
.50049 .50975 L
.50163 .50974 L
.50286 .50972 L
.50401 .5097 L
.50508 .50967 L
.50754 .50959 L
.51014 .50946 L
.51268 .50929 L
.51504 .50911 L
.5204 .50858 L
.5293 .50734 L
.53882 .50553 L
.54906 .50304 L
.56016 .49971 L
.58032 .49206 L
.62123 .47072 L
.66064 .44384 L
.69852 .41326 L
.73886 .37669 L
.77769 .33841 L
.81897 .29515 L
Mistroke
.85873 .25151 L
.89697 .20811 L
.93767 .16068 L
.97619 .11485 L
Mfstroke
.02381 .15151 m
.06244 .20015 L
.10458 .25256 L
.14415 .301 L
.18221 .34667 L
.22272 .39395 L
.26171 .43773 L
.30316 .48167 L
.34309 .52041 L
.3815 .55297 L
.40095 .56712 L
.42237 .58046 L
.44268 .59059 L
.46172 .59755 L
.46668 .59894 L
.4721 .60024 L
.47687 .6012 L
.48196 .60203 L
.48456 .60237 L
.487 .60265 L
.48938 .60287 L
.49157 .60304 L
.49365 .60316 L
.49472 .60321 L
.49585 .60325 L
.497 .60328 L
.49806 .6033 L
.49933 .60332 L
.50049 .60332 L
.50167 .60331 L
.50277 .60329 L
.50399 .60326 L
.5053 .60321 L
.50659 .60315 L
.50796 .60307 L
.5104 .60289 L
.51478 .60245 L
.51957 .6018 L
.52477 .60089 L
.53033 .59968 L
.54033 .59693 L
.56168 .58864 L
.58183 .57805 L
.6203 .55158 L
.66122 .51645 L
.70062 .4778 L
.73851 .4375 L
.77885 .39216 L
.81767 .34681 L
.85895 .29724 L
Mistroke
.89871 .2485 L
.93695 .2009 L
.97619 .15151 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`00303oool0103Z^W8000000000LP2jj_lo0?ooo`060?oDV`00000000000000000009/0e?oo
PP3oool01P3oe9/00000000000000000002K0=Cood40oooo00@0j[Yb000000000780^^[o203oool0
00d0oooo00<0omBK07:jjP3oool0@03oool00`2jLP00002K0=Coo`250?ooo`030;Yb000009/0e?oo
04@0oooo00<0omBK07:jjP3oool0203oool000X0oooo00H0oooD09/00000000000000000LP2jj_m1
0?ooo`030?oDV`000000VmCo08D0oooo00<0omBK0000002Ke?l0@03oool01P3oom@0V`0000000000
0000001b0;[Zo`P0oooo00040?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3DV`00VmCo
0?oDV`1b^^Xj0?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3oool0oooo0?ooe03De?m0
0?ooo`030000003oool0oooo04<0oooo00<0oooD0=CDo`3oool0@03oool0103DV`00VmCo0?oDV`1b
^^X90?ooo`002`3oool0103oom@0V`1b0;ZjV`1b^^Y00?ooo`060?oZ^P1bL[X0oooo0?ooe02K09/0
e?oo?`3oool00`000000oooo0?ooo`100?ooo`060?oZ^P1bL[X0oooo0?ooe02K09/0e?oo@03oool0
103oom@0V`1b0;ZjV`1b^^X90?ooo`00303oool00`3oj[X0LP0007:jjP110?ooo`040>ZjLP000000
000007:jjT00oooo00<000000?ooo`3oool0@@3oool0103Z^W8000000000001b^^Y20?ooo`030?oZ
^P1b0000L[[Z00T0oooo002D0?ooo`030000003oool0oooo09<0oooo000:0?ooo`030000003oool0
oooo08L0oooo0P0000290?ooo`030000003oool0oooo00P0oooo000;0?ooo`030000003oool0oooo
08H0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo0?ooo`090?ooo`00303oool00`000000
oooo0?ooo`250?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3oool02P3oool000d0oooo
00<000000?ooo`3oool0Q03oool00`000000oooo0?ooo`250?ooo`030000003oool0oooo00/0oooo
000>0?ooo`030000003oool0oooo08<0oooo00<000000?ooo`3oool0Q03oool00`000000oooo0?oo
o`0<0?ooo`000`3ooooo000002D000000`3oool000X0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0203oool00100
oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`220?ooo`030000003oool0oooo00h0
oooo000A0?ooo`030000003oool0oooo0800oooo00<000000?ooo`3oool0P@3oool00`000000oooo
0?ooo`0?0?ooo`002P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo07l0oooo0P00
00210?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool000/0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo07l0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`090?ooo`00303oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo07d0oooo00<000000?ooo`3oool0OP3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00X0oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0O03oool00`000000oooo0?ooo`1m0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool02`3oool000h0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1k0?ooo`030000
003oool0oooo07`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`003`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo07X0oooo0P00001l0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool03@3oool000l0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`1i0?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0>0?ooo`00403oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
07P0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00h0oooo000A0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0M`3oool00`000000
oooo0?ooo`1h0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03`3oool00180oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1f0?ooo`030000003oool0oooo07H0oooo
0P0000080?ooo`030000003oool0oooo0100oooo000:0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`1e0?ooo`800000MP3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool000/0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo07@0oooo00<00000
0?ooo`3oool0M03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool02@3oool000`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo07<0oooo00<000000?ooo`3oool0L`3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool02P3oool000d0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0780oooo00<000000?ooo`3o
ool0LP3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool02`3oool000d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo0740oooo0P00001b0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0;0?ooo`003P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`1`0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`003`3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0K`3oool0
0`000000oooo0?ooo`1_0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`0=0?ooo`00403oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0F`3oool0203Z^W8000000000LP2jj_l0oooo0?ooe02K000007:j
0`3oool0103Z^W8000000000001b^^X40?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00h0oooo000A0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1K0?ooo`030?oD
V`1b^^X0oooo00H0oooo00H0onZj079b^P3oool0oooo0;YbLP2jj_l30?ooo`030000003oool0oooo
06d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00l0oooo000B0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`1G0?ooo`060?ooe02K00000000000000000780^^[o2P3oool00`3DVg80^^[o0?ooo`02
0?ooo`<00000K03oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0403oool000X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0D03oool00`3oe9/00000000000020000
000609_Do`3oool0e9/009_Do`3oe9/0L[[Z203oool0103DV`00000000000000Vm@40?ooo`030000
003oool0oooo06/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0203oool000/0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo0P00001G0?ooo`040?ooe02K
0780^[ZK07:jjPP0oooo00<0e9]b0;[Zo`3oool01@3oool00`000000oooo0?ooo`1Z0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00T0oooo000<0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo05D0oooo00<0onZj0780001b^^X0203o
ool0103DV`00000000000000Vm@40?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
2P3oool000`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`1X0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00/0oooo000=0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo06H0oooo0P00001X0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00/0oooo000>0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo06D0oooo00<000000?ooo`3oool0IP3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0<0?ooo`003`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1T0?ooo`030000003oool0oooo06D0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool03@3oool000l0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0H`3oool00`000000oooo
0?ooo`1T0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00h0oooo000@0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0680oooo0P00
001S0?ooo`8000002P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool03`3oool00140oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`1Q
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo0100oooo000B0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0600oooo00<000000?oo
o`3oool0H03oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0@0?ooo`002P3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`80
0000H03oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0203oool000/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1M0?ooo`030000
003oool0oooo05h0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`00303o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo05`0oooo0P00001M0?ooo`8000002`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0:0?ooo`00303oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo05/0oooo00<000000?ooo`3oool0F`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00/0oooo000=0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0FP3oool00`00
0000oooo0?ooo`1J0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02`3oool000h0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo05T0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`003`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo05P0oooo0P00001I0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool03@3oool000l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool2000005P0oooo00<0
00000?ooo`3oool0EP3oool2000000`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03P3oool00100oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0?0?ooo`004@3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo04d0oooo00@0j[Yb000000000780^^[o0`3oool00`000000oooo0?ooo`1D
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0403oool00180oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool02P3oool2000004h0oooo00<0omBK07:jjP3oool00`3oool00`000000oooo0?ooo`1C0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo0P00000<0?ooo`03
0000003oool0oooo04P0oooo00H0oooD09/00000000000000000LP2jj_l30?ooo`<00000DP3oool0
0`000000oooo0?ooo`0:0?ooo`8000002P3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`110?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3DV`00VmCo0?oDV`1b
^^X40?ooo`030000003oool0oooo0500oooo0P00000<0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0180oooo000D
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00X0oooo0P0000180?ooo`040?ooe02K0780^[ZK07:jjP@0oooo00<0
00000?ooo`3oool0C`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01<0oooo000E
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0AP3oool00`3oj[X0LP0007:jjP04
0?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0D
0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo04`0oooo00<000000?oo
o`3oool0C@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01D0oooo000G0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00/0oooo0P00001<0?ooo`800000C03oool2000000d0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool05P3oool001L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`190?ooo`030000
003oool0oooo04X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`00603o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0B@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01L0oooo000I0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`180?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0603oool001X0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`160?ooo`800000B03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
01T0oooo000K0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo0P0000160?ooo`030000003oool0oooo04D0
oooo0P00000>0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo01X0oooo000K0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`8000003P3oool00`000000oooo
0?ooo`130?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0303oool2000000`0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01X0oooo
000L0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?oo
o`130?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool2000000X0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0K0?ooo`007@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`800000@P3oool00`000000oooo0?ooo`110?ooo`8000003P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0L
0?ooo`007P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03l0oooo0P0000110?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool07@3oool001l0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool03@3oool2000003l0oooo00<000000?ooo`3oool0?P3oool2000000l0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool07@3oool001l0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0l0?ooo`030000
003oool0oooo03d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0N0?ooo`00803o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0>0?ooo`800000?03oool00`000000oooo0?ooo`0k0?ooo`800000403o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0O0?ooo`008@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02`3oool200000100oooo00<000000?ooo`3oool0>@3oool0
0`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00h0oooo0P00000<0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0P0?ooo`008P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0>0?ooo`800000>@3oool2000003T0oooo0P00000@0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
0240oooo000S0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0=P3oool00`000000
oooo0?ooo`0g0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool08@3oool002@0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool03`3oool200000280oooo00@0j[Yb00000000000009_D0P3oool00`3oom@0
V`00001b^P030?ooo`040>ZjLP000000000007:jjP@0oooo00<000000?ooo`3oool0=@3oool20000
0140oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool08P3oool002@0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0403oool2000001l0
oooo00H0onZj079b^P3oool0oooD09/0LP2jj_l60?ooo`060?oZ^P1bL[X0oooo0?ooo`2jLW80^^[o
0`3oool00`000000oooo0?ooo`0c0?ooo`8000004P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0S0?ooo`009@3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0303o
ool200000180oooo00<000000?ooo`3oool07P3oool00`3DV`00000009_Do`0;0?ooo`030=BKLP2j
j_l0oooo0080oooo0`00000a0?ooo`8000004P3oool2000000d0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02@0oooo000V0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02@3oool2000000h0oooo00<000000?ooo`3oool0403oool2
000001H0oooo00<0omBK0000000000000P0000001P2Ke?l0oooo0?ooo`3oool0oooD09]b^PP0oooo
00@0e9/000000000000009_D103oool00`000000oooo0?ooo`0_0?ooo`8000004`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0U0?ooo`009`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0A0?ooo`8000006P3oool01P3oom@0V`1b
0;[Zo`3oom@0V`2K0=Coo`L0oooo00<0e9]b0;[Zo`3oool01@3oool00`000000oooo0?ooo`0]0?oo
o`800000503oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0U0?ooo`00:03oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0B0?ooo`80
00006@3oool0103oj[X0LP000000002Ke?l80?ooo`040=BK000000000000002Ke0@0oooo00<00000
0?ooo`3oool0;03oool00`000000oooo0?ooo`0B0?ooo`8000003P3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool09P3oool002T0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo0P00000D0?oo
o`800000:`3oool00`000000oooo0?ooo`0Z0?ooo`800000503oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0W0?oo
o`00:P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0C0?ooo`800000:@3oool2000002T0oooo0P00000D0?ooo`80
00003`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0:03oool002X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0503oool2000002L0oooo00<000000?ooo`3oool0
9P3oool2000001D0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0:03oool002/0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo0P00000F0?ooo`8000009@3o
ool00`000000oooo0?ooo`0T0?ooo`8000005@3oool200000100oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02T0oooo000/0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo01D0oooo0P00000S0?ooo`030000003oool0oooo0280oooo0P00000F0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo02X0oooo000]0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo01H0oooo0`00000P0?ooo`030000003oool0oooo
0200oooo0P00000F0?ooo`8000004@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0:`3oool002h0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00h0oooo0P00000I0?ooo`<000007@3oool2000001h0
oooo0`00000G0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo02`0oooo000_0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool02`3oool200000100oooo00<000000?ooo`3oool06@3oool3000001X0oooo
00<000000?ooo`3oool06P3oool3000001P0oooo0P00000A0?ooo`8000003@3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo02`0oooo000_0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`800000703oool3000001L0oooo00<0
00000?ooo`3oool05`3oool3000001X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0;@3oool00300oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo0P00000M
0?ooo`@000004`3oool00`000000oooo0?ooo`0C0?ooo`@000006`3oool200000180oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02h0oooo000a0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo01h0oooo1000000?0?ooo`8000003`3oool5000001d0oooo0P00000C0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0_0?oo
o`00<P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool0403oool200000280oooo1`0000080?ooo`030000003oool0oooo00P0oooo1P00000Q0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo0300oooo000b0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0A0?ooo`8000009`3ooolC000002D0oooo0P00000D0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0`0?ooo`00<`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04P3o
ool2000002d0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0a0?ooo`00=03oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo02X0oooo0P00000D0?ooo`8000003P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0380oooo000e0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool2000001@0oooo0P00000Z0?ooo`800000:@3oool20000
01D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
03<0oooo000f0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0C0?ooo`800000:03oool00`000000oooo0?ooo`0V0?ooo`8000005P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0=03oool003H0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01@0oooo
0P00000V0?ooo`030000003oool0oooo02@0oooo0P00000F0?ooo`8000003`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo03@0oooo000g0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0E0?ooo`800000703oool0103Z^W8000000000
0000Vm@40?ooo`030000003oool0oooo0280oooo0P00000G0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0e0?ooo`00>03oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool05P3oool2000001T0oooo00H0
onZj079b^P3oool0oooD09/0LP2jj_l30?ooo`030000003oool0oooo0200oooo0P00000H0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0f0?ooo`00
>@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo0P00000H0?ooo`800000
6@3oool00`3DV`00000009_Do`040?ooo`<000007P3oool2000001P0oooo0P00000@0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0=`3oool003X0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01L0oooo0`00000>0?ooo`030?oDV`00
000000000080000000H0VmCo0?ooo`3oool0oooo0?ooe02KL[X40?ooo`030000003oool0oooo01`0
oooo0P00000I0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0h0?ooo`00>`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool06@3oool300000140oooo00H0oooD09/0LP2jj_l0oooD09/0V`3Dool30?oo
o`030000003oool0oooo01T0oooo0`00000I0?ooo`8000004@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo03T0oooo000l0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool03P3oool2000001`0oooo0`00000?0?ooo`040?oZ^P1b0000000009_Do`@0oooo00<000000?oo
o`3oool05`3oool2000001/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo03X0oooo000m0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`0L0?ooo`<00000503oool2000001@0oooo1000000L0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0k0?ooo`00
?P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo0P00000O0?ooo`<00000
4@3oool00`000000oooo0?ooo`0>0?ooo`D000007P3oool200000180oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0l0?ooo`00?P3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool07`3oool5000000`0oooo00<000000?ooo`3oool02`3o
ool300000280oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo03`0oooo000o0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0403oool2
000002@0oooo2`000000103oool000000?ooo`3oool;000002@0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03d0oooo00100?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0/0?ooo`@00000;@3oool2
000001<0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0n0?ooo`00@@3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo0140oooo0P00000]0?ooo`800000;@3oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0?`3oool00480
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo02X0
oooo00<000000?ooo`3oool0:P3oool2000001@0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`100?ooo`00@`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0180oooo
0P00000Z0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo0440oooo00140?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool04`3oool2000002P0oooo00<000000?ooo`3oool09`3oool2000001D0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`120?ooo`00A@3oool00`000000oooo0?ooo`0=
0?ooo`8000005@3oool2000002H0oooo0P00000V0?ooo`8000005@3oool2000000l0oooo00<00000
0?ooo`3oool0@`3oool004H0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0D0?oo
o`800000903oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo01@0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`140?ooo`00A`3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo01D0oooo0P00000R0?ooo`030000003oool0oooo0280oooo0P00000F0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool0A@3oool004L0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0
803oool2000001L0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`150?ooo`00B03o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01H0oooo0P00000O0?ooo`030000003o
ool0oooo01h0oooo0P00000H0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0AP3o
ool004T0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0G0?ooo`8000007@3oool2
000001d0oooo0P00000I0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0A`3oool0
04X0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0H0?ooo`<000006P3oool00`00
0000oooo0?ooo`0I0?ooo`<000006P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
04P0oooo001;0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool06P3oool3000001L0
oooo00<000000?ooo`3oool05`3oool2000001/0oooo0P00000A0?ooo`030000003oool0oooo04T0
oooo001<0?ooo`030000003oool0oooo00l0oooo0P00000M0?ooo`H0000000H0002K0=Coo`3oool0
oooD09/00000L[X30?ooo`040>ZjLP000000000007:jjP@0oooo00<000000?ooo`3oool0503oool3
000001`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1:0?ooo`00C03oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo01d0oooo0`0000080?ooo`060?oZ^P1bL[X0oooo
0?ooo`2jLW80^^[o0`3oool00`000000oooo0?ooo`0A0?ooo`<000007P3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo04X0oooo001=0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool07@3oool0103oe9/0000000000000000:0?ooo`030=BKLP2jj_l0oooo0080oooo0`00
000>0?ooo`<00000803oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo04/0oooo001>
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0503oool00`3oe9/0000000000002
0000000709_Do`3oool0oooo0?ooo`3oom@0e=Co0?ooo`07000000040=BK000000000000002Ke0@0
oooo00<000000?ooo`3oool0203oool600000280oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`1<0?ooo`00C`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01T0oooo
00H0onZj079b^P3oool0oooD09/0V`3Dool70?oooa<000009P3oool2000001<0oooo00<000000?oo
o`3oool0C@3oool00500oooo00<000000?ooo`3oool04@3oool2000001X0oooo00@0j[Yb00000000
0000L[[Z203oool0103DV`00000000000000Vm@40?ooo`030000003oool0oooo02d0oooo00<00000
0?ooo`3oool04P3oool00`000000oooo0?ooo`1>0?ooo`00D@3oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo02/0oooo0P00000]0?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool0C`3oool00580oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0Z0?ooo`03
0000003oool0oooo02X0oooo0P00000D0?ooo`030000003oool0oooo0500oooo001C0?ooo`030000
003oool0oooo0180oooo0P00000Z0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`1A0?ooo`00E03oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo02L0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo0580oooo001E0?ooo`030000003oool0oooo01<0oooo0P00000W0?ooo`030000003oool0
oooo02H0oooo0P00000E0?ooo`030000003oool0oooo05<0oooo001E0?ooo`030000003oool0oooo
01D0oooo0P00000U0?ooo`8000009P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
05<0oooo001F0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool08P3oool00`000000
oooo0?ooo`0T0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0E03oool005L0oooo
00<000000?ooo`3oool05P3oool200000280oooo00<000000?ooo`3oool08P3oool2000001L0oooo
00<000000?ooo`3oool0E@3oool005P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0O0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`1F0?ooo`00F@3oool00`000000oooo0?ooo`0G0?ooo`8000007`3oool00`000000oooo0?ooo`0O
0?ooo`800000603oool00`000000oooo0?ooo`1G0?ooo`00FP3oool00`000000oooo0?ooo`0H0?oo
o`8000007@3oool2000001h0oooo0P00000I0?ooo`030000003oool0oooo05P0oooo001K0?ooo`03
0000003oool0oooo01T0oooo0P00000K0?ooo`030000003oool0oooo01/0oooo0P00000J0?ooo`03
0000003oool0oooo05T0oooo001L0?ooo`030000003oool0oooo01X0oooo0P00000I0?ooo`030000
003oool0oooo01T0oooo0P00000K0?ooo`030000003oool0oooo05X0oooo001M0?ooo`030000003o
ool0oooo01/0oooo0P00000G0?ooo`030000003oool0oooo01L0oooo0P00000L0?ooo`030000003o
ool0oooo05/0oooo001N0?ooo`030000003oool0oooo01`0oooo0`00000D0?ooo`8000005@3oool3
000001d0oooo00<000000?ooo`3oool0G03oool005l0oooo00<000000?ooo`3oool07P3oool30000
0140oooo00<000000?ooo`3oool04@3oool3000001l0oooo00<000000?ooo`3oool0G@3oool00600
oooo00<000000?ooo`3oool0803oool2000000l0oooo00<000000?ooo`3oool03P3oool300000200
oooo0P00001P0?ooo`00H@3oool200000280oooo0`0000030?ooo`060?oDV`000000000000000000
09/0e?oo0`3oool00`000000oooo0?ooo`0;0?ooo`<000008P3oool00`000000oooo0?ooo`1P0?oo
o`00H`3oool00`000000oooo0?ooo`0R0?ooo`D0000000<0002K0=Coo`3oool0103oool00`000000
oooo0?ooo`050?ooo`H00000903oool00`000000oooo0?ooo`1Q0?ooo`00I03oool00`000000oooo
0?ooo`0V0?ooo`l00000:@3oool00`000000oooo0?ooo`1R0?ooo`00I@3oool00`000000oooo0?oo
o`0M0?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3oool0oooo0?ooe03De?l40?ooo`03
0000003oool0oooo02d0oooo00<000000?ooo`3oool0H`3oool006H0oooo00<000000?ooo`3oool0
8P3oool01P3oj[X0LW:j0?ooo`3oom@0V`2K0=Coo`<0oooo00<000000?ooo`3oool0;03oool00`00
0000oooo0?ooo`1T0?ooo`00I`3oool00`000000oooo0?ooo`0R0?ooo`040>ZjLP000000000007:j
jP@0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`1U0?ooo`00J03oool00`000000
oooo0?ooo`0Y0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0IP3oool006T0oooo
00<000000?ooo`3oool0:03oool2000002T0oooo0P00001Y0?ooo`00JP3oool00`000000oooo0?oo
o`0W0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0J@3oool006/0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo06X0oooo001/0?oo
o`8000009P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo06/0oooo001^0?ooo`03
0000003oool0oooo02<0oooo0P00000U0?ooo`030000003oool0oooo06`0oooo001_0?ooo`030000
003oool0oooo0280oooo00<000000?ooo`3oool08P3oool2000006l0oooo001`0?ooo`030000003o
ool0oooo0240oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`1_0?ooo`00L@3oool0
0`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0L03oool0
0780oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0N0?ooo`800000L`3oool007<0
oooo0P00000O0?ooo`8000007P3oool00`000000oooo0?ooo`1c0?ooo`00M@3oool00`000000oooo
0?ooo`0L0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0M03oool007H0oooo0P00
000L0?ooo`030000003oool0oooo01X0oooo0P00001g0?ooo`00N03oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0M`3oool007T0oooo0P00000I0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool0N03oool007/0oooo00<000000?ooo`3o
ool05P3oool2000001L0oooo0P00001k0?ooo`00O03oool2000001H0oooo00<000000?ooo`3oool0
5@3oool00`000000oooo0?ooo`1k0?ooo`00OP3oool00`000000oooD09/00002000000060000LP2j
j_l0oooo0?ooe02K000007:j0`3oool0103Z^W8000000000001b^^X40?ooo`030000003oool0oooo
01<0oooo0P00001n0?ooo`00O`3oool2000000030?oDV`1b^^X0oooo00L0oooo00H0onZj079b^P3o
ool0oooo0;YbLP2jj_l30?ooo`030000003oool0oooo0140oooo0P0000200?ooo`00P@3oool20000
00`0oooo00<0e9]b0;[Zo`3oool00P3oool3000000h0oooo0`0000220?ooo`00N@3oool00`3oe9/0
0000000000020000000509_Do`3oool0oooo0?oDV`1b^^X00`0000060?ooo`040=BK000000000000
002Ke0@0oooo00<000000?ooo`3oool02`3oool3000008D0oooo00200?ooo`030;YbV`3De9/0L[[Z
00<0oooo0P0000040?ooo`030=BKLP2jj_l0oooo00D0oooo00<000000?ooo`3oool0203oool30000
08P0oooo00200?ooo`030?oDV`000000L[[Z00D0oooo1`0000000`00Vm@0oooo0?ooo`020?ooo`03
0000003oool0oooo00H0oooo0P00002;0?ooo`00S@3oool@000008d0oooo002D0?ooo`800000U03o
ool009@0oooo00<000000?ooo`3oool0T`3oool009@0oooo00<000000?ooo`3oool0T`3oool009@0
oooo00<000000?ooo`3oool0T`3oool00001\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {678.688, 532.125}} -> {-9.26274, \
9.06982, 0.0289319, 0.0215621}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["obl3=Table[Plot[y2[x],{x,-4,4}],{c,1,5}];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Show[%]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.0147151 0.157311 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.7381 .00222 -3 -9 ]
[.7381 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.4875 .09337 -18 -4.5 ]
[.4875 .09337 0 4.5 ]
[.4875 .17203 -6 -4.5 ]
[.4875 .17203 0 4.5 ]
[.4875 .25068 -18 -4.5 ]
[.4875 .25068 0 4.5 ]
[.4875 .32934 -6 -4.5 ]
[.4875 .32934 0 4.5 ]
[.4875 .40799 -18 -4.5 ]
[.4875 .40799 0 4.5 ]
[.4875 .48665 -6 -4.5 ]
[.4875 .48665 0 4.5 ]
[.4875 .5653 -18 -4.5 ]
[.4875 .5653 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-4)] .02381 .00222 0 1 Mshowa
.2619 .01472 m
.2619 .02097 L
s
[(-2)] .2619 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(2)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(4)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.08333 .01472 m
.08333 .01847 L
s
.14286 .01472 m
.14286 .01847 L
s
.20238 .01472 m
.20238 .01847 L
s
.32143 .01472 m
.32143 .01847 L
s
.38095 .01472 m
.38095 .01847 L
s
.44048 .01472 m
.44048 .01847 L
s
.55952 .01472 m
.55952 .01847 L
s
.61905 .01472 m
.61905 .01847 L
s
.67857 .01472 m
.67857 .01847 L
s
.79762 .01472 m
.79762 .01847 L
s
.85714 .01472 m
.85714 .01847 L
s
.91667 .01472 m
.91667 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .09337 m
.50625 .09337 L
s
[(0.5)] .4875 .09337 1 0 Mshowa
.5 .17203 m
.50625 .17203 L
s
[(1)] .4875 .17203 1 0 Mshowa
.5 .25068 m
.50625 .25068 L
s
[(1.5)] .4875 .25068 1 0 Mshowa
.5 .32934 m
.50625 .32934 L
s
[(2)] .4875 .32934 1 0 Mshowa
.5 .40799 m
.50625 .40799 L
s
[(2.5)] .4875 .40799 1 0 Mshowa
.5 .48665 m
.50625 .48665 L
s
[(3)] .4875 .48665 1 0 Mshowa
.5 .5653 m
.50625 .5653 L
s
[(3.5)] .4875 .5653 1 0 Mshowa
.125 Mabswid
.5 .03045 m
.50375 .03045 L
s
.5 .04618 m
.50375 .04618 L
s
.5 .06191 m
.50375 .06191 L
s
.5 .07764 m
.50375 .07764 L
s
.5 .1091 m
.50375 .1091 L
s
.5 .12483 m
.50375 .12483 L
s
.5 .14056 m
.50375 .14056 L
s
.5 .15629 m
.50375 .15629 L
s
.5 .18776 m
.50375 .18776 L
s
.5 .20349 m
.50375 .20349 L
s
.5 .21922 m
.50375 .21922 L
s
.5 .23495 m
.50375 .23495 L
s
.5 .26641 m
.50375 .26641 L
s
.5 .28214 m
.50375 .28214 L
s
.5 .29787 m
.50375 .29787 L
s
.5 .31361 m
.50375 .31361 L
s
.5 .34507 m
.50375 .34507 L
s
.5 .3608 m
.50375 .3608 L
s
.5 .37653 m
.50375 .37653 L
s
.5 .39226 m
.50375 .39226 L
s
.5 .42372 m
.50375 .42372 L
s
.5 .43945 m
.50375 .43945 L
s
.5 .45519 m
.50375 .45519 L
s
.5 .47092 m
.50375 .47092 L
s
.5 .50238 m
.50375 .50238 L
s
.5 .51811 m
.50375 .51811 L
s
.5 .53384 m
.50375 .53384 L
s
.5 .54957 m
.50375 .54957 L
s
.5 .58103 m
.50375 .58103 L
s
.5 .59677 m
.50375 .59677 L
s
.5 .6125 m
.50375 .6125 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .54839 L
.10458 .4875 L
.14415 .42898 L
.18221 .37088 L
.22272 .30585 L
.26171 .23755 L
.28326 .19509 L
.30316 .14949 L
.31304 .12214 L
.3223 .08984 L
.32481 .07874 L
.3271 .06672 L
.32832 .05912 L
.32965 .04903 L
.33038 .04201 L
.33105 .0333 L
s
.66843 .02135 m
.66859 .02635 L
.66928 .03798 L
.66992 .04506 L
.67137 .05698 L
.67378 .07163 L
.67597 .08238 L
.68089 .10214 L
.70244 .16326 L
.74229 .24495 L
.78227 .3141 L
.82073 .37545 L
.86165 .43767 L
.90106 .49572 L
.93894 .55038 L
.97619 .60332 L
s
.02381 .55966 m
.06244 .49981 L
.10458 .43189 L
.14415 .36417 L
.18221 .29285 L
.20342 .24839 L
.22272 .20251 L
.23233 .17633 L
.24276 .14339 L
.24754 .12563 L
.25261 .10346 L
.25694 .07929 L
.25813 .07098 L
.2594 .06044 L
.26061 .0476 L
.26171 .02745 L
s
.73849 .03286 m
.73955 .04959 L
.74072 .06156 L
.74197 .07167 L
.74683 .1007 L
.75552 .13725 L
.7751 .19681 L
.8153 .28786 L
.8568 .36587 L
.89678 .43414 L
.93525 .49617 L
.97617 .55962 L
.97619 .55966 L
s
.02381 .51218 m
.06244 .44579 L
.10458 .36762 L
.14415 .28421 L
.16408 .23508 L
.18221 .18164 L
.19227 .14462 L
.19689 .12403 L
.20178 .09725 L
.20426 .0798 L
.20568 .06744 L
.20636 .06036 L
.207 .05244 L
.20821 .02831 L
s
.79167 .0231 m
.79183 .02969 L
.79254 .04564 L
.79322 .05532 L
.79457 .06979 L
.79603 .08211 L
.80106 .11361 L
.81095 .15738 L
.82007 .18908 L
.85782 .28874 L
.89722 .37114 L
.93511 .44145 L
.97545 .51094 L
.97619 .51218 L
s
.02381 .45966 m
.06244 .38395 L
.10458 .28866 L
.1253 .23193 L
.14415 .16682 L
.15367 .12178 L
.15639 .10518 L
.15891 .08669 L
.16003 .07666 L
.16128 .06334 L
.16253 .04451 L
.16321 .02378 L
s
.83683 .02622 m
.83802 .05396 L
.83871 .06324 L
.83937 .07063 L
.84058 .08234 L
.84332 .10325 L
.84824 .13213 L
.85942 .18084 L
.87826 .24246 L
.89869 .29681 L
.93961 .38818 L
.97619 .45966 L
s
.02381 .40005 m
.06244 .3094 L
.08426 .24782 L
.09408 .21534 L
.10458 .17457 L
.10966 .15102 L
.11447 .12457 L
.11878 .09404 L
.11996 .08342 L
.12122 .07004 L
.12229 .0553 L
.12347 .02449 L
s
.87666 .03103 m
.87779 .05662 L
.87904 .07299 L
.8804 .08687 L
.88316 .10898 L
.88811 .13941 L
.89929 .19055 L
.91976 .26006 L
.93891 .3129 L
.97619 .40005 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`003`3oool0103Z^W8000000000LP2jj_ln0?ooo`060?oDV`00000000000000000009/0e?oo
OP3oool01P3oe9/00000000000000000002K0=Coocl0oooo00@0j[Yb000000000780^^[o303oool0
0100oooo00<0omBK07:jjP3oool0?`3oool00`2jLP00002K0=Coo`210?ooo`030;Yb000009/0e?oo
0480oooo00<0omBK07:jjP3oool0303oool000d0oooo00H0oooD09/00000000000000000LP2jj_m0
0?ooo`030?oDV`000000VmCo0840oooo00<0omBK0000002Ke?l0?P3oool01P3oom@0V`0000000000
0000001b0;[Zo``0oooo00070?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3DV`00VmCo
0?oDV`1b^^Xi0?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3oool0oooo0?ooe03De?n2
0?ooo`030?ooe03De?l0oooo03h0oooo00@0e9/009_Do`3oe9/0L[[Z3@3oool000h0oooo00@0oooD
09/0LP2j^Y/0L[[Z?`3oool01P3oj[X0LW:j0?ooo`3oom@0V`2K0=Coogh0oooo00H0onZj079b^P3o
ool0oooD09/0V`3Dooln0?ooo`040?ooe02K0780^[ZK07:jjPd0oooo000?0?ooo`030?oZ^P1b0000
L[[Z0400oooo00@0j[Yb000000000000L[[ZP03oool0103Z^W8000000000001b^^Y00?ooo`030?oZ
^P1b0000L[[Z00d0oooo003o0?ooob/0oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?oo
o`030000003oool0oooo09<0oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?ooo`030000
003oool0oooo09<0oooo002D0?ooo`030000003oool0oooo09<0oooo00070?ooool000007@000007
0?ooo`003@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00/0oooo00@000000?oo
o`3oool00000403oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00`0oooo000Z0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo0200oooo00<000000?ooo`3oool0@03oool002X0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool0@03oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0c0?ooo`00:P3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`100?ooo`800000
;P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0X0?ooo`00:P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo02d0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo02P0oooo000Z0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0;@3oool0
0`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0:03oool0
02T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo
02d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo02d0oooo0P00000^0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0:03oool002T0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0]0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0X0?ooo`00:@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02d0oooo00<0
00000?ooo`3oool0;@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02P0oooo000Y
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0^
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0:03oool002T0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo02h0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo02h0oooo0P00000_0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0:03oool002T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0^0?ooo`030000
003oool0oooo02h0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0W0?ooo`00:@3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;`3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02L0oooo000Y0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool09`3oool002T0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0^0?ooo`800000<03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
02L0oooo000Y0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0;P3oool00`000000
oooo0?ooo`0_0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool09`3oool002T0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo02l0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0W0?ooo`00:@3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo01/0oooo00@0j[Yb000000000000L[[Z0P3oool00`3oom@0V`00
001b^P030?ooo`040>ZjLP000000000007:jjP@0oooo00<000000?ooo`3oool0;`3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo02L0oooo000X0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool06`3oool01@2jVkX0oooo0?ooo`2jLY/0e?oo00H0oooo00H0onZj079b^P3o
ool0oooo0;YbLP2jj_l30?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0W0?ooo`00:03oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
01X0oooo00H0oooD09]b^P3oool0oooo0=BKLP2jj_l:0?ooo`030=BKLP2jj_l0oooo0080oooo0`00
000`0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool09`3oool002P0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0K0?ooo`060?ooe02KL[X0oooo0?ooo`3DVg80^^[o
1`3oool0103DV`00000000000000Vm@40?ooo`030000003oool0oooo0340oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0W0?ooo`00:03oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo01`0oooo00D0^W9b0;[Zo`3oom@0V`2K0=Coo`070?ooo`030=BKLP2jj_l0oooo00D0
oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02H0
oooo000X0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0703oool0103oj[X0LP00
0000002Ke?l80?ooo`040=BK000000000000002Ke0@0oooo00<000000?ooo`3oool0<@3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo02H0oooo000X0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool0<@3oool2000003<0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0V0?ooo`009`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0340oooo
00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02H0oooo
000W0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?oo
o`0b0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool09P3oool002L0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo03<0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0V0?ooo`009`3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo0380oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo02H0oooo000W0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool0<P3oool2000003@0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0U0?ooo`00
9`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0
=03oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02D0oooo000W0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0d0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool09@3oool002L0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`0c0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0U0?ooo`009P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
03<0oooo0P00000f0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool09@3oool002H0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo03D0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0U0?ooo`009P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0=@3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo02D0oooo000V0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool0=03oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0903oool002H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0d
0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0T
0?ooo`009@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03D0oooo0P00000g0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0903oool002D0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0T0?ooo`009@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo02d0oooo00H0oooD09/00000000000000000LP2jj_l30?ooo`030000003oool0oooo
03L0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0T0?ooo`009@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo02l0oooo00<0omBK07:jjP3oool0103oool00`000000
oooo0?ooo`0g0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool08`3oool002@0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0`0?ooo`030?oDV`1b^^X0oooo00@0oooo
0`00000h0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool08`3oool002@0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0`0?ooo`030?oDV`1b^^X0oooo00@0oooo00<0
00000?ooo`3oool0>03oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo02<0oooo000T
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0<03oool00`2jLY/0e=BK07:jjP05
0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0S
0?ooo`008`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0300oooo00<0omBK0000
001b^^X01@3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool08P3oool002<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0i0?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0R0?ooo`00
8`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03T0oooo0P00000k0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool08P3oool002<0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0R0?ooo`008P3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo03X0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo0240oooo000R0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0>`3oool00`00
0000oooo0?ooo`0l0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool08@3oool00280
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0k0?ooo`800000?@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo0240oooo000R0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool08@3oool00240oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0l0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0P0?ooo`008@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo03d0oooo00<00000
0?ooo`3oool0?P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0200oooo000Q0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool0?@3oool2000003l0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0P0?ooo`008@3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo03h0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo01l0oooo000P0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
?P3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
7`3oool00200oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0o0?ooo`030000003o
ool0oooo0400oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0O0?ooo`00803oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0@03oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo01h0oooo000P0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0@03oool200000480oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0N0?ooo`00803oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0400
oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01h0
oooo000O0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0;03oool02P3oom@0V`00
000000000000001b0;[Zo`3oool0oooD09/00000L[X30?ooo`040>ZjLP000000000007:jjP@0oooo
00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01h0oooo
000O0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0;P3oool00`3oe9/0L[[Z0?oo
o`070?ooo`060?oZ^P1bL[X0oooo0?ooo`2jLW80^^[o0`3oool00`000000oooo0?ooo`120?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool07@3oool001l0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0_0?ooo`030?oDV`1b^^X0oooo00/0oooo00<0e9]b0;[Zo`3oool0
0P3oool3000004<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0M0?ooo`007`3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02l0oooo00<0omBK07:jjP3oool0203o
ool0103DV`00000000000000Vm@40?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0M0?ooo`007P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo02l0oooo00<0^W:K0=CDV`1b^^X02@3oool00`3DVg80^^[o0?ooo`050?ooo`030000003o
ool0oooo04@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0L0?ooo`007P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02l0oooo00<0omBK0000001b^^X02@3oool0
103DV`00000000000000Vm@40?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0L0?ooo`007@3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo04@0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo01`0oooo000M0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0A@3oool20000
04H0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0K0?ooo`007@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0AP3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo01/0oooo000L0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool06P3oool001`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`160?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0J0?ooo`006`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo04L0oooo0P000019
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool06P3oool001/0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04P0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0I0?ooo`006P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo04P0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo01T0oooo000J0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
B@3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
603oool001X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`190?ooo`030000003o
ool0oooo04X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0H0?ooo`006@3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo04X0oooo0P00001<0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0603oool001T0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`1:0?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0G0?ooo`00603oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo04/0
oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01L0
oooo000H0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0C03oool00`000000oooo
0?ooo`1<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05P3oool001P0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`1<0?ooo`800000CP3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo01H0oooo000G0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0C@3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool05P3oool001L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1>0?oo
o`030000003oool0oooo04h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo04D0oooo00H0omBK00000000
000000000000V`3Dool30?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
04L0oooo00<0^W800000V`3Dool01@3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0503oool001D0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`190?ooo`030?oDV`000000VmCo00@0oooo0`00001@0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0503oool001D0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`1:0?ooo`030?ooe03De?l0oooo00<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool0B03oool01P3oj[X0LW:j0?ooo`3oom@0V`2K0=Coo`<0oooo00<000000?ooo`3o
ool0D@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01<0oooo000D0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0BP3oool0103Z^W8000000000001b^^X40?ooo`03
0000003oool0oooo0580oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0C0?ooo`00
503oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0580oooo0P00001C0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool04P3oool001<0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0B0?ooo`004`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo05@0oooo00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo0180oooo000B0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0E03oool00`00
0000oooo0?ooo`1D0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool04@3oool00180
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0A0?ooo`004P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo05H0oooo0P00001G0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0403oool00140oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`1F0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0@0?ooo`004@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo05L0oooo00<00000
0?ooo`3oool0E`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0100oooo000@0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`1G0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool03`3oool00100oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`1H0?ooo`800000F@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00l0oooo000@0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
F@3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
3P3oool000l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1J0?ooo`030000003o
ool0oooo05T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0>0?ooo`003`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0FP3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00h0oooo000>0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0F`3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool03@3oool000h0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`1L0?ooo`800000G@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00d0
oooo000=0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0G03oool00`000000oooo
0?ooo`1L0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0303oool000d0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`180?ooo`0:0?oDV`00000000000000000009/0
e?oo0?ooo`3oom@0V`00001b^P<0oooo00@0j[Yb000000000000L[[Z103oool00`000000oooo0?oo
o`1M0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool001D0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0B@3oool00`2jLP00002K0=Coo`080?ooo`060?oZ^P1bL[X0oooo0?ooo`2jLW80^^[o
0`3oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01@0oooo000D0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo04/0oooo00<0omBK0000002Ke?l02`3oool00`3DVg80^^[o0?ooo`020?ooo`<00000GP3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0C0?ooo`00503oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1=0?ooo`030?ooe03De?l0
oooo00L0oooo00@0e9/000000000000009_D103oool00`000000oooo0?ooo`1O0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo01<0oooo000C0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo04X0oooo00H0onZj079b^P3oool0oooD09/0
V`3Dool70?ooo`030=BKLP2jj_l0oooo00D0oooo00<000000?ooo`3oool0H03oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0B0?ooo`004`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`1<0?ooo`040>ZjLP000000000007:jjPP0oooo
00@0e9/000000000000009_D103oool00`000000oooo0?ooo`1P0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0180
oooo000B0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0640oooo0P00001R0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0140oooo
000B0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo0640oooo00<000000?ooo`3oool0HP3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0A0?ooo`004@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo06<0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0403oool00140oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`1S0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0100oooo000@0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3o
ool0I03oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`0?0?ooo`00403oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1T0?ooo`800000
IP3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0?0?ooo`003`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1U0?ooo`030000003o
ool0oooo06D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool03P3oool000l0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0I@3oool0
0`000000oooo0?ooo`1V0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00h0oooo000>0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
06H0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0=0?ooo`003P3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`1W0?ooo`800000J03oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0=0?ooo`003@3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`1W0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool000d0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0J03oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo000E
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1X
0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo01<0oooo000E0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo06X0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01<0oooo000D0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1Z0?ooo`80
0000J`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool04P3oool001<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo06X0oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool04P3oool001<0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo06<0oooo00@0j[Yb00000000000009_D
103oool00`000000oooo0?ooo`1/0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0A0?ooo`004P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0H`3oool01P3oj[X0LW:j0?ooo`3oom@0V`1b0;[Zo`<0
oooo00<000000?ooo`3oool0K03oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0403oool00180oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo06D0oooo00<0e9/00000002Ke?l0103oool3000006d0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0100oooo
000A0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`1W0?ooo`030?ooe02KL[X0oooo00<0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03`3oool00100oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo06D0oooo00H0oooD
09/0LP2jj_l0oooD09/0V`3Dool30?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00l0oooo000@0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1V0?ooo`040?oZ^P1b
0000000009_Do`@0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool03P3oool000l0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool0L03o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool03P3o
ool000l0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo0700oooo0P00001a0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0=0?ooo`003P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0L@3oool00`000000oooo0?ooo`1a0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0=0?ooo`003P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0L@3oool00`000000
oooo0?ooo`1b0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0<0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`1c0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`005@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo07<0oooo0P00001d0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool04`3oool001@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1c
0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0C
0?ooo`004`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo07@0oooo00<000000?oo
o`3oool0M@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0180oooo000C0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0M@3oool00`000000oooo0?ooo`1f0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool04P3oool00180oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo07H0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0A0?ooo`004P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo07H0oooo0P00001h0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0403o
ool00140oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1g0?ooo`030000003oool0
oooo07P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0@0?ooo`00403oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo07P0oooo00<000000?ooo`3oool0N@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00l0oooo000@0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0N03oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool03P3oool000l0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`1i0?ooo`800000N`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00h0oooo
000>0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0NP3oool00`000000oooo0?oo
o`1k0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool03@3oool000h0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo07/0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0=0?ooo`003@3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo06L0oooo00@0j[Yb00000000000009_D0P3oool00`3oom@0V`00001b^P03
0?ooo`040>ZjLP000000000007:jjP@0oooo00<000000?ooo`3oool0O03oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00`0oooo000E0?ooo`030000003oool0oooo06L0oooo00H0onZj
079b^P3oool0oooD09/0LP2jj_l60?ooo`060?oZ^P1bL[X0oooo0?ooo`2jLW80^^[o0`3oool00`00
0000oooo0?ooo`1m0?ooo`030000003oool0oooo01<0oooo000D0?ooo`030000003oool0oooo06X0
oooo00<0e9/00000002Ke?l02`3oool00`3DVg80^^[o0?ooo`020?ooo`<00000O@3oool00`000000
oooo0?ooo`0C0?ooo`00503oool00`000000oooo0?ooo`1[0?ooo`030?ooe02KL[X0oooo00L0oooo
00@0e9/000000000000009_D103oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo0180
oooo000C0?ooo`030000003oool0oooo06T0oooo00H0oooD09/0LP2jj_l0oooD09/0V`3Dool70?oo
o`030=BKLP2jj_l0oooo00D0oooo00<000000?ooo`3oool0O`3oool00`000000oooo0?ooo`0A0?oo
o`004P3oool00`000000oooo0?ooo`1[0?ooo`040?oZ^P1b0000000009_Do`P0oooo00@0e9/00000
0000000009_D103oool00`000000oooo0?ooo`1o0?ooo`030000003oool0oooo0140oooo000A0?oo
o`030000003oool0oooo0800oooo0P0000210?ooo`030000003oool0oooo0100oooo000A0?ooo`03
0000003oool0oooo0800oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`0?0?ooo`00
403oool00`000000oooo0?ooo`210?ooo`030000003oool0oooo0840oooo00<000000?ooo`3oool0
3`3oool000l0oooo00<000000?ooo`3oool0PP3oool00`000000oooo0?ooo`220?ooo`030000003o
ool0oooo00h0oooo000>0?ooo`030000003oool0oooo08<0oooo0P0000240?ooo`030000003oool0
oooo00d0oooo000>0?ooo`030000003oool0oooo08<0oooo00<000000?ooo`3oool0P`3oool00`00
0000oooo0?ooo`0=0?ooo`003@3oool00`000000oooo0?ooo`240?ooo`030000003oool0oooo08@0
oooo00<000000?ooo`3oool0303oool009@0oooo00<000000?ooo`3oool0T`3oool009@0oooo00<0
00000?ooo`3oool0T`3oool009@0oooo0P00002D0?ooo`00U03oool00`000000oooo0?ooo`2C0?oo
o`00\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {228.438, 81.875}} -> {-9.50681, \
2.01814, 0.0296943, 0.0224717}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["obl4=Table[Plot[y2[x],{x,-4,4}],{c,-5,-1}];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show[%]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 -0.21119 0.159738 [
[.02381 .09579 -6 -9 ]
[.02381 .09579 6 0 ]
[.2619 .09579 -6 -9 ]
[.2619 .09579 6 0 ]
[.7381 .09579 -3 -9 ]
[.7381 .09579 3 0 ]
[.97619 .09579 -3 -9 ]
[.97619 .09579 3 0 ]
[.4875 .02842 -18 -4.5 ]
[.4875 .02842 0 4.5 ]
[.4875 .18816 -18 -4.5 ]
[.4875 .18816 0 4.5 ]
[.4875 .26803 -6 -4.5 ]
[.4875 .26803 0 4.5 ]
[.4875 .34789 -18 -4.5 ]
[.4875 .34789 0 4.5 ]
[.4875 .42776 -6 -4.5 ]
[.4875 .42776 0 4.5 ]
[.4875 .50763 -18 -4.5 ]
[.4875 .50763 0 4.5 ]
[.4875 .5875 -6 -4.5 ]
[.4875 .5875 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .10829 m
.02381 .11454 L
s
[(-4)] .02381 .09579 0 1 Mshowa
.2619 .10829 m
.2619 .11454 L
s
[(-2)] .2619 .09579 0 1 Mshowa
.7381 .10829 m
.7381 .11454 L
s
[(2)] .7381 .09579 0 1 Mshowa
.97619 .10829 m
.97619 .11454 L
s
[(4)] .97619 .09579 0 1 Mshowa
.125 Mabswid
.08333 .10829 m
.08333 .11204 L
s
.14286 .10829 m
.14286 .11204 L
s
.20238 .10829 m
.20238 .11204 L
s
.32143 .10829 m
.32143 .11204 L
s
.38095 .10829 m
.38095 .11204 L
s
.44048 .10829 m
.44048 .11204 L
s
.55952 .10829 m
.55952 .11204 L
s
.61905 .10829 m
.61905 .11204 L
s
.67857 .10829 m
.67857 .11204 L
s
.79762 .10829 m
.79762 .11204 L
s
.85714 .10829 m
.85714 .11204 L
s
.91667 .10829 m
.91667 .11204 L
s
.25 Mabswid
0 .10829 m
1 .10829 L
s
.5 .02842 m
.50625 .02842 L
s
[(1.5)] .4875 .02842 1 0 Mshowa
.5 .18816 m
.50625 .18816 L
s
[(2.5)] .4875 .18816 1 0 Mshowa
.5 .26803 m
.50625 .26803 L
s
[(3)] .4875 .26803 1 0 Mshowa
.5 .34789 m
.50625 .34789 L
s
[(3.5)] .4875 .34789 1 0 Mshowa
.5 .42776 m
.50625 .42776 L
s
[(4)] .4875 .42776 1 0 Mshowa
.5 .50763 m
.50625 .50763 L
s
[(4.5)] .4875 .50763 1 0 Mshowa
.5 .5875 m
.50625 .5875 L
s
[(5)] .4875 .5875 1 0 Mshowa
.125 Mabswid
.5 .04439 m
.50375 .04439 L
s
.5 .06037 m
.50375 .06037 L
s
.5 .07634 m
.50375 .07634 L
s
.5 .09231 m
.50375 .09231 L
s
.5 .12426 m
.50375 .12426 L
s
.5 .14023 m
.50375 .14023 L
s
.5 .15621 m
.50375 .15621 L
s
.5 .17218 m
.50375 .17218 L
s
.5 .20413 m
.50375 .20413 L
s
.5 .2201 m
.50375 .2201 L
s
.5 .23608 m
.50375 .23608 L
s
.5 .25205 m
.50375 .25205 L
s
.5 .284 m
.50375 .284 L
s
.5 .29997 m
.50375 .29997 L
s
.5 .31595 m
.50375 .31595 L
s
.5 .33192 m
.50375 .33192 L
s
.5 .36387 m
.50375 .36387 L
s
.5 .37984 m
.50375 .37984 L
s
.5 .39582 m
.50375 .39582 L
s
.5 .41179 m
.50375 .41179 L
s
.5 .44374 m
.50375 .44374 L
s
.5 .45971 m
.50375 .45971 L
s
.5 .47568 m
.50375 .47568 L
s
.5 .49166 m
.50375 .49166 L
s
.5 .52361 m
.50375 .52361 L
s
.5 .53958 m
.50375 .53958 L
s
.5 .55555 m
.50375 .55555 L
s
.5 .57153 m
.50375 .57153 L
s
.5 .01244 m
.50375 .01244 L
s
.5 .60348 m
.50375 .60348 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .56332 L
.10458 .52139 L
.14415 .4839 L
.18221 .44986 L
.22272 .41618 L
.26171 .38664 L
.30316 .35883 L
.34309 .33607 L
.3815 .31838 L
.40095 .31114 L
.42237 .30458 L
.44268 .29977 L
.45178 .29807 L
.46172 .29655 L
.4671 .29587 L
.4721 .29533 L
.47727 .29487 L
.48196 .29453 L
.48658 .29427 L
.4887 .29417 L
.49093 .29409 L
.49332 .29403 L
.49438 .294 L
.49552 .29398 L
.49675 .29397 L
.49789 .29395 L
.49859 .29395 L
.49925 .29395 L
.50049 .29395 L
.50163 .29395 L
.50286 .29396 L
.50401 .29398 L
.50508 .29399 L
.50754 .29405 L
.51014 .29413 L
.51268 .29423 L
.51504 .29435 L
.5204 .29469 L
.5293 .29548 L
.53882 .29663 L
.54906 .29822 L
.56016 .30036 L
.58032 .30531 L
.62123 .31949 L
.66064 .33801 L
.69852 .35988 L
.73886 .38705 L
.77769 .4165 L
.81897 .45088 L
Mistroke
.85873 .48656 L
.89697 .5229 L
.93767 .56343 L
.97619 .60332 L
Mfstroke
.02381 .57136 m
.06244 .52964 L
.10458 .48569 L
.14415 .44617 L
.18221 .41007 L
.22272 .3741 L
.26171 .34231 L
.30316 .31216 L
.34309 .28727 L
.3815 .26778 L
.40095 .25976 L
.42237 .25247 L
.44268 .24712 L
.45178 .24523 L
.46172 .24353 L
.4671 .24277 L
.4721 .24217 L
.47727 .24165 L
.48196 .24127 L
.48658 .24098 L
.4887 .24087 L
.49093 .24078 L
.49332 .24071 L
.49438 .24068 L
.49552 .24066 L
.49675 .24064 L
.49789 .24063 L
.49859 .24062 L
.49925 .24062 L
.50049 .24062 L
.50163 .24062 L
.50286 .24063 L
.50401 .24065 L
.50508 .24067 L
.50754 .24073 L
.51014 .24082 L
.51268 .24094 L
.51504 .24107 L
.5204 .24145 L
.5293 .24233 L
.53882 .24361 L
.54906 .24539 L
.56016 .24777 L
.58032 .25329 L
.62123 .26901 L
.66064 .2894 L
.69852 .3133 L
.73886 .34276 L
.77769 .37444 L
.81897 .41115 L
Mistroke
.85873 .44898 L
.89697 .48728 L
.93767 .52976 L
.97619 .57136 L
Mfstroke
.02381 .53805 m
.06244 .49436 L
.10458 .44806 L
.14415 .40613 L
.18221 .36754 L
.22272 .32874 L
.26171 .29411 L
.30316 .26089 L
.34309 .23314 L
.3815 .21116 L
.40095 .20205 L
.42237 .19372 L
.44268 .18757 L
.45178 .1854 L
.46172 .18345 L
.4671 .18257 L
.4721 .18187 L
.47727 .18127 L
.48196 .18084 L
.48658 .1805 L
.4887 .18038 L
.49093 .18028 L
.49332 .18019 L
.49438 .18016 L
.49552 .18013 L
.49675 .18011 L
.49789 .1801 L
.49859 .18009 L
.49925 .18009 L
.50049 .18009 L
.50163 .18009 L
.50286 .18011 L
.50401 .18012 L
.50508 .18015 L
.50754 .18022 L
.51014 .18032 L
.51268 .18046 L
.51504 .18061 L
.5204 .18104 L
.5293 .18206 L
.53882 .18354 L
.54906 .18559 L
.56016 .18833 L
.58032 .19466 L
.62123 .21256 L
.66064 .23553 L
.69852 .26216 L
.73886 .2946 L
.77769 .32912 L
.81897 .3687 L
Mistroke
.85873 .40912 L
.89697 .44973 L
.93767 .49449 L
.97619 .53805 L
Mfstroke
.02381 .50318 m
.06244 .45722 L
.10458 .40815 L
.14415 .36331 L
.18221 .32163 L
.22272 .27921 L
.26171 .2408 L
.30316 .20333 L
.34309 .17143 L
.3815 .14567 L
.40095 .13483 L
.42237 .12484 L
.44268 .11741 L
.45178 .11477 L
.46172 .11239 L
.4671 .11132 L
.4721 .11047 L
.47727 .10974 L
.48196 .1092 L
.48658 .10879 L
.4887 .10865 L
.49093 .10852 L
.49332 .10841 L
.49438 .10838 L
.49552 .10834 L
.49675 .10832 L
.49789 .1083 L
.49859 .10829 L
.49925 .10829 L
.50049 .10829 L
.50163 .10829 L
.50286 .10831 L
.50401 .10833 L
.50508 .10836 L
.50754 .10845 L
.51014 .10858 L
.51268 .10874 L
.51504 .10892 L
.5204 .10946 L
.5293 .1107 L
.53882 .1125 L
.54906 .115 L
.56016 .11833 L
.58032 .12597 L
.62123 .14732 L
.66064 .1742 L
.69852 .20477 L
.73886 .24135 L
.77769 .27962 L
.81897 .32289 L
Mistroke
.85873 .36652 L
.89697 .40993 L
.93767 .45735 L
.97619 .50318 L
Mfstroke
.02381 .46652 m
.06244 .41788 L
.10458 .36548 L
.14415 .31703 L
.18221 .27137 L
.22272 .22408 L
.26171 .1803 L
.30316 .13637 L
.34309 .09762 L
.3815 .06506 L
.40095 .05091 L
.42237 .03758 L
.44268 .02745 L
.46172 .02048 L
.46668 .0191 L
.4721 .0178 L
.47687 .01684 L
.48196 .01601 L
.48456 .01566 L
.487 .01539 L
.48938 .01516 L
.49157 .015 L
.49365 .01487 L
.49472 .01483 L
.49585 .01478 L
.497 .01475 L
.49806 .01473 L
.49933 .01472 L
.50049 .01472 L
.50167 .01473 L
.50277 .01474 L
.50399 .01478 L
.5053 .01483 L
.50659 .01489 L
.50796 .01497 L
.5104 .01514 L
.51478 .01558 L
.51957 .01624 L
.52477 .01715 L
.53033 .01835 L
.54033 .02111 L
.56168 .0294 L
.58183 .03999 L
.6203 .06646 L
.66122 .10158 L
.70062 .14023 L
.73851 .18054 L
.77885 .22588 L
.81767 .27122 L
.85895 .32079 L
Mistroke
.89871 .36954 L
.93695 .41713 L
.97619 .46652 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oU03oool0
0`000000oooo0?ooo`2C0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00U03oool00`000000
oooo0?ooo`2C0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00TP3oool600000980oooo002<
0?ooo`H000000P3oool010000000oooo0?ooo`3oool7000008/0oooo001o0?ooo`090?ooe02K0000
0000000000000780^^[o0?ooo`3oom@0V`0000@0000000@0j[Yb000000000000L[[Z103oool00`00
0000oooo0?ooo`080?ooo`<00000R03oool00840oooo00@0omBK07:jjP3oool0oooo0`0000030?oo
o`060?oZ^P1bL[X0oooo0?ooo`2jLW80^^[o0`3oool00`000000oooo0?ooo`0;0?ooo`800000QP3o
ool00840oooo00@0omBK07:jjP00000000002P3oool00`3DVg80^^[o0?ooo`020?ooo`<000003@3o
ool2000008@0oooo00210?ooo`8000002@3oool0103DV`00000000000000Vm@40?ooo`030000003o
ool0oooo00l0oooo0P0000220?ooo`00O`3oool2000000030=CDV`1b^^X0oooo00P0oooo00<0e9]b
0;[Zo`3oool01@3oool00`000000oooo0?ooo`0A0?ooo`800000P03oool007d0oooo0P000000103o
ool0omBK0000001b^^X90?ooo`040=BK000000000000002Ke0@0oooo00<000000?ooo`3oool04`3o
ool2000007h0oooo001k0?ooo`8000005`3oool00`000000oooo0?ooo`0E0?ooo`800000O03oool0
07X0oooo00<000000?ooo`3oool05`3oool2000001P0oooo0P00001j0?ooo`00N03oool2000001X0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`1g0?ooo`00M`3oool00`000000oooo
0?ooo`0J0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0MP3oool007D0oooo0P00
000M0?ooo`030000003oool0oooo01/0oooo0P00001f0?ooo`00M03oool00`000000oooo0?ooo`0M
0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0L`3oool00780oooo0P00000P0?oo
o`8000007`3oool00`000000oooo0?ooo`1b0?ooo`00L@3oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo01l0oooo0P00001b0?ooo`002@3oool0103Z^W8000000000LP2jj_m10?ooo`06
0?oDV`00000000000000000009/0e?oo703oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0
oooo0240oooo00<000000?ooo`3oool07@3oool01P3oe9/00000000000000000002K0=Cood<0oooo
00@0j[Yb000000000780^^[o1@3oool000X0oooo00<0omBK07:jjP3oool0@P3oool00`2jLP00002K
0=Coo`0M0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool08P3oool00`000000oooo
0?ooo`0M0?ooo`030;Yb000009/0e?oo04H0oooo00<0omBK07:jjP3oool01@3oool000L0oooo00H0
oooD09/00000000000000000LP2jj_m30?ooo`030?oDV`000000VmCo01/0oooo00<000000?ooo`3o
ool08`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo01d0oooo00<0omBK0000002K
e?l0@P3oool01P3oom@0V`00000000000000001b0;[Zo`D0oooo00000`3oool0omBK000000030000
000609_Do`3oool0e9/009_Do`3oe9/0L[[Z?03oool00`3oe9/00000000000020000000609_Do`3o
ool0oooo0?ooo`3oom@0e=Co6P3oool00`000000oooo0?ooo`0T0?ooo`8000009@3oool2000001h0
oooo00<0oooD0=CDo`3oool0@P3oool0103DV`00VmCo0?oDV`1b^^X60?ooo`00203oool0103oom@0
V`1b0;ZjV`1b^^Y20?ooo`060?oZ^P1bL[X0oooo0?ooe02K09/0e?oo5`3oool2000002L0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`0H0?ooo`060?oZ^P1bL[X0oooo0?ooe02K09/0
e?oo@P3oool0103oom@0V`1b0;ZjV`1b^^X60?ooo`002@3oool00`3oj[X0LP0007:jjP130?ooo`04
0>ZjLP000000000007:jjQL0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0W0?oo
o`030000003oool0oooo01P0oooo00@0j[Yb000000000000L[[ZA03oool00`3oj[X0LP0007:jjP06
0?ooo`00J@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02P0oooo00<000000?oo
o`3oool0J03oool006P0oooo00<000000?ooo`3oool0:@3oool2000002X0oooo00<000000?ooo`3o
ool0I`3oool006L0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0Z0?ooo`800000
I`3oool006H0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0/0?ooo`030000003o
ool0oooo06@0oooo001U0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0;@3oool0
0`000000oooo0?ooo`1S0?ooo`00I03oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo
02h0oooo00<000000?ooo`3oool0HP3oool00?l00000:`00000000L0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0>0?ooo`040000003oool0oooo000000h0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`020?ooo`L000001@3oool00`000000oooo0?ooo`050?ooo`H0
0000103oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`00
00004@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00D0oooo00070?ooo`030000
003oool0oooo04@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0Q0?ooo`<00000
303oool00`000000oooo0?ooo`0;0?ooo`<000008`3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo04@0oooo00<000000?ooo`3oool01@3oool005l0oooo0P00000Q0?ooo`<000003`3o
ool00`000000oooo0?ooo`0>0?ooo`<000008@3oool00`000000oooo0?ooo`1N0?ooo`00GP3oool0
0`000000oooo0?ooo`0N0?ooo`<000004P3oool00`000000oooo0?ooo`0A0?ooo`<000007`3oool0
0`000000oooo0?ooo`1M0?ooo`00G@3oool00`000000oooo0?ooo`0M0?ooo`8000005@3oool20000
01D0oooo0P00000N0?ooo`030000003oool0oooo05`0oooo001L0?ooo`030000003oool0oooo01`0
oooo0P00000G0?ooo`030000003oool0oooo01H0oooo0P00000M0?ooo`030000003oool0oooo05/0
oooo001K0?ooo`030000003oool0oooo01/0oooo0P00000I0?ooo`030000003oool0oooo01P0oooo
0P00000L0?ooo`030000003oool0oooo05X0oooo001J0?ooo`030000003oool0oooo01X0oooo0P00
000K0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?oo
o`1I0?ooo`00F@3oool00`000000oooo0?ooo`0I0?ooo`8000007@3oool00`000000oooo0?ooo`0K
0?ooo`8000006`3oool00`000000oooo0?ooo`1H0?ooo`00F03oool00`000000oooo0?ooo`0H0?oo
o`8000007`3oool2000001h0oooo0P00000J0?ooo`030000003oool0oooo05L0oooo001G0?ooo`03
0000003oool0oooo01L0oooo0P00000Q0?ooo`030000003oool0oooo01l0oooo0P00000I0?ooo`03
0000003oool0oooo05H0oooo001G0?ooo`030000003oool0oooo01D0oooo0P00000S0?ooo`030000
003oool0oooo0240oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`1E0?ooo`00EP3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08P3o
ool2000001P0oooo00<000000?ooo`3oool0E03oool005D0oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`0T0?ooo`8000009@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo05<0oooo001D0?ooo`030000003oool0oooo01@0oooo0P00000W0?ooo`030000003oool0oooo
02D0oooo0P00000G0?ooo`030000003oool0oooo0580oooo001C0?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool0DP3oool00580oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0X0?ooo`030000003oool0oooo02P0oooo0P00000E0?ooo`030000003oool0oooo0540oooo
001A0?ooo`030000003oool0oooo01<0oooo0P00000[0?ooo`030000003oool0oooo02X0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`1@0?ooo`00D@3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo02/0oooo0P00000/0?ooo`800000503oool00`000000oooo0?ooo`1?
0?ooo`00D03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo02`0oooo00<000000?oo
o`3oool0;@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo04h0oooo001?0?ooo`03
0000003oool0oooo0140oooo0P00000]0?ooo`D00000;P3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo04d0oooo001>0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
6P3oool02@3oe9/00000000000000000002K0=Coo`3oool0oooD09/0000;000000040?ooo`000000
oooo0?ooo`/00000903oool2000001<0oooo00<000000?ooo`3oool0C03oool004d0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0L0?ooo`030;Yb000009/0e?oo0080oooo0`000003
0?ooo`060?oZ^P1bL[X0oooo0?ooo`2jLW80^^[o0`3oool00`000000oooo0?ooo`0;0?ooo`<00000
8`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo04/0oooo001<0?ooo`030000003o
ool0oooo0100oooo0P00000P0?ooo`040?oDV`0000000000000000X0oooo00<0e9]b0;[Zo`3oool0
0P3oool3000000h0oooo0`00000Q0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
BP3oool004/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0N0?ooo`<0000000<0
oooD0=CDo`3oool01`3oool0103DV`00000000000000Vm@40?ooo`030000003oool0oooo0140oooo
0`00000O0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0B@3oool004X0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0L0?ooo`<0000000H0onZj079b^P3oool0oooD
09/0V`3Dool70?ooo`030=BKLP2jj_l0oooo00D0oooo00<000000?ooo`3oool0503oool3000001d0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`180?ooo`00B@3oool00`000000oooo
0?ooo`0?0?ooo`800000703oool3000000@0oooo00@0j[Yb000000000000L[[Z203oool0103DV`00
000000000000Vm@40?ooo`030000003oool0oooo01L0oooo0P00000L0?ooo`8000004P3oool00`00
0000oooo0?ooo`170?ooo`00B03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01X0
oooo0P00000K0?ooo`030000003oool0oooo01T0oooo0P00000L0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0AP3oool004P0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0I0?ooo`8000007@3oool2000001`0oooo0`00000J0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool0AP3oool004L0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0H0?ooo`8000007`3oool00`000000oooo0?ooo`0N0?ooo`8000006@3oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo04D0oooo00160?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool05`3oool200000240oooo00<000000?ooo`3oool0803oool2000001P0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`140?ooo`00A@3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo01H0oooo0P00000S0?ooo`030000003oool0oooo0280oooo0P00000G0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool0@`3oool004@0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0E0?ooo`8000009@3oool2000002D0oooo0P00000F0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0@P3oool004<0oooo00<000000?ooo`3oool0
3@3oool2000001H0oooo0P00000W0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
503oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0440oooo00120?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool0503oool2000002T0oooo00<000000?ooo`3oool09`3o
ool2000001D0oooo0P00000@0?ooo`030000003oool0oooo0400oooo00110?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool04`3oool2000002/0oooo00<000000?ooo`3oool0:@3oool2
000001D0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0:`3oool00`00
0000oooo0?ooo`0[0?ooo`800000503oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
03h0oooo000o0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04P3oool2000002h0
oooo0P00000^0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0m0?ooo`00?`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool0;03oool6000002d0oooo0P00000C0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool0?@3oool003h0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0A0?ooo`8000009@3oool:00000080oooo00<000000?ooo`3oool02`00000U0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0l0?ooo`00?@3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool07`3oool6
000000`0oooo00<000000?ooo`3oool02`3oool3000002<0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03/0oooo000l0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0403oool2000001l0oooo0`00000B0?ooo`030000003oool0oooo
00h0oooo1000000P0?ooo`8000004P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
03X0oooo000k0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0L0?ooo`<000005@3oool2000001<0oooo1@00000M0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0i0?ooo`00>P3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00l0oooo0P00000L0?ooo`<00000603oool00`000000oooo
0?ooo`0G0?ooo`800000703oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool0>03oool003T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo01X0oooo0P00000K0?ooo`030000003oool0oooo01T0oooo0P00
000K0?ooo`8000004@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03L0oooo000i
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0I
0?ooo`8000005@3oool0103Z^W80000000000000Vm@40?ooo`030000003oool0oooo01/0oooo0`00
000J0?ooo`030000003oool0oooo00l0oooo0P00000=0?ooo`030000003oool0oooo03L0oooo000h
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0H
0?ooo`8000005P3oool01P3oj[X0LW:j0?ooo`3oom@0V`1b0;[Zo`<0oooo00<000000?ooo`3oool0
7P3oool2000001T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo03H0oooo000g0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03P3o
ool2000001P0oooo0`00000J0?ooo`030=BK00000000VmCo00@0oooo0`00000P0?ooo`800000603o
ool200000140oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0e0?ooo`00=P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool05P3oool2
000001h0oooo00<0oooD09]b^P3oool00`3oool00`000000oooo0?ooo`0R0?ooo`800000603oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0=03oool0
03D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
01D0oooo0P00000M0?ooo`060?ooe02K0780^^[o0?ooe02K09/0e?oo0`3oool00`000000oooo0?oo
o`0T0?ooo`8000005`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0<`3oool003@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo01@0oooo0P00000P0?ooo`040?oZ^P1b0000000009_Do`@0oooo00<0
00000?ooo`3oool09P3oool2000001H0oooo0P00000@0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0<P3oool003<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo01<0oooo0P00000Z0?ooo`800000:@3oool2000001H0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0340oooo000c0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool2000001@0oooo0P00000/0?oo
o`030000003oool0oooo02X0oooo0P00000E0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0a0?ooo`00<P3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool04P3oool2000002h0oooo00<000000?ooo`3o
ool0;03oool2000001@0oooo0P00000?0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0<03oool00340oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool0:@3oool=000002T0oooo0P00000D0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0_0?ooo`00<03o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04@3o
ool200000280oooo2P0000050?ooo`030000003oool0oooo00D0oooo1P00000U0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo02h0oooo000_0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01h0oooo1000000?0?ooo`800000303oool6
00000200oooo0P00000C0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0]0?ooo`00;P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0403oool2000001`0oooo1@00000C0?ooo`030000003oool0oooo
0140oooo0`00000O0?ooo`8000004P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0;03oool002h0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool06@3oool3000001P0
oooo00<000000?ooo`3oool0503oool3000001h0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0:`3oool002d0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00l0oooo
0P00000J0?ooo`8000006`3oool00`000000oooo0?ooo`0G0?ooo`<00000703oool200000140oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02/0oooo
000/0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool200000140oooo00<0
00000?ooo`3oool0603oool2000001d0oooo00<000000?ooo`3oool06P3oool3000001/0oooo00<0
00000?ooo`3oool03`3oool2000000d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0Z0?ooo`00:`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0G0?ooo`8000007`3oool2000001h0oooo0`00000I
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo02T0oooo000Z0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0?0?ooo`8000005`3oool300000240oooo00<000000?oo
o`3oool0803oool3000001L0oooo0P00000A0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0E0?ooo`80
0000903oool00`000000oooo0?ooo`0S0?ooo`8000005`3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0W0?ooo`00
:@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0D0?ooo`8000009P3oool00`000000oooo0?ooo`0U0?ooo`800000
5P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0V0?ooo`00:03oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool03P3oool2000001D0oooo0P00000X0?ooo`030000003o
ool0oooo02L0oooo0`00000D0?ooo`800000403oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool09P3oool002L0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04`3oool2
000002X0oooo0P00000[0?ooo`800000503oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0U0?ooo`009P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0B0?ooo`800000;03oool00`000000oooo0?ooo`0/0?ooo`8000004`3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0T0?ooo`009@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool03@3oool2000001<0oooo0P00000J0?ooo`040>ZjLP0000000000002K
e080oooo00<0oooD09/00000L[X00`3oool0103Z^W8000000000001b^^X40?ooo`030000003oool0
oooo02h0oooo0P00000B0?ooo`8000003`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool08`3oool002D0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04@3oool20000
01/0oooo00H0onZj079b^P3oool0oooD09/0LP2jj_l60?ooo`060?oZ^P1bL[X0oooo0?ooo`2jLW80
^^[o0`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool08P3oool002@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0M0?ooo`030=BK
00000000VmCo00/0oooo00<0e9]b0;[Zo`3oool00P3oool300000340oooo0P00000B0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo0280oooo000S0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3o
ool2000000h0oooo0P00000B0?ooo`8000008@3oool00`3oom@0Vg:j0?ooo`070?ooo`040=BK0000
00000000002Ke0@0oooo00<000000?ooo`3oool0<`3oool200000140oooo0P00000>0?ooo`800000
2`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0240oooo000R0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo0100oooo0P00000P0?ooo`060?ooe02K0780^^[o0?ooe02K09/0e?oo1`3oool00`3DVg80
^^[o0?ooo`050?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0P0?ooo`008@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0?0?ooo`8000008`3oool0103oj[X0LP00
0000002Ke?l80?ooo`040=BK000000000000002Ke0@0oooo00<000000?ooo`3oool0=P3oool20000
0140oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool07`3oool00240oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo0P00000A0?ooo`030000003oool0oooo03L0
oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0?0?ooo`8000003P3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool07P3oool00200oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool03`3oool2000003X0oooo0P00000j0?ooo`8000004@3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0N0?ooo`007`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool0>`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01d0oooo000N
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;
0?ooo`800000403oool2000003d0oooo00<000000?ooo`3oool0?03oool200000100oooo0P00000=
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0L
0?ooo`007@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03d0oooo00<000000?oo
o`3oool0?P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01/0oooo000L0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00h0oooo0P0000100?ooo`030000003oool0oooo03l0oooo0P00000@0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo01X0oooo000L0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
@03oool200000480oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0J0?ooo`006`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0=0?ooo`800000@`3oool00`000000oooo0?ooo`120?ooo`8000003`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0I0?ooo`006P3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo04<0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo01P0oooo000I0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0A03oool00`00
0000oooo0?ooo`150?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05`3oool001P0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0
oooo0P00000>0?ooo`800000A`3oool00`000000oooo0?ooo`160?ooo`8000003P3oool2000000`0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01L0
oooo000G0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0A`3oool2000004T0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`005P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo01D0oooo000E0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo0P00001;
0?ooo`030000003oool0oooo04X0oooo0P00000>0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01@0oooo000E0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`1<0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool04`3oool001@0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`1<0?ooo`800000CP3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo01<0oooo000C0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo0P00001?0?ooo`030000
003oool0oooo04h0oooo0P00000=0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0180oooo000B0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`1@0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool04@3oool00140oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`190?ooo`040>ZjLP000000001b0;[Zo`<0oooo00<000000?ooo`3oool0D@3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0100oooo000A0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0B`3oool00`3oe9/0L[[Z0?ooo`030?ooo`030000003oool0
oooo0580oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0?0?ooo`00403oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool20000
00`0oooo0P00001;0?ooo`060?ooe02K00000000000000000780^^[o0`3oool3000005<0oooo0P00
000<0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00l0oooo000?0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0C03oool0103DV`00VmCo0?oDV`1b^^X40?ooo`030000003oool0oooo05D0oooo00<0
00000?ooo`3oool02P3oool2000000X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00h0oooo000>0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0C@3oool0103oom@0V`1b0;ZjV`1b^^X40?ooo`030000003oool0oooo05H0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0=0?ooo`003P3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo04l0oooo00<0onZj0780001b^^X0103oool00`000000oooo0?ooo`1G
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0303oool000d0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo05P0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0;0?ooo`00303oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`80
0000FP3oool2000005X0oooo0P00000<0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00/0oooo000;0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`1K0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo05`0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00P0oooo00090?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0G@3oool20000
05l0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`00203oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool0G`3oool2000000/0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01`3oool000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`1O0?ooo`030000003oool0oooo0640oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`800000HP3oool00`000000oooo0?oo
o`1R0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool000l0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0HP3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00d0oooo000>0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo06<0oooo0P00001U0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00`0oooo000=0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo06@0oooo00<000000?ooo`3oool0I@3oool2000000T0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00/0oooo000<0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo06D0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0;0?ooo`002`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3o
ool000X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00T0oooo000:0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo06P0oooo0P00001[0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00P0oooo00090?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool0J`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`070?ooo`00203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo06`0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0F03oool0203Z^W8000000000
LP2jj_l0oooo0?ooe02K000007:j0`3oool0103Z^W8000000000001b^^X40?ooo`030000003oool0
oooo06d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool01@3oool000l0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`080?ooo`800000G03oool00`3oe9/0L[[Z0?ooo`060?ooo`060?oZ^P1bL[X0oooo
0?ooo`2jLW80^^[o0`3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0>0?ooo`003`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0F@3oool01P3oom@0V`0000000000
0000001b0;[Zo`X0oooo00<0e9]b0;[Zo`3oool00P3oool3000006l0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00d0oooo000>0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1K0?ooo`040=BK002K
e?l0omBK07:jjPP0oooo00@0e9/000000000000009_D103oool00`000000oooo0?ooo`1`0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`00
3@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
G03oool0103oom@0V`1b0;ZjV`1b^^X80?ooo`030=BKLP2jj_l0oooo00D0oooo00<000000?ooo`3o
ool0L@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool02`3oool000`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo05h0oooo00<0onZj0780001b^^X0203oool0103DV`00000000000000Vm@40?ooo`03
0000003oool0oooo0780oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00/0oooo000;0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`1b0?ooo`800000M03oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool02P3oool000X0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo07<0oooo00<000000?ooo`3oool0M03o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02@3o
ool000X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo07@0oooo00<000000?ooo`3oool0M@3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo07D0oooo00<000000?ooo`3oool0MP3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool000P0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo07H0
oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo07L0oooo0P00001i0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`003`3oool00`000000oooo0?oo
o`060?ooo`800000NP3oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool03@3oool000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1j
0?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0<
0?ooo`003@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo07/0oooo00<000000?oo
o`3oool0N`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00/0oooo000<0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0O03oool00`000000oooo0?ooo`1l0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool02`3oool000/0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`1m0?ooo`800000OP3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00X0oooo000:0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0OP3o
ool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02@3o
ool000X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1o0?ooo`030000003oool0
oooo07l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0800oooo00<000000?ooo`3oool0P03oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00080?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`210?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`220?ooo`800000P`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo
000>0?ooo`030000003oool0oooo08<0oooo00<000000?ooo`3oool0P`3oool00`000000oooo0?oo
o`0=0?ooo`003@3oool00`000000oooo0?ooo`1l0?ooo`040>ZjLP000000000007:jjP@0oooo00<0
00000?ooo`3oool0Q03oool00`000000oooo0?ooo`0<0?ooo`00303oool00`000000oooo0?ooo`1l
0?ooo`060?oZ^P1bL[X0oooo0?ooo`2jLW80^^[o0`3oool00`000000oooo0?ooo`250?ooo`030000
003oool0oooo00/0oooo000<0?ooo`030000003oool0oooo0800oooo00<0e9]b0;[Zo`3oool00P3o
ool3000008H0oooo00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool0OP3oool0
103DV`00000000000000Vm@40?ooo`030000003oool0oooo08L0oooo00<000000?ooo`3oool02@3o
ool000X0oooo00<000000?ooo`3oool0O`3oool00`3DVg80^^[o0?ooo`050?ooo`030000003oool0
oooo08P0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0P03oool0103D
V`00000000000000Vm@40?ooo`030000003oool0oooo08T0oooo00<000000?ooo`3oool01`3oool0
00P0oooo00<000000?ooo`3oool0R@3oool00`000000oooo0?ooo`2:0?ooo`030000003oool0oooo
00H0oooo00070?ooo`030000003oool0oooo08X0oooo0P00002<0?ooo`030000003oool0oooo00D0
oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?ooo`030000003oool0oooo09<0oooo002D
0?ooo`030000003oool0oooo09<0oooo002D0?ooo`030000003oool0oooo09<0oooo0000\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {448.375, 301.813}} -> {-9.07237, \
9.28955, 0.0283373, 0.021119}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["G1=Show[obl1,obl2]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.603319 0.115435 [
[.02381 .59082 -6 -9 ]
[.02381 .59082 6 0 ]
[.2619 .59082 -6 -9 ]
[.2619 .59082 6 0 ]
[.7381 .59082 -3 -9 ]
[.7381 .59082 3 0 ]
[.97619 .59082 -3 -9 ]
[.97619 .59082 3 0 ]
[.4875 .02615 -12 -4.5 ]
[.4875 .02615 0 4.5 ]
[.4875 .14158 -12 -4.5 ]
[.4875 .14158 0 4.5 ]
[.4875 .25701 -12 -4.5 ]
[.4875 .25701 0 4.5 ]
[.4875 .37245 -12 -4.5 ]
[.4875 .37245 0 4.5 ]
[.4875 .48788 -12 -4.5 ]
[.4875 .48788 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .60332 m
.02381 .60957 L
s
[(-4)] .02381 .59082 0 1 Mshowa
.2619 .60332 m
.2619 .60957 L
s
[(-2)] .2619 .59082 0 1 Mshowa
.7381 .60332 m
.7381 .60957 L
s
[(2)] .7381 .59082 0 1 Mshowa
.97619 .60332 m
.97619 .60957 L
s
[(4)] .97619 .59082 0 1 Mshowa
.125 Mabswid
.08333 .60332 m
.08333 .60707 L
s
.14286 .60332 m
.14286 .60707 L
s
.20238 .60332 m
.20238 .60707 L
s
.32143 .60332 m
.32143 .60707 L
s
.38095 .60332 m
.38095 .60707 L
s
.44048 .60332 m
.44048 .60707 L
s
.55952 .60332 m
.55952 .60707 L
s
.61905 .60332 m
.61905 .60707 L
s
.67857 .60332 m
.67857 .60707 L
s
.79762 .60332 m
.79762 .60707 L
s
.85714 .60332 m
.85714 .60707 L
s
.91667 .60332 m
.91667 .60707 L
s
.25 Mabswid
0 .60332 m
1 .60332 L
s
.5 .02615 m
.50625 .02615 L
s
[(-5)] .4875 .02615 1 0 Mshowa
.5 .14158 m
.50625 .14158 L
s
[(-4)] .4875 .14158 1 0 Mshowa
.5 .25701 m
.50625 .25701 L
s
[(-3)] .4875 .25701 1 0 Mshowa
.5 .37245 m
.50625 .37245 L
s
[(-2)] .4875 .37245 1 0 Mshowa
.5 .48788 m
.50625 .48788 L
s
[(-1)] .4875 .48788 1 0 Mshowa
.125 Mabswid
.5 .04923 m
.50375 .04923 L
s
.5 .07232 m
.50375 .07232 L
s
.5 .09541 m
.50375 .09541 L
s
.5 .11849 m
.50375 .11849 L
s
.5 .16467 m
.50375 .16467 L
s
.5 .18775 m
.50375 .18775 L
s
.5 .21084 m
.50375 .21084 L
s
.5 .23393 m
.50375 .23393 L
s
.5 .2801 m
.50375 .2801 L
s
.5 .30319 m
.50375 .30319 L
s
.5 .32628 m
.50375 .32628 L
s
.5 .34936 m
.50375 .34936 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .41862 m
.50375 .41862 L
s
.5 .44171 m
.50375 .44171 L
s
.5 .4648 m
.50375 .4648 L
s
.5 .51097 m
.50375 .51097 L
s
.5 .53406 m
.50375 .53406 L
s
.5 .55715 m
.50375 .55715 L
s
.5 .58023 m
.50375 .58023 L
s
.5 .00306 m
.50375 .00306 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .1714 m
.06244 .21171 L
.10458 .25639 L
.14415 .29933 L
.18221 .34197 L
.22272 .38968 L
.26171 .4398 L
.28326 .47096 L
.30316 .50442 L
.31304 .52449 L
.3223 .54819 L
.32481 .55634 L
.3271 .56516 L
.32832 .57074 L
.32965 .57814 L
.33038 .58329 L
.33105 .58968 L
s
.66843 .59845 m
.66859 .59478 L
.66928 .58625 L
.66992 .58106 L
.67137 .5723 L
.67378 .56155 L
.67597 .55367 L
.68089 .53917 L
.70244 .49431 L
.74229 .43437 L
.78227 .38363 L
.82073 .33861 L
.86165 .29296 L
.90106 .25036 L
.93894 .21025 L
.97619 .1714 L
s
.02381 .20344 m
.06244 .24736 L
.10458 .2972 L
.14415 .34689 L
.18221 .39923 L
.20342 .43185 L
.22272 .46552 L
.23233 .48472 L
.24276 .5089 L
.24754 .52193 L
.25261 .5382 L
.25694 .55594 L
.25813 .56204 L
.2594 .56977 L
.26061 .57919 L
.26171 .59397 L
s
.73849 .59 m
.73955 .57773 L
.74072 .56895 L
.74197 .56152 L
.74683 .54023 L
.75552 .5134 L
.7751 .4697 L
.8153 .40289 L
.8568 .34564 L
.89678 .29555 L
.93525 .25002 L
.97617 .20347 L
.97619 .20344 L
s
.02381 .23828 m
.06244 .287 L
.10458 .34436 L
.14415 .40556 L
.16408 .44162 L
.18221 .48083 L
.19227 .508 L
.19689 .5231 L
.20178 .54276 L
.20426 .55556 L
.20568 .56463 L
.20636 .56982 L
.207 .57564 L
.20821 .59334 L
s
.79167 .59717 m
.79183 .59233 L
.79254 .58063 L
.79322 .57352 L
.79457 .5629 L
.79603 .55387 L
.80106 .53075 L
.81095 .49863 L
.82007 .47537 L
.85782 .40224 L
.89722 .34178 L
.93511 .29018 L
.97545 .23919 L
.97619 .23828 L
s
.02381 .27682 m
.06244 .33238 L
.10458 .4023 L
.1253 .44393 L
.14415 .49171 L
.15367 .52475 L
.15639 .53693 L
.15891 .5505 L
.16003 .55786 L
.16128 .56764 L
.16253 .58145 L
.16321 .59667 L
s
.83683 .59488 m
.83802 .57452 L
.83871 .56771 L
.83937 .56229 L
.84058 .5537 L
.84332 .53835 L
.84824 .51716 L
.85942 .48142 L
.87826 .4362 L
.89869 .39632 L
.93961 .32927 L
.97619 .27682 L
s
.02381 .32056 m
.06244 .38708 L
.08426 .43227 L
.09408 .4561 L
.10458 .48602 L
.10966 .5033 L
.11447 .52271 L
.11878 .54511 L
.11996 .5529 L
.12122 .56272 L
.12229 .57354 L
.12347 .59615 L
s
.87666 .59135 m
.87779 .57257 L
.87904 .56056 L
.8804 .55037 L
.88316 .53415 L
.88811 .51182 L
.89929 .47429 L
.91976 .42328 L
.93891 .38451 L
.97619 .32056 L
s
.02381 .01472 m
.06244 .04362 L
.10458 .07392 L
.14415 .10101 L
.18221 .12561 L
.22272 .14995 L
.26171 .1713 L
.30316 .19139 L
.34309 .20784 L
.3815 .22062 L
.40095 .22586 L
.42237 .2306 L
.44268 .23408 L
.45178 .2353 L
.46172 .2364 L
.4671 .23689 L
.4721 .23728 L
.47727 .23762 L
.48196 .23786 L
.48658 .23805 L
.4887 .23812 L
.49093 .23818 L
.49332 .23822 L
.49438 .23824 L
.49552 .23826 L
.49675 .23827 L
.49789 .23828 L
.49859 .23828 L
.49925 .23828 L
.50049 .23828 L
.50163 .23828 L
.50286 .23827 L
.50401 .23826 L
.50508 .23825 L
.50754 .23821 L
.51014 .23815 L
.51268 .23808 L
.51504 .23799 L
.5204 .23775 L
.5293 .23718 L
.53882 .23635 L
.54906 .2352 L
.56016 .23365 L
.58032 .23007 L
.62123 .21982 L
.66064 .20644 L
.69852 .19064 L
.73886 .171 L
.77769 .14972 L
.81897 .12487 L
Mistroke
.85873 .09909 L
.89697 .07283 L
.93767 .04354 L
.97619 .01472 L
Mfstroke
.02381 .03781 m
.06244 .06796 L
.10458 .09972 L
.14415 .12828 L
.18221 .15437 L
.22272 .18036 L
.26171 .20333 L
.30316 .22512 L
.34309 .24311 L
.3815 .25719 L
.40095 .26299 L
.42237 .26825 L
.44268 .27212 L
.45178 .27349 L
.46172 .27472 L
.4671 .27527 L
.4721 .2757 L
.47727 .27608 L
.48196 .27635 L
.48658 .27656 L
.4887 .27664 L
.49093 .2767 L
.49332 .27676 L
.49438 .27677 L
.49552 .27679 L
.49675 .2768 L
.49789 .27681 L
.49859 .27682 L
.49925 .27682 L
.50049 .27682 L
.50163 .27682 L
.50286 .27681 L
.50401 .2768 L
.50508 .27678 L
.50754 .27674 L
.51014 .27667 L
.51268 .27659 L
.51504 .27649 L
.5204 .27622 L
.5293 .27559 L
.53882 .27466 L
.54906 .27337 L
.56016 .27165 L
.58032 .26766 L
.62123 .2563 L
.66064 .24157 L
.69852 .2243 L
.73886 .20301 L
.77769 .18011 L
.81897 .15359 L
Mistroke
.85873 .12625 L
.89697 .09857 L
.93767 .06787 L
.97619 .03781 L
Mfstroke
.02381 .06188 m
.06244 .09345 L
.10458 .12691 L
.14415 .15721 L
.18221 .1851 L
.22272 .21314 L
.26171 .23816 L
.30316 .26217 L
.34309 .28222 L
.3815 .29811 L
.40095 .30469 L
.42237 .31071 L
.44268 .31515 L
.45178 .31672 L
.46172 .31814 L
.4671 .31877 L
.4721 .31927 L
.47727 .31971 L
.48196 .32002 L
.48658 .32026 L
.4887 .32035 L
.49093 .32043 L
.49332 .32049 L
.49438 .32051 L
.49552 .32053 L
.49675 .32055 L
.49789 .32056 L
.49859 .32056 L
.49925 .32056 L
.50049 .32056 L
.50163 .32056 L
.50286 .32055 L
.50401 .32054 L
.50508 .32052 L
.50754 .32047 L
.51014 .32039 L
.51268 .3203 L
.51504 .32019 L
.5204 .31987 L
.5293 .31914 L
.53882 .31807 L
.54906 .31659 L
.56016 .31461 L
.58032 .31003 L
.62123 .2971 L
.66064 .2805 L
.69852 .26126 L
.73886 .23781 L
.77769 .21287 L
.81897 .18426 L
Mistroke
.85873 .15505 L
.89697 .1257 L
.93767 .09336 L
.97619 .06188 L
Mfstroke
.02381 .08708 m
.06244 .1203 L
.10458 .15576 L
.14415 .18816 L
.18221 .21828 L
.22272 .24893 L
.26171 .27669 L
.30316 .30377 L
.34309 .32682 L
.3815 .34544 L
.40095 .35327 L
.42237 .36049 L
.44268 .36585 L
.45178 .36776 L
.46172 .36948 L
.4671 .37026 L
.4721 .37087 L
.47727 .3714 L
.48196 .37179 L
.48658 .37208 L
.4887 .37219 L
.49093 .37228 L
.49332 .37236 L
.49438 .37239 L
.49552 .37241 L
.49675 .37243 L
.49789 .37244 L
.49859 .37245 L
.49925 .37245 L
.50049 .37245 L
.50163 .37244 L
.50286 .37243 L
.50401 .37242 L
.50508 .3724 L
.50754 .37233 L
.51014 .37224 L
.51268 .37212 L
.51504 .37199 L
.5204 .3716 L
.5293 .37071 L
.53882 .3694 L
.54906 .3676 L
.56016 .36519 L
.58032 .35967 L
.62123 .34424 L
.66064 .32482 L
.69852 .30272 L
.73886 .27629 L
.77769 .24863 L
.81897 .21737 L
Mistroke
.85873 .18583 L
.89697 .15447 L
.93767 .1202 L
.97619 .08708 L
Mfstroke
.02381 .11357 m
.06244 .14872 L
.10458 .18659 L
.14415 .2216 L
.18221 .2546 L
.22272 .28877 L
.26171 .32041 L
.30316 .35216 L
.34309 .38016 L
.3815 .40369 L
.40095 .41391 L
.42237 .42355 L
.44268 .43087 L
.46172 .4359 L
.46668 .4369 L
.4721 .43784 L
.47687 .43854 L
.48196 .43914 L
.48456 .43938 L
.487 .43958 L
.48938 .43975 L
.49157 .43987 L
.49365 .43995 L
.49472 .43999 L
.49585 .44002 L
.497 .44004 L
.49806 .44006 L
.49933 .44007 L
.50049 .44007 L
.50167 .44006 L
.50277 .44005 L
.50399 .44002 L
.5053 .43999 L
.50659 .43994 L
.50796 .43989 L
.5104 .43976 L
.51478 .43944 L
.51957 .43897 L
.52477 .43831 L
.53033 .43744 L
.54033 .43545 L
.56168 .42946 L
.58183 .42181 L
.6203 .40268 L
.66122 .37729 L
.70062 .34936 L
.73851 .32024 L
.77885 .28747 L
.81767 .2547 L
.85895 .21888 L
Mistroke
.89871 .18366 L
.93695 .14926 L
.97619 .11357 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oU03oool0
0`000000oooo0?ooo`2C0?ooo`00U03oool2000009@0oooo002D0?ooo`030000003oool0oooo09<0
oooo002D0?ooo`030000003oool0oooo09<0oooo00070?ooo`030000003oool0oooo08X0oooo00<0
00000?ooo`3oool0R`3oool00`000000oooo0?ooo`050?ooo`00203oool00`000000oooo0?ooo`29
0?ooo`030000003oool0oooo08X0oooo00<000000?ooo`3oool01P3oool000T0oooo0P0000210?oo
o`040>ZjLP000000000007:jjP@0oooo00<000000?ooo`3oool0R03oool2000000T0oooo000;0?oo
o`030000003oool0oooo07d0oooo00H0onZj079b^P3oool0oooo0;YbLP2jj_l30?ooo`030000003o
ool0oooo08L0oooo00<000000?ooo`3oool02@3oool000`0oooo00<000000?ooo`3oool0P03oool0
0`3DVg80^^[o0?ooo`020?ooo`<00000QP3oool00`000000oooo0?ooo`0:0?ooo`003@3oool00`00
0000oooo0?ooo`1e0?ooo`030?oDV`00000000000080000000<0VmCo0?ooo`3DV`000P0000000`00
Vm@0oooo0?ooo`020?ooo`030000003oool0oooo08@0oooo0P00000=0?ooo`003P3oool00`000000
oooo0?ooo`1k0?ooo`030=BKLP2jj_l0oooo00D0oooo00<000000?ooo`3oool0P`3oool00`000000
oooo0?ooo`0=0?ooo`001`3oool00`000000oooo0?ooo`050?ooo`800000N`3oool0103DV`000000
00000000Vm@40?ooo`030000003oool0oooo0880oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`050?ooo`00203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0800oooo
00<000000?ooo`3oool0P03oool2000000P0oooo00<000000?ooo`3oool01P3oool000T0oooo0P00
00070?ooo`030000003oool0oooo07l0oooo00<000000?ooo`3oool0O`3oool00`000000oooo0?oo
o`060?ooo`8000002@3oool000/0oooo00<000000?ooo`3oool01@3oool2000007l0oooo00<00000
0?ooo`3oool0OP3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo000<0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0O03oool2000007d0oooo0P0000080?oo
o`030000003oool0oooo00X0oooo000=0?ooo`030000003oool0oooo00H0oooo0P00001l0?ooo`03
0000003oool0oooo07/0oooo00<000000?ooo`3oool01P3oool2000000d0oooo000>0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`1j0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool03@3oool000L0oooo00<000000?ooo`3oool01@3o
ool2000000P0oooo00<000000?ooo`3oool0N03oool00`000000oooo0?ooo`1h0?ooo`800000203o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00080?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool01P3oool2000007P0oooo00<000000?ooo`3oool0M`3oool0
0`000000oooo0?ooo`060?ooo`800000203oool00`000000oooo0?ooo`060?ooo`002@3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0M@3oool00`00
0000oooo0?ooo`1f0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0
oooo0P00001e0?ooo`800000M@3oool2000000P0oooo00<000000?ooo`3oool01P3oool2000000X0
oooo000;0?ooo`030000003oool0oooo00H0oooo0P0000090?ooo`030000003oool0oooo0780oooo
00<000000?ooo`3oool0L`3oool00`000000oooo0?ooo`060?ooo`800000203oool00`000000oooo
0?ooo`0:0?ooo`00303oool2000000P0oooo00<000000?ooo`3oool01`3oool200000780oooo00<0
00000?ooo`3oool0L@3oool2000000P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0;0?ooo`003P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0K`3oool00`000000oooo0?ooo`1`0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`003`3oool00`000000oooo0?ooo`060?oo
o`8000002@3oool2000006l0oooo00<000000?ooo`3oool0KP3oool2000000P0oooo0P0000090?oo
o`030000003oool0oooo00d0oooo00070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3o
ool0K03oool2000000T0oooo00<000000?ooo`3oool01`3oool2000000P0oooo00<000000?ooo`3o
ool01@3oool000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00P0oooo0P00001/0?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1P3oool000T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`8000002P3o
ool00`000000oooo0?ooo`1Y0?ooo`800000JP3oool2000000T0oooo0P0000090?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo0P00001Y0?ooo`030000003oool0
oooo06P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00H0oooo0P00000:0?ooo`002`3oool00`000000oooo0?ooo`060?ooo`8000002@3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0IP3oool20000
00T0oooo0P0000090?ooo`800000203oool00`000000oooo0?ooo`0:0?ooo`00303oool2000000P0
oooo00<000000?ooo`3oool01`3oool2000000X0oooo0P00001V0?ooo`030000003oool0oooo06D0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool02`3oool000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0H`3oool00`000000oooo
0?ooo`1S0?ooo`8000002P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0303oool000l0oooo00<000000?ooo`3oool01P3oool2000000T0oooo0P00
000:0?ooo`800000H`3oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo00P0oooo0P00
00090?ooo`8000002@3oool00`000000oooo0?ooo`0=0?ooo`001`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`09
0?ooo`800000H@3oool00`000000oooo0?ooo`1P0?ooo`8000002P3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00L0oooo0P0000080?ooo`030000003oool0oooo00D0oooo00080?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?oo
o`8000002`3oool00`000000oooo0?ooo`1N0?ooo`800000H03oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00H0oooo00090?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01`3oool2000000X0oooo00<000000?ooo`3oool02@3oool2000005h0oooo00<000000?ooo`3o
ool0G@3oool2000000X0oooo0P0000090?ooo`8000002@3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00L0oooo000:0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`080?ooo`8000002`3oool00`000000oooo0?ooo`1K0?ooo`030000
003oool0oooo05`0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool2000000X0oooo000;0?ooo`030000003o
ool0oooo00H0oooo0P0000090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3o
ool2000005/0oooo00<000000?ooo`3oool0FP3oool2000000/0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02P3o
ool000`0oooo0P0000080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool2
000000/0oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`1H0?ooo`8000002`3oool2
000000T0oooo0P0000090?ooo`800000203oool00`000000oooo0?ooo`0;0?ooo`003P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo0P00000;0?ooo`030000003oool0oooo
00T0oooo0P00001A0?ooo`040>ZjLP000000001b0;[Zo`<0oooo00<000000?ooo`3oool0E`3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00`0oooo000?0?ooo`030000003oool0oooo
00H0oooo0P0000090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`1?0?ooo`030?oDV`1b^^X0oooo00<0oooo00<000000?ooo`3oool0E@3oool20000
00`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool03@3oool00100oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo0P00000;0?ooo`800000C03oool01P3oom@0
V`00000000000000001b0;[Zo`<0oooo0`00001C0?ooo`800000303oool2000000X0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`800000403oool00140oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`070?ooo`8000002`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo04<0oooo00<0omBK0000000000000P0000001P2Ke?l0oooo0=BK002Ke?l0
omBK07:jjP@0oooo00<000000?ooo`3oool0D@3oool2000000d0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0403o
ool00180oooo00<000000?ooo`3oool01`3oool2000000T0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0:0?ooo`800000BP3oool0103oom@0V`1b0;ZjV`1b^^X40?ooo`030000003o
ool0oooo0500oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`080?ooo`8000002@3o
ool2000000P0oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo0P00000<0?ooo`030000003oool0
oooo04P0oooo00<0onZj0780001b^^X0103oool00`000000oooo0?ooo`1>0?ooo`8000003@3oool2
000000X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo0180oooo000D0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool20000
00/0oooo00<000000?ooo`3oool02P3oool2000004l0oooo00<000000?ooo`3oool0C03oool20000
00h0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool04`3oool001D0oooo0P0000090?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool02@3oool2000000`0oooo0P00001=0?ooo`030000003oool0oooo04/0
oooo00<000000?ooo`3oool0303oool2000000/0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo01@0oooo000G0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0203oool2000000/0oooo00<000000?ooo`3oool02`3oool2000004/0oooo
00<000000?ooo`3oool0B@3oool2000000d0oooo0P00000;0?ooo`8000002@3oool2000000T0oooo
00<000000?ooo`3oool05@3oool001P0oooo00<000000?ooo`3oool01`3oool2000000X0oooo00<0
00000?ooo`3oool02@3oool2000000d0oooo0P0000190?ooo`800000B03oool2000000h0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool05P3oool001T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool2000004L0oooo00<00000
0?ooo`3oool0A@3oool2000000h0oooo0P00000<0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0G0?ooo`001`3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool2000000/0oooo0P00000>0?oo
o`800000A@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo00`0oooo0P00000<0?oo
o`8000002P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool01@3oool000P0oooo00<000000?ooo`3oool0403oool2000000T0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00d0oooo0P0000130?ooo`03
0000003oool0oooo0480oooo0P00000=0?ooo`8000003@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`060?ooo`00
2@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0:0?ooo`8000003`3oool200000440oooo00<000000?ooo`3oool0
@03oool2000000h0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`080?ooo`800000
2P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00L0oooo000:0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool01`3oool2000000X0oooo0P00000<0?ooo`030000003o
ool0oooo00h0oooo0P00000o0?ooo`030000003oool0oooo03h0oooo0P00000>0?ooo`8000003@3o
ool2000000X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo00P0oooo000;0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo0P00000@0?ooo`800000?@3oool0
0`000000oooo0?ooo`0l0?ooo`8000003P3oool2000000h0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool02@3oool0
00`0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00T0oooo0P00000<0?ooo`800000403oool2000003/0oooo0P00000k0?ooo`8000003`3oool00`00
0000oooo0?ooo`0<0?ooo`8000002`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool02P3oool000`0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool200000100
oooo0`00000h0?ooo`030000003oool0oooo03L0oooo0`00000?0?ooo`8000003P3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0;0?ooo`003@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00P0oooo
0P00000;0?ooo`8000003@3oool200000140oooo0P00000f0?ooo`030000003oool0oooo03@0oooo
0`00000@0?ooo`8000003P3oool2000000/0oooo0P00000:0?ooo`8000004P3oool00`000000oooo
0?ooo`0<0?ooo`003P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`8000004@3oool2000003@0oooo00<0
00000?ooo`3oool0<P3oool200000140oooo0P00000?0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00d0oooo0007
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00X0oooo0P00000>0?ooo`8000004@3oool300000340oooo00<00000
0?ooo`3oool0;`3oool300000180oooo00<000000?ooo`3oool03@3oool2000000`0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01@3oool000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0B0?oo
o`8000002P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo0P00000B0?oo
o`800000;`3oool00`000000oooo0?ooo`0/0?ooo`<000004`3oool2000000l0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`060?ooo`002@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0;0?ooo`80
00003`3oool200000180oooo0`00000/0?ooo`030000003oool0oooo02T0oooo0`00000D0?ooo`80
00003`3oool2000000d0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00P0oooo0P00000=0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool04P3oool3000002T0oooo0P00000W0?ooo`<00000
5P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00/0oooo0P00000:0?ooo`800000
4`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo000:0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00/0oooo0P00000?0?ooo`8000005@3oool2000002L0oooo00<000000?ooo`3oool08`3o
ool3000001L0oooo0P00000?0?ooo`8000003@3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`002`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo0P00000E0?ooo`<00000903oool0
0`000000oooo0?ooo`0P0?ooo`<00000603oool200000100oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`090?ooo`00303oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`800000403oool20000
01H0oooo1000000P0?ooo`030000003oool0oooo01`0oooo1000000I0?ooo`800000403oool20000
00h0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool02P3oool000d0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00T0oooo0P00000>0?ooo`030000003oool0oooo00l0
oooo0P00000H0?ooo`H000006P3oool00`000000oooo0?ooo`0H0?ooo`@000006`3oool200000140
oooo00<000000?ooo`3oool0303oool2000000/0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00/0oooo000>0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo
0P00000A0?ooo`800000703oool6000001@0oooo00<000000?ooo`3oool04`3oool5000001d0oooo
0P00000A0?ooo`8000003P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`003`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo0100oooo0P00000P0?ooo`D000003`3oool2000000l0oooo1@00
000P0?ooo`8000004P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00d0oooo000?
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0:
0?ooo`8000003P3oool200000180oooo0`00000R0?ooo`P000001`3oool00`000000oooo0?ooo`05
0?ooo`T000008`3oool200000180oooo0P00000>0?ooo`800000303oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool03P3oool000L0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01<0oooo0P00000<0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool04P3oool2000002P0oooo3`00000Z0?oo
o`8000004`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00X0oooo0P00000D0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool2000000L0oooo00080?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool2000001@0oooo0`00000/0?ooo`03
0000003oool0oooo02`0oooo0`00000C0?ooo`8000003`3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00L0oooo00090?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00X0oooo0P00000?0?ooo`800000
5@3oool3000002T0oooo00<000000?ooo`3oool0:@3oool3000001@0oooo0P00000?0?ooo`800000
303oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`070?ooo`002@3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool05@3oool2000001l0oooo00@0j[Yb00000000000009_D
103oool00`000000oooo0?ooo`0V0?ooo`<000005P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0203oool000X0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool02`3o
ool2000000l0oooo0P00000G0?ooo`<000006`3oool01P3oj[X0LW:j0?ooo`3oom@0V`1b0;[Zo`<0
oooo00<000000?ooo`3oool08`3oool3000001L0oooo0P00000?0?ooo`8000003@3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`090?ooo`002`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo
0P00000H0?ooo`<000006P3oool00`3DV`00000009_Do`040?ooo`<00000803oool3000001P0oooo
0P00000@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02P3oool000`0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool0303oool200000100oooo0P00000I0?ooo`<000003`3oool00`3oe9/000000000
00020000000609_Do`3oool0oooo0?ooo`3oom@0Vg:j103oool00`000000oooo0?ooo`0L0?ooo`@0
00006@3oool200000100oooo0P00000>0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo000<0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0I0?ooo`<00000
4P3oool01P3oom@0V`1b0;[Zo`3oom@0V`2K0=Coo`<0oooo00<000000?ooo`3oool0603oool40000
01/0oooo0P00000A0?ooo`030000003oool0oooo00`0oooo0P00000F0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0;0?ooo`003@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0503oool2000000h0
oooo0P00000@0?ooo`800000703oool300000100oooo00@0onZj078000000000VmCo103oool00`00
0000oooo0?ooo`0D0?ooo`@000007@3oool200000140oooo0P00000>0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00`0oooo000>0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0E0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03`3oool2000001d0
oooo1000000D0?ooo`030000003oool0oooo0140oooo0`00000O0?ooo`8000004P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00d0oooo000?0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00d0oooo
0P00000A0?ooo`8000007`3oool8000000`0oooo00<000000?ooo`3oool02`3oool600000200oooo
0P00000B0?ooo`8000003P3oool2000001L0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00d0oooo00070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0@0?ooo`8000009@3ooolJ000002@0oooo0P00
000C0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`050?ooo`00203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00h0oooo0P00000B
0?ooo`800000;`3oool2000002d0oooo0`00000C0?ooo`8000003`3oool00`000000oooo0?ooo`0F
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00H0oooo00080?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01H0oooo0P00000@0?oo
o`030000003oool0oooo0140oooo0`00000/0?ooo`030000003oool0oooo02X0oooo0P00000E0?oo
o`030000003oool0oooo00d0oooo0P00000I0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00090?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool03P3oool2000001@0oooo0P00000Z0?ooo`03
0000003oool0oooo02P0oooo0P00000E0?ooo`8000003`3oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00L0oooo000:0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0C0?ooo`800000:03oool00`000000oooo0?ooo`0U0?ooo`<00000
5P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
203oool000X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0?0?ooo`8000005@3o
ool2000002H0oooo00<000000?ooo`3oool08`3oool2000001L0oooo0P00000@0?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0203oool000/0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05`3oool2
00000140oooo00<000000?ooo`3oool0503oool2000002@0oooo00<000000?ooo`3oool0803oool3
000001P0oooo00<000000?ooo`3oool03P3oool2000001X0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool0
00`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0?0?ooo`8000005P3oool40000
0200oooo00<000000?ooo`3oool07@3oool3000001T0oooo0P00000@0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool02P3oool000`0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo01L0oooo1@00000K0?ooo`8000006`3oool3000001/0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00/0
oooo000=0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo01P0oooo0P00000A0?ooo`800000703oool3000001P0oooo
00<000000?ooo`3oool05`3oool3000001`0oooo0P00000A0?ooo`030000003oool0oooo01X0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool02`3oool000d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`0@0?ooo`8000007@3oool3000001D0oooo00<000000?ooo`3oool04`3oool4000001d0oooo0P00
000B0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0303oool000h0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01d0oooo0`00000B
0?ooo`030000003oool0oooo00h0oooo1@00000O0?ooo`8000004P3oool2000001`0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool03@3oool000l0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool06P3oool200000180oooo0P00000P0?oo
o`P000002P3oool00`000000oooo0?ooo`080?ooo`H000008P3oool2000001<0oooo00<000000?oo
o`3oool06`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0=0?ooo`001`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo01/0oooo00<000000?ooo`3oool04@3oool2000002H0oooo5@00000V0?ooo`80
0000503oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01@3oool000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0K0?ooo`030000
003oool0oooo0180oooo0P00000^0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1P3oool000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0K0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool0:`3oool2000002`0oooo0P00000D0?ooo`8000007@3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00090?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool06`3oool2000001@0oooo0P00000[0?ooo`030000003oool0
oooo02T0oooo0P00000E0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`070?ooo`002@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool04`3oool2000002T0oooo00<000000?ooo`3oool09`3oool20000
01H0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00L0oooo000:0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0D0?ooo`8000009`3oool00`000000oooo0?ooo`0U0?ooo`8000005`3oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool000X0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo01D0oooo
0P00000U0?ooo`030000003oool0oooo02<0oooo0P00000H0?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`002`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool05P3oool2000002<0oooo00<0
00000?ooo`3oool0803oool3000001P0oooo0P00000O0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool02@3oool000/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0M
0?ooo`800000603oool200000240oooo00<000000?ooo`3oool07P3oool2000001X0oooo00<00000
0?ooo`3oool07P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo000<0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0G0?oo
o`<000007P3oool2000001d0oooo0P00000K0?ooo`030000003oool0oooo01h0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`00303oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo01h0oooo00<000000?ooo`3oool06@3oool3000001/0oooo00<000000?ooo`3o
ool06@3oool3000001/0oooo0P00000P0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool02`3oool000d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0O0?ooo`800000
703oool3000001P0oooo00<000000?ooo`3oool05`3oool2000001d0oooo00<000000?ooo`3oool0
7`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00/0oooo000>0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0L0?ooo`<000005@3o
ool00`000000oooo0?ooo`0C0?ooo`@000007@3oool200000240oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0<0?ooo`003P3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo0200oooo0P00000O0?ooo`<000004P3oool00`000000oooo0?ooo`0>0?ooo`D00000803oool0
0`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03@3oool0
00l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo
01l0oooo1P0000030?ooo`060?oDV`00000000000000000009/0e?oo0`3oool00`000000oooo0?oo
o`0;0?ooo`<000008`3oool2000002<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0=0?ooo`003`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0240oooo0P00000U
0?ooo`T000000`3oool010000000oooo0?ooo`3oool:000002D0oooo00<000000?ooo`3oool08P3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00h0oooo000@0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0W0?ooo`040?oDV`000000
VmCo0?ooo`L00000;@3oool2000002@0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0>0?ooo`00403oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0280oooo0P00000O
0?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3oool0oooo0?ooe03De?l40?ooo`030000
003oool0oooo02d0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00l0oooo000A0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`0R0?ooo`060?oZ^P1bL[X0oooo0?ooe02K09/0e?oo0`3oool00`000000
oooo0?ooo`0[0?ooo`8000009@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00l0
oooo000A0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0903oool2000002<0oooo
00@0j[Yb000000000000L[[Z103oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo02@0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0@0?ooo`004P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0:03oool00`000000oooo
0?ooo`0X0?ooo`8000009P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0140oooo
000C0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool09@3oool2000002P0oooo00<0
00000?ooo`3oool09`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0V
0?ooo`8000009P3oool2000002H0oooo0P00000X0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool04P3oool001@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0W0?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0W0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool04P3oool001@0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0X0?ooo`8000008`3oool00`000000oooo0?ooo`0R0?ooo`80
0000:@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01<0oooo000E0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0P0?ooo`030000
003oool0oooo0200oooo0P00000Z0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
4`3oool001D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0Y0?ooo`800000803o
ool00`000000oooo0?ooo`0N0?ooo`800000:`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo01@0oooo000F0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0:P3oool2
000001h0oooo00<000000?ooo`3oool0703oool2000002d0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`0D0?ooo`005P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
02/0oooo0P00000L0?ooo`030000003oool0oooo01X0oooo0P00000^0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool05@3oool001L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0]0?ooo`8000006P3oool2000001T0oooo0P00000_0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool05@3oool001L0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0^0?ooo`800000603oool00`000000oooo0?ooo`0F0?ooo`800000<03oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo01H0oooo000H0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0;`3oool3000001D0oooo00<000000?ooo`3oool0503oool200000340oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`00603oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo0340oooo0`00000B0?ooo`030000003oool0oooo0180oooo0P00000c
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05P3oool001T0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0c0?ooo`@000003P3oool00`000000oooo0?ooo`0=0?oo
o`D00000=03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01L0oooo000I0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0=`3oool4000000X0oooo00<000000?ooo`3o
ool0203oool5000003P0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0G0?ooo`00
6P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03X0oooo1`0000030?ooo`030000
003oool0oooo0080oooo1P00000l0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
603oool001X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0o0?ooo`T00000@P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01P0oooo000K0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`130?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0603oool001/0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`120?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0I0?ooo`00703oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0440
oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01T0
oooo000L0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0@03oool00`000000oooo
0?ooo`110?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool06P3oool001`0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0400oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0J0?ooo`007@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo01X0oooo000M0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0?P3oool200000400oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0K0?oo
o`007@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3o
ool0?P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01/0oooo000N0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0n0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool0703oool001h0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0L0?ooo`007P3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo03`0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo01`0oooo000O0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0<P3oool01P3o
om@0V`00000000000000001b0;[Zo`<0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo01d0oooo000O0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool0=03oool00`3oe9/0L[[Z0?ooo`040?ooo`030000003oool0oooo03/0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0M0?ooo`007`3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo03<0oooo00<0omBK07:jjP3oool0103oool3000003X0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0M0?ooo`007`3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo02X0oooo00<0omBK0000000000000P0000001@2Ke?l0oooo0?ooo`3oe9/0L[[Z
00D0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
01d0oooo000P0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0<@3oool00`2jLY/0
e=BK07:jjP050?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0N0?ooo`00803oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0300oooo
00<0omBK0000001b^^X01@3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool07P3oool00200oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0h0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0N0?ooo`00803oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03L0oooo00<00000
0?ooo`3oool0>03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01h0oooo000Q0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0g0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool07`3oool00240oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0f0?ooo`800000>03oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo01l0oooo000Q0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
=P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
7`3oool00280oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0e0?ooo`030000003o
ool0oooo03H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0P0?ooo`008P3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0=@3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo0200oooo000R0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0803oool00280oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0d0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0P0?ooo`008P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03<0oooo
00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0240oooo
000S0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0<`3oool2000003@0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0Q0?ooo`008`3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo0240oooo000S0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0<P3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool08P3oool002<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0a0?ooo`03
0000003oool0oooo0380oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0R0?ooo`00
8`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0
<P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0280oooo000S0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0b0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool08P3oool002<0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0a0?ooo`800000<`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo0280oooo000T0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0<@3oool00`00
0000oooo0?ooo`0a0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool08P3oool000T0
oooo00@0j[Yb000000000780^^[o5`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool03@3oool00`000000omBK00000002000000030000V`3Dool0oooo
00`0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo
00d0oooo00<0omBK0000000000000P0000000`3Dool0oooo0?ooo`0<0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0I0?ooo`040>ZjLP000000001b
0;[Zo`D0oooo000:0?ooo`030?oDV`1b^^X0oooo01L0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00d0oooo00D000000?ooo`2jLP00002K0=Coo`0?
0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0>
0?ooo`040;Yb000009/0e?oo000000l0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo01/0oooo00<0omBK07:jjP3oool01@3oool000L0oooo00H0oooD
09/00000000000000000LP2jj_lG0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0=0?ooo`060000003oool0oooo0?oDV`000000VmCo3P3oool00`00
0000oooo0?ooo`0`0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0403oool00`3o
e9/000000000000>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0H0?ooo`060?ooe02K00000000000000000780^^[o1@3oool000030?ooo`3oe9/0
000000<0000000H0VmCo0?ooo`3DV`00VmCo0?oDV`1b^^XH0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030?oDV`000000000000<00000
0`3oool00`3oom@0e=Co0?ooo`0=0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0
<03oool00`000000oooo0?ooo`0A0?ooo`030?ooe0000000oooo00d0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01T0oooo00@0e9/009_Do`3oe9/0
L[[Z1P3oool000P0oooo00@0oooD09/0LP2j^Y/0L[[Z603oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool01`000000onZj079b^P3oool0oooD
09/0V`3Dool03P3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0300oooo00<00000
0?ooo`3oool03P3oool01P3oj[X0LW:j0?ooo`000000V`2K0=Coo`d0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01T0oooo00@0oooD09/0LP2j^Y/0
L[[Z1P3oool000T0oooo00<0onZj0780001b^^X0603oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool00`000000oooo0>ZjLP020000000307:j
jP3oool0oooo00d0oooo00<000000?ooo`3oool0;`3oool200000340oooo00<000000?ooo`3oool0
3`3oool0103Z^W8000000000001b^^X>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0J0?ooo`030?oZ^P1b0000L[[Z00H0oooo000T0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0`0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool08`3oool002D0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0S0?ooo`009@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo02l0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo02<0oooo000U0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0;`3oool00`00
0000oooo0?ooo`0R0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0S0?ooo`009@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0640
oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0;`3oool009@0oooo00<000000?ooo`3oool0;`3oool00`000000oooo
0?ooo`1Q0?ooo`00o`00000[000000001`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo00D0oooo00070?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0@`3oool00`00
0000oooo0?ooo`140?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool01@3oool009@0
oooo00<000000?ooo`3oool0T`3oool009@0oooo00<000000?ooo`3oool0T`3oool00001\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {646.313, 499.75}} -> {-9.07237, \
13.0295, 0.0283373, 0.0292243}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["G2=Show[obl3,obl4]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.0147151 0.115435 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.7381 .00222 -3 -9 ]
[.7381 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.4875 .13015 -6 -4.5 ]
[.4875 .13015 0 4.5 ]
[.4875 .24558 -6 -4.5 ]
[.4875 .24558 0 4.5 ]
[.4875 .36102 -6 -4.5 ]
[.4875 .36102 0 4.5 ]
[.4875 .47645 -6 -4.5 ]
[.4875 .47645 0 4.5 ]
[.4875 .59189 -6 -4.5 ]
[.4875 .59189 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-4)] .02381 .00222 0 1 Mshowa
.2619 .01472 m
.2619 .02097 L
s
[(-2)] .2619 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(2)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(4)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.08333 .01472 m
.08333 .01847 L
s
.14286 .01472 m
.14286 .01847 L
s
.20238 .01472 m
.20238 .01847 L
s
.32143 .01472 m
.32143 .01847 L
s
.38095 .01472 m
.38095 .01847 L
s
.44048 .01472 m
.44048 .01847 L
s
.55952 .01472 m
.55952 .01847 L
s
.61905 .01472 m
.61905 .01847 L
s
.67857 .01472 m
.67857 .01847 L
s
.79762 .01472 m
.79762 .01847 L
s
.85714 .01472 m
.85714 .01847 L
s
.91667 .01472 m
.91667 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .13015 m
.50625 .13015 L
s
[(1)] .4875 .13015 1 0 Mshowa
.5 .24558 m
.50625 .24558 L
s
[(2)] .4875 .24558 1 0 Mshowa
.5 .36102 m
.50625 .36102 L
s
[(3)] .4875 .36102 1 0 Mshowa
.5 .47645 m
.50625 .47645 L
s
[(4)] .4875 .47645 1 0 Mshowa
.5 .59189 m
.50625 .59189 L
s
[(5)] .4875 .59189 1 0 Mshowa
.125 Mabswid
.5 .0378 m
.50375 .0378 L
s
.5 .06089 m
.50375 .06089 L
s
.5 .08398 m
.50375 .08398 L
s
.5 .10706 m
.50375 .10706 L
s
.5 .15324 m
.50375 .15324 L
s
.5 .17632 m
.50375 .17632 L
s
.5 .19941 m
.50375 .19941 L
s
.5 .2225 m
.50375 .2225 L
s
.5 .26867 m
.50375 .26867 L
s
.5 .29176 m
.50375 .29176 L
s
.5 .31485 m
.50375 .31485 L
s
.5 .33793 m
.50375 .33793 L
s
.5 .38411 m
.50375 .38411 L
s
.5 .40719 m
.50375 .40719 L
s
.5 .43028 m
.50375 .43028 L
s
.5 .45337 m
.50375 .45337 L
s
.5 .49954 m
.50375 .49954 L
s
.5 .52263 m
.50375 .52263 L
s
.5 .54571 m
.50375 .54571 L
s
.5 .5688 m
.50375 .5688 L
s
.5 .61498 m
.50375 .61498 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .44663 m
.06244 .40633 L
.10458 .36165 L
.14415 .3187 L
.18221 .27607 L
.22272 .22835 L
.26171 .17823 L
.28326 .14707 L
.30316 .11362 L
.31304 .09354 L
.3223 .06984 L
.32481 .06169 L
.3271 .05288 L
.32832 .0473 L
.32965 .0399 L
.33038 .03475 L
.33105 .02835 L
s
.66843 .01959 m
.66859 .02325 L
.66928 .03179 L
.66992 .03698 L
.67137 .04573 L
.67378 .05648 L
.67597 .06437 L
.68089 .07886 L
.70244 .12372 L
.74229 .18366 L
.78227 .2344 L
.82073 .27942 L
.86165 .32508 L
.90106 .36768 L
.93894 .40778 L
.97619 .44663 L
s
.02381 .41459 m
.06244 .37068 L
.10458 .32084 L
.14415 .27115 L
.18221 .21881 L
.20342 .18618 L
.22272 .15252 L
.23233 .13331 L
.24276 .10914 L
.24754 .0961 L
.25261 .07984 L
.25694 .0621 L
.25813 .056 L
.2594 .04827 L
.26061 .03884 L
.26171 .02406 L
s
.73849 .02803 m
.73955 .04031 L
.74072 .04909 L
.74197 .05651 L
.74683 .07781 L
.75552 .10463 L
.7751 .14834 L
.8153 .21515 L
.8568 .27239 L
.89678 .32249 L
.93525 .36801 L
.97617 .41457 L
.97619 .41459 L
s
.02381 .37975 m
.06244 .33104 L
.10458 .27367 L
.14415 .21247 L
.16408 .17642 L
.18221 .13721 L
.19227 .11004 L
.19689 .09493 L
.20178 .07528 L
.20426 .06247 L
.20568 .05341 L
.20636 .04821 L
.207 .0424 L
.20821 .02469 L
s
.79167 .02086 m
.79183 .0257 L
.79254 .03741 L
.79322 .04451 L
.79457 .05513 L
.79603 .06417 L
.80106 .08729 L
.81095 .1194 L
.82007 .14266 L
.85782 .21579 L
.89722 .27626 L
.93511 .32785 L
.97545 .37885 L
.97619 .37975 L
s
.02381 .34121 m
.06244 .28566 L
.10458 .21574 L
.1253 .17411 L
.14415 .12633 L
.15367 .09328 L
.15639 .0811 L
.15891 .06753 L
.16003 .06017 L
.16128 .05039 L
.16253 .03658 L
.16321 .02137 L
s
.83683 .02316 m
.83802 .04351 L
.83871 .05033 L
.83937 .05574 L
.84058 .06434 L
.84332 .07968 L
.84824 .10087 L
.85942 .13662 L
.87826 .18183 L
.89869 .22172 L
.93961 .28876 L
.97619 .34121 L
s
.02381 .29747 m
.06244 .23095 L
.08426 .18576 L
.09408 .16193 L
.10458 .13201 L
.10966 .11473 L
.11447 .09533 L
.11878 .07292 L
.11996 .06513 L
.12122 .05531 L
.12229 .0445 L
.12347 .02189 L
s
.87666 .02669 m
.87779 .04546 L
.87904 .05748 L
.8804 .06766 L
.88316 .08388 L
.88811 .10621 L
.89929 .14374 L
.91976 .19475 L
.93891 .23352 L
.97619 .29747 L
s
.02381 .60332 m
.06244 .57441 L
.10458 .54411 L
.14415 .51702 L
.18221 .49242 L
.22272 .46808 L
.26171 .44673 L
.30316 .42664 L
.34309 .41019 L
.3815 .39741 L
.40095 .39218 L
.42237 .38743 L
.44268 .38396 L
.45178 .38273 L
.46172 .38163 L
.4671 .38114 L
.4721 .38075 L
.47727 .38042 L
.48196 .38017 L
.48658 .37998 L
.4887 .37992 L
.49093 .37986 L
.49332 .37981 L
.49438 .37979 L
.49552 .37978 L
.49675 .37977 L
.49789 .37976 L
.49859 .37975 L
.49925 .37975 L
.50049 .37975 L
.50163 .37976 L
.50286 .37976 L
.50401 .37977 L
.50508 .37978 L
.50754 .37982 L
.51014 .37988 L
.51268 .37996 L
.51504 .38004 L
.5204 .38029 L
.5293 .38086 L
.53882 .38169 L
.54906 .38284 L
.56016 .38438 L
.58032 .38797 L
.62123 .39821 L
.66064 .41159 L
.69852 .4274 L
.73886 .44703 L
.77769 .46832 L
.81897 .49316 L
Mistroke
.85873 .51894 L
.89697 .5452 L
.93767 .5745 L
.97619 .60332 L
Mfstroke
.02381 .58023 m
.06244 .55008 L
.10458 .51831 L
.14415 .48975 L
.18221 .46367 L
.22272 .43767 L
.26171 .4147 L
.30316 .39291 L
.34309 .37493 L
.3815 .36084 L
.40095 .35505 L
.42237 .34978 L
.44268 .34591 L
.45178 .34454 L
.46172 .34332 L
.4671 .34277 L
.4721 .34233 L
.47727 .34196 L
.48196 .34168 L
.48658 .34147 L
.4887 .3414 L
.49093 .34133 L
.49332 .34128 L
.49438 .34126 L
.49552 .34124 L
.49675 .34123 L
.49789 .34122 L
.49859 .34122 L
.49925 .34121 L
.50049 .34121 L
.50163 .34122 L
.50286 .34123 L
.50401 .34124 L
.50508 .34125 L
.50754 .3413 L
.51014 .34136 L
.51268 .34145 L
.51504 .34154 L
.5204 .34181 L
.5293 .34245 L
.53882 .34338 L
.54906 .34466 L
.56016 .34638 L
.58032 .35037 L
.62123 .36173 L
.66064 .37647 L
.69852 .39374 L
.73886 .41502 L
.77769 .43792 L
.81897 .46445 L
Mistroke
.85873 .49178 L
.89697 .51946 L
.93767 .55016 L
.97619 .58023 L
Mfstroke
.02381 .55615 m
.06244 .52458 L
.10458 .49112 L
.14415 .46082 L
.18221 .43293 L
.22272 .4049 L
.26171 .37987 L
.30316 .35586 L
.34309 .33581 L
.3815 .31993 L
.40095 .31334 L
.42237 .30732 L
.44268 .30288 L
.45178 .30131 L
.46172 .2999 L
.4671 .29927 L
.4721 .29876 L
.47727 .29833 L
.48196 .29801 L
.48658 .29777 L
.4887 .29768 L
.49093 .29761 L
.49332 .29755 L
.49438 .29752 L
.49552 .2975 L
.49675 .29749 L
.49789 .29748 L
.49859 .29747 L
.49925 .29747 L
.50049 .29747 L
.50163 .29748 L
.50286 .29748 L
.50401 .2975 L
.50508 .29751 L
.50754 .29757 L
.51014 .29764 L
.51268 .29774 L
.51504 .29785 L
.5204 .29816 L
.5293 .2989 L
.53882 .29997 L
.54906 .30145 L
.56016 .30343 L
.58032 .308 L
.62123 .32093 L
.66064 .33754 L
.69852 .35678 L
.73886 .38022 L
.77769 .40517 L
.81897 .43377 L
Mistroke
.85873 .46298 L
.89697 .49233 L
.93767 .52467 L
.97619 .55615 L
Mfstroke
.02381 .53095 m
.06244 .49774 L
.10458 .46228 L
.14415 .42988 L
.18221 .39975 L
.22272 .3691 L
.26171 .34135 L
.30316 .31427 L
.34309 .29121 L
.3815 .2726 L
.40095 .26477 L
.42237 .25755 L
.44268 .25218 L
.45178 .25027 L
.46172 .24855 L
.4671 .24778 L
.4721 .24716 L
.47727 .24663 L
.48196 .24625 L
.48658 .24595 L
.4887 .24584 L
.49093 .24575 L
.49332 .24568 L
.49438 .24565 L
.49552 .24563 L
.49675 .24561 L
.49789 .24559 L
.49859 .24559 L
.49925 .24559 L
.50049 .24558 L
.50163 .24559 L
.50286 .2456 L
.50401 .24562 L
.50508 .24564 L
.50754 .2457 L
.51014 .24579 L
.51268 .24591 L
.51504 .24604 L
.5204 .24643 L
.5293 .24733 L
.53882 .24863 L
.54906 .25043 L
.56016 .25284 L
.58032 .25837 L
.62123 .27379 L
.66064 .29322 L
.69852 .31531 L
.73886 .34174 L
.77769 .3694 L
.81897 .40067 L
Mistroke
.85873 .4322 L
.89697 .46357 L
.93767 .49783 L
.97619 .53095 L
Mfstroke
.02381 .50446 m
.06244 .46931 L
.10458 .43144 L
.14415 .39643 L
.18221 .36343 L
.22272 .32926 L
.26171 .29763 L
.30316 .26588 L
.34309 .23788 L
.3815 .21435 L
.40095 .20412 L
.42237 .19448 L
.44268 .18717 L
.46172 .18213 L
.46668 .18113 L
.4721 .18019 L
.47687 .1795 L
.48196 .1789 L
.48456 .17865 L
.487 .17845 L
.48938 .17829 L
.49157 .17817 L
.49365 .17808 L
.49472 .17804 L
.49585 .17801 L
.497 .17799 L
.49806 .17798 L
.49933 .17797 L
.50049 .17797 L
.50167 .17797 L
.50277 .17799 L
.50399 .17801 L
.5053 .17805 L
.50659 .17809 L
.50796 .17815 L
.5104 .17828 L
.51478 .17859 L
.51957 .17906 L
.52477 .17972 L
.53033 .18059 L
.54033 .18258 L
.56168 .18858 L
.58183 .19623 L
.6203 .21536 L
.66122 .24074 L
.70062 .26867 L
.73851 .2978 L
.77885 .33056 L
.81767 .36333 L
.85895 .39915 L
Mistroke
.89871 .43438 L
.93695 .46877 L
.97619 .50446 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`003`3oool0103Z^W8000000000LP2jj_ln0?ooo`060?oDV`00000000000000000009/0e?oo
OP3oool01P3oe9/00000000000000000002K0=Coocl0oooo00@0j[Yb000000000780^^[o303oool0
0100oooo00<0omBK07:jjP3oool0?`3oool00`2jLP00002K0=Coo`210?ooo`030;Yb000009/0e?oo
0480oooo00<0omBK07:jjP3oool0303oool000d0oooo00H0oooD09/00000000000000000LP2jj_m0
0?ooo`030?oDV`000000VmCo0840oooo00<0omBK0000002Ke?l0?P3oool01P3oom@0V`0000000000
0000001b0;[Zo``0oooo00070?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3DV`00VmCo
0?oDV`1b^^Xi0?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3oool0oooo0?ooe03De?n2
0?ooo`030?ooe03De?l0oooo03h0oooo00@0e9/009_Do`3oe9/0L[[Z3@3oool000h0oooo00@0oooD
09/0LP2j^Y/0L[[Z?`3oool01P3oj[X0LW:j0?ooo`3oom@0V`2K0=Coogh0oooo00H0onZj079b^P3o
ool0oooD09/0V`3Dooln0?ooo`040?ooe02K0780^[ZK07:jjPd0oooo000?0?ooo`030?oZ^P1b0000
L[[Z0400oooo00@0j[Yb000000000000L[[ZP03oool0103Z^W8000000000001b^^Y00?ooo`030?oZ
^P1b0000L[[Z00d0oooo003o0?ooob/0oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?oo
o`030000003oool0oooo09<0oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?ooo`030000
003oool0oooo09<0oooo002D0?ooo`030000003oool0oooo09<0oooo00070?ooool000007@000007
0?ooo`003@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool02`3oool010000000oooo0?ooo`00000@0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`000000403oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool0303oool002X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo0200oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0c0?oo
o`00:P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3o
ool0;@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02P0oooo000Z0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0]0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool0:03oool002T0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo02d0oooo0P00000^0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0:03oool0
02T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo
02d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0;P3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo02P0oooo000Y0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0:03oool002T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0^0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0X0?ooo`00:@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo02h0oooo00<00000
0?ooo`3oool0;`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02L0oooo000Y0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0_0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool09`3oool002T0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0^0?ooo`800000<03oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo02L0oooo000Y0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
;`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
9`3oool002P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0_0?ooo`030000003o
ool0oooo02l0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0W0?ooo`00:03oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0<03oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo02L0oooo000X0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool09`3oool002P0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0`0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0V0?ooo`009`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0340oooo
0P00000b0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool09P3oool002L0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0380oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0V0?ooo`009`3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo02H0oooo000W0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool0<P3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool09P3oool002L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0b0?ooo`03
0000003oool0oooo03<0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0U0?ooo`00
9`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0
=03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02D0oooo000V0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0d0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool09@3oool002H0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0c0?ooo`800000=P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo02D0oooo000V0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0=03oool00`00
0000oooo0?ooo`0e0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0903oool002H0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo03H0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0T0?ooo`009P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0=P3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo02@0oooo000U0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool0;03oool01P3oom@0V`00000000000000001b0;[Zo`<0oooo00<000000?ooo`3o
ool0=`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo02@0oooo000U0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool0;`3oool00`3oe9/0L[[Z0?ooo`040?ooo`030000
003oool0oooo03P0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0S0?ooo`00903o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0300oooo00<0omBK07:jjP3oool0103o
ool3000003P0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0S0?ooo`00903oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0300oooo00<0omBK07:jjP3oool0103oool0
0`000000oooo0?ooo`0i0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool08`3oool0
02@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0`0?ooo`030;YbV`3De9/0L[[Z
00D0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
02<0oooo000S0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0<@3oool00`3oe9/0
000007:jjP050?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0R0?ooo`008`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03T0oooo
00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0280oooo
000R0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?oo
o`0l0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool08P3oool00280oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo03`0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0Q0?ooo`008P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo03/0oooo0P00000n0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool08@3oool00240oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0l0?ooo`03
0000003oool0oooo03d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0P0?ooo`00
8@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0
?P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0200oooo000Q0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0o0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0803oool00200oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0n0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0O0?ooo`00803oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
03l0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
01l0oooo000P0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0?`3oool200000480
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0N0?ooo`00803oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo03P0oooo4000000l0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool07P3oool001l0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0d0?ooo`D00000203oool00`000000oooo0?ooo`050?ooo`H00000=`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo01h0oooo000O0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0<@3oool4000000d0oooo00<000000?ooo`3oool02`3oool3000003D0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0M0?ooo`007P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo02h0oooo0`00000A0?ooo`030000003oool0oooo00h0oooo0`00000b0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool07@3oool001h0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0]0?ooo`800000503oool00`000000oooo0?ooo`0A0?ooo`<0
0000<03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01`0oooo000M0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0;03oool2000001H0oooo00<000000?ooo`3oool0
503oool2000002l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0L0?ooo`007@3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02/0oooo0P00000H0?ooo`8000005`3o
ool2000002h0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0K0?ooo`00703oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02X0oooo0P00000J0?ooo`030000003oool0
oooo01P0oooo0P00000/0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool06`3oool0
01`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0X0?ooo`800000703oool00`00
0000oooo0?ooo`0J0?ooo`800000:`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
01X0oooo000K0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool09`3oool2000001h0
oooo00<000000?ooo`3oool0703oool2000002X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0J0?ooo`006`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02L0oooo
00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0N0?ooo`800000:@3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo01T0oooo000J0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool09P3oool200000240oooo00<000000?ooo`3oool0803oool2000002L0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0I0?ooo`006P3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool08@3oool2000002<0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01P0oooo000I0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0903oool2000002@0oooo00<000000?oo
o`3oool08`3oool2000002H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0H0?oo
o`006@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02<0oooo0P00000V0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo01L0oooo000H0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
8`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo0P00000T0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool05`3oool001L0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0R0?ooo`800000:@3oool00`000000oooo0?ooo`0X0?ooo`030000003o
ool0oooo0280oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0F0?ooo`005`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0803oool0
1P3oe9/00000000000000000002K0=Coo`<0oooo00<000000?ooo`3oool0:@3oool2000002<0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo0200oooo0P00000T0?ooo`030;Yb000009/0e?oo00D0oooo00<0
00000?ooo`3oool0:`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0oooo02@0oooo4P00000U0?ooo`8000008P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0803oool00`000000oooo0?ooo`0O0?ooo`H000000P3oool00`3oom@0e=Co0?ooo`030?oo
o`030000003oool0oooo00L0oooo1P00000Q0?ooo`030000003oool0oooo01l0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0D0?ooo`005@3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo01l0oooo0P00000N0?ooo`@000001@3oool01P3oj[X0LW:j0?ooo`3oom@0V`2K
0=Coo`<0oooo00<000000?ooo`3oool03@3oool3000001l0oooo00<000000?ooo`3oool07`3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo01<0oooo000D0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0I0?ooo`D000002P3oool0103Z
^W8000000000001b^^X40?ooo`030000003oool0oooo0100oooo0`00000M0?ooo`800000803oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo01<0oooo000C0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0G0?ooo`<000005`3oool00`00
0000oooo0?ooo`0C0?ooo`<00000703oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool04P3oool001<0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0N0?ooo`800000603oool2000001X0oooo00<000000?ooo`3oool05P3oool3000001X0
oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0180
oooo000B0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`0F0?ooo`800000703oool00`000000oooo0?ooo`0I0?ooo`<00000603oool2000001l0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0A0?ooo`004P3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool05@3oool2000001h0oooo0P00
000M0?ooo`<000005`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool0403oool00140oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0L
0?ooo`8000005P3oool200000200oooo00<000000?ooo`3oool07`3oool3000001D0oooo0P00000M
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0403oool00100oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo01@0oooo0P00000R0?oo
o`030000003oool0oooo0280oooo0P00000E0?ooo`030000003oool0oooo01/0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0?0?ooo`00403oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo01`0oooo00<000000?ooo`3oool04`3oool2000002@0oooo00<000000?ooo`3o
ool0903oool2000001@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00l0oooo000?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
6`3oool2000001@0oooo0P00000V0?ooo`030000003oool0oooo02H0oooo0P00000C0?ooo`800000
703oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00h0oooo000?0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0B0?ooo`800000:03o
ool00`000000oooo0?ooo`0X0?ooo`8000004`3oool00`000000oooo0?ooo`0J0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool03P3oool000h0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0140oooo0P00000Z0?ooo`800000:`3oool2
00000180oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00d0oooo000>0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool06P3oool20000
0180oooo0P00000/0?ooo`030000003oool0oooo02`0oooo0P00000A0?ooo`8000006`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo000=0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0@0?ooo`8000008`3ooolH000002@0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0303oool001D0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0?0?ooo`8000007P3oool7000000/0oooo00<000000?ooo`3oool02P3oool6000001l0oooo
0P00000A0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool04`3oool001@0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0603oool200000100oooo0P00000K0?ooo`D000004P3oool00`000000oooo0?oo
o`0@0?ooo`<000007P3oool200000100oooo0P00000J0?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01<0oooo000C
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool03P3oool2000001X0oooo0`00000G
0?ooo`030000003oool0oooo01<0oooo0`00000M0?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0B0?ooo`004P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool05`3oool3000001X0oooo00<000000?oo
o`3oool05P3oool4000001X0oooo0P00000@0?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool04@3oool00180oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0=0?ooo`80
0000603oool2000001d0oooo0P00000K0?ooo`@00000603oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool04@3oool00140oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01D0oooo0`00000O0?ooo`030000
003oool0oooo01h0oooo1000000E0?ooo`8000003`3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo0100oooo000@0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo0P00000>0?ooo`8000005P3o
ool200000280oooo00<000000?ooo`3oool08P3oool2000001D0oooo00<000000?ooo`3oool03@3o
ool2000001T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool03`3oool00100oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01@0oooo0P00000T0?ooo`030000003oool0
oooo02@0oooo0P00000D0?ooo`8000003`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00l0oooo000?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0303oool20000
01D0oooo0P00000V0?ooo`030000003oool0oooo02H0oooo0P00000D0?ooo`8000003P3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00h0oooo000>0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0C0?ooo`800000:03oool00`000000
oooo0?ooo`0X0?ooo`800000503oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool03@3oool000h0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05P3oool2000000d0oooo
0P00000C0?ooo`<00000:P3oool2000002/0oooo0`00000B0?ooo`8000003@3oool2000001L0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool03@3oool000d0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo0140oooo0P00000T0?oooa<000009P3oool200000180oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo000E
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo00/0oooo0P00000B0?ooo`8000007@3oool9000000T0oooo00<00000
0?ooo`3oool01`3oool600000280oooo0P00000A0?ooo`8000003@3oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0C
0?ooo`00503oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0503oool2000000d0oooo00<000000?ooo`3oool0403oool2000001X0oooo1@00000B0?oo
o`030000003oool0oooo00d0oooo1000000P0?ooo`8000004@3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo01D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo01<0oooo000C0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool03`3oool2000001T0oooo0`00000G0?ooo`030000003oool0oooo0140oooo1@00000M0?ooo`80
0000403oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0180oooo000B0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo00/0oooo0P00000@0?ooo`800000603oool300000180oooo00@0j[Yb000000000000
09_D103oool00`000000oooo0?ooo`0F0?ooo`@000006`3oool2000000l0oooo0P00000<0?ooo`80
00005P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool04@3oool00180oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo01<0oooo0P00000=0?ooo`030000003oool0oooo00h0oooo0P00000H0?ooo`800000
503oool01P3oj[X0LW:j0?ooo`3oom@0V`1b0;[Zo`<0oooo00<000000?ooo`3oool06P3oool40000
01T0oooo0P00000?0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0403oool00140
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`8000005`3oool3000001P0
oooo00<0e9/00000002Ke?l0103oool3000001h0oooo1000000G0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0@0?ooo`00403oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`0;0?ooo`8000003`3oool00`000000oooo0?ooo`0D0?ooo`<00000703oool00`3oom@0Vg:j
0?ooo`030?ooo`030000003oool0oooo0280oooo0`00000E0?ooo`8000003P3oool2000000`0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool03`3oool000l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0=0?ooo`8000005@3oool2000001`0oooo00H0oooD09/0LP2jj_l0oooD09/0V`3Dool30?ooo`03
0000003oool0oooo02D0oooo0P00000E0?ooo`8000003P3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00h0oooo000?0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool2000001@0oooo0`00000O0?ooo`040?oZ^P1b0000000009_Do`@0oooo00<000000?ooo`3o
ool09`3oool3000001@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`80
0000503oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool03@3oool000h0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool02P3oool2000000d0oooo0P00000C0?ooo`<00000
:P3oool00`000000oooo0?ooo`0Z0?ooo`<000004P3oool2000000d0oooo0P00000<0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00d0oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0B0?ooo`800000303oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo0140oooo0P00000T0?oooa<000009P3oool200000180oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo000E0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo0P00000B0?ooo`8000007@3oool9000000T0oooo0P0000080?ooo`X000007P3oool2
00000140oooo0P00000=0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo01@0oooo000D0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0:0?ooo`8000003@3oool00`00
0000oooo0?ooo`0@0?ooo`8000006@3oool600000180oooo00<000000?ooo`3oool04@3oool50000
01/0oooo0P00000A0?ooo`030000003oool0oooo00/0oooo0P00000;0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0C0?ooo`004`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0;0?ooo`8000004@3oool2000001H0oooo1@00000H0?ooo`030000003oool0oooo01H0
oooo1000000I0?ooo`800000403oool2000000d0oooo00<000000?ooo`3oool02@3oool2000001<0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0B0?ooo`004P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0:0?ooo`8000004@3oool2000001H0oooo0P00000M0?ooo`030000003oool0oooo01X0oooo
1000000G0?ooo`800000403oool2000000`0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool04@3oool00140oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00T0oooo0P00
000<0?ooo`030000003oool0oooo00l0oooo0P00000E0?ooo`<000007`3oool00`000000oooo0?oo
o`0N0?ooo`@000005@3oool200000100oooo00<000000?ooo`3oool02P3oool2000000/0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0100oooo000@
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00X0oooo0P00000@0?ooo`800000503oool300000280oooo00<00000
0?ooo`3oool08P3oool3000001@0oooo0P00000?0?ooo`800000303oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0?
0?ooo`00403oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0203oool2000000`0oooo00<000000?ooo`3oool03P3oool2000001@0oooo0P00000U0?oo
o`030000003oool0oooo02D0oooo0P00000D0?ooo`8000003`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00l0oooo000?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo0P00000?0?ooo`80
00004`3oool3000002L0oooo0P00000X0?ooo`<000004`3oool2000000h0oooo0P00000;0?ooo`80
00002P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool03P3oool000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0=0?ooo`800000
4P3oool3000002X0oooo00<000000?ooo`3oool0:P3oool300000180oooo0P00000>0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool03@3oool000d0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0@0?ooo`8000002@3oool2000000/0oooo0P00000>0?ooo`8000004@3o
ool3000002d0oooo00<000000?ooo`3oool0;@3oool300000140oooo00<000000?ooo`3oool0303o
ool2000000/0oooo00<000000?ooo`3oool0203oool200000180oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0<0?ooo`005@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`8000004@3oool2
00000300oooo00<000000?ooo`3oool0<03oool200000100oooo0P00000>0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo01<0oooo000D0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`090?ooo`8000003@3oool200000100oooo0`00000b0?ooo`030000003oool0oooo
0380oooo0`00000?0?ooo`8000003@3oool2000000X0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo0180oooo000C0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool01`3oool2000000/0oooo00<000000?ooo`3oool02`3oool200000100
oooo0P00000e0?ooo`030000003oool0oooo03D0oooo0P00000?0?ooo`8000003@3oool00`000000
oooo0?ooo`080?ooo`8000002P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0140
oooo000B0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`090?ooo`800000303oool200000100oooo0P00000g0?ooo`800000>03oool2000000l0oooo
0P00000<0?ooo`8000002P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool04@3oool00140oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool200000100oooo0P00
000i0?ooo`030000003oool0oooo03T0oooo0P00000?0?ooo`800000303oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0@0?ooo`00403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00H0oooo0P00000:
0?ooo`800000303oool00`000000oooo0?ooo`0>0?ooo`800000>`3oool00`000000oooo0?ooo`0k
0?ooo`8000003`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00l0oooo000?0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00X0oooo0P00000?0?ooo`800000?@3oool00`000000oooo0?ooo`0m0?oo
o`8000003P3oool2000000/0oooo0P0000090?ooo`8000002@3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo00h0oooo000>0?ooo`030000003oool0oooo00l0oooo0P0000080?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0=0?ooo`80
0000?`3oool00`000000oooo0?ooo`0o0?ooo`8000003P3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo00d0oooo000=0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`080?ooo`8000002`3oool2000000h0oooo0P0000110?ooo`030000
003oool0oooo0440oooo00<000000?ooo`3oool0303oool2000000/0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
303oool001h0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0303oool2000004<0oooo00<000000?ooo`3oool0@P3o
ool2000000h0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00L0oooo0P00000N0?ooo`007@3oool00`000000oooo0?ooo`060?ooo`8000002P3oool0
0`000000oooo0?ooo`090?ooo`8000003@3oool2000004D0oooo0P0000150?ooo`8000003@3oool2
000000X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo01/0oooo000L0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool20000
00/0oooo00<000000?ooo`3oool02`3oool2000004L0oooo00<000000?ooo`3oool0AP3oool20000
00d0oooo00<000000?ooo`3oool0203oool2000000T0oooo0P0000090?ooo`030000003oool0oooo
01X0oooo000J0?ooo`800000203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0
oooo0P00000<0?ooo`800000B@3oool00`000000oooo0?ooo`180?ooo`800000303oool2000000X0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01T0
oooo000I0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00X0oooo0P00001;0?ooo`030000003oool0oooo04X0oooo
0P00000<0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo01P0oooo000H0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool2000000X0oooo0P00000<0?ooo`030000003oool0oooo04@0oooo00@0
j[Yb000000000780^^[o0`3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo00X0oooo
0P0000090?ooo`8000002@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01L0oooo
000G0?ooo`030000003oool0oooo00H0oooo0P0000090?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool02P3oool2000004P0oooo00<0omBK07:jjP3oool00`3oool00`000000oooo0?oo
o`1=0?ooo`800000303oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo0P00
00080?ooo`030000003oool0oooo01H0oooo000F0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`8000002`3oool2000004L0oooo00H0oooD
09/00000000000000000LP2jj_l30?ooo`<00000C`3oool2000000/0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
5@3oool001D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00L0oooo0P00000<0?ooo`030000003oool0oooo04P0oooo00@0e9/009_Do`3oe9/0L[[Z
103oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00T0oooo0P0000090?ooo`800000
2@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01@0oooo000D0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00X0oooo0P00001;0?ooo`040?ooe02K0780^[ZK07:jjP@0oooo00<000000?ooo`3oool0
DP3oool2000000/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool04`3oool00180oooo0P0000080?ooo`030000003o
ool0oooo00L0oooo0P0000080?ooo`8000002`3oool2000004h0oooo00<0onZj0780001b^^X0103o
ool00`000000oooo0?ooo`1D0?ooo`8000002P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool2000001<0oooo000A0?ooo`030000003oool0
oooo00H0oooo0P0000090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool2
000005L0oooo00<000000?ooo`3oool0EP3oool2000000T0oooo0P0000090?ooo`800000203oool2
000000P0oooo00<000000?ooo`3oool0403oool00100oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo0P00000;0?ooo`030000003oool0oooo
05L0oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00l0oooo000?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo0P00001J0?ooo`030000003oool0oooo05T0
oooo0P0000090?ooo`8000002@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool03P3oool000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`070?ooo`800000203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo05X0oooo
0P00001L0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool2000000P0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0=0?ooo`003@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool2000000X0oooo0P00
001M0?ooo`030000003oool0oooo05`0oooo0P0000090?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00`0oooo000E
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`08
0?ooo`800000G`3oool00`000000oooo0?ooo`1N0?ooo`800000203oool2000000T0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0D0?ooo`00503oool00`000000oooo0?ooo`060?oo
o`800000203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo05l0oooo00<000000?oo
o`3oool0H03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0C0?ooo`004P3oool2000000P0oooo00<000000?ooo`3o
ool01P3oool2000000T0oooo0P00001R0?ooo`030000003oool0oooo0640oooo0P0000080?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool2000001<0oooo000A0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo0680oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`060?ooo`800000
203oool2000000P0oooo00<000000?ooo`3oool0403oool00100oooo00<000000?ooo`3oool01P3o
ool2000000P0oooo00<000000?ooo`3oool01`3oool2000006D0oooo0P00001U0?ooo`800000203o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03`3o
ool000l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`8000002@3oool0
0`000000oooo0?ooo`1U0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool01P3oool2
000000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0>0?ooo`003P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`1V0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03@3oool000d0
oooo00<000000?ooo`3oool01@3oool2000000P0oooo00<000000?ooo`3oool01`3oool2000006T0
oooo00<000000?ooo`3oool0J03oool2000000P0oooo00<000000?ooo`3oool01P3oool2000000L0
oooo00<000000?ooo`3oool0303oool001@0oooo00<000000?ooo`3oool01P3oool2000000T0oooo
00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo00H0oooo
0P0000080?ooo`030000003oool0oooo01<0oooo000C0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo06/0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0180oooo000B
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool2000006d0oooo00<00000
0?ooo`3oool0K03oool2000000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0A
0?ooo`004@3oool00`000000oooo0?ooo`050?ooo`8000002@3oool00`000000oooo0?ooo`1]0?oo
o`800000K`3oool00`000000oooo0?ooo`060?ooo`8000001`3oool00`000000oooo0?ooo`0@0?oo
o`003`3oool2000000L0oooo00<000000?ooo`3oool01`3oool200000700oooo00<000000?ooo`3o
ool0K`3oool2000000P0oooo00<000000?ooo`3oool01@3oool200000100oooo000>0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1`0?ooo`030000
003oool0oooo0740oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00d0oooo000=0?ooo`030000003oool0oooo00D0oooo0P0000080?ooo`800000L`3o
ool00`000000oooo0?ooo`1b0?ooo`030000003oool0oooo00H0oooo0P0000070?ooo`030000003o
ool0oooo00`0oooo000D0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0L`3oool0
0`000000oooo0?ooo`1c0?ooo`800000203oool00`000000oooo0?ooo`0C0?ooo`004`3oool00`00
0000oooo0?ooo`060?ooo`800000MP3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool04P3oool00180oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`1f0?ooo`030000003oool0oooo07H0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0A0?ooo`004@3oool00`000000oooo0?ooo`050?ooo`800000N@3oool2000007P0oooo
0P0000070?ooo`030000003oool0oooo0100oooo000?0?ooo`8000001`3oool00`000000oooo0?oo
o`1i0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3oool01@3oool200000100oooo000>
0?ooo`030000003oool0oooo00D0oooo0P00001l0?ooo`030000003oool0oooo07X0oooo0P000007
0?ooo`030000003oool0oooo00d0oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0O03oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0303oool001@0oooo00<000000?ooo`3oool0M@3oool0103Z^W8000000000001b^^X40?oo
o`030000003oool0oooo07d0oooo00<000000?ooo`3oool04`3oool00180oooo0P00001g0?ooo`06
0?oZ^P1bL[X0oooo0?ooo`2jLW80^^[o0`3oool00`000000oooo0?ooo`1n0?ooo`8000004`3oool0
0140oooo00<000000?ooo`3oool0N`3oool00`3DVg80^^[o0?ooo`020?ooo`<00000P03oool00`00
0000oooo0?ooo`0@0?ooo`00403oool00`000000oooo0?ooo`1i0?ooo`040=BK000000000000002K
e0@0oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`0?0?ooo`003P3oool2000007`0
oooo00<0e9]b0;[Zo`3oool01@3oool00`000000oooo0?ooo`220?ooo`8000003`3oool000d0oooo
00<000000?ooo`3oool0O03oool0103DV`00000000000000Vm@40?ooo`030000003oool0oooo08@0
oooo00<000000?ooo`3oool0303oool009@0oooo00<000000?ooo`3oool0T`3oool009@0oooo00<0
00000?ooo`3oool0T`3oool009@0oooo00<000000?ooo`3oool0T`3oool009@0oooo0P00002D0?oo
o`00\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {228.438, 81.875}} -> {-9.50681, \
2.75026, 0.0296943, 0.0306237}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show[G1,G2,kp1,kp2,AspectRatio->Automatic]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.05762 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 0.510802 0.0952381 [
[.11905 .4983 -6 -9 ]
[.11905 .4983 6 0 ]
[.30952 .4983 -6 -9 ]
[.30952 .4983 6 0 ]
[.69048 .4983 -3 -9 ]
[.69048 .4983 3 0 ]
[.88095 .4983 -3 -9 ]
[.88095 .4983 3 0 ]
[.4875 .12985 -12 -4.5 ]
[.4875 .12985 0 4.5 ]
[.4875 .32033 -12 -4.5 ]
[.4875 .32033 0 4.5 ]
[.4875 .70128 -6 -4.5 ]
[.4875 .70128 0 4.5 ]
[.4875 .89175 -6 -4.5 ]
[.4875 .89175 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.05762 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .5108 m
.11905 .51705 L
s
[(-4)] .11905 .4983 0 1 Mshowa
.30952 .5108 m
.30952 .51705 L
s
[(-2)] .30952 .4983 0 1 Mshowa
.69048 .5108 m
.69048 .51705 L
s
[(2)] .69048 .4983 0 1 Mshowa
.88095 .5108 m
.88095 .51705 L
s
[(4)] .88095 .4983 0 1 Mshowa
.125 Mabswid
.16667 .5108 m
.16667 .51455 L
s
.21429 .5108 m
.21429 .51455 L
s
.2619 .5108 m
.2619 .51455 L
s
.35714 .5108 m
.35714 .51455 L
s
.40476 .5108 m
.40476 .51455 L
s
.45238 .5108 m
.45238 .51455 L
s
.54762 .5108 m
.54762 .51455 L
s
.59524 .5108 m
.59524 .51455 L
s
.64286 .5108 m
.64286 .51455 L
s
.7381 .5108 m
.7381 .51455 L
s
.78571 .5108 m
.78571 .51455 L
s
.83333 .5108 m
.83333 .51455 L
s
.07143 .5108 m
.07143 .51455 L
s
.02381 .5108 m
.02381 .51455 L
s
.92857 .5108 m
.92857 .51455 L
s
.97619 .5108 m
.97619 .51455 L
s
.25 Mabswid
0 .5108 m
1 .5108 L
s
.5 .12985 m
.50625 .12985 L
s
[(-4)] .4875 .12985 1 0 Mshowa
.5 .32033 m
.50625 .32033 L
s
[(-2)] .4875 .32033 1 0 Mshowa
.5 .70128 m
.50625 .70128 L
s
[(2)] .4875 .70128 1 0 Mshowa
.5 .89175 m
.50625 .89175 L
s
[(4)] .4875 .89175 1 0 Mshowa
.125 Mabswid
.5 .17747 m
.50375 .17747 L
s
.5 .22509 m
.50375 .22509 L
s
.5 .27271 m
.50375 .27271 L
s
.5 .36795 m
.50375 .36795 L
s
.5 .41556 m
.50375 .41556 L
s
.5 .46318 m
.50375 .46318 L
s
.5 .55842 m
.50375 .55842 L
s
.5 .60604 m
.50375 .60604 L
s
.5 .65366 m
.50375 .65366 L
s
.5 .7489 m
.50375 .7489 L
s
.5 .79652 m
.50375 .79652 L
s
.5 .84414 m
.50375 .84414 L
s
.5 .08223 m
.50375 .08223 L
s
.5 .03461 m
.50375 .03461 L
s
.5 .93937 m
.50375 .93937 L
s
.5 .98699 m
.50375 .98699 L
s
.5 1.03461 m
.50375 1.03461 L
s
.25 Mabswid
.5 0 m
.5 1.05762 L
s
0 0 m
1 0 L
1 1.05762 L
0 1.05762 L
closepath
clip
newpath
.5 Mabswid
.11905 .15445 m
.14996 .18771 L
.18366 .22457 L
.21532 .26 L
.24577 .29518 L
.27817 .33455 L
.30937 .37589 L
.32661 .4016 L
.34252 .42921 L
.35043 .44577 L
.35784 .46532 L
.35985 .47204 L
.36168 .47932 L
.36266 .48392 L
.36372 .49003 L
.3643 .49428 L
.36484 .49955 L
s
.63475 .50678 m
.63487 .50376 L
.63542 .49672 L
.63593 .49243 L
.6371 .48521 L
.63903 .47634 L
.64078 .46984 L
.64471 .45788 L
.66195 .42087 L
.69383 .37141 L
.72581 .32955 L
.75659 .29241 L
.78932 .25474 L
.82084 .2196 L
.85115 .1865 L
.88095 .15445 L
s
.11905 .18089 m
.14996 .21712 L
.18366 .25824 L
.21532 .29924 L
.24577 .34242 L
.26273 .36933 L
.27817 .39711 L
.28586 .41296 L
.29421 .4329 L
.29804 .44366 L
.30209 .45707 L
.30555 .47171 L
.3065 .47674 L
.30752 .48312 L
.30849 .4909 L
.30937 .50309 L
s
.69079 .49982 m
.69164 .48969 L
.69258 .48244 L
.69357 .47632 L
.69746 .45875 L
.70441 .43662 L
.72008 .40056 L
.75224 .34544 L
.78544 .29821 L
.81743 .25688 L
.8482 .21932 L
.88093 .18091 L
.88095 .18089 L
s
.11905 .20963 m
.14996 .24983 L
.18366 .29715 L
.21532 .34765 L
.23126 .37739 L
.24577 .40974 L
.25382 .43216 L
.25751 .44462 L
.26142 .46084 L
.26341 .4714 L
.26454 .47888 L
.26508 .48317 L
.2656 .48796 L
.26657 .50257 L
s
.73334 .50573 m
.73346 .50174 L
.73403 .49208 L
.73458 .48622 L
.73566 .47746 L
.73683 .47 L
.74085 .45093 L
.74876 .42443 L
.75606 .40524 L
.78626 .34491 L
.81778 .29502 L
.84809 .25245 L
.88036 .21038 L
.88095 .20963 L
s
.11905 .24143 m
.14996 .28727 L
.18366 .34495 L
.20024 .3793 L
.21532 .41872 L
.22294 .44598 L
.22511 .45603 L
.22712 .46723 L
.22803 .4733 L
.22902 .48137 L
.23002 .49276 L
.23057 .50532 L
s
.76946 .50384 m
.77042 .48704 L
.77097 .48142 L
.77149 .47695 L
.77247 .46986 L
.77465 .4572 L
.77859 .43972 L
.78754 .41023 L
.80261 .37292 L
.81895 .34002 L
.85169 .2847 L
.88095 .24143 L
s
.11905 .27752 m
.14996 .3324 L
.16741 .36968 L
.17526 .38934 L
.18366 .41403 L
.18773 .42828 L
.19157 .4443 L
.19503 .46278 L
.19597 .46921 L
.19697 .47731 L
.19783 .48623 L
.19877 .50488 L
s
.80133 .50092 m
.80224 .48543 L
.80323 .47552 L
.80432 .46712 L
.80653 .45374 L
.81049 .43531 L
.81943 .40435 L
.83581 .36227 L
.85113 .33028 L
.88095 .27752 L
s
.11905 .02518 m
.14996 .04903 L
.18366 .07403 L
.21532 .09638 L
.24577 .11667 L
.27817 .13676 L
.30937 .15437 L
.34252 .17095 L
.37447 .18452 L
.4052 .19507 L
.42076 .19938 L
.43789 .2033 L
.45415 .20616 L
.46143 .20717 L
.46937 .20808 L
.47368 .20849 L
.47768 .20881 L
.48182 .20908 L
.48557 .20929 L
.48926 .20944 L
.49096 .2095 L
.49274 .20955 L
.49466 .20959 L
.49551 .2096 L
.49642 .20961 L
.4974 .20962 L
.49831 .20963 L
.49887 .20963 L
.4994 .20963 L
.50039 .20963 L
.5013 .20963 L
.50228 .20962 L
.50321 .20962 L
.50406 .20961 L
.50604 .20957 L
.50811 .20952 L
.51014 .20946 L
.51203 .20939 L
.51632 .20919 L
.52344 .20872 L
.53105 .20804 L
.53925 .20709 L
.54813 .20581 L
.56425 .20286 L
.59699 .1944 L
.62851 .18336 L
.65882 .17032 L
.69109 .15412 L
.72215 .13656 L
.75517 .11607 L
Mistroke
.78698 .0948 L
.81758 .07313 L
.85014 .04896 L
.88095 .02518 L
Mfstroke
.11905 .04423 m
.14996 .06911 L
.18366 .09531 L
.21532 .11888 L
.24577 .1404 L
.27817 .16185 L
.30937 .1808 L
.34252 .19878 L
.37447 .21361 L
.4052 .22523 L
.42076 .23001 L
.43789 .23436 L
.45415 .23755 L
.46143 .23868 L
.46937 .23969 L
.47368 .24015 L
.47768 .24051 L
.48182 .24082 L
.48557 .24104 L
.48926 .24121 L
.49096 .24128 L
.49274 .24133 L
.49466 .24138 L
.49551 .24139 L
.49642 .2414 L
.4974 .24142 L
.49831 .24142 L
.49887 .24143 L
.4994 .24143 L
.50039 .24143 L
.5013 .24143 L
.50228 .24142 L
.50321 .24141 L
.50406 .2414 L
.50604 .24136 L
.50811 .24131 L
.51014 .24124 L
.51203 .24116 L
.51632 .24093 L
.52344 .24041 L
.53105 .23964 L
.53925 .23858 L
.54813 .23716 L
.56425 .23387 L
.59699 .2245 L
.62851 .21234 L
.65882 .19809 L
.69109 .18053 L
.72215 .16164 L
.75517 .13976 L
Mistroke
.78698 .1172 L
.81758 .09437 L
.85014 .06904 L
.88095 .04423 L
Mfstroke
.11905 .0641 m
.14996 .09014 L
.18366 .11775 L
.21532 .14275 L
.24577 .16576 L
.27817 .18889 L
.30937 .20953 L
.34252 .22934 L
.37447 .24589 L
.4052 .25899 L
.42076 .26443 L
.43789 .26939 L
.45415 .27305 L
.46143 .27435 L
.46937 .27552 L
.47368 .27604 L
.47768 .27645 L
.48182 .27681 L
.48557 .27707 L
.48926 .27727 L
.49096 .27734 L
.49274 .2774 L
.49466 .27746 L
.49551 .27747 L
.49642 .27749 L
.4974 .2775 L
.49831 .27751 L
.49887 .27751 L
.4994 .27752 L
.50039 .27752 L
.5013 .27751 L
.50228 .27751 L
.50321 .2775 L
.50406 .27748 L
.50604 .27744 L
.50811 .27738 L
.51014 .2773 L
.51203 .27721 L
.51632 .27695 L
.52344 .27634 L
.53105 .27546 L
.53925 .27424 L
.54813 .2726 L
.56425 .26883 L
.59699 .25816 L
.62851 .24446 L
.65882 .22859 L
.69109 .20924 L
.72215 .18866 L
.75517 .16506 L
Mistroke
.78698 .14096 L
.81758 .11675 L
.85014 .09007 L
.88095 .0641 L
Mfstroke
.11905 .08488 m
.14996 .11229 L
.18366 .14155 L
.21532 .16828 L
.24577 .19313 L
.27817 .21842 L
.30937 .24132 L
.34252 .26366 L
.37447 .28268 L
.4052 .29804 L
.42076 .3045 L
.43789 .31046 L
.45415 .31488 L
.46143 .31646 L
.46937 .31788 L
.47368 .31852 L
.47768 .31902 L
.48182 .31946 L
.48557 .31978 L
.48926 .32002 L
.49096 .32011 L
.49274 .32019 L
.49466 .32025 L
.49551 .32027 L
.49642 .32029 L
.4974 .32031 L
.49831 .32032 L
.49887 .32032 L
.4994 .32033 L
.50039 .32033 L
.5013 .32032 L
.50228 .32031 L
.50321 .3203 L
.50406 .32028 L
.50604 .32023 L
.50811 .32015 L
.51014 .32006 L
.51203 .31995 L
.51632 .31963 L
.52344 .31889 L
.53105 .31781 L
.53925 .31632 L
.54813 .31434 L
.56425 .30978 L
.59699 .29706 L
.62851 .28103 L
.65882 .2628 L
.69109 .24099 L
.72215 .21817 L
.75517 .19238 L
Mistroke
.78698 .16636 L
.81758 .14048 L
.85014 .11221 L
.88095 .08488 L
Mfstroke
.11905 .10674 m
.14996 .13574 L
.18366 .16699 L
.21532 .19587 L
.24577 .2231 L
.27817 .25129 L
.30937 .27739 L
.34252 .30358 L
.37447 .32669 L
.4052 .3461 L
.42076 .35453 L
.43789 .36249 L
.45415 .36852 L
.46937 .37268 L
.47334 .3735 L
.47768 .37428 L
.4815 .37485 L
.48557 .37534 L
.48765 .37555 L
.4896 .37571 L
.4915 .37585 L
.49326 .37595 L
.49492 .37602 L
.49577 .37605 L
.49668 .37607 L
.4976 .37609 L
.49845 .37611 L
.49947 .37611 L
.50039 .37611 L
.50133 .37611 L
.50222 .3761 L
.50319 .37608 L
.50424 .37605 L
.50527 .37601 L
.50637 .37597 L
.50832 .37586 L
.51183 .3756 L
.51566 .37521 L
.51982 .37467 L
.52426 .37395 L
.53227 .3723 L
.54934 .36736 L
.56547 .36105 L
.59624 .34527 L
.62897 .32432 L
.6605 .30128 L
.69081 .27725 L
.72308 .25022 L
.75414 .22318 L
.78716 .19363 L
Mistroke
.81897 .16457 L
.84956 .13619 L
.88095 .10674 L
Mfstroke
.11905 .86715 m
.14996 .8339 L
.18366 .79703 L
.21532 .7616 L
.24577 .72643 L
.27817 .68706 L
.30937 .64571 L
.32661 .62 L
.34252 .5924 L
.35043 .57584 L
.35784 .55628 L
.35985 .54956 L
.36168 .54229 L
.36266 .53768 L
.36372 .53158 L
.3643 .52733 L
.36484 .52205 L
s
.63475 .51482 m
.63487 .51785 L
.63542 .52489 L
.63593 .52917 L
.6371 .53639 L
.63903 .54526 L
.64078 .55177 L
.64471 .56373 L
.66195 .60074 L
.69383 .65019 L
.72581 .69205 L
.75659 .7292 L
.78932 .76686 L
.82084 .80201 L
.85115 .8351 L
.88095 .86715 L
s
.11905 .84072 m
.14996 .80449 L
.18366 .76336 L
.21532 .72237 L
.24577 .67919 L
.26273 .65227 L
.27817 .62449 L
.28586 .60865 L
.29421 .5887 L
.29804 .57795 L
.30209 .56453 L
.30555 .54989 L
.3065 .54486 L
.30752 .53848 L
.30849 .53071 L
.30937 .51851 L
s
.69079 .52179 m
.69164 .53192 L
.69258 .53916 L
.69357 .54529 L
.69746 .56286 L
.70441 .58499 L
.72008 .62105 L
.75224 .67617 L
.78544 .72339 L
.81743 .76473 L
.8482 .80228 L
.88093 .8407 L
.88095 .84072 L
s
.11905 .81197 m
.14996 .77178 L
.18366 .72445 L
.21532 .67396 L
.23126 .64421 L
.24577 .61186 L
.25382 .58945 L
.25751 .57699 L
.26142 .56077 L
.26341 .5502 L
.26454 .54272 L
.26508 .53844 L
.2656 .53364 L
.26657 .51904 L
s
.73334 .51588 m
.73346 .51987 L
.73403 .52952 L
.73458 .53539 L
.73566 .54415 L
.73683 .5516 L
.74085 .57068 L
.74876 .59717 L
.75606 .61636 L
.78626 .6767 L
.81778 .72659 L
.84809 .76915 L
.88036 .81122 L
.88095 .81197 L
s
.11905 .78018 m
.14996 .73434 L
.18366 .67665 L
.20024 .64231 L
.21532 .60289 L
.22294 .57562 L
.22511 .56557 L
.22712 .55438 L
.22803 .54831 L
.22902 .54024 L
.23002 .52884 L
.23057 .51629 L
s
.76946 .51777 m
.77042 .53456 L
.77097 .54018 L
.77149 .54465 L
.77247 .55174 L
.77465 .5644 L
.77859 .58188 L
.78754 .61138 L
.80261 .64868 L
.81895 .68159 L
.85169 .7369 L
.88095 .78018 L
s
.11905 .74409 m
.14996 .68921 L
.16741 .65192 L
.17526 .63226 L
.18366 .60758 L
.18773 .59332 L
.19157 .57731 L
.19503 .55882 L
.19597 .5524 L
.19697 .54429 L
.19783 .53537 L
.19877 .51672 L
s
.80133 .52068 m
.80224 .53617 L
.80323 .54608 L
.80432 .55449 L
.80653 .56787 L
.81049 .58629 L
.81943 .61726 L
.83581 .65934 L
.85113 .69133 L
.88095 .74409 L
s
.11905 .99642 m
.14996 .97258 L
.18366 .94758 L
.21532 .92522 L
.24577 .90493 L
.27817 .88485 L
.30937 .86723 L
.34252 .85066 L
.37447 .83709 L
.4052 .82654 L
.42076 .82222 L
.43789 .81831 L
.45415 .81544 L
.46143 .81443 L
.46937 .81353 L
.47368 .81312 L
.47768 .8128 L
.48182 .81252 L
.48557 .81232 L
.48926 .81216 L
.49096 .81211 L
.49274 .81206 L
.49466 .81202 L
.49551 .81201 L
.49642 .81199 L
.4974 .81198 L
.49831 .81198 L
.49887 .81197 L
.4994 .81197 L
.50039 .81197 L
.5013 .81197 L
.50228 .81198 L
.50321 .81199 L
.50406 .812 L
.50604 .81203 L
.50811 .81208 L
.51014 .81214 L
.51203 .81221 L
.51632 .81241 L
.52344 .81288 L
.53105 .81357 L
.53925 .81452 L
.54813 .81579 L
.56425 .81875 L
.59699 .8272 L
.62851 .83824 L
.65882 .85128 L
.69109 .86748 L
.72215 .88504 L
.75517 .90554 L
Mistroke
.78698 .92681 L
.81758 .94848 L
.85014 .97264 L
.88095 .99642 L
Mfstroke
.11905 .97737 m
.14996 .9525 L
.18366 .92629 L
.21532 .90273 L
.24577 .8812 L
.27817 .85976 L
.30937 .84081 L
.34252 .82283 L
.37447 .80799 L
.4052 .79637 L
.42076 .79159 L
.43789 .78724 L
.45415 .78405 L
.46143 .78292 L
.46937 .78191 L
.47368 .78146 L
.47768 .7811 L
.48182 .78079 L
.48557 .78056 L
.48926 .78039 L
.49096 .78033 L
.49274 .78027 L
.49466 .78023 L
.49551 .78021 L
.49642 .7802 L
.4974 .78019 L
.49831 .78018 L
.49887 .78018 L
.4994 .78018 L
.50039 .78018 L
.5013 .78018 L
.50228 .78019 L
.50321 .7802 L
.50406 .78021 L
.50604 .78024 L
.50811 .7803 L
.51014 .78037 L
.51203 .78045 L
.51632 .78067 L
.52344 .78119 L
.53105 .78196 L
.53925 .78302 L
.54813 .78444 L
.56425 .78773 L
.59699 .7971 L
.62851 .80926 L
.65882 .82351 L
.69109 .84107 L
.72215 .85996 L
.75517 .88185 L
Mistroke
.78698 .9044 L
.81758 .92724 L
.85014 .95257 L
.88095 .97737 L
Mfstroke
.11905 .95751 m
.14996 .93146 L
.18366 .90386 L
.21532 .87886 L
.24577 .85585 L
.27817 .83272 L
.30937 .81207 L
.34252 .79226 L
.37447 .77572 L
.4052 .76261 L
.42076 .75718 L
.43789 .75221 L
.45415 .74855 L
.46143 .74725 L
.46937 .74609 L
.47368 .74557 L
.47768 .74515 L
.48182 .74479 L
.48557 .74453 L
.48926 .74433 L
.49096 .74426 L
.49274 .7442 L
.49466 .74415 L
.49551 .74413 L
.49642 .74411 L
.4974 .7441 L
.49831 .74409 L
.49887 .74409 L
.4994 .74409 L
.50039 .74409 L
.5013 .74409 L
.50228 .7441 L
.50321 .74411 L
.50406 .74412 L
.50604 .74417 L
.50811 .74423 L
.51014 .74431 L
.51203 .7444 L
.51632 .74466 L
.52344 .74526 L
.53105 .74615 L
.53925 .74737 L
.54813 .749 L
.56425 .75277 L
.59699 .76345 L
.62851 .77714 L
.65882 .79302 L
.69109 .81236 L
.72215 .83294 L
.75517 .85654 L
Mistroke
.78698 .88064 L
.81758 .90485 L
.85014 .93154 L
.88095 .95751 L
Mfstroke
.11905 .93672 m
.14996 .90931 L
.18366 .88006 L
.21532 .85333 L
.24577 .82848 L
.27817 .80319 L
.30937 .78029 L
.34252 .75795 L
.37447 .73892 L
.4052 .72357 L
.42076 .7171 L
.43789 .71115 L
.45415 .70672 L
.46143 .70515 L
.46937 .70373 L
.47368 .70309 L
.47768 .70258 L
.48182 .70214 L
.48557 .70182 L
.48926 .70158 L
.49096 .70149 L
.49274 .70142 L
.49466 .70135 L
.49551 .70133 L
.49642 .70131 L
.4974 .7013 L
.49831 .70129 L
.49887 .70128 L
.4994 .70128 L
.50039 .70128 L
.5013 .70128 L
.50228 .70129 L
.50321 .70131 L
.50406 .70132 L
.50604 .70137 L
.50811 .70145 L
.51014 .70155 L
.51203 .70166 L
.51632 .70198 L
.52344 .70272 L
.53105 .70379 L
.53925 .70528 L
.54813 .70727 L
.56425 .71182 L
.59699 .72455 L
.62851 .74058 L
.65882 .7588 L
.69109 .78061 L
.72215 .80343 L
.75517 .82923 L
Mistroke
.78698 .85524 L
.81758 .88112 L
.85014 .90939 L
.88095 .93672 L
Mfstroke
.11905 .91486 m
.14996 .88586 L
.18366 .85462 L
.21532 .82573 L
.24577 .79851 L
.27817 .77032 L
.30937 .74421 L
.34252 .71802 L
.37447 .69492 L
.4052 .67551 L
.42076 .66707 L
.43789 .65912 L
.45415 .65308 L
.46937 .64893 L
.47334 .6481 L
.47768 .64733 L
.4815 .64675 L
.48557 .64626 L
.48765 .64605 L
.4896 .64589 L
.4915 .64576 L
.49326 .64566 L
.49492 .64559 L
.49577 .64556 L
.49668 .64553 L
.4976 .64551 L
.49845 .6455 L
.49947 .64549 L
.50039 .64549 L
.50133 .6455 L
.50222 .64551 L
.50319 .64553 L
.50424 .64556 L
.50527 .64559 L
.50637 .64564 L
.50832 .64575 L
.51183 .64601 L
.51566 .6464 L
.51982 .64694 L
.52426 .64766 L
.53227 .6493 L
.54934 .65424 L
.56547 .66056 L
.59624 .67634 L
.62897 .69728 L
.6605 .72032 L
.69081 .74436 L
.72308 .77139 L
.75414 .79842 L
.78716 .82798 L
Mistroke
.81897 .85704 L
.84956 .88542 L
.88095 .91486 L
Mfstroke
.009 w
.02381 1.03244 m
.06244 .99743 L
.10458 .95992 L
.14415 .92551 L
.18221 .89335 L
.22272 .86043 L
.26171 .83039 L
.30316 .8008 L
.34309 .77533 L
.3815 .75451 L
.40095 .74567 L
.42237 .73747 L
.44268 .73134 L
.45178 .72915 L
.46172 .72718 L
.4671 .72629 L
.4721 .72558 L
.47727 .72497 L
.48196 .72452 L
.48658 .72418 L
.4887 .72406 L
.49093 .72395 L
.49332 .72387 L
.49438 .72384 L
.49552 .72381 L
.49675 .72379 L
.49789 .72377 L
.49859 .72377 L
.49925 .72376 L
.50049 .72376 L
.50163 .72377 L
.50286 .72378 L
.50401 .7238 L
.50508 .72382 L
.50754 .72389 L
.51014 .724 L
.51268 .72414 L
.51504 .72429 L
.5204 .72474 L
.5293 .72577 L
.53882 .72727 L
.54906 .72934 L
.56016 .7321 L
.58032 .7384 L
.62123 .75585 L
.66064 .77755 L
.69852 .80194 L
.73886 .83081 L
.77769 .86075 L
.81897 .89433 L
Mistroke
.85873 .92798 L
.89697 .96129 L
.93767 .99753 L
.97619 1.03244 L
Mfstroke
.01 w
.02381 .11813 m
.0322 .12834 L
.04135 .13959 L
.04994 .15026 L
.05821 .16063 L
.067 .1718 L
.07547 .18268 L
.08447 .19441 L
.09314 .20589 L
.10148 .21711 L
.11036 .22927 L
.1189 .24123 L
.12712 .25297 L
.13587 .26579 L
.14429 .27849 L
.15324 .29245 L
.16186 .30642 L
.17016 .32045 L
.17898 .33619 L
.18748 .35236 L
.19651 .37101 L
.20521 .39106 L
.21358 .41348 L
.21783 .42679 L
.22249 .44409 L
.22452 .45312 L
.2267 .46463 L
.22775 .47135 L
.22875 .47897 L
.22965 .48785 L
.2299 .49095 L
.23016 .4949 L
.23038 .49928 L
.23063 .51073 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{284, 300.313},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004L0001;2000`400?l00000o`00003oS@3oool0
0`000000oooo0?ooo`2<0?ooo`00S@3oool00`000000oooo0?ooo`2<0?ooo`00S@3oool00`000000
oooo0?ooo`2<0?ooo`00S@3oool00`000000oooo0?ooo`2<0?ooo`00S@3oool00`000000oooo0?oo
o`2<0?ooo`00S@3oool00`000000oooo0?ooo`2<0?ooo`00S@3oool00`000000oooo0?ooo`2<0?oo
o`008@3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3o
ool0803oool00280oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`1X0?ooo`030000
003oool0oooo0240oooo000S0?ooo`800000J03oool00`000000oooo0?ooo`1V0?ooo`800000903o
ool002D0oooo00<000000?ooo`3oool0I@3oool2000006H0oooo00<000000?ooo`3oool0903oool0
02H0oooo00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`1T0?ooo`030000003oool0oooo
02D0oooo000W0?ooo`800000I03oool00`000000oooo0?ooo`1R0?ooo`800000:03oool00240oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1Q0?ooo`030000003oool0oooo0640oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0P0?ooo`008P3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool0H03oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0240oooo000S0?ooo`8000001P3oool00`000000oooo0?ooo`1O
0?ooo`030000003oool0oooo05l0oooo00<000000?ooo`3oool0103oool2000002@0oooo000U0?oo
o`030000003oool0oooo00@0oooo0P00001O0?ooo`030000003oool0oooo05d0oooo0P0000060?oo
o`030000003oool0oooo02@0oooo000V0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0G03oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool09@3oool00240oooo00<000000?ooo`3oool00`3oool2000000H0oooo00<000000?ooo`3oool0
F`3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000
003oool0oooo0200oooo000R0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103o
ool2000005/0oooo00<000000?ooo`3oool0F@3oool2000000H0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0Q0?ooo`008`3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`1H0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0R0?ooo`00903oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0E`3oool00`00
0000oooo0?ooo`1G0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0S0?ooo`009@3oool2000000D0oooo0P0000060?ooo`800000E`3oool00`000000
oooo0?ooo`1E0?ooo`8000001P3oool2000000D0oooo0P00000V0?ooo`009`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0E03oool2000005D0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02H0oooo
000Q0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`050?ooo`800000E03oool00`000000oooo0?ooo`1B0?ooo`8000001`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0803oool00280oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`8000001`3oool00`000000oooo0?ooo`1A
0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool01@3oool2000000H0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0Q0?ooo`008`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool200000540oooo00<000000?oo
o`3oool0C`3oool2000000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0280oooo000T0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3o
ool0CP3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0S0?ooo`009@3oool2000000D0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`060?ooo`800000CP3oool00`000000oooo0?ooo`1<0?ooo`800000
1`3oool2000000H0oooo0P0000050?ooo`8000009P3oool002L0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`050?ooo`800000203oool00`000000oooo0?ooo`1;0?ooo`030000003o
ool0oooo04/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool09P3oool00240oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`030?ooo`8000001`3oool00`000000oooo0?ooo`060?ooo`800000B`3oool0
0`000000oooo0?ooo`190?ooo`8000001`3oool2000000L0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0200oooo000R0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01@3oool2000000H0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0Q0?ooo`008`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01@3oool2000000P0oooo0P0000180?ooo`030000003oool0oooo04H0
oooo0P0000070?ooo`8000001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool08P3oool000H0oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0A@3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo02<0oooo00050?ooo`<000007@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`800000A@3oool00`000000oooo0?ooo`130?ooo`800000203oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0T0?ooo`001P3oool3000001d0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00H0oooo0P0000090?ooo`030000003oool0oooo03X0oooo00@0j[Yb
000000000780^^[o103oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo00H0oooo0P00
00070?ooo`8000001`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02D0oooo0007
0?ooo`<000007@3oool00`000000oooo0?ooo`040?ooo`8000001@3oool2000000P0oooo00<00000
0?ooo`3oool01`3oool2000003/0oooo00<0omBK07:jjP3oool0103oool00`000000oooo0?ooo`10
0?ooo`800000203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo0P000006
0?ooo`030000003oool0oooo02H0oooo00080?ooo`8000007P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool2000000T0oooo00<000000?oo
o`3oool0=@3oool01P3oom@0V`00000000000000001b0;[Zo`@0oooo0`00000o0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool09`3oool000T0oooo0P00000N0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00L0oooo0P00000_0?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3DV`00VmCo0?oD
V`1b^^X50?ooo`030000003oool0oooo03d0oooo0P0000080?ooo`8000001`3oool2000000L0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0X0?ooo`002P3oool2000001h0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`800000203oool2000000T0oooo00<0
00000?ooo`3oool0<`3oool0103oom@0V`1b0;ZjV`1b^^X50?ooo`030000003oool0oooo03`0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0Y0?ooo`002`3oool2000001h0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool2000003@0oooo00<0onZj0780001b^^X01@3oool00`000000oooo0?oo
o`0j0?ooo`8000002@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0Z0?ooo`002`3oool3000001h0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo0P000009
0?ooo`800000>P3oool00`000000oooo0?ooo`0h0?ooo`8000002@3oool2000000P0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02/0oooo000<0?oo
o`<000007P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo0P0000090?oo
o`030000003oool0oooo00P0oooo0P00000h0?ooo`030000003oool0oooo03H0oooo0P00000:0?oo
o`030000003oool0oooo00H0oooo0P0000070?ooo`8000001`3oool00`000000oooo0?ooo`0/0?oo
o`003@3oool2000001l0oooo0P0000060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01`3oool2000000X0oooo0P00000f0?ooo`030000003oool0oooo03@0oooo0P00000:0?ooo`80
0000203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo0P00000_0?ooo`00
3P3oool200000140oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`040?ooo`800000
1`3oool2000000T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0c0?ooo`030000
003oool0oooo0380oooo0P00000;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
803oool000l0oooo0P00000A0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo0P00000:0?ooo`800000<`3o
ool00`000000oooo0?ooo`0`0?ooo`8000002`3oool2000000P0oooo0P0000070?ooo`8000001`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0240oooo000@0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00H0oooo0P0000090?ooo`030000003oool0oooo00T0oooo0P00000a0?ooo`030000003oool0
oooo02h0oooo0P00000<0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool08P3oool0
0100oooo0P00000B0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo0P00000;0?ooo`800000;`3oool00`00
0000oooo0?ooo`0/0?ooo`800000303oool2000000T0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool08`3oool00140
oooo0P00000B0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo0P00000;0?ooo`800000;@3oool00`000000
oooo0?ooo`0Y0?ooo`<00000303oool2000000X0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0903oool00180oooo
0P00000B0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`070?ooo`8000002P3oool2000000/0oooo0P00000[0?ooo`030000003oool0oooo02L0oooo
0P00000=0?ooo`8000002P3oool2000000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo02D0oooo000B0?ooo`<000004P3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00D0oooo0P0000090?ooo`030000003oool0oooo00T0oooo0P00
000;0?ooo`<00000:03oool2000002H0oooo0P00000=0?ooo`8000002`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0V0?ooo`004`3oool3000000/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00/0oooo0`00000U0?ooo`030000003oool0oooo02<0oooo0P00000>
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01P3oool2000000L0oooo0P00000>
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0803oool001@0oooo0P00000<0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00L0oooo0P00000;0?ooo`8000003P3oool300000280oooo00<000000?oo
o`3oool0803oool3000000h0oooo0P00000;0?ooo`800000203oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0Q0?oo
o`005@3oool2000000`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00H0oooo0P0000090?ooo`030000003oool0oooo00X0oooo0P00000?0?ooo`<0
00007`3oool00`000000oooo0?ooo`0M0?ooo`<000003`3oool2000000`0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0R0?ooo`005P3oool2000000/0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0;0?ooo`800000403oool3000001`0oooo00<000000?ooo`3oool0
6P3oool300000100oooo0P00000=0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
8P3oool001L0oooo0P00000;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo0P00000=0?ooo`8000004@3o
ool3000001T0oooo00<000000?ooo`3oool05`3oool300000140oooo0P00000=0?ooo`8000002@3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0S0?ooo`005`3oool3000000/0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool2
000000d0oooo00<000000?ooo`3oool04@3oool2000001L0oooo00<000000?ooo`3oool0503oool3
00000180oooo0P00000=0?ooo`8000002P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0T0?ooo`00603oool30000
00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00L0oooo0P00000:0?ooo`800000303oool2000001<0oooo0`00000D0?ooo`030000003oool0oooo
0140oooo0`00000C0?ooo`8000003@3oool2000000X0oooo0P0000080?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0U0?ooo`006@3oool2000000`0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`8000002@3oool00`000000
oooo0?ooo`090?ooo`800000303oool2000001@0oooo1@00000?0?ooo`030000003oool0oooo00X0
oooo1`00000D0?ooo`8000003@3oool2000000/0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool09P3oool001X0oooo
0P00000<0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool2000001L0oooo
3P0000000`3oool000000?ooo`0;000001T0oooo0P00000>0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool01P3oool200000100oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`0W0?ooo`006`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00L0oooo0P00
000;0?ooo`8000003@3oool200000280oooo1000000Q0?ooo`<000003P3oool2000000/0oooo0P00
00080?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0200oooo000K0?ooo`8000001@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool03P3oool2000000T0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`8000008P3oool00`000000oooo0?ooo`0N
0?ooo`800000403oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool08@3oool001`0oooo0P0000050?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool02P3oool2000000h0oooo0`00000O0?ooo`030000003oool0oooo01`0oooo0P00000@0?oo
o`800000303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0280oooo000L0?ooo`<0
0000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`070?ooo`800000303oool00`000000oooo0?ooo`0>0?ooo`<0
0000703oool00`000000oooo0?ooo`0J0?ooo`8000004@3oool00`000000oooo0?ooo`0:0?ooo`80
00002@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0R0?ooo`007@3oool3000000@0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0:0?ooo`8000004@3oool4000001P0oooo0P00000G0?ooo`@00000
4@3oool2000000`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0S0?ooo`007P3o
ool2000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0203oool2000000`0oooo00<000000?ooo`3oool04P3o
ool3000001D0oooo00<000000?ooo`3oool04P3oool4000001<0oooo0P00000<0?ooo`8000002P3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0T0?ooo`007`3oool2000000D0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0:0?ooo`8000005@3oool2000001<0oooo00<000000?ooo`3oool03P3oool4
000001D0oooo0P00000=0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool09@3oool0
0200oooo0P0000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0@0?ooo`8000002P3oool2000000`0oooo0P00000E0?ooo`L00000303oool00`00
0000oooo0?ooo`0:0?ooo`@000005`3oool2000000d0oooo0P00000:0?ooo`8000004@3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool09@3oool00240
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0
oooo0P00000J0?ooo`/0000000<0oooo0000003oool02`00000I0?ooo`8000003P3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo02H0oooo000Q0?ooo`8000001@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00`0oooo0P00000S0?ooo`<000008@3oool3000000l0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0200oooo
000R0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool02@3oool2000000h0oooo0P00
000R0?ooo`030000003oool0oooo01h0oooo0P00000@0?ooo`8000002`3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0240oooo000R0?ooo`8000001P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00d0oooo0`00000O0?ooo`030000003oool0oooo01`0oooo0P00000A
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0Q
0?ooo`008`3oool2000000H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0?0?oo
o`<00000703oool00`000000oooo0?ooo`0J0?ooo`8000004P3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool08P3oool002<0oooo0`0000050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo00X0oooo0P00000B0?ooo`<000006@3oool00`000000oooo0?ooo`0G0?ooo`<0
00004P3oool2000000`0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0S0?ooo`00
903oool3000000D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0B0?ooo`800000
5`3oool00`000000oooo0?ooo`0D0?ooo`<00000503oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool08`3oool002D0oooo0P0000060?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0B0?ooo`800000303o
ool00`000000oooo0?ooo`0C0?ooo`<00000503oool00`000000oooo0?ooo`0A0?ooo`<000005P3o
ool00`000000oooo0?ooo`0:0?ooo`800000503oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0T0?ooo`009P3oool2
000000D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool02P3oool2000001H0oooo1@00000?0?ooo`030000003oool0
oooo00h0oooo0`00000G0?ooo`800000303oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo02D0oooo000W0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02`3oool20000
01T0oooo0`00000<0?ooo`8000002`3oool4000001P0oooo0P00000=0?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool09@3oool002L0oooo0P0000060?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00`0
oooo0P00000J0?ooo`L000001@3oool00`000000oooo0?ooo`040?ooo`H000006P3oool2000000h0
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0V0?ooo`008@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool03@3oool2000001l0oooo
3000000N0?ooo`8000003`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0803oool00280oooo00<000000?ooo`3oool00`3oool2000000H0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0200oooo0P00
000?0?ooo`8000005@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0240oooo000R
0?ooo`030000003oool0oooo00@0oooo0P0000060?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0D0?ooo`8000003`3oool200000240oooo00<00000
0?ooo`3oool07P3oool200000100oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0240oooo000S0?ooo`030000003oool0oooo00@0oooo0P0000060?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0E0?oo
o`030000003oool0oooo00h0oooo0P00000O0?ooo`030000003oool0oooo01`0oooo0P00000@0?oo
o`8000005`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0280oooo000S0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0?0?ooo`80
00007@3oool00`000000oooo0?ooo`0J0?ooo`8000004@3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool08P3oool002@0oooo00<000000?ooo`3oool0
103oool2000000H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo01D0oooo0P00000A0?ooo`8000006`3oool00`000000oooo0?ooo`0G0?ooo`<00000
4@3oool2000001P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0S0?ooo`009@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0403o
ool3000001P0oooo00<000000?ooo`3oool05@3oool2000001<0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02@0oooo000U0?ooo`030000003oool0
oooo00@0oooo0P0000060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0180oooo0`00000E0?ooo`030000003oool0
oooo01<0oooo0P00000D0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0T0?ooo`009P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool0503oool2000001<0oooo00<000000?ooo`3oool04@3oool20000
01D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
02D0oooo000V0?ooo`030000003oool0oooo00@0oooo0P0000060?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0G0?ooo`8000005P3oool4000000l0
oooo00<000000?ooo`3oool03P3oool3000001H0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo02D0oooo000W0?ooo`030000003oool0oooo00@0oooo
0P0000060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01L0oooo0`0000020?ooo`060?oDV`000000000000000000
09/0e?oo103oool00`000000oooo0?ooo`0:0?ooo`@000005`3oool2000001X0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`0V0?ooo`00:03oool00`000000oooo0?ooo`040?ooo`80
00001P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0I0?ooo`L000001@3oool00`000000oooo0?ooo`040?ooo`H0
00006P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool09`3oool002P0oooo00<000000?ooo`3oool0103oool2000000H0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01P0oooo0P00000M0?ooo`030?oD
V`000000VmCo00`000007`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool09`3oool002T0oooo00<000000?ooo`3oool0103oool2000000H0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool04P3oool00`3oe9/00000000000020000000609_Do`3oool0oooo0?ooo`3oom@0
e=Co1@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo0?ooo`040?ooo`800000
1P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
6P3oool00`000000oooo0?ooo`0G0?ooo`060?oZ^P1bL[X0oooo0?ooe02K09/0e?oo103oool00`00
0000oooo0?ooo`0P0?ooo`8000006`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
02P0oooo000Z0?ooo`030000003oool0oooo00@0oooo0P0000060?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0J0?ooo`800000603oool0103Z^W80
00000000001b^^X50?ooo`030000003oool0oooo01h0oooo0P00000L0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0:@3oool002X0oooo00<000000?ooo`3oool0103oool2000000L0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01/0
oooo0P00000O0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool06`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo02T0oooo000[0?ooo`030000003oool0oooo00@0oooo
0P0000060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0L0?ooo`8000007@3oool00`000000oooo0?ooo`0K0?ooo`8000007P3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo02X0oooo000[0?ooo`030000003oool0oooo00@0oooo0P00
00070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0N0?ooo`8000006`3oool00`000000oooo0?ooo`0I0?ooo`8000007`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo02X0oooo000/0?ooo`030000003oool0oooo00@0oooo0P000006
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0N
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0:`3oool002`0oooo00<000000?oo
o`3oool0103oool3000000H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo01l0oooo0P00000H0?ooo`030000003oool0oooo01H0oooo0P00000P0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0:`3oool002d0oooo00<000000?ooo`3o
ool0103oool2000000L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo0200oooo0P00000F0?ooo`030000003oool0oooo01@0oooo0P00000R0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0;03oool002d0oooo00<000000?ooo`3oool0
103oool3000000H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo0280oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0B0?ooo`800000
8`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02`0oooo000^0?ooo`030000003o
ool0oooo00@0oooo0P0000070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0R0?ooo`8000004`3oool00`000000oooo0?ooo`0?0?ooo`<00000903o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02d0oooo000^0?ooo`030000003oool0
oooo00@0oooo0`0000060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0S0?ooo`@000003`3oool00`000000oooo0?ooo`0=0?ooo`8000009P3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo02d0oooo000_0?ooo`030000003oool0oooo
00@0oooo0P0000070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0V0?ooo`<00000303oool2000000/0oooo0`00000X0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0;@3oool002l0oooo00<000000?ooo`3oool0103oool2000000P0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02T0
oooo0P00000:0?ooo`030000003oool0oooo00P0oooo0P00000Z0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0;P3oool002l0oooo00<000000?ooo`3oool01@3oool2000000L0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02X0oooo
200000020?ooo`030000003oool0oooo00P00000:`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo02h0oooo000`0?ooo`030000003oool0oooo00@0oooo0P0000080?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0`0?ooo`H00000<`3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02l0oooo000`0?ooo`030000003oool0
oooo00D0oooo0P0000070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0b0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0_0?ooo`00<@3oool00`000000oooo0?ooo`040?ooo`800000203oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0<P3oool00`00
0000oooo0?ooo`0a0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0<03oool00340
oooo00<000000?ooo`3oool01@3oool2000000L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0<@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo0300oooo000a0?ooo`030000003oool0oooo00D0oooo
0P0000080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0`0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0`0?ooo`00<P3oool00`000000oooo0?ooo`040?ooo`<000001`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?oo
o`0_0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0<@3oool00380oooo00<00000
0?ooo`3oool01@3oool2000000P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo0340oooo000b0?ooo`030000003oool0oooo00D0oooo0`0000070?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0^0?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0b0?oo
o`00<P3oool00`000000oooo0?ooo`060?ooo`800000203oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0^0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0<P3oool003<0oooo00<000000?ooo`3oool0
1@3oool2000000P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo02d0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo0380oooo000c0?ooo`030000003oool0oooo00D0oooo0`0000070?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0]0?ooo`030000003o
ool0oooo02`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0c0?ooo`00<`3oool0
0`000000oooo0?ooo`060?ooo`800000203oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0;03oool2000002d0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0c0?ooo`00=03oool00`000000oooo0?ooo`050?ooo`800000203oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0;03oool00`00
0000oooo0?ooo`0[0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0<`3oool003@0
oooo00<000000?ooo`3oool01@3oool2000000P0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0:`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo03<0oooo000e0?ooo`030000003oool0oooo00@0oooo
0P0000090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0[0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`0d0?ooo`00=@3oool00`000000oooo0?ooo`050?ooo`800000203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?oo
o`0Z0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0=03oool003D0oooo00<00000
0?ooo`3oool01@3oool2000000P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo03@0oooo000f0?ooo`030000003oool0oooo00@0oooo0P0000080?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0Y0?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0d0?oo
o`00=P3oool00`000000oooo0?ooo`040?ooo`<00000203oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0X0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0=03oool003H0oooo00<000000?ooo`3oool0
1@3oool2000000P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo02L0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo03D0oooo000f0?ooo`030000003oool0oooo00D0oooo0P0000080?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0W0?ooo`030000003o
ool0oooo02L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0e0?ooo`00=P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo03D0oooo000g0?ooo`030000003oool0oooo
00D0oooo0P0000080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0e0?ooo`00=`3oool00`000000oooo0?ooo`050?ooo`800000203oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0=@3oool003L0oooo
00<000000?ooo`3oool01@3oool2000000P0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo02D0oooo0P00000W0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0=P3oool003L0oooo00<000000?ooo`3oool01@3oool2000000P0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool09@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo03H0oooo000S
0?ooo`040>ZjLP000000001b0;[Zoa00oooo00<000000?ooo`3oool01@3oool2000000T0oooo00<0
00000?ooo`3oool02@3oool00`000000omBK00000002000000030000V`3Dool0oooo00L0oooo00<0
00000?ooo`3oool09@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00P0oooo00<0
omBK0000000000000P0000000`3Dool0oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`0B0?ooo`040>ZjLP000000001b0;[Zob00oooo
000T0?ooo`030?oDV`1b^^X0oooo0100oooo00<000000?ooo`3oool01@3oool2000000T0oooo00<0
00000?ooo`3oool02@3oool01@000000oooo0;Yb000009/0e?oo00X0oooo00<000000?ooo`3oool0
9@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00X0oooo00@0^W800000V`3Dool0
00002`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool04`3oool00`3oe9/0L[[Z0?ooo`0P0?ooo`008@3oool01P3oom@0V`00000000000000001b0;[Z
oa00oooo00<000000?ooo`3oool01@3oool2000000T0oooo00<000000?ooo`3oool02@3oool01P00
0000oooo0?ooo`3oe9/0000009_Do`T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo00/0oooo00<0omBK0000000000002`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0403oool01P3oom@0V`000000
00000000001b0;[Zob00oooo000K0?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3DV`00
VmCo0?oDV`1b^^XA0?ooo`030000003oool0oooo00D0oooo0P0000090?ooo`030000003oool0oooo
00@0oooo00<0omBK0000000000000`0000030?ooo`030?ooe03De?l0oooo00T0oooo00<000000?oo
o`3oool0903oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00`0oooo00<0oooD0000
003oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool04@3oool0103DV`00VmCo0?oDV`1b^^XQ0?ooo`008P3oool0103oom@0V`1b0;ZjV`1b^^XA
0?ooo`030000003oool0oooo00D0oooo0P00000:0?ooo`030000003oool0oooo00T0oooo00H00000
079b^P3oool0oooD09/0V`3Dool90?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0
903oool00`000000oooo0?ooo`090?ooo`060?oZ^P1bL[X0oooo0?ooe0000000e?oo2@3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool04@3oool0103o
om@0V`1b0;ZjV`1b^^XQ0?ooo`008`3oool00`3oj[X0LP0007:jjP0A0?ooo`030000003oool0oooo
00D0oooo0`0000090?ooo`030000003oool0oooo00T0oooo00D000000>ZjLP000000000007:jjP0:
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0:
0?ooo`040>ZjLP000000000007:jjPX0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo0180oooo00<0onZj0780001b^^X08@3oool003L0oooo00<00000
0?ooo`3oool01P3oool2000000T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo03H0oooo000g0?ooo`030000003oool0oooo00H0oooo0P0000090?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0S0?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0g0?oo
o`00>03oool00`000000oooo0?ooo`050?ooo`8000002@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0=`3oool003P0oooo00<000000?ooo`3oool0
1@3oool2000000T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo03L0oooo000h0?ooo`030000003oool0oooo00D0oooo0P00000E0?ooo`030000003o
ool0oooo03<0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0@03oool00400oooo0P00001;0?ooo`030000003oool0
oooo02<0oooo00<000000?ooo`3oool0IP3oool00?l000007@00000000H0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool01P3oool01@000000oooo0?ooo`3oool0000000<0oooo0P0000080?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0203oool00`000000oooo0000000=0?ooo`030000003oool0oooo
00T0oooo0P00000=0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01@3oool00240
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo02<0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0P0?ooo`00>03oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo03L0oooo000g0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool08`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool0=`3oool003L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0T
0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0g
0?ooo`00=`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02@0oooo00<000000?oo
o`3oool08`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo03H0oooo000g0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0T0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0=P3oool003L0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0f0?ooo`00=`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo02@0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo03H0oooo000g0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0=P3oool0
03L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0f0?ooo`00=`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo03H0oooo000g0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool09@3oool2000002H0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0f0?ooo`00=`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03H0oooo000g
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0=@3oool003H0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0e0?ooo`00=P3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo03D0oooo000f0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
9`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
=@3oool003H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0X0?ooo`030000003o
ool0oooo02P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0d0?ooo`00=P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo03@0oooo000e0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0=03oool003D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0Y0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0d0?ooo`00=@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02X0oooo
00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03@0oooo
000d0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?oo
o`0Z0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0<`3oool003@0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo02/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0c0?ooo`00<`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo02`0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo03<0oooo000c0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0;03oool2000002d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0c0?ooo`00
<`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0
;@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0380oooo000b0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0^0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0<P3oool00380oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0^0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0b0?ooo`00<P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
02h0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0380oooo000b0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0;`3oool00`000000
oooo0?ooo`0_0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0<@3oool00340oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0300oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0a0?ooo`00<@3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0300oooo000a0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool0<@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0<03oool00300oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0b0?oo
o`030000003oool0oooo0380oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0`0?oo
o`00<03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3o
ool0<`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02l0oooo000`0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0;@3oool>000002h0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0_0?ooo`00;`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo02X0oooo100000060?ooo`030000003oool0oooo00D0oooo1000000[0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0;P3oool002l0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0W0?ooo`@000002P3oool2000000X0oooo1000000X0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0;P3oool002h0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0U0?ooo`8000003P3oool00`000000oooo0?ooo`0=0?ooo`8000009P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo02d0oooo000^0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0903oool200000100oooo00<000000?ooo`3oool03`3oool2000002D0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0]0?ooo`00;@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo02<0oooo0P00000B0?ooo`030000003oool0oooo0140oooo
0P00000T0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0;@3oool002d0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0Q0?ooo`<00000503oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0/0?ooo`00;03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01l0oooo0P00000G
0?ooo`030000003oool0oooo01@0oooo0P00000R0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0;03oool002`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0N0?oo
o`8000006@3oool00`000000oooo0?ooo`0F0?ooo`8000008@3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo02/0oooo000[0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool07@3oool2000001/0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0O0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0:`3oool002/0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0
6@3oool200000200oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0Z0?ooo`00:P3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01/0oooo0P00000N0?ooo`030000003o
ool0oooo01/0oooo0P00000N0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0:P3o
ool002X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo01h0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0:@3oool002T0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0J0?ooo`8000008@3oool00`000000oooo0?ooo`0N0?ooo`8000007@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo02T0oooo000Y0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0G0?ooo`060?oDV`00000000000000
000009/0e?oo103oool00`000000oooo0?ooo`0P0?ooo`800000703oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo02P0oooo000X0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0603oool2000001/0oooo00<0^W800000V`3Dool01P3oool00`000000oooo0?ooo`0R0?oo
o`030000003oool0oooo01X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0X0?oo
o`00:03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool06`3ooolC000001`0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo02L0oooo000W0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
5`3oool2000001P0oooo1P0000020?ooo`030?ooe03De?l0oooo00@0oooo00<000000?ooo`3oool0
1`3oool5000001P0oooo0P00000J0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
9`3oool002L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo01D0oooo0`0000050?ooo`060?oZ^P1bL[X0oooo0?ooe02K09/0e?oo103oool00`000000
oooo0?ooo`0<0?ooo`800000603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool09P3oool002H0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0F0?ooo`8000005P3oool2000000T0oooo00@0j[Yb000000000000L[[Z1@3oool00`000000
oooo0?ooo`0>0?ooo`<000005P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool09@3oool002D0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0F0?ooo`030000003oool0oooo01<0oooo0`00000D0?ooo`030000003oool0oooo0140oooo
0`00000D0?ooo`8000006@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02D0oooo
000U0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`0B0?ooo`8000005`3oool00`000000oooo0?ooo`0D0?ooo`<000004`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0903oool002@0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0100oooo0`00000A
0?oooa4000004@3oool200000180oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo02@0oooo000T0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool05@3oool00`000000oooo0?ooo`0?0?ooo`8000003P3ooolM000000d0oooo0P00000A0?oo
o`8000005`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02<0oooo000S0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0503oool200000100oooo0P00000;0?ooo``0
00001`3oool00`000000oooo0?ooo`050?ooo`d000002@3oool200000140oooo00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0280oooo000S0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0>0?ooo`800000
2P3oool9000000d0oooo00<000000?ooo`3oool02`3oool:000000P0oooo0P00000@0?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0R0?ooo`008P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool03@3o
ool2000000T0oooo1`00000B0?ooo`030000003oool0oooo0140oooo1P0000080?ooo`8000003`3o
ool2000001H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0Q0?ooo`008P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0303oool2
000000P0oooo1`00000E0?ooo`030000003oool0oooo01@0oooo1@0000080?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0240oooo000Q0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo1P00000?0?oooa<000003`3oool60000
00H0oooo0P00000?0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0P0?ooo`009`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0
oooo0P0000070?ooo`D00000303oool6000000T0oooo0P0000080?ooo`H000002`3oool6000000H0
oooo0P00000>0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool09P3oool002L0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool04P3oool2000000d0oooo00<000000?ooo`3oool01@3oool5000000X0oooo
1000000?0?ooo`030000003oool0oooo00d0oooo1000000:0?ooo`D000001P3oool2000000d0oooo
0P00000D0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo02D0oooo000V0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool02`3oool2000000H0oooo1@0000080?ooo`@000004`3oool00`000000oooo0?oo
o`0A0?ooo`<000002@3oool5000000H0oooo0P00000=0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool09@3oool002D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00D0oooo100000080?ooo`8000005`3oool00`000000oooo0?ooo`0D
0?ooo`<00000203oool5000000H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo02@0oooo000T0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0140oooo0P00000<0?oo
o`8000001P3oool4000000L0oooo0`00000I0?ooo`030000003oool0oooo01L0oooo0`0000070?oo
o`@000001P3oool2000000`0oooo0P00000C0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02<0oooo000T0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`D0
00001P3oool2000001`0oooo00<000000?ooo`3oool06P3oool2000000L0oooo100000060?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0S0?ooo`00
8`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00X0oooo0P0000060?ooo`@00000
1P3oool2000001h0oooo00<000000?ooo`3oool0703oool2000000H0oooo1@0000050?ooo`800000
303oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0280oooo000R0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`040?ooo`@000001P3o
ool200000200oooo00<000000?ooo`3oool07P3oool2000000H0oooo1@0000050?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0Q0?ooo`008P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00T0oooo0P0000050?ooo`D00000103oool3
00000280oooo00<000000?ooo`3oool0803oool2000000H0oooo1@0000040?ooo`8000002`3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0240oooo000Q0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`040?ooo`@00000103oool20000
01`0oooo4`00000K0?ooo`8000001P3oool4000000D0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo0200oooo000X0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0?0?ooo`8000002P3oool2000000D0
oooo100000040?ooo`800000603oool6000000T0oooo00<000000?ooo`3oool01`3oool6000001L0
oooo0P0000060?ooo`@00000103oool00`000000oooo0?ooo`090?ooo`8000004@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool09P3oool002L0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`D000000`3oool2000001H0oooo
1000000?0?ooo`030000003oool0oooo00d0oooo1000000E0?ooo`8000001@3oool4000000@0oooo
0P00000;0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo02D0oooo000V0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00P0oooo0P00
00040?ooo`D000000`3oool2000001@0oooo1000000C0?ooo`030000003oool0oooo0140oooo0`00
000D0?ooo`8000001@3oool4000000@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0U0?ooo`009@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00<0oooo10000003
0?ooo`800000503oool2000001L0oooo00<000000?ooo`3oool0503oool3000001<0oooo00<00000
0?ooo`3oool00`3oool4000000@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0T
0?ooo`00903oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`070?ooo`800000103oool4000000@0oooo00<000000?oo
o`3oool04@3oool3000001T0oooo0P00000H0?ooo`<000004@3oool2000000D0oooo100000030?oo
o`8000002P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`0S0?ooo`008`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00<0oooo100000030?ooo`8000004@3oool3000001`0oooo00<000000?ooo`3o
ool06P3oool300000100oooo0P0000040?ooo`@00000103oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo0280oooo000S0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
0P3oool4000000@0oooo00<000000?ooo`3oool03P3oool3000001l0oooo00<000000?ooo`3oool0
7@3oool3000000l0oooo0P0000040?ooo`@000000`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0280oooo000R0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00P3o
ool4000000<0oooo0P00000>0?ooo`<000008P3oool00`000000oooo0?ooo`0P0?ooo`<000003P3o
ool2000000<0oooo100000030?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool08@3o
ool00240oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00h0oooo0P0000090?ooo`040000003oool0oooo0?ooo`@00000103oool00`000000oooo0?oo
o`0<0?ooo`800000703ooolC000001`0oooo0P00000>0?ooo`030000003oool0oooo0080oooo1000
00020?ooo`8000002@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0P0?ooo`009`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool01`3oool2000000<0oooo10000003
0?ooo`8000003@3oool2000001P0oooo1P0000090?ooo`030000003oool0oooo00L0oooo1P00000H
0?ooo`8000003@3oool2000000<0oooo100000030?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02H0oooo000V0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo0080oooo0`0000040?ooo`030000003oool0oooo00/0oooo0P00000F0?oo
o`@000003`3oool00`000000oooo0?ooo`0=0?ooo`D000005@3oool2000000d0oooo00<000000?oo
o`3oool00P3oool400000080oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool09@3oool002D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3o
ool0oooo100000030?ooo`800000303oool2000001<0oooo1@00000C0?ooo`030000003oool0oooo
0180oooo1000000C0?ooo`800000303oool2000000<0oooo100000020?ooo`800000203oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0903oool002D0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00L0
oooo00@000000?ooo`3oool0oooo100000030?ooo`030000003oool0oooo00X0oooo0P00000A0?oo
o`@00000603oool00`000000oooo0?ooo`0F0?ooo`@000004@3oool2000000`0oooo00<000000?oo
o`3oool00P3oool400000080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool08`3oool002@0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3o
ool0oooo0`0000030?ooo`8000002`3oool200000100oooo0`00000L0?ooo`030000003oool0oooo
01X0oooo0`00000@0?ooo`8000002`3oool2000000<0oooo100000020?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
0280oooo000S0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`070?ooo`040000003oool0oooo0?ooo`<000000`3oool00`000000oooo0?ooo`090?oo
o`8000003`3oool3000001l0oooo00<000000?ooo`3oool07@3oool3000000l0oooo0P00000;0?oo
o`030000003oool0oooo0080oooo0`0000020?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0280oooo000R0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`060?ooo`80
00000P3oool400000080oooo0P00000:0?ooo`8000003P3oool300000280oooo00<000000?ooo`3o
ool0803oool3000000h0oooo0P00000:0?ooo`030000003oool0oooo0080oooo100000000`3oool0
0000000000070?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0Q0?ooo`008@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00`0oooo
0P0000080?ooo`040000003oool0oooo0?ooo`@000000P3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00`0oooo0P00000U0?ooo`030000003oool0oooo02<0oooo0P00000>0?ooo`03
0000003oool0oooo00P0oooo0P0000030?ooo`@000000P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0P0?ooo`00
9`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool0
oooo0`0000020?ooo`8000002P3oool2000000d0oooo0P00000W0?ooo`8000009P3oool2000000d0
oooo0P00000:0?ooo`030000003oool0oooo0080oooo0`0000020?ooo`030000003oool0oooo00D0
oooo0P00000>0?ooo`030000003oool0oooo02L0oooo000V0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool01P3oool2000000<0oooo0`0000020?ooo`030000003oool0oooo00P0oooo
0P00000=0?ooo`800000:@3oool00`000000oooo0?ooo`0W0?ooo`8000003@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo0080oooo0`0000020?ooo`8000001`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo02H0oooo000U0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool01P3oool010000000oooo0?ooo`3oool4000000030?ooo`000000000000T0oooo
0P00000=0?ooo`800000:`3oool00`000000oooo0?ooo`0Y0?ooo`800000303oool2000000T0oooo
0P0000030?ooo`@000000P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool09@3oool002D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`060?ooo`040000003oool0oooo0?ooo`@0000000<0oooo0000003oool0203oool2000000d0oooo
0P00000]0?ooo`030000003oool0oooo02/0oooo0P00000<0?ooo`030000003oool0oooo00P0oooo
00@000000?ooo`3oool0oooo100000020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0T0?ooo`00903oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00H0oooo00@000000?ooo`3oool0oooo0`0000020?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool02`3oool2000002l0oooo00<000000?ooo`3oool0;@3oool2000000/0
oooo0P0000090?ooo`030000003oool0oooo0080oooo0`0000020?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0S0?ooo`008`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00D0oooo0P0000030?ooo`<0000000<0oooo000000000000
2@3oool00`000000oooo0?ooo`0:0?ooo`800000<@3oool00`000000oooo0?ooo`0_0?ooo`800000
2`3oool00`000000oooo0?ooo`070?ooo`8000000`3oool300000080oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0280oooo000R0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`3oool4000000030?oo
o`000000oooo00P0oooo0P00000;0?ooo`800000<`3oool00`000000oooo0?ooo`0a0?ooo`800000
2P3oool2000000T0oooo00@000000?ooo`3oool0oooo0`0000020?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0Q0?ooo`008@3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool0oooo100000000`3oool0
00000?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0<`3oool00`000000
oooo0?ooo`0c0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool200000080
oooo100000000`3oool00000000000060?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool0803oool002h0oooo00<000000?ooo`3oool0103oool2000000<0oooo0`0000000`3oool00000
000000090?ooo`030000003oool0oooo00T0oooo0P00000f0?ooo`030000003oool0oooo03@0oooo
0P00000:0?ooo`8000002@3oool00`000000oooo0?ooo`0400000080oooo00<000000?ooo`3oool0
103oool2000002l0oooo000]0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool0oooo
100000000`3oool000000?ooo`080?ooo`8000002P3oool2000003P0oooo00<000000?ooo`3oool0
=P3oool2000000X0oooo00<000000?ooo`3oool01`3oool200000080oooo0`0000020?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0;03oool002`0oooo00<000000?ooo`3oool0103o
ool010000000oooo0?ooo`3oool4000000030?ooo`000000oooo00P0oooo00<000000?ooo`3oool0
203oool2000003X0oooo00<000000?ooo`3oool0>03oool2000000T0oooo0P0000090?ooo`030000
003oool0oooo00<000000P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02/0oooo
000[0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool0oooo0`0000020?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool2000003`0oooo00<000000?ooo`3oool0
>P3oool2000000T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`04000000030?oo
o`000000oooo00H0oooo00<000000?ooo`3oool0:P3oool002X0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`04000000030?ooo`000000000000P0oooo0P0000090?ooo`030000003o
ool0oooo03@0oooo00@0j[Yb000000000780^^[o103oool00`000000oooo0?ooo`0l0?ooo`030000
003oool0oooo00L0oooo0P0000080?ooo`80000000<0oooo0000000000000P0000000`3oool00000
0?ooo`060?ooo`030000003oool0oooo02T0oooo000Y0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0100000000`3oool000000?ooo`080?ooo`030000003oool0oooo00L0oooo0P00
000h0?ooo`030?oDV`1b^^X0oooo00@0oooo00<000000?ooo`3oool0?@3oool2000000T0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`03000000030?ooo`000000oooo00H0oooo00<0
00000?ooo`3oool0:03oool002P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`03
00000080oooo00<000000?ooo`3oool01P3oool2000000P0oooo0P00000g0?ooo`060?ooe02K0000
0000000000000780^^[o103oool3000003l0oooo0P0000080?ooo`800000203oool00`000000oooo
0?ooo`03000000030?ooo`000000oooo00H0oooo00<000000?ooo`3oool09`3oool002L0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`03000000030?ooo`000000000000P0oooo00<0
00000?ooo`3oool01P3oool2000003X0oooo00@0e9/009_Do`3oe9/0L[[Z1@3oool00`000000oooo
0?ooo`110?ooo`800000203oool00`000000oooo0?ooo`060?ooo`80000000D0oooo000000000000
00000?ooo`02000000H0oooo00<000000?ooo`3oool09P3oool002D0oooo0P0000060?ooo`030000
003oool0000000<0000000<0oooo0000003oool01`3oool2000000L0oooo0P00000l0?ooo`040?oo
e02K0780^[ZK07:jjPD0oooo00<000000?ooo`3oool0@`3oool2000000L0oooo0P0000080?ooo`03
0000003oool0000000<0000000<0oooo0000003oool01@3oool2000002H0oooo000T0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`0000000`0000000`3oool000000?ooo`070?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0?@3oool00`3oj[X0LP0007:jjP050?ooo`030000
003oool0oooo04D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000
003oool0000000<0000000<0oooo0000003oool01P3oool00`000000oooo0?ooo`0S0?ooo`008`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool00000008000000P3oool00`000000oooo0?oo
o`050?ooo`8000001`3oool2000004P0oooo00<000000?ooo`3oool0AP3oool2000000L0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`03000000030?ooo`000000oooo00H0oooo00<0
00000?ooo`3oool08P3oool00280oooo00<000000?ooo`3oool01@3oool00`000000oooo00000002
00000080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo04P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`050?ooo`8000001`3oool0
0`000000oooo0?ooo`03000000030?ooo`000000oooo00H0oooo00<000000?ooo`3oool08@3oool0
0240oooo00<000000?ooo`3oool01@3oool500000080oooo00<000000?ooo`3oool0103oool20000
00L0oooo0P00001;0?ooo`030000003oool0oooo04T0oooo0P0000070?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool00`0000000`3oool000000?ooo`060?ooo`030000003oool0oooo
0200oooo000W0?ooo`H0000000<0oooo0000000000001P3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo04/0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo0P0000000`3oool0000000000004000002P0oooo000V0?ooo`030000
003oool00000008000000P3oool00`000000oooo0?ooo`040?ooo`8000001`3oool2000004h0oooo
00<000000?ooo`3oool0C03oool2000000H0oooo0P0000070?ooo`030000003oool0000000<00000
00<0oooo0000003oool09P3oool002D0oooo00<000000?ooo`0000000P0000020?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1>0?ooo`030000003o
ool0oooo04h0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00<0000000<0oooo0000003oool09@3oool002<0oooo0P000000103oool0000000000000
00020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool200000540oooo00<0
00000?ooo`3oool0C`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool00`0000000`3oool000000000000T0?ooo`008P3oool00`000000oooo0?ooo`03
00000080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0540oooo00<000000?ooo`3oool0D03oool2000000H0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0300000080oooo00<000000?ooo`3oool08@3oool00240oooo00<000000?oo
o`3oool00`0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool20000
05@0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`040?ooo`8000001P3oool00`00
0000oooo0?ooo`0300000080oooo00<000000?ooo`3oool0803oool00280oooo100000000`3oool0
0000000000050?ooo`8000001P3oool00`000000oooo0?ooo`1D0?ooo`800000E03oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo0P000000103oool0000000000000000T0?oo
o`008@3oool4000000030?ooo`000000oooo00D0oooo00<000000?ooo`3oool0103oool2000005L0
oooo00<000000?ooo`3oool0E03oool2000000H0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0000000300000280oooo000P0?ooo`<000000P3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`1F0?ooo`030000
003oool0oooo00@0oooo0P0000060?ooo`030000003oool0000000<000008@3oool001l0oooo0`00
00000`3oool00000000000060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0F03o
ool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103o
ool2000000040?ooo`000000000000000200oooo000N0?ooo`<0000000<0oooo0000003oool01P3o
ool00`000000oooo0?ooo`030?ooo`800000F`3oool00`000000oooo0?ooo`1H0?ooo`8000001P3o
ool00`000000oooo0?ooo`050?ooo`030000003oool00000008000007`3oool001d0oooo0`000000
0`3oool000000?ooo`060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0F`3oool0
0`000000oooo0?ooo`1J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo00000002000001h0oooo000L0?ooo`<00000203oool2000000D0oooo00<000000?oo
o`3oool0G03oool00`000000oooo0?ooo`1K0?ooo`8000001@3oool2000000P0oooo0`00000M0?oo
o`006`3oool3000000P0oooo00<000000?ooo`3oool00`3oool2000005l0oooo00<000000?ooo`3o
ool0G@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo0`00000L0?ooo`00
6@3oool4000000P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1O0?ooo`030000
003oool0oooo05h0oooo0P0000050?ooo`030000003oool0oooo00H0oooo1000000J0?ooo`00603o
ool4000000L0oooo0P0000050?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool0H03o
ool00`000000oooo0?ooo`030?ooo`8000001`3oool4000001T0oooo000G0?ooo`<00000203oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0640oooo00<000000?ooo`3oool0H@3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo0`00000H0?ooo`005P3oool30000
00P0oooo00<000000?ooo`3oool00`3oool2000006@0oooo00<000000?ooo`3oool0HP3oool20000
00D0oooo00<000000?ooo`3oool01P3oool3000001L0oooo000E0?ooo`<000003P3oool00`000000
oooo0?ooo`1T0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0303oool3000001H0
oooo000C0?ooo`@000003P3oool00`000000oooo0?ooo`1U0?ooo`030000003oool0oooo06D0oooo
00<000000?ooo`3oool0303oool4000001@0oooo000B0?ooo`@000003@3oool2000006P0oooo0P00
001W0?ooo`8000003@3oool4000001<0oooo000A0?ooo`<000003P3oool00`000000oooo0?ooo`1X
0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0303oool300000180oooo000@0?oo
o`<000003P3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo06T0oooo00<000000?oo
o`3oool0303oool300000140oooo000?0?ooo`<00000N`3oool00`000000oooo0?ooo`1i0?ooo`<0
0000403oool000h0oooo0`00001l0?ooo`030000003oool0oooo07X0oooo0`00000?0?ooo`003@3o
ool3000007d0oooo00<000000?ooo`3oool0N`3oool3000000h0oooo000<0?ooo`<00000OP3oool0
0`000000oooo0?ooo`1l0?ooo`<000003@3oool000X0oooo1000001o0?ooo`030000003oool0oooo
07d0oooo1000000;0?ooo`002@3oool400000800oooo00<000000?ooo`3oool0OP3oool4000000X0
oooo00080?ooo`<00000PP3oool00`000000oooo0?ooo`200?ooo`<000002@3oool000L0oooo0`00
00230?ooo`030000003oool0oooo0840oooo0`0000080?ooo`001P3oool3000008@0oooo00<00000
0?ooo`3oool0PP3oool3000000L0oooo00050?ooo`<00000Q@3oool00`000000oooo0?ooo`230?oo
o`<000001P3oool000H0oooo00<000000?ooo`3oool0Q03oool2000008D0oooo00<000000?ooo`3o
ool01@3oool008d0oooo00<000000?ooo`3oool0S03oool008d0oooo00<000000?ooo`3oool0S03o
ool008d0oooo00<000000?ooo`3oool0S03oool008d0oooo00<000000?ooo`3oool0S03oool008d0
oooo00<000000?ooo`3oool0S03oool008d0oooo00<000000?ooo`3oool0S03oool00001\
\>"],
  ImageRangeCache->{{{137.188, 363.375}, {519.063, 279.813}} -> {-11.6186, \
7.62533, 0.0371377, 0.0371377}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DSolve[x-y[x]*y'[x]==0,y[x],x]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{y[x] \[Rule] \(-\@\(x\^2 + 2\ C[1]\)\)}, {y[
            x] \[Rule] \@\(x\^2 + 2\ C[1]\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DSolve[{x-y[x]*y'[x]==0,y[2]==3},y[x],x]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{y[x] \[Rule] \@\(5 + x\^2\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DSolve[{x-y[x]*y'[x]==0,y[-3]==-1},y[x],x]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{y[x] \[Rule] \(-\@\(\(-8\) + x\^2\)\)}}\)], "Output"]
}, Open  ]],

Cell["\<\
Clear[y1,y2,y,yp,yp1,yp2]
\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
2. Rie\[SHacek]te diferenci\[AAcute]lnu rovnicu 1/(x-1)+1/y*y'=0.
    N\[AAcute]jdite partikul\[AAcute]rne rie\[SHacek]enie, ktor\[EAcute] sp\
\:013a\:0148a za\[CHacek]. podmienku:
   \ta)y(-2)=1
  \tb)y(2)=1. 
   Nakreslite integr\[AAcute]lne krivky partikul\[AAcute]rnych rie\[SHacek]en\
\[IAcute].
------------------------------------------------------------------------------\
---\
\>", "Section",
  PageBreakAbove->True,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Arial CE",
  FontColor->RGBColor[0, 0.500008, 0],
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["DSolve[1/(x-1)+1/y[x]*y'[x]==0,y[x],x]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{y[x] \[Rule] C[1]\/\(1 - x\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["y1[x_]=y[x]/.%[[1]]/.C[1]->c", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(c\/\(1 - x\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["r1=Solve[y1[-1]==1,c]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{c \[Rule] 2}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["yp[x_]=y1[x]/.r1[[1]]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(2\/\(1 - x\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
gyp=Plot[yp[x],{x,-3,0.9},
PlotStyle->{RGBColor[1, 0, 0],Thickness[0.01]}]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.75641 0.2442 0.0147151 0.0294302 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.26801 .00222 -6 -9 ]
[.26801 .00222 6 0 ]
[.51221 .00222 -6 -9 ]
[.51221 .00222 6 0 ]
[.74391 .16187 -6 -4.5 ]
[.74391 .16187 0 4.5 ]
[.74391 .30902 -12 -4.5 ]
[.74391 .30902 0 4.5 ]
[.74391 .45617 -12 -4.5 ]
[.74391 .45617 0 4.5 ]
[.74391 .60332 -12 -4.5 ]
[.74391 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-3)] .02381 .00222 0 1 Mshowa
.26801 .01472 m
.26801 .02097 L
s
[(-2)] .26801 .00222 0 1 Mshowa
.51221 .01472 m
.51221 .02097 L
s
[(-1)] .51221 .00222 0 1 Mshowa
.125 Mabswid
.07265 .01472 m
.07265 .01847 L
s
.12149 .01472 m
.12149 .01847 L
s
.17033 .01472 m
.17033 .01847 L
s
.21917 .01472 m
.21917 .01847 L
s
.31685 .01472 m
.31685 .01847 L
s
.36569 .01472 m
.36569 .01847 L
s
.41453 .01472 m
.41453 .01847 L
s
.46337 .01472 m
.46337 .01847 L
s
.56105 .01472 m
.56105 .01847 L
s
.60989 .01472 m
.60989 .01847 L
s
.65873 .01472 m
.65873 .01847 L
s
.70757 .01472 m
.70757 .01847 L
s
.80525 .01472 m
.80525 .01847 L
s
.85409 .01472 m
.85409 .01847 L
s
.90293 .01472 m
.90293 .01847 L
s
.95177 .01472 m
.95177 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.75641 .16187 m
.76266 .16187 L
s
[(5)] .74391 .16187 1 0 Mshowa
.75641 .30902 m
.76266 .30902 L
s
[(10)] .74391 .30902 1 0 Mshowa
.75641 .45617 m
.76266 .45617 L
s
[(15)] .74391 .45617 1 0 Mshowa
.75641 .60332 m
.76266 .60332 L
s
[(20)] .74391 .60332 1 0 Mshowa
.125 Mabswid
.75641 .04415 m
.76016 .04415 L
s
.75641 .07358 m
.76016 .07358 L
s
.75641 .10301 m
.76016 .10301 L
s
.75641 .13244 m
.76016 .13244 L
s
.75641 .1913 m
.76016 .1913 L
s
.75641 .22073 m
.76016 .22073 L
s
.75641 .25016 m
.76016 .25016 L
s
.75641 .27959 m
.76016 .27959 L
s
.75641 .33845 m
.76016 .33845 L
s
.75641 .36788 m
.76016 .36788 L
s
.75641 .39731 m
.76016 .39731 L
s
.75641 .42674 m
.76016 .42674 L
s
.75641 .4856 m
.76016 .4856 L
s
.75641 .51503 m
.76016 .51503 L
s
.75641 .54446 m
.76016 .54446 L
s
.75641 .57389 m
.76016 .57389 L
s
.25 Mabswid
.75641 0 m
.75641 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.01 w
.02381 .02943 m
.06244 .03004 L
.10458 .03076 L
.14415 .0315 L
.18221 .03228 L
.22272 .03319 L
.26171 .03417 L
.30316 .03532 L
.34309 .03658 L
.3815 .03793 L
.42237 .03957 L
.46172 .04139 L
.49955 .0434 L
.53984 .04591 L
.57861 .04878 L
.61984 .05246 L
.65954 .05686 L
.69774 .06217 L
.73838 .06953 L
.77751 .07914 L
.79892 .08598 L
.81909 .0939 L
.83747 .10282 L
.85765 .11526 L
.87758 .13155 L
.8886 .14304 L
.89865 .15569 L
.90799 .16991 L
.91816 .18904 L
.9289 .21515 L
.93907 .24829 L
.94763 .286 L
.95707 .34484 L
.96182 .38522 L
.96693 .44151 L
.97176 .51296 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`003`3oool0103Z^W80000000000000VmA00?ooo`060?oDV`00000000000000000009/0e?oo
?`3oool01P3oom@0V`00000000000000001b0;[Zoh`0oooo000>0?ooo`060?oZ^P1bL[X0oooo0?oo
e02K0780^^[o@03oool00`2jLP00002K0=Coo`130?ooo`030?oDV`1b^^X0oooo08d0oooo000@0?oo
o`030=BK00000000VmCo0480oooo00<0omBK0000002Ke?l0@P3oool00`3oe9/0L[[Z0?ooo`2=0?oo
o`00203oool00`3oe9/00000000000020000000609_Do`3oool0oooo0?ooo`3oom@0Vg:j>P3oool0
0`3oe9/00000000000020000000609_Do`3oool0oooo0?ooo`3oom@0e=Co>P3oool00`3oe9/00000
000000020000000509_Do`3oool0oooo0?oDV`1b^^X0SP3oool000h0oooo00H0oooD09/0LP2jj_l0
oooD09/0V`3Doolo0?ooo`060?oZ^P1bL[X0oooo0?ooe02K09/0e?oo@03oool00`2jLY/0e=BK07:j
jP2>0?ooo`003`3oool0103oj[X0LP000000002Ke?m10?ooo`040>ZjLP000000000007:jjT40oooo
00<0omBK0000001b^^X0SP3oool00?l0oooo:`3oool00=d0oooo00<000000?ooo`3oool0BP3oool0
0=d0oooo00<000000?ooo`3oool0BP3oool00=d0oooo00<000000?ooo`3oool0BP3oool00=d0oooo
00<000000?ooo`3oool0BP3oool00=d0oooo00<000000?ooo`3oool0BP3oool000L0ooooo`00000M
000000L0oooo000>0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool04`3oool00=d0
oooo00<000000?ooo`3oool0BP3oool00=d0oooo00<000000?ooo`3oool0BP3oool000d0oooo;@3o
002S0?ooo`030000003oool0oooo04X0oooo000=0?oooe/0o`00M@3oool00`000000oooo0?ooo`1:
0?ooo`00>P3ooom40?l005l0oooo00<000000?ooo`3oool0BP3oool006P0oooo;03o00190?ooo`03
0000003oool0oooo04X0oooo001n0?ooobd0o`00<P3oool2000004/0oooo002D0?ooob80o`009`3o
ool00`000000oooo0?ooo`1:0?ooo`00Z`3ooolF0?l001`0oooo00<000000?ooo`3oool0BP3oool0
0;H0oooo4@3o000F0?ooo`030000003oool0oooo04X0oooo00310?ooo`/0o`004@3oool00`000000
oooo0?ooo`1:0?ooo`00a`3oool;0?l000/0oooo00<000000?ooo`3oool0BP3oool00<`0oooo303o
00050?ooo`030000003oool0oooo04X0oooo003B0?ooo`X0o`0000<0oooo0000003oool0B`3oool0
0=P0oooo203o001:0?ooo`00g03oool70?l004L0oooo003M0?ooo`030000003oool0oooo00L0o`00
@`3oool00=d0oooo00<000000?ooo`3oool00`3oool70?l00400oooo003M0?ooo`030000003oool0
oooo00H0oooo1`3o000m0?ooo`00g@3oool00`000000oooo0?ooo`090?ooo`L0o`00>P3oool00=d0
oooo00<000000?ooo`3oool0303oool60?l003P0oooo003M0?ooo`030000003oool0oooo00l0oooo
1P3o000e0?ooo`00g@3oool00`000000oooo0?ooo`0A0?ooo`D0o`00=03oool00=d0oooo0P00000E
0?ooo`<0o`00<`3oool00=d0oooo00<000000?ooo`3oool05@3oool40?l00340oooo003M0?ooo`03
0000003oool0oooo01H0oooo103o000`0?ooo`00g@3oool00`000000oooo0?ooo`0H0?ooo`<0o`00
;`3oool00=d0oooo00<000000?ooo`3oool06@3oool30?l002h0oooo003M0?ooo`030000003oool0
oooo01X0oooo103o000/0?ooo`00g@3oool00`000000oooo0?ooo`0K0?ooo`@0o`00:`3oool00=d0
oooo00<000000?ooo`3oool07@3oool30?l002X0oooo003M0?ooo`8000007`3oool30?l002T0oooo
003M0?ooo`030000003oool0oooo01l0oooo0`3o000X0?ooo`00g@3oool00`000000oooo0?ooo`0P
0?ooo`<0o`009`3oool00=d0oooo00<000000?ooo`3oool08@3oool30?l002H0oooo003M0?ooo`03
0000003oool0oooo0280oooo0`3o000U0?ooo`00g@3oool00`000000oooo0?ooo`0S0?ooo`<0o`00
903oool00=@0oooo00@0j[Yb000000000000L[[Z1@3oool00`000000oooo0?ooo`0T0?ooo`80o`00
903oool00=<0oooo00H0onZj079b^P3oool0oooo0;YbLP2jj_l40?ooo`030000003oool0oooo02D0
oooo0P3o000S0?ooo`00e`3oool00`3DVg80^^[o0?ooo`030?ooo`<000009P3oool20?l00280oooo
003D0?ooo`040=BK000000000000002Ke0D0oooo00<000000?ooo`3oool09`3oool20?l00240oooo
003D0?ooo`030=BKLP2jj_l0oooo00H0oooo00<000000?ooo`3oool0:03oool00`3o0000oooo0?oo
o`0O0?ooo`00e03oool0103DV`00000000000000Vm@50?ooo`030000003oool0oooo02P0oooo0P3o
000P0?ooo`00g@3oool00`000000oooo0?ooo`0Y0?ooo`030?l0003oool0oooo01h0oooo003M0?oo
o`030000003oool0oooo02T0oooo0P3o000O0?ooo`00g@3oool00`000000oooo0?ooo`0Z0?ooo`03
0?l0003oool0oooo01d0oooo003M0?ooo`030000003oool0oooo02X0oooo0P3o000N0?ooo`00g@3o
ool2000002`0oooo00<0o`000?ooo`3oool0703oool00=d0oooo00<000000?ooo`3oool0:`3oool2
0?l001d0oooo003M0?ooo`030000003oool0oooo02/0oooo0P3o000M0?ooo`00g@3oool00`000000
oooo0?ooo`0/0?ooo`80o`00703oool00=d0oooo00<000000?ooo`3oool0;03oool20?l001`0oooo
003M0?ooo`030000003oool0oooo02`0oooo0`3o000K0?ooo`00g@3oool00`000000oooo0?ooo`0]
0?ooo`80o`006`3oool00=d0oooo00<000000?ooo`3oool0;@3oool20?l001/0oooo003M0?ooo`03
0000003oool0oooo02h0oooo0P3o000J0?ooo`00g@3oool2000002l0oooo0P3o000J0?ooo`00g@3o
ool00`000000oooo0?ooo`0^0?ooo`80o`006P3oool00=d0oooo00<000000?ooo`3oool0;P3oool2
0?l001X0oooo003M0?ooo`030000003oool0oooo02h0oooo0P3o000J0?ooo`00g@3oool00`000000
oooo0?ooo`0_0?ooo`80o`006@3oool00=d0oooo00<000000?ooo`3oool0;`3oool20?l001T0oooo
003M0?ooo`030000003oool0oooo02l0oooo0P3o000I0?ooo`00g@3oool00`000000oooo0?ooo`0_
0?ooo`80o`006@3oool00=d0oooo0P00000`0?ooo`<0o`00603oool00=d0oooo00<000000?ooo`3o
ool0<03oool20?l001P0oooo003M0?ooo`030000003oool0oooo0300oooo0P3o000H0?ooo`00g@3o
ool00`000000oooo0?ooo`0`0?ooo`<0o`005`3oool00=d0oooo00<000000?ooo`3oool0<@3oool2
0?l001L0oooo003M0?ooo`030000003oool0oooo0340oooo0P3o000G0?ooo`00g@3oool00`000000
oooo0?ooo`0a0?ooo`80o`005`3oool00=d0oooo00<000000?ooo`3oool0<@3oool30?l001H0oooo
003M0?ooo`800000<`3oool20?l001H0oooo003M0?ooo`030000003oool0oooo0380oooo0P3o000F
0?ooo`00g@3oool00`000000oooo0?ooo`0b0?ooo`80o`005P3oool00=d0oooo00<000000?ooo`3o
ool0<`3oool20?l001D0oooo003M0?ooo`030000003oool0oooo03<0oooo0P3o000E0?ooo`00g@3o
ool00`000000oooo0?ooo`0c0?ooo`80o`005@3oool00=d0oooo00<000000?ooo`3oool0<`3oool2
0?l001D0oooo003=0?ooo`080?ooe02K00000000000000000780^^[o0?ooo`3Z^W820000000307:j
jP3oool0oooo00<0oooo00<000000?ooo`3oool0<`3oool20?l001D0oooo003?0?ooo`030?oDV`1b
^^X0oooo0080oooo00D0^Y^j0?ooo`3oool0^W:K0=Coo`040?ooo`030000003oool0oooo03@0oooo
0P3o000D0?ooo`00c`3oool01P3oe9/0L[[Z0?ooo`3oool0oooD09]b^P80oooo00<0e9]b0;[Zo`3o
ool00`3oool3000003@0oooo0P3o000D0?ooo`00c`3oool01P3oe9/0L[[Z0?ooo`3oool0oooD09]b
^P80oooo00<0e9]b0;[Zo`3oool00`3oool00`000000oooo0?ooo`0d0?ooo`80o`00503oool00<h0
oooo00<0^W:K0=CDV`1b^^X00`3oool01@2jLW80^^[o0?ooe02K09/0e?oo00@0oooo00<000000?oo
o`3oool0=03oool20?l001@0oooo003>0?ooo`030?oDV`000000L[[Z00<0oooo00@0onZj07800000
0000VmCo1@3oool00`000000oooo0?ooo`0d0?ooo`80o`00503oool00=d0oooo00<000000?ooo`3o
ool0=03oool20?l001@0oooo003M0?ooo`030000003oool0oooo03D0oooo0P3o000C0?ooo`00g@3o
ool00`000000oooo0?ooo`0e0?ooo`80o`004`3oool00=d0oooo00<000000?ooo`3oool0=@3oool2
0?l001<0oooo003M0?ooo`800000=P3oool20?l001<0oooo003M0?ooo`030000003oool0oooo03D0
oooo0P3o000C0?ooo`00g@3oool00`000000oooo0?ooo`0e0?ooo`80o`004`3oool00=d0oooo00<0
00000?ooo`3oool0=P3oool20?l00180oooo003M0?ooo`030000003oool0oooo03H0oooo0P3o000B
0?ooo`00g@3oool00`000000oooo0?ooo`0f0?ooo`80o`004P3oool00=d0oooo00<000000?ooo`3o
ool0=P3oool20?l00180oooo003M0?ooo`030000003oool0oooo03H0oooo0P3o000B0?ooo`00g@3o
ool2000003L0oooo0P3o000B0?ooo`00g@3oool00`000000oooo0?ooo`0f0?ooo`80o`004P3oool0
0=d0oooo00<000000?ooo`3oool0=P3oool20?l00180oooo003M0?ooo`030000003oool0oooo03H0
oooo0P3o000B0?ooo`00g@3oool00`000000oooo0?ooo`0f0?ooo`80o`004P3oool00=d0oooo00<0
00000?ooo`3oool0=P3oool20?l00180oooo003M0?ooo`030000003oool0oooo03L0oooo0P3o000A
0?ooo`00g@3oool00`000000oooo0?ooo`0g0?ooo`80o`004@3oool00=d0oooo00<000000?ooo`3o
ool0=`3oool20?l00140oooo003M0?ooo`800000>03oool20?l00140oooo003M0?ooo`030000003o
ool0oooo03L0oooo0P3o000A0?ooo`00g@3oool00`000000oooo0?ooo`0g0?ooo`80o`004@3oool0
0=d0oooo00<000000?ooo`3oool0=`3oool20?l00140oooo003M0?ooo`030000003oool0oooo03L0
oooo0P3o000A0?ooo`00g@3oool00`000000oooo0?ooo`0g0?ooo`80o`004@3oool00=d0oooo00<0
00000?ooo`3oool0=`3oool20?l00140oooo003M0?ooo`030000003oool0oooo03L0oooo0P3o000A
0?ooo`00g@3oool2000003P0oooo0P3o000A0?ooo`00g@3oool00`000000oooo0?ooo`0g0?ooo`80
o`004@3oool00=d0oooo00<000000?ooo`3oool0=`3oool20?l00140oooo003M0?ooo`030000003o
ool0oooo03L0oooo0P3o000A0?ooo`00g@3oool00`000000oooo0?ooo`0g0?ooo`80o`004@3oool0
0=d0oooo00<000000?ooo`3oool0>03oool20?l00100oooo003=0?ooo`080?ooe02K000000000000
00000780^^[o0?ooo`3Z^W820000000307:jjP3oool0oooo00<0oooo00<000000?ooo`3oool0>03o
ool20?l00100oooo003?0?ooo`060?oDV`1b^^X0oooo0?ooo`3oj[X0LW:j0P3oool00`2jLW80^^[o
0?ooo`030?ooo`030000003oool0oooo03P0oooo0P3o000@0?ooo`00c`3oool00`3oe9/0L[[Z0?oo
o`050?ooo`030=BKLP2jj_l0oooo00<0oooo0`00000h0?ooo`80o`00403oool00<l0oooo00<0omBK
07:jjP3oool00P3oool0103DV`00000000000000Vm@50?ooo`030000003oool0oooo03P0oooo0P3o
000@0?ooo`00cP3oool00`2jLY/0e=BK07:jjP030?ooo`030=BKLP2jj_l0oooo00H0oooo00<00000
0?ooo`3oool0>03oool20?l00100oooo003>0?ooo`030?oDV`000000L[[Z00<0oooo00@0e9/00000
0000000009_D1@3oool00`000000oooo0?ooo`0h0?ooo`80o`00403oool00=d0oooo00<000000?oo
o`3oool0>03oool20?l00100oooo003M0?ooo`030000003oool0oooo03P0oooo0P3o000@0?ooo`00
g@3oool00`000000oooo0?ooo`0h0?ooo`80o`00403oool00=d0oooo00<000000?ooo`3oool0>@3o
ool20?l000l0oooo003M0?ooo`030000003oool0oooo03T0oooo0P3o000?0?ooo`00g@3oool20000
03X0oooo0P3o000?0?ooo`00g@3oool00`000000oooo0?ooo`0i0?ooo`80o`003`3oool00=d0oooo
00<000000?ooo`3oool0>@3oool20?l000l0oooo003M0?ooo`030000003oool0oooo03T0oooo0P3o
000?0?ooo`00g@3oool00`000000oooo0?ooo`0i0?ooo`80o`003`3oool00=d0oooo00<000000?oo
o`3oool0>@3oool20?l000l0oooo003M0?ooo`030000003oool0oooo03T0oooo0P3o000?0?ooo`00
g@3oool00`000000oooo0?ooo`0i0?ooo`80o`003`3oool00=d0oooo0P00000k0?ooo`80o`003P3o
ool00=d0oooo00<000000?ooo`3oool0>P3oool20?l000h0oooo003M0?ooo`030000003oool0oooo
03X0oooo0P3o000>0?ooo`00g@3oool00`000000oooo0?ooo`0j0?ooo`80o`003P3oool00=d0oooo
00<000000?ooo`3oool0>P3oool20?l000h0oooo003M0?ooo`030000003oool0oooo03X0oooo0P3o
000>0?ooo`00g@3oool00`000000oooo0?ooo`0j0?ooo`80o`003P3oool00=d0oooo00<000000?oo
o`3oool0>P3oool20?l000h0oooo003M0?ooo`800000>`3oool20?l000h0oooo003M0?ooo`030000
003oool0oooo03X0oooo0P3o000>0?ooo`00g@3oool00`000000oooo0?ooo`0j0?ooo`80o`003P3o
ool00=d0oooo00<000000?ooo`3oool0>P3oool20?l000h0oooo003M0?ooo`030000003oool0oooo
03X0oooo0P3o000>0?ooo`00g@3oool00`000000oooo0?ooo`0j0?ooo`80o`003P3oool00=d0oooo
00<000000?ooo`3oool0>P3oool20?l000h0oooo003M0?ooo`030000003oool0oooo03X0oooo0P3o
000>0?ooo`00g@3oool00`000000oooo0?ooo`0j0?ooo`80o`003P3oool00=d0oooo0P00000k0?oo
o`80o`003P3oool00=d0oooo00<000000?ooo`3oool0>P3oool20?l000h0oooo003M0?ooo`030000
003oool0oooo03X0oooo0P3o000>0?ooo`00g@3oool00`000000oooo0?ooo`0j0?ooo`80o`003P3o
ool00=d0oooo00<000000?ooo`3oool0>P3oool20?l000h0oooo003M0?ooo`030000003oool0oooo
03X0oooo0P3o000>0?ooo`00c@3oool0203oe9/00000000000000000002K0=Coo`3oool0j[Yb0P00
00000`1b^^X0oooo0?ooo`030?ooo`030000003oool0oooo03X0oooo0P3o000>0?ooo`00cP3oool0
0`2jLP00002K0=Coo`030?ooo`050;ZK^P3oool0oooo0;YbV`3Dool0103oool00`000000oooo0?oo
o`0j0?ooo`80o`003P3oool00<l0oooo00H0omBK0000002Ke?l0oooo0?ooe02KL[X20?ooo`030=BK
LP2jj_l0oooo00<0oooo0`00000k0?ooo`80o`003@3oool00=00oooo00D0oooD0=CDo`3oool0oooD
09]b^P020?ooo`030=BKLP2jj_l0oooo00<0oooo00<000000?ooo`3oool0>`3oool20?l000d0oooo
003=0?ooo`0<0?oZ^P1bL[X0oooo0?ooe02K09/0e?oo0?ooo`2jLW80^^[o0?ooe02K09/0e?oo103o
ool00`000000oooo0?ooo`1:0?ooo`00cP3oool0103Z^W8000000000001b^^X20?ooo`040?oZ^P1b
0000000009_Do`D0oooo00<000000?ooo`3oool0BP3oool00=d0oooo00<000000?ooo`3oool0BP3o
ool00001\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {571.063, 424.5}} -> {-5.69384, \
62.3561, 0.0145049, 0.120356}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["t=Table[y1[x],{c,-3,3,0.5}]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({\(-\(3\/\(1 - x\)\)\), \(-\(2.5`\/\(1 - x\)\)\), \(-\(2.`\/\(1 - 
              x\)\)\), \(-\(1.5`\/\(1 - x\)\)\), \(-\(1.`\/\(1 - 
              x\)\)\), \(-\(0.5`\/\(1 - x\)\)\), 0.`\/\(1 - x\), 
      0.5`\/\(1 - x\), 1.`\/\(1 - x\), 1.5`\/\(1 - x\), 2.`\/\(1 - x\), 
      2.5`\/\(1 - x\), 3.`\/\(1 - x\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["gvr3=Plot[Evaluate[t],{x,-3,5}]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.380952 0.119048 0.309017 0.0445629 [
[.14286 .29652 -6 -9 ]
[.14286 .29652 6 0 ]
[.61905 .29652 -3 -9 ]
[.61905 .29652 3 0 ]
[.85714 .29652 -3 -9 ]
[.85714 .29652 3 0 ]
[.36845 .04164 -12 -4.5 ]
[.36845 .04164 0 4.5 ]
[.36845 .13077 -12 -4.5 ]
[.36845 .13077 0 4.5 ]
[.36845 .21989 -12 -4.5 ]
[.36845 .21989 0 4.5 ]
[.36845 .39814 -6 -4.5 ]
[.36845 .39814 0 4.5 ]
[.36845 .48727 -6 -4.5 ]
[.36845 .48727 0 4.5 ]
[.36845 .57639 -6 -4.5 ]
[.36845 .57639 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.14286 .30902 m
.14286 .31527 L
s
[(-2)] .14286 .29652 0 1 Mshowa
.61905 .30902 m
.61905 .31527 L
s
[(2)] .61905 .29652 0 1 Mshowa
.85714 .30902 m
.85714 .31527 L
s
[(4)] .85714 .29652 0 1 Mshowa
.125 Mabswid
.20238 .30902 m
.20238 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.08333 .30902 m
.08333 .31277 L
s
.02381 .30902 m
.02381 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.97619 .30902 m
.97619 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.38095 .04164 m
.3872 .04164 L
s
[(-6)] .36845 .04164 1 0 Mshowa
.38095 .13077 m
.3872 .13077 L
s
[(-4)] .36845 .13077 1 0 Mshowa
.38095 .21989 m
.3872 .21989 L
s
[(-2)] .36845 .21989 1 0 Mshowa
.38095 .39814 m
.3872 .39814 L
s
[(2)] .36845 .39814 1 0 Mshowa
.38095 .48727 m
.3872 .48727 L
s
[(4)] .36845 .48727 1 0 Mshowa
.38095 .57639 m
.3872 .57639 L
s
[(6)] .36845 .57639 1 0 Mshowa
.125 Mabswid
.38095 .06392 m
.3847 .06392 L
s
.38095 .0862 m
.3847 .0862 L
s
.38095 .10848 m
.3847 .10848 L
s
.38095 .15305 m
.3847 .15305 L
s
.38095 .17533 m
.3847 .17533 L
s
.38095 .19761 m
.3847 .19761 L
s
.38095 .24217 m
.3847 .24217 L
s
.38095 .26445 m
.3847 .26445 L
s
.38095 .28674 m
.3847 .28674 L
s
.38095 .3313 m
.3847 .3313 L
s
.38095 .35358 m
.3847 .35358 L
s
.38095 .37586 m
.3847 .37586 L
s
.38095 .42042 m
.3847 .42042 L
s
.38095 .44271 m
.3847 .44271 L
s
.38095 .46499 m
.3847 .46499 L
s
.38095 .50955 m
.3847 .50955 L
s
.38095 .53183 m
.3847 .53183 L
s
.38095 .55411 m
.3847 .55411 L
s
.38095 .01936 m
.3847 .01936 L
s
.38095 .59868 m
.3847 .59868 L
s
.25 Mabswid
.38095 0 m
.38095 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .27559 m
.06244 .27264 L
.10458 .26877 L
.14415 .26429 L
.18221 .25894 L
.22272 .25162 L
.26171 .24223 L
.28158 .23615 L
.30316 .22816 L
.32216 .21953 L
.34309 .20759 L
.36292 .19291 L
.38395 .17187 L
.40336 .14433 L
.41426 .12339 L
.42424 .09894 L
.43408 .06757 L
.44322 .0287 L
s
.44322 .0287 m
.44801 0 L
s
.4998 0 m
.49982 .61803 L
s
.5516 .61803 m
.55516 .59752 L
.56448 .55584 L
.57536 .52021 L
.58541 .49536 L
.60411 .46188 L
.61475 .44771 L
.62473 .43662 L
.64495 .41882 L
.66347 .40638 L
.68403 .3955 L
.70314 .38736 L
.7413 .37497 L
.7804 .36578 L
.82195 .35845 L
.86199 .35298 L
.9005 .34876 L
.94148 .34507 L
.97619 .34244 L
s
.02381 .28117 m
.06244 .27871 L
.10458 .27548 L
.14415 .27175 L
.18221 .26728 L
.22272 .26119 L
.26171 .25336 L
.28158 .24829 L
.30316 .24164 L
.32216 .23444 L
.34309 .2245 L
.36292 .21226 L
.38395 .19473 L
.40336 .17178 L
.41426 .15432 L
.42424 .13396 L
.43408 .10781 L
.44322 .07542 L
.45325 .02529 L
s
.45325 .02529 m
.45692 0 L
s
.4998 0 m
.49982 .61803 L
s
.54307 .61803 m
.54493 .60418 L
.55019 .57326 L
.55516 .54944 L
.56448 .5147 L
.57536 .48501 L
.58541 .4643 L
.60411 .43641 L
.61475 .42459 L
.62473 .41535 L
.64495 .40052 L
.66347 .39015 L
.68403 .38108 L
.70314 .3743 L
.7413 .36398 L
.7804 .35632 L
.82195 .35021 L
.86199 .34566 L
.9005 .34213 L
.94148 .33906 L
.97619 .33687 L
s
.02381 .28674 m
.06244 .28477 L
.10458 .28218 L
.14415 .2792 L
.18221 .27563 L
.22272 .27075 L
.26171 .26449 L
.28158 .26044 L
.30316 .25512 L
.32216 .24936 L
.34309 .2414 L
.36292 .23161 L
.38395 .21759 L
.40336 .19923 L
.41426 .18526 L
.42424 .16897 L
.43408 .14805 L
.44322 .12214 L
.45325 .08204 L
.45886 .05109 L
.46395 .01472 L
s
.46395 .01472 m
.46551 0 L
s
.4998 0 m
.49982 .61803 L
s
.53437 .61803 m
.53486 .61341 L
.53969 .57637 L
.54493 .54515 L
.55019 .52042 L
.55516 .50135 L
.56448 .47356 L
.57536 .44981 L
.58541 .43324 L
.60411 .41093 L
.61475 .40148 L
.62473 .39408 L
.64495 .38222 L
.66347 .37392 L
.68403 .36667 L
.70314 .36125 L
.7413 .35299 L
.7804 .34686 L
.82195 .34197 L
.86199 .33833 L
.9005 .33551 L
.94148 .33305 L
.97619 .3313 L
s
.02381 .29231 m
.06244 .29083 L
.10458 .28889 L
.14415 .28665 L
.18221 .28398 L
.22272 .28032 L
.26171 .27562 L
.28158 .27258 L
.30316 .26859 L
.32216 .26427 L
.34309 .2583 L
.36292 .25096 L
.38395 .24045 L
.40336 .22667 L
.41426 .2162 L
.42424 .20398 L
.43408 .18829 L
.44322 .16886 L
.45325 .13878 L
.45886 .11557 L
.46395 .08829 L
.46882 .05378 L
.47149 .02994 L
.47397 .00328 L
s
.47397 .00328 m
.4742 0 L
s
.49979 0 m
.49983 .61803 L
s
.526 .61803 m
.52923 .58129 L
.53191 .55838 L
.53486 .53731 L
.53969 .50953 L
.54493 .48612 L
.55019 .46757 L
.55516 .45327 L
.56448 .43243 L
.57536 .41461 L
.58541 .40219 L
.60411 .38545 L
.61475 .37836 L
.62473 .37282 L
.64495 .36392 L
.66347 .3577 L
.68403 .35226 L
.70314 .34819 L
.7413 .34199 L
.7804 .3374 L
.82195 .33373 L
.86199 .331 L
.9005 .32889 L
.94148 .32704 L
.97619 .32573 L
s
.02381 .29788 m
.06244 .29689 L
.10458 .2956 L
.14415 .29411 L
.18221 .29232 L
.22272 .28988 L
.26171 .28675 L
.28158 .28473 L
.30316 .28207 L
.32216 .27919 L
.34309 .27521 L
.36292 .27032 L
.38395 .2633 L
.40336 .25412 L
.41426 .24714 L
.42424 .23899 L
.43408 .22853 L
.44322 .21558 L
.45325 .19553 L
.45886 .18005 L
.46395 .16187 L
.46882 .13886 L
.47149 .12297 L
.47397 .10519 L
.47837 .06377 L
.4807 .03417 L
s
.4807 .03417 m
.48279 0 L
s
.49979 0 m
.49983 .61803 L
s
.51725 .61803 m
.51852 .59544 L
.5211 .56042 L
.52389 .53108 L
.52923 .49053 L
.53191 .47526 L
.53486 .46121 L
.53969 .44269 L
.54493 .42708 L
.55019 .41472 L
.55516 .40519 L
.56448 .39129 L
.57536 .37941 L
.58541 .37113 L
.60411 .35997 L
.61475 .35525 L
.62473 .35155 L
.64495 .34562 L
.66347 .34147 L
.68403 .33784 L
.70314 .33513 L
.7413 .331 L
.7804 .32794 L
.82195 .32549 L
.86199 .32367 L
.9005 .32226 L
.94148 .32103 L
.97619 .32016 L
s
.02381 .30345 m
.06244 .30295 L
.10458 .30231 L
.14415 .30156 L
.18221 .30067 L
.22272 .29945 L
.26171 .29789 L
.28158 .29687 L
.30316 .29554 L
.32216 .2941 L
.34309 .29211 L
.36292 .28967 L
.38395 .28616 L
.40336 .28157 L
.41426 .27808 L
.42424 .274 L
.43408 .26878 L
.44322 .2623 L
.45325 .25227 L
.45886 .24454 L
.46395 .23544 L
.46882 .22394 L
.47149 .21599 L
.47397 .20711 L
.47837 .18639 L
.4807 .1716 L
.48319 .15118 L
.48587 .12125 L
.48739 .09872 L
.48879 .07246 L
.49001 .04355 L
.49136 .00216 L
s
.49136 .00216 m
.49141 0 L
s
.49976 0 m
.49986 .61803 L
s
.50862 .61803 m
.5089 .60692 L
.51004 .57322 L
.51109 .54814 L
.51348 .50581 L
.51484 .48773 L
.51613 .47351 L
.51852 .45223 L
.5211 .43472 L
.52389 .42005 L
.52923 .39978 L
.53191 .39214 L
.53486 .38512 L
.53969 .37585 L
.54493 .36805 L
.55019 .36187 L
.55516 .3571 L
.56448 .35015 L
.57536 .34422 L
.58541 .34007 L
.60411 .33449 L
.61475 .33213 L
.62473 .33028 L
.64495 .32732 L
.66347 .32524 L
.68403 .32343 L
.70314 .32207 L
.7413 .32001 L
.7804 .31848 L
.82195 .31726 L
.86199 .31634 L
.9005 .31564 L
.94148 .31503 L
.97619 .31459 L
s
.02381 .30902 m
.02499 .30902 L
.02605 .30902 L
.02729 .30902 L
.02846 .30902 L
.02954 .30902 L
.03053 .30902 L
.03163 .30902 L
.03279 .30902 L
.03395 .30902 L
.0352 .30902 L
.03638 .30902 L
.03746 .30902 L
.03873 .30902 L
.03944 .30902 L
.04011 .30902 L
.04132 .30902 L
.04262 .30902 L
.04327 .30902 L
.04396 .30902 L
.04519 .30902 L
.04588 .30902 L
.04652 .30902 L
.04722 .30902 L
.04797 .30902 L
.04862 .30902 L
.04933 .30902 L
.05061 .30902 L
.05186 .30902 L
.05302 .30902 L
.05414 .30902 L
.05519 .30902 L
.05634 .30902 L
.05759 .30902 L
.05882 .30902 L
.06012 .30902 L
.06123 .30902 L
.06244 .30902 L
.06315 .30902 L
.06381 .30902 L
.06453 .30902 L
.06529 .30902 L
.06657 .30902 L
.06729 .30902 L
.06797 .30902 L
.06924 .30902 L
.0704 .30902 L
.07103 .30902 L
.07173 .30902 L
.073 .30902 L
Mistroke
.07376 .30902 L
.07448 .30902 L
.07513 .30902 L
.07583 .30902 L
.0766 .30902 L
.0774 .30902 L
.07809 .30902 L
.07885 .30902 L
.07956 .30902 L
.0802 .30902 L
.08095 .30902 L
.08166 .30902 L
.08291 .30902 L
.08362 .30902 L
.08427 .30902 L
.08544 .30902 L
.08669 .30902 L
.08787 .30902 L
.08896 .30902 L
.09016 .30902 L
.09148 .30902 L
.09214 .30902 L
.09285 .30902 L
.09413 .30902 L
.09483 .30902 L
.09548 .30902 L
.09619 .30902 L
.09695 .30902 L
.09821 .30902 L
.09893 .30902 L
.09961 .30902 L
.10086 .30902 L
.10201 .30902 L
.10333 .30902 L
.10458 .30902 L
.10572 .30902 L
.10694 .30902 L
.1081 .30902 L
.10916 .30902 L
.11033 .30902 L
.11162 .30902 L
.11227 .30902 L
.11297 .30902 L
.11422 .30902 L
.11491 .30902 L
.11554 .30902 L
.11624 .30902 L
.11698 .30902 L
.11822 .30902 L
.11892 .30902 L
Mistroke
.11958 .30902 L
.12081 .30902 L
.12194 .30902 L
.12323 .30902 L
.12446 .30902 L
.12562 .30902 L
.12668 .30902 L
.12789 .30902 L
.12903 .30902 L
.13009 .30902 L
.13107 .30902 L
.13214 .30902 L
.13327 .30902 L
.13441 .30902 L
.13564 .30902 L
.1368 .30902 L
.13785 .30902 L
.13909 .30902 L
.13979 .30902 L
.14043 .30902 L
.14162 .30902 L
.14288 .30902 L
.14402 .30902 L
.14526 .30902 L
.14656 .30902 L
.14777 .30902 L
.14891 .30902 L
.14994 .30902 L
.15113 .30902 L
.15226 .30902 L
.15348 .30902 L
.15478 .30902 L
.15589 .30902 L
.15711 .30902 L
.15842 .30902 L
.15915 .30902 L
.15982 .30902 L
.16113 .30902 L
.16236 .30902 L
.16352 .30902 L
.16456 .30902 L
.16577 .30902 L
.1669 .30902 L
.16796 .30902 L
.16893 .30902 L
.16999 .30902 L
.17111 .30902 L
.17225 .30902 L
.17347 .30902 L
.17462 .30902 L
Mistroke
.17566 .30902 L
.17689 .30902 L
.17758 .30902 L
.17823 .30902 L
.1794 .30902 L
.18065 .30902 L
.18185 .30902 L
.18316 .30902 L
.18441 .30902 L
.18556 .30902 L
.1867 .30902 L
.18773 .30902 L
.18893 .30902 L
.19005 .30902 L
.19128 .30902 L
.19258 .30902 L
.19369 .30902 L
.19491 .30902 L
.19623 .30902 L
.19696 .30902 L
.19763 .30902 L
.19894 .30902 L
.20017 .30902 L
.20122 .30902 L
.20238 .30902 L
.20359 .30902 L
.20472 .30902 L
.20578 .30902 L
.20675 .30902 L
.20781 .30902 L
.20894 .30902 L
.21008 .30902 L
.21129 .30902 L
.21244 .30902 L
.21349 .30902 L
.21472 .30902 L
.21541 .30902 L
.21605 .30902 L
.21723 .30902 L
.21847 .30902 L
.21968 .30902 L
.221 .30902 L
.22224 .30902 L
.2234 .30902 L
.22454 .30902 L
.22558 .30902 L
.22677 .30902 L
.2279 .30902 L
.22914 .30902 L
.23044 .30902 L
Mistroke
.23155 .30902 L
.23277 .30902 L
.23409 .30902 L
.23482 .30902 L
.2355 .30902 L
.2368 .30902 L
.23804 .30902 L
.23909 .30902 L
.24025 .30902 L
.24146 .30902 L
.2426 .30902 L
.24365 .30902 L
.24462 .30902 L
.24569 .30902 L
.24681 .30902 L
.24795 .30902 L
.24917 .30902 L
.25032 .30902 L
.25137 .30902 L
.2526 .30902 L
.25329 .30902 L
.25393 .30902 L
.2551 .30902 L
.25635 .30902 L
.25756 .30902 L
.25888 .30902 L
.26013 .30902 L
.26129 .30902 L
.26233 .30902 L
.26348 .30902 L
.26467 .30902 L
.2658 .30902 L
.26704 .30902 L
.26835 .30902 L
.26946 .30902 L
.27068 .30902 L
.272 .30902 L
.27274 .30902 L
.27341 .30902 L
.27472 .30902 L
.27595 .30902 L
.27701 .30902 L
.27817 .30902 L
.27938 .30902 L
.28052 .30902 L
.28158 .30902 L
.28255 .30902 L
.28367 .30902 L
.28474 .30902 L
.28588 .30902 L
Mistroke
.2871 .30902 L
.28825 .30902 L
.2893 .30902 L
.29053 .30902 L
.29122 .30902 L
.29186 .30902 L
.29303 .30902 L
.29427 .30902 L
.29549 .30902 L
.29618 .30902 L
.29682 .30902 L
.29799 .30902 L
.29923 .30902 L
.30034 .30902 L
.30138 .30902 L
.30252 .30902 L
.30375 .30902 L
.30499 .30902 L
.30569 .30902 L
.30634 .30902 L
.30765 .30902 L
.30839 .30902 L
.30906 .30902 L
.31026 .30902 L
.31156 .30902 L
.31278 .30902 L
.31392 .30902 L
.31497 .30902 L
.31611 .30902 L
.31718 .30902 L
.31816 .30902 L
.3193 .30902 L
.32055 .30902 L
.32173 .30902 L
.32282 .30902 L
.32406 .30902 L
.32522 .30902 L
.32626 .30902 L
.32739 .30902 L
.32862 .30902 L
.32992 .30902 L
.33103 .30902 L
.33225 .30902 L
.33356 .30902 L
.33477 .30902 L
.33541 .30902 L
.3361 .30902 L
.33683 .30902 L
.33751 .30902 L
.33876 .30902 L
Mistroke
.33991 .30902 L
.34123 .30902 L
.34249 .30902 L
.3436 .30902 L
.3448 .30902 L
.34592 .30902 L
.34694 .30902 L
.34814 .30902 L
.34945 .30902 L
.35067 .30902 L
.35181 .30902 L
.35302 .30902 L
.35431 .30902 L
.35554 .30902 L
.35665 .30902 L
.35796 .30902 L
.3587 .30902 L
.35939 .30902 L
.36064 .30902 L
.36128 .30902 L
.36198 .30902 L
.36266 .30902 L
.36337 .30902 L
.36465 .30902 L
.36536 .30902 L
.36602 .30902 L
.36675 .30902 L
.36753 .30902 L
.3682 .30902 L
.36893 .30902 L
.36962 .30902 L
.37026 .30902 L
.37146 .30902 L
.37274 .30902 L
.37394 .30902 L
.37526 .30902 L
.37651 .30902 L
.37766 .30902 L
.3788 .30902 L
.37984 .30902 L
.38103 .30902 L
.38216 .30902 L
.38339 .30902 L
.3847 .30902 L
.38581 .30902 L
.38703 .30902 L
.38834 .30902 L
.38908 .30902 L
.38975 .30902 L
.39106 .30902 L
Mistroke
.39229 .30902 L
.39334 .30902 L
.3945 .30902 L
.39571 .30902 L
.39685 .30902 L
.39791 .30902 L
.39888 .30902 L
.39994 .30902 L
.40106 .30902 L
.40221 .30902 L
.40342 .30902 L
.40457 .30902 L
.40562 .30902 L
.40685 .30902 L
.40754 .30902 L
.40818 .30902 L
.40936 .30902 L
.4106 .30902 L
.41181 .30902 L
.41313 .30902 L
.41438 .30902 L
.41554 .30902 L
.41669 .30902 L
.41772 .30902 L
.41892 .30902 L
.42005 .30902 L
.42129 .30902 L
.42259 .30902 L
.42371 .30902 L
.42493 .30902 L
.42624 .30902 L
.42698 .30902 L
.42765 .30902 L
.42896 .30902 L
.43019 .30902 L
.43125 .30902 L
.43241 .30902 L
.43362 .30902 L
.43476 .30902 L
.43582 .30902 L
.43679 .30902 L
.43791 .30902 L
.43898 .30902 L
.44012 .30902 L
.44134 .30902 L
.44249 .30902 L
.44354 .30902 L
.44477 .30902 L
.44546 .30902 L
.4461 .30902 L
Mistroke
.44727 .30902 L
.44851 .30902 L
.44973 .30902 L
.45042 .30902 L
.45106 .30902 L
.45223 .30902 L
.45347 .30902 L
.45458 .30902 L
.45562 .30902 L
.45676 .30902 L
.45799 .30902 L
.45922 .30902 L
.45992 .30902 L
.46057 .30902 L
.46188 .30902 L
.46262 .30902 L
.46329 .30902 L
.46449 .30902 L
.46579 .30902 L
.46702 .30902 L
.46815 .30902 L
.4692 .30902 L
.47034 .30902 L
.47141 .30902 L
.47239 .30902 L
.47353 .30902 L
.47478 .30902 L
.47596 .30902 L
.47705 .30902 L
.47829 .30902 L
.47945 .30902 L
.48049 .30902 L
.48162 .30902 L
.48285 .30902 L
.48415 .30902 L
.48526 .30902 L
.48648 .30902 L
.48779 .30902 L
.489 .30902 L
.48963 .30902 L
.49033 .30902 L
.49105 .30902 L
.49174 .30902 L
.49299 .30902 L
.49413 .30902 L
.49539 .30902 L
.49671 .30902 L
.49783 .30902 L
.49902 .30902 L
.50014 .30902 L
Mistroke
.50116 .30902 L
.50236 .30902 L
.50366 .30902 L
.50489 .30902 L
.50603 .30902 L
.50723 .30902 L
.50853 .30902 L
.50975 .30902 L
.51087 .30902 L
.51218 .30902 L
.51292 .30902 L
.51361 .30902 L
.51486 .30902 L
.5155 .30902 L
.5162 .30902 L
.51687 .30902 L
.51759 .30902 L
.51886 .30902 L
.51958 .30902 L
.52024 .30902 L
.52096 .30902 L
.52174 .30902 L
.52241 .30902 L
.52314 .30902 L
.52383 .30902 L
.52447 .30902 L
.52568 .30902 L
.52695 .30902 L
.52816 .30902 L
.52947 .30902 L
.53072 .30902 L
.53187 .30902 L
.53301 .30902 L
.53405 .30902 L
.53525 .30902 L
.53637 .30902 L
.5376 .30902 L
.53891 .30902 L
.54002 .30902 L
.54124 .30902 L
.54255 .30902 L
.54329 .30902 L
.54396 .30902 L
.54526 .30902 L
.5465 .30902 L
.54755 .30902 L
.54871 .30902 L
.54992 .30902 L
.55105 .30902 L
.55211 .30902 L
Mistroke
.55308 .30902 L
.55415 .30902 L
.55527 .30902 L
.55641 .30902 L
.55763 .30902 L
.55878 .30902 L
.55982 .30902 L
.56105 .30902 L
.56175 .30902 L
.56238 .30902 L
.56356 .30902 L
.5648 .30902 L
.56601 .30902 L
.56734 .30902 L
.56858 .30902 L
.56974 .30902 L
.57088 .30902 L
.57192 .30902 L
.57312 .30902 L
.57425 .30902 L
.57548 .30902 L
.57679 .30902 L
.5779 .30902 L
.57912 .30902 L
.58044 .30902 L
.58118 .30902 L
.58185 .30902 L
.58315 .30902 L
.58439 .30902 L
.58544 .30902 L
.5866 .30902 L
.58782 .30902 L
.58895 .30902 L
.59001 .30902 L
.59098 .30902 L
.5921 .30902 L
.59317 .30902 L
.59431 .30902 L
.59553 .30902 L
.59668 .30902 L
.59773 .30902 L
.59896 .30902 L
.59965 .30902 L
.60029 .30902 L
.60146 .30902 L
.60271 .30902 L
.60392 .30902 L
.60461 .30902 L
.60525 .30902 L
.60642 .30902 L
Mistroke
.60766 .30902 L
.60876 .30902 L
.6098 .30902 L
.61094 .30902 L
.61217 .30902 L
.61341 .30902 L
.6141 .30902 L
.61475 .30902 L
.61607 .30902 L
.6168 .30902 L
.61747 .30902 L
.61867 .30902 L
.61997 .30902 L
.6212 .30902 L
.62233 .30902 L
.62339 .30902 L
.62452 .30902 L
.62559 .30902 L
.62657 .30902 L
.62771 .30902 L
.62896 .30902 L
.63014 .30902 L
.63123 .30902 L
.63247 .30902 L
.63363 .30902 L
.63467 .30902 L
.6358 .30902 L
.63703 .30902 L
.63833 .30902 L
.63944 .30902 L
.64066 .30902 L
.64197 .30902 L
.64318 .30902 L
.64381 .30902 L
.6445 .30902 L
.64523 .30902 L
.64591 .30902 L
.64716 .30902 L
.64831 .30902 L
.64956 .30902 L
.65088 .30902 L
.652 .30902 L
.65319 .30902 L
.65431 .30902 L
.65533 .30902 L
.65653 .30902 L
.65784 .30902 L
.65906 .30902 L
.6602 .30902 L
.6614 .30902 L
Mistroke
.6627 .30902 L
.66392 .30902 L
.66504 .30902 L
.66635 .30902 L
.66709 .30902 L
.66777 .30902 L
.66903 .30902 L
.66966 .30902 L
.67036 .30902 L
.67104 .30902 L
.67175 .30902 L
.67303 .30902 L
.67374 .30902 L
.6744 .30902 L
.67513 .30902 L
.67591 .30902 L
.67658 .30902 L
.67731 .30902 L
.678 .30902 L
.67864 .30902 L
.67984 .30902 L
.68112 .30902 L
.68232 .30902 L
.68364 .30902 L
.68488 .30902 L
.68603 .30902 L
.68718 .30902 L
.68821 .30902 L
.68941 .30902 L
.69053 .30902 L
.69176 .30902 L
.69307 .30902 L
.69418 .30902 L
.6954 .30902 L
.69671 .30902 L
.69745 .30902 L
.69812 .30902 L
.69942 .30902 L
.70066 .30902 L
.70171 .30902 L
.70286 .30902 L
.70407 .30902 L
.70521 .30902 L
.70627 .30902 L
.70724 .30902 L
.7083 .30902 L
.70942 .30902 L
.71056 .30902 L
.71178 .30902 L
.71293 .30902 L
Mistroke
.71398 .30902 L
.71521 .30902 L
.7159 .30902 L
.71654 .30902 L
.71771 .30902 L
.71896 .30902 L
.72017 .30902 L
.72149 .30902 L
.72273 .30902 L
.72389 .30902 L
.72503 .30902 L
.72607 .30902 L
.72727 .30902 L
.7284 .30902 L
.72963 .30902 L
.73094 .30902 L
.73205 .30902 L
.73327 .30902 L
.73458 .30902 L
.73532 .30902 L
.73599 .30902 L
.7373 .30902 L
.73853 .30902 L
.73959 .30902 L
.74075 .30902 L
.74196 .30902 L
.7431 .30902 L
.74416 .30902 L
.74513 .30902 L
.74619 .30902 L
.74731 .30902 L
.74846 .30902 L
.74967 .30902 L
.75083 .30902 L
.75187 .30902 L
.7531 .30902 L
.75379 .30902 L
.75443 .30902 L
.75561 .30902 L
.75685 .30902 L
.75806 .30902 L
.75875 .30902 L
.75939 .30902 L
.76056 .30902 L
.7618 .30902 L
.7629 .30902 L
.76394 .30902 L
.76508 .30902 L
.76631 .30902 L
.76754 .30902 L
Mistroke
.76824 .30902 L
.76889 .30902 L
.7702 .30902 L
.77094 .30902 L
.77161 .30902 L
.7728 .30902 L
.7741 .30902 L
.77533 .30902 L
.77646 .30902 L
.77752 .30902 L
.77865 .30902 L
.77972 .30902 L
.7807 .30902 L
.78184 .30902 L
.78309 .30902 L
.78427 .30902 L
.78536 .30902 L
.7866 .30902 L
.78776 .30902 L
.7888 .30902 L
.78993 .30902 L
.79116 .30902 L
.79246 .30902 L
.79357 .30902 L
.79479 .30902 L
.7961 .30902 L
.7973 .30902 L
.79793 .30902 L
.79863 .30902 L
.79936 .30902 L
.80004 .30902 L
.80129 .30902 L
.80243 .30902 L
.80369 .30902 L
.80501 .30902 L
.80612 .30902 L
.80731 .30902 L
.80843 .30902 L
.80945 .30902 L
.81066 .30902 L
.81196 .30902 L
.81318 .30902 L
.81432 .30902 L
.81552 .30902 L
.81682 .30902 L
.81804 .30902 L
.81916 .30902 L
.82047 .30902 L
.8212 .30902 L
.82189 .30902 L
Mistroke
.82315 .30902 L
.82385 .30902 L
.82448 .30902 L
.82516 .30902 L
.82587 .30902 L
.82715 .30902 L
.82786 .30902 L
.82852 .30902 L
.82925 .30902 L
.83002 .30902 L
.8307 .30902 L
.83143 .30902 L
.83212 .30902 L
.83275 .30902 L
.83396 .30902 L
.83524 .30902 L
.83644 .30902 L
.83775 .30902 L
.839 .30902 L
.84015 .30902 L
.84129 .30902 L
.84232 .30902 L
.84352 .30902 L
.84464 .30902 L
.84587 .30902 L
.84718 .30902 L
.84829 .30902 L
.8495 .30902 L
.85082 .30902 L
.85155 .30902 L
.85222 .30902 L
.85353 .30902 L
.85476 .30902 L
.85581 .30902 L
.85697 .30902 L
.85818 .30902 L
.85932 .30902 L
.86037 .30902 L
.86134 .30902 L
.86241 .30902 L
.86353 .30902 L
.86467 .30902 L
.86589 .30902 L
.86704 .30902 L
.86808 .30902 L
.86931 .30902 L
.87 .30902 L
.87064 .30902 L
.87182 .30902 L
.87306 .30902 L
Mistroke
.87427 .30902 L
.87559 .30902 L
.87684 .30902 L
.87799 .30902 L
.87914 .30902 L
.88017 .30902 L
.88137 .30902 L
.88249 .30902 L
.88373 .30902 L
.88503 .30902 L
.88615 .30902 L
.88737 .30902 L
.88868 .30902 L
.88942 .30902 L
.89009 .30902 L
.89139 .30902 L
.89263 .30902 L
.89368 .30902 L
.89484 .30902 L
.89605 .30902 L
.89719 .30902 L
.89825 .30902 L
.89922 .30902 L
.90029 .30902 L
.90141 .30902 L
.90255 .30902 L
.90377 .30902 L
.90492 .30902 L
.90596 .30902 L
.90719 .30902 L
.90789 .30902 L
.90852 .30902 L
.9097 .30902 L
.91094 .30902 L
.91216 .30902 L
.91284 .30902 L
.91348 .30902 L
.91464 .30902 L
.91589 .30902 L
.91699 .30902 L
.91803 .30902 L
.91917 .30902 L
.9204 .30902 L
.92163 .30902 L
.92233 .30902 L
.92297 .30902 L
.92429 .30902 L
.92502 .30902 L
.92569 .30902 L
.92689 .30902 L
Mistroke
.92819 .30902 L
.92941 .30902 L
.93055 .30902 L
.9316 .30902 L
.93273 .30902 L
.9338 .30902 L
.93478 .30902 L
.93592 .30902 L
.93717 .30902 L
.93835 .30902 L
.93944 .30902 L
.94068 .30902 L
.94184 .30902 L
.94288 .30902 L
.94401 .30902 L
.94524 .30902 L
.94654 .30902 L
.94765 .30902 L
.94887 .30902 L
.94975 .30902 L
.95057 .30902 L
.95146 .30902 L
.95241 .30902 L
.95324 .30902 L
.95401 .30902 L
.95486 .30902 L
.95577 .30902 L
.95653 .30902 L
.95737 .30902 L
.95824 .30902 L
.95905 .30902 L
.95981 .30902 L
.9605 .30902 L
.9613 .30902 L
.96206 .30902 L
.96287 .30902 L
.96377 .30902 L
.96471 .30902 L
.96559 .30902 L
.96641 .30902 L
.96716 .30902 L
.96802 .30902 L
.96884 .30902 L
.96972 .30902 L
.97067 .30902 L
.97155 .30902 L
.97236 .30902 L
.97331 .30902 L
.97433 .30902 L
.9753 .30902 L
Mistroke
.97619 .30902 L
Mfstroke
.02381 .31459 m
.06244 .31508 L
.10458 .31573 L
.14415 .31647 L
.18221 .31736 L
.22272 .31858 L
.26171 .32015 L
.28158 .32116 L
.30316 .32249 L
.32216 .32393 L
.34309 .32592 L
.36292 .32837 L
.38395 .33187 L
.40336 .33646 L
.41426 .33996 L
.42424 .34403 L
.43408 .34926 L
.44322 .35574 L
.45325 .36576 L
.45886 .3735 L
.46395 .38259 L
.46882 .3941 L
.47149 .40204 L
.47397 .41093 L
.47837 .43164 L
.4807 .44644 L
.48319 .46686 L
.48587 .49678 L
.48739 .51932 L
.48879 .54558 L
.49001 .57449 L
.49136 .61588 L
s
.49136 .61588 m
.49141 .61803 L
s
.49976 .61803 m
.49986 0 L
s
.50862 0 m
.5089 .01112 L
.51004 .04482 L
.51109 .0699 L
.51348 .11223 L
.51484 .1303 L
.51613 .14452 L
.51852 .1658 L
.5211 .18332 L
.52389 .19799 L
.52923 .21826 L
.53191 .2259 L
.53486 .23292 L
.53969 .24218 L
.54493 .24998 L
.55019 .25617 L
.55516 .26093 L
.56448 .26788 L
.57536 .27382 L
.58541 .27796 L
.60411 .28354 L
.61475 .2859 L
.62473 .28775 L
.64495 .29072 L
.66347 .29279 L
.68403 .2946 L
.70314 .29596 L
.7413 .29802 L
.7804 .29956 L
.82195 .30078 L
.86199 .30169 L
.9005 .30239 L
.94148 .30301 L
.97619 .30345 L
s
.02381 .32016 m
.06244 .32114 L
.10458 .32243 L
.14415 .32393 L
.18221 .32571 L
.22272 .32815 L
.26171 .33128 L
.28158 .33331 L
.30316 .33597 L
.32216 .33885 L
.34309 .34283 L
.36292 .34772 L
.38395 .35473 L
.40336 .36391 L
.41426 .37089 L
.42424 .37904 L
.43408 .3895 L
.44322 .40246 L
.45325 .42251 L
.45886 .43798 L
.46395 .45617 L
.46882 .47917 L
.47149 .49507 L
.47397 .51284 L
.47837 .55427 L
.4807 .58386 L
s
.4807 .58386 m
.48279 .61803 L
s
.49979 .61803 m
.49983 0 L
s
.51725 0 m
.51852 .02259 L
.5211 .05762 L
.52389 .08695 L
.52923 .1275 L
.53191 .14278 L
.53486 .15682 L
.53969 .17534 L
.54493 .19095 L
.55019 .20332 L
.55516 .21285 L
.56448 .22674 L
.57536 .23862 L
.58541 .2469 L
.60411 .25806 L
.61475 .26279 L
.62473 .26648 L
.64495 .27242 L
.66347 .27656 L
.68403 .28019 L
.70314 .2829 L
.7413 .28703 L
.7804 .2901 L
.82195 .29254 L
.86199 .29436 L
.9005 .29577 L
.94148 .297 L
.97619 .29788 L
s
.02381 .32573 m
.06244 .3272 L
.10458 .32914 L
.14415 .33138 L
.18221 .33406 L
.22272 .33772 L
.26171 .34241 L
.28158 .34545 L
.30316 .34944 L
.32216 .35376 L
.34309 .35973 L
.36292 .36707 L
.38395 .37759 L
.40336 .39136 L
.41426 .40183 L
.42424 .41405 L
.43408 .42974 L
.44322 .44918 L
.45325 .47925 L
.45886 .50246 L
.46395 .52974 L
.46882 .56425 L
.47149 .58809 L
.47397 .61475 L
s
.47397 .61475 m
.4742 .61803 L
s
.49979 .61803 m
.49983 0 L
s
.526 0 m
.52923 .03674 L
.53191 .05966 L
.53486 .08072 L
.53969 .1085 L
.54493 .13192 L
.55019 .15047 L
.55516 .16476 L
.56448 .18561 L
.57536 .20342 L
.58541 .21585 L
.60411 .23258 L
.61475 .23967 L
.62473 .24522 L
.64495 .25412 L
.66347 .26034 L
.68403 .26578 L
.70314 .26984 L
.7413 .27604 L
.7804 .28064 L
.82195 .2843 L
.86199 .28703 L
.9005 .28915 L
.94148 .29099 L
.97619 .29231 L
s
.02381 .3313 m
.06244 .33327 L
.10458 .33585 L
.14415 .33883 L
.18221 .3424 L
.22272 .34728 L
.26171 .35354 L
.28158 .35759 L
.30316 .36292 L
.32216 .36868 L
.34309 .37663 L
.36292 .38642 L
.38395 .40045 L
.40336 .41881 L
.41426 .43277 L
.42424 .44907 L
.43408 .46998 L
.44322 .4959 L
.45325 .536 L
.45886 .56694 L
.46395 .60332 L
s
.46395 .60332 m
.46551 .61803 L
s
.4998 .61803 m
.49982 0 L
s
.53437 0 m
.53486 .00462 L
.53969 .04167 L
.54493 .07288 L
.55019 .09762 L
.55516 .11668 L
.56448 .14447 L
.57536 .16822 L
.58541 .18479 L
.60411 .20711 L
.61475 .21655 L
.62473 .22395 L
.64495 .23582 L
.66347 .24411 L
.68403 .25136 L
.70314 .25679 L
.7413 .26505 L
.7804 .27118 L
.82195 .27606 L
.86199 .27971 L
.9005 .28252 L
.94148 .28498 L
.97619 .28674 L
s
.02381 .33687 m
.06244 .33933 L
.10458 .34256 L
.14415 .34629 L
.18221 .35075 L
.22272 .35685 L
.26171 .36468 L
.28158 .36974 L
.30316 .37639 L
.32216 .38359 L
.34309 .39354 L
.36292 .40577 L
.38395 .4233 L
.40336 .44626 L
.41426 .46371 L
.42424 .48408 L
.43408 .51023 L
.44322 .54262 L
.45325 .59274 L
s
.45325 .59274 m
.45692 .61803 L
s
.4998 .61803 m
.49982 0 L
s
.54307 0 m
.54493 .01385 L
.55019 .04477 L
.55516 .0686 L
.56448 .10333 L
.57536 .13302 L
.58541 .15373 L
.60411 .18163 L
.61475 .19344 L
.62473 .20268 L
.64495 .21752 L
.66347 .22788 L
.68403 .23695 L
.70314 .24373 L
.7413 .25405 L
.7804 .26172 L
.82195 .26782 L
.86199 .27238 L
.9005 .2759 L
.94148 .27898 L
.97619 .28117 L
s
.02381 .34244 m
.06244 .34539 L
.10458 .34927 L
.14415 .35374 L
.18221 .3591 L
.22272 .36641 L
.26171 .37581 L
.28158 .38188 L
.30316 .38987 L
.32216 .39851 L
.34309 .41044 L
.36292 .42512 L
.38395 .44616 L
.40336 .4737 L
.41426 .49465 L
.42424 .51909 L
.43408 .55047 L
.44322 .58934 L
s
.44322 .58934 m
.44801 .61803 L
s
.4998 .61803 m
.49982 0 L
s
.5516 0 m
.55516 .02051 L
.56448 .0622 L
.57536 .09782 L
.58541 .12268 L
.60411 .15615 L
.61475 .17032 L
.62473 .18142 L
.64495 .19922 L
.66347 .21166 L
.68403 .22254 L
.70314 .23067 L
.7413 .24306 L
.7804 .25226 L
.82195 .25958 L
.86199 .26505 L
.9005 .26928 L
.94148 .27297 L
.97619 .27559 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oK@3oool0
0`000000oooo0?ooo`0@0?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo
000000020?ooo`050000003oool000000?ooo`0000000P3oool00`000000oooo000000020?ooo`03
0000003oool000000080oooo00<000000?ooo`3oool0O`3oool006d0oooo00<000000?ooo`3oool0
403oool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`0000000P3oool01@00
0000oooo0000003oool000000080oooo00<000000?ooo`0000000P3oool00`000000oooo00000002
0?ooo`030000003oool0oooo07l0oooo001]0?ooo`030000003oool0oooo0100oooo00H000000?oo
o`3oool000000?ooo`0000020?ooo`030000003oool000000080oooo00<000000?ooo`0000000P3o
ool01@000000oooo0000003oool000000080oooo00<000000?ooo`0000000P3oool00`000000oooo
0?ooo`1o0?ooo`00K@3oool00`000000oooo0?ooo`0@0?ooo`060000003oool0oooo0000003oool0
00000P3oool00`000000oooo000000020?ooo`030000003oool000000080oooo00D000000?ooo`00
0000oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0OP3oool0
06d0oooo00<000000?ooo`3oool03`3oool010000000oooo0?ooo`0000020?ooo`060000003oool0
oooo0000003oool000000P3oool00`000000oooo000000020?ooo`050000003oool000000?ooo`00
00000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo07h0oooo001]0?ooo`80
0000403oool010000000oooo0?ooo`0000020?ooo`050000003oool000000?ooo`0000000`3oool0
0`000000oooo000000020?ooo`050000003oool000000?ooo`0000000P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo07h0oooo001]0?ooo`030000003oool0oooo00l0oooo00@0
00000?ooo`3oool000000P3oool01@000000oooo0000003oool000000080oooo00@000000?ooo`3o
ool000000P3oool00`000000oooo000000020?ooo`030000003oool000000080oooo00@000000?oo
o`3oool00000P03oool006d0oooo00<000000?ooo`3oool03`3oool01P000000oooo0?ooo`000000
oooo00000080oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000
003oool000000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0oooo
07h0oooo001]0?ooo`030000003oool0oooo00l0oooo00H000000?ooo`3oool000000?ooo`000002
0?ooo`030000003oool000000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0000
00020?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo0?ooo`1n0?ooo`00
I03oool01@3oom@0V`00000000000780^^[o00@0oooo00<000000?ooo`3oool03`3oool01P000000
oooo0?ooo`000000oooo00000080oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`00
00020?ooo`030000003oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`00001o0?ooo`00I03oool01@3DV`00VmCo0?ooo`3oom@0e=Co00@0oooo00<000000?ooo`3o
ool03P3oool010000000oooo0?ooo`0000020?ooo`060000003oool0oooo0000003oool000000P3o
ool010000000oooo0?ooo`0000020?ooo`030000003oool000000080oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`00001o0?ooo`00H`3oool01P3oom@0V`0007:jjP3oool0j[Yb
09_Do`@0oooo0`00000>0?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool00000
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo000007l0oooo001M0?ooo`030?oDV`000000
00000080000000H0VmCo0?ooo`2jLY/0LW8000000000L[X50?ooo`030000003oool0oooo00h0oooo
00H000000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3o
ool000000P3oool00`000000oooo0?ooo`1m0?ooo`00I03oool00`3oe9/007:j0?ooo`060?ooo`03
0000003oool0oooo00h0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo0000
0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`1m0?ooo`00I@3oool0103Z
^W8000000000002Ke?l40?ooo`030000003oool0oooo00d0oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`060000003oool0oooo0000003oool00000
O`3oool006d0oooo00<000000?ooo`3oool03@3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo
0?ooo`1l0?ooo`00K@3oool00`000000oooo0?ooo`0=0?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000
003oool0oooo07`0oooo001]0?ooo`030000003oool0oooo00d0oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool0O03oool006d0oooo0P00000=0?ooo`050000003oool0oooo0?ooo`000000
0P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`060000003oool0oooo0000003oool0
0000OP3oool006d0oooo00<000000?ooo`3oool0303oool010000000oooo0?ooo`0000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0oooo07/0oooo001]0?ooo`030000003oool0oooo00`0oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`3oool0N`3oool006d0oooo00<000000?ooo`3oool02`3oool01@000000oooo
0?ooo`3oool000000080oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo07/0oooo001]0?ooo`030000003oool0oooo00/0oooo
00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo000000<0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo00000080oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo07X0oooo001]0?ooo`030000
003oool0oooo00/0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000`3oool010000000oooo0?oo
o`0000020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`1j0?ooo`00
K@3oool2000000/0oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003o
ool0oooo00000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo07T0
oooo001]0?ooo`030000003oool0oooo00X0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0
oooo000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`03
0000003oool0oooo07T0oooo001]0?ooo`030000003oool0oooo00X0oooo00@000000?ooo`3oool0
00000`3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000`3oool0
10000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool0
00000`3oool00`000000oooo0?ooo`1i0?ooo`00K@3oool00`000000oooo0?ooo`090?ooo`050000
003oool0oooo0?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo
000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo000000<0oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo07P0oooo001]0?ooo`030000
003oool0oooo00T0oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo0000
00<0oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`1h0?ooo`00K@3oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo000000<0
oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo000000<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0N03oool006d0oooo00<000000?ooo`3oool0
203oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?oo
o`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo07L0
oooo001]0?ooo`8000002@3oool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3o
ool00000103oool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000`3o
ool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`1g0?ooo`00K@3oool00`000000oooo0?ooo`070?ooo`050000003oool0oooo0?ooo`00
0000103oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo000000<0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool0
00000`3oool00`000000oooo0?ooo`1g0?ooo`00K@3oool00`000000oooo0?ooo`070?ooo`050000
003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?oo
o`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?oo
o`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo07L0
oooo001]0?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3oool0oooo000000040?ooo`05
0000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0MP3oool006D0oooo00@0j[Yb000000000780
^^[o103oool00`000000oooo0?ooo`060?ooo`050000003oool0oooo0?ooo`000000103oool01@00
0000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003o
ool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`00001h0?ooo`00IP3oool00`3oe9/0L[[Z0?ooo`040?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`04
0000003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
0`3oool01@000000oooo0?ooo`3oool0000007L0oooo001S0?ooo`060?ooe02K0000000000000000
0780^^[o103oool3000000D0oooo00D000000?ooo`3oool0oooo000000040?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
0`3oool01@000000oooo0?ooo`3oool0000000@0oooo00D000000?ooo`3oool0oooo000000040?oo
o`040000003oool0oooo000007L0oooo001M0?ooo`030?oDV`00000000000080000000H0VmCo0?oo
o`3DV`00VmCo0?oDV`1b^^X50?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
00@0oooo00D000000?ooo`3oool0oooo000000040?ooo`050000003oool0oooo0?ooo`000000MP3o
ool006@0oooo00@0oooD09/0LP2j^Y/0L[[Z1@3oool00`000000oooo0?ooo`040?ooo`050000003o
ool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo07<0oooo001U0?ooo`030?oZ^P1b0000L[[Z00D0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000001e0?ooo`00K@3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0780oooo001]0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0
L@3oool006d0oooo0P0000030?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0740oooo001]0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3oool0000000D0oooo00<0
00000?ooo`3oool0L03oool006d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0K`3oool006d0oooo00@00000
0?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0K`3oool006d0oooo
00<000000?ooo`000000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0KP3oool006d0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0K@3oool006d0oooo0P0000040?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1/0?ooo`00K@3oool2
000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo06`0oooo001/0?ooo`8000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0J`3oool006/0oooo00<000000?ooo`0000000P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0JP3oool006X0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0J@3oool006T0oooo00L000000?ooo`3oool0oooo0000003oool00000
00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1X0?ooo`00J03oool00`000000
oooo0?ooo`020?ooo`8000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo06L0
oooo001V0?ooo`8000001@3oool2000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`1V0?ooo`00I@3oool00`000000oooo0?ooo`040?ooo`8000001@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo06D0oooo001S0?ooo`8000001@3oool2000000030?ooo`000000
oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool00`3oool2000006D0oooo001R0?ooo`030000003oool0oooo
00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo0P00001S
0?ooo`00H03oool2000000H0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`000006
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool2000000H0oooo0P00001Q
0?ooo`00GP3oool2000000<0oooo00<0omBK0000000000000P0000000`3Dool0oooo0?ooo`020?oo
o`030000003oool0000000H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo0P00001O0?ooo`00G03oool2000000H0oooo00<0^W800000003D
ool01P3oool2000000H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00H0oooo0P00001M0?ooo`00FP3oool2000000L0oooo0P0000000`3oe9/00000
09_Do`040?ooo`@00000103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`8000001P3oool2000000P0oooo
0P00001K0?ooo`00F03oool2000000<0oooo00<0omBK0000000000000`0000030?ooo`030?ooe03D
e?l0oooo0080oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01P3oool2000000L0oooo00<000000?ooo`3oool01@3o
ool2000000P0oooo0P00001I0?ooo`00EP3oool2000000P0oooo0P0000001`3oool0onZj079b^P3o
ool0oooD09/0V`3Dool00P0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1@3oool2000000L0oooo0`0000070?ooo`800000E`3oool00580oooo100000080?ooo`800000103o
ool01@3Z^W8000000000001b^^X0000000@0oooo00<000000?ooo`3oool00P0000090?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`800000
203oool3000000H0oooo0P00001E0?ooo`00C`3oool3000000T0oooo0`0000080?ooo`8000001@3o
ool00`000000oooo0000000:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3o
ool2000000P0oooo0P0000090?ooo`<000001@3oool400000540oooo001=0?ooo`8000002P3oool2
000000T0oooo0P0000070?ooo`8000002P3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool01`3oool3000000T0oooo0P0000070?ooo`@00000C@3oool0
04X0oooo0`0000090?ooo`<00000203oool3000000P0oooo0`0000080?ooo`8000002`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`080?ooo`8000002P3oool2000000T0oooo0`0000080?ooo`<00000BP3oool004H0
oooo100000080?ooo`@00000203oool3000000T0oooo0P0000000`3oool000000?ooo`070?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool2000000X0oooo0P00000:0?ooo`@0
00001`3oool4000004H0oooo00120?ooo`@00000203oool4000000T0oooo0`00000:0?ooo`800000
0`3oool00`000000oooo0?ooo`040?ooo`800000303oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool2000000/0oooo0P00000:0?ooo`800000
303oool4000000L0oooo100000120?ooo`00?P3oool4000000L0oooo1@00000;0?ooo`8000002`3o
ool2000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`8000002`3o
ool3000000T0oooo1000000<0?ooo`@000001`3oool4000003h0oooo000h0?ooo`H000001@3oool6
000000/0oooo1@00000;0?ooo`8000001`3oool010000000oooo0?ooo`3oool2000000h0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo0P00
000<0?ooo`<000002P3oool5000000/0oooo1P0000050?ooo`H00000>03oool002l0oooo2@000006
0?ooo`D000002`3oool6000000`0oooo100000090?ooo`040000003oool00000000000l0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`8000003P3oool2000000d0oooo0`00
000<0?ooo`H000002`3oool5000000H0oooo2@00000_0?ooo`009`3oool8000000T0oooo1P00000;
0?ooo`D00000303oool6000000d0oooo0P00000@0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`8000003P3oool3000000l0oooo1@00000;
0?ooo`H000002@3oool9000002H0oooo000Q0?ooo`H000000P3oool01P3oe9/00000000000000000
002K0=Coo`T000002`3oool6000000d0oooo1000000@0?ooo`@000003`3oool200000100oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0:0?ooo`030?oDV`000000000000@000003P3o
ool400000100oooo1P00000;0?ooo`H000001P3oool0103Z^W8000000000LP2jj_l20?ooo`H00000
803oool001T0oooo200000030?ooo`/00000303oool8000000l0oooo1000000@0?ooo`@000000`3o
ool00`000000oooo0?ooo`0;0?ooo`8000004P3oool00`000000oooo0?ooo`0@0?ooo`8000002`3o
ool00`2jLP00002K0=Coo`030?ooo`800000403oool500000140oooo1@00000<0?ooo`H0000000<0
oooo0?oDV`1b^^X02@3oool8000001P0oooo00070?oooad000001`3oool0103oe9/0000009_Do`3o
ool<000000h0oooo2@00000>0?ooo`H000001`3oool00`000000oooo0?ooo`080?ooo`<00000503o
ool00`000000oooo0?ooo`0B0?ooo`8000002P3oool00`3oe9/0000009_Do`040?ooo`@000004@3o
ool600000100oooo1P00000:0?ooo`030?ooe02K0000000000P000002`3oool@000000P0oooo000=
0?ooo``000002P3oool00`3oe9/0000000000009000001@0oooo1P00000A0?ooo`H000003@3oool0
0`000000oooo0?ooo`050?ooo`<000005`3oool00`000000oooo0?ooo`0D0?ooo`<00000203oool0
0`3oom@0e=Co0?ooo`070?ooo`H000004@3oool8000000h0oooo2@0000020?ooo`040=BK002Ke?l0
omBK07:jjPH0oooo5@00000>0?ooo`001`3oool6000000`0oooo2`0000050?ooo`060?oZ^P1bL[X0
oooo0?ooe02K09/0e?oo303oool800000140oooo1P00000C0?ooo`040000003oool0oooo0?ooo`@0
00006P3oool00`000000oooo0?ooo`0G0?ooo`<000000P3oool01P3oj[X0LW:j0?ooo`3oom@0V`2K
0=Coo`d0oooo1P00000C0?ooo`/00000303ooolG000000X0oooo1P0000080?ooo`003@3oool<0000
0140oooo00D0j[Yb000000000000L[[Z0?ooo`0<000001<0oooo1P00000H0?ooo`D000007P3oool0
0`000000oooo0?ooo`0J0?ooo`H0000000<0L[[Z0?ooo`3oool04P3oool8000001H0oooo30000003
0?ooo`030?oZ^P1b0000L[[Z0140oooo2P00000>0?ooo`001`3oool6000000`0oooo5P00000G0?oo
o`P00000603oool6000000030?ooo`00000000000200oooo00<000000?ooo`3oool0803oool40000
01T0oooo2`00000G0?oooaL000002P3oool6000000P0oooo00070?oooa8000005P3ooolG000001X0
oooo1P0000070?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0903oool;000001T0
oooo5`00000G0?oooa000000203oool001T0oooo5P00000U0?ooo``000003@3oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo02l0oooo3P00000R0?oooaL00000603oool000L0oooo4P00
000R0?oooaT000006@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo03d0oooo5P00
000S0?oooa000000203oool000L0oooo=000000b0?ooo`030000003oool0oooo01l0oooo00<00000
0?ooo`3oool0D`3ooolc000000P0oooo001]0?ooo`030000003oool0oooo01l0oooo00<000000?oo
o`3oool0SP3oool00?l00000800000010?ooo`001`3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00H0oooo00070?oooc<00000<`3oool00`000000oooo0?ooo`0O0?ooo`030000003o
ool0oooo01l0oooo00<000000?ooo`3oool0<P3ooolb000000P0oooo00070?ooo`H00000;@3ooolD
000001l0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0m0?oooaL000008P3oool@
000000P0oooo000=0?ooob8000007`3ooolA000000h0oooo00<000000?ooo`3oool07`3oool00`00
0000oooo0?ooo`0`0?ooo`d000008`3ooolF000001P0oooo00070?oooa4000005`3oool;000002D0
oooo1P0000080?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0903oool<000001P0
oooo6000000F0?oooa000000203oool000L0oooo1P00000;0?oooaL000002`3ooolD000001L0oooo
1P0000020?ooo`800000803oool00`000000oooo0?ooo`0P0?ooo`@00000703oool8000001P0oooo
5P00000;0?ooo`D00000203oool000d0oooo2`00000G0?ooo`/00000503oool6000001L0oooo1P00
000N0?ooo`030000003oool0oooo01X0oooo1P00000J0?ooo`H00000503oool<000001H0oooo2`00
000=0?ooo`001`3oool6000000/0oooo3000000F0?ooo`T000004@3oool6000001<0oooo00@00000
0?ooo`3oool0oooo1000000J0?ooo`030000003oool0oooo01L0oooo0`00000F0?ooo`X000003P3o
ool<000000`0oooo5P00000;0?ooo`D00000203oool000d0oooo2`00000<0?ooo`/00000503oool6
00000140oooo1@00000>0?ooo`030000003oool0oooo00D0oooo0`00000G0?ooo`030000003oool0
oooo01D0oooo0P00000D0?ooo`D00000403oool8000000l0oooo2@00000F0?ooo`/000003@3oool0
00L0oooo3P0000030?ooo``000002`3oool;000000l0oooo2@00000=0?ooo`H00000203oool00`00
0000oooo0?ooo`080?ooo`8000005@3oool00`000000oooo0?ooo`0C0?ooo`8000004`3oool30000
00l0oooo1P00000A0?ooo`H00000503ooolK000000P0oooo000E0?ooo`H000002@3oool;000000/0
oooo2@00000?0?ooo`@000003`3oool5000000<0oooo00<000000?ooo`3oool02P3oool2000001<0
oooo00<000000?ooo`3oool04@3oool200000140oooo1000000=0?ooo`D000004@3oool6000000l0
oooo2`0000030?ooo`P00000603oool001/0oooo2@00000;0?ooo`P00000303oool6000000d0oooo
1000000@0?ooo`@000003P3oool200000140oooo00<000000?ooo`3oool03`3oool2000000l0oooo
1000000=0?ooo`@00000403oool6000000`0oooo2@0000080?ooo`H00000803oool002@0oooo2`00
00080?ooo`H00000303oool5000000`0oooo1000000?0?ooo`8000003`3oool2000000l0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`8000003P3oool3000000l0oooo1@00
000<0?ooo`H000002@3oool8000002H0oooo000_0?ooo`P000001P3oool6000000/0oooo1P00000:
0?ooo`<00000303oool010000000oooo00000000000?0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`8000003@3oool3000000`0oooo1P00
000;0?ooo`H000001P3oool9000002h0oooo000g0?ooo`H000001P3oool6000000/0oooo1@000008
0?ooo`<000002@3oool010000000oooo0?ooo`3oool2000000h0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`8000003P3oool00`000000oooo0?ooo`0:0?ooo`<000002`3o
ool4000000/0oooo1P0000060?ooo`H00000=`3oool003d0oooo1@0000070?ooo`D000002`3oool2
000000T0oooo0`0000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool2
000000X0oooo0`00000<0?ooo`8000002`3oool4000000L0oooo1@00000m0?ooo`00@P3oool40000
00P0oooo100000090?ooo`<000002@3oool2000000@0oooo00<000000?ooo`3oool0103oool20000
00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00X0oooo0P00000:0?ooo`800000303oool3000000T0oooo100000070?ooo`@00000@P3oool004H0
oooo100000080?ooo`@00000203oool3000000P0oooo0P0000020?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02@3oool2000000X0oooo0P00000;0?ooo`<00000203oool4000000L0
oooo100000160?ooo`00BP3oool3000000T0oooo0`0000080?ooo`800000203oool4000000P0oooo
0P00000;0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00P0oooo0P00000:0?ooo`<00000203oool3000000P0oooo
0`00001:0?ooo`00C@3oool2000000X0oooo0P0000080?ooo`800000203oool2000000X0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo0`00
00090?ooo`8000001`3oool4000004d0oooo001?0?ooo`<000002@3oool2000000P0oooo0P000006
0?ooo`030000003oool0000000X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`07
0?ooo`800000203oool2000000T0oooo0`0000050?ooo`@00000D@3oool00580oooo100000070?oo
o`800000203oool2000000@0oooo00<000000?ooo`3oool00P0000090?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`800000203oool30000
00H0oooo0P00001E0?ooo`00EP3oool2000000L0oooo0P0000080?ooo`8000000P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo0P0000080?ooo`8000001`3oool2000005L0
oooo001H0?ooo`8000001`3oool2000000060?oDV`00000000000000000009/0e?oo0P3oool00`00
0000oooo000000050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool20000
00L0oooo0P00001I0?ooo`00FP3oool2000000L0oooo0P0000000`0009/0e?oo0?ooo`040?ooo`80
00001P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool2000000L0oooo00<000000?ooo`3oool01@3oool2000000P0oooo00<000000?ooo`3o
ool0F@3oool005`0oooo00<000000?ooo`3oool01P3oool20000000309_Do`3oool0oooo00<0oooo
0`0000050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool2000000P0oooo
0P00001L0?ooo`00G@3oool2000000L0oooo0P0000050?ooo`030000003oool0000000H0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo0P00
001N0?ooo`00G`3oool200000080oooo00H0onZj079b^P3oool0oooD09/0V`0000040?ooo`040000
003oool0oooo000000H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool2000000D0oooo0P0000070?ooo`80
0000H03oool00640oooo0P0000001`3oool0j[Yb000000000000L[[Z0?ooo`0000000`3oool01@00
0000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00D0oooo0P00001R0?ooo`00H`3oool2000000D0oooo00@000000?oo
o`3oool00000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`800000I03oool006D0oooo00<000000?oo
o`3oool00`3oool3000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool2000006H0oooo001V0?ooo`80
00001@3oool2000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1V0?ooo`00
J03oool00`000000oooo0?ooo`020?ooo`8000001@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo06L0oooo001Y0?ooo`070000003oool0oooo0?ooo`000000oooo000000050?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0J03oool006X0oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0J03oool006/0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0J@3oool006`0oooo0P0000030?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1Z0?ooo`00K@3oool2
000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo06/0oooo001]0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0K03oool006d0oooo00<000000?ooo`000000103oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0K@3oool006d0oooo
00<000000?ooo`000000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0KP3oool006d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0K`3oool006d0oooo00@000000?ooo`3oool00000103oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0K`3oool006d0
oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000050?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?oo
o`1`0?ooo`00K@3oool2000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0L@3oool006d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000001@3oool0
0`000000oooo0?ooo`1a0?ooo`00K@3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000040?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0780oooo001]0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`000000M@3oool006D0oooo00@0j[Yb000000000780^^[o103oool0
0`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?oo
o`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`000000103oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo07<0oooo001V0?ooo`03
0?oDV`1b^^X0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`000000103oool01@000000oooo0?ooo`3oool0000000@0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`000000103oool01@000000oooo
0?ooo`3oool0000000@0oooo00D000000?ooo`3oool0oooo0000001f0?ooo`00H`3oool01P3oom@0
V`00000000000000001b0;[Zo`@0oooo0`0000050?ooo`050000003oool0oooo0?ooo`000000103o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P3oool01@000000oooo
0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000040?ooo`050000003oool0oooo
0?ooo`000000103oool010000000oooo0?ooo`00001g0?ooo`00I03oool0103DV`00VmCo0?oDV`1b
^^X50?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000<0
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`000000M`3oool006@0oooo00@0oooD
09/0LP2j^Y/0L[[Z1@3oool00`000000oooo0?ooo`060?ooo`050000003oool0oooo0?ooo`000000
103oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?oo
o`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`00001h0?ooo`00I@3oool00`3oj[X0LP0007:j
jP050?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3oool0oooo000000040?ooo`050000
003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?oo
o`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`3oool0MP3oool006d0oooo00<000000?ooo`3oool01`3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`05
0000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`1g0?ooo`00K@3oool00`000000oooo0?ooo`070?ooo`050000003oool0oooo0?ooo`000000
103oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo000000<0oooo00D000000?oo
o`3oool0oooo000000030?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo0?ooo`1g0?ooo`00K@3oool2000000T0oooo00D000000?ooo`3oool0oooo
000000030?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool000000`3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`3oool0M`3oool006d0oooo00<000000?ooo`3oool0203o
ool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`04
0000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo07L0oooo
001]0?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool000000`3oool01@000000oooo
0?ooo`3oool0000000<0oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool0N03oool006d0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?oo
o`3oool0000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo07P0oooo001]0?ooo`030000003o
ool0oooo00T0oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo000000<0
oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool000000080oooo00@00000
0?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0
N03oool006d0oooo00<000000?ooo`3oool02P3oool010000000oooo0?ooo`0000030?ooo`050000
003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo
000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`030000
003oool0oooo07T0oooo001]0?ooo`030000003oool0oooo00X0oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000030?oo
o`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo07T0oooo001]0?ooo`8000002`3oool01@000000oooo0?oo
o`3oool0000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?oo
o`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo07T0oooo001]0?ooo`030000003oool0oooo00/0oooo00@0
00000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`1j0?ooo`00K@3oool00`000000oooo0?oo
o`0;0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000030?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`00
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`1j0?ooo`00K@3o
ool00`000000oooo0?ooo`0;0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo
0?ooo`0000030?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000`3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0
N`3oool006d0oooo00<000000?ooo`3oool0303oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo
0?ooo`1k0?ooo`00K@3oool00`000000oooo0?ooo`0<0?ooo`040000003oool0oooo00000080oooo
00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool0N`3oool006d0oooo0P00000=0?ooo`050000003oool0oooo0?ooo`000000
0P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`060000003oool0oooo0000003oool0
0000OP3oool006d0oooo00<000000?ooo`3oool03@3oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`1l0?ooo`00K@3oool00`000000oooo0?ooo`0=0?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0oooo07`0oooo001]0?ooo`030000003oool0oooo00d0oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`3oool0O03oool006d0oooo00<000000?ooo`3oool03@3oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool0
00000?ooo`00001o0?ooo`00I03oool01@3oom@0V`00000000000780^^[o00@0oooo00<000000?oo
o`3oool03P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000020?ooo`060000003oool0oooo0000003oool000000P3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo07d0oooo001T0?ooo`050=BK002Ke?l0
oooo0?ooe03De?l0103oool00`000000oooo0?ooo`0>0?ooo`060000003oool0oooo0000003oool0
00000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00H00000
0?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool0O@3oool006<0oooo00H0oooD09/0001b^^X0oooo0>ZjLP2Ke?l40?ooo`<000003P3oool01000
0000oooo0?ooo`0000020?ooo`060000003oool0oooo0000003oool000000P3oool010000000oooo
0?ooo`0000020?ooo`030000003oool000000080oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`00001o0?ooo`00I03oool0102jLY/0LW8000000000L[X50?ooo`030000003oool0
oooo00h0oooo00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo00000080
oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000020?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool00000O`3oool006@0oooo00<0omBK001b^P3oool01P3oool0
0`000000oooo0?ooo`0?0?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo
000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo000007l0oooo001U0?ooo`040>ZjLP0000000000
09_Do`@0oooo00<000000?ooo`3oool03`3oool01P000000oooo0?ooo`000000oooo00000080oooo
00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool000000080
oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000200?ooo`00K@3oool00`000000
oooo0?ooo`0?0?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo00000002
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool01P000000oooo0?oo
o`000000oooo00000080oooo00<000000?ooo`3oool0OP3oool006d0oooo00<000000?ooo`3oool0
3`3oool010000000oooo0?ooo`0000020?ooo`050000003oool000000?ooo`0000000P3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool000000080oooo00<000000?ooo`0000000P3oool0
10000000oooo0?ooo`0000200?ooo`00K@3oool200000100oooo00@000000?ooo`3oool000000P3o
ool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`0000000P3oool01@000000oooo
0000003oool000000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`1n0?oo
o`00K@3oool00`000000oooo0?ooo`0?0?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`0000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00D000000?ooo`000000oooo
000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0OP3oool006d0oooo
00<000000?ooo`3oool0403oool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?oo
o`0000000P3oool00`000000oooo000000020?ooo`050000003oool000000?ooo`0000000P3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo07h0oooo001]0?ooo`030000003oool0
oooo0100oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool000000080oooo
00<000000?ooo`0000000P3oool01@000000oooo0000003oool000000080oooo00H000000?ooo`3o
ool000000?ooo`0000210?ooo`00K@3oool00`000000oooo0?ooo`0@0?ooo`060000003oool0oooo
0000003oool000000P3oool00`000000oooo000000020?ooo`050000003oool000000?ooo`000000
0P3oool00`000000oooo000000020?ooo`030000003oool000000080oooo00<000000?ooo`3oool0
O`3oool006d0oooo00<000000?ooo`3oool0403oool01P000000oooo0?ooo`000000oooo00000080
oooo00<000000?ooo`0000000P3oool01@000000oooo0000003oool000000080oooo00<000000?oo
o`0000000P3oool00`000000oooo000000020?ooo`030000003oool0oooo07l0oooo0000\
\>"],
  ImageRangeCache->{{{91.5625, 320.938}, {223.188, 81.875}} -> {-6.57714, \
1.101, 0.0293901, 0.0785145}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show[gvr3,gyp]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.380952 0.119048 0.301961 0.0432289 [
[.14286 .28946 -6 -9 ]
[.14286 .28946 6 0 ]
[.61905 .28946 -3 -9 ]
[.61905 .28946 3 0 ]
[.85714 .28946 -3 -9 ]
[.85714 .28946 3 0 ]
[.36845 .04259 -12 -4.5 ]
[.36845 .04259 0 4.5 ]
[.36845 .12905 -12 -4.5 ]
[.36845 .12905 0 4.5 ]
[.36845 .2155 -12 -4.5 ]
[.36845 .2155 0 4.5 ]
[.36845 .38842 -6 -4.5 ]
[.36845 .38842 0 4.5 ]
[.36845 .47488 -6 -4.5 ]
[.36845 .47488 0 4.5 ]
[.36845 .56133 -6 -4.5 ]
[.36845 .56133 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.14286 .30196 m
.14286 .30821 L
s
[(-2)] .14286 .28946 0 1 Mshowa
.61905 .30196 m
.61905 .30821 L
s
[(2)] .61905 .28946 0 1 Mshowa
.85714 .30196 m
.85714 .30821 L
s
[(4)] .85714 .28946 0 1 Mshowa
.125 Mabswid
.20238 .30196 m
.20238 .30571 L
s
.2619 .30196 m
.2619 .30571 L
s
.32143 .30196 m
.32143 .30571 L
s
.44048 .30196 m
.44048 .30571 L
s
.5 .30196 m
.5 .30571 L
s
.55952 .30196 m
.55952 .30571 L
s
.67857 .30196 m
.67857 .30571 L
s
.7381 .30196 m
.7381 .30571 L
s
.79762 .30196 m
.79762 .30571 L
s
.08333 .30196 m
.08333 .30571 L
s
.02381 .30196 m
.02381 .30571 L
s
.91667 .30196 m
.91667 .30571 L
s
.97619 .30196 m
.97619 .30571 L
s
.25 Mabswid
0 .30196 m
1 .30196 L
s
.38095 .04259 m
.3872 .04259 L
s
[(-6)] .36845 .04259 1 0 Mshowa
.38095 .12905 m
.3872 .12905 L
s
[(-4)] .36845 .12905 1 0 Mshowa
.38095 .2155 m
.3872 .2155 L
s
[(-2)] .36845 .2155 1 0 Mshowa
.38095 .38842 m
.3872 .38842 L
s
[(2)] .36845 .38842 1 0 Mshowa
.38095 .47488 m
.3872 .47488 L
s
[(4)] .36845 .47488 1 0 Mshowa
.38095 .56133 m
.3872 .56133 L
s
[(6)] .36845 .56133 1 0 Mshowa
.125 Mabswid
.38095 .0642 m
.3847 .0642 L
s
.38095 .08582 m
.3847 .08582 L
s
.38095 .10743 m
.3847 .10743 L
s
.38095 .15066 m
.3847 .15066 L
s
.38095 .17227 m
.3847 .17227 L
s
.38095 .19389 m
.3847 .19389 L
s
.38095 .23712 m
.3847 .23712 L
s
.38095 .25873 m
.3847 .25873 L
s
.38095 .28035 m
.3847 .28035 L
s
.38095 .32358 m
.3847 .32358 L
s
.38095 .34519 m
.3847 .34519 L
s
.38095 .3668 m
.3847 .3668 L
s
.38095 .41003 m
.3847 .41003 L
s
.38095 .43165 m
.3847 .43165 L
s
.38095 .45326 m
.3847 .45326 L
s
.38095 .49649 m
.3847 .49649 L
s
.38095 .51811 m
.3847 .51811 L
s
.38095 .53972 m
.3847 .53972 L
s
.38095 .02097 m
.3847 .02097 L
s
.38095 .58295 m
.3847 .58295 L
s
.38095 .60456 m
.3847 .60456 L
s
.25 Mabswid
.38095 0 m
.38095 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26954 m
.06244 .26668 L
.10458 .26292 L
.14415 .25857 L
.18221 .25338 L
.22272 .24628 L
.26171 .23717 L
.28158 .23128 L
.30316 .22353 L
.32216 .21515 L
.34309 .20357 L
.36292 .18933 L
.38395 .16892 L
.40336 .1422 L
.41426 .12189 L
.42424 .09818 L
.43408 .06774 L
.44322 .03003 L
s
.44322 .03003 m
.44839 0 L
s
.4998 0 m
.49982 .61803 L
s
.54895 .61803 m
.55019 .60957 L
.55516 .58183 L
.56448 .54139 L
.57536 .50683 L
.58541 .48272 L
.60411 .45025 L
.61475 .4365 L
.62473 .42574 L
.64495 .40847 L
.66347 .39641 L
.68403 .38585 L
.70314 .37796 L
.7413 .36594 L
.7804 .35702 L
.82195 .34991 L
.86199 .34461 L
.9005 .34051 L
.94148 .33693 L
.97619 .33438 L
s
.02381 .27494 m
.06244 .27256 L
.10458 .26942 L
.14415 .26581 L
.18221 .26148 L
.22272 .25556 L
.26171 .24797 L
.28158 .24306 L
.30316 .2366 L
.32216 .22962 L
.34309 .21997 L
.36292 .2081 L
.38395 .1911 L
.40336 .16883 L
.41426 .1519 L
.42424 .13214 L
.43408 .10678 L
.44322 .07535 L
.45325 .02673 L
s
.45325 .02673 m
.45725 0 L
s
.4998 0 m
.49982 .61803 L
s
.54081 .61803 m
.54493 .58829 L
.55019 .5583 L
.55516 .53518 L
.56448 .50149 L
.57536 .47269 L
.58541 .4526 L
.60411 .42554 L
.61475 .41408 L
.62473 .40511 L
.64495 .39072 L
.66347 .38067 L
.68403 .37187 L
.70314 .36529 L
.7413 .35528 L
.7804 .34784 L
.82195 .34192 L
.86199 .3375 L
.9005 .33408 L
.94148 .3311 L
.97619 .32898 L
s
.02381 .28035 m
.06244 .27844 L
.10458 .27593 L
.14415 .27304 L
.18221 .26957 L
.22272 .26484 L
.26171 .25877 L
.28158 .25484 L
.30316 .24967 L
.32216 .24409 L
.34309 .23637 L
.36292 .22687 L
.38395 .21327 L
.40336 .19546 L
.41426 .18191 L
.42424 .1661 L
.43408 .14581 L
.44322 .12067 L
.45325 .08177 L
.45886 .05176 L
.46395 .01647 L
s
.46395 .01647 m
.46575 0 L
s
.4998 0 m
.49982 .61803 L
s
.53261 .61803 m
.53486 .59724 L
.53969 .56131 L
.54493 .53103 L
.55019 .50703 L
.55516 .48854 L
.56448 .46158 L
.57536 .43854 L
.58541 .42247 L
.60411 .40082 L
.61475 .39165 L
.62473 .38448 L
.64495 .37297 L
.66347 .36492 L
.68403 .35789 L
.70314 .35263 L
.7413 .34461 L
.7804 .33867 L
.82195 .33393 L
.86199 .33039 L
.9005 .32766 L
.94148 .32527 L
.97619 .32358 L
s
.02381 .28575 m
.06244 .28432 L
.10458 .28244 L
.14415 .28027 L
.18221 .27767 L
.22272 .27412 L
.26171 .26957 L
.28158 .26662 L
.30316 .26274 L
.32216 .25855 L
.34309 .25277 L
.36292 .24565 L
.38395 .23544 L
.40336 .22208 L
.41426 .21192 L
.42424 .20007 L
.43408 .18485 L
.44322 .166 L
.45325 .13682 L
.45886 .11431 L
.46395 .08784 L
.46882 .05437 L
.47149 .03124 L
.47397 .00538 L
s
.47397 .00538 m
.47436 0 L
s
.49979 0 m
.49983 .61803 L
s
.52453 .61803 m
.52923 .56609 L
.53191 .54386 L
.53486 .52342 L
.53969 .49647 L
.54493 .47376 L
.55019 .45576 L
.55516 .4419 L
.56448 .42168 L
.57536 .4044 L
.58541 .39234 L
.60411 .37611 L
.61475 .36923 L
.62473 .36385 L
.64495 .35522 L
.66347 .34918 L
.68403 .34391 L
.70314 .33996 L
.7413 .33395 L
.7804 .32949 L
.82195 .32594 L
.86199 .32329 L
.9005 .32124 L
.94148 .31945 L
.97619 .31817 L
s
.02381 .29115 m
.06244 .2902 L
.10458 .28895 L
.14415 .2875 L
.18221 .28577 L
.22272 .2834 L
.26171 .28036 L
.28158 .2784 L
.30316 .27582 L
.32216 .27302 L
.34309 .26916 L
.36292 .26442 L
.38395 .25761 L
.40336 .24871 L
.41426 .24194 L
.42424 .23403 L
.43408 .22389 L
.44322 .21132 L
.45325 .19187 L
.45886 .17686 L
.46395 .15921 L
.46882 .1369 L
.47149 .12148 L
.47397 .10424 L
.47837 .06405 L
.4807 .03534 L
s
.4807 .03534 m
.48293 0 L
s
.49979 0 m
.49983 .61803 L
s
.5163 .61803 m
.51852 .57981 L
.5211 .54583 L
.52389 .51738 L
.52923 .47804 L
.53191 .46322 L
.53486 .4496 L
.53969 .43163 L
.54493 .41649 L
.55019 .4045 L
.55516 .39525 L
.56448 .38177 L
.57536 .37025 L
.58541 .36222 L
.60411 .35139 L
.61475 .34681 L
.62473 .34322 L
.64495 .33746 L
.66347 .33344 L
.68403 .32992 L
.70314 .32729 L
.7413 .32329 L
.7804 .32031 L
.82195 .31795 L
.86199 .31618 L
.9005 .31481 L
.94148 .31362 L
.97619 .31277 L
s
.02381 .29656 m
.06244 .29608 L
.10458 .29545 L
.14415 .29473 L
.18221 .29386 L
.22272 .29268 L
.26171 .29116 L
.28158 .29018 L
.30316 .28889 L
.32216 .28749 L
.34309 .28556 L
.36292 .28319 L
.38395 .27979 L
.40336 .27533 L
.41426 .27195 L
.42424 .268 L
.43408 .26292 L
.44322 .25664 L
.45325 .24691 L
.45886 .23941 L
.46395 .23059 L
.46882 .21943 L
.47149 .21172 L
.47397 .2031 L
.47837 .18301 L
.4807 .16865 L
.48319 .14885 L
.48587 .11981 L
.48739 .09796 L
.48879 .07248 L
.49001 .04444 L
.49136 .00429 L
s
.49136 .00429 m
.49147 0 L
s
.49976 0 m
.49986 .61803 L
s
.50819 .61803 m
.5089 .59094 L
.51004 .55825 L
.51109 .53392 L
.51348 .49286 L
.51484 .47532 L
.51613 .46153 L
.51852 .44089 L
.5211 .4239 L
.52389 .40967 L
.52923 .39 L
.53191 .38259 L
.53486 .37578 L
.53969 .3668 L
.54493 .35923 L
.55019 .35323 L
.55516 .34861 L
.56448 .34187 L
.57536 .33611 L
.58541 .33209 L
.60411 .32668 L
.61475 .32438 L
.62473 .32259 L
.64495 .31971 L
.66347 .3177 L
.68403 .31594 L
.70314 .31463 L
.7413 .31262 L
.7804 .31114 L
.82195 .30995 L
.86199 .30907 L
.9005 .30839 L
.94148 .30779 L
.97619 .30736 L
s
.02381 .30196 m
.02499 .30196 L
.02605 .30196 L
.02729 .30196 L
.02846 .30196 L
.02954 .30196 L
.03053 .30196 L
.03163 .30196 L
.03279 .30196 L
.03395 .30196 L
.0352 .30196 L
.03638 .30196 L
.03746 .30196 L
.03873 .30196 L
.03944 .30196 L
.04011 .30196 L
.04132 .30196 L
.04262 .30196 L
.04327 .30196 L
.04396 .30196 L
.04519 .30196 L
.04588 .30196 L
.04652 .30196 L
.04722 .30196 L
.04797 .30196 L
.04862 .30196 L
.04933 .30196 L
.05061 .30196 L
.05186 .30196 L
.05302 .30196 L
.05414 .30196 L
.05519 .30196 L
.05634 .30196 L
.05759 .30196 L
.05882 .30196 L
.06012 .30196 L
.06123 .30196 L
.06244 .30196 L
.06315 .30196 L
.06381 .30196 L
.06453 .30196 L
.06529 .30196 L
.06657 .30196 L
.06729 .30196 L
.06797 .30196 L
.06924 .30196 L
.0704 .30196 L
.07103 .30196 L
.07173 .30196 L
.073 .30196 L
Mistroke
.07376 .30196 L
.07448 .30196 L
.07513 .30196 L
.07583 .30196 L
.0766 .30196 L
.0774 .30196 L
.07809 .30196 L
.07885 .30196 L
.07956 .30196 L
.0802 .30196 L
.08095 .30196 L
.08166 .30196 L
.08291 .30196 L
.08362 .30196 L
.08427 .30196 L
.08544 .30196 L
.08669 .30196 L
.08787 .30196 L
.08896 .30196 L
.09016 .30196 L
.09148 .30196 L
.09214 .30196 L
.09285 .30196 L
.09413 .30196 L
.09483 .30196 L
.09548 .30196 L
.09619 .30196 L
.09695 .30196 L
.09821 .30196 L
.09893 .30196 L
.09961 .30196 L
.10086 .30196 L
.10201 .30196 L
.10333 .30196 L
.10458 .30196 L
.10572 .30196 L
.10694 .30196 L
.1081 .30196 L
.10916 .30196 L
.11033 .30196 L
.11162 .30196 L
.11227 .30196 L
.11297 .30196 L
.11422 .30196 L
.11491 .30196 L
.11554 .30196 L
.11624 .30196 L
.11698 .30196 L
.11822 .30196 L
.11892 .30196 L
Mistroke
.11958 .30196 L
.12081 .30196 L
.12194 .30196 L
.12323 .30196 L
.12446 .30196 L
.12562 .30196 L
.12668 .30196 L
.12789 .30196 L
.12903 .30196 L
.13009 .30196 L
.13107 .30196 L
.13214 .30196 L
.13327 .30196 L
.13441 .30196 L
.13564 .30196 L
.1368 .30196 L
.13785 .30196 L
.13909 .30196 L
.13979 .30196 L
.14043 .30196 L
.14162 .30196 L
.14288 .30196 L
.14402 .30196 L
.14526 .30196 L
.14656 .30196 L
.14777 .30196 L
.14891 .30196 L
.14994 .30196 L
.15113 .30196 L
.15226 .30196 L
.15348 .30196 L
.15478 .30196 L
.15589 .30196 L
.15711 .30196 L
.15842 .30196 L
.15915 .30196 L
.15982 .30196 L
.16113 .30196 L
.16236 .30196 L
.16352 .30196 L
.16456 .30196 L
.16577 .30196 L
.1669 .30196 L
.16796 .30196 L
.16893 .30196 L
.16999 .30196 L
.17111 .30196 L
.17225 .30196 L
.17347 .30196 L
.17462 .30196 L
Mistroke
.17566 .30196 L
.17689 .30196 L
.17758 .30196 L
.17823 .30196 L
.1794 .30196 L
.18065 .30196 L
.18185 .30196 L
.18316 .30196 L
.18441 .30196 L
.18556 .30196 L
.1867 .30196 L
.18773 .30196 L
.18893 .30196 L
.19005 .30196 L
.19128 .30196 L
.19258 .30196 L
.19369 .30196 L
.19491 .30196 L
.19623 .30196 L
.19696 .30196 L
.19763 .30196 L
.19894 .30196 L
.20017 .30196 L
.20122 .30196 L
.20238 .30196 L
.20359 .30196 L
.20472 .30196 L
.20578 .30196 L
.20675 .30196 L
.20781 .30196 L
.20894 .30196 L
.21008 .30196 L
.21129 .30196 L
.21244 .30196 L
.21349 .30196 L
.21472 .30196 L
.21541 .30196 L
.21605 .30196 L
.21723 .30196 L
.21847 .30196 L
.21968 .30196 L
.221 .30196 L
.22224 .30196 L
.2234 .30196 L
.22454 .30196 L
.22558 .30196 L
.22677 .30196 L
.2279 .30196 L
.22914 .30196 L
.23044 .30196 L
Mistroke
.23155 .30196 L
.23277 .30196 L
.23409 .30196 L
.23482 .30196 L
.2355 .30196 L
.2368 .30196 L
.23804 .30196 L
.23909 .30196 L
.24025 .30196 L
.24146 .30196 L
.2426 .30196 L
.24365 .30196 L
.24462 .30196 L
.24569 .30196 L
.24681 .30196 L
.24795 .30196 L
.24917 .30196 L
.25032 .30196 L
.25137 .30196 L
.2526 .30196 L
.25329 .30196 L
.25393 .30196 L
.2551 .30196 L
.25635 .30196 L
.25756 .30196 L
.25888 .30196 L
.26013 .30196 L
.26129 .30196 L
.26233 .30196 L
.26348 .30196 L
.26467 .30196 L
.2658 .30196 L
.26704 .30196 L
.26835 .30196 L
.26946 .30196 L
.27068 .30196 L
.272 .30196 L
.27274 .30196 L
.27341 .30196 L
.27472 .30196 L
.27595 .30196 L
.27701 .30196 L
.27817 .30196 L
.27938 .30196 L
.28052 .30196 L
.28158 .30196 L
.28255 .30196 L
.28367 .30196 L
.28474 .30196 L
.28588 .30196 L
Mistroke
.2871 .30196 L
.28825 .30196 L
.2893 .30196 L
.29053 .30196 L
.29122 .30196 L
.29186 .30196 L
.29303 .30196 L
.29427 .30196 L
.29549 .30196 L
.29618 .30196 L
.29682 .30196 L
.29799 .30196 L
.29923 .30196 L
.30034 .30196 L
.30138 .30196 L
.30252 .30196 L
.30375 .30196 L
.30499 .30196 L
.30569 .30196 L
.30634 .30196 L
.30765 .30196 L
.30839 .30196 L
.30906 .30196 L
.31026 .30196 L
.31156 .30196 L
.31278 .30196 L
.31392 .30196 L
.31497 .30196 L
.31611 .30196 L
.31718 .30196 L
.31816 .30196 L
.3193 .30196 L
.32055 .30196 L
.32173 .30196 L
.32282 .30196 L
.32406 .30196 L
.32522 .30196 L
.32626 .30196 L
.32739 .30196 L
.32862 .30196 L
.32992 .30196 L
.33103 .30196 L
.33225 .30196 L
.33356 .30196 L
.33477 .30196 L
.33541 .30196 L
.3361 .30196 L
.33683 .30196 L
.33751 .30196 L
.33876 .30196 L
Mistroke
.33991 .30196 L
.34123 .30196 L
.34249 .30196 L
.3436 .30196 L
.3448 .30196 L
.34592 .30196 L
.34694 .30196 L
.34814 .30196 L
.34945 .30196 L
.35067 .30196 L
.35181 .30196 L
.35302 .30196 L
.35431 .30196 L
.35554 .30196 L
.35665 .30196 L
.35796 .30196 L
.3587 .30196 L
.35939 .30196 L
.36064 .30196 L
.36128 .30196 L
.36198 .30196 L
.36266 .30196 L
.36337 .30196 L
.36465 .30196 L
.36536 .30196 L
.36602 .30196 L
.36675 .30196 L
.36753 .30196 L
.3682 .30196 L
.36893 .30196 L
.36962 .30196 L
.37026 .30196 L
.37146 .30196 L
.37274 .30196 L
.37394 .30196 L
.37526 .30196 L
.37651 .30196 L
.37766 .30196 L
.3788 .30196 L
.37984 .30196 L
.38103 .30196 L
.38216 .30196 L
.38339 .30196 L
.3847 .30196 L
.38581 .30196 L
.38703 .30196 L
.38834 .30196 L
.38908 .30196 L
.38975 .30196 L
.39106 .30196 L
Mistroke
.39229 .30196 L
.39334 .30196 L
.3945 .30196 L
.39571 .30196 L
.39685 .30196 L
.39791 .30196 L
.39888 .30196 L
.39994 .30196 L
.40106 .30196 L
.40221 .30196 L
.40342 .30196 L
.40457 .30196 L
.40562 .30196 L
.40685 .30196 L
.40754 .30196 L
.40818 .30196 L
.40936 .30196 L
.4106 .30196 L
.41181 .30196 L
.41313 .30196 L
.41438 .30196 L
.41554 .30196 L
.41669 .30196 L
.41772 .30196 L
.41892 .30196 L
.42005 .30196 L
.42129 .30196 L
.42259 .30196 L
.42371 .30196 L
.42493 .30196 L
.42624 .30196 L
.42698 .30196 L
.42765 .30196 L
.42896 .30196 L
.43019 .30196 L
.43125 .30196 L
.43241 .30196 L
.43362 .30196 L
.43476 .30196 L
.43582 .30196 L
.43679 .30196 L
.43791 .30196 L
.43898 .30196 L
.44012 .30196 L
.44134 .30196 L
.44249 .30196 L
.44354 .30196 L
.44477 .30196 L
.44546 .30196 L
.4461 .30196 L
Mistroke
.44727 .30196 L
.44851 .30196 L
.44973 .30196 L
.45042 .30196 L
.45106 .30196 L
.45223 .30196 L
.45347 .30196 L
.45458 .30196 L
.45562 .30196 L
.45676 .30196 L
.45799 .30196 L
.45922 .30196 L
.45992 .30196 L
.46057 .30196 L
.46188 .30196 L
.46262 .30196 L
.46329 .30196 L
.46449 .30196 L
.46579 .30196 L
.46702 .30196 L
.46815 .30196 L
.4692 .30196 L
.47034 .30196 L
.47141 .30196 L
.47239 .30196 L
.47353 .30196 L
.47478 .30196 L
.47596 .30196 L
.47705 .30196 L
.47829 .30196 L
.47945 .30196 L
.48049 .30196 L
.48162 .30196 L
.48285 .30196 L
.48415 .30196 L
.48526 .30196 L
.48648 .30196 L
.48779 .30196 L
.489 .30196 L
.48963 .30196 L
.49033 .30196 L
.49105 .30196 L
.49174 .30196 L
.49299 .30196 L
.49413 .30196 L
.49539 .30196 L
.49671 .30196 L
.49783 .30196 L
.49902 .30196 L
.50014 .30196 L
Mistroke
.50116 .30196 L
.50236 .30196 L
.50366 .30196 L
.50489 .30196 L
.50603 .30196 L
.50723 .30196 L
.50853 .30196 L
.50975 .30196 L
.51087 .30196 L
.51218 .30196 L
.51292 .30196 L
.51361 .30196 L
.51486 .30196 L
.5155 .30196 L
.5162 .30196 L
.51687 .30196 L
.51759 .30196 L
.51886 .30196 L
.51958 .30196 L
.52024 .30196 L
.52096 .30196 L
.52174 .30196 L
.52241 .30196 L
.52314 .30196 L
.52383 .30196 L
.52447 .30196 L
.52568 .30196 L
.52695 .30196 L
.52816 .30196 L
.52947 .30196 L
.53072 .30196 L
.53187 .30196 L
.53301 .30196 L
.53405 .30196 L
.53525 .30196 L
.53637 .30196 L
.5376 .30196 L
.53891 .30196 L
.54002 .30196 L
.54124 .30196 L
.54255 .30196 L
.54329 .30196 L
.54396 .30196 L
.54526 .30196 L
.5465 .30196 L
.54755 .30196 L
.54871 .30196 L
.54992 .30196 L
.55105 .30196 L
.55211 .30196 L
Mistroke
.55308 .30196 L
.55415 .30196 L
.55527 .30196 L
.55641 .30196 L
.55763 .30196 L
.55878 .30196 L
.55982 .30196 L
.56105 .30196 L
.56175 .30196 L
.56238 .30196 L
.56356 .30196 L
.5648 .30196 L
.56601 .30196 L
.56734 .30196 L
.56858 .30196 L
.56974 .30196 L
.57088 .30196 L
.57192 .30196 L
.57312 .30196 L
.57425 .30196 L
.57548 .30196 L
.57679 .30196 L
.5779 .30196 L
.57912 .30196 L
.58044 .30196 L
.58118 .30196 L
.58185 .30196 L
.58315 .30196 L
.58439 .30196 L
.58544 .30196 L
.5866 .30196 L
.58782 .30196 L
.58895 .30196 L
.59001 .30196 L
.59098 .30196 L
.5921 .30196 L
.59317 .30196 L
.59431 .30196 L
.59553 .30196 L
.59668 .30196 L
.59773 .30196 L
.59896 .30196 L
.59965 .30196 L
.60029 .30196 L
.60146 .30196 L
.60271 .30196 L
.60392 .30196 L
.60461 .30196 L
.60525 .30196 L
.60642 .30196 L
Mistroke
.60766 .30196 L
.60876 .30196 L
.6098 .30196 L
.61094 .30196 L
.61217 .30196 L
.61341 .30196 L
.6141 .30196 L
.61475 .30196 L
.61607 .30196 L
.6168 .30196 L
.61747 .30196 L
.61867 .30196 L
.61997 .30196 L
.6212 .30196 L
.62233 .30196 L
.62339 .30196 L
.62452 .30196 L
.62559 .30196 L
.62657 .30196 L
.62771 .30196 L
.62896 .30196 L
.63014 .30196 L
.63123 .30196 L
.63247 .30196 L
.63363 .30196 L
.63467 .30196 L
.6358 .30196 L
.63703 .30196 L
.63833 .30196 L
.63944 .30196 L
.64066 .30196 L
.64197 .30196 L
.64318 .30196 L
.64381 .30196 L
.6445 .30196 L
.64523 .30196 L
.64591 .30196 L
.64716 .30196 L
.64831 .30196 L
.64956 .30196 L
.65088 .30196 L
.652 .30196 L
.65319 .30196 L
.65431 .30196 L
.65533 .30196 L
.65653 .30196 L
.65784 .30196 L
.65906 .30196 L
.6602 .30196 L
.6614 .30196 L
Mistroke
.6627 .30196 L
.66392 .30196 L
.66504 .30196 L
.66635 .30196 L
.66709 .30196 L
.66777 .30196 L
.66903 .30196 L
.66966 .30196 L
.67036 .30196 L
.67104 .30196 L
.67175 .30196 L
.67303 .30196 L
.67374 .30196 L
.6744 .30196 L
.67513 .30196 L
.67591 .30196 L
.67658 .30196 L
.67731 .30196 L
.678 .30196 L
.67864 .30196 L
.67984 .30196 L
.68112 .30196 L
.68232 .30196 L
.68364 .30196 L
.68488 .30196 L
.68603 .30196 L
.68718 .30196 L
.68821 .30196 L
.68941 .30196 L
.69053 .30196 L
.69176 .30196 L
.69307 .30196 L
.69418 .30196 L
.6954 .30196 L
.69671 .30196 L
.69745 .30196 L
.69812 .30196 L
.69942 .30196 L
.70066 .30196 L
.70171 .30196 L
.70286 .30196 L
.70407 .30196 L
.70521 .30196 L
.70627 .30196 L
.70724 .30196 L
.7083 .30196 L
.70942 .30196 L
.71056 .30196 L
.71178 .30196 L
.71293 .30196 L
Mistroke
.71398 .30196 L
.71521 .30196 L
.7159 .30196 L
.71654 .30196 L
.71771 .30196 L
.71896 .30196 L
.72017 .30196 L
.72149 .30196 L
.72273 .30196 L
.72389 .30196 L
.72503 .30196 L
.72607 .30196 L
.72727 .30196 L
.7284 .30196 L
.72963 .30196 L
.73094 .30196 L
.73205 .30196 L
.73327 .30196 L
.73458 .30196 L
.73532 .30196 L
.73599 .30196 L
.7373 .30196 L
.73853 .30196 L
.73959 .30196 L
.74075 .30196 L
.74196 .30196 L
.7431 .30196 L
.74416 .30196 L
.74513 .30196 L
.74619 .30196 L
.74731 .30196 L
.74846 .30196 L
.74967 .30196 L
.75083 .30196 L
.75187 .30196 L
.7531 .30196 L
.75379 .30196 L
.75443 .30196 L
.75561 .30196 L
.75685 .30196 L
.75806 .30196 L
.75875 .30196 L
.75939 .30196 L
.76056 .30196 L
.7618 .30196 L
.7629 .30196 L
.76394 .30196 L
.76508 .30196 L
.76631 .30196 L
.76754 .30196 L
Mistroke
.76824 .30196 L
.76889 .30196 L
.7702 .30196 L
.77094 .30196 L
.77161 .30196 L
.7728 .30196 L
.7741 .30196 L
.77533 .30196 L
.77646 .30196 L
.77752 .30196 L
.77865 .30196 L
.77972 .30196 L
.7807 .30196 L
.78184 .30196 L
.78309 .30196 L
.78427 .30196 L
.78536 .30196 L
.7866 .30196 L
.78776 .30196 L
.7888 .30196 L
.78993 .30196 L
.79116 .30196 L
.79246 .30196 L
.79357 .30196 L
.79479 .30196 L
.7961 .30196 L
.7973 .30196 L
.79793 .30196 L
.79863 .30196 L
.79936 .30196 L
.80004 .30196 L
.80129 .30196 L
.80243 .30196 L
.80369 .30196 L
.80501 .30196 L
.80612 .30196 L
.80731 .30196 L
.80843 .30196 L
.80945 .30196 L
.81066 .30196 L
.81196 .30196 L
.81318 .30196 L
.81432 .30196 L
.81552 .30196 L
.81682 .30196 L
.81804 .30196 L
.81916 .30196 L
.82047 .30196 L
.8212 .30196 L
.82189 .30196 L
Mistroke
.82315 .30196 L
.82385 .30196 L
.82448 .30196 L
.82516 .30196 L
.82587 .30196 L
.82715 .30196 L
.82786 .30196 L
.82852 .30196 L
.82925 .30196 L
.83002 .30196 L
.8307 .30196 L
.83143 .30196 L
.83212 .30196 L
.83275 .30196 L
.83396 .30196 L
.83524 .30196 L
.83644 .30196 L
.83775 .30196 L
.839 .30196 L
.84015 .30196 L
.84129 .30196 L
.84232 .30196 L
.84352 .30196 L
.84464 .30196 L
.84587 .30196 L
.84718 .30196 L
.84829 .30196 L
.8495 .30196 L
.85082 .30196 L
.85155 .30196 L
.85222 .30196 L
.85353 .30196 L
.85476 .30196 L
.85581 .30196 L
.85697 .30196 L
.85818 .30196 L
.85932 .30196 L
.86037 .30196 L
.86134 .30196 L
.86241 .30196 L
.86353 .30196 L
.86467 .30196 L
.86589 .30196 L
.86704 .30196 L
.86808 .30196 L
.86931 .30196 L
.87 .30196 L
.87064 .30196 L
.87182 .30196 L
.87306 .30196 L
Mistroke
.87427 .30196 L
.87559 .30196 L
.87684 .30196 L
.87799 .30196 L
.87914 .30196 L
.88017 .30196 L
.88137 .30196 L
.88249 .30196 L
.88373 .30196 L
.88503 .30196 L
.88615 .30196 L
.88737 .30196 L
.88868 .30196 L
.88942 .30196 L
.89009 .30196 L
.89139 .30196 L
.89263 .30196 L
.89368 .30196 L
.89484 .30196 L
.89605 .30196 L
.89719 .30196 L
.89825 .30196 L
.89922 .30196 L
.90029 .30196 L
.90141 .30196 L
.90255 .30196 L
.90377 .30196 L
.90492 .30196 L
.90596 .30196 L
.90719 .30196 L
.90789 .30196 L
.90852 .30196 L
.9097 .30196 L
.91094 .30196 L
.91216 .30196 L
.91284 .30196 L
.91348 .30196 L
.91464 .30196 L
.91589 .30196 L
.91699 .30196 L
.91803 .30196 L
.91917 .30196 L
.9204 .30196 L
.92163 .30196 L
.92233 .30196 L
.92297 .30196 L
.92429 .30196 L
.92502 .30196 L
.92569 .30196 L
.92689 .30196 L
Mistroke
.92819 .30196 L
.92941 .30196 L
.93055 .30196 L
.9316 .30196 L
.93273 .30196 L
.9338 .30196 L
.93478 .30196 L
.93592 .30196 L
.93717 .30196 L
.93835 .30196 L
.93944 .30196 L
.94068 .30196 L
.94184 .30196 L
.94288 .30196 L
.94401 .30196 L
.94524 .30196 L
.94654 .30196 L
.94765 .30196 L
.94887 .30196 L
.94975 .30196 L
.95057 .30196 L
.95146 .30196 L
.95241 .30196 L
.95324 .30196 L
.95401 .30196 L
.95486 .30196 L
.95577 .30196 L
.95653 .30196 L
.95737 .30196 L
.95824 .30196 L
.95905 .30196 L
.95981 .30196 L
.9605 .30196 L
.9613 .30196 L
.96206 .30196 L
.96287 .30196 L
.96377 .30196 L
.96471 .30196 L
.96559 .30196 L
.96641 .30196 L
.96716 .30196 L
.96802 .30196 L
.96884 .30196 L
.96972 .30196 L
.97067 .30196 L
.97155 .30196 L
.97236 .30196 L
.97331 .30196 L
.97433 .30196 L
.9753 .30196 L
Mistroke
.97619 .30196 L
Mfstroke
.02381 .30736 m
.06244 .30784 L
.10458 .30847 L
.14415 .30919 L
.18221 .31006 L
.22272 .31124 L
.26171 .31276 L
.28158 .31374 L
.30316 .31503 L
.32216 .31643 L
.34309 .31836 L
.36292 .32073 L
.38395 .32413 L
.40336 .32859 L
.41426 .33197 L
.42424 .33592 L
.43408 .341 L
.44322 .34728 L
.45325 .35701 L
.45886 .36451 L
.46395 .37333 L
.46882 .38449 L
.47149 .3922 L
.47397 .40082 L
.47837 .42092 L
.4807 .43527 L
.48319 .45508 L
.48587 .48411 L
.48739 .50596 L
.48879 .53144 L
.49001 .55948 L
.49136 .59964 L
s
.49136 .59964 m
.49185 .61803 L
s
.49976 .61803 m
.49986 0 L
s
.50856 0 m
.5089 .01298 L
.51004 .04567 L
.51109 .07 L
.51348 .11106 L
.51484 .1286 L
.51613 .14239 L
.51852 .16303 L
.5211 .18002 L
.52389 .19425 L
.52923 .21392 L
.53191 .22133 L
.53486 .22814 L
.53969 .23712 L
.54493 .24469 L
.55019 .25069 L
.55516 .25532 L
.56448 .26206 L
.57536 .26782 L
.58541 .27183 L
.60411 .27725 L
.61475 .27954 L
.62473 .28133 L
.64495 .28421 L
.66347 .28622 L
.68403 .28798 L
.70314 .28929 L
.7413 .2913 L
.7804 .29278 L
.82195 .29397 L
.86199 .29485 L
.9005 .29554 L
.94148 .29613 L
.97619 .29656 L
s
.02381 .31277 m
.06244 .31372 L
.10458 .31498 L
.14415 .31642 L
.18221 .31815 L
.22272 .32052 L
.26171 .32356 L
.28158 .32552 L
.30316 .3281 L
.32216 .3309 L
.34309 .33476 L
.36292 .3395 L
.38395 .34631 L
.40336 .35521 L
.41426 .36199 L
.42424 .36989 L
.43408 .38003 L
.44322 .3926 L
.45325 .41205 L
.45886 .42706 L
.46395 .44471 L
.46882 .46702 L
.47149 .48244 L
.47397 .49968 L
.47837 .53987 L
.4807 .56858 L
.48319 .60819 L
s
.48319 .60819 m
.48365 .61803 L
s
.49979 .61803 m
.49983 0 L
s
.51712 0 m
.51852 .02411 L
.5211 .05809 L
.52389 .08655 L
.52923 .12588 L
.53191 .1407 L
.53486 .15432 L
.53969 .17229 L
.54493 .18743 L
.55019 .19943 L
.55516 .20867 L
.56448 .22215 L
.57536 .23367 L
.58541 .24171 L
.60411 .25253 L
.61475 .25711 L
.62473 .2607 L
.64495 .26646 L
.66347 .27048 L
.68403 .274 L
.70314 .27663 L
.7413 .28063 L
.7804 .28361 L
.82195 .28598 L
.86199 .28774 L
.9005 .28911 L
.94148 .2903 L
.97619 .29115 L
s
.02381 .31817 m
.06244 .3196 L
.10458 .32148 L
.14415 .32365 L
.18221 .32625 L
.22272 .3298 L
.26171 .33436 L
.28158 .3373 L
.30316 .34118 L
.32216 .34537 L
.34309 .35116 L
.36292 .35828 L
.38395 .36848 L
.40336 .38184 L
.41426 .392 L
.42424 .40385 L
.43408 .41907 L
.44322 .43793 L
.45325 .4671 L
.45886 .48961 L
.46395 .51608 L
.46882 .54956 L
.47149 .57268 L
.47397 .59854 L
s
.47397 .59854 m
.47539 .61803 L
s
.49979 .61803 m
.49983 0 L
s
.5258 0 m
.52923 .03784 L
.53191 .06007 L
.53486 .0805 L
.53969 .10745 L
.54493 .13016 L
.55019 .14816 L
.55516 .16203 L
.56448 .18224 L
.57536 .19952 L
.58541 .21158 L
.60411 .22781 L
.61475 .23469 L
.62473 .24007 L
.64495 .24871 L
.66347 .25474 L
.68403 .26002 L
.70314 .26396 L
.7413 .26997 L
.7804 .27443 L
.82195 .27798 L
.86199 .28064 L
.9005 .28269 L
.94148 .28448 L
.97619 .28575 L
s
.02381 .32358 m
.06244 .32548 L
.10458 .32799 L
.14415 .33088 L
.18221 .33435 L
.22272 .33908 L
.26171 .34515 L
.28158 .34908 L
.30316 .35425 L
.32216 .35984 L
.34309 .36755 L
.36292 .37705 L
.38395 .39065 L
.40336 .40847 L
.41426 .42201 L
.42424 .43782 L
.43408 .45811 L
.44322 .48325 L
.45325 .52215 L
.45886 .55216 L
.46395 .58745 L
s
.46395 .58745 m
.46729 .61803 L
s
.4998 .61803 m
.49982 0 L
s
.53414 0 m
.53486 .00668 L
.53969 .04261 L
.54493 .0729 L
.55019 .09689 L
.55516 .11538 L
.56448 .14234 L
.57536 .16538 L
.58541 .18145 L
.60411 .2031 L
.61475 .21227 L
.62473 .21944 L
.64495 .23095 L
.66347 .239 L
.68403 .24603 L
.70314 .25129 L
.7413 .25931 L
.7804 .26525 L
.82195 .26999 L
.86199 .27353 L
.9005 .27626 L
.94148 .27865 L
.97619 .28035 L
s
.02381 .32898 m
.06244 .33136 L
.10458 .3345 L
.14415 .33812 L
.18221 .34245 L
.22272 .34836 L
.26171 .35595 L
.28158 .36087 L
.30316 .36732 L
.32216 .3743 L
.34309 .38395 L
.36292 .39582 L
.38395 .41283 L
.40336 .43509 L
.41426 .45202 L
.42424 .47178 L
.43408 .49715 L
.44322 .52857 L
.45325 .57719 L
.45886 .61471 L
s
.45886 .61471 m
.45925 .61803 L
s
.4998 .61803 m
.49982 0 L
s
.54277 0 m
.54493 .01563 L
.55019 .04562 L
.55516 .06874 L
.56448 .10243 L
.57536 .13123 L
.58541 .15132 L
.60411 .17838 L
.61475 .18984 L
.62473 .19881 L
.64495 .2132 L
.66347 .22326 L
.68403 .23205 L
.70314 .23863 L
.7413 .24864 L
.7804 .25608 L
.82195 .262 L
.86199 .26642 L
.9005 .26984 L
.94148 .27282 L
.97619 .27494 L
s
.02381 .33438 m
.06244 .33725 L
.10458 .34101 L
.14415 .34535 L
.18221 .35054 L
.22272 .35764 L
.26171 .36675 L
.28158 .37265 L
.30316 .38039 L
.32216 .38877 L
.34309 .40035 L
.36292 .41459 L
.38395 .435 L
.40336 .46172 L
.41426 .48204 L
.42424 .50575 L
.43408 .53618 L
.44322 .57389 L
s
.44322 .57389 m
.45081 .61803 L
s
.4998 .61803 m
.49982 0 L
s
.5512 0 m
.55516 .02209 L
.56448 .06253 L
.57536 .09709 L
.58541 .1212 L
.60411 .15367 L
.61475 .16742 L
.62473 .17818 L
.64495 .19545 L
.66347 .20751 L
.68403 .21807 L
.70314 .22596 L
.7413 .23798 L
.7804 .2469 L
.82195 .25401 L
.86199 .25931 L
.9005 .26341 L
.94148 .26699 L
.97619 .26954 L
s
1 0 0 r
.01 w
.02381 .32358 m
.04264 .32447 L
.06319 .32552 L
.08248 .32661 L
.10103 .32776 L
.12078 .3291 L
.13979 .33053 L
.15999 .33223 L
.17946 .33407 L
.19818 .33606 L
.21811 .33847 L
.23729 .34114 L
.25573 .3441 L
.27537 .34778 L
.29428 .35199 L
.31437 .35741 L
.33373 .36386 L
.35235 .37167 L
.37216 .38247 L
.39124 .3966 L
.40168 .40664 L
.41151 .41828 L
.42047 .43138 L
.4303 .44964 L
.44002 .47357 L
.4454 .49046 L
.45029 .50903 L
.45485 .52992 L
.4598 .55802 L
.46504 .59637 L
s
.46504 .59637 m
.46725 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{137.188, 375.063}, {421.125, 274.563}} -> {-8.07237, \
19.7977, 0.0283373, 0.0780381}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solve[y1[2]==1,c]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{c \[Rule] \(-1\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(yp2[x_] = y1[x] /. %[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(\(-\(1\/\(1 - x\)\)\)\)], "Output"]
}, Open  ]],

Cell["Clear[y1,y]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["DSolve[{1/(x-1)+1/y[x]*y'[x]==0, y[-2]==1},y[x],x]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{y[x] \[Rule] \(-\(3\/\(\(-1\) + x\)\)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DSolve[{1/(x-1)+1/y[x]*y'[x]==0, y[2]==1},y[x],x]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{y[x] \[Rule] 1\/\(\(-1\) + x\)}}\)], "Output"]
}, Open  ]],

Cell["\<\
Clear[y,y1,yp]
\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
3. Rie\[SHacek]te diferenci\[AAcute]lnu rovnicu y+x*lnx*y'=0. 
   N\[AAcute]jdite partikul\[AAcute]rne rie\[SHacek]enie, ktor\[EAcute] sp\
\:013a\:0148a za\[CHacek]. podmienku \t\ty(e)=3.
   Nakreslite integr\[AAcute]lnu krivku partikul\[AAcute]rneho \
rie\[SHacek]enia.
------------------------------------------------------------------------------\
-\
\>", "Section",
  PageBreakAbove->True,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Arial CE",
  FontColor->RGBColor[0, 0.500008, 0],
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["DSolve[y[x]+x*Log[x]*y'[x]==0,y[x],x]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{y[x] \[Rule] C[1]\/Log[x]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["y1[x_]=y[x]/.%[[1]]/.C[1]->c", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[BoxData[
    \(c\/Log[x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solve[y1[E]==3,c]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{c \[Rule] 3}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["yp[x_]=y1[x]/.c->3", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(3\/Log[x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
gp=Plot[yp[x],{x,1.001,1.5},PlotRange->{0,50},
PlotStyle->Thickness[0.008]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.88668 1.90858 1.73472e-017 0.0123607 [
[.21276 -0.0125 -9 -9 ]
[.21276 -0.0125 9 0 ]
[.40362 -0.0125 -9 -9 ]
[.40362 -0.0125 9 0 ]
[.59447 -0.0125 -9 -9 ]
[.59447 -0.0125 9 0 ]
[.78533 -0.0125 -9 -9 ]
[.78533 -0.0125 9 0 ]
[.97619 -0.0125 -9 -9 ]
[.97619 -0.0125 9 0 ]
[.0094 .12361 -12 -4.5 ]
[.0094 .12361 0 4.5 ]
[.0094 .24721 -12 -4.5 ]
[.0094 .24721 0 4.5 ]
[.0094 .37082 -12 -4.5 ]
[.0094 .37082 0 4.5 ]
[.0094 .49443 -12 -4.5 ]
[.0094 .49443 0 4.5 ]
[.0094 .61803 -12 -4.5 ]
[.0094 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21276 0 m
.21276 .00625 L
s
[(1.1)] .21276 -0.0125 0 1 Mshowa
.40362 0 m
.40362 .00625 L
s
[(1.2)] .40362 -0.0125 0 1 Mshowa
.59447 0 m
.59447 .00625 L
s
[(1.3)] .59447 -0.0125 0 1 Mshowa
.78533 0 m
.78533 .00625 L
s
[(1.4)] .78533 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(1.5)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.06007 0 m
.06007 .00375 L
s
.09824 0 m
.09824 .00375 L
s
.13642 0 m
.13642 .00375 L
s
.17459 0 m
.17459 .00375 L
s
.25093 0 m
.25093 .00375 L
s
.2891 0 m
.2891 .00375 L
s
.32727 0 m
.32727 .00375 L
s
.36545 0 m
.36545 .00375 L
s
.44179 0 m
.44179 .00375 L
s
.47996 0 m
.47996 .00375 L
s
.51813 0 m
.51813 .00375 L
s
.5563 0 m
.5563 .00375 L
s
.63265 0 m
.63265 .00375 L
s
.67082 0 m
.67082 .00375 L
s
.70899 0 m
.70899 .00375 L
s
.74716 0 m
.74716 .00375 L
s
.8235 0 m
.8235 .00375 L
s
.86168 0 m
.86168 .00375 L
s
.89985 0 m
.89985 .00375 L
s
.93802 0 m
.93802 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.0219 .12361 m
.02815 .12361 L
s
[(10)] .0094 .12361 1 0 Mshowa
.0219 .24721 m
.02815 .24721 L
s
[(20)] .0094 .24721 1 0 Mshowa
.0219 .37082 m
.02815 .37082 L
s
[(30)] .0094 .37082 1 0 Mshowa
.0219 .49443 m
.02815 .49443 L
s
[(40)] .0094 .49443 1 0 Mshowa
.0219 .61803 m
.02815 .61803 L
s
[(50)] .0094 .61803 1 0 Mshowa
.125 Mabswid
.0219 .02472 m
.02565 .02472 L
s
.0219 .04944 m
.02565 .04944 L
s
.0219 .07416 m
.02565 .07416 L
s
.0219 .09889 m
.02565 .09889 L
s
.0219 .14833 m
.02565 .14833 L
s
.0219 .17305 m
.02565 .17305 L
s
.0219 .19777 m
.02565 .19777 L
s
.0219 .22249 m
.02565 .22249 L
s
.0219 .27193 m
.02565 .27193 L
s
.0219 .29666 m
.02565 .29666 L
s
.0219 .32138 m
.02565 .32138 L
s
.0219 .3461 m
.02565 .3461 L
s
.0219 .39554 m
.02565 .39554 L
s
.0219 .42026 m
.02565 .42026 L
s
.0219 .44498 m
.02565 .44498 L
s
.0219 .46971 m
.02565 .46971 L
s
.0219 .51915 m
.02565 .51915 L
s
.0219 .54387 m
.02565 .54387 L
s
.0219 .56859 m
.02565 .56859 L
s
.0219 .59331 m
.02565 .59331 L
s
.25 Mabswid
.0219 0 m
.0219 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.14013 .61803 m
.14407 .59767 L
.16442 .51491 L
.18298 .45768 L
.20367 .40762 L
.22282 .37048 L
.26115 .31399 L
.30042 .27223 L
.33817 .24185 L
.37837 .21655 L
.41706 .19706 L
.4582 .18012 L
.49782 .16656 L
.53593 .15549 L
.57649 .14537 L
.61554 .13693 L
.65703 .12909 L
.69702 .12244 L
.73548 .11674 L
.7764 .11132 L
.8158 .10662 L
.85369 .10251 L
.89403 .09853 L
.93286 .09503 L
.97413 .09162 L
.97619 .09146 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{137.188, 375.063}, {558.375, 411.813}} -> {0.620541, \
151.018, 0.00194675, 0.300592}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["t3=Table[y1[x],{c,1,5}]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({1\/Log[x], 2\/Log[x], 3\/Log[x], 4\/Log[x], 5\/Log[x]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["gvr=Plot[Evaluate[t3],{x,1.001,1.5},PlotRange->{0,100}]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.88668 1.90858 1.73472e-017 0.00618034 [
[.21276 -0.0125 -9 -9 ]
[.21276 -0.0125 9 0 ]
[.40362 -0.0125 -9 -9 ]
[.40362 -0.0125 9 0 ]
[.59447 -0.0125 -9 -9 ]
[.59447 -0.0125 9 0 ]
[.78533 -0.0125 -9 -9 ]
[.78533 -0.0125 9 0 ]
[.97619 -0.0125 -9 -9 ]
[.97619 -0.0125 9 0 ]
[.0094 .12361 -12 -4.5 ]
[.0094 .12361 0 4.5 ]
[.0094 .24721 -12 -4.5 ]
[.0094 .24721 0 4.5 ]
[.0094 .37082 -12 -4.5 ]
[.0094 .37082 0 4.5 ]
[.0094 .49443 -12 -4.5 ]
[.0094 .49443 0 4.5 ]
[.0094 .61803 -18 -4.5 ]
[.0094 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21276 0 m
.21276 .00625 L
s
[(1.1)] .21276 -0.0125 0 1 Mshowa
.40362 0 m
.40362 .00625 L
s
[(1.2)] .40362 -0.0125 0 1 Mshowa
.59447 0 m
.59447 .00625 L
s
[(1.3)] .59447 -0.0125 0 1 Mshowa
.78533 0 m
.78533 .00625 L
s
[(1.4)] .78533 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(1.5)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.06007 0 m
.06007 .00375 L
s
.09824 0 m
.09824 .00375 L
s
.13642 0 m
.13642 .00375 L
s
.17459 0 m
.17459 .00375 L
s
.25093 0 m
.25093 .00375 L
s
.2891 0 m
.2891 .00375 L
s
.32727 0 m
.32727 .00375 L
s
.36545 0 m
.36545 .00375 L
s
.44179 0 m
.44179 .00375 L
s
.47996 0 m
.47996 .00375 L
s
.51813 0 m
.51813 .00375 L
s
.5563 0 m
.5563 .00375 L
s
.63265 0 m
.63265 .00375 L
s
.67082 0 m
.67082 .00375 L
s
.70899 0 m
.70899 .00375 L
s
.74716 0 m
.74716 .00375 L
s
.8235 0 m
.8235 .00375 L
s
.86168 0 m
.86168 .00375 L
s
.89985 0 m
.89985 .00375 L
s
.93802 0 m
.93802 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.0219 .12361 m
.02815 .12361 L
s
[(20)] .0094 .12361 1 0 Mshowa
.0219 .24721 m
.02815 .24721 L
s
[(40)] .0094 .24721 1 0 Mshowa
.0219 .37082 m
.02815 .37082 L
s
[(60)] .0094 .37082 1 0 Mshowa
.0219 .49443 m
.02815 .49443 L
s
[(80)] .0094 .49443 1 0 Mshowa
.0219 .61803 m
.02815 .61803 L
s
[(100)] .0094 .61803 1 0 Mshowa
.125 Mabswid
.0219 .0309 m
.02565 .0309 L
s
.0219 .0618 m
.02565 .0618 L
s
.0219 .09271 m
.02565 .09271 L
s
.0219 .15451 m
.02565 .15451 L
s
.0219 .18541 m
.02565 .18541 L
s
.0219 .21631 m
.02565 .21631 L
s
.0219 .27812 m
.02565 .27812 L
s
.0219 .30902 m
.02565 .30902 L
s
.0219 .33992 m
.02565 .33992 L
s
.0219 .40172 m
.02565 .40172 L
s
.0219 .43262 m
.02565 .43262 L
s
.0219 .46353 m
.02565 .46353 L
s
.0219 .52533 m
.02565 .52533 L
s
.0219 .55623 m
.02565 .55623 L
s
.0219 .58713 m
.02565 .58713 L
s
.25 Mabswid
.0219 0 m
.0219 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.04116 .61803 m
.04262 .57247 L
.04748 .46428 L
.05023 .41949 L
.05278 .38505 L
.05746 .33481 L
.06244 .29402 L
.06791 .25945 L
.07382 .23025 L
.08454 .19138 L
.09498 .16448 L
.10458 .14574 L
.1234 .11927 L
.13409 .1082 L
.14407 .09961 L
.16442 .08582 L
.18298 .07628 L
.20367 .06794 L
.22282 .06175 L
.26115 .05233 L
.30042 .04537 L
.33817 .04031 L
.37837 .03609 L
.41706 .03284 L
.4582 .03002 L
.49782 .02776 L
.53593 .02591 L
.57649 .02423 L
.61554 .02282 L
.65703 .02151 L
.69702 .02041 L
.73548 .01946 L
.7764 .01855 L
.8158 .01777 L
.85369 .01709 L
.89403 .01642 L
.93286 .01584 L
.97413 .01527 L
.97619 .01524 L
s
.06061 .61803 m
.06244 .58803 L
.06791 .5189 L
.07382 .46051 L
.08454 .38275 L
.09498 .32897 L
.10458 .29147 L
.1234 .23855 L
.13409 .2164 L
.14407 .19922 L
.16442 .17164 L
.18298 .15256 L
.20367 .13587 L
.22282 .12349 L
.26115 .10466 L
.30042 .09074 L
.33817 .08062 L
.37837 .07218 L
.41706 .06569 L
.4582 .06004 L
.49782 .05552 L
.53593 .05183 L
.57649 .04846 L
.61554 .04564 L
.65703 .04303 L
.69702 .04081 L
.73548 .03891 L
.7764 .03711 L
.8158 .03554 L
.85369 .03417 L
.89403 .03284 L
.93286 .03168 L
.97413 .03054 L
.97619 .03049 L
s
.08051 .61803 m
.08454 .57413 L
.09498 .49345 L
.10458 .43721 L
.1234 .35782 L
.13409 .3246 L
.14407 .29884 L
.16442 .25746 L
.18298 .22884 L
.20367 .20381 L
.22282 .18524 L
.26115 .157 L
.30042 .13612 L
.33817 .12092 L
.37837 .10828 L
.41706 .09853 L
.4582 .09006 L
.49782 .08328 L
.53593 .07774 L
.57649 .07268 L
.61554 .06846 L
.65703 .06454 L
.69702 .06122 L
.73548 .05837 L
.7764 .05566 L
.8158 .05331 L
.85369 .05126 L
.89403 .04927 L
.93286 .04752 L
.97413 .04581 L
.97619 .04573 L
s
.10009 .61803 m
.10458 .58295 L
.1234 .47709 L
.13409 .4328 L
.14407 .39845 L
.16442 .34328 L
.18298 .30512 L
.20367 .27174 L
.22282 .24699 L
.26115 .20933 L
.30042 .18149 L
.33817 .16123 L
.37837 .14437 L
.41706 .13138 L
.4582 .12008 L
.49782 .11104 L
.53593 .10366 L
.57649 .09691 L
.61554 .09128 L
.65703 .08606 L
.69702 .08163 L
.73548 .07783 L
.7764 .07421 L
.8158 .07108 L
.85369 .06834 L
.89403 .06569 L
.93286 .06335 L
.97413 .06108 L
.97619 .06097 L
s
.12032 .61803 m
.1234 .59637 L
.13409 .54101 L
.14407 .49806 L
.16442 .42909 L
.18298 .3814 L
.20367 .33968 L
.22282 .30873 L
.26115 .26166 L
.30042 .22686 L
.33817 .20154 L
.37837 .18046 L
.41706 .16422 L
.4582 .1501 L
.49782 .1388 L
.53593 .12957 L
.57649 .12114 L
.61554 .11411 L
.65703 .10757 L
.69702 .10203 L
.73548 .09729 L
.7764 .09276 L
.8158 .08885 L
.85369 .08543 L
.89403 .08211 L
.93286 .07919 L
.97413 .07635 L
.97619 .07621 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`00A03oool02P3oom@0V`00000000000000001b0;[Zo`3oool0oooD09/00000L[X20?ooo`06
0?ooe02K00000000000000000780^^[o8P3oool02P3oom@0V`00000000000000001b0;[Zo`3oool0
oooD09/00000L[X20?ooo`060?oDV`00000000000000000009/0e?oo8@3oool02P3oom@0V`000000
00000000001b0;[Zo`3oool0oooD09/00000L[X30?ooo`040>ZjLP0000000000002Ke2<0oooo00X0
oooD09/00000000000000000LP2jj_l0oooo0?ooe02K000007:j103oool0103Z^W8000000000LP2j
j_lQ0?ooo`0:0?ooe02K00000000000000000780^^[o0?ooo`3oom@0V`00001b^P<0oooo00@0j[Yb
000000000000L[[Z1`3oool004H0oooo00<0omBK07:jjP3oool02@3oool00`3oe9/0L[[Z0?ooo`0U
0?ooo`030?oDV`1b^^X0oooo00P0oooo00<0^W800000V`3Dool09@3oool00`3oe9/0L[[Z0?ooo`07
0?ooo`060?oZ^P1bL[X0oooo0?ooe02K0780^^[o903oool00`3oe9/0L[[Z0?ooo`0:0?ooo`030?oD
V`1b^^X0oooo02<0oooo00<0omBK07:jjP3oool01`3oool01P3oj[X0LW:j0?ooo`3oool0^W9b0;[Z
o`H0oooo00160?ooo`030?oDV`1b^^X0oooo00T0oooo00<0omBK07:jjP3oool09@3oool00`3oe9/0
L[[Z0?ooo`090?ooo`030?oDV`000000VmCo02@0oooo00<0omBK07:jjP3oool02@3oool00`3DV`00
000009_Do`0U0?ooo`030?oDV`1b^^X0oooo00L0oooo00H0oooD09/00000000000000000LP2jj_lS
0?ooo`030?oDV`1b^^X0oooo00/0oooo00<0e9]b0;[Zo`3oool01@3oool004H0oooo00<0omBK07:j
jP3oool02@3oool00`3oe9/0L[[Z0?ooo`0U0?ooo`030?oDV`1b^^X0oooo00X0oooo00<0oooD0=CD
o`3oool08`3oool00`3oe9/0L[[Z0?ooo`0:0?ooo`030?ooe02KL[X0oooo02@0oooo00<0omBK07:j
jP3oool0203oool0103DV`00VmCo0?oDV`1b^^XT0?ooo`030?oDV`1b^^X0oooo00P0oooo00@0e9/0
00000000000009_D1`3oool004D0oooo00<0^W:K0=CDV`1b^^X02@3oool00`2jLY/0e=BK07:jjP0U
0?ooo`030;YbV`3De9/0L[[Z00P0oooo00H0onZj079b^P3oool0oooD09/0V`3DoolR0?ooo`030;Yb
V`3De9/0L[[Z00P0oooo00H0oooD09/0LP2jj_l0oooD09/0V`3DoolS0?ooo`030;YbV`3De9/0L[[Z
00T0oooo00@0oooD09/0LP2j^Y/0L[[Z8`3oool00`2jLY/0e=BK07:jjP090?ooo`030=BKLP2jj_l0
oooo00P0oooo00150?ooo`030?oDV`000000L[[Z00T0oooo00<0omBK0000001b^^X09@3oool00`3o
e9/0000007:jjP090?ooo`040>ZjLP000000000007:jjR<0oooo00<0omBK0000001b^^X02@3oool0
103oj[X0LP000000002Ke?lT0?ooo`030?oDV`000000L[[Z00X0oooo00<0onZj0780001b^^X08`3o
ool00`3oe9/0000007:jjP090?ooo`040=BK000000000000002Ke0L0oooo003o0?ooob/0oooo003o
0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo000D0?ooool000004000
00070?ooo`006P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00`0oooo000J0?oo
o`030000003oool0oooo0300oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo0340oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0<0?oo
o`006P3oool00`000000oooo0?ooo`3o0?ooo`h0oooo000J0?ooo`030000003oool0oooo0?T0oooo
1P00000>0?ooo`006P3oool00`000000oooo0?ooo`330?ooocH00000503oool001X0oooo00<00000
0?ooo`3oool0X`3ooolP000004X0oooo000J0?ooo`030000003oool0oooo08<0oooo8000001Z0?oo
o`006P3oool00`000000oooo0?ooo`1]0?oooaH00000RP3oool001X0oooo0P00001T0?ooo`X00000
MP3ooolL000000h0oooo000J0?ooo`030000003oool0oooo05P0oooo2`00001P0?ooob000000:P3o
ool001X0oooo00<000000?ooo`3oool0D03oool8000005H0oooo5@00001:0?ooo`006P3oool00`00
0000oooo0?ooo`1;0?ooo`D00000D`3oool;000005l0oooo000J0?ooo`030000003oool0oooo04<0
oooo200000120?oooaH00000B`3ooolA000000h0oooo000J0?ooo`030000003oool0oooo03`0oooo
1`0000100?ooo`X00000C03ooolE000001l0oooo000J0?ooo`030000003oool0oooo03T0oooo0`00
000o0?ooo`P00000@03ooolF000003@0oooo000J0?ooo`030000003oool0oooo03D0oooo1000000l
0?ooo`H00000?P3oool:000004X0oooo000J0?ooo`800000<`3oool3000003P0oooo2000000i0?oo
o`/00000=@3ooolA000000h0oooo000J0?ooo`030000003oool0oooo0300oooo0P00000c0?ooo`P0
0000=P3oool;000003D0oooo2`00000O0?ooo`006P3oool00`000000oooo0?ooo`0]0?ooo`<00000
<03oool5000003<0oooo2`00000f0?ooo`X00000:P3oool001X0oooo00<000000?ooo`3oool0:P3o
ool3000002h0oooo1@00000]0?ooo`/00000:`3ooolF000003@0oooo000J0?ooo`030000003oool0
oooo02P0oooo0P00000[0?ooo`H00000:P3oool8000002`0oooo2P00000f0?ooo`H000003P3oool0
01X0oooo00<000000?ooo`3oool09P3oool2000002T0oooo1000000[0?ooo`D00000;03oool80000
03D0oooo2`00000D0?ooo`006P3oool00`000000oooo0?ooo`0T0?ooo`800000:03oool3000002X0
oooo1@00000[0?ooo`H00000:03ooolE000001l0oooo000J0?ooo`030000003oool0oooo02<0oooo
00<000000?ooo`3oool0903oool4000002L0oooo1P00000X0?ooo`P000008`3oool;000003@0oooo
000J0?ooo`8000008P3oool2000002@0oooo0`00000V0?ooo`D000008`3oool;000002<0oooo2000
000o0?ooo`006P3oool00`000000oooo0?ooo`0O0?ooo`8000008`3oool3000002<0oooo1P00000P
0?ooo`P00000:03oool6000004L0oooo000J0?ooo`030000003oool0oooo01h0oooo00<000000?oo
o`3oool08@3oool200000280oooo1000000P0?ooo`H00000:@3oool7000004d0oooo000J0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool07`3oool300000240oooo0`00000O0?ooo`D0
0000903oool;000005@0oooo000J0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0
7P3oool200000200oooo1000000M0?ooo`D000008@3oool8000005l0oooo000J0?ooo`030000003o
ool0oooo01/0oooo00<000000?ooo`3oool07@3oool2000001l0oooo0`00000M0?ooo`@00000803o
ool6000006L0oooo000J0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0703oool2
000001d0oooo1000000L0?ooo`@000007`3oool5000006d0oooo000:0?ooo`080?oDV`0000000000
0000000009/0e?oo0?ooo`3Z^W820000000307:jjP3oool0oooo00<0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0K0?ooo`8000006`3oool4000001`0oooo1000000M0?ooo`H00000
LP3oool000/0oooo00<0^W800000V`3Dool00`3oool01@2jVkX0oooo0?ooo`2jLY/0e?oo00@0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0J0?ooo`8000006P3oool3000001d0oooo
0`00000L0?ooo`D00000N03oool000`0oooo00H0omBK0000002Ke?l0oooo0?ooe02KL[X20?ooo`03
0=BKLP2jj_l0oooo00<0oooo0`00000G0?ooo`030000003oool0oooo01T0oooo0P00000J0?ooo`80
0000703oool4000001T0oooo1P00001m0?ooo`003@3oool01@3oom@0e=Co0?ooo`3oom@0Vg:j0080
oooo00<0e9]b0;[Zo`3oool00`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0
oooo0P00000I0?ooo`<000006P3oool4000001T0oooo100000230?ooo`002P3oool0303oj[X0LW:j
0?ooo`3oom@0V`2K0=Coo`3oool0^W9b0;[Zo`3oom@0V`2K0=Coo`@0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`0F0?ooo`8000006@3oool2000001X0oooo0`00000J0?ooo`<00000
Q`3oool000/0oooo00@0j[Yb000000000000L[[Z0P3oool0103oj[X0LP000000002Ke?l50?ooo`03
0000003oool0oooo01D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`80
00006@3oool3000001T0oooo1000002:0?ooo`006P3oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool05P3oool2000001L0oooo1000000I0?ooo`<00000
SP3oool001X0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo01D0oooo0P00000F0?ooo`<000006@3oool400000940oooo000J0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0503oool2000001H0oooo0P00000F0?ooo`800000603oool4
000009D0oooo000J0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`0D0?ooo`8000005P3oool2000001L0oooo0`00002I0?ooo`006P3oool2000001<0
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0C0?ooo`8000005P3oool2000001H0
oooo0`00002L0?ooo`006P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0D0?ooo`8000005P3oool2000009l0oooo
000J0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0B0?ooo`8000005@3oool2000001D0oooo0`00002Q0?ooo`006P3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0C
0?ooo`800000503oool300000:@0oooo000J0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0180oooo0P00000D0?oo
o`800000Y`3oool001X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0140oooo0P00000C0?ooo`8000004`3oool300000:T0oooo000J0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo0140oooo0P00000C0?ooo`800000[03oool001X0oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00l0oooo0P00000B0?ooo`8000004`3o
ool200000:h0oooo000J0?ooo`800000403oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0403oool2000001<0oooo0P00002`0?ooo`006P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo0140oooo0P00002b0?ooo`006P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo0P00002d0?ooo`006P3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0?0?ooo`8000004@3oool200000;H0oooo000J0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool03`3oool200000;P0oooo000J0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`2h0?ooo`006P3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?oo
o`800000403oool200000;/0oooo000J0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`2k0?ooo`006P3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool0_03oool001X0oooo0P00000=0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00h0oooo0P00002o0?ooo`006P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool0_`3oool001X0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0=0?ooo`800000`P3oool001X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo0<80oooo000J0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`330?ooo`006P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00`0oooo0P0000360?ooo`00303oool01P3Z^W8000000000LP2j
j_l0oooo0>ZjLP80000000<0L[[Z0?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0aP3oool000d0oooo00D0omBK07:jjP3oool0oooo
0;ZK^P020?ooo`030;YbV`3Dool0oooo00<0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo0<L0oooo000:0?ooo`080?ooe02K00000000000000000780
^^[o0?ooe02KL[X20?ooo`030=BKLP2jj_l0oooo00<0oooo0`00000:0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0b03oool000/0oooo00L0e9/009_Do`3oe9/0L[[Z0?ooo`3oom@0
Vg:j0080oooo00<0e9]b0;[Zo`3oool00`3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0b@3oool000/0oooo00@0oooD09/0LP2j^Y/0L[[Z0P3oool0
1@2jLW80^^[o0?ooe02K09/0e?oo00@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0:0?ooo`800000c03oool000`0oooo00<0onZj0780001b^^X00P3oool0103oj[X0LP000000002K
e?l50?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`3<0?ooo`006P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool0c@3oool001X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo0<h0oooo000J0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`3?0?ooo`006P3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0c`3oool001X0oooo0P0000090?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0d03oool001X0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo0=40oooo000J0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`3B0?ooo`006P3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0dP3oool001X0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0=<0oooo
000J0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`3D0?ooo`006P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0e@3oool001X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo0=D0oooo000J0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`3F0?ooo`006P3oool2000000P0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`3G0?ooo`006P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool0f03oool001X0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo0=P0oooo000J0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`3I0?ooo`006P3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0fP3oool001X0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0=X0oooo
000J0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`3K0?ooo`006P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0f`3oool001X0oooo0P0000070?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0g03oool001X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo0=d0oooo000J0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`3M0?ooo`006P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0gP3oool001X0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo0=h0oooo000J0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3O0?ooo`002`3oool01`3oom@0
V`00000000000780^^[o0?ooo`3Z^W800P0000000`1b^^X0oooo0?ooo`030?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3O0?ooo`002`3oool01`3D
V`00VmCo0?ooo`3oom@0e=Co0?ooo`2jVkX00P3oool00`2jLY/0e?oo0?ooo`030?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3P0?ooo`002P3oool0
203oom@0V`0007:jjP3oool0j[Yb09_Do`3oom@0Vg:j0P3oool00`3DVg80^^[o0?ooo`030?ooo`<0
00001@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0>00oooo000;0?ooo`070;Yb
V`1bLP000000001b^P3oool0oooD09]b^P020?ooo`030=BKLP2jj_l0oooo00<0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0>40oooo000;0?ooo`03
0?oDV`00L[X0oooo00<0oooo00D0^W9b0;[Zo`3oom@0V`2K0=Coo`040?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3Q0?ooo`00303oool02@3Z^W80
00000000002Ke?l0oooo0?oZ^P1b0000000009_Do`050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`3R0?ooo`006P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0hP3oool001X0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0><0oooo000J0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3S0?ooo`00
6P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
i03oool001X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo0>@0oooo000J0?ooo`8000001@3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0>@0oooo000J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`3U0?ooo`006P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0i@3oool001X0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0>D0oooo000J0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`3V0?ooo`006P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0iP3oool001X0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0>L0oooo000J0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3W0?ooo`00
6P3oool2000000D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3W0?ooo`006P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0j03o
ool001X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0>P0oooo000J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`3X0?ooo`006P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0j03oool001X0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0>T0oooo000J0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`3Y0?ooo`006P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0j@3oool001X0oooo0P0000050?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0j@3oool001X0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0>X0oooo000J0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3Z0?ooo`006P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0jP3o
ool001X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0>X0oooo000J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`3[0?ooo`006P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0j`3oool000/0oooo00@0e9/0000000000000L[[Z0P3oool0103Z^W80
00000000001b^^X50?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`3[0?ooo`002P3oool01@3oom@0Vi_D0?ooo`3oool0^Y^j0080oooo00D0^Y^j0?oo
o`3oool0^W:K0=Coo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`3[0?ooo`002`3oool01`2jVkX0oooo0?ooe02KVm@0oooo0?ooe02KL[X00P3o
ool00`3DVg80^^[o0?ooo`030?ooo`<000000`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0>`0oooo000;0?ooo`070=BK00000000000007:jjP3oool0oooD09]b^P020?ooo`030=BK
LP2jj_l0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0>`0oooo000:0?ooo`050?ooe02KL[X0oooo0?ooe02KL[X00P3oool01@2jLW80^^[o
0?ooe02K09/0e?oo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo0>`0oooo000;0?ooo`040>ZjLP000000000009_Do`80oooo00@0onZj07800000
0000VmCo1@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0k@3oool001X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo0>d0oooo000J0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`3]0?ooo`006P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0k@3oool001X0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0>h0oooo000J0?ooo`800000103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0>h0oooo000J0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3^0?ooo`006P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0kP3oool001X0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0>l0oooo000J
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3_
0?ooo`006P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0k`3oool001X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0>l0oooo000J0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`3`0?ooo`006P3oool2000000<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`3`0?ooo`006P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0l03oool001X0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0?00oooo000J0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3`0?ooo`006P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0l@3oool001X0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?40oooo000J
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3a
0?ooo`006P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0l@3oool001X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0?40oooo000J0?ooo`8000000`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0?80oooo000J0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`3b0?ooo`006P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0lP3oool001X0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0?80oooo000J0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3b0?ooo`006P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0l`3oool000@0oooo00P0
oooD09/00000000000000000LP2jj_l0oooo0>ZjLP80000000@0L[[Z0?ooo`3oool0j[Yb0P000000
0`1b^^X0oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`3c0?ooo`001P3oool00`3oe9/0L[[Z0?ooo`020?ooo`070;ZK^P3oool0oooo
0;YbV`3Dool0oooo0;ZK^P020?ooo`030;YbV`3Dool0oooo00<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?<0oooo00060?ooo`060?oDV`1b^^X0
oooo0?ooo`3oom@0Vg:j0P3oool0103DVg80^^[o0?ooe02KL[X20?ooo`030=BKLP2jj_l0oooo00<0
oooo0`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0l`3oool000H0oooo
00H0omBK07:jjP3oool0oooo0?ooe02KL[X20?ooo`040=BKLP2jj_l0oooD09]b^P80oooo00<0e9]b
0;[Zo`3oool0o`3ooolD0?ooo`001@3oool00`2jLY/0e=BK07:jjP030?ooo`0;0;YbLP2jj_l0oooD
09/0V`3Dool0oooo0;YbLP2jj_l0oooD09/0V`3Dool0o`3ooolE0?ooo`001@3oool00`3oe9/00000
07:jjP030?ooo`040?oZ^P1b0000000009_Do`80oooo00@0onZj078000000000VmCoo`3ooolF0?oo
o`00o`3oool[0?ooo`00\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {228.438, 81.875}} -> {0.614701, \
54.0938, 0.00194675, 0.601185}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["gvs=Show[gvr,gp]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.88668 1.90858 1.73472e-017 0.00618034 [
[.21276 -0.0125 -9 -9 ]
[.21276 -0.0125 9 0 ]
[.40362 -0.0125 -9 -9 ]
[.40362 -0.0125 9 0 ]
[.59447 -0.0125 -9 -9 ]
[.59447 -0.0125 9 0 ]
[.78533 -0.0125 -9 -9 ]
[.78533 -0.0125 9 0 ]
[.97619 -0.0125 -9 -9 ]
[.97619 -0.0125 9 0 ]
[.0094 .12361 -12 -4.5 ]
[.0094 .12361 0 4.5 ]
[.0094 .24721 -12 -4.5 ]
[.0094 .24721 0 4.5 ]
[.0094 .37082 -12 -4.5 ]
[.0094 .37082 0 4.5 ]
[.0094 .49443 -12 -4.5 ]
[.0094 .49443 0 4.5 ]
[.0094 .61803 -18 -4.5 ]
[.0094 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21276 0 m
.21276 .00625 L
s
[(1.1)] .21276 -0.0125 0 1 Mshowa
.40362 0 m
.40362 .00625 L
s
[(1.2)] .40362 -0.0125 0 1 Mshowa
.59447 0 m
.59447 .00625 L
s
[(1.3)] .59447 -0.0125 0 1 Mshowa
.78533 0 m
.78533 .00625 L
s
[(1.4)] .78533 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(1.5)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.06007 0 m
.06007 .00375 L
s
.09824 0 m
.09824 .00375 L
s
.13642 0 m
.13642 .00375 L
s
.17459 0 m
.17459 .00375 L
s
.25093 0 m
.25093 .00375 L
s
.2891 0 m
.2891 .00375 L
s
.32727 0 m
.32727 .00375 L
s
.36545 0 m
.36545 .00375 L
s
.44179 0 m
.44179 .00375 L
s
.47996 0 m
.47996 .00375 L
s
.51813 0 m
.51813 .00375 L
s
.5563 0 m
.5563 .00375 L
s
.63265 0 m
.63265 .00375 L
s
.67082 0 m
.67082 .00375 L
s
.70899 0 m
.70899 .00375 L
s
.74716 0 m
.74716 .00375 L
s
.8235 0 m
.8235 .00375 L
s
.86168 0 m
.86168 .00375 L
s
.89985 0 m
.89985 .00375 L
s
.93802 0 m
.93802 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.0219 .12361 m
.02815 .12361 L
s
[(20)] .0094 .12361 1 0 Mshowa
.0219 .24721 m
.02815 .24721 L
s
[(40)] .0094 .24721 1 0 Mshowa
.0219 .37082 m
.02815 .37082 L
s
[(60)] .0094 .37082 1 0 Mshowa
.0219 .49443 m
.02815 .49443 L
s
[(80)] .0094 .49443 1 0 Mshowa
.0219 .61803 m
.02815 .61803 L
s
[(100)] .0094 .61803 1 0 Mshowa
.125 Mabswid
.0219 .0309 m
.02565 .0309 L
s
.0219 .0618 m
.02565 .0618 L
s
.0219 .09271 m
.02565 .09271 L
s
.0219 .15451 m
.02565 .15451 L
s
.0219 .18541 m
.02565 .18541 L
s
.0219 .21631 m
.02565 .21631 L
s
.0219 .27812 m
.02565 .27812 L
s
.0219 .30902 m
.02565 .30902 L
s
.0219 .33992 m
.02565 .33992 L
s
.0219 .40172 m
.02565 .40172 L
s
.0219 .43262 m
.02565 .43262 L
s
.0219 .46353 m
.02565 .46353 L
s
.0219 .52533 m
.02565 .52533 L
s
.0219 .55623 m
.02565 .55623 L
s
.0219 .58713 m
.02565 .58713 L
s
.25 Mabswid
.0219 0 m
.0219 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.04116 .61803 m
.04262 .57247 L
.04748 .46428 L
.05023 .41949 L
.05278 .38505 L
.05746 .33481 L
.06244 .29402 L
.06791 .25945 L
.07382 .23025 L
.08454 .19138 L
.09498 .16448 L
.10458 .14574 L
.1234 .11927 L
.13409 .1082 L
.14407 .09961 L
.16442 .08582 L
.18298 .07628 L
.20367 .06794 L
.22282 .06175 L
.26115 .05233 L
.30042 .04537 L
.33817 .04031 L
.37837 .03609 L
.41706 .03284 L
.4582 .03002 L
.49782 .02776 L
.53593 .02591 L
.57649 .02423 L
.61554 .02282 L
.65703 .02151 L
.69702 .02041 L
.73548 .01946 L
.7764 .01855 L
.8158 .01777 L
.85369 .01709 L
.89403 .01642 L
.93286 .01584 L
.97413 .01527 L
.97619 .01524 L
s
.06061 .61803 m
.06244 .58803 L
.06791 .5189 L
.07382 .46051 L
.08454 .38275 L
.09498 .32897 L
.10458 .29147 L
.1234 .23855 L
.13409 .2164 L
.14407 .19922 L
.16442 .17164 L
.18298 .15256 L
.20367 .13587 L
.22282 .12349 L
.26115 .10466 L
.30042 .09074 L
.33817 .08062 L
.37837 .07218 L
.41706 .06569 L
.4582 .06004 L
.49782 .05552 L
.53593 .05183 L
.57649 .04846 L
.61554 .04564 L
.65703 .04303 L
.69702 .04081 L
.73548 .03891 L
.7764 .03711 L
.8158 .03554 L
.85369 .03417 L
.89403 .03284 L
.93286 .03168 L
.97413 .03054 L
.97619 .03049 L
s
.08051 .61803 m
.08454 .57413 L
.09498 .49345 L
.10458 .43721 L
.1234 .35782 L
.13409 .3246 L
.14407 .29884 L
.16442 .25746 L
.18298 .22884 L
.20367 .20381 L
.22282 .18524 L
.26115 .157 L
.30042 .13612 L
.33817 .12092 L
.37837 .10828 L
.41706 .09853 L
.4582 .09006 L
.49782 .08328 L
.53593 .07774 L
.57649 .07268 L
.61554 .06846 L
.65703 .06454 L
.69702 .06122 L
.73548 .05837 L
.7764 .05566 L
.8158 .05331 L
.85369 .05126 L
.89403 .04927 L
.93286 .04752 L
.97413 .04581 L
.97619 .04573 L
s
.10009 .61803 m
.10458 .58295 L
.1234 .47709 L
.13409 .4328 L
.14407 .39845 L
.16442 .34328 L
.18298 .30512 L
.20367 .27174 L
.22282 .24699 L
.26115 .20933 L
.30042 .18149 L
.33817 .16123 L
.37837 .14437 L
.41706 .13138 L
.4582 .12008 L
.49782 .11104 L
.53593 .10366 L
.57649 .09691 L
.61554 .09128 L
.65703 .08606 L
.69702 .08163 L
.73548 .07783 L
.7764 .07421 L
.8158 .07108 L
.85369 .06834 L
.89403 .06569 L
.93286 .06335 L
.97413 .06108 L
.97619 .06097 L
s
.12032 .61803 m
.1234 .59637 L
.13409 .54101 L
.14407 .49806 L
.16442 .42909 L
.18298 .3814 L
.20367 .33968 L
.22282 .30873 L
.26115 .26166 L
.30042 .22686 L
.33817 .20154 L
.37837 .18046 L
.41706 .16422 L
.4582 .1501 L
.49782 .1388 L
.53593 .12957 L
.57649 .12114 L
.61554 .11411 L
.65703 .10757 L
.69702 .10203 L
.73548 .09729 L
.7764 .09276 L
.8158 .08885 L
.85369 .08543 L
.89403 .08211 L
.93286 .07919 L
.97413 .07635 L
.97619 .07621 L
s
.008 w
.08051 .61803 m
.08454 .57413 L
.09498 .49345 L
.10458 .43721 L
.1234 .35782 L
.13409 .3246 L
.14407 .29884 L
.16442 .25746 L
.18298 .22884 L
.20367 .20381 L
.22282 .18524 L
.26115 .157 L
.30042 .13612 L
.33817 .12092 L
.37837 .10828 L
.41706 .09853 L
.4582 .09006 L
.49782 .08328 L
.53593 .07774 L
.57649 .07268 L
.61554 .06846 L
.65703 .06454 L
.69702 .06122 L
.73548 .05837 L
.7764 .05566 L
.8158 .05331 L
.85369 .05126 L
.89403 .04927 L
.93286 .04752 L
.97413 .04581 L
.97619 .04573 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`00A03oool02P3oom@0V`00000000000000001b0;[Zo`3oool0oooD09/00000L[X20?ooo`06
0?ooe02K00000000000000000780^^[o8P3oool02P3oom@0V`00000000000000001b0;[Zo`3oool0
oooD09/00000L[X20?ooo`060?oDV`00000000000000000009/0e?oo8@3oool02P3oom@0V`000000
00000000001b0;[Zo`3oool0oooD09/00000L[X30?ooo`040>ZjLP0000000000002Ke2<0oooo00X0
oooD09/00000000000000000LP2jj_l0oooo0?ooe02K000007:j103oool0103Z^W8000000000LP2j
j_lQ0?ooo`0:0?ooe02K00000000000000000780^^[o0?ooo`3oom@0V`00001b^P<0oooo00@0j[Yb
000000000000L[[Z1`3oool004H0oooo00<0omBK07:jjP3oool02@3oool00`3oe9/0L[[Z0?ooo`0U
0?ooo`030?oDV`1b^^X0oooo00P0oooo00<0^W800000V`3Dool09@3oool00`3oe9/0L[[Z0?ooo`07
0?ooo`060?oZ^P1bL[X0oooo0?ooe02K0780^^[o903oool00`3oe9/0L[[Z0?ooo`0:0?ooo`030?oD
V`1b^^X0oooo02<0oooo00<0omBK07:jjP3oool01`3oool01P3oj[X0LW:j0?ooo`3oool0^W9b0;[Z
o`H0oooo00160?ooo`030?oDV`1b^^X0oooo00T0oooo00<0omBK07:jjP3oool09@3oool00`3oe9/0
L[[Z0?ooo`090?ooo`030?oDV`000000VmCo02@0oooo00<0omBK07:jjP3oool02@3oool00`3DV`00
000009_Do`0U0?ooo`030?oDV`1b^^X0oooo00L0oooo00H0oooD09/00000000000000000LP2jj_lS
0?ooo`030?oDV`1b^^X0oooo00/0oooo00<0e9]b0;[Zo`3oool01@3oool004H0oooo00<0omBK07:j
jP3oool02@3oool00`3oe9/0L[[Z0?ooo`0U0?ooo`030?oDV`1b^^X0oooo00X0oooo00<0oooD0=CD
o`3oool08`3oool00`3oe9/0L[[Z0?ooo`0:0?ooo`030?ooe02KL[X0oooo02@0oooo00<0omBK07:j
jP3oool0203oool0103DV`00VmCo0?oDV`1b^^XT0?ooo`030?oDV`1b^^X0oooo00P0oooo00@0e9/0
00000000000009_D1`3oool004D0oooo00<0^W:K0=CDV`1b^^X02@3oool00`2jLY/0e=BK07:jjP0U
0?ooo`030;YbV`3De9/0L[[Z00P0oooo00H0onZj079b^P3oool0oooD09/0V`3DoolR0?ooo`030;Yb
V`3De9/0L[[Z00P0oooo00H0oooD09/0LP2jj_l0oooD09/0V`3DoolS0?ooo`030;YbV`3De9/0L[[Z
00T0oooo00@0oooD09/0LP2j^Y/0L[[Z8`3oool00`2jLY/0e=BK07:jjP090?ooo`030=BKLP2jj_l0
oooo00P0oooo00150?ooo`030?oDV`000000L[[Z00T0oooo00<0omBK0000001b^^X09@3oool00`3o
e9/0000007:jjP090?ooo`040>ZjLP000000000007:jjR<0oooo00<0omBK0000001b^^X02@3oool0
103oj[X0LP000000002Ke?lT0?ooo`030?oDV`000000L[[Z00X0oooo00<0onZj0780001b^^X08`3o
ool00`3oe9/0000007:jjP090?ooo`040=BK000000000000002Ke0L0oooo003o0?ooob/0oooo003o
0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo000D0?ooool000004000
00070?ooo`006P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00`0oooo000J0?oo
o`030000003oool0oooo0300oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo0340oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0<0?oo
o`006P3oool00`000000oooo0?ooo`3o0?ooo`h0oooo000J0?ooo`030000003oool0oooo0?T0oooo
1P00000>0?ooo`006P3oool00`000000oooo0?ooo`330?ooocH00000503oool001X0oooo00<00000
0?ooo`3oool0X`3ooolP000004X0oooo000J0?ooo`030000003oool0oooo08<0oooo8000001Z0?oo
o`006P3oool00`000000oooo0?ooo`1]0?oooaH00000RP3oool001X0oooo0P00001T0?ooo`X00000
MP3ooolL000000h0oooo000J0?ooo`030000003oool0oooo05P0oooo2`00001P0?ooob000000:P3o
ool001X0oooo00<000000?ooo`3oool0D03oool8000005H0oooo5@00001:0?ooo`006P3oool00`00
0000oooo0?ooo`1;0?ooo`D00000D`3oool;000005l0oooo000J0?ooo`030000003oool0oooo04<0
oooo200000120?oooaH00000A@3ooolG000000h0oooo000J0?ooo`030000003oool0oooo03`0oooo
1`0000100?ooo`X00000AP3oool/000000h0oooo000J0?ooo`030000003oool0oooo03T0oooo0`00
000o0?ooo`P00000>P3oool[000002D0oooo000J0?ooo`030000003oool0oooo03D0oooo1000000l
0?ooo`H00000>03ooolP000003X0oooo000J0?ooo`800000<`3oool3000003P0oooo2000000c0?oo
oaD00000<@3ooolA000000h0oooo000J0?ooo`030000003oool0oooo0300oooo0P00000c0?ooo`P0
0000<03ooolF00000300oooo2`00000O0?ooo`006P3oool00`000000oooo0?ooo`0]0?ooo`<00000
<03oool5000002d0oooo5P00000a0?ooo`X00000:P3oool001X0oooo00<000000?ooo`3oool0:P3o
ool3000002h0oooo1@00000W0?oooaH000009P3ooolF000003@0oooo000J0?ooo`030000003oool0
oooo02P0oooo0P00000[0?ooo`H000009`3oool@000002L0oooo2P00000f0?ooo`H000003P3oool0
01X0oooo00<000000?ooo`3oool09P3oool2000002T0oooo1000000X0?ooo`X00000:P3oool80000
03D0oooo2`00000D0?ooo`006P3oool00`000000oooo0?ooo`0T0?ooo`800000:03oool3000002L0
oooo2P00000Y0?ooo`H00000:03ooolE000001l0oooo000J0?ooo`030000003oool0oooo02<0oooo
00<000000?ooo`3oool0903oool4000002@0oooo2`00000V0?ooo`P000008`3oool;000003@0oooo
000J0?ooo`8000008P3oool2000002@0oooo0`00000S0?ooo`/00000803oool;000002<0oooo2000
000o0?ooo`006P3oool00`000000oooo0?ooo`0O0?ooo`8000008`3oool300000200oooo2`00000N
0?ooo`P00000:03oool6000004L0oooo000J0?ooo`030000003oool0oooo01h0oooo00<000000?oo
o`3oool08@3oool200000200oooo2@00000M0?ooo`H00000:@3oool7000004d0oooo000J0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool07`3oool3000001l0oooo1P00000N0?ooo`D0
0000903oool;000005@0oooo000J0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0
7P3oool2000001h0oooo1`00000L0?ooo`D000008@3oool8000005l0oooo000J0?ooo`030000003o
ool0oooo01/0oooo00<000000?ooo`3oool07@3oool2000001d0oooo1`00000K0?ooo`@00000803o
ool6000006L0oooo000J0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0703oool2
000001/0oooo1`00000K0?ooo`@000007`3oool5000006d0oooo000:0?ooo`080?oDV`0000000000
0000000009/0e?oo0?ooo`3Z^W820000000307:jjP3oool0oooo00<0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0K0?ooo`8000006@3oool8000001X0oooo1000000M0?ooo`H00000
LP3oool000/0oooo00<0^W800000V`3Dool00`3oool01@2jVkX0oooo0?ooo`2jLY/0e?oo00@0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0J0?ooo`800000603oool7000001/0oooo
0`00000L0?ooo`D00000N03oool000`0oooo00H0omBK0000002Ke?l0oooo0?ooe02KL[X20?ooo`03
0=BKLP2jj_l0oooo00<0oooo0`00000G0?ooo`030000003oool0oooo01T0oooo0P00000H0?ooo`H0
00006P3oool4000001T0oooo1P00001m0?ooo`003@3oool01@3oom@0e=Co0?ooo`3oom@0Vg:j0080
oooo00<0e9]b0;[Zo`3oool00`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0
oooo0P00000G0?ooo`H000006@3oool4000001T0oooo100000230?ooo`002P3oool0303oj[X0LW:j
0?ooo`3oom@0V`2K0=Coo`3oool0^W9b0;[Zo`3oom@0V`2K0=Coo`@0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`0F0?ooo`8000005`3oool6000001P0oooo0`00000J0?ooo`<00000
Q`3oool000/0oooo00@0j[Yb000000000000L[[Z0P3oool0103oj[X0LP000000002Ke?l50?ooo`03
0000003oool0oooo01D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0E0?ooo`D0
0000603oool3000001T0oooo1000002:0?ooo`006P3oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool0503oool5000001H0oooo1000000I0?ooo`<00000
SP3oool001X0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo01<0oooo1@00000E0?ooo`<000006@3oool400000940oooo000J0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0503oool2000001D0oooo1000000E0?ooo`800000603oool4
000009D0oooo000J0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`0C0?ooo`@000005@3oool2000001L0oooo0`00002I0?ooo`006P3oool2000001<0
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0B0?ooo`D00000503oool2000001H0
oooo0`00002L0?ooo`006P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool04P3oool4000001@0oooo0P00000F0?ooo`800000W`3oool001X0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo1000
000D0?ooo`8000005@3oool300000:40oooo000J0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`@000004`3oool2000001@0oooo0`00002T
0?ooo`006P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0403oool4000001<0oooo0P00000D0?ooo`800000Y`3oool001X0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo1000000B0?ooo`80
00004`3oool300000:T0oooo000J0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0?0?ooo`@000004P3oool2000001<0oooo0P00002/0?ooo`006P3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool03P3o
ool400000140oooo0P00000C0?ooo`800000[P3oool001X0oooo0P00000@0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool03P3oool300000140oooo0P00000C0?ooo`800000/03oool0
01X0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
00h0oooo0`00000A0?ooo`030000003oool0oooo0140oooo0P00002b0?ooo`006P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool300000140
oooo00<000000?ooo`3oool0403oool200000;@0oooo000J0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`<00000403oool200000140oooo
0P00002f0?ooo`006P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool300000100oooo00<000000?ooo`3oool03`3oool200000;P0oooo000J
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=
0?ooo`<00000403oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0;P0oooo000J0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?oo
o`<000003`3oool200000100oooo0P00002k0?ooo`006P3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool3000000l0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`2k0?ooo`006P3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0303oool2000000l0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`2l0?ooo`006P3oool2000000d0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0<0?ooo`8000003`3oool00`000000oooo0?ooo`0>0?ooo`800000_`3o
ool001X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo0`00000>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0_`3oool0
01X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo0`00000>0?ooo`030000003oool0oooo00d0oooo0P0000320?ooo`006P3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool2000000h0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`320?ooo`006P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool2000000h0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`330?ooo`006P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool2000000h0oooo00<0
00000?ooo`3oool0303oool200000<H0oooo000<0?ooo`060>ZjLP000000001b0;[Zo`3oool0j[Yb
0P0000000`1b^^X0oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`360?ooo`003@3oool01@3oe9/0L[[Z0?ooo`3oool0^Y^j0080oooo
00<0^W:K0=Coo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02P3oool2000000d0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`370?ooo`002P3oool0203oom@0V`00000000000000001b0;[Zo`3oom@0Vg:j0P3oool00`3D
Vg80^^[o0?ooo`030?ooo`<000002P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
0<P0oooo000;0?ooo`070=BK002Ke?l0omBK07:jjP3oool0oooD09]b^P020?ooo`030=BKLP2jj_l0
oooo00<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00X0oooo0P00000<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0b@3oool0
00/0oooo00@0oooD09/0LP2j^Y/0L[[Z0P3oool01@2jLW80^^[o0?ooe02K09/0e?oo00@0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo0P00
000=0?ooo`030000003oool0oooo00X0oooo0P00003<0?ooo`00303oool00`3oj[X0LP0007:jjP02
0?ooo`040?oZ^P1b0000000009_Do`D0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo0<`0oooo000J0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`800000303oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo0<d0oooo000J0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`3>0?ooo`006P3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool2000000`0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`3?0?ooo`006P3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0c`3oool001X0oooo0P0000090?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02@3oool2000000/0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`3@0?ooo`006P3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0d@3oool001X0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo0=80oooo000J0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`8000002P3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo0=80oooo000J0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`3C0?ooo`006P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool2000000X0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`3D0?ooo`006P3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool2000000X0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`3E0?ooo`006P3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool2000000X0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`3E0?ooo`006P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool3000000T0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`3F0?ooo`006P3oool2000000P0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`070?ooo`8000002@3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo0=L0oooo000J0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`070?ooo`8000002@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo0=P0oooo000J0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`060?ooo`<00000203oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo0=P0oooo000J0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`070?ooo`8000002@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
0=T0oooo000J0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`060?ooo`<00000203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0=X0
oooo000J0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`060?ooo`8000002@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0=X0oooo
000J0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`060?ooo`800000203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0=/0oooo000J
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`05
0?ooo`<00000203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0=/0oooo000J0?oo
o`8000001`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo0P0000080?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0g03oool001X0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo0P0000080?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0g@3oool001X0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo0`0000080?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0g@3oool001X0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo0P0000080?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0gP3oool001X0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo0P0000080?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0gP3oool001X0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo0`0000080?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0g`3oool000/0oooo00L0oooD09/000000000001b0;[Zo`3oool0
j[Yb0080000000<0L[[Z0?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool01@3oool2000000P0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`3O0?ooo`002`3oool01`3DV`00VmCo0?ooo`3oom@0e=Co0?ooo`2jVkX00P3o
ool00`2jLY/0e?oo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`050?ooo`800000203oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo0>00oooo000:0?ooo`080?ooe02K0000L[[Z0?ooo`3Z^W80VmCo0?ooe02KL[X20?ooo`03
0=BKLP2jj_l0oooo00<0oooo0`0000050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool01@3oool2000000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3P0?ooo`00
2`3oool01`2jLY/0LW8000000000L[X0oooo0?ooe02KL[X00P3oool00`3DVg80^^[o0?ooo`030?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?oo
o`<000001`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0>40oooo000;0?ooo`03
0?oDV`00L[X0oooo00<0oooo00D0^W9b0;[Zo`3oom@0V`2K0=Coo`040?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`800000203oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo0>40oooo000<0?ooo`090>ZjLP000000000009_D
o`3oool0onZj078000000000VmCo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00D0oooo0P0000080?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0hP3oool001X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00D0oooo0P0000070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0hP3oool001X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00@0oooo0`0000070?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0h`3oool001X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00@0oooo0P0000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0h`3oool001X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00@0oooo0P0000070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
i03oool001X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00D0oooo0P0000070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0i03o
ool001X0oooo0P0000050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool2
000000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3T0?ooo`006P3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool30000
00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3U0?ooo`006P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool2000000L0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3U0?ooo`006P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool2000000L0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3U0?ooo`006P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool2000000H0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`3V0?ooo`006P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool3000000H0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`3V0?ooo`006P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool2000000L0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`3W0?ooo`006P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool2000000H0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`3W0?ooo`006P3oool2000000D0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`040?ooo`8000001P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo0>L0oooo000J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`030?ooo`<000001P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0>P0oooo000J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`030?ooo`8000001P3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0>P0oooo000J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`030?ooo`8000001P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0>P0oooo000J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`030?ooo`8000001P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0>P0
oooo000J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`8000001P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0>T0oooo
000J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`040?ooo`8000001@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0>T0oooo000J
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`04
0?ooo`8000001@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0>T0oooo000J0?oo
o`8000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo0P0000050?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0j@3oool001X0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo0P0000060?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0jP3oool001X0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo0P0000050?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0jP3oool001X0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo0P0000050?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0jP3oool001X0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0jP3oool001X0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0j`3oool001X0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0j`3oool000/0oooo00@0e9/0000000000000L[[Z0P3oool0103Z^W80
00000000001b^^X50?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0>/0oooo000:0?ooo`050?ooe02KVm@0oooo0?ooo`2jVkX00P3oool01@2jVkX0oooo0?ooo`2jLY/0
e?oo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo0P0000050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0j`3oool0
00/0oooo00L0^Y^j0?ooo`3oom@0Vi_D0?ooo`3oom@0Vg:j0080oooo00<0e9]b0;[Zo`3oool00`3o
ool3000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`8000001@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0>`0oooo000;0?ooo`070=BK00000000
000007:jjP3oool0oooD09]b^P020?ooo`030=BKLP2jj_l0oooo00<0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo0P0000050?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0k03oool000X0oooo00D0oooD09]b^P3oool0oooD
09]b^P020?ooo`050;YbLP2jj_l0oooD09/0V`3Dool0103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`3/0?ooo`002`3oool0103Z^W8000000000002Ke?l20?ooo`04
0?oZ^P1b0000000009_Do`D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00@0oooo0P0000050?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0k@3oool001X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0k@3oool001X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
k@3oool001X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0k@3o
ool001X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo0P0000050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0kP3oool0
01X0oooo0P0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool20000
00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3^0?ooo`006P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool2000000D0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3^0?ooo`006P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool2000000@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3^0?ooo`006P3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool2000000@0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`3_0?ooo`006P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool2000000@0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`3_0?ooo`006P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool2000000@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`3_0?ooo`006P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool2000000D0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`3_0?ooo`006P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool2000000D0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`3`0?ooo`006P3oool2000000<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`030?ooo`800000103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0?00oooo000J0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`030?ooo`800000103oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0?00oooo000J0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`030?ooo`800000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0?00oooo000J0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`030?ooo`800000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?00
oooo000J0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`030?ooo`800000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?40oooo
000J0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`020?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?40oooo000J
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`02
0?ooo`800000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?40oooo000J0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?oo
o`800000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?40oooo000J0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`80
0000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?40oooo000J0?ooo`800000
0`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo0P0000040?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0lP3oool001X0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo0P0000040?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0lP3oool001X0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo0P0000040?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0lP3oool001X0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo0P0000040?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0lP3oool001X0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo0P0000030?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0lP3oool001X0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00<0oooo0P0000030?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0l`3oool000@0oooo00P0oooD09/00000000000000000LP2jj_l0oooo0>Zj
LP80000000@0L[[Z0?ooo`3oool0j[Yb0P0000000`1b^^X0oooo0?ooo`030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`8000000`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo0?<0oooo00060?ooo`030?oDV`1b^^X0oooo
0080oooo00L0^Y^j0?ooo`3oool0^W:K0=Coo`3oool0^Y^j0080oooo00<0^W:K0=Coo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3o
ool2000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3c0?ooo`001P3oool0
1P3oe9/0L[[Z0?ooo`3oool0oooD09]b^P80oooo00@0e9]b0;[Zo`3oom@0Vg:j0P3oool00`3DVg80
^^[o0?ooo`030?ooo`<000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0
oooo0P0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0l`3oool000H0oooo
00H0omBK07:jjP3oool0oooo0?ooe02KL[X20?ooo`040=BKLP2jj_l0oooD09]b^P80oooo00<0e9]b
0;[Zo`3oool0o`3ooolD0?ooo`001@3oool00`2jLY/0e=BK07:jjP030?ooo`0;0;YbLP2jj_l0oooD
09/0V`3Dool0oooo0;YbLP2jj_l0oooD09/0V`3Dool0o`3ooolE0?ooo`001@3oool00`3oe9/00000
07:jjP030?ooo`040?oZ^P1b0000000009_Do`80oooo00@0onZj078000000000VmCoo`3ooolF0?oo
o`00o`3oool[0?ooo`00\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {426.375, 279.813}} -> {0.614701, \
202.84, 0.00194675, 0.601185}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["Clear[y,y1,yp]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["DSolve[{y[x]+x*Log[x]*y'[x]==0,y[E]==3},y[x],x]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[BoxData[
    \({{y[x] \[Rule] 3\/Log[x]}}\)], "Output"]
}, Open  ]],

Cell["\<\
Clear[y1,y,yp]
\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
4. Rie\[SHacek]te diferenci\[AAcute]lnu rovnicu y'e^y-1=0. 
    N\[AAcute]jdite partikul\[AAcute]rne rie\[SHacek]enie, ktor\[EAcute] sp\
\:013a\:0148a za\[CHacek]. podmienku 
    \t\t       y(-1)=0.
   Nakreslite integr\[AAcute]lnu krivku partikul\[AAcute]rneho \
rie\[SHacek]enia.
   Vypo\[CHacek]itajte hodnotu partikul\[AAcute]rneho rie\[SHacek]enia 
   pre y(0), y(-1.5).
------------------------------------------------------------------------------\
---
\
\>", "Section",
  PageBreakAbove->True,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Arial CE",
  FontColor->RGBColor[0, 0.500008, 0],
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["DSolve[y'[x]*Exp[y[x]]-1==0,y[x],x]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{y[x] \[Rule] Log[x + C[1]]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["y1[x_]=y[x]/.%[[1]]/.C[1]->c", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(Log[c + x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solve[y1[-1]==0,c]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{c \[Rule] 2}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["yp[x_]=y1[x]/.c->2", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(Log[2 + x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["gp=Plot[yp[x],{x,-1.9,5},PlotStyle->Thickness[0.01]]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.286059 0.138026 0.333724 0.138544 [
[.01001 .32122 -6 -9 ]
[.01001 .32122 6 0 ]
[.14803 .32122 -6 -9 ]
[.14803 .32122 6 0 ]
[.42409 .32122 -3 -9 ]
[.42409 .32122 3 0 ]
[.56211 .32122 -3 -9 ]
[.56211 .32122 3 0 ]
[.70014 .32122 -3 -9 ]
[.70014 .32122 3 0 ]
[.83816 .32122 -3 -9 ]
[.83816 .32122 3 0 ]
[.97619 .32122 -3 -9 ]
[.97619 .32122 3 0 ]
[.27356 .05664 -12 -4.5 ]
[.27356 .05664 0 4.5 ]
[.27356 .19518 -12 -4.5 ]
[.27356 .19518 0 4.5 ]
[.27356 .47227 -6 -4.5 ]
[.27356 .47227 0 4.5 ]
[.27356 .61081 -6 -4.5 ]
[.27356 .61081 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01001 .33372 m
.01001 .33997 L
s
[(-2)] .01001 .32122 0 1 Mshowa
.14803 .33372 m
.14803 .33997 L
s
[(-1)] .14803 .32122 0 1 Mshowa
.42409 .33372 m
.42409 .33997 L
s
[(1)] .42409 .32122 0 1 Mshowa
.56211 .33372 m
.56211 .33997 L
s
[(2)] .56211 .32122 0 1 Mshowa
.70014 .33372 m
.70014 .33997 L
s
[(3)] .70014 .32122 0 1 Mshowa
.83816 .33372 m
.83816 .33997 L
s
[(4)] .83816 .32122 0 1 Mshowa
.97619 .33372 m
.97619 .33997 L
s
[(5)] .97619 .32122 0 1 Mshowa
.125 Mabswid
.03761 .33372 m
.03761 .33747 L
s
.06522 .33372 m
.06522 .33747 L
s
.09282 .33372 m
.09282 .33747 L
s
.12043 .33372 m
.12043 .33747 L
s
.17564 .33372 m
.17564 .33747 L
s
.20324 .33372 m
.20324 .33747 L
s
.23085 .33372 m
.23085 .33747 L
s
.25845 .33372 m
.25845 .33747 L
s
.31366 .33372 m
.31366 .33747 L
s
.34127 .33372 m
.34127 .33747 L
s
.36888 .33372 m
.36888 .33747 L
s
.39648 .33372 m
.39648 .33747 L
s
.45169 .33372 m
.45169 .33747 L
s
.4793 .33372 m
.4793 .33747 L
s
.5069 .33372 m
.5069 .33747 L
s
.53451 .33372 m
.53451 .33747 L
s
.58972 .33372 m
.58972 .33747 L
s
.61732 .33372 m
.61732 .33747 L
s
.64493 .33372 m
.64493 .33747 L
s
.67253 .33372 m
.67253 .33747 L
s
.72774 .33372 m
.72774 .33747 L
s
.75535 .33372 m
.75535 .33747 L
s
.78295 .33372 m
.78295 .33747 L
s
.81056 .33372 m
.81056 .33747 L
s
.86577 .33372 m
.86577 .33747 L
s
.89337 .33372 m
.89337 .33747 L
s
.92098 .33372 m
.92098 .33747 L
s
.94859 .33372 m
.94859 .33747 L
s
.25 Mabswid
0 .33372 m
1 .33372 L
s
.28606 .05664 m
.29231 .05664 L
s
[(-2)] .27356 .05664 1 0 Mshowa
.28606 .19518 m
.29231 .19518 L
s
[(-1)] .27356 .19518 1 0 Mshowa
.28606 .47227 m
.29231 .47227 L
s
[(1)] .27356 .47227 1 0 Mshowa
.28606 .61081 m
.29231 .61081 L
s
[(2)] .27356 .61081 1 0 Mshowa
.125 Mabswid
.28606 .08434 m
.28981 .08434 L
s
.28606 .11205 m
.28981 .11205 L
s
.28606 .13976 m
.28981 .13976 L
s
.28606 .16747 m
.28981 .16747 L
s
.28606 .22289 m
.28981 .22289 L
s
.28606 .2506 m
.28981 .2506 L
s
.28606 .27831 m
.28981 .27831 L
s
.28606 .30602 m
.28981 .30602 L
s
.28606 .36143 m
.28981 .36143 L
s
.28606 .38914 m
.28981 .38914 L
s
.28606 .41685 m
.28981 .41685 L
s
.28606 .44456 m
.28981 .44456 L
s
.28606 .49998 m
.28981 .49998 L
s
.28606 .52769 m
.28981 .52769 L
s
.28606 .5554 m
.28981 .5554 L
s
.28606 .5831 m
.28981 .5831 L
s
.28606 .02893 m
.28981 .02893 L
s
.28606 .00122 m
.28981 .00122 L
s
.25 Mabswid
.28606 0 m
.28606 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.01 w
.02381 .01472 m
.02846 .05492 L
.03279 .08412 L
.04262 .13383 L
.0522 .16951 L
.06244 .19964 L
.08451 .24829 L
.10458 .28134 L
.14451 .33014 L
.18292 .36495 L
.22379 .39434 L
.26314 .41775 L
.30098 .43705 L
.34126 .45501 L
.38004 .47035 L
.42126 .48498 L
.46097 .49775 L
.49916 .50902 L
.53981 .52007 L
.57894 .52995 L
.62052 .53972 L
.66059 .54853 L
.69914 .5565 L
.74014 .56451 L
.77963 .57181 L
.8176 .57848 L
.85802 .58525 L
.89693 .59146 L
.93829 .59778 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oE`3oool2
00000=40oooo001G0?ooo`030000003oool0oooo0=00oooo001G0?ooo`030000003oool0oooo0=00
oooo001G0?ooo`030000003oool0oooo0=00oooo00090?ooo`800000C03oool00`000000oooo0?oo
o`3@0?ooo`002P3oool2000004/0oooo00<000000?ooo`3oool0d03oool000X0oooo0P00001;0?oo
o`030000003oool0oooo0=00oooo000:0?ooo`800000B`3oool00`000000oooo0?ooo`3@0?ooo`00
2P3oool2000004/0oooo0P00003A0?ooo`002P3oool2000004/0oooo00<000000?ooo`3oool0d03o
ool000X0oooo0P00001;0?ooo`030000003oool0oooo0=00oooo000;0?ooo`800000BP3oool00`00
0000oooo0?ooo`3@0?ooo`002`3oool2000004X0oooo00<000000?ooo`3oool0d03oool000/0oooo
0P00001:0?ooo`030000003oool0oooo0=00oooo000;0?ooo`800000BP3oool00`000000oooo0?oo
o`3@0?ooo`002`3oool200000400oooo00H0omBK00000000000000000000V`3Dool40?ooo`030000
003oool0oooo0=00oooo000;0?ooo`800000@@3oool00`2jLP00002K0=Coo`060?ooo`030000003o
ool0oooo0=00oooo000<0?ooo`800000@@3oool00`3oe9/0000009_Do`050?ooo`<00000d03oool0
00`0oooo0P00000i0?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3oool0oooo0?ooe03D
e?l50?ooo`030000003oool0oooo0=00oooo000<0?ooo`800000?`3oool01P3oj[X0LW:j0?ooo`3o
om@0V`2K0=Coo`@0oooo00<000000?ooo`3oool0d03oool000`0oooo0P0000100?ooo`040>ZjLP00
0000000007:jjPD0oooo00<000000?ooo`3oool0d03oool000`0oooo0P0000190?ooo`030000003o
ool0oooo0=00oooo000<0?ooo`800000B@3oool00`000000oooo0?ooo`3@0?ooo`00303oool20000
04T0oooo00<000000?ooo`3oool0d03oool000`0oooo0P0000190?ooo`030000003oool0oooo0=00
oooo000<0?ooo`800000B@3oool200000=40oooo000=0?ooo`800000B03oool00`000000oooo0?oo
o`3@0?ooo`003@3oool2000004P0oooo00<000000?ooo`3oool0d03oool000d0oooo0P0000180?oo
o`030000003oool0oooo0=00oooo000=0?ooo`800000B03oool00`000000oooo0?ooo`3@0?ooo`00
3P3oool2000004L0oooo00<000000?ooo`3oool0d03oool000h0oooo0P0000170?ooo`030000003o
ool0oooo0=00oooo000>0?ooo`800000A`3oool00`000000oooo0?ooo`3@0?ooo`003P3oool20000
04L0oooo0P00003A0?ooo`003P3oool2000004L0oooo00<000000?ooo`3oool0d03oool000l0oooo
0P0000160?ooo`030000003oool0oooo0=00oooo000?0?ooo`800000AP3oool00`000000oooo0?oo
o`3@0?ooo`003`3oool2000004H0oooo00<000000?ooo`3oool0d03oool000l0oooo0P0000160?oo
o`030000003oool0oooo0=00oooo000?0?ooo`<00000A@3oool00`000000oooo0?ooo`3@0?ooo`00
403oool2000004D0oooo00<000000?ooo`3oool0d03oool00100oooo0P0000150?ooo`800000d@3o
ool00100oooo0P0000150?ooo`030000003oool0oooo0=00oooo000@0?ooo`<00000A03oool00`00
0000oooo0?ooo`3@0?ooo`004@3oool2000004@0oooo00<000000?ooo`3oool0d03oool00140oooo
0P0000140?ooo`030000003oool0oooo0=00oooo000A0?ooo`<00000@`3oool00`000000oooo0?oo
o`3@0?ooo`004P3oool2000004<0oooo00<000000?ooo`3oool0d03oool00180oooo0P0000130?oo
o`030000003oool0oooo0=00oooo000B0?ooo`800000@`3oool200000=40oooo000B0?ooo`<00000
@P3oool00`000000oooo0?ooo`3@0?ooo`004`3oool200000480oooo00<000000?ooo`3oool0d03o
ool001<0oooo0P0000120?ooo`030000003oool0oooo0=00oooo000C0?ooo`<00000@@3oool00`00
0000oooo0?ooo`3@0?ooo`00503oool200000440oooo00<000000?ooo`3oool0d03oool001@0oooo
0P00000g0?ooo`060?ooe02K00000000000000000780^^[o103oool00`000000oooo0?ooo`3@0?oo
o`00503oool3000003P0oooo00<0omBK07:jjP3oool01@3oool00`000000oooo0?ooo`3@0?ooo`00
5@3oool2000003P0oooo00<0omBK07:jjP3oool01@3oool300000=00oooo000E0?ooo`800000<03o
ool00`3oe9/00000000000020000000509_Do`3oool0oooo0?oDV`1b^^X01P3oool00`000000oooo
0?ooo`3@0?ooo`005@3oool3000003H0oooo00<0^W:K0=CDV`1b^^X01P3oool00`000000oooo0?oo
o`3@0?ooo`005P3oool2000003H0oooo00<0omBK0000001b^^X01P3oool00`000000oooo0?ooo`3@
0?ooo`005P3oool3000003h0oooo00<000000?ooo`3oool0d03oool001L0oooo0P00000n0?ooo`03
0000003oool0oooo0=00oooo000G0?ooo`800000?P3oool00`000000oooo0?ooo`3@0?ooo`005`3o
ool3000003d0oooo00<000000?ooo`3oool0d03oool001P0oooo0P00000m0?ooo`800000d@3oool0
01P0oooo0`00000l0?ooo`030000003oool0oooo0=00oooo000I0?ooo`800000?03oool00`000000
oooo0?ooo`3@0?ooo`006@3oool3000003/0oooo00<000000?ooo`3oool0d03oool001X0oooo0P00
000k0?ooo`030000003oool0oooo0=00oooo000J0?ooo`800000>`3oool00`000000oooo0?ooo`3@
0?ooo`006P3oool3000003X0oooo00<000000?ooo`3oool0d03oool001/0oooo0P00000j0?ooo`03
0000003oool0oooo0=00oooo000L0?ooo`030000003oool0oooo03P0oooo0P00003A0?ooo`00703o
ool2000003T0oooo00<000000?ooo`3oool0d03oool001d0oooo0P00000h0?ooo`030000003oool0
oooo0=00oooo000N0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0d03oool001h0
oooo0P00000g0?ooo`030000003oool0oooo0=00oooo000O0?ooo`800000=P3oool00`000000oooo
0?ooo`3@0?ooo`00803oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0=00oooo000P
0?ooo`800000=@3oool00`000000oooo0?ooo`3@0?ooo`008@3oool2000003@0oooo00<000000?oo
o`3oool0d03oool00280oooo0P00000c0?ooo`800000d@3oool00280oooo0`00000b0?ooo`030000
003oool0oooo0=00oooo000S0?ooo`800000<P3oool00`000000oooo0?ooo`3@0?ooo`00903oool2
00000340oooo00<000000?ooo`3oool0d03oool000H0oooo00H0omBK00000000000000000000V`3D
oolH0?ooo`<00000203oool01P3oom@0V`00000000000000001b0;[Zob80oooo00<000000?ooo`3o
ool08`3oool01P3oom@0V`00000000000000001b0;[Zob80oooo00H0omBK00000000000000000000
V`3DoolS0?ooo`040>ZjLP0000000000002Ke2H0oooo00@0j[Yb000000000780^^[o8`3oool0103Z
^W8000000000001b^^X70?ooo`001`3oool00`2jLP00002K0=Coo`0K0?ooo`<000002@3oool00`3o
e9/0L[[Z0?ooo`0S0?ooo`030000003oool0oooo02D0oooo00<0omBK07:jjP3oool0903oool00`2j
LP00002K0=Coo`0T0?ooo`060?oZ^P1bL[X0oooo0?ooe02K0780^^[o9P3oool00`3oe9/0L[[Z0?oo
o`0R0?ooo`060?oZ^P1bL[X0oooo0?ooo`2jLW80^^[o1P3oool000P0oooo00<0omBK0000002Ke?l0
6`3oool3000000P0oooo00<0omBK07:jjP3oool08`3oool00`000000oooo0?ooo`0U0?ooo`030?oD
V`1b^^X0oooo02D0oooo00<0omBK0000002Ke?l09@3oool00`3DV`00000009_Do`0T0?ooo`060?oo
e02K00000000000000000780^^[o9P3oool00`3DVg80^^[o0?ooo`050?ooo`0000<0omBK00000000
00000P0000001P2Ke?l0oooo0?ooo`3oool0oooD0=CDoa`0oooo0P0000000`3oe9/0000000000002
0000000509_Do`3oool0oooo0?oDV`1b^^X0903oool00`000000oooo0?ooo`0U0?ooo`030?oDV`1b
^^X0oooo02H0oooo00<0oooD0=CDo`3oool09@3oool00`3oom@0Vg:j0?ooo`0T0?ooo`040=BK002K
e?l0omBK07:jjR@0oooo00@0e9/000000000000009_D1`3oool000H0oooo00H0onZj079b^P3oool0
oooD09/0V`3DoolL0?ooo`8000001P3oool00`2jLY/0e=BK07:jjP0T0?ooo`8000009@3oool00`2j
LY/0e=BK07:jjP0T0?ooo`060?oZ^P1bL[X0oooo0?ooe02K09/0e?oo8P3oool01P3oom@0V`1b0;[Z
o`3oom@0V`2K0=Coob@0oooo00@0oooD09/0LP2j^Y/0L[[Z903oool00`3DVg80^^[o0?ooo`080?oo
o`001`3oool0103Z^W8000000000001b^^XM0?ooo`<000001@3oool00`3oe9/0000007:jjP0T0?oo
o`030000003oool0oooo02@0oooo00<0omBK0000001b^^X09@3oool0103Z^W8000000000001b^^XT
0?ooo`040?oZ^P1b0000000009_DobH0oooo00<0onZj0780001b^^X0903oool0103DV`0000000000
0000Vm@70?ooo`00:@3oool3000002/0oooo00<000000?ooo`3oool0d03oool002X0oooo0`00000Z
0?ooo`030000003oool0oooo0=00oooo000[0?ooo`800000:P3oool00`000000oooo0?ooo`3@0?oo
o`00;03oool2000002T0oooo00<000000?ooo`3oool0d03oool002`0oooo0`00000X0?ooo`030000
003oool0oooo0=00oooo000]0?ooo`<000009`3oool00`000000oooo0?ooo`3@0?ooo`000`3ooooo
000002L000000@3oool000H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?oo
o`<000001@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01P3oool000H0oooo00<000000?ooo`3oool09P3oool4000002@0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00H0oooo000a0?ooo`<00000
8`3oool00`000000oooo0?ooo`3@0?ooo`00<P3oool400000240oooo00<000000?ooo`3oool0d03o
ool003<0oooo1000000P0?ooo`030000003oool0oooo0=00oooo000e0?ooo`<000007`3oool00`00
0000oooo0?ooo`3@0?ooo`00=P3oool3000001h0oooo00<000000?ooo`3oool0d03oool003L0oooo
0`00000M0?ooo`800000d@3oool003P0oooo0`00000L0?ooo`030000003oool0oooo0=00oooo000i
0?ooo`@000006P3oool00`000000oooo0?ooo`3@0?ooo`00>P3oool4000001T0oooo00<000000?oo
o`3oool0d03oool003`0oooo0`00000H0?ooo`030000003oool0oooo0=00oooo000m0?ooo`@00000
5P3oool00`000000oooo0?ooo`3@0?ooo`00?P3oool4000001D0oooo00<000000?ooo`3oool0d03o
ool00400oooo0`00000D0?ooo`030000003oool0oooo0=00oooo00110?ooo`@000004P3oool20000
0=40oooo00120?ooo`@000004@3oool00`000000oooo0?ooo`3@0?ooo`00A03oool4000000l0oooo
00<000000?ooo`3oool0d03oool004D0oooo1@00000=0?ooo`030000003oool0oooo0=00oooo0017
0?ooo`@00000303oool00`000000oooo0?ooo`3@0?ooo`00B@3oool4000000X0oooo00<000000?oo
o`3oool0d03oool004X0oooo1@0000080?ooo`030000003oool0oooo0=00oooo001<0?ooo`D00000
1P3oool00`000000oooo0?ooo`3@0?ooo`00CP3oool5000000@0oooo0P00003A0?ooo`00D03oool5
00000080oooo00<000000?ooo`3oool0d03oool00580oooo1P00003B0?ooo`00E03oool500000=40
oooo001F0?ooo`D00000c`3oool005L0oooo1P00003=0?ooo`00E`3oool00`000000oooo0?ooo`05
00000</0oooo001G0?ooo`030000003oool0oooo0080oooo1@0000390?ooo`00E`3oool2000000D0
oooo1P0000360?ooo`00E`3oool00`000000oooo0?ooo`060?ooo`H00000a03oool005L0oooo00<0
00000?ooo`3oool02@3oool500000<80oooo001G0?ooo`030000003oool0oooo00/0oooo1@000030
0?ooo`00E`3oool00`000000oooo0?ooo`0=0?ooo`H00000_@3oool005L0oooo00<000000?ooo`3o
ool03`3oool600000;/0oooo001=0?ooo`060?ooe02K00000000000000000780^^[o103oool00`00
0000oooo0?ooo`0B0?ooo`H00000^03oool004l0oooo00<0omBK07:jjP3oool01@3oool00`000000
oooo0?ooo`0D0?ooo`H00000]P3oool004l0oooo00<0omBK07:jjP3oool01@3oool3000001L0oooo
1P00002c0?ooo`00C`3oool00`3oe9/0L[[Z0?ooo`050?ooo`030000003oool0oooo01T0oooo1`00
002`0?ooo`00CP3oool00`2jLY/0e=BK07:jjP060?ooo`030000003oool0oooo01`0oooo1`00002]
0?ooo`00CP3oool00`3oe9/0000007:jjP060?ooo`030000003oool0oooo01l0oooo1`00002Z0?oo
o`00E`3oool00`000000oooo0?ooo`0R0?ooo`L00000Y`3oool005L0oooo00<000000?ooo`3oool0
9@3oool600000:D0oooo001G0?ooo`030000003oool0oooo02P0oooo1P00002R0?ooo`00E`3oool0
0`000000oooo0?ooo`0Z0?ooo`L00000W`3oool005L0oooo00<000000?ooo`3oool0;@3oool70000
09`0oooo001G0?ooo`800000<@3oool8000009P0oooo001G0?ooo`030000003oool0oooo03@0oooo
2000002D0?ooo`00E`3oool00`000000oooo0?ooo`0h0?ooo`P00000T03oool005L0oooo00<00000
0?ooo`3oool0?03oool8000008`0oooo001G0?ooo`030000003oool0oooo0400oooo200000280?oo
o`00E`3oool00`000000oooo0?ooo`140?ooo`P00000Q03oool005L0oooo00<000000?ooo`3oool0
B03oool800000800oooo001G0?ooo`030000003oool0oooo04`0oooo1`00001m0?ooo`00E`3oool2
00000540oooo1`00001i0?ooo`00E`3oool00`000000oooo0?ooo`1C0?ooo`P00000M@3oool005L0
oooo00<000000?ooo`3oool0E`3oool800000740oooo001G0?ooo`030000003oool0oooo05/0oooo
2000001]0?ooo`00E`3oool00`000000oooo0?ooo`1O0?ooo`P00000J@3oool005L0oooo00<00000
0?ooo`3oool0H`3oool8000006D0oooo001G0?ooo`030000003oool0oooo06L0oooo2P00001O0?oo
o`00E`3oool00`000000oooo0?ooo`1[0?ooo`/00000FP3oool005L0oooo0P00001b0?ooo`/00000
E03oool005L0oooo00<000000?ooo`3oool0MP3oool<000004h0oooo001G0?ooo`030000003oool0
oooo07`0oooo2P00001:0?ooo`00E`3oool00`000000oooo0?ooo`220?ooo`P00000AP3oool005L0
oooo00<000000?ooo`3oool0QP3oool800000480oooo001G0?ooo`030000003oool0oooo08X0oooo
2P00000l0?ooo`00E`3oool00`000000oooo0?ooo`2>0?ooo`/00000=`3oool005L0oooo00<00000
0?ooo`3oool0U03oool;00000340oooo001G0?ooo`800000VP3oool<000002/0oooo001G0?ooo`03
0000003oool0oooo09l0oooo4@00000P0?ooo`00E`3oool00`000000oooo0?ooo`2U0?oooa400000
6P3oool005L0oooo00<000000?ooo`3oool0/03oool<000001@0oooo001G0?ooo`030000003oool0
oooo0;H0oooo3000000>0?ooo`00E`3oool00`000000oooo0?ooo`2l0?ooo`/000002@3oool004d0
oooo00H0omBK00000000000000000000V`3Dool40?ooo`030000003oool0oooo0<80oooo1P000008
0?ooo`00CP3oool00`2jLP00002K0=Coo`060?ooo`030000003oool0oooo0<L0oooo00<000000?oo
o`3oool01P3oool004l0oooo00<0omBK0000002Ke?l01@3oool300000=00oooo001@0?ooo`030?oo
e03De?l0oooo00@0oooo00<000000?ooo`3oool0d03oool004d0oooo00H0onZj079b^P3oool0oooD
09/0V`3Dool40?ooo`030000003oool0oooo0=00oooo001>0?ooo`040>ZjLP000000000007:jj]P0
oooo003o0?ooob/0oooo0000\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {578.938, 432.375}} -> {-6.41631, \
10.9252, 0.0247638, 0.0246712}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["t=Table[y1[x],{c,0.5,2.5,0.5}]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({Log[\(\(0.5`\)\(\[InvisibleSpace]\)\) + x], 
      Log[\(\(1.`\)\(\[InvisibleSpace]\)\) + x], 
      Log[\(\(1.5`\)\(\[InvisibleSpace]\)\) + x], 
      Log[\(\(2.`\)\(\[InvisibleSpace]\)\) + x], 
      Log[\(\(2.5`\)\(\[InvisibleSpace]\)\) + x]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["gvs=Plot[Evaluate[t],{x,-2,5}]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.295918 0.136054 0.495292 0.053614 [
[.02381 .48279 -6 -9 ]
[.02381 .48279 6 0 ]
[.15986 .48279 -6 -9 ]
[.15986 .48279 6 0 ]
[.43197 .48279 -3 -9 ]
[.43197 .48279 3 0 ]
[.56803 .48279 -3 -9 ]
[.56803 .48279 3 0 ]
[.70408 .48279 -3 -9 ]
[.70408 .48279 3 0 ]
[.84014 .48279 -3 -9 ]
[.84014 .48279 3 0 ]
[.97619 .48279 -3 -9 ]
[.97619 .48279 3 0 ]
[.28342 .06638 -12 -4.5 ]
[.28342 .06638 0 4.5 ]
[.28342 .17361 -12 -4.5 ]
[.28342 .17361 0 4.5 ]
[.28342 .28084 -12 -4.5 ]
[.28342 .28084 0 4.5 ]
[.28342 .38806 -12 -4.5 ]
[.28342 .38806 0 4.5 ]
[.28342 .60252 -6 -4.5 ]
[.28342 .60252 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .49529 m
.02381 .50154 L
s
[(-2)] .02381 .48279 0 1 Mshowa
.15986 .49529 m
.15986 .50154 L
s
[(-1)] .15986 .48279 0 1 Mshowa
.43197 .49529 m
.43197 .50154 L
s
[(1)] .43197 .48279 0 1 Mshowa
.56803 .49529 m
.56803 .50154 L
s
[(2)] .56803 .48279 0 1 Mshowa
.70408 .49529 m
.70408 .50154 L
s
[(3)] .70408 .48279 0 1 Mshowa
.84014 .49529 m
.84014 .50154 L
s
[(4)] .84014 .48279 0 1 Mshowa
.97619 .49529 m
.97619 .50154 L
s
[(5)] .97619 .48279 0 1 Mshowa
.125 Mabswid
.05102 .49529 m
.05102 .49904 L
s
.07823 .49529 m
.07823 .49904 L
s
.10544 .49529 m
.10544 .49904 L
s
.13265 .49529 m
.13265 .49904 L
s
.18707 .49529 m
.18707 .49904 L
s
.21429 .49529 m
.21429 .49904 L
s
.2415 .49529 m
.2415 .49904 L
s
.26871 .49529 m
.26871 .49904 L
s
.32313 .49529 m
.32313 .49904 L
s
.35034 .49529 m
.35034 .49904 L
s
.37755 .49529 m
.37755 .49904 L
s
.40476 .49529 m
.40476 .49904 L
s
.45918 .49529 m
.45918 .49904 L
s
.48639 .49529 m
.48639 .49904 L
s
.51361 .49529 m
.51361 .49904 L
s
.54082 .49529 m
.54082 .49904 L
s
.59524 .49529 m
.59524 .49904 L
s
.62245 .49529 m
.62245 .49904 L
s
.64966 .49529 m
.64966 .49904 L
s
.67687 .49529 m
.67687 .49904 L
s
.73129 .49529 m
.73129 .49904 L
s
.7585 .49529 m
.7585 .49904 L
s
.78571 .49529 m
.78571 .49904 L
s
.81293 .49529 m
.81293 .49904 L
s
.86735 .49529 m
.86735 .49904 L
s
.89456 .49529 m
.89456 .49904 L
s
.92177 .49529 m
.92177 .49904 L
s
.94898 .49529 m
.94898 .49904 L
s
.25 Mabswid
0 .49529 m
1 .49529 L
s
.29592 .06638 m
.30217 .06638 L
s
[(-8)] .28342 .06638 1 0 Mshowa
.29592 .17361 m
.30217 .17361 L
s
[(-6)] .28342 .17361 1 0 Mshowa
.29592 .28084 m
.30217 .28084 L
s
[(-4)] .28342 .28084 1 0 Mshowa
.29592 .38806 m
.30217 .38806 L
s
[(-2)] .28342 .38806 1 0 Mshowa
.29592 .60252 m
.30217 .60252 L
s
[(2)] .28342 .60252 1 0 Mshowa
.125 Mabswid
.29592 .09319 m
.29967 .09319 L
s
.29592 .11999 m
.29967 .11999 L
s
.29592 .1468 m
.29967 .1468 L
s
.29592 .20042 m
.29967 .20042 L
s
.29592 .22722 m
.29967 .22722 L
s
.29592 .25403 m
.29967 .25403 L
s
.29592 .30764 m
.29967 .30764 L
s
.29592 .33445 m
.29967 .33445 L
s
.29592 .36126 m
.29967 .36126 L
s
.29592 .41487 m
.29967 .41487 L
s
.29592 .44168 m
.29967 .44168 L
s
.29592 .46848 m
.29967 .46848 L
s
.29592 .5221 m
.29967 .5221 L
s
.29592 .54891 m
.29967 .54891 L
s
.29592 .57571 m
.29967 .57571 L
s
.29592 .03957 m
.29967 .03957 L
s
.29592 .01277 m
.29967 .01277 L
s
.25 Mabswid
.29592 0 m
.29592 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.22878 .22558 m
.22995 .27071 L
.23118 .29571 L
.23233 .31177 L
.23367 .32597 L
.23495 .33668 L
.23735 .35238 L
.23994 .36533 L
.24276 .37661 L
.24752 .39149 L
.25259 .4038 L
.26171 .42066 L
.2729 .43599 L
.28345 .44727 L
.30316 .46355 L
.32323 .47623 L
.34171 .48572 L
.38119 .50169 L
.41917 .51356 L
.45959 .52384 L
.4985 .53216 L
.53986 .53978 L
.5797 .54623 L
.61803 .55177 L
.65882 .5571 L
.69808 .56178 L
.73583 .56592 L
.77604 .57 L
.81472 .57366 L
.85586 .57729 L
.89549 .58057 L
.9336 .58355 L
.97416 .58654 L
.97619 .58669 L
s
.16006 .14427 m
.16032 .19018 L
.16147 .25719 L
.16254 .28464 L
.16375 .30468 L
.16508 .3204 L
.16749 .34079 L
.16984 .35518 L
.17201 .36578 L
.17695 .38405 L
.18221 .39844 L
.19315 .4198 L
.20345 .43427 L
.22272 .45389 L
.24279 .46875 L
.26127 .47953 L
.30075 .49716 L
.33873 .50996 L
.37915 .52088 L
.41806 .52964 L
.45942 .53761 L
.49927 .5443 L
.5376 .55004 L
.57838 .55554 L
.61764 .56034 L
.65539 .56459 L
.6956 .56877 L
.73429 .57251 L
.77543 .57622 L
.81505 .57957 L
.85316 .5826 L
.89372 .58565 L
.93276 .58842 L
.97426 .59123 L
.97619 .59136 L
s
.092 0 m
.09259 .21687 L
.0933 .25236 L
.09396 .27217 L
.09522 .29729 L
.09641 .3134 L
.09771 .32683 L
.09911 .33829 L
.10197 .35603 L
.10458 .36833 L
.10961 .38617 L
.11428 .39867 L
.12487 .41939 L
.1342 .43274 L
.14415 .44405 L
.16556 .46244 L
.18573 .47541 L
.22428 .49385 L
.26529 .50831 L
.30478 .51931 L
.34275 .52811 L
.38317 .53611 L
.42208 .54284 L
.46344 .54916 L
.50329 .55462 L
.54162 .5594 L
.5824 .56405 L
.62166 .56818 L
.65942 .57187 L
.69962 .57554 L
.73831 .57885 L
.77945 .58216 L
.81907 .58516 L
.85718 .5879 L
.89774 .59067 L
.93678 .5932 L
.97619 .59565 L
s
.02447 0 m
.02499 .24056 L
.02605 .27525 L
.02729 .29874 L
.02846 .31425 L
.03053 .33405 L
.03279 .34954 L
.03527 .36263 L
.0379 .37371 L
.04262 .3892 L
.05205 .411 L
.05742 .42032 L
.06244 .4278 L
.08274 .45044 L
.09415 .45992 L
.10458 .46734 L
.14429 .48877 L
.18248 .50354 L
.22313 .51576 L
.26226 .52537 L
.30384 .53399 L
.34391 .54116 L
.38246 .54726 L
.42346 .55306 L
.46295 .55811 L
.50092 .56256 L
.54134 .56692 L
.58025 .57081 L
.62161 .57465 L
.66146 .57811 L
.69979 .58124 L
.74057 .58438 L
.77984 .58724 L
.81759 .58985 L
.85779 .5925 L
.89648 .59493 L
.93762 .5974 L
.97619 .59962 L
s
.02381 .45813 m
.04262 .47122 L
.06244 .48224 L
.10458 .50009 L
.14264 .5123 L
.18314 .52282 L
.22214 .53131 L
.26358 .53906 L
.30351 .5456 L
.34193 .55122 L
.38279 .55661 L
.42214 .56134 L
.45998 .56552 L
.50027 .56964 L
.53904 .57333 L
.58026 .57699 L
.61997 .5803 L
.65817 .5833 L
.69881 .58631 L
.73794 .58906 L
.77952 .59184 L
.81959 .59439 L
.85814 .59673 L
.89914 .59911 L
.93863 .60131 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003o1`3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0c`3oool0
00L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0>P3oool00`000000
oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0j0?ooo`800000d03oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0c`3oool0
00L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0>P3oool200000=00
oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0a0?ooo`040=BK00000000000007:jjPD0oooo00<000000?ooo`3o
ool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0`0?ooo`050?oo
e02KVm@0oooo0?ooo`2jVkX01@3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo0340oooo00@0^Y^j0?ooo`3oom@0Vi_D1@3oool300000<l0
oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0:P3oool00`3oe9/00000
000000020000000309_Do`3oool0e9/00080000000<0L[[Z0?ooo`3oool00`3oool00`000000oooo
0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0300oooo00D0
oooD09]b^P3oool0oooD09]b^P050?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0<@3oool0103Z^W8000000000002Ke?l50?ooo`030000
003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo03X0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0j0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo03X0oooo0P00003@0?ooo`001`3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0<l0oooo00070?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`3?0?oo
o`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo03X0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0j0?ooo`800000d03oool000L0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0j0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0<l0oooo00070?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`3?0?oo
o`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02H0oooo0P00003@0?ooo`001`3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool07@3oool01@3oom@0V`00000000000780^^[o00@0oooo00<000000?ooo`3oool0c`3o
ool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo01d0oooo00D0e9/009_Do`3oool0oooD0=CDo`040?ooo`030000003oool0oooo0<l0oooo0007
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0L
0?ooo`060?ooe02K0000L[[Z0?ooo`3Z^W80VmCo103oool300000<l0oooo00070?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0F0?ooo`030?oDV`00
000000000080000000H0VmCo0?ooo`2jLY/0LW8000000000L[X50?ooo`030000003oool0oooo0<l0
oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0M0?ooo`030?oDV`00L[X0oooo00H0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01h0oooo00@0
j[Yb000000000000VmCo103oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`3?0?oo
o`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool09P3oool200000=00oooo00070?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo0<l0oooo
00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo0P00003@
0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0<l0oooo00070?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0<l0oooo00070?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0c`3oool0
00L0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo
0P00003@0?ooo`001`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0<l0oooo0008
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0c`3oool000P0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`3?0?ooo`00203oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0<l0oooo00080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
c`3oool000P0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool02@3oool0103Z^W8000000000LP2jj_l40?ooo`030000
003oool0oooo0<l0oooo00080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00X0oooo00<0omBK07:jjP3oool0103o
ool00`000000oooo0?ooo`3?0?ooo`00203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`070?ooo`060?ooe02K0000
0000000000000780^^[o103oool300000<l0oooo00080?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`050000003oool0oooo0?ooo`3oe9/0
100000001P2Ke?l0oooo0=BK002Ke?l0omBK07:jjPD0oooo00<000000?ooo`3oool0c`3oool000P0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool0203oool0103oom@0V`1b0;ZjV`1b^^X50?ooo`030000003oool0oooo
0<l0oooo00080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo00T0oooo00<0onZj0780001b^^X01@3oool00`000000
oooo0?ooo`3?0?ooo`00203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0<l0oooo
00080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0c`3oool000P0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`3?0?ooo`00203oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo0<l0oooo00080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0100oooo0P00003@0?ooo`00
203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0<l0oooo00080?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0c`3oool000P0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`3?0?ooo`00203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
0<l0oooo00080?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0c`3oool000T0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`3?0?ooo`002@3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0<l0oooo00090?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00l0oooo0P00003@
0?ooo`002@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0<l0oooo00090?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0c`3oool000X0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`3?0?ooo`002P3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo0<l0oooo000:0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0c`3oool0
00X0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`3?0?ooo`002P3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo0<l0oooo000:0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00h0oooo
0P00003@0?ooo`002P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0<l0oooo000:
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0c`3oool000/0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`3?0?ooo`002`3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo0<l0oooo000;0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
c`3oool000`0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool00`3oool01P3oe9/00000000000000000002K0=Coo`@0
oooo00<000000?ooo`3oool0c`3oool000`0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0103oool00`2jLP00002K
0=Coo`060?ooo`030000003oool0oooo0<l0oooo000=0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00@0oooo00<0
omBK0000002Ke?l01@3oool300000<l0oooo000=0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030?oDV`00000000000080000000H0VmCo
0?ooo`3oool0oooo0?ooe03De?l50?ooo`030000003oool0oooo0<l0oooo000=0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0080oooo00H0onZj079b^P3oool0oooD09/0V`3Dool40?ooo`030000003oool0oooo0<l0
oooo000>0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo0080oooo00@0j[Yb000000000000L[[Z1@3oool00`000000
oooo0?ooo`3?0?ooo`003P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0<l0oooo
000>0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0c`3oool000l0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`3?0?ooo`003`3oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo0<l0oooo000@0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00P0oooo0P00003@0?ooo`00
403oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0<l0oooo000A0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0c`3oool00140oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`3?0?ooo`004P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
0<l0oooo000C0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0c`3oool001@0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3?0?ooo`005@3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo0<l0oooo000E0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00<0oooo0P00003@
0?ooo`005P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0<l0oooo000G0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`05
0000003oool0oooo0?ooo`000000d@3oool001P0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00@000000?ooo`3oool00000d@3oool000L0
oooo00H0omBK00000000000000000000V`3Dool<0?ooo`030000003oool0oooo0180oooo0P000000
1@2K00000000000000000780^^[o00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0000
000T0?ooo`060?ooe02K00000000000000000780^^[o8`3oool01P3oe9/00000000000000000002K
0=Coob<0oooo00@0j[Yb00000000000009_D9@3oool0103Z^W8000000000LP2jj_lT0?ooo`040>Zj
LP000000000007:jjPH0oooo00070?ooo`040000002jLP00002K0=Coo`l0oooo0P00000D0?ooo`03
0000003oe9/0L[[Z0100oooo0P00000B0?ooo`8000009P3oool00`3oe9/0L[[Z0?ooo`0U0?ooo`03
0;Yb000009/0e?oo02@0oooo00H0onZj079b^P3oool0oooD09/0LP2jj_lU0?ooo`030?oDV`1b^^X0
oooo02<0oooo00H0onZj079b^P3oool0oooo0;YbLP2jj_l50?ooo`00203oool30000000309_Do`3o
ool0oooo00h0oooo00<000000?ooo`3oool04P3oool00`000000L[[Z0?ooo`0A0?ooo`030000003o
ool0oooo0100oooo0P00000U0?ooo`030?oDV`1b^^X0oooo02H0oooo00<0omBK0000002Ke?l09@3o
ool00`3DV`00000009_Do`0S0?ooo`060?ooe02K00000000000000000780^^[o9`3oool00`3DVg80
^^[o0?ooo`040?ooo`0000<0oooo0?oDV`0000000`0000001P2Ke?l0oooo0?ooo`3oool000000=CD
oa40oooo0P00000:0?ooo`030?oDV`00000000000080000000@0VmCo0?ooo`3oool0omBK0P00000B
0?ooo`800000403oool00`000000oooo0000000T0?ooo`030?oDV`1b^^X0oooo02L0oooo00<0oooD
0=CDo`3oool09@3oool00`3oom@0Vg:j0?ooo`0S0?ooo`040=BK002Ke?l0omBK07:jjRD0oooo00@0
e9/000000000000009_D1P3oool000L0oooo00@0onZj079b^P3oool0oooD0P00000B0?ooo`030000
003oool0oooo00h0oooo00D0^W:K0=CDV`1b^^X0oooo0000000C0?ooo`030000003oool0oooo00d0
oooo0P0000000`3oool000000000000Q0?ooo`030;YbV`3De9/0L[[Z02D0oooo00H0onZj079b^P3o
ool0oooD09/0V`3DoolR0?ooo`060?ooe02K0780^^[o0?ooe02K09/0e?oo8`3oool0103oom@0V`1b
0;ZjV`1b^^XU0?ooo`030=BKLP2jj_l0oooo00L0oooo00080?ooo`060>ZjLP000000000007:jjP3o
ool000004P3oool2000000h0oooo00<0omBK0000001b^^X00P3oool200000180oooo0P00000=0?oo
o`030000003oool0oooo0080oooo0P00000O0?ooo`030?oDV`000000L[[Z02H0oooo00@0j[Yb0000
00000000L[[Z903oool0103oj[X0LP000000002Ke?lU0?ooo`030?oZ^P1b0000L[[Z02D0oooo00@0
e9/000000000000009_D1P3oool000h0oooo0P00000B0?ooo`8000004`3oool00`000000oooo0?oo
o`0A0?ooo`8000002`3oool00`000000oooo0?ooo`040?ooo`800000b@3oool00100oooo0P00000B
0?ooo`8000004P3oool2000001<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`06
0?ooo`800000a`3oool00180oooo0P00000B0?ooo`8000004P3oool200000180oooo0P0000080?oo
o`030000003oool0oooo00P0oooo0P0000350?ooo`00503oool200000180oooo0P00000B0?ooo`80
00004P3oool2000000H0oooo00<000000?ooo`3oool02P3oool200000<<0oooo000F0?ooo`<00000
4@3oool300000140oooo0P00000B0?ooo`800000103oool00`000000oooo0?ooo`0<0?ooo`800000
`@3oool001T0oooo0`00000A0?ooo`8000004@3oool200000180oooo0P0000020?ooo`030000003o
ool0oooo00h0oooo0P00002o0?ooo`00o`00000[000000001`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool3000000H0oooo00<000000?oo
o`3oool01@3oool010000000oooo0000000000040?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool00P3oool3000000030?ooo`000000oooo00H0oooo00<000000?ooo`3oool01@3oool3
000000D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`<000001`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`050?ooo`001`3oool00`000000oooo0?ooo`0G0?ooo`<000002`3oool01000
0000oooo0?ooo`3oool200000180oooo1000000=0?ooo`030000003oool0oooo00@000004@3oool3
000000d0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`050?ooo`00903oool20000
00l0oooo0`00000C0?ooo`<000002P3oool00`000000oooo0?ooo`040?ooo`@00000403oool40000
0;<0oooo000V0?ooo`<000003`3oool400000180oooo0`0000070?ooo`030000003oool0oooo00P0
oooo0`00000A0?ooo`@00000[`3oool002T0oooo0`00000@0?ooo`@000004@3oool4000000<0oooo
00<000000?ooo`3oool02`3oool300000180oooo0`00002/0?ooo`00;03oool400000100oooo1000
000A0?ooo`@00000403oool300000180oooo0`00002Y0?ooo`00<03oool400000100oooo1000000@
0?ooo`@00000403oool300000180oooo0`00002V0?ooo`00=03oool400000100oooo1000000<0?oo
o`8000000P3oool4000000l0oooo1000000A0?ooo`<00000X`3oool003P0oooo1000000@0?ooo`@0
0000203oool00`000000oooo0?ooo`050?ooo`@000003`3oool6000000h0oooo1000002O0?ooo`00
?03oool400000100oooo100000040?ooo`030000003oool0oooo00T0oooo1@00000@0?ooo`D00000
3@3oool6000009T0oooo00100?ooo`D000003`3oool500000100oooo1P00000?0?ooo`@000003`3o
ool6000009<0oooo00150?ooo`H000003@3oool500000180oooo1P00000=0?ooo`@000004@3oool6
000008d0oooo001;0?ooo`H000001`3oool00`000000oooo0?ooo`020?ooo`H000004P3oool60000
00/0oooo1@00000B0?ooo`H00000Q`3oool00540oooo1P0000000`3oool000000?ooo`090?ooo`T0
00003`3oool5000000/0oooo1P00000B0?ooo`H00000P@3oool005L0oooo1P00000?0?ooo`T00000
2`3oool6000000/0oooo2@00000?0?ooo`H00000N`3oool005P0oooo0P0000030?ooo`H000004P3o
ool6000000/0oooo1P00000>0?ooo`T00000303oool6000007D0oooo001H0?ooo`030000003oool0
oooo00P0oooo2@00000?0?ooo`H000002`3oool600000140oooo1P00000<0?ooo`P00000K@3oool0
05P0oooo00<000000?ooo`3oool04@3oool9000000`0oooo1P00000;0?ooo`T000003P3oool90000
00/0oooo2@00001T0?ooo`00F03oool00`000000oooo0?ooo`0J0?ooo`H00000303oool8000000`0
oooo3000000;0?ooo`P00000303oool6000005h0oooo001H0?ooo`030000003oool0oooo0200oooo
2000000<0?ooo``00000303oool9000000X0oooo1P00000<0?ooo`T00000E@3oool005P0oooo00<0
00000?ooo`3oool0:03oool;000000d0oooo300000090?ooo`H000002P3oool8000000d0oooo2`00
001:0?ooo`00F03oool00`000000oooo0?ooo`0c0?ooo``000003@3oool8000000L0oooo2000000:
0?ooo``00000303oool<000003h0oooo001H0?ooo`030000003oool0oooo03l0oooo300000090?oo
o`H000002@3oool<000000X0oooo3000000<0?ooo``00000<P3oool005P0oooo0P00001<0?ooo``0
00000`3oool9000000`0oooo3000000:0?ooo``00000303oool<000002H0oooo001H0?ooo`030000
003oool0oooo05L0oooo6000000<0?ooo`/000002`3oool<000000`0oooo3000000J0?ooo`00F03o
ool00`000000oooo0?ooo`1S0?ooo`/0000000<0oooo0000000000002P00000;0?ooo``000002`3o
ool;000000d0oooo2`00000?0?ooo`00F03oool00`000000oooo0?ooo`1^0?ooo``0000000<0oooo
0000000000008@00000:0?ooo``00000303oool8000000L0oooo001H0?ooo`030000003oool0oooo
07X0oooo3000000<0?ooobh000003`3oool005P0oooo00<000000?ooo`3oool0QP3ooolT000000/0
oooo4`0000070?ooo`00CP3oool01P3oe9/00000000000000000002K0=Coo`@0oooo00<000000?oo
o`3oool0WP3ooolZ000000L0oooo001?0?ooo`030;Yb000009/0e?oo00H0oooo00<000000?ooo`3o
ool0ZP3oool<000000/0oooo1`0000070?ooo`00D03oool00`3oe9/0000009_Do`050?ooo`<00000
]P3ooolB000000L0oooo001A0?ooo`030?ooe03De?l0oooo00@0oooo00<000000?ooo`3oool0c`3o
ool004h0oooo00H0onZj079b^P3oool0oooD09/0V`3Dool40?ooo`030000003oool0oooo0<l0oooo
001?0?ooo`040>ZjLP000000000007:jjPD0oooo00<000000?ooo`3oool0c`3oool005P0oooo00<0
00000?ooo`3oool0c`3oool00001\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {228.438, 81.875}} -> {-6.43837, \
-2.79849, 0.0247953, 0.062922}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show[gvs,gp]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.295918 0.136054 0.487205 0.0576274 [
[.02381 .47471 -6 -9 ]
[.02381 .47471 6 0 ]
[.15986 .47471 -6 -9 ]
[.15986 .47471 6 0 ]
[.43197 .47471 -3 -9 ]
[.43197 .47471 3 0 ]
[.56803 .47471 -3 -9 ]
[.56803 .47471 3 0 ]
[.70408 .47471 -3 -9 ]
[.70408 .47471 3 0 ]
[.84014 .47471 -3 -9 ]
[.84014 .47471 3 0 ]
[.97619 .47471 -3 -9 ]
[.97619 .47471 3 0 ]
[.28342 .02619 -12 -4.5 ]
[.28342 .02619 0 4.5 ]
[.28342 .14144 -12 -4.5 ]
[.28342 .14144 0 4.5 ]
[.28342 .2567 -12 -4.5 ]
[.28342 .2567 0 4.5 ]
[.28342 .37195 -12 -4.5 ]
[.28342 .37195 0 4.5 ]
[.28342 .60246 -6 -4.5 ]
[.28342 .60246 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .48721 m
.02381 .49346 L
s
[(-2)] .02381 .47471 0 1 Mshowa
.15986 .48721 m
.15986 .49346 L
s
[(-1)] .15986 .47471 0 1 Mshowa
.43197 .48721 m
.43197 .49346 L
s
[(1)] .43197 .47471 0 1 Mshowa
.56803 .48721 m
.56803 .49346 L
s
[(2)] .56803 .47471 0 1 Mshowa
.70408 .48721 m
.70408 .49346 L
s
[(3)] .70408 .47471 0 1 Mshowa
.84014 .48721 m
.84014 .49346 L
s
[(4)] .84014 .47471 0 1 Mshowa
.97619 .48721 m
.97619 .49346 L
s
[(5)] .97619 .47471 0 1 Mshowa
.125 Mabswid
.05102 .48721 m
.05102 .49096 L
s
.07823 .48721 m
.07823 .49096 L
s
.10544 .48721 m
.10544 .49096 L
s
.13265 .48721 m
.13265 .49096 L
s
.18707 .48721 m
.18707 .49096 L
s
.21429 .48721 m
.21429 .49096 L
s
.2415 .48721 m
.2415 .49096 L
s
.26871 .48721 m
.26871 .49096 L
s
.32313 .48721 m
.32313 .49096 L
s
.35034 .48721 m
.35034 .49096 L
s
.37755 .48721 m
.37755 .49096 L
s
.40476 .48721 m
.40476 .49096 L
s
.45918 .48721 m
.45918 .49096 L
s
.48639 .48721 m
.48639 .49096 L
s
.51361 .48721 m
.51361 .49096 L
s
.54082 .48721 m
.54082 .49096 L
s
.59524 .48721 m
.59524 .49096 L
s
.62245 .48721 m
.62245 .49096 L
s
.64966 .48721 m
.64966 .49096 L
s
.67687 .48721 m
.67687 .49096 L
s
.73129 .48721 m
.73129 .49096 L
s
.7585 .48721 m
.7585 .49096 L
s
.78571 .48721 m
.78571 .49096 L
s
.81293 .48721 m
.81293 .49096 L
s
.86735 .48721 m
.86735 .49096 L
s
.89456 .48721 m
.89456 .49096 L
s
.92177 .48721 m
.92177 .49096 L
s
.94898 .48721 m
.94898 .49096 L
s
.25 Mabswid
0 .48721 m
1 .48721 L
s
.29592 .02619 m
.30217 .02619 L
s
[(-8)] .28342 .02619 1 0 Mshowa
.29592 .14144 m
.30217 .14144 L
s
[(-6)] .28342 .14144 1 0 Mshowa
.29592 .2567 m
.30217 .2567 L
s
[(-4)] .28342 .2567 1 0 Mshowa
.29592 .37195 m
.30217 .37195 L
s
[(-2)] .28342 .37195 1 0 Mshowa
.29592 .60246 m
.30217 .60246 L
s
[(2)] .28342 .60246 1 0 Mshowa
.125 Mabswid
.29592 .055 m
.29967 .055 L
s
.29592 .08381 m
.29967 .08381 L
s
.29592 .11263 m
.29967 .11263 L
s
.29592 .17025 m
.29967 .17025 L
s
.29592 .19907 m
.29967 .19907 L
s
.29592 .22788 m
.29967 .22788 L
s
.29592 .28551 m
.29967 .28551 L
s
.29592 .31432 m
.29967 .31432 L
s
.29592 .34314 m
.29967 .34314 L
s
.29592 .40076 m
.29967 .40076 L
s
.29592 .42958 m
.29967 .42958 L
s
.29592 .45839 m
.29967 .45839 L
s
.29592 .51602 m
.29967 .51602 L
s
.29592 .54483 m
.29967 .54483 L
s
.29592 .57365 m
.29967 .57365 L
s
.25 Mabswid
.29592 0 m
.29592 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.22878 .1973 m
.22995 .24581 L
.23118 .27268 L
.23233 .28994 L
.23367 .30521 L
.23495 .31672 L
.23735 .33359 L
.23994 .34751 L
.24276 .35964 L
.24752 .37563 L
.25259 .38887 L
.26171 .40699 L
.2729 .42346 L
.28345 .43559 L
.30316 .45309 L
.32323 .46671 L
.34171 .47692 L
.38119 .49408 L
.41917 .50684 L
.45959 .51789 L
.4985 .52683 L
.53986 .53503 L
.5797 .54195 L
.61803 .54791 L
.65882 .55364 L
.69808 .55867 L
.73583 .56312 L
.77604 .56751 L
.81472 .57144 L
.85586 .57534 L
.89549 .57887 L
.9336 .58207 L
.97416 .58529 L
.97619 .58545 L
s
.16006 .10991 m
.16032 .15925 L
.16147 .23128 L
.16254 .26078 L
.16375 .28233 L
.16508 .29922 L
.16749 .32113 L
.16984 .3366 L
.17201 .348 L
.17695 .36764 L
.18221 .3831 L
.19315 .40607 L
.20345 .42161 L
.22272 .4427 L
.24279 .45868 L
.26127 .47027 L
.30075 .48922 L
.33873 .50297 L
.37915 .51471 L
.41806 .52412 L
.45942 .53269 L
.49927 .53988 L
.5376 .54605 L
.57838 .55196 L
.61764 .55713 L
.65539 .56169 L
.6956 .56619 L
.73429 .57021 L
.77543 .57419 L
.81505 .57779 L
.85316 .58105 L
.89372 .58432 L
.93276 .58731 L
.97426 .59032 L
.97619 .59046 L
s
.09211 0 m
.09259 .18794 L
.0933 .22609 L
.09396 .24738 L
.09522 .27438 L
.09641 .29169 L
.09771 .30613 L
.09911 .31845 L
.10197 .33752 L
.10458 .35074 L
.10961 .36991 L
.11428 .38336 L
.12487 .40563 L
.1342 .41997 L
.14415 .43213 L
.16556 .4519 L
.18573 .46583 L
.22428 .48566 L
.26529 .5012 L
.30478 .51302 L
.34275 .52248 L
.38317 .53108 L
.42208 .53831 L
.46344 .54511 L
.50329 .55098 L
.54162 .55611 L
.5824 .56111 L
.62166 .56555 L
.65942 .56952 L
.69962 .57346 L
.73831 .57702 L
.77945 .58057 L
.81907 .5838 L
.85718 .58674 L
.89774 .58972 L
.93678 .59245 L
.97619 .59507 L
s
.02456 0 m
.02499 .2134 L
.02605 .25069 L
.02729 .27594 L
.02846 .29261 L
.03053 .31389 L
.03279 .33055 L
.03527 .34461 L
.0379 .35652 L
.04262 .37317 L
.05205 .3966 L
.05742 .40663 L
.06244 .41466 L
.08274 .43899 L
.09415 .44919 L
.10458 .45716 L
.14429 .4802 L
.18248 .49607 L
.22313 .50921 L
.26226 .51954 L
.30384 .5288 L
.34391 .53651 L
.38246 .54306 L
.42346 .5493 L
.46295 .55473 L
.50092 .55951 L
.54134 .5642 L
.58025 .56837 L
.62161 .57251 L
.66146 .57622 L
.69979 .57959 L
.74057 .58296 L
.77984 .58604 L
.81759 .58885 L
.85779 .59169 L
.89648 .59431 L
.93762 .59696 L
.97619 .59934 L
s
.02381 .44726 m
.04262 .46133 L
.06244 .47318 L
.10458 .49236 L
.14264 .50549 L
.18314 .5168 L
.22214 .52592 L
.26358 .53425 L
.30351 .54128 L
.34193 .54732 L
.38279 .55312 L
.42214 .5582 L
.45998 .56269 L
.50027 .56712 L
.53904 .57109 L
.58026 .57502 L
.61997 .57857 L
.65817 .5818 L
.69881 .58504 L
.73794 .588 L
.77952 .59098 L
.81959 .59372 L
.85814 .59623 L
.89914 .59879 L
.93863 .60116 L
.97619 .60332 L
s
.01 w
.03741 .35451 m
.042 .37124 L
.04626 .38338 L
.05595 .40406 L
.0654 .4189 L
.0755 .43143 L
.09725 .45167 L
.11703 .46542 L
.15639 .48572 L
.19426 .50019 L
.23454 .51242 L
.27333 .52215 L
.31062 .53018 L
.35033 .53766 L
.38855 .54403 L
.42919 .55012 L
.46833 .55543 L
.50598 .56012 L
.54604 .56472 L
.58461 .56882 L
.6256 .57289 L
.66509 .57655 L
.70309 .57987 L
.74351 .5832 L
.78243 .58624 L
.81986 .58901 L
.85971 .59183 L
.89806 .59441 L
.93883 .59704 L
.97619 .59934 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003o1`3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0c`3oool0
00L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0>P3oool00`000000
oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0j0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool0>P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo0340oooo00@0e9/0000000000000L[[Z1@3oool00`000000oooo0?ooo`3?
0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0300oooo00D0oooD09^K
e03oool0oooo0;ZK^P050?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool0<@3oool0102jVkX0oooo0?ooe02KVm@50?ooo`<00000c`3oool0
00L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0Z0?ooo`030?oDV`0000000000
0080000000<0VmCo0?ooo`3DV`000P0000000`1b^^X0oooo0?ooo`030?ooo`030000003oool0oooo
0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0<03oool01@3oom@0
Vg:j0?ooo`3oom@0Vg:j00D0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0a0?ooo`040>ZjLP000000000009_Do`D0oooo00<000000?oo
o`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
>P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo03X0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool0>P3oool200000=00oooo00070?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0<l0oooo0007
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`3?
0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo00<000000?oo
o`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
>P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo03X0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0j0?ooo`800000d03oool000L0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0j0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0<l0oooo0007
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`3?
0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo00<000000?oo
o`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0V0?ooo`800000d03oool000L0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0c`3o
ool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0c`3oool000L0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo01d0oooo00D0oooD09/000000000001b0;[Zo`040?ooo`030000003o
ool0oooo0<l0oooo00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0M0?ooo`050=BK002Ke?l0oooo0?ooe03De?l0103oool00`000000oooo0?oo
o`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool0703oool01P3oom@0V`0007:jjP3oool0j[Yb09_Do`@0oooo0`00003?0?ooo`001`3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool05P3o
ool00`3oe9/00000000000020000000609_Do`3oool0^W:K079b0000000007:j1@3oool00`000000
oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool07@3oool00`3oe9/007:j0?ooo`060?ooo`030000003oool0oooo0<l0oooo
00070?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0N0?ooo`040>ZjLP000000000009_Do`@0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool0c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo02H0oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
c`3oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo02H0oooo0P00003@0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool09P3oool00`000000oooo
0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`3?
0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`80
0000d03oool000L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`3?0?ooo`001`3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0
oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool0c`3oool000L0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0<l0
oooo00070?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0c`3oool000L0oooo00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`3?0?ooo`001`3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo0<l0oooo00070?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo0P00003@0?oo
o`00203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0<l0oooo00080?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0c`3oool000P0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`3?0?ooo`00203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0<l0oooo00080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0c`3oool000P0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool02@3oool0103Z^W8000000000LP2jj_l40?ooo`030000003oool0oooo
0<l0oooo00080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo00X0oooo00<0omBK07:jjP3oool0103oool00`000000
oooo0?ooo`3?0?ooo`00203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`070?ooo`060?ooe02K0000000000000000
0780^^[o103oool300000<l0oooo00080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0A0?ooo`050000003oool0oooo0?ooo`3oe9/0100000001P2K
e?l0oooo0=BK002Ke?l0omBK07:jjPD0oooo00<000000?ooo`3oool0c`3oool000P0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool0203oool0103oom@0V`1b0;ZjV`1b^^X50?ooo`030000003oool0oooo0<l0oooo0008
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo00T0oooo00<0onZj0780001b^^X01@3oool00`000000oooo0?ooo`3?
0?ooo`00203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0<l0oooo00080?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0c`3oool000P0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`3?0?ooo`00203oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0<l0oooo00080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0c`3oool0
00P0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool0403oool200000=00oooo00080?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0c`3oool000P0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`3?0?ooo`00203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0<l0oooo0008
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0c`3oool000P0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`3?0?ooo`002@3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0<l0oooo00090?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
c`3oool000T0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool03`3oool200000=00oooo00090?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0c`3oool000T0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`3?0?ooo`002P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0180
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0<l0
oooo000:0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0c`3oool000X0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`3?0?ooo`002P3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo0<l0oooo000:0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool0c`3oool000X0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`3?0?ooo`00
2P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0>0?ooo`800000d03oool000X0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`3?0?ooo`002P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo0<l0oooo000;0?ooo`8000004P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`3?0?ooo`002`3oool200000180
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool0c`3oool000/0oooo0P00000B0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0<l0oooo
000;0?ooo`8000004`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool00`3oool01P3oe9/00000000000000000002K0=Coo`@0oooo00<000000?ooo`3o
ool0c`3oool000/0oooo0P00000C0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`040?ooo`030;Yb000009/0e?oo00H0oooo00<000000?ooo`3oool0
c`3oool000`0oooo0P00000B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`040?ooo`030?oDV`000000VmCo00D0oooo0`00003?0?ooo`00303oool2
00000180oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0@0?ooo`030?oDV`000000
00000080000000H0VmCo0?ooo`3oool0oooo0?ooe03De?l50?ooo`030000003oool0oooo0<l0oooo
000=0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo0080oooo00H0onZj079b^P3oool0oooD09/0V`3Dool40?ooo`03
0000003oool0oooo0<l0oooo000=0?ooo`8000004P3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool00P3oool0103Z^W8000000000001b^^X50?ooo`03
0000003oool0oooo0<l0oooo000>0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
c`3oool000h0oooo0P00000B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0<l0oooo000>0?ooo`8000004`3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`3?0?ooo`003P3oool300000180oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0c`3oool000l0
oooo0P00000C0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo0<l0oooo000?0?ooo`8000004`3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0203oool200000=00oooo
000@0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0c`3oool00100oooo0P00000D
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo0<l0oooo000A0?ooo`8000004`3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3?0?oo
o`004P3oool2000001<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0c`3oool001<0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`3?0?ooo`004`3oool2000001<0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0c`3o
ool001@0oooo0P00000C0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0<l0oooo000E0?ooo`8000004`3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`3?0?ooo`005P3oool2000001<0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo0080oooo0P00003@0?ooo`005P3oool3000001<0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`050000003oool0oooo0?ooo`00
0000d@3oool001L0oooo0`00000C0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4@3oool010000000oooo0?ooo`00003A0?ooo`00603oool400000180oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool000000=40oooo000I0?ooo`@000004P3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo0P00003A0?ooo`001`3oool4
000000030000V`3Dool0oooo00d0oooo0`00000A0?ooo`060?ooe00000000000000000000780^^[o
3`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0280oooo00H0oooD09/000000000
00000000LP2jj_lS0?ooo`060?oDV`00000000000000000009/0e?oo8`3oool0103Z^W8000000000
0000Vm@U0?ooo`040>ZjLP000000001b0;[Zob@0oooo00@0j[Yb000000000000L[[Z1P3oool000P0
oooo0P0000000`3Dool0oooo0?ooo`0?0?ooo`<000004P3oool00`000000L[[Z0?ooo`0A0?ooo`80
00004@3oool2000002D0oooo00<0omBK07:jjP3oool09@3oool00`2jLP00002K0=Coo`0T0?ooo`06
0?oZ^P1bL[X0oooo0?ooe02K0780^^[o9@3oool00`3oe9/0L[[Z0?ooo`0S0?ooo`060?oZ^P1bL[X0
oooo0?ooo`2jLW80^^[o1@3oool000T0oooo00<0omBK0000002Ke?l04@3oool400000100oooo00<0
omBK0000000000004`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0000002@0oooo00<0
omBK07:jjP3oool09P3oool00`3oe9/0000009_Do`0U0?ooo`030=BK00000000VmCo02<0oooo00H0
oooD09/00000000000000000LP2jj_lW0?ooo`030=BKLP2jj_l0oooo00@0oooo00000`3oool0omBK
000000030000000509_Do`3oool0oooo0?ooo`3oom@00P00000A0?ooo`@000001`3oool00`3oe9/0
0000000000020000000709_Do`3oool0oooo0?oDV`1b^^X0oooo0000000C0?ooo`030000003oool0
oooo00d0oooo0P0000000`3oool000000000000R0?ooo`030?oDV`1b^^X0oooo02L0oooo00<0oooD
0=CDo`3oool09@3oool00`3oom@0Vg:j0?ooo`0S0?ooo`040=BK002Ke?l0omBK07:jjRD0oooo00@0
e9/000000000000009_D1P3oool000L0oooo00L0onZj079b^P3oool0oooD09/0V`3Dool000000180
oooo1000000<0?ooo`030;YbV`3De9/0L[[Z0080oooo0P00000B0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0N0?ooo`030;YbV`3De9/0L[[Z02D0
oooo00H0onZj079b^P3oool0oooD09/0V`3DoolR0?ooo`060?ooe02K0780^^[o0?ooe02K09/0e?oo
8`3oool0103oom@0V`1b0;ZjV`1b^^XU0?ooo`030=BKLP2jj_l0oooo00L0oooo00080?ooo`040>Zj
LP000000000007:jjP80oooo0P00000A0?ooo`D000002P3oool00`3oe9/0000007:jjP040?ooo`03
0000003oool0oooo0100oooo0P00000<0?ooo`030000003oool0oooo00<0oooo0P00000N0?ooo`03
0?oDV`000000L[[Z02H0oooo00@0j[Yb000000000000L[[Z903oool0103oj[X0LP000000002Ke?lU
0?ooo`030?oZ^P1b0000L[[Z02D0oooo00@0e9/000000000000009_D1P3oool00100oooo0P00000A
0?ooo`D00000403oool200000180oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo0<L0oooo000B0?ooo`8000004@3oool400000140oooo0P00000A0?oo
o`8000002@3oool00`000000oooo0?ooo`060?ooo`800000a`3oool001@0oooo0P00000A0?ooo`@0
00004@3oool200000140oooo0P0000070?ooo`030000003oool0oooo00P0oooo0P0000350?ooo`00
5P3oool200000100oooo1@00000A0?ooo`8000004@3oool2000000D0oooo00<000000?ooo`3oool0
2P3oool200000<<0oooo000H0?ooo`800000403oool500000140oooo0P00000A0?ooo`<000000P3o
ool00`000000oooo0?ooo`0<0?ooo`800000`@3oool001X0oooo0P00000@0?ooo`D000004@3oool2
00000180oooo0`00000@0?ooo`800000_`3oool00?l00000:`00000000L0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo0`0000060?ooo`03
0000003oool0oooo00D0oooo1`0000000`3oool000000?ooo`060?ooo`030000003oool0oooo00@0
oooo0`0000070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`0000020?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool3000000L0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool000L0oooo00<000000?ooo`3oool05`3oool3000000/0oooo00@000000?ooo`3oool0
oooo1P00000@0?ooo`<00000303oool00`000000oooo0?ooo`030?ooo`800000403oool3000000d0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`050?ooo`00903oool2000000l0oooo
1P00000A0?ooo`8000002P3oool00`000000oooo0?ooo`050?ooo`<00000403oool400000;<0oooo
000V0?ooo`<000003`3oool600000100oooo0`0000070?ooo`030000003oool0oooo00P0oooo0`00
000A0?ooo`@00000[`3oool002T0oooo0`00000>0?ooo`P000003`3oool4000000<0oooo00<00000
0?ooo`3oool02`3oool300000180oooo0`00002/0?ooo`00;03oool4000000h0oooo1`00000@0?oo
o`@00000403oool300000180oooo0`00002Y0?ooo`00<03oool4000000h0oooo1`00000?0?ooo`@0
0000403oool300000180oooo0`00002V0?ooo`00=03oool4000000d0oooo2000000;0?ooo`800000
0P3oool4000000l0oooo0`00000B0?ooo`<00000X`3oool003P0oooo1000000=0?ooo`P000001`3o
ool00`000000oooo0?ooo`050?ooo`@000003P3oool400000140oooo1000002O0?ooo`00?03oool4
000000d0oooo2P0000000`3oool000000?ooo`0:0?ooo`@000003P3oool400000140oooo1P00002I
0?ooo`00@03oool4000000d0oooo2`00000<0?ooo`@000003P3oool500000180oooo1@00002D0?oo
o`00A03oool4000000l0oooo2@00000<0?ooo`@000003`3oool600000140oooo1000002@0?ooo`00
B03oool4000000`0oooo00@000000?ooo`3oool0oooo2000000<0?ooo`D00000403oool6000000l0
oooo1000002<0?ooo`00C03oool5000000L0oooo00<000000?ooo`3oool01@3oool9000000`0oooo
1P00000@0?ooo`H000003@3oool5000008L0oooo001A0?ooo`H0000000<0oooo0000003oool02P3o
ool;000000`0oooo1@00000A0?ooo`H00000303oool600000840oooo001G0?ooo`H000002`3oool=
000000/0oooo1P00000A0?ooo`H00000303oool6000007/0oooo001H0?ooo`8000000`3oool60000
00/0oooo4@0000070?ooo`H000004@3oool6000000`0oooo1P00001e0?ooo`00F03oool00`000000
oooo0?ooo`080?ooo`T000001`3ooolB000000L0oooo1P00000A0?ooo`H00000303oool8000006d0
oooo001H0?ooo`030000003oool0oooo0140oooo2@00000:0?ooo``000001`3oool9000000h0oooo
2@00000;0?ooo`T00000I03oool005P0oooo00<000000?ooo`3oool06P3oool6000000X0oooo4@00
00050?ooo`T000003P3oool8000000`0oooo1P00001N0?ooo`00F03oool00`000000oooo0?ooo`0P
0?ooo`P00000203ooolA000000P0oooo1P00000@0?ooo`H00000303oool9000005D0oooo001H0?oo
o`030000003oool0oooo02P0oooo2`0000080?ooo``00000203oool9000000d0oooo2000000=0?oo
o`/00000BP3oool005P0oooo00<000000?ooo`3oool0<`3oool9000000D0oooo4@0000060?ooo`/0
00002P3oool<000000`0oooo2@0000110?ooo`00F03oool00`000000oooo0?ooo`0l0?ooo`H00000
1@3ooolH000000@0oooo3000000:0?ooo``000002@3oool6000003/0oooo001H0?ooo`800000@`3o
ool9000000L0oooo600000050?ooo``000002P3oool9000000H0oooo2@00000b0?ooo`00F03oool0
0`000000oooo0?ooo`1;0?ooo``00000203ooolG000000D0oooo2`0000080?ooo`H000002@3oool<
000002H0oooo001H0?ooo`030000003oool0oooo05L0oooo300000070?oooaP00000103oool<0000
0080oooo2@00000<0?ooo``000006P3oool005P0oooo00<000000?ooo`3oool0H`3oool;000000P0
oooo5`0000050?ooob80000000<0oooo0000000000002@00000?0?ooo`00F03oool00`000000oooo
0?ooo`1^0?ooo``00000203ooolF000000H0oooo2`00000;0?oooa@000001`3oool005P0oooo00<0
00000?ooo`3oool0NP3ooolZ000000D0oooo3000000;0?ooo`P000001`3oool005P0oooo00<00000
0?ooo`3oool0TP3oool_000000h0oooo001>0?ooo`060?oDV`00000000000000000009/0e?oo103o
ool00`000000oooo0?ooo`2N0?ooobX000001`3oool004l0oooo00<0^W800000V`3Dool01P3oool0
0`000000oooo0?ooo`2Z0?oooah000001`3oool00500oooo00<0omBK0000002Ke?l01@3oool30000
0<80oooo1P0000070?ooo`00D@3oool00`3oom@0e=Co0?ooo`040?ooo`030000003oool0oooo0<l0
oooo001>0?ooo`060?oZ^P1bL[X0oooo0?ooe02K09/0e?oo103oool00`000000oooo0?ooo`3?0?oo
o`00C`3oool0103Z^W8000000000001b^^X50?ooo`030000003oool0oooo0<l0oooo001H0?ooo`03
0000003oool0oooo0<l0oooo0000\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {426.375, 279.813}} -> {-6.43837, \
12.0208, 0.0247953, 0.0585399}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["yp[0]//N", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(0.6931471805599453`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["yp[-1.5]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(\(-0.6931471805599453`\)\)], "Output"]
}, Open  ]],

Cell["\<\
Clear[y,yp,y1,gvs,gp]
\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
5. Rie\[SHacek]te difrenci\[AAcute]lnu rovnicu x+y^3y'=0. 
    N\[AAcute]jdite partikul\[AAcute]rne rie\[SHacek]enie, ktor\[EAcute] sp\
\:013a\:0148a za\[CHacek]. podmienku \t\t\ty(2)=5.
   Nakreslite integr\[AAcute]lnu krivku partikul\[AAcute]rneho \
rie\[SHacek]enia.
   Vypo\[CHacek]itajte hodnotu partikul\[AAcute]rnehho rie\[SHacek]enia \
y(1.58).
------------------------------------------------------------------------------\
-----------\
\>", "Section",
  PageBreakAbove->True,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Arial CE",
  FontColor->RGBColor[0, 0.500008, 0],
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["r=DSolve[x+y[x]^3*y'[x]==0,y[x],x]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{y[x] \[Rule] \(-2\^\(1/4\)\)\ \((\(-x\^2\) + 2\ C[1])\)\^\(1/4\)}, {y[
            x] \[Rule] \(-\[ImaginaryI]\)\ 2\^\(1/4\)\ \((\(-x\^2\) + 2\ \
C[1])\)\^\(1/4\)}, {y[
            x] \[Rule] \[ImaginaryI]\ 2\^\(1/4\)\ \((\(-x\^2\) + 2\ C[1])\)\^\
\(1/4\)}, {y[x] \[Rule] 
          2\^\(1/4\)\ \((\(-x\^2\) + 2\ C[1])\)\^\(1/4\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["y1[x_]=y[x]/.r[[1]]/.C[1]->c", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(\(-2\^\(1/4\)\)\ \((2\ c - x\^2)\)\^\(1/4\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["y2[x_]=y[x]/.r[[4]]/.C[1]->c", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(2\^\(1/4\)\ \((2\ c - x\^2)\)\^\(1/4\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solve[y2[2]==5,c]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{c \[Rule] 633\/4}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["yp[x_]=y2[x]/.c->633", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(2\^\(1/4\)\ \((1266 - x\^2)\)\^\(1/4\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["gp=Plot[yp[x],{x,-5,5},PlotStyle->Thickness[0.01]]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 -117.738 16.6828 [
[.11905 .03049 -6 -9 ]
[.11905 .03049 6 0 ]
[.30952 .03049 -6 -9 ]
[.30952 .03049 6 0 ]
[.69048 .03049 -3 -9 ]
[.69048 .03049 3 0 ]
[.88095 .03049 -3 -9 ]
[.88095 .03049 3 0 ]
[.4875 .1264 -30 -4.5 ]
[.4875 .1264 0 4.5 ]
[.4875 .20981 -24 -4.5 ]
[.4875 .20981 0 4.5 ]
[.4875 .29323 -30 -4.5 ]
[.4875 .29323 0 4.5 ]
[.4875 .37664 -24 -4.5 ]
[.4875 .37664 0 4.5 ]
[.4875 .46006 -30 -4.5 ]
[.4875 .46006 0 4.5 ]
[.4875 .54347 -24 -4.5 ]
[.4875 .54347 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .04299 m
.11905 .04924 L
s
[(-4)] .11905 .03049 0 1 Mshowa
.30952 .04299 m
.30952 .04924 L
s
[(-2)] .30952 .03049 0 1 Mshowa
.69048 .04299 m
.69048 .04924 L
s
[(2)] .69048 .03049 0 1 Mshowa
.88095 .04299 m
.88095 .04924 L
s
[(4)] .88095 .03049 0 1 Mshowa
.125 Mabswid
.16667 .04299 m
.16667 .04674 L
s
.21429 .04299 m
.21429 .04674 L
s
.2619 .04299 m
.2619 .04674 L
s
.35714 .04299 m
.35714 .04674 L
s
.40476 .04299 m
.40476 .04674 L
s
.45238 .04299 m
.45238 .04674 L
s
.54762 .04299 m
.54762 .04674 L
s
.59524 .04299 m
.59524 .04674 L
s
.64286 .04299 m
.64286 .04674 L
s
.7381 .04299 m
.7381 .04674 L
s
.78571 .04299 m
.78571 .04674 L
s
.83333 .04299 m
.83333 .04674 L
s
.07143 .04299 m
.07143 .04674 L
s
.02381 .04299 m
.02381 .04674 L
s
.92857 .04299 m
.92857 .04674 L
s
.97619 .04299 m
.97619 .04674 L
s
.25 Mabswid
0 .04299 m
1 .04299 L
s
.5 .1264 m
.50625 .1264 L
s
[(7.065)] .4875 .1264 1 0 Mshowa
.5 .20981 m
.50625 .20981 L
s
[(7.07)] .4875 .20981 1 0 Mshowa
.5 .29323 m
.50625 .29323 L
s
[(7.075)] .4875 .29323 1 0 Mshowa
.5 .37664 m
.50625 .37664 L
s
[(7.08)] .4875 .37664 1 0 Mshowa
.5 .46006 m
.50625 .46006 L
s
[(7.085)] .4875 .46006 1 0 Mshowa
.5 .54347 m
.50625 .54347 L
s
[(7.09)] .4875 .54347 1 0 Mshowa
.125 Mabswid
.5 .05967 m
.50375 .05967 L
s
.5 .07635 m
.50375 .07635 L
s
.5 .09303 m
.50375 .09303 L
s
.5 .10972 m
.50375 .10972 L
s
.5 .14308 m
.50375 .14308 L
s
.5 .15977 m
.50375 .15977 L
s
.5 .17645 m
.50375 .17645 L
s
.5 .19313 m
.50375 .19313 L
s
.5 .2265 m
.50375 .2265 L
s
.5 .24318 m
.50375 .24318 L
s
.5 .25986 m
.50375 .25986 L
s
.5 .27655 m
.50375 .27655 L
s
.5 .30991 m
.50375 .30991 L
s
.5 .32659 m
.50375 .32659 L
s
.5 .34328 m
.50375 .34328 L
s
.5 .35996 m
.50375 .35996 L
s
.5 .39333 m
.50375 .39333 L
s
.5 .41001 m
.50375 .41001 L
s
.5 .42669 m
.50375 .42669 L
s
.5 .44337 m
.50375 .44337 L
s
.5 .47674 m
.50375 .47674 L
s
.5 .49342 m
.50375 .49342 L
s
.5 .51011 m
.50375 .51011 L
s
.5 .52679 m
.50375 .52679 L
s
.5 .0263 m
.50375 .0263 L
s
.5 .00962 m
.50375 .00962 L
s
.5 .56015 m
.50375 .56015 L
s
.5 .57684 m
.50375 .57684 L
s
.5 .59352 m
.50375 .59352 L
s
.5 .6102 m
.50375 .6102 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.01 w
.02381 .01472 m
.06244 .10693 L
.10458 .1984 L
.14415 .27571 L
.18221 .34226 L
.22272 .40473 L
.26171 .45675 L
.30316 .50336 L
.34309 .53983 L
.3815 .56712 L
.40095 .57803 L
.42237 .58779 L
.44268 .59485 L
.45178 .59733 L
.46172 .59954 L
.4671 .60053 L
.4721 .60131 L
.47727 .60199 L
.48196 .60248 L
.48658 .60286 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .60291 L
.51504 .60274 L
.5204 .60225 L
.5293 .60111 L
.53882 .59944 L
.54906 .59712 L
.56016 .59399 L
.58032 .5867 L
.60019 .57745 L
.62123 .56543 L
.65912 .53803 L
.69946 .50068 L
.73829 .45676 L
.77956 .40144 L
Mistroke
.81932 .33973 L
.85757 .27252 L
.89827 .19252 L
.93745 .10718 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oU03oool0
0`000000oooo0?ooo`2C0?ooo`009@3oool0103Z^W8000000000LP2jj_lc0?ooo`060?oDV`000000
00000000000009/0e?oo<P3oool00`000000oooo0?ooo`0c0?ooo`060?oDV`000000000000000000
09/0e?oo=03oool0103Z^W8000000000LP2jj_lR0?ooo`009P3oool00`3oe9/0L[[Z0?ooo`0d0?oo
o`030;Yb000009/0e?oo03@0oooo00<000000?ooo`3oool0=03oool00`2jLP00002K0=Coo`0g0?oo
o`030?oDV`1b^^X0oooo0280oooo00070?ooo`030000003oool0oooo01T0oooo00H0oooD09/00000
000000000000LP2jj_le0?ooo`030?oDV`000000VmCo03<0oooo0P00000f0?ooo`030?oDV`000000
VmCo03<0oooo00H0oooD09/00000000000000000LP2jj_lJ0?ooo`030000003oool0oooo00D0oooo
00060?ooo`<00000503oool00`3oe9/00000000000020000000609_Do`3oool0e9/009_Do`3oe9/0
L[[Z;P3oool00`3oe9/00000000000020000000609_Do`3oool0oooo0?ooo`3oom@0e=Co<`3oool0
0`000000oooo0?ooo`0f0?ooo`030?ooe03De?l0oooo03<0oooo00@0e9/009_Do`3oe9/0L[[Z6P3o
ool3000000H0oooo00070?ooo`8000006`3oool0103oom@0V`1b0;ZjV`1b^^Xd0?ooo`060?oZ^P1b
L[X0oooo0?ooe02K09/0e?oo<P3oool00`000000oooo0?ooo`0c0?ooo`060?oZ^P1bL[X0oooo0?oo
e02K09/0e?oo<`3oool0103oom@0V`1b0;ZjV`1b^^XJ0?ooo`8000001`3oool000L0oooo0P00000L
0?ooo`030?oZ^P1b0000L[[Z03D0oooo00@0j[Yb000000000000L[[Z<`3oool00`000000oooo0?oo
o`0d0?ooo`040>ZjLP000000000007:jjSD0oooo00<0onZj0780001b^^X06@3oool3000000L0oooo
00070?ooo`<00000RP3oool00`000000oooo0?ooo`290?ooo`800000203oool000P0oooo0P00002:
0?ooo`800000RP3oool2000000P0oooo00080?ooo`<00000R@3oool00`000000oooo0?ooo`280?oo
o`<00000203oool000T0oooo0P0000290?ooo`030000003oool0oooo08P0oooo0P0000090?ooo`00
2@3oool2000008T0oooo00<000000?ooo`3oool0Q`3oool3000000T0oooo00090?ooo`<00000R03o
ool00`000000oooo0?ooo`270?ooo`8000002P3oool00?l00000:`00000000L0oooo00<000000?oo
o`3oool00`0000080?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo0P0000030?ooo`030000003oool0oooo
00D0oooo000;0?ooo`8000005P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0
oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo01D0
oooo0P00000;0?ooo`002`3oool2000008L0oooo00<000000?ooo`3oool0Q@3oool3000000/0oooo
000;0?ooo`<00000QP3oool00`000000oooo0?ooo`250?ooo`800000303oool000`0oooo0P000026
0?ooo`800000Q@3oool3000000`0oooo000<0?ooo`<00000Q@3oool00`000000oooo0?ooo`240?oo
o`8000003@3oool000d0oooo0P0000250?ooo`030000003oool0oooo08<0oooo0`00000=0?ooo`00
3@3oool2000008D0oooo00<000000?ooo`3oool0P`3oool2000000h0oooo000=0?ooo`<00000Q03o
ool00`000000oooo0?ooo`230?ooo`8000003P3oool000h0oooo0P0000240?ooo`800000P`3oool3
000000h0oooo000>0?ooo`<00000P`3oool00`000000oooo0?ooo`220?ooo`8000003`3oool000l0
oooo0P0000230?ooo`030000003oool0oooo0840oooo0`00000?0?ooo`003`3oool2000008<0oooo
00<000000?ooo`3oool0P@3oool200000100oooo000?0?ooo`<00000PP3oool00`000000oooo0?oo
o`200?ooo`<00000403oool00100oooo0P0000220?ooo`800000P@3oool200000140oooo000@0?oo
o`<00000P@3oool00`000000oooo0?ooo`200?ooo`8000004@3oool00140oooo0P0000210?ooo`03
0000003oool0oooo07l0oooo0`00000A0?ooo`004@3oool200000840oooo00<000000?ooo`3oool0
O`3oool200000180oooo000B0?ooo`030000003oool0oooo07l0oooo00<000000?ooo`3oool0O`3o
ool200000180oooo000B0?ooo`800000P03oool2000007l0oooo0P00000C0?ooo`004`3oool00`00
0000oooo0?ooo`1n0?ooo`030000003oool0oooo07h0oooo00<000000?ooo`3oool04P3oool001<0
oooo0P00001o0?ooo`030000003oool0oooo07d0oooo0P00000D0?ooo`00503oool00`000000oooo
0?ooo`1N0?ooo`030>ZjLP2Ke?l0oooo0080oooo00<0oooD09/00000L[X00`3oool0103Z^W800000
0000001b^^X20?ooo`070?ooe02K000000000000LP2jj_l0oooo0>ZjLP020000000307:jjP3oool0
oooo0080oooo00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`0C0?ooo`00503oool20000
05l0oooo00<0oooD09^Ke03oool0203oool03@2jVkX0oooo0?ooo`2jLY/0e?oo0?ooo`3DV`00VmCo
0?ooo`3oom@0e=Co0?oZ^P1bL[X00P3oool00`2jLW80^^[o0?ooo`020?ooo`030000003oool0oooo
07d0oooo00<000000?ooo`3oool04`3oool001D0oooo00<000000?ooo`3oool0GP3oool00`3DVi/0
e?oo0?ooo`060?ooo`0<0?ooe02KL[X0oooo0?ooo`3DVg80^^[o0?ooe02K0000L[[Z0?ooo`3Z^W80
VmCo103oool00`3DVg80^^[o0?ooo`020?ooo`<00000O03oool2000001D0oooo000E0?ooo`800000
G`3oool00`3oe9/0L[[Z0?ooo`060?ooo`0;0?ooe02KL[X0oooo0?ooo`3DVg80^^[o0?ooo`2jLY/0
LW8000000000L[X00P3oool0103DV`00000000000000Vm@40?ooo`030000003oool0oooo07`0oooo
00<000000?ooo`3oool0503oool001H0oooo00<000000?ooo`3oool0FP3oool01@3oj[X0LY_D0?oo
o`3oom@0Vg:j00P0oooo00P0^W9b0;[Zo`3oom@0V`2K0=Coo`3oool0omBK001b^P@0oooo00<0e9]b
0;[Zo`3oool01@3oool00`000000oooo0?ooo`1k0?ooo`8000005P3oool001H0oooo0P00001K0?oo
o`060?oZ^P1b000000000000000009/0e?oo1`3oool0103oj[X0LP000000002Ke?l30?ooo`060>Zj
LP000000000009_Do`3oool0e9/00P0000000`00Vm@0oooo0?ooo`020?ooo`030000003oool0oooo
07/0oooo00<000000?ooo`3oool05@3oool001L0oooo00<000000?ooo`3oool0NP3oool2000007/0
oooo0P00000G0?ooo`005`3oool2000007/0oooo00<000000?ooo`3oool0NP3oool00`000000oooo
0?ooo`0F0?ooo`00603oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo07T0oooo0P00
000H0?ooo`00603oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo07T0oooo00<00000
0?ooo`3oool05`3oool001P0oooo0P00001j0?ooo`030000003oool0oooo07T0oooo00<000000?oo
o`3oool05`3oool001T0oooo00<000000?ooo`3oool0N03oool2000007T0oooo0P00000I0?ooo`00
6@3oool2000007T0oooo00<000000?ooo`3oool0N03oool00`000000oooo0?ooo`0H0?ooo`006P3o
ool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo07L0oooo0P00000J0?ooo`006P3oool2
000007P0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`0I0?ooo`006`3oool00`00
0000oooo0?ooo`1f0?ooo`030000003oool0oooo07H0oooo0P00000K0?ooo`006`3oool2000007L0
oooo0P00001g0?ooo`030000003oool0oooo01X0oooo000L0?ooo`030000003oool0oooo07D0oooo
00<000000?ooo`3oool0MP3oool00`000000oooo0?ooo`0J0?ooo`00703oool2000007H0oooo00<0
00000?ooo`3oool0M@3oool2000001`0oooo000M0?ooo`030000003oool0oooo07@0oooo00<00000
0?ooo`3oool0M@3oool00`000000oooo0?ooo`0K0?ooo`007@3oool2000007D0oooo00<000000?oo
o`3oool0M03oool2000001d0oooo000N0?ooo`030000003oool0oooo07<0oooo0P00001e0?ooo`03
0000003oool0oooo01`0oooo000N0?ooo`800000M03oool00`000000oooo0?ooo`1c0?ooo`800000
7P3oool001l0oooo00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`1c0?ooo`030000003o
ool0oooo01d0oooo000O0?ooo`800000FP3oool00`3Z^W80VmCo0?ooo`020?ooo`030?ooe02K0000
07:j00<0oooo00@0j[Yb000000000000L[[Z0`3oool00`3Z^W80VmCo0?ooo`040?ooo`030000003o
ool0oooo0780oooo0P00000O0?ooo`00803oool00`000000oooo0?ooo`1H0?ooo`030?ooe02KVm@0
oooo00P0oooo00D0^Y^j0?ooo`3oool0^W:K0=Coo`020?ooo`030?ooe02KVm@0oooo00@0oooo00<0
00000?ooo`3oool0LP3oool00`000000oooo0?ooo`0N0?ooo`00803oool2000005X0oooo00<0e9^K
0=Coo`3oool01P3oool01P3oom@0Vg:j0?ooo`3oool0e9]b0;[Zo`<0oooo00<0e9^K0=Coo`3oool0
0`3oool300000740oooo0P00000P0?ooo`008@3oool00`000000oooo0?ooo`1H0?ooo`030?oDV`1b
^^X0oooo00H0oooo00H0oooD09]b^P3oool0oooo0=BKLP2jj_l30?ooo`030?oDV`1b^^X0oooo00<0
oooo00<000000?ooo`3oool0L03oool200000240oooo000Q0?ooo`800000EP3oool01@3oj[X0LY_D
0?ooo`3oom@0Vg:j00P0oooo00X0^W9b0;[Zo`3oom@0V`2K0=Coo`3oj[X0LY_D0?ooo`3oom@0Vg:j
103oool00`000000oooo0?ooo`1`0?ooo`030000003oool0oooo0200oooo000R0?ooo`030000003o
ool0oooo05@0oooo00H0onZj07800000000000000000V`3Dool70?ooo`070?oZ^P1b0000000009_D
o`3oool0onZj07800002000000030000V`3Dool0oooo0080oooo00<000000?ooo`3oool0K`3oool2
00000280oooo000R0?ooo`800000L03oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo
0240oooo000S0?ooo`030000003oool0oooo06h0oooo0P00001_0?ooo`8000008`3oool002<0oooo
0P00001_0?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3oool08P3oool002@0oooo00<0
00000?ooo`3oool0K@3oool00`000000oooo0?ooo`1]0?ooo`800000903oool002@0oooo0P00001^
0?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3oool08`3oool002D0oooo0P00001]0?oo
o`030000003oool0oooo06`0oooo0P00000U0?ooo`009P3oool00`000000oooo0?ooo`1[0?ooo`80
0000K@3oool00`000000oooo0?ooo`0T0?ooo`009P3oool2000006`0oooo00<000000?ooo`3oool0
J`3oool2000002H0oooo000W0?ooo`030000003oool0oooo06X0oooo00<000000?ooo`3oool0J`3o
ool00`000000oooo0?ooo`0U0?ooo`009`3oool2000006/0oooo00<000000?ooo`3oool0JP3oool2
000002L0oooo000X0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool0J@3oool20000
02P0oooo000X0?ooo`800000JP3oool2000006X0oooo00<000000?ooo`3oool09`3oool002T0oooo
00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`1X0?ooo`800000:@3oool002T0oooo0P00
001Y0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0:03oool002X0oooo00<00000
0?ooo`3oool0I`3oool00`000000oooo0?ooo`1W0?ooo`800000:P3oool002X0oooo0P00001X0?oo
o`030000003oool0oooo06L0oooo00<000000?ooo`3oool0:@3oool002/0oooo00<000000?ooo`3o
ool0IP3oool2000006L0oooo0P00000[0?ooo`00:`3oool2000006L0oooo00<000000?ooo`3oool0
IP3oool00`000000oooo0?ooo`0Z0?ooo`00;03oool00`000000oooo0?ooo`1U0?ooo`030000003o
ool0oooo06D0oooo0P00000/0?ooo`00;03oool2000004L0oooo00<0j[Yb09_Do`3oool00P3oool0
0`3oom@0V`00001b^P030?ooo`040>ZjLP000000000007:jjP<0oooo00<0j[Yb09_Do`3oool00P3o
ool0103Z^W8000000000001b^^X40?ooo`030000003oool0oooo06D0oooo00<000000?ooo`3oool0
:`3oool002d0oooo00<000000?ooo`3oool0A@3oool00`3oom@0Vi_D0?ooo`080?ooo`050;ZK^P3o
ool0oooo0;YbV`3Dool00P3oool01P3oom@0Vi_D0?ooo`3oool0onZj079b^P80oooo00<0^W9b0;[Z
o`3oool00P3oool00`000000oooo0?ooo`1T0?ooo`800000;@3oool002d0oooo0P0000170?ooo`03
0=BKV`3Dool0oooo00H0oooo00H0oooD09]b^P3oool0oooo0=BKLP2jj_l30?ooo`030=BKV`3Dool0
oooo00@0oooo00<0e9]b0;[Zo`3oool00P3oool3000006<0oooo0P00000^0?ooo`00;P3oool20000
04H0oooo00<0omBK07:jjP3oool01P3oool01P3oom@0Vg:j0?ooo`3oool0e9]b0;[Zo`<0oooo00D0
omBK07:jjP3oool0oooo0=BK000200000003002Ke03oool0oooo0080oooo00<000000?ooo`3oool0
H`3oool00`000000oooo0?ooo`0]0?ooo`00;`3oool00`000000oooo0?ooo`110?ooo`050?oZ^P1b
Vm@0oooo0?ooe02KL[X0203oool02P2jLW80^^[o0?ooe02K09/0e?oo0?oZ^P1bVm@0oooo0?ooe02K
L[X20?ooo`030=BKLP2jj_l0oooo00D0oooo00<000000?ooo`3oool0HP3oool2000002l0oooo000_
0?ooo`800000@P3oool01P3oj[X0LP00000000000000002K0=Coo`L0oooo00L0onZj078000000000
VmCo0?ooo`3oj[X0LP000080000000@0002K0=Coo`3oool0e9/00P0000000`00Vm@0oooo0?ooo`02
0?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool0;P3oool00300oooo00<000000?oo
o`3oool0H@3oool00`000000oooo0?ooo`1Q0?ooo`800000<03oool00300oooo0P00001R0?ooo`80
0000HP3oool00`000000oooo0?ooo`0_0?ooo`00<@3oool00`000000oooo0?ooo`1P0?ooo`030000
003oool0oooo0600oooo0P00000a0?ooo`00<@3oool200000640oooo00<000000?ooo`3oool0H03o
ool00`000000oooo0?ooo`0`0?ooo`00<P3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0
oooo05l0oooo0P00000b0?ooo`00<P3oool200000600oooo00<000000?ooo`3oool0GP3oool20000
03<0oooo000c0?ooo`800000G`3oool2000005l0oooo00<000000?ooo`3oool0<P3oool003@0oooo
00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`1M0?ooo`800000=03oool003@0oooo0P00
001N0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0<`3oool003D0oooo00<00000
0?ooo`3oool0G03oool00`000000oooo0?ooo`1L0?ooo`800000=@3oool003D0oooo0P00001M0?oo
o`030000003oool0oooo05`0oooo00<000000?ooo`3oool0=03oool003H0oooo00<000000?ooo`3o
ool0F`3oool2000005`0oooo0P00000f0?ooo`00=P3oool2000005`0oooo00<000000?ooo`3oool0
FP3oool2000003L0oooo000g0?ooo`800000F`3oool00`000000oooo0?ooo`1J0?ooo`030000003o
ool0oooo03H0oooo000h0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0F@3oool2
000003P0oooo000h0?ooo`800000FP3oool00`000000oooo0?ooo`1H0?ooo`800000>@3oool003T0
oooo0P00001I0?ooo`800000F@3oool00`000000oooo0?ooo`0h0?ooo`00>P3oool00`000000oooo
0?ooo`1G0?ooo`030000003oool0oooo05L0oooo0P00000j0?ooo`00>P3oool2000005P0oooo00<0
00000?ooo`3oool0EP3oool2000003/0oooo000k0?ooo`800000?P3oool00`3Z^W80VmCo0?ooo`02
0?ooo`030?ooe02K000007:j00<0oooo00@0j[Yb000000000000L[[Z0P3oool0103DV`0000000000
001b^^X40?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0>P3oool003`0oooo00<0
00000?ooo`3oool0?03oool00`3oom@0Vi_D0?ooo`080?ooo`070;ZK^P3oool0oooo0;YbV`3Dool0
oooD09^Ke0020?ooo`030;ZK^P3oool0oooo0080oooo00<000000?ooo`3oool0E@3oool2000003`0
oooo000l0?ooo`800000?P3oool00`3DVi/0e?oo0?ooo`060?ooo`0;0?ooe02KL[X0oooo0?ooo`3D
Vg80^^[o0?ooo`2jVkX0oooo0?ooe02KVm@0103oool3000005@0oooo0P00000m0?ooo`00?@3oool2
000003d0oooo00<0omBK07:jjP3oool01P3oool0203oom@0Vg:j0?ooo`3oool0e9]b0;[Zo`3oool0
e9/00P0000000`1b^^X0oooo0?ooo`020?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3o
ool0?03oool003h0oooo00<000000?ooo`3oool0>03oool01@3oj[X0LY_D0?ooo`3oom@0Vg:j00P0
oooo00X0^W9b0;[Zo`3oom@0V`2K0=Coo`3oom@0Vg:j0?ooo`3oom@0Vg:j103oool00`000000oooo
0?ooo`1C0?ooo`800000?P3oool003h0oooo0P00000i0?ooo`060?oZ^P1b000000000000000009/0
e?oo1`3oool0103oj[X0LP000000002Ke?l20?ooo`040>ZjLP000000000009_Do`@0oooo00<00000
0?ooo`3oool0DP3oool2000003l0oooo000o0?ooo`800000D`3oool00`000000oooo0?ooo`1B0?oo
o`030000003oool0oooo03h0oooo00100?ooo`030000003oool0oooo0540oooo0P00001B0?ooo`80
0000@03oool00400oooo0P00001B0?ooo`030000003oool0oooo0500oooo0P0000110?ooo`00@@3o
ool200000540oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`100?ooo`00@P3oool0
0`000000oooo0?ooo`1?0?ooo`030000003oool0oooo04l0oooo0P0000120?ooo`00@P3oool20000
0500oooo00<000000?ooo`3oool0CP3oool2000004<0oooo00130?ooo`800000C`3oool2000004l0
oooo00<000000?ooo`3oool0@P3oool004@0oooo0P00001>0?ooo`030000003oool0oooo04d0oooo
0P0000140?ooo`00A@3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo04`0oooo0P00
00150?ooo`00A@3oool2000004d0oooo00<000000?ooo`3oool0B`3oool2000004H0oooo00160?oo
o`800000C03oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo04D0oooo00170?ooo`80
0000B`3oool2000004/0oooo0P0000170?ooo`00B03oool00`000000oooo0?ooo`190?ooo`030000
003oool0oooo04T0oooo0P0000180?ooo`00B03oool2000004X0oooo00<000000?ooo`3oool0B@3o
ool00`000000oooo0?ooo`170?ooo`00B@3oool2000004T0oooo00<000000?ooo`3oool0B03oool2
000004T0oooo001:0?ooo`800000B03oool00`000000oooo0?ooo`170?ooo`800000BP3oool004/0
oooo00<000000?ooo`3oool0AP3oool2000004L0oooo0P00001;0?ooo`00B`3oool2000004L0oooo
00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`1:0?ooo`00C03oool2000004H0oooo00<0
00000?ooo`3oool0A@3oool2000004`0oooo001=0?ooo`8000009P3oool00`3Z^W80VmCo0?ooo`02
0?ooo`030?ooe02K000007:j00<0oooo00@0j[Yb000000000000L[[Z0P3oool0103DV`0000000000
001b^^X20?ooo`040>ZjLP000000000007:jjP@0oooo00<000000?ooo`3oool0A03oool2000004d0
oooo001>0?ooo`8000009@3oool00`3oom@0Vi_D0?ooo`080?ooo`070;ZK^P3oool0oooo0;YbV`3D
ool0oooD09^Ke0020?ooo`040;ZK^P3oool0onZj079b^P80oooo00<0^W9b0;[Zo`3oool00P3oool0
0`000000oooo0?ooo`130?ooo`800000CP3oool004h0oooo0`00000U0?ooo`030=BKV`3Dool0oooo
00H0oooo00/0oooD09]b^P3oool0oooo0=BKLP2jj_l0oooo0;ZK^P3oool0oooD09^Ke0050?ooo`03
0=BKLP2jj_l0oooo0080oooo0`0000120?ooo`<00000CP3oool004l0oooo0`00000T0?ooo`030?oD
V`1b^^X0oooo00H0oooo00P0oooD09]b^P3oool0oooo0=BKLP2jj_l0oooo0=BK0080000000@0L[[Z
0?ooo`3oool0e9/00P0000000`00Vm@0oooo0?ooo`020?ooo`030000003oool0oooo0440oooo0`00
001?0?ooo`00D03oool300000200oooo00D0onZj07:Ke03oool0oooD09]b^P080?ooo`0:0;YbLP2j
j_l0oooD09/0V`3Dool0oooD09]b^P3oool0oooD09]b^P80oooo00<0e9]b0;[Zo`3oool01@3oool0
0`000000oooo0?ooo`110?ooo`800000D03oool00540oooo0`00000O0?ooo`060?oZ^P1b00000000
0000000009/0e?oo1`3oool0103oj[X0LP000000002Ke?l20?ooo`040>ZjLP000000000009_Do`80
oooo00@0e9/000000000000009_D103oool00`000000oooo0?ooo`100?ooo`800000D@3oool00580
oooo0`00000o0?ooo`030000003oool0oooo03l0oooo0`00001A0?ooo`00D`3oool2000003l0oooo
0P00000o0?ooo`<00000DP3oool005@0oooo0P00000n0?ooo`030000003oool0oooo03d0oooo0`00
001C0?ooo`00E03oool3000003d0oooo00<000000?ooo`3oool0?03oool3000005@0oooo001E0?oo
o`<00000?03oool00`000000oooo0?ooo`0l0?ooo`800000E@3oool005H0oooo0`00000k0?ooo`80
0000?03oool2000005H0oooo001G0?ooo`<00000>P3oool00`000000oooo0?ooo`0j0?ooo`<00000
EP3oool005P0oooo0`00000i0?ooo`030000003oool0oooo03T0oooo0`00001G0?ooo`00F@3oool3
000003P0oooo00<000000?ooo`3oool0>03oool3000005P0oooo001J0?ooo`<00000=`3oool00`00
0000oooo0?ooo`0g0?ooo`<00000F@3oool005/0oooo0`00000f0?ooo`800000=`3oool3000005X0
oooo001L0?ooo`<00000=@3oool00`000000oooo0?ooo`0e0?ooo`<00000F`3oool005d0oooo0`00
000d0?ooo`030000003oool0oooo03@0oooo0`00001L0?ooo`00GP3oool400000380oooo00<00000
0?ooo`3oool0<P3oool4000005d0oooo001O0?ooo`@00000<@3oool00`000000oooo0?ooo`0a0?oo
o`@00000GP3oool00640oooo0`00000`0?ooo`800000<@3oool300000600oooo001R0?ooo`<00000
;`3oool00`000000oooo0?ooo`0_0?ooo`<00000H@3oool006<0oooo0`00000^0?ooo`030000003o
ool0oooo02h0oooo0`00001R0?ooo`00I03oool3000001@0oooo00<0j[Yb09_Do`3oool00P3oool0
0`3oom@0V`00001b^P030?ooo`040>ZjLP000000000007:jjP80oooo00@0^W80000000000000L[[Z
103oool00`000000oooo0?ooo`0]0?ooo`<00000H`3oool006D0oooo0`00000C0?ooo`030?ooe02K
Vm@0oooo00P0oooo00D0^Y^j0?ooo`3oool0^W:K0=Coo`040?ooo`030;YbV`3Dool0oooo0080oooo
00<000000?ooo`3oool0:`3oool4000006@0oooo001V0?ooo`@000004P3oool00`3DVi/0e?oo0?oo
o`060?ooo`080?ooe02KL[X0oooo0?ooo`3DVg80^^[o0?ooo`3oe9/30000000409_Do`3oool0oooo
0?ooo`<00000:P3oool4000006D0oooo001W0?ooo`@000004@3oool00`3oe9/0L[[Z0?ooo`060?oo
o`0<0?ooe02KL[X0oooo0?ooo`3DVg80^^[o0?ooe02K09/0e?oo0?ooo`3Z^W80VmCo0`3oool00`00
0000oooo0?ooo`0X0?ooo`@00000I`3oool006T0oooo0`00000=0?ooo`050?oZ^P1bVm@0oooo0?oo
e02KL[X0203oool02`2jLW80^^[o0?ooe02K09/0e?oo0?ooe02K09/0e?oo0?ooo`2jLY/0e?oo00<0
oooo00<000000?ooo`3oool09`3oool4000006P0oooo001Z0?ooo`@000002`3oool01P3oj[X0LP00
000000000000002K0=Coo`L0oooo00@0onZj078000000000VmCo0P3oool0103oe9/000000000001b
^^X40?ooo`030000003oool0oooo02D0oooo1000001Z0?ooo`00J`3oool4000002D0oooo00<00000
0?ooo`3oool0903oool4000006/0oooo001]0?ooo`@000008`3oool2000002<0oooo1000001]0?oo
o`00KP3oool400000280oooo00<000000?ooo`3oool08@3oool4000006h0oooo001`0?ooo`<00000
8@3oool00`000000oooo0?ooo`0O0?ooo`@00000L03oool00740oooo1000000O0?ooo`030000003o
ool0oooo01d0oooo1@00001a0?ooo`00LP3oool4000001h0oooo00<000000?ooo`3oool06`3oool5
000007<0oooo001d0?ooo`@00000703oool2000001X0oooo1@00001e0?ooo`00M@3oool5000001X0
oooo00<000000?ooo`3oool05`3oool5000007L0oooo001g0?ooo`D00000603oool00`000000oooo
0?ooo`0E0?ooo`D00000N@3oool007T0oooo1@00000F0?ooo`030000003oool0oooo0180oooo1P00
001k0?ooo`00N`3oool6000001<0oooo00<000000?ooo`3oool03`3oool7000007d0oooo001m0?oo
o`L00000403oool2000000d0oooo1`0000200?ooo`00P03oool:000000X0oooo00<000000?ooo`3o
ool02@3oool7000008<0oooo00230?ooo`X000001`3oool00`000000oooo0?ooo`030?ooo`X00000
QP3oool008T0oooo600000290?ooo`00S03oool?000008l0oooo002D0?ooo`800000U03oool009@0
oooo00<000000?ooo`3oool0T`3oool009@0oooo00<000000?ooo`3oool0T`3oool00001\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {618.125, 471.563}} -> {-11.3405, \
7.17664, 0.0354218, 0.000202214}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["t1=Table[y1[x],{c,627,639,3}]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({\(-2\^\(1/4\)\)\ \((1254 - x\^2)\)\^\(1/4\), \(-2\^\(1/4\)\)\ \((1260 \
- x\^2)\)\^\(1/4\), \(-2\^\(1/4\)\)\ \((1266 - x\^2)\)\^\(1/4\), \
\(-2\^\(1/4\)\)\ \((1272 - x\^2)\)\^\(1/4\), \(-2\^\(1/4\)\)\ \((1278 - x\^2)\
\)\^\(1/4\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["t2=Table[y2[x],{c,627,639,3}]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({2\^\(1/4\)\ \((1254 - x\^2)\)\^\(1/4\), 
      2\^\(1/4\)\ \((1260 - x\^2)\)\^\(1/4\), 
      2\^\(1/4\)\ \((1266 - x\^2)\)\^\(1/4\), 
      2\^\(1/4\)\ \((1272 - x\^2)\)\^\(1/4\), 
      2\^\(1/4\)\ \((1278 - x\^2)\)\^\(1/4\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["k1=Plot[Evaluate[t1],{x,-5,5}]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 60.5316 8.51112 [
[.11905 .0902 -6 -9 ]
[.11905 .0902 6 0 ]
[.30952 .0902 -6 -9 ]
[.30952 .0902 6 0 ]
[.69048 .0902 -3 -9 ]
[.69048 .0902 3 0 ]
[.88095 .0902 -3 -9 ]
[.88095 .0902 3 0 ]
[.4875 .01759 -30 -4.5 ]
[.4875 .01759 0 4.5 ]
[.4875 .18781 -30 -4.5 ]
[.4875 .18781 0 4.5 ]
[.4875 .27292 -30 -4.5 ]
[.4875 .27292 0 4.5 ]
[.4875 .35803 -30 -4.5 ]
[.4875 .35803 0 4.5 ]
[.4875 .44314 -30 -4.5 ]
[.4875 .44314 0 4.5 ]
[.4875 .52825 -30 -4.5 ]
[.4875 .52825 0 4.5 ]
[.4875 .61337 -30 -4.5 ]
[.4875 .61337 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .1027 m
.11905 .10895 L
s
[(-4)] .11905 .0902 0 1 Mshowa
.30952 .1027 m
.30952 .10895 L
s
[(-2)] .30952 .0902 0 1 Mshowa
.69048 .1027 m
.69048 .10895 L
s
[(2)] .69048 .0902 0 1 Mshowa
.88095 .1027 m
.88095 .10895 L
s
[(4)] .88095 .0902 0 1 Mshowa
.125 Mabswid
.16667 .1027 m
.16667 .10645 L
s
.21429 .1027 m
.21429 .10645 L
s
.2619 .1027 m
.2619 .10645 L
s
.35714 .1027 m
.35714 .10645 L
s
.40476 .1027 m
.40476 .10645 L
s
.45238 .1027 m
.45238 .10645 L
s
.54762 .1027 m
.54762 .10645 L
s
.59524 .1027 m
.59524 .10645 L
s
.64286 .1027 m
.64286 .10645 L
s
.7381 .1027 m
.7381 .10645 L
s
.78571 .1027 m
.78571 .10645 L
s
.83333 .1027 m
.83333 .10645 L
s
.07143 .1027 m
.07143 .10645 L
s
.02381 .1027 m
.02381 .10645 L
s
.92857 .1027 m
.92857 .10645 L
s
.97619 .1027 m
.97619 .10645 L
s
.25 Mabswid
0 .1027 m
1 .1027 L
s
.5 .01759 m
.50625 .01759 L
s
[(-7.11)] .4875 .01759 1 0 Mshowa
.5 .18781 m
.50625 .18781 L
s
[(-7.09)] .4875 .18781 1 0 Mshowa
.5 .27292 m
.50625 .27292 L
s
[(-7.08)] .4875 .27292 1 0 Mshowa
.5 .35803 m
.50625 .35803 L
s
[(-7.07)] .4875 .35803 1 0 Mshowa
.5 .44314 m
.50625 .44314 L
s
[(-7.06)] .4875 .44314 1 0 Mshowa
.5 .52825 m
.50625 .52825 L
s
[(-7.05)] .4875 .52825 1 0 Mshowa
.5 .61337 m
.50625 .61337 L
s
[(-7.04)] .4875 .61337 1 0 Mshowa
.125 Mabswid
.5 .03461 m
.50375 .03461 L
s
.5 .05163 m
.50375 .05163 L
s
.5 .06865 m
.50375 .06865 L
s
.5 .08568 m
.50375 .08568 L
s
.5 .11972 m
.50375 .11972 L
s
.5 .13674 m
.50375 .13674 L
s
.5 .15376 m
.50375 .15376 L
s
.5 .17079 m
.50375 .17079 L
s
.5 .20483 m
.50375 .20483 L
s
.5 .22185 m
.50375 .22185 L
s
.5 .23888 m
.50375 .23888 L
s
.5 .2559 m
.50375 .2559 L
s
.5 .28994 m
.50375 .28994 L
s
.5 .30696 m
.50375 .30696 L
s
.5 .32399 m
.50375 .32399 L
s
.5 .34101 m
.50375 .34101 L
s
.5 .37505 m
.50375 .37505 L
s
.5 .39208 m
.50375 .39208 L
s
.5 .4091 m
.50375 .4091 L
s
.5 .42612 m
.50375 .42612 L
s
.5 .46017 m
.50375 .46017 L
s
.5 .47719 m
.50375 .47719 L
s
.5 .49421 m
.50375 .49421 L
s
.5 .51123 m
.50375 .51123 L
s
.5 .54528 m
.50375 .54528 L
s
.5 .5623 m
.50375 .5623 L
s
.5 .57932 m
.50375 .57932 L
s
.5 .59634 m
.50375 .59634 L
s
.5 .00056 m
.50375 .00056 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .55593 L
.10458 .50892 L
.14415 .4692 L
.18221 .435 L
.22272 .4029 L
.26171 .37617 L
.30316 .35222 L
.34309 .33348 L
.3815 .31945 L
.40095 .31385 L
.42237 .30884 L
.44268 .3052 L
.45178 .30393 L
.46172 .3028 L
.4671 .30229 L
.4721 .30189 L
.47727 .30154 L
.48196 .30129 L
.48658 .30109 L
.4887 .30102 L
.49093 .30096 L
.49332 .30091 L
.49438 .3009 L
.49552 .30088 L
.49675 .30087 L
.49789 .30086 L
.49859 .30086 L
.49925 .30086 L
.50049 .30086 L
.50163 .30086 L
.50286 .30087 L
.50401 .30088 L
.50508 .30089 L
.50754 .30093 L
.51014 .30099 L
.51268 .30107 L
.51504 .30115 L
.5204 .30141 L
.5293 .30199 L
.53882 .30285 L
.54906 .30404 L
.56016 .30565 L
.58032 .3094 L
.60019 .31415 L
.62123 .32032 L
.65912 .3344 L
.69946 .35359 L
.73829 .37616 L
.77956 .40459 L
Mistroke
.81932 .4363 L
.85757 .47083 L
.89827 .51195 L
.93745 .5558 L
.97619 .60332 L
Mfstroke
.02381 .53031 m
.06244 .48309 L
.10458 .43626 L
.14415 .39667 L
.18221 .3626 L
.22272 .33062 L
.26171 .30398 L
.30316 .28012 L
.34309 .26144 L
.3815 .24747 L
.40095 .24188 L
.42237 .23689 L
.44268 .23327 L
.45178 .232 L
.46172 .23087 L
.4671 .23037 L
.4721 .22996 L
.47727 .22962 L
.48196 .22937 L
.48658 .22917 L
.4887 .22911 L
.49093 .22905 L
.49332 .229 L
.49438 .22898 L
.49552 .22896 L
.49675 .22895 L
.49789 .22894 L
.49859 .22894 L
.49925 .22894 L
.50049 .22894 L
.50163 .22894 L
.50286 .22895 L
.50401 .22896 L
.50508 .22897 L
.50754 .22901 L
.51014 .22907 L
.51268 .22915 L
.51504 .22924 L
.5204 .22949 L
.5293 .23007 L
.53882 .23093 L
.54906 .23211 L
.56016 .23371 L
.58032 .23745 L
.60019 .24218 L
.62123 .24833 L
.65912 .26236 L
.69946 .28149 L
.73829 .30398 L
.77956 .3323 L
Mistroke
.81932 .3639 L
.85757 .39831 L
.89827 .43927 L
.93745 .48297 L
.97619 .53031 L
Mfstroke
.02381 .45757 m
.06244 .41052 L
.10458 .36385 L
.14415 .32441 L
.18221 .29046 L
.22272 .25859 L
.26171 .23205 L
.30316 .20827 L
.34309 .18967 L
.3815 .17574 L
.40095 .17018 L
.42237 .1652 L
.44268 .16159 L
.45178 .16033 L
.46172 .1592 L
.4671 .1587 L
.4721 .1583 L
.47727 .15796 L
.48196 .1577 L
.48658 .15751 L
.4887 .15744 L
.49093 .15738 L
.49332 .15733 L
.49438 .15732 L
.49552 .1573 L
.49675 .15729 L
.49789 .15728 L
.49859 .15728 L
.49925 .15728 L
.50049 .15728 L
.50163 .15728 L
.50286 .15729 L
.50401 .1573 L
.50508 .15731 L
.50754 .15735 L
.51014 .15741 L
.51268 .15749 L
.51504 .15757 L
.5204 .15782 L
.5293 .15841 L
.53882 .15926 L
.54906 .16044 L
.56016 .16203 L
.58032 .16576 L
.60019 .17048 L
.62123 .1766 L
.65912 .19058 L
.69946 .20964 L
.73829 .23205 L
.77956 .26027 L
Mistroke
.81932 .29175 L
.85757 .32604 L
.89827 .36685 L
.93745 .41039 L
.97619 .45757 L
Mfstroke
.02381 .38509 m
.06244 .33821 L
.10458 .29171 L
.14415 .25241 L
.18221 .21858 L
.22272 .18683 L
.26171 .16038 L
.30316 .13668 L
.34309 .11815 L
.3815 .10427 L
.40095 .09872 L
.42237 .09377 L
.44268 .09017 L
.45178 .08891 L
.46172 .08779 L
.4671 .08729 L
.4721 .08689 L
.47727 .08655 L
.48196 .0863 L
.48658 .08611 L
.4887 .08604 L
.49093 .08598 L
.49332 .08593 L
.49438 .08591 L
.49552 .0859 L
.49675 .08588 L
.49789 .08588 L
.49859 .08587 L
.49925 .08587 L
.50049 .08587 L
.50163 .08587 L
.50286 .08588 L
.50401 .08589 L
.50508 .0859 L
.50754 .08594 L
.51014 .086 L
.51268 .08608 L
.51504 .08617 L
.5204 .08641 L
.5293 .08699 L
.53882 .08784 L
.54906 .08902 L
.56016 .09061 L
.58032 .09432 L
.60019 .09902 L
.62123 .10513 L
.65912 .11906 L
.69946 .13805 L
.73829 .16038 L
.77956 .1885 L
Mistroke
.81932 .21987 L
.85757 .25403 L
.89827 .2947 L
.93745 .33808 L
.97619 .38509 L
Mfstroke
.02381 .31287 m
.06244 .26616 L
.10458 .21983 L
.14415 .18067 L
.18221 .14696 L
.22272 .11531 L
.26171 .08896 L
.30316 .06535 L
.34309 .04688 L
.3815 .03305 L
.40095 .02752 L
.42237 .02258 L
.44268 .019 L
.45178 .01775 L
.46172 .01663 L
.4671 .01613 L
.4721 .01573 L
.47727 .01539 L
.48196 .01514 L
.48658 .01495 L
.4887 .01488 L
.49093 .01482 L
.49332 .01477 L
.49438 .01476 L
.49552 .01474 L
.49675 .01473 L
.49789 .01472 L
.49859 .01472 L
.49925 .01472 L
.50049 .01472 L
.50163 .01472 L
.50286 .01473 L
.50401 .01474 L
.50508 .01475 L
.50754 .01479 L
.51014 .01485 L
.51268 .01492 L
.51504 .01501 L
.5204 .01526 L
.5293 .01584 L
.53882 .01668 L
.54906 .01786 L
.56016 .01944 L
.58032 .02314 L
.60019 .02782 L
.62123 .03391 L
.65912 .04779 L
.69946 .06671 L
.73829 .08896 L
.77956 .11698 L
Mistroke
.81932 .14824 L
.85757 .18228 L
.89827 .2228 L
.93745 .26603 L
.97619 .31287 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oU03oool2
000009@0oooo002D0?ooo`030000003oool0oooo09<0oooo002D0?ooo`030000003oool0oooo09<0
oooo001k0?ooo`030>ZjLP2Ke?l0oooo0080oooo00<0oooD09/00000L[X00P3oool0203oom@0V`00
000000000000001b0;[Zo`3oom@0V`000P0000000`000780^^[o0?ooo`020?ooo`030000003oool0
oooo09<0oooo001k0?ooo`030?ooe02KVm@0oooo00T0oooo00<0omBK07:jjP3oool00`3oool00`3o
e9/000000000000<000008h0oooo001l0?ooo`030=BKV`3Dool0oooo00L0oooo200000000`1b^^X0
oooo0?ooo`030?ooo`<000001@3oool9000008D0oooo001c0?ooo`030?oDV`000000000000800000
00H0VmCo0?ooo`3oool0oooo0?oDV`1b^^X40?ooo`@0000000<0oooo0?oDV`1b^^X0103oool00`3o
e9/0L[[Z0?ooo`040?ooo`030000003oool0oooo00h0oooo100000210?ooo`00N@3oool00`3oj[X0
LY_D00000006000000@0oooo00<0^W:K0=CDV`1b^^X00`3oool00`2jLY/0e=BK07:jjP050?ooo`03
0000003oool0oooo0180oooo1P00001k0?ooo`00MP3oool7000000030000V`3Dool0oooo00H0oooo
00<0omBK0000001b^^X00`3oool00`3oe9/0000007:jjP050?ooo`030000003oool0oooo01P0oooo
1@00001f0?ooo`00M03oool2000001h0oooo00<000000?ooo`3oool07@3oool3000007<0oooo001a
0?ooo`<00000803oool200000240oooo0`00001`0?ooo`00KP3oool3000002<0oooo00<000000?oo
o`3oool08`3oool3000006d0oooo001/0?ooo`8000009P3oool00`000000oooo0?ooo`0V0?ooo`80
0000J`3oool006T0oooo0`00000X0?ooo`030000003oool0oooo02P0oooo0`00001X0?ooo`00IP3o
ool3000002/0oooo00<000000?ooo`3oool0:`3oool3000006D0oooo001T0?ooo`800000;P3oool2
000002l0oooo0P00001S0?ooo`00HP3oool200000300oooo00<000000?ooo`3oool0<03oool20000
0640oooo001O0?ooo`<00000<P3oool00`000000oooo0?ooo`0b0?ooo`<00000GP3oool002L0oooo
00@0j[Yb000000000780^^[o<P3oool4000000030000V`3Dool0oooo0300oooo00<000000?ooo`3o
ool0<P3oool00`3oe9/0000000000002000000030=Coo`3oool0oooo0340oooo00@0j[Yb00000000
0780^^[o903oool002P0oooo00<0omBK07:jjP3oool0<03oool2000000040?ooo`2jLP00002K0=Co
oc<0oooo00<000000?ooo`3oool0<`3oool0102jLP00002K0=Coo`3oool2000003<0oooo00<0omBK
07:jjP3oool0903oool002D0oooo00H0oooD09/00000000000000000LP2jj_l^0?ooo`800000103o
ool00`3oe9/0000009_Do`0b0?ooo`800000=@3oool00`3oe9/0000009_Do`020?ooo`800000;P3o
ool01P3oom@0V`00000000000000001b0;[Zob@0oooo000O0?ooo`030?oDV`000000000000800000
00H0VmCo0?ooo`3DV`00VmCo0?oDV`1b^^X]0?ooo`D0000000H0VmCo0?ooo`3oool0oooo0?ooe03D
e?lb0?ooo`030000003oool0oooo03D0oooo00<0oooD0=CDo`3oool00`3oool00`000000oooo0?oo
o`0/0?ooo`040=BK002Ke?l0omBK07:jjRD0oooo000V0?ooo`040?ooe02K0780^[ZK07:jjR`0oooo
00<000000?ooo`3oool0103oool01P3oj[X0LW:j0?ooo`3oom@0V`2K0=Cooc40oooo00<000000?oo
o`3oool0<P3oool01P3oj[X0LW:j0?ooo`3oom@0V`2K0=Coo`@0oooo0P00000/0?ooo`040?ooe02K
0780^[ZK07:jjRD0oooo000W0?ooo`030?oZ^P1b0000L[[Z02X0oooo0P0000080?ooo`040>ZjLP00
0000000007:jjS80oooo00<000000?ooo`3oool0<`3oool0103Z^W8000000000001b^^X70?ooo`80
0000:`3oool00`3oj[X0LP0007:jjP0U0?ooo`00DP3oool200000400oooo00<000000?ooo`3oool0
@03oool00`000000oooo0?ooo`1@0?ooo`00D03oool2000003T0oooo5000000i0?ooo`800000D03o
ool004l0oooo00<000000?ooo`3oool0<03oool9000000T0oooo00<000000?ooo`3oool0203oool9
00000380oooo00<000000?ooo`3oool0C@3oool004d0oooo0P00000^0?ooo`D000004P3oool00`00
0000oooo0?ooo`0A0?ooo`<00000<03oool2000004d0oooo001<0?ooo`030000003oool0oooo02X0
oooo1000000G0?ooo`030000003oool0oooo01@0oooo1000000^0?ooo`030000003oool0oooo04X0
oooo001:0?ooo`800000:@3oool4000001/0oooo00<000000?ooo`3oool0603oool5000002X0oooo
0P00001:0?ooo`000P3ooooo000002H000000`3oool000T0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`030?ooo`8000001P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool00`0000080?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0103oool3000000@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0203oool002D0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0D0?oo
o`030000003oool0oooo00`0oooo0P00000V0?ooo`030000003oool0oooo02<0oooo0`00000?0?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0T0?oo
o`00A03oool2000002<0oooo0`00000X0?ooo`030000003oool0oooo02H0oooo0P00000U0?ooo`80
0000A03oool004<0oooo00<000000?ooo`3oool08@3oool2000002/0oooo00<000000?ooo`3oool0
:03oool3000002@0oooo00<000000?ooo`3oool0@@3oool00480oooo00<000000?ooo`3oool0803o
ool2000002d0oooo0P00000/0?ooo`<000008P3oool00`000000oooo0?ooo`100?ooo`00@03oool2
00000240oooo0P00000_0?ooo`030000003oool0oooo02h0oooo0P00000Q0?ooo`800000@03oool0
03l0oooo00<000000?ooo`3oool07`3oool200000340oooo00<000000?ooo`3oool0<03oool20000
0240oooo00<000000?ooo`3oool0?@3oool003h0oooo00<000000?ooo`3oool07P3oool2000003<0
oooo00<000000?ooo`3oool0<P3oool3000001l0oooo00<000000?ooo`3oool0?03oool003d0oooo
00<000000?ooo`3oool07@3oool2000003D0oooo00<000000?ooo`3oool0=@3oool2000001h0oooo
0P00000l0?ooo`00?03oool00`000000oooo0?ooo`0L0?ooo`800000=`3oool2000003P0oooo0P00
000N0?ooo`030000003oool0oooo03T0oooo000j0?ooo`8000007@3oool2000003T0oooo00<00000
0?ooo`3oool0>@3oool2000001d0oooo00<000000?ooo`3oool0>03oool003T0oooo00<000000?oo
o`3oool06`3oool2000003/0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0K0?oo
o`800000>03oool003P0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0k0?ooo`03
0000003oool0oooo03`0oooo0P00000M0?ooo`030000003oool0oooo03D0oooo000g0?ooo`030000
003oool0oooo01X0oooo0P00000n0?ooo`030000003oool0oooo03h0oooo0P00000L0?ooo`030000
003oool0oooo03@0oooo000f0?ooo`030000003oool0oooo01T0oooo0P0000100?ooo`800000@@3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo03<0oooo000d0?ooo`8000006P3oool2
000003H0oooo6P00000f0?ooo`8000006`3oool00`000000oooo0?ooo`0b0?ooo`00<`3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo0300oooo1P00000<0?ooo`030000003oool0oooo
00/0oooo1`00000a0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0<@3oool00380
oooo00<000000?ooo`3oool0603oool2000002h0oooo1@00000B0?ooo`030000003oool0oooo0180
oooo1@00000]0?ooo`8000006P3oool200000340oooo000a0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0:P3oool4000001L0oooo00<000000?ooo`3oool05`3oool3000002`0oooo
00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0^0?ooo`00<03oool00`000000oooo0?oo
o`0G0?ooo`800000:@3oool4000001/0oooo0P00000K0?ooo`<00000:P3oool2000001X0oooo00<0
00000?ooo`3oool0;@3oool002h0oooo0P00000I0?ooo`030000003oool0oooo02D0oooo1000000O
0?ooo`030000003oool0oooo01d0oooo0`00000Y0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0;03oool002d0oooo00<000000?ooo`3oool05`3oool2000002D0oooo0`00000S0?oo
o`030000003oool0oooo0200oooo0`00000W0?ooo`8000006@3oool00`000000oooo0?ooo`0[0?oo
o`00;03oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo02<0oooo0P00000=0?ooo`03
0>ZjLP2Ke?l0oooo0080oooo00<0oooD09/00000L[X00`3oool0103Z^W8000000000001b^^X20?oo
o`040;Yb00000000000007:jjP@0oooo00<000000?ooo`3oool08`3oool3000002H0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0Z0?ooo`00:`3oool00`000000oooo0?ooo`0F0?oo
o`8000008`3oool3000000l0oooo00<0oooD09^Ke03oool0203oool01@2jVkX0oooo0?ooo`2jLY/0
e?oo00@0oooo00<0^W:K0=Coo`3oool00P3oool00`000000oooo0?ooo`0V0?ooo`8000009@3oool2
000001P0oooo00<000000?ooo`3oool0:@3oool002X0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`0Q0?ooo`8000004`3oool00`3DVi/0e?oo0?ooo`060?ooo`080?ooe02KL[X0oooo
0?ooo`3DVg80^^[o0?ooo`3oe9/30000000409_Do`3oool0oooo0?ooo`<00000:03oool3000002@0
oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo
0?ooo`0F0?ooo`030000003oool0oooo0200oooo0P00000<0?ooo`030?oDV`000000000000800000
00H0VmCo0?ooo`3oool0oooo0?oDV`1b^^X70?ooo`0<0?ooe02KL[X0oooo0?ooo`3DVg80^^[o0?oo
e02K09/0e?oo0?ooo`3Z^W80VmCo0`3oool00`000000oooo0?ooo`0[0?ooo`<000008P3oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo02L0oooo000X0?ooo`030000003oool0oooo01D0
oooo0P00000Q0?ooo`800000503oool01@3oj[X0LY_D0?ooo`3oom@0Vg:j00P0oooo00/0^W9b0;[Z
o`3oom@0V`2K0=Coo`3oom@0V`2K0=Coo`3oool0^W:K0=Coo`030?ooo`030000003oool0oooo02h0
oooo0P00000Q0?ooo`8000005`3oool00`000000oooo0?ooo`0V0?ooo`009`3oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo01l0oooo0P00000F0?ooo`060?oZ^P1b0000000000000000
09/0e?oo1`3oool0103oj[X0LP000000002Ke?l20?ooo`040?oDV`000000000007:jjP@0oooo00<0
00000?ooo`3oool0<03oool200000240oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`0U0?ooo`009P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo01h0oooo0P00000c
0?ooo`030000003oool0oooo0380oooo0`00000O0?ooo`030000003oool0oooo01D0oooo00<00000
0?ooo`3oool0903oool002D0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0M0?oo
o`800000=@3oool2000003H0oooo0P00000N0?ooo`8000005P3oool00`000000oooo0?ooo`0S0?oo
o`00903oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo01`0oooo0P00000g0?ooo`03
0000003oool0oooo03L0oooo0P00000N0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3o
ool08P3oool002<0oooo00<000000?ooo`3oool0503oool2000001d0oooo0P00000i0?ooo`030000
003oool0oooo03T0oooo0P00000M0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0
8@3oool00280oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0K0?ooo`800000>`3o
ool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo01/0oooo0P00000E0?ooo`030000003o
ool0oooo0200oooo000Q0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool06`3oool0
0`000000oooo0?ooo`0k0?ooo`030000003oool0oooo03`0oooo0P00000M0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool07`3oool00200oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0J0?ooo`800000?P3oool2000003l0oooo0P00000L0?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool07P3oool001l0oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`0I0?ooo`800000@03oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0M0?ooo`007P3oool00`000000oooo
0?ooo`0C0?ooo`8000006P3oool2000003H0oooo6P00000f0?ooo`8000006`3oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo01`0oooo000N0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`0`0?ooo`H00000303oool00`000000oooo0?oo
o`0;0?ooo`L00000<@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool06`3oool001d0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0H
0?ooo`800000;P3oool500000180oooo00<000000?ooo`3oool04P3oool5000002d0oooo0P00000J
0?ooo`8000004`3oool00`000000oooo0?ooo`0K0?ooo`00703oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo01L0oooo0P00000/0?ooo`@000005`3oool2000001P0oooo0`00000/0?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0J0?oo
o`006`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0:03oool4000001/0oooo00<000000?ooo`3oool06P3oool4000002T0oooo0P00000J0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool06@3oool001X0oooo00<000000?ooo`3oool0
4@3oool2000001P0oooo0P00000W0?ooo`@000007`3oool00`000000oooo0?ooo`0N0?ooo`D00000
9P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
603oool001T0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0F0?ooo`8000009P3o
ool3000002<0oooo00<000000?ooo`3oool08`3oool2000002D0oooo0P00000I0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool05`3oool001P0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0E0?ooo`8000009P3oool2000002H0oooo00<000000?ooo`3oool09@3oool2
000002D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo01H0oooo000H0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool05@3oool00`00
0000oooo0?ooo`0S0?ooo`<00000:03oool2000002P0oooo0P00000T0?ooo`800000603oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo01H0oooo000G0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0R0?ooo`800000:`3oool00`000000
oooo0?ooo`0Y0?ooo`800000903oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo0240oooo0P00000]0?ooo`030000003oool0oooo02/0oooo
0`00000R0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0D0?ooo`005@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool0803oool2000001H0oooo00<0j[Yb09_Do`3oool00P3oool00`3oom@0V`00001b
^P030?ooo`040>ZjLP000000000007:jjP80oooo00@0e9/0000000000000L[[Z103oool00`000000
oooo0?ooo`0^0?ooo`8000008@3oool2000001L0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0C0?ooo`00503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool07`3oool2000001P0oooo00<0oooD09^Ke03oool0203oool01`2jVkX0oooo
0?ooo`2jLY/0e?oo0?ooe02KVm@00P3oool00`2jVkX0oooo0?ooo`020?ooo`030000003oool0oooo
0300oooo0P00000Q0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0B0?ooo`004`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01@0
oooo0P00000P0?ooo`8000006`3oool00`3DVi/0e?oo0?ooo`060?ooo`0;0?ooe02KL[X0oooo0?oo
o`3DVg80^^[o0?ooo`2jVkX0oooo0?ooe02KVm@0103oool300000380oooo0`00000O0?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`004P3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool07P3o
ool2000001@0oooo00<0omBK0000000000000P0000001P2Ke?l0oooo0?ooo`3oool0omBK07:jjPL0
oooo00P0oooD09]b^P3oool0oooo0=BKLP2jj_l0oooo0=BK0080000000<0L[[Z0?ooo`3oool00P3o
ool00`000000oooo0?ooo`0e0?ooo`8000007P3oool2000001H0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0@0?ooo`004@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool07@3oool2000001`0oooo00D0onZj07:Ke03oool0oooD09]b
^P080?ooo`0:0;YbLP2jj_l0oooD09/0V`3Dool0oooD09]b^P3oool0oooD09]b^P@0oooo00<00000
0?ooo`3oool0=`3oool2000001h0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo0100oooo000@0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`0L0?ooo`8000007P3oool01P3oj[X0LP00000000000000
002K0=Coo`L0oooo00@0onZj078000000000VmCo0P3oool0103Z^W8000000000002Ke?l40?ooo`03
0000003oool0oooo03T0oooo0P00000M0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`0?0?ooo`003`3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool06`3oool2000003/0oooo00<000000?ooo`3oool0
>`3oool00`000000oooo0?ooo`0K0?ooo`8000005@3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00h0oooo000?0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo03/0oooo0P00000m0?ooo`8000007@3o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03@3o
ool000h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo01X0oooo0P00000n0?ooo`030000003oool0oooo03h0oooo0P00000L0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0<0?ooo`003@3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool06@3oool20000
0400oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0;0?ooo`00303oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo01<0oooo0P00000J0?ooo`800000=P3ooolJ000003H0
oooo0P00000K0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0;0?ooo`002`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0`0?ooo`H00000303oool00`000000oooo
0?ooo`0;0?ooo`L00000<@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01<0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0:0?ooo`002P3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0603oool2000002h0oooo1@00
000B0?ooo`8000004`3oool5000002d0oooo0P00000J0?ooo`8000004`3oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo00T0oooo00090?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool04P3oool00`000000oooo0?ooo`0G0?ooo`800000;03oool4000001L0oooo00<00000
0?ooo`3oool05`3oool3000002`0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0203oool001/0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo02P0oooo1000000K0?oo
o`030000003oool0oooo01X0oooo1000000Y0?ooo`8000006P3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo01T0oooo000J0?ooo`030000003oool0oooo0140oooo0P00000H0?ooo`80
00009`3oool4000001l0oooo00<000000?ooo`3oool07P3oool5000002H0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01P0oooo000I0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool05P3oool2000002H0oooo0`00000S0?ooo`030000
003oool0oooo02<0oooo0P00000U0?ooo`8000006@3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo01L0oooo000H0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool05@3o
ool2000002H0oooo0P00000V0?ooo`8000009P3oool2000002D0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01H0oooo000H0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0S0?ooo`<00000:03oool0
0`000000oooo0?ooo`0W0?ooo`800000903oool2000001P0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0F0?ooo`005`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool08P3oool2000002/0oooo00<000000?ooo`3oool0:@3oool20000
02@0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
01D0oooo000F0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`0Q0?ooo`800000;@3oool00`000000oooo0?ooo`0[0?ooo`<000008P3oool00`000000
oooo0?ooo`0F0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0503oool001D0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0200oooo
0P00000_0?ooo`030000003oool0oooo02h0oooo0P00000Q0?ooo`8000005`3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo01<0oooo000D0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool05@3oool00`000000oooo0?ooo`0O0?ooo`800000<@3oool200000340oooo0P00
000Q0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0B0?ooo`004`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01@0oooo0P00000P
0?ooo`800000<`3oool00`000000oooo0?ooo`0b0?ooo`<000007`3oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00180oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01h0oooo0P00000L0?oo
o`030>ZjLP2Ke?l0oooo0080oooo00<0oooD09/00000L[X00`3oool0103Z^W8000000000001b^^X3
0?ooo`030>ZjLP2Ke?l0oooo00@0oooo00<000000?ooo`3oool0=@3oool2000001h0oooo0P00000F
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00140oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01d0oooo0P00000N0?oo
o`030?ooe02KVm@0oooo00P0oooo00D0^Y^j0?ooo`3oool0^W:K0=Coo`020?ooo`030?ooe02KVm@0
oooo00@0oooo00<000000?ooo`3oool0=`3oool2000001h0oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0100oooo000@0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0L0?ooo`8000008@3oool00`3D
Vi/0e?oo0?ooo`060?ooo`060?ooe02KL[X0oooo0?ooo`3DVg80^^[o0`3oool00`3DVi/0e?oo0?oo
o`030?ooo`<00000>@3oool2000001d0oooo00<000000?ooo`3oool0503oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo00l0oooo000?0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`0K0?ooo`8000006P3oool00`3oe9/0000000000002
0000000609_Do`3oool0oooo0?ooo`3oe9/0L[[Z1`3oool01P3oom@0Vg:j0?ooo`3oool0e9]b0;[Z
o`<0oooo00<0omBK07:jjP3oool00`3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo
01/0oooo0P00000E0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03P3oool000l0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool0803oool01@3oj[X0LY_D0?ooo`3oom@0Vg:j00P0oooo00X0^W9b0;[Z
o`3oom@0V`2K0=Coo`3oj[X0LY_D0?ooo`3oom@0Vg:j103oool00`000000oooo0?ooo`0l0?ooo`80
00007@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool03@3oool000h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo01X0oooo0P00000S0?ooo`060?oZ^P1b000000000000000009/0e?oo1`3oool01`3o
j[X0LP000000002Ke?l0oooo0?oZ^P1b00000P0000000`0009/0e?oo0?ooo`020?ooo`030000003o
ool0oooo03h0oooo0P00000L0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`0<0?ooo`003@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool06@3oool200000400oooo00<000000?ooo`3oool0@03oool0
0`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`0;0?ooo`00303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
01<0oooo0P00000J0?ooo`800000@P3oool200000480oooo0P00000K0?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0;0?ooo`002`3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`120?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool02P3oool000X0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01P0oooo
0P0000150?ooo`030000003oool0oooo04@0oooo0P00000J0?ooo`8000004`3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo00T0oooo00090?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo04D0oooo00<0
00000?ooo`3oool0AP3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`080?ooo`006`3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo01L0oooo0P0000180?ooo`030000003oool0oooo04L0oooo0P00000J
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool06@3oool001X0oooo00<000000?oo
o`3oool04@3oool2000001T0oooo00<000000?ooo`3oool0B03oool2000004X0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01P0oooo000I0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool05`3oool2000004/0oooo00<000000?ooo`3o
ool0BP3oool2000001T0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`00
603oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
B`3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0F0?ooo`00603oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo01H0oooo0P00001>0?ooo`030000003oool0oooo04d0oooo0P00000H0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool05P3oool001L0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool0C`3oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool05@3oool0
01H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo
04l0oooo0P00001A0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0D0?ooo`005@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01D0
oooo0P00001B0?ooo`030000003oool0oooo0540oooo0P00000G0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool04`3oool001@0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0D`3oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04P3oool001<0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo05<0oooo00<0
00000?ooo`3oool0E03oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool04@3oool00180oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0E@3oool2000001H0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0A0?ooo`004P3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo01D0oooo00<000000?ooo`3oool0E@3oool2000005P0oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0100oooo000A0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0503oool2000005P0oooo00<000000?ooo`3o
ool0F03oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool03`3oool00100oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo05P0oooo00<000000?ooo`3oool0F@3oool2000001D0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0>0?ooo`003`3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool0@03oool00`3Z^W80VmCo0?ooo`020?ooo`030?ooe02K
000007:j00<0oooo00@0j[Yb000000000000L[[Z0P3oool01@3oom@0V`00000000000780^^[o00<0
oooo00<000000?ooo`3oool0F`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03P3oool000h0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0D0?ooo`030000003oool0oooo0440oooo00<0oooD09^Ke03oool0203oool02`2jVkX0oooo
0?ooo`2jLY/0e?oo0?ooo`3DV`00VmCo0?ooo`3oom@0e=Co00<0oooo00<000000?ooo`3oool0G03o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3o
ool000d0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo04<0oooo00<0e9^K0=Coo`3oool01P3oool0303oom@0Vg:j0?ooo`3oool0e9]b0;[Zo`3oom@0
V`0007:jjP3oool0j[Yb09_Do`<0oooo0`00001M0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0<0?ooo`00303oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo01<0oooo0P00000m0?ooo`030?oDV`00000000000080000000H0VmCo0?oo
o`3oool0oooo0?oDV`1b^^X70?ooo`0;0?ooe02KL[X0oooo0?ooo`3DVg80^^[o0?ooo`2jLY/0LW80
00000000L[X0103oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0;0?ooo`00303oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool0@`3oool01@3oj[X0LY_D0?ooo`3oom@0
Vg:j00P0oooo00P0^W9b0;[Zo`3oom@0V`2K0=Coo`3oool0omBK001b^PH0oooo00<000000?ooo`3o
ool0G`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool02P3oool000/0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo04@0oooo00H0onZj07800000000000000000V`3Dool70?ooo`040?oZ^P1b00000000
09_Do`<0oooo00@0j[Yb000000000000VmCo0`3oool00`000000oooo0?ooo`1P0?ooo`8000004`3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00X0oooo000:0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`1P0?ooo`030000003oool0
oooo0680oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00T0oooo00090?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`1Q0?ooo`800000I03oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool0203oool001X0oooo00<000000?ooo`3oool04@3oool2000006@0
oooo00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01P0
oooo000I0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0I03oool00`000000oooo
0?ooo`1U0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool05`3oool001P0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`1U0?ooo`030000003oool0oooo06H0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0F0?ooo`00603oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo01H0oooo000G0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0I`3oool2000006T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3o
ool0J@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`1Z0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool04`3oool001@0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0B0?ooo`004`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo06/0oooo00<000000?ooo`3oool0K03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0140oooo000B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0J`3oool20000
06h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0A0?ooo`004P3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0KP3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo0100oooo000A0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool03`3oool00100oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`1^0?ooo`030000003oool0oooo0700oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0>0?ooo`003`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo06l0oooo00<00000
0?ooo`3oool0L@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo000>0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0L03oool2000007<0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`003@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0740oooo00<000000?ooo`3oool0L`3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00`0oooo000<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
LP3oool00`000000oooo0?ooo`1d0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
2`3oool000`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`1J0?ooo`030>ZjLP2K
e?l0oooo0080oooo00<0oooD09/00000L[X00`3oool0103Z^W8000000000001b^^X20?ooo`040>Zj
LP000000000007:jjP@0oooo00<000000?ooo`3oool0M@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00X0oooo000;0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
F`3oool00`3oom@0Vi_D0?ooo`080?ooo`070;ZK^P3oool0oooo0;YbV`3Dool0onZj079b^P020?oo
o`030;YbLP2jj_l0oooo0080oooo00<000000?ooo`3oool0M@3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00X0oooo000:0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool0G@3oool00`3DVi/0e?oo0?ooo`060?ooo`060?ooe02KL[X0oooo0?ooo`3DVg80^^[o103oool0
0`3DVg80^^[o0?ooo`020?ooo`<00000MP3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00T0oooo00090?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0E@3oool00`3o
e9/00000000000020000000609_Do`3oool0oooo0?ooo`3oe9/0L[[Z1`3oool0203oom@0Vg:j0?oo
o`3oool0e9]b0;[Zo`3oool0e9/00P0000000`00Vm@0oooo0?ooo`020?ooo`030000003oool0oooo
07L0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`080?ooo`006`3oool00`000000
oooo0?ooo`1K0?ooo`050?oZ^P1bVm@0oooo0?ooe02KL[X0203oool0202jLW80^^[o0?ooe02K09/0
e?oo0?ooo`3DVg80^^[o1P3oool00`000000oooo0?ooo`1h0?ooo`030000003oool0oooo01P0oooo
000J0?ooo`030000003oool0oooo05`0oooo00H0onZj07800000000000000000V`3Dool70?ooo`04
0?oZ^P1b0000000009_Do`80oooo00@0e9/000000000000009_D103oool00`000000oooo0?ooo`1i
0?ooo`030000003oool0oooo01L0oooo000I0?ooo`030000003oool0oooo07P0oooo00<000000?oo
o`3oool0NP3oool00`000000oooo0?ooo`0F0?ooo`00603oool00`000000oooo0?ooo`1i0?ooo`80
0000N`3oool00`000000oooo0?ooo`0F0?ooo`005`3oool00`000000oooo0?ooo`1j0?ooo`030000
003oool0oooo07/0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0N`3o
ool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0
oooo07`0oooo00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`0C0?ooo`00503oool00`00
0000oooo0?ooo`1m0?ooo`030000003oool0oooo07h0oooo00<000000?ooo`3oool04P3oool001<0
oooo00<000000?ooo`3oool0OP3oool200000800oooo00<000000?ooo`3oool04@3oool00180oooo
00<000000?ooo`3oool0O`3oool00`000000oooo0?ooo`1o0?ooo`030000003oool0oooo0140oooo
000B0?ooo`030000003oool0oooo07l0oooo00<000000?ooo`3oool0P03oool00`000000oooo0?oo
o`0@0?ooo`004@3oool00`000000oooo0?ooo`200?ooo`030000003oool0oooo0840oooo00<00000
0?ooo`3oool03`3oool00100oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`220?oo
o`030000003oool0oooo00h0oooo000?0?ooo`030000003oool0oooo0880oooo0P0000230?ooo`03
0000003oool0oooo00h0oooo000>0?ooo`030000003oool0oooo08<0oooo00<000000?ooo`3oool0
P`3oool00`000000oooo0?ooo`0=0?ooo`003@3oool00`000000oooo0?ooo`240?ooo`030000003o
ool0oooo08@0oooo00<000000?ooo`3oool0303oool000`0oooo00<000000?ooo`3oool0Q@3oool0
0`000000oooo0?ooo`250?ooo`030000003oool0oooo00/0oooo000<0?ooo`030000003oool0oooo
08D0oooo00<000000?ooo`3oool0QP3oool00`000000oooo0?ooo`0:0?ooo`002`3oool00`000000
oooo0?ooo`260?ooo`800000Q`3oool00`000000oooo0?ooo`0:0?ooo`002P3oool00`000000oooo
0?ooo`270?ooo`030000003oool0oooo08L0oooo00<000000?ooo`3oool02@3oool000T0oooo00<0
00000?ooo`3oool0R03oool00`000000oooo0?ooo`280?ooo`030000003oool0oooo00P0oooo001k
0?ooo`030>ZjLP2Ke?l0oooo0080oooo00<0oooD09/00000L[X00`3oool0103Z^W8000000000001b
^^X30?ooo`040>ZjLP000000001b0;[Zo`<0oooo00<000000?ooo`3oool0T`3oool007/0oooo00<0
oooD09^Ke03oool0203oool01@2jVkX0oooo0?ooo`2jLY/0e?oo00<0oooo00<0omBK07:jjP3oool0
0`3oool00`000000oooo0?ooo`2C0?ooo`00O03oool00`3DVi/0e?oo0?ooo`060?ooo`080?ooe02K
L[X0oooo0?ooo`3DVg80^^[o0?ooe02K0002000000030000LP2jj_l0oooo0080oooo0`00002C0?oo
o`00L`3oool00`3oe9/00000000000020000000609_Do`3oool0oooo0?ooo`3oe9/0L[[Z1`3oool0
2`3oom@0Vg:j0?ooo`3oool0e9]b0;[Zo`3oool0e9/009_Do`3oe9/0L[[Z00@0oooo00<000000?oo
o`3oool0T`3oool007T0oooo00D0onZj07:Ke03oool0oooD09]b^P080?ooo`0:0;YbLP2jj_l0oooD
09/0V`3Dool0oooo0?ooe02K0780^[ZK07:jjYX0oooo001i0?ooo`060?oZ^P1b0000000000000000
09/0e?oo1`3oool0103oj[X0LP000000002Ke?l30?ooo`030?oZ^P1b0000L[[Z09X0oooo003o0?oo
ob/0oooo0000\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {228.438, 81.875}} -> {-11.5384, \
-7.07079, 0.0360399, 0.000403281}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["k2=Plot[Evaluate[t2],{x,-5,5}]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 -59.9136 8.51112 [
[.11905 .50284 -6 -9 ]
[.11905 .50284 6 0 ]
[.30952 .50284 -6 -9 ]
[.30952 .50284 6 0 ]
[.69048 .50284 -3 -9 ]
[.69048 .50284 3 0 ]
[.88095 .50284 -3 -9 ]
[.88095 .50284 3 0 ]
[.4875 .00467 -24 -4.5 ]
[.4875 .00467 0 4.5 ]
[.4875 .08978 -24 -4.5 ]
[.4875 .08978 0 4.5 ]
[.4875 .17489 -24 -4.5 ]
[.4875 .17489 0 4.5 ]
[.4875 .26 -24 -4.5 ]
[.4875 .26 0 4.5 ]
[.4875 .34511 -24 -4.5 ]
[.4875 .34511 0 4.5 ]
[.4875 .43022 -24 -4.5 ]
[.4875 .43022 0 4.5 ]
[.4875 .60045 -24 -4.5 ]
[.4875 .60045 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .51534 m
.11905 .52159 L
s
[(-4)] .11905 .50284 0 1 Mshowa
.30952 .51534 m
.30952 .52159 L
s
[(-2)] .30952 .50284 0 1 Mshowa
.69048 .51534 m
.69048 .52159 L
s
[(2)] .69048 .50284 0 1 Mshowa
.88095 .51534 m
.88095 .52159 L
s
[(4)] .88095 .50284 0 1 Mshowa
.125 Mabswid
.16667 .51534 m
.16667 .51909 L
s
.21429 .51534 m
.21429 .51909 L
s
.2619 .51534 m
.2619 .51909 L
s
.35714 .51534 m
.35714 .51909 L
s
.40476 .51534 m
.40476 .51909 L
s
.45238 .51534 m
.45238 .51909 L
s
.54762 .51534 m
.54762 .51909 L
s
.59524 .51534 m
.59524 .51909 L
s
.64286 .51534 m
.64286 .51909 L
s
.7381 .51534 m
.7381 .51909 L
s
.78571 .51534 m
.78571 .51909 L
s
.83333 .51534 m
.83333 .51909 L
s
.07143 .51534 m
.07143 .51909 L
s
.02381 .51534 m
.02381 .51909 L
s
.92857 .51534 m
.92857 .51909 L
s
.97619 .51534 m
.97619 .51909 L
s
.25 Mabswid
0 .51534 m
1 .51534 L
s
.5 .00467 m
.50625 .00467 L
s
[(7.04)] .4875 .00467 1 0 Mshowa
.5 .08978 m
.50625 .08978 L
s
[(7.05)] .4875 .08978 1 0 Mshowa
.5 .17489 m
.50625 .17489 L
s
[(7.06)] .4875 .17489 1 0 Mshowa
.5 .26 m
.50625 .26 L
s
[(7.07)] .4875 .26 1 0 Mshowa
.5 .34511 m
.50625 .34511 L
s
[(7.08)] .4875 .34511 1 0 Mshowa
.5 .43022 m
.50625 .43022 L
s
[(7.09)] .4875 .43022 1 0 Mshowa
.5 .60045 m
.50625 .60045 L
s
[(7.11)] .4875 .60045 1 0 Mshowa
.125 Mabswid
.5 .02169 m
.50375 .02169 L
s
.5 .03871 m
.50375 .03871 L
s
.5 .05574 m
.50375 .05574 L
s
.5 .07276 m
.50375 .07276 L
s
.5 .1068 m
.50375 .1068 L
s
.5 .12382 m
.50375 .12382 L
s
.5 .14085 m
.50375 .14085 L
s
.5 .15787 m
.50375 .15787 L
s
.5 .19191 m
.50375 .19191 L
s
.5 .20894 m
.50375 .20894 L
s
.5 .22596 m
.50375 .22596 L
s
.5 .24298 m
.50375 .24298 L
s
.5 .27702 m
.50375 .27702 L
s
.5 .29405 m
.50375 .29405 L
s
.5 .31107 m
.50375 .31107 L
s
.5 .32809 m
.50375 .32809 L
s
.5 .36214 m
.50375 .36214 L
s
.5 .37916 m
.50375 .37916 L
s
.5 .39618 m
.50375 .39618 L
s
.5 .4132 m
.50375 .4132 L
s
.5 .44725 m
.50375 .44725 L
s
.5 .46427 m
.50375 .46427 L
s
.5 .48129 m
.50375 .48129 L
s
.5 .49831 m
.50375 .49831 L
s
.5 .53236 m
.50375 .53236 L
s
.5 .54938 m
.50375 .54938 L
s
.5 .5664 m
.50375 .5664 L
s
.5 .58342 m
.50375 .58342 L
s
.5 .61747 m
.50375 .61747 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .06211 L
.10458 .10911 L
.14415 .14884 L
.18221 .18303 L
.22272 .21513 L
.26171 .24187 L
.30316 .26582 L
.34309 .28456 L
.3815 .29858 L
.40095 .30419 L
.42237 .3092 L
.44268 .31283 L
.45178 .3141 L
.46172 .31524 L
.4671 .31575 L
.4721 .31615 L
.47727 .3165 L
.48196 .31675 L
.48658 .31694 L
.4887 .31701 L
.49093 .31707 L
.49332 .31712 L
.49438 .31714 L
.49552 .31715 L
.49675 .31717 L
.49789 .31717 L
.49859 .31718 L
.49925 .31718 L
.50049 .31718 L
.50163 .31718 L
.50286 .31717 L
.50401 .31716 L
.50508 .31714 L
.50754 .3171 L
.51014 .31704 L
.51268 .31697 L
.51504 .31688 L
.5204 .31663 L
.5293 .31604 L
.53882 .31518 L
.54906 .31399 L
.56016 .31239 L
.58032 .30864 L
.60019 .30389 L
.62123 .29771 L
.65912 .28363 L
.69946 .26444 L
.73829 .24187 L
.77956 .21345 L
Mistroke
.81932 .18173 L
.85757 .1472 L
.89827 .10609 L
.93745 .06223 L
.97619 .01472 L
Mfstroke
.02381 .08772 m
.06244 .13494 L
.10458 .18178 L
.14415 .22136 L
.18221 .25543 L
.22272 .28742 L
.26171 .31405 L
.30316 .33792 L
.34309 .35659 L
.3815 .37056 L
.40095 .37615 L
.42237 .38114 L
.44268 .38476 L
.45178 .38603 L
.46172 .38716 L
.4671 .38767 L
.4721 .38807 L
.47727 .38842 L
.48196 .38867 L
.48658 .38886 L
.4887 .38893 L
.49093 .38899 L
.49332 .38904 L
.49438 .38905 L
.49552 .38907 L
.49675 .38908 L
.49789 .38909 L
.49859 .38909 L
.49925 .3891 L
.50049 .3891 L
.50163 .38909 L
.50286 .38909 L
.50401 .38908 L
.50508 .38906 L
.50754 .38902 L
.51014 .38896 L
.51268 .38888 L
.51504 .3888 L
.5204 .38855 L
.5293 .38796 L
.53882 .38711 L
.54906 .38592 L
.56016 .38432 L
.58032 .38059 L
.60019 .37585 L
.62123 .3697 L
.65912 .35567 L
.69946 .33655 L
.73829 .31406 L
.77956 .28574 L
Mistroke
.81932 .25414 L
.85757 .21973 L
.89827 .17877 L
.93745 .13507 L
.97619 .08772 L
Mfstroke
.02381 .16047 m
.06244 .20752 L
.10458 .25418 L
.14415 .29362 L
.18221 .32757 L
.22272 .35944 L
.26171 .38598 L
.30316 .40976 L
.34309 .42837 L
.3815 .44229 L
.40095 .44786 L
.42237 .45283 L
.44268 .45644 L
.45178 .4577 L
.46172 .45883 L
.4671 .45933 L
.4721 .45973 L
.47727 .46008 L
.48196 .46033 L
.48658 .46052 L
.4887 .46059 L
.49093 .46065 L
.49332 .4607 L
.49438 .46072 L
.49552 .46073 L
.49675 .46074 L
.49789 .46075 L
.49859 .46076 L
.49925 .46076 L
.50049 .46076 L
.50163 .46075 L
.50286 .46075 L
.50401 .46074 L
.50508 .46072 L
.50754 .46068 L
.51014 .46062 L
.51268 .46055 L
.51504 .46046 L
.5204 .46021 L
.5293 .45963 L
.53882 .45878 L
.54906 .45759 L
.56016 .456 L
.58032 .45228 L
.60019 .44756 L
.62123 .44143 L
.65912 .42745 L
.69946 .4084 L
.73829 .38599 L
.77956 .35777 L
Mistroke
.81932 .32628 L
.85757 .29199 L
.89827 .25118 L
.93745 .20764 L
.97619 .16047 L
Mfstroke
.02381 .23295 m
.06244 .27983 L
.10458 .32632 L
.14415 .36562 L
.18221 .39945 L
.22272 .43121 L
.26171 .45765 L
.30316 .48135 L
.34309 .49989 L
.3815 .51376 L
.40095 .51931 L
.42237 .52427 L
.44268 .52786 L
.45178 .52912 L
.46172 .53024 L
.4671 .53075 L
.4721 .53114 L
.47727 .53149 L
.48196 .53174 L
.48658 .53193 L
.4887 .532 L
.49093 .53206 L
.49332 .53211 L
.49438 .53212 L
.49552 .53214 L
.49675 .53215 L
.49789 .53216 L
.49859 .53216 L
.49925 .53216 L
.50049 .53216 L
.50163 .53216 L
.50286 .53215 L
.50401 .53214 L
.50508 .53213 L
.50754 .53209 L
.51014 .53203 L
.51268 .53195 L
.51504 .53187 L
.5204 .53162 L
.5293 .53104 L
.53882 .53019 L
.54906 .52901 L
.56016 .52742 L
.58032 .52371 L
.60019 .51901 L
.62123 .5129 L
.65912 .49897 L
.69946 .47999 L
.73829 .45766 L
.77956 .42954 L
Mistroke
.81932 .39817 L
.85757 .364 L
.89827 .32333 L
.93745 .27995 L
.97619 .23295 L
Mfstroke
.02381 .30517 m
.06244 .35188 L
.10458 .39821 L
.14415 .43737 L
.18221 .47108 L
.22272 .50272 L
.26171 .52907 L
.30316 .55268 L
.34309 .57116 L
.3815 .58498 L
.40095 .59051 L
.42237 .59545 L
.44268 .59903 L
.45178 .60028 L
.46172 .60141 L
.4671 .60191 L
.4721 .6023 L
.47727 .60264 L
.48196 .60289 L
.48658 .60308 L
.4887 .60315 L
.49093 .60321 L
.49332 .60326 L
.49438 .60328 L
.49552 .60329 L
.49675 .60331 L
.49789 .60331 L
.49859 .60332 L
.49925 .60332 L
.50049 .60332 L
.50163 .60332 L
.50286 .60331 L
.50401 .6033 L
.50508 .60329 L
.50754 .60324 L
.51014 .60318 L
.51268 .60311 L
.51504 .60302 L
.5204 .60278 L
.5293 .6022 L
.53882 .60135 L
.54906 .60018 L
.56016 .59859 L
.58032 .5949 L
.60019 .59021 L
.62123 .58413 L
.65912 .57025 L
.69946 .55133 L
.73829 .52908 L
.77956 .50106 L
Mistroke
.81932 .46979 L
.85757 .43575 L
.89827 .39523 L
.93745 .352 L
.97619 .30517 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`00o`3oool[0?ooo`00N`3oool00`3Z^W80VmCo0?ooo`020?ooo`030?ooe02K000007:j00<0
oooo00@0j[Yb000000000000L[[Z0`3oool0103Z^W8000000000LP2jj_nI0?ooo`00N`3oool00`3o
om@0Vi_D0?ooo`080?ooo`050;ZK^P3oool0oooo0;YbV`3Dool00`3oool00`3oe9/0L[[Z0?ooo`03
0?ooo`030000003oool0oooo09<0oooo001l0?ooo`030=BKV`3Dool0oooo00H0oooo00P0oooD09]b
^P3oool0oooo0=BKLP2jj_l0oooD09/00080000000<0001b0;[Zo`3oool00P3oool3000009<0oooo
001l0?ooo`030?oDV`1b^^X0oooo00H0oooo00/0oooD09]b^P3oool0oooo0=BKLP2jj_l0oooo0=BK
002Ke?l0omBK07:jjP040?ooo`030000003oool0oooo09<0oooo001i0?ooo`050?oZ^P1bVm@0oooo
0?ooe02KL[X0203oool02P2jLW80^^[o0?ooe02K09/0e?oo0?ooo`3oom@0V`1b0;ZjV`1b^^X40?oo
o`030000003oool0oooo09<0oooo00090?ooo`030000003oool0oooo06d0oooo00H0onZj07800000
000000000000V`3Dool70?ooo`040?oZ^P1b0000000009_Do`<0oooo00<0onZj0780001b^^X0103o
ool00`000000oooo0?ooo`280?ooo`030000003oool0oooo00P0oooo000:0?ooo`030000003oool0
oooo08L0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo0?ooo`090?ooo`002`3oool00`00
0000oooo0?ooo`260?ooo`800000Q`3oool00`000000oooo0?ooo`0:0?ooo`00303oool00`000000
oooo0?ooo`250?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3oool02P3oool000`0oooo
00<000000?ooo`3oool0Q@3oool00`000000oooo0?ooo`250?ooo`030000003oool0oooo00/0oooo
000=0?ooo`030000003oool0oooo08@0oooo00<000000?ooo`3oool0Q03oool00`000000oooo0?oo
o`0<0?ooo`003P3oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo08<0oooo00<00000
0?ooo`3oool03@3oool000l0oooo00<000000?ooo`3oool0PP3oool2000008<0oooo00<000000?oo
o`3oool03P3oool00100oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`220?ooo`03
0000003oool0oooo00h0oooo000A0?ooo`030000003oool0oooo0800oooo00<000000?ooo`3oool0
P@3oool00`000000oooo0?ooo`0?0?ooo`004P3oool00`000000oooo0?ooo`1o0?ooo`030000003o
ool0oooo0800oooo00<000000?ooo`3oool0403oool00180oooo00<000000?ooo`3oool0O`3oool0
0`000000oooo0?ooo`1o0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo
07h0oooo0P0000200?ooo`030000003oool0oooo0140oooo000D0?ooo`030000003oool0oooo07d0
oooo00<000000?ooo`3oool0OP3oool00`000000oooo0?ooo`0B0?ooo`005@3oool00`000000oooo
0?ooo`1l0?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3oool04`3oool001H0oooo00<0
00000?ooo`3oool0N`3oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo01@0oooo000G
0?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool0N`3oool00`000000oooo0?ooo`0E
0?ooo`00603oool00`000000oooo0?ooo`1i0?ooo`800000N`3oool00`000000oooo0?ooo`0F0?oo
o`00603oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3o
ool05P3oool001T0oooo00<000000?ooo`3oool0N03oool00`000000oooo0?ooo`1i0?ooo`030000
003oool0oooo01L0oooo000J0?ooo`030000003oool0oooo05h0oooo00<0j[Yb09_Do`3oool00P3o
ool00`3oom@0V`00001b^P030?ooo`040>ZjLP000000000007:jjP80oooo00@0j[Yb000000000000
L[[Z103oool00`000000oooo0?ooo`1h0?ooo`030000003oool0oooo01P0oooo000K0?ooo`030000
003oool0oooo05d0oooo00<0oooD09^Ke03oool0203oool01`2jVkX0oooo0?ooo`2jLY/0e?oo0?oZ
^P1bL[X00P3oool00`2jLW80^^[o0?ooo`020?ooo`030000003oool0oooo07L0oooo00<000000?oo
o`3oool06@3oool000T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1M0?ooo`03
0=BKV`3Dool0oooo00H0oooo00H0oooD09]b^P3oool0oooo0=BKLP2jj_l40?ooo`030=BKLP2jj_l0
oooo0080oooo0`00001f0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0203oool0
00X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1L0?ooo`030?oDV`1b^^X0oooo
00H0oooo00P0oooD09]b^P3oool0oooo0=BKLP2jj_l0oooo0=BK0080000000<009_D0?ooo`3oool0
0P3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
2@3oool000/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1H0?ooo`050?oZ^P1b
Vm@0oooo0?ooe02KL[X0203oool0202jLW80^^[o0?ooe02K09/0e?oo0?ooo`3DVg80^^[o1P3oool0
0`000000oooo0?ooo`1e0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool02P3oool0
00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`1H0?ooo`060?oZ^P1b00000000
0000000009/0e?oo1`3oool0103oj[X0LP000000002Ke?l20?ooo`040=BK000000000000002Ke0@0
oooo00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00X0
oooo000<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0LP3oool00`000000oooo
0?ooo`1c0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool02`3oool000d0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`1a0?ooo`800000L`3oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo00`0oooo000>0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0L03oool00`000000oooo0?ooo`1a0?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool03@3oool000l0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1_0?oo
o`030000003oool0oooo0700oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?oo
o`00403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3o
ool0K`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00h0oooo000A0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`1^0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool03`3oool00180oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`1/0?ooo`800000KP3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo000B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0J`3oool0
0`000000oooo0?ooo`1/0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool0
01<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo
06/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`00503oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo06X0oooo00<000000?ooo`3oool0JP3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo000E0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool04`3oool001H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`1X0?ooo`800000J@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01@0oooo000G
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`1W
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool05@3oool001P0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo06H0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0F0?ooo`006@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo06D0oooo00<000000?ooo`3oool0I@3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo01L0oooo000J0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
I03oool00`000000oooo0?ooo`1T0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
603oool001/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1S0?ooo`800000I03o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01T0oooo00090?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool04@3oool2000006<0oooo00<000000?ooo`3oool0HP3oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0203oool0
00X0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
0600oooo00<000000?ooo`3oool0H03oool2000001@0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`090?ooo`002`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0180
oooo00<000000?ooo`3oool0AP3oool00`3Z^W80VmCo0?ooo`020?ooo`030?ooe02K000007:j00<0
oooo00@0j[Yb000000000000L[[Z0P3oool01@3oom@0V`00000000000780^^[o00<0oooo00<00000
0?ooo`3oool0G`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool02P3oool000`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo04D0oooo00<0oooD09^Ke03oool0203oool02`2jVkX0oooo0?ooo`2jLY/0
e?oo0?ooo`3DV`00VmCo0?ooo`3oom@0e=Co00<0oooo00<000000?ooo`3oool0GP3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool02P3oool000`0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo04D0oooo
00<0e9^K0=Coo`3oool01P3oool0303oom@0Vg:j0?ooo`3oool0e9]b0;[Zo`3oom@0V`0007:jjP3o
ool0j[Yb09_Do`<0oooo0`00001M0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0;0?ooo`003@3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0180oooo0P0000150?ooo`030?oDV`1b^^X0oooo00H0oooo00/0oooD09]b^P3oool0oooo
0=BKLP2jj_l0oooo0;YbV`1bLP000000001b^P040?ooo`030000003oool0oooo05`0oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00`0oooo000>0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0o0?oo
o`050?oZ^P1bVm@0oooo0?ooe02KL[X0203oool0202jLW80^^[o0?ooe02K09/0e?oo0?ooo`3oe9/0
07:j1P3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`0=0?ooo`003`3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool0?P3oool01P3oj[X0LP00000000000000002K0=Co
o`L0oooo00@0onZj078000000000VmCo0`3oool0103Z^W8000000000002Ke?l30?ooo`030000003o
ool0oooo05X0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo00h0oooo000@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`1H0?ooo`030000003oool0oooo05P0oooo0P00000E0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool03P3oool00140oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0C0?ooo`800000F03oool2000005P0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo00l0oooo000B0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05H0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100
oooo000B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`1D0?ooo`030000003oool0oooo05@0oooo0P00000F0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool001@0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0580oooo00<00000
0?ooo`3oool0DP3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool04P3oool001D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0E0?oo
o`800000DP3oool200000540oooo0P00000G0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool04`3oool001H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo04l0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0503oool001L0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool0
CP3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
5@3oool001P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0F0?ooo`800000CP3o
ool00`000000oooo0?ooo`1<0?ooo`800000603oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo01H0oooo000I0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`1;0?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01L0oooo000J0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool05`3oool2000004/0oooo0P00001;0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0H0?ooo`006`3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`180?ooo`8000006@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01T0
oooo00090?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool04@3oool2000001T0oooo
0P0000180?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0203oool000X0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool0A@3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo01L0oooo0P00
000D0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool02@3oool000/0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01P0oooo0P000015
0?ooo`030000003oool0oooo04@0oooo0P00000I0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0:0?ooo`00303oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`120?oo
o`800000A03oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0:0?ooo`00303oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool06@3oool200000480oooo00<000000?ooo`3o
ool0@@3oool2000001X0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo00/0oooo000=0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
4P3oool2000001/0oooo0P0000100?ooo`030000003oool0oooo03l0oooo0P00000K0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0<0?ooo`003P3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool06P3o
ool00`000000oooo0?ooo`0T0?ooo`030>ZjLP2Ke?l0oooo0080oooo00<0oooD09/00000L[X00`3o
ool0103Z^W8000000000001b^^X30?ooo`030>ZjLP2Ke?l0oooo00@0oooo00<000000?ooo`3oool0
?@3oool2000001`0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00d0oooo000?0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0J0?ooo`800000903oool00`3oom@0Vi_D0?ooo`080?ooo`050;ZK^P3o
ool0oooo0;YbV`3Dool00P3oool00`3oom@0Vi_D0?ooo`040?ooo`030000003oool0oooo03/0oooo
0P00000M0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0>0?ooo`00403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool06`3oool2000002<0oooo00<0e9^K0=Coo`3oool01P3oool01P3oom@0Vg:j0?oo
o`3oool0e9]b0;[Zo`<0oooo00<0e9^K0=Coo`3oool00`3oool3000003T0oooo0P00000N0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0>0?ooo`00
4@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01<0oooo0P00000M0?ooo`800000
8@3oool00`3oe9/0L[[Z0?ooo`060?ooo`060?ooe02KL[X0oooo0?ooo`3DVg80^^[o0`3oool00`3o
e9/0L[[Z0?ooo`030?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0703oool20000
01D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0?0?ooo`004P3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0703oool2000001`0
oooo00D0onZj07:Ke03oool0oooD09]b^P080?ooo`0:0;YbLP2jj_l0oooD09/0V`3Dool0onZj07:K
e03oool0oooD09]b^P@0oooo00<000000?ooo`3oool0=P3oool2000001h0oooo00<000000?ooo`3o
ool0503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo000B0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0M0?ooo`800000
6P3oool01P3oj[X0LP00000000000000002K0=Coo`L0oooo00L0onZj078000000000VmCo0?ooo`3o
j[X0LP000080000000<0002K0=Coo`3oool00P3oool00`000000oooo0?ooo`0d0?ooo`8000007`3o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3o
ool001<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo01h0oooo0P00000c0?ooo`030000003oool0oooo0380oooo0P00000P0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`00503oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool07`3oool30000
0300oooo0P00000a0?ooo`8000008@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool04P3oool001D0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0E0?ooo`8000008P3oool2000002h0oooo00<000000?ooo`3oool0;P3oool200000240
oooo0P00000F0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04`3oool001H0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0240oooo
0`00000[0?ooo`030000003oool0oooo02/0oooo0`00000R0?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0D0?ooo`005`3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool08`3oool3000002P0oooo00<0
00000?ooo`3oool0:03oool3000002@0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo01D0oooo000H0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool05P3oool2000002H0oooo0P00000V0?ooo`030000003oool0oooo02H0oooo0P00000U
0?ooo`8000005`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01H0oooo000I0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0U0?oo
o`<000008`3oool2000002@0oooo0`00000V0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`006P3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo01L0oooo0P00000X0?ooo`<00000803oool00`000000oooo0?ooo`0P0?ooo`<0
00009`3oool2000001P0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0H0?ooo`00
6`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
:03oool2000001h0oooo00<000000?ooo`3oool07@3oool3000002T0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01T0oooo00090?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool04@3oool2000001T0oooo0P00000Z0?ooo`D000006@3o
ool00`000000oooo0?ooo`0I0?ooo`@00000:P3oool2000001T0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00P0oooo000:0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo02`0oooo1P00000C0?ooo`030000003oool0oooo01<0oooo1P00000]0?ooo`030000003oool0
oooo01L0oooo0P00000D0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool02@3oool0
00/0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
01P0oooo0P00000b0?ooo`@000003`3oool2000000l0oooo1@00000a0?ooo`8000006@3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool02P3oool000`0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0<`3oool8000000L0oooo00<000000?ooo`3oool01@3oool9000003D0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool02P3oool000`0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo01T0oooo0P00000k0?ooo`l00000?03oool2000001X0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00/0oooo
000=0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04P3oool2000001/0oooo0P00
00100?ooo`030000003oool0oooo03l0oooo0P00000K0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0<0?ooo`003P3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0m
0?ooo`030000003oool0oooo03d0oooo0P00000L0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0=0?ooo`003`3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool06P3oool2000003d0oooo0P00000l0?oo
o`8000007@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool03P3oool00100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo01/0oooo0P00000k0?ooo`030000003oool0oooo03T0oooo0P00000N0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0>0?ooo`00
4@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01<0oooo0P00000M0?ooo`800000
>@3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo01`0oooo0P00000E0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool03`3oool00180oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01`0oooo0P00000N0?ooo`030>ZjLP2K
e?l0oooo0080oooo00<0oooD09/00000L[X00`3oool0103Z^W8000000000001b^^X20?ooo`040=BK
00000000000007:jjP@0oooo00<000000?ooo`3oool0=P3oool2000001h0oooo00<000000?ooo`3o
ool0503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo000B0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0M0?ooo`800000
703oool00`3oom@0Vi_D0?ooo`080?ooo`070;ZK^P3oool0oooo0;YbV`3Dool0oooD09^Ke0020?oo
o`030;ZK^P3oool0oooo0080oooo00<000000?ooo`3oool0=03oool2000001l0oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0140oooo000C0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0N0?ooo`80
00006`3oool00`3DVi/0e?oo0?ooo`060?ooo`0;0?ooe02KL[X0oooo0?ooo`3DVg80^^[o0?ooo`2j
VkX0oooo0?ooe02KVm@0103oool300000380oooo0P00000P0?ooo`030000003oool0oooo01@0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`00503oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool07`3oool3000001P0oooo00<0
omBK07:jjP3oool01P3oool0203oom@0Vg:j0?ooo`3oool0e9]b0;[Zo`3oool0e9/00P0000000`1b
^^X0oooo0?ooo`020?ooo`030000003oool0oooo0300oooo0P00000Q0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`005@3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo01D0oooo0P00000R0?ooo`8000004`3oool01@3oj[X0
LY_D0?ooo`3oom@0Vg:j00P0oooo00X0^W9b0;[Zo`3oom@0V`2K0=Coo`3oom@0Vg:j0?ooo`3oom@0
Vg:j103oool00`000000oooo0?ooo`0^0?ooo`8000008@3oool2000001H0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0C0?ooo`005P3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool08@3oool300000100oooo00H0onZj078000000000
00000000V`3Dool70?ooo`040?oZ^P1b0000000009_Do`80oooo00@0j[Yb000000000000VmCo103o
ool00`000000oooo0?ooo`0[0?ooo`<000008P3oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0503oool001L0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo02<0oooo0`00000X0?ooo`030000003oool0
oooo02P0oooo0`00000T0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0E0?ooo`00603oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
01H0oooo0P00000V0?ooo`8000009P3oool2000002L0oooo0P00000U0?ooo`8000005`3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo01H0oooo000I0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0U0?ooo`<000008`3oool00`000000
oooo0?ooo`0S0?ooo`<000009P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool05`3oool001X0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0G0?ooo`800000:03oool300000200oooo00<000000?ooo`3oool0803oool3000002L0oooo
0P00000H0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0603oool001/0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo02P0oooo0P00
000N0?ooo`030000003oool0oooo01d0oooo0`00000Y0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0I0?ooo`006`3oool00`000000oooo0?ooo`0A
0?ooo`8000006@3oool2000002X0oooo1@00000I0?ooo`030000003oool0oooo01T0oooo1000000Z
0?ooo`8000006@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01T0oooo000L0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0/0?oo
o`H000004`3oool2000001@0oooo1P00000]0?ooo`030000003oool0oooo01L0oooo0P00000D0?oo
o`030000003oool0oooo01X0oooo000M0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3o
ool0603oool200000380oooo1000000?0?ooo`030000003oool0oooo00h0oooo1@00000a0?ooo`80
00006@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01/0oooo000N0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0c0?ooo`X00000
1@3oool00`000000oooo0?ooo`050?ooo`T00000=@3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool0703oool001l0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0I0?ooo`800000?@3oool=000003`0oooo0P00000J0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool07@3oool00200oooo00<000000?ooo`3oool04P3oool2
000001/0oooo0P0000100?ooo`030000003oool0oooo03l0oooo0P00000K0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool07P3oool00240oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo03d0oooo0P00000n0?ooo`800000703oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo01l0oooo000R0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool06P3oool2000003d0oooo00<000000?ooo`3oool0>`3oool2000001d0
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0P0?ooo`008`3oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo01/0oooo0P00000k0?ooo`030000003oool0oooo03T0oooo
0P00000M0?ooo`8000005@3oool00`000000oooo0?ooo`0Q0?ooo`00903oool00`000000oooo0?oo
o`0C0?ooo`8000007@3oool2000003T0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool08P3oool002D0oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`0L0?ooo`800000=`3oool00`000000oooo0?ooo`0f
0?ooo`8000007P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo02<0oooo000V0?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool07@3oool2000003D0oooo0P00000e0?oo
o`8000007P3oool2000001H0oooo00<000000?ooo`3oool0903oool002H0oooo00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`0N0?ooo`800000<`3oool00`000000oooo0?ooo`0b0?ooo`80
00007`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02D0oooo000W0?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool07`3oool300000300oooo00<000000?ooo`3oool0
<03oool200000200oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0V0?ooo`00:03o
ool00`000000oooo0?ooo`0E0?ooo`8000008P3oool2000001D0oooo00<0j[Yb09_Do`3oool00P3o
ool00`3oom@0V`00001b^P030?ooo`040>ZjLP000000000007:jjP80oooo00@0^W80000000000000
L[[Z103oool00`000000oooo0?ooo`0^0?ooo`800000803oool2000001L0oooo00<000000?ooo`3o
ool09`3oool002T0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0Q0?ooo`<00000
4P3oool00`3oom@0Vi_D0?ooo`080?ooo`050;ZK^P3oool0oooo0;YbV`3Dool0103oool00`2jLY/0
e?oo0?ooo`020?ooo`030000003oool0oooo02/0oooo0`00000Q0?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool0:03oool002X0oooo00<000000?ooo`3oool05P3oool00`000000oooo
0?ooo`0S0?ooo`<00000403oool00`3DVi/0e?oo0?ooo`060?ooo`080?ooe02KL[X0oooo0?ooo`3D
Vg80^^[o0?ooo`3oe9/30000000409_Do`3oool0oooo0?ooo`<00000:03oool3000002<0oooo00<0
00000?ooo`3oool05P3oool00`000000oooo0?ooo`0Y0?ooo`00:`3oool00`000000oooo0?ooo`0F
0?ooo`8000009P3oool2000000h0oooo00<0omBK07:jjP3oool01P3oool0303oom@0Vg:j0?ooo`3o
ool0e9]b0;[Zo`3oom@0V`2K0=Coo`3oool0j[Yb09_Do`<0oooo00<000000?ooo`3oool09P3oool2
000002@0oooo0P00000H0?ooo`030000003oool0oooo02X0oooo000/0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool09@3oool3000000P0oooo00D0onZj07:Ke03oool0oooD09]b^P08
0?ooo`0;0;YbLP2jj_l0oooD09/0V`3Dool0oooD09/0V`3Dool0oooo0;YbV`3Dool00`3oool00`00
0000oooo0?ooo`0S0?ooo`<000009@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
02/0oooo000]0?ooo`030000003oool0oooo01L0oooo0P00000X0?ooo`<000001@3oool01P3oj[X0
LP00000000000000002K0=Coo`L0oooo00@0onZj078000000000VmCo0P3oool0103oe9/000000000
001b^^X40?ooo`030000003oool0oooo0200oooo0`00000W0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool0;03oool002h0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0X0?ooo`8000007P3oool00`000000oooo0?ooo`0M0?ooo`<00000:03oool2000001T0oooo00<0
00000?ooo`3oool0;@3oool002l0oooo0P00000I0?ooo`800000:P3oool5000001T0oooo0P00000J
0?ooo`@00000:P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo02h0oooo000a0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool0;03oool6000001<0oooo00<000000?oo
o`3oool04`3oool6000002d0oooo00<000000?ooo`3oool05`3oool200000340oooo000b0?ooo`03
0000003oool0oooo01P0oooo0P00000b0?ooo`@000003`3oool00`000000oooo0?ooo`0>0?ooo`D0
0000<@3oool2000001T0oooo00<000000?ooo`3oool0<@3oool003<0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0c0?ooo`/00000103oool00`000000oooo0?ooo`030?ooo`/00000
=@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0380oooo000d0?ooo`030000003o
ool0oooo01T0oooo0P00000n0?ooo`X00000?P3oool2000001X0oooo00<000000?ooo`3oool0<`3o
ool003D0oooo0P00000K0?ooo`800000@03oool200000400oooo0P00000K0?ooo`030000003oool0
oooo03@0oooo000g0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0?@3oool00`00
0000oooo0?ooo`0m0?ooo`800000703oool00`000000oooo0?ooo`0e0?ooo`00>03oool00`000000
oooo0?ooo`0J0?ooo`800000?@3oool00`000000oooo0?ooo`0k0?ooo`8000007@3oool00`000000
oooo0?ooo`0f0?ooo`009`3oool0103Z^W8000000000LP2jj_l>0?ooo`030000003oool0oooo01/0
oooo0P0000040?ooo`060?oDV`00000000000000000009/0e?oo<@3oool00`000000oooo0?ooo`0b
0?ooo`070?oDV`00000000000000000009/0e?oo0?ooo`02000001d0oooo0P00000A0?ooo`040>Zj
LP000000001b0;[Zob@0oooo000X0?ooo`030?oDV`1b^^X0oooo00l0oooo0P00000M0?ooo`800000
0`3oool00`2jLP00002K0=Coo`0c0?ooo`030000003oool0oooo03<0oooo00<0^W800000V`3Dool0
0P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0180oooo00<0omBK07:jjP3oool0
903oool002D0oooo00H0oooD09/00000000000000000LP2jj_lA0?ooo`030000003oool0oooo01`0
oooo0P0000020?ooo`030?oDV`000000VmCo0380oooo0P00000e0?ooo`040?oDV`00000000000000
01h0oooo00<000000?ooo`3oool0403oool01P3oom@0V`00000000000000001b0;[Zob@0oooo000O
0?ooo`030?oDV`00000000000080000000H0VmCo0?ooo`3DV`00VmCo0?oDV`1b^^XC0?ooo`030000
003oool0oooo01L0oooo00<0omBK0000000000000P0000001P2Ke?l000000000003oool0oooD0=CD
oc80oooo00<000000?ooo`3oool0=03oool2000000030=CDo`3oool0oooo01/0oooo0P00000D0?oo
o`040=BK002Ke?l0omBK07:jjRD0oooo000V0?ooo`040?ooe02K0780^[ZK07:jjQ@0oooo00<00000
0?ooo`3oool0703oool01P3oj[X0LW:j000000000000V`2K0=Cooc40oooo00<000000?ooo`3oool0
<P3oool2000000040?ooo`3oom@0V`2K0=Cooa/0oooo00<000000?ooo`3oool0503oool0103oom@0
V`1b0;ZjV`1b^^XU0?ooo`009`3oool00`3oj[X0LP0007:jjP0E0?ooo`030000003oool0oooo01`0
oooo00<0j[Yb0000000000000`00000`0?ooo`030000003oool0oooo0300oooo0P0000001@3oool0
j[Yb000000000000L[[Z01/0oooo00<000000?ooo`3oool05P3oool00`3oj[X0LP0007:jjP0U0?oo
o`00@03oool200000280oooo0P00000^0?ooo`030000003oool0oooo02h0oooo0P00000P0?ooo`80
0000@@3oool00480oooo00<000000?ooo`3oool08@3oool3000002/0oooo0P00000/0?ooo`<00000
8@3oool00`000000oooo0?ooo`110?ooo`00@`3oool00`000000oooo0?ooo`0S0?ooo`<00000:03o
ool00`000000oooo0?ooo`0X0?ooo`<000008`3oool00`000000oooo0?ooo`120?ooo`00A03oool2
000002H0oooo0P00000V0?ooo`030000003oool0oooo02H0oooo0P00000T0?ooo`800000A@3oool0
04H0oooo00<000000?ooo`3oool09@3oool3000002<0oooo00<000000?ooo`3oool08`3oool30000
02D0oooo00<000000?ooo`3oool0A@3oool004L0oooo0P00000X0?ooo`<00000803oool00`000000
oooo0?ooo`0P0?ooo`<000009`3oool00`000000oooo0?ooo`160?ooo`000P3ooooo000002H00000
0`3oool000T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`060?ooo`8000000`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203o
ool5000000/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo1000000:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool01@000000oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`080?ooo`00C03oool00`000000oooo0?ooo`0/0?ooo`H000004`3oool00`000000oooo0?oo
o`0C0?ooo`H00000;@3oool00`000000oooo0?ooo`1:0?ooo`00C@3oool200000380oooo1000000?
0?ooo`030000003oool0oooo00h0oooo1@00000a0?ooo`800000C@3oool004l0oooo00<000000?oo
o`3oool0<`3ooolP000003D0oooo00<000000?ooo`3oool0C@3oool00500oooo0P0000120?ooo`03
0000003oool0oooo0440oooo0P00001@0?ooo`00DP3oool200000400oooo00<000000?ooo`3oool0
?`3oool200000580oooo001D0?ooo`800000?P3oool00`000000oooo0?ooo`0m0?ooo`800000E03o
ool005H0oooo0P00000l0?ooo`030000003oool0oooo03/0oooo0P00001F0?ooo`00F03oool20000
03X0oooo0P00000j0?ooo`800000F03oool005X0oooo0P00000h0?ooo`030000003oool0oooo03P0
oooo00<000000?ooo`3oool0F03oool005`0oooo0P00000f0?ooo`030000003oool0oooo03H0oooo
0P00001K0?ooo`00GP3oool2000003@0oooo00<000000?ooo`3oool0=03oool2000005d0oooo001P
0?ooo`800000<P3oool00`000000oooo0?ooo`0b0?ooo`800000G`3oool00680oooo0P00000`0?oo
o`800000<@3oool200000640oooo001T0?ooo`800000;P3oool00`000000oooo0?ooo`0^0?ooo`80
0000H`3oool006H0oooo0`00000[0?ooo`030000003oool0oooo02/0oooo0`00001U0?ooo`00J@3o
ool3000002P0oooo00<000000?ooo`3oool0:03oool3000006P0oooo001/0?ooo`8000009P3oool0
0`000000oooo0?ooo`0V0?ooo`800000J`3oool006h0oooo0`00000S0?ooo`800000903oool30000
06d0oooo001a0?ooo`@000007`3oool00`000000oooo0?ooo`0O0?ooo`@00000L03oool007D0oooo
1000000K0?ooo`030000003oool0oooo01X0oooo1@00001d0?ooo`00N@3oool4000000<0oooo00<0
oooD09/00000L[X00P3oool0203oom@0V`00000000000000001b0;[Zo`3oom@0V`000P0000000`00
0780^^[o0?ooo`020?ooo`030000003oool0oooo01L0oooo0`00001i0?ooo`00N`3oool00`3oom@0
Vi_D00000003000000H0oooo00<0omBK07:jjP3oool00`3oool00`3oe9/0L[[Z0?ooo`040?ooo`03
0000003oool0oooo01<0oooo1000001l0?ooo`00O03oool00`3DVi/0e?oo0?ooo`020?ooo`L00000
00<0L[[Z0?ooo`3oool00P3oool00`3oe9/0L[[Z0?ooo`040?ooo`<000002`3oool800000800oooo
001l0?ooo`030?oDV`1b^^X0oooo00P0oooo00<0omBK000000000000600000280?ooo`00N@3oool0
1@3oj[X0LY_D0?ooo`3oom@0Vg:j00P0oooo00<0^W:K0=CDV`1b^^X00`3oool00`2jLY/0e=BK07:j
jP050?ooo`030000003oool0oooo09<0oooo001i0?ooo`060?oZ^P1b000000000000000009/0e?oo
1`3oool00`3oe9/0000007:jjP030?ooo`030?oDV`000000L[[Z00D0oooo00<000000?ooo`3oool0
T`3oool009@0oooo00<000000?ooo`3oool0T`3oool009@0oooo0P00002D0?ooo`00\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {426.375, 279.813}} -> {-11.5382, \
7.17923, 0.0360393, 0.000403275}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show[k2,gp]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 -59.9136 8.51112 [
[.11905 .50284 -6 -9 ]
[.11905 .50284 6 0 ]
[.30952 .50284 -6 -9 ]
[.30952 .50284 6 0 ]
[.69048 .50284 -3 -9 ]
[.69048 .50284 3 0 ]
[.88095 .50284 -3 -9 ]
[.88095 .50284 3 0 ]
[.4875 .00467 -24 -4.5 ]
[.4875 .00467 0 4.5 ]
[.4875 .08978 -24 -4.5 ]
[.4875 .08978 0 4.5 ]
[.4875 .17489 -24 -4.5 ]
[.4875 .17489 0 4.5 ]
[.4875 .26 -24 -4.5 ]
[.4875 .26 0 4.5 ]
[.4875 .34511 -24 -4.5 ]
[.4875 .34511 0 4.5 ]
[.4875 .43022 -24 -4.5 ]
[.4875 .43022 0 4.5 ]
[.4875 .60045 -24 -4.5 ]
[.4875 .60045 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .51534 m
.11905 .52159 L
s
[(-4)] .11905 .50284 0 1 Mshowa
.30952 .51534 m
.30952 .52159 L
s
[(-2)] .30952 .50284 0 1 Mshowa
.69048 .51534 m
.69048 .52159 L
s
[(2)] .69048 .50284 0 1 Mshowa
.88095 .51534 m
.88095 .52159 L
s
[(4)] .88095 .50284 0 1 Mshowa
.125 Mabswid
.16667 .51534 m
.16667 .51909 L
s
.21429 .51534 m
.21429 .51909 L
s
.2619 .51534 m
.2619 .51909 L
s
.35714 .51534 m
.35714 .51909 L
s
.40476 .51534 m
.40476 .51909 L
s
.45238 .51534 m
.45238 .51909 L
s
.54762 .51534 m
.54762 .51909 L
s
.59524 .51534 m
.59524 .51909 L
s
.64286 .51534 m
.64286 .51909 L
s
.7381 .51534 m
.7381 .51909 L
s
.78571 .51534 m
.78571 .51909 L
s
.83333 .51534 m
.83333 .51909 L
s
.07143 .51534 m
.07143 .51909 L
s
.02381 .51534 m
.02381 .51909 L
s
.92857 .51534 m
.92857 .51909 L
s
.97619 .51534 m
.97619 .51909 L
s
.25 Mabswid
0 .51534 m
1 .51534 L
s
.5 .00467 m
.50625 .00467 L
s
[(7.04)] .4875 .00467 1 0 Mshowa
.5 .08978 m
.50625 .08978 L
s
[(7.05)] .4875 .08978 1 0 Mshowa
.5 .17489 m
.50625 .17489 L
s
[(7.06)] .4875 .17489 1 0 Mshowa
.5 .26 m
.50625 .26 L
s
[(7.07)] .4875 .26 1 0 Mshowa
.5 .34511 m
.50625 .34511 L
s
[(7.08)] .4875 .34511 1 0 Mshowa
.5 .43022 m
.50625 .43022 L
s
[(7.09)] .4875 .43022 1 0 Mshowa
.5 .60045 m
.50625 .60045 L
s
[(7.11)] .4875 .60045 1 0 Mshowa
.125 Mabswid
.5 .02169 m
.50375 .02169 L
s
.5 .03871 m
.50375 .03871 L
s
.5 .05574 m
.50375 .05574 L
s
.5 .07276 m
.50375 .07276 L
s
.5 .1068 m
.50375 .1068 L
s
.5 .12382 m
.50375 .12382 L
s
.5 .14085 m
.50375 .14085 L
s
.5 .15787 m
.50375 .15787 L
s
.5 .19191 m
.50375 .19191 L
s
.5 .20894 m
.50375 .20894 L
s
.5 .22596 m
.50375 .22596 L
s
.5 .24298 m
.50375 .24298 L
s
.5 .27702 m
.50375 .27702 L
s
.5 .29405 m
.50375 .29405 L
s
.5 .31107 m
.50375 .31107 L
s
.5 .32809 m
.50375 .32809 L
s
.5 .36214 m
.50375 .36214 L
s
.5 .37916 m
.50375 .37916 L
s
.5 .39618 m
.50375 .39618 L
s
.5 .4132 m
.50375 .4132 L
s
.5 .44725 m
.50375 .44725 L
s
.5 .46427 m
.50375 .46427 L
s
.5 .48129 m
.50375 .48129 L
s
.5 .49831 m
.50375 .49831 L
s
.5 .53236 m
.50375 .53236 L
s
.5 .54938 m
.50375 .54938 L
s
.5 .5664 m
.50375 .5664 L
s
.5 .58342 m
.50375 .58342 L
s
.5 .61747 m
.50375 .61747 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .06211 L
.10458 .10911 L
.14415 .14884 L
.18221 .18303 L
.22272 .21513 L
.26171 .24187 L
.30316 .26582 L
.34309 .28456 L
.3815 .29858 L
.40095 .30419 L
.42237 .3092 L
.44268 .31283 L
.45178 .3141 L
.46172 .31524 L
.4671 .31575 L
.4721 .31615 L
.47727 .3165 L
.48196 .31675 L
.48658 .31694 L
.4887 .31701 L
.49093 .31707 L
.49332 .31712 L
.49438 .31714 L
.49552 .31715 L
.49675 .31717 L
.49789 .31717 L
.49859 .31718 L
.49925 .31718 L
.50049 .31718 L
.50163 .31718 L
.50286 .31717 L
.50401 .31716 L
.50508 .31714 L
.50754 .3171 L
.51014 .31704 L
.51268 .31697 L
.51504 .31688 L
.5204 .31663 L
.5293 .31604 L
.53882 .31518 L
.54906 .31399 L
.56016 .31239 L
.58032 .30864 L
.60019 .30389 L
.62123 .29771 L
.65912 .28363 L
.69946 .26444 L
.73829 .24187 L
.77956 .21345 L
Mistroke
.81932 .18173 L
.85757 .1472 L
.89827 .10609 L
.93745 .06223 L
.97619 .01472 L
Mfstroke
.02381 .08772 m
.06244 .13494 L
.10458 .18178 L
.14415 .22136 L
.18221 .25543 L
.22272 .28742 L
.26171 .31405 L
.30316 .33792 L
.34309 .35659 L
.3815 .37056 L
.40095 .37615 L
.42237 .38114 L
.44268 .38476 L
.45178 .38603 L
.46172 .38716 L
.4671 .38767 L
.4721 .38807 L
.47727 .38842 L
.48196 .38867 L
.48658 .38886 L
.4887 .38893 L
.49093 .38899 L
.49332 .38904 L
.49438 .38905 L
.49552 .38907 L
.49675 .38908 L
.49789 .38909 L
.49859 .38909 L
.49925 .3891 L
.50049 .3891 L
.50163 .38909 L
.50286 .38909 L
.50401 .38908 L
.50508 .38906 L
.50754 .38902 L
.51014 .38896 L
.51268 .38888 L
.51504 .3888 L
.5204 .38855 L
.5293 .38796 L
.53882 .38711 L
.54906 .38592 L
.56016 .38432 L
.58032 .38059 L
.60019 .37585 L
.62123 .3697 L
.65912 .35567 L
.69946 .33655 L
.73829 .31406 L
.77956 .28574 L
Mistroke
.81932 .25414 L
.85757 .21973 L
.89827 .17877 L
.93745 .13507 L
.97619 .08772 L
Mfstroke
.02381 .16047 m
.06244 .20752 L
.10458 .25418 L
.14415 .29362 L
.18221 .32757 L
.22272 .35944 L
.26171 .38598 L
.30316 .40976 L
.34309 .42837 L
.3815 .44229 L
.40095 .44786 L
.42237 .45283 L
.44268 .45644 L
.45178 .4577 L
.46172 .45883 L
.4671 .45933 L
.4721 .45973 L
.47727 .46008 L
.48196 .46033 L
.48658 .46052 L
.4887 .46059 L
.49093 .46065 L
.49332 .4607 L
.49438 .46072 L
.49552 .46073 L
.49675 .46074 L
.49789 .46075 L
.49859 .46076 L
.49925 .46076 L
.50049 .46076 L
.50163 .46075 L
.50286 .46075 L
.50401 .46074 L
.50508 .46072 L
.50754 .46068 L
.51014 .46062 L
.51268 .46055 L
.51504 .46046 L
.5204 .46021 L
.5293 .45963 L
.53882 .45878 L
.54906 .45759 L
.56016 .456 L
.58032 .45228 L
.60019 .44756 L
.62123 .44143 L
.65912 .42745 L
.69946 .4084 L
.73829 .38599 L
.77956 .35777 L
Mistroke
.81932 .32628 L
.85757 .29199 L
.89827 .25118 L
.93745 .20764 L
.97619 .16047 L
Mfstroke
.02381 .23295 m
.06244 .27983 L
.10458 .32632 L
.14415 .36562 L
.18221 .39945 L
.22272 .43121 L
.26171 .45765 L
.30316 .48135 L
.34309 .49989 L
.3815 .51376 L
.40095 .51931 L
.42237 .52427 L
.44268 .52786 L
.45178 .52912 L
.46172 .53024 L
.4671 .53075 L
.4721 .53114 L
.47727 .53149 L
.48196 .53174 L
.48658 .53193 L
.4887 .532 L
.49093 .53206 L
.49332 .53211 L
.49438 .53212 L
.49552 .53214 L
.49675 .53215 L
.49789 .53216 L
.49859 .53216 L
.49925 .53216 L
.50049 .53216 L
.50163 .53216 L
.50286 .53215 L
.50401 .53214 L
.50508 .53213 L
.50754 .53209 L
.51014 .53203 L
.51268 .53195 L
.51504 .53187 L
.5204 .53162 L
.5293 .53104 L
.53882 .53019 L
.54906 .52901 L
.56016 .52742 L
.58032 .52371 L
.60019 .51901 L
.62123 .5129 L
.65912 .49897 L
.69946 .47999 L
.73829 .45766 L
.77956 .42954 L
Mistroke
.81932 .39817 L
.85757 .364 L
.89827 .32333 L
.93745 .27995 L
.97619 .23295 L
Mfstroke
.02381 .30517 m
.06244 .35188 L
.10458 .39821 L
.14415 .43737 L
.18221 .47108 L
.22272 .50272 L
.26171 .52907 L
.30316 .55268 L
.34309 .57116 L
.3815 .58498 L
.40095 .59051 L
.42237 .59545 L
.44268 .59903 L
.45178 .60028 L
.46172 .60141 L
.4671 .60191 L
.4721 .6023 L
.47727 .60264 L
.48196 .60289 L
.48658 .60308 L
.4887 .60315 L
.49093 .60321 L
.49332 .60326 L
.49438 .60328 L
.49552 .60329 L
.49675 .60331 L
.49789 .60331 L
.49859 .60332 L
.49925 .60332 L
.50049 .60332 L
.50163 .60332 L
.50286 .60331 L
.50401 .6033 L
.50508 .60329 L
.50754 .60324 L
.51014 .60318 L
.51268 .60311 L
.51504 .60302 L
.5204 .60278 L
.5293 .6022 L
.53882 .60135 L
.54906 .60018 L
.56016 .59859 L
.58032 .5949 L
.60019 .59021 L
.62123 .58413 L
.65912 .57025 L
.69946 .55133 L
.73829 .52908 L
.77956 .50106 L
Mistroke
.81932 .46979 L
.85757 .43575 L
.89827 .39523 L
.93745 .352 L
.97619 .30517 L
Mfstroke
.01 w
.02381 .16047 m
.06244 .20752 L
.10458 .25418 L
.14415 .29362 L
.18221 .32757 L
.22272 .35944 L
.26171 .38598 L
.30316 .40976 L
.34309 .42837 L
.3815 .44229 L
.40095 .44786 L
.42237 .45283 L
.44268 .45644 L
.45178 .4577 L
.46172 .45883 L
.4671 .45933 L
.4721 .45973 L
.47727 .46008 L
.48196 .46033 L
.48658 .46052 L
.4887 .46059 L
.49093 .46065 L
.49332 .4607 L
.49438 .46072 L
.49552 .46073 L
.49675 .46074 L
.49789 .46075 L
.49859 .46076 L
.49925 .46076 L
.50049 .46076 L
.50163 .46075 L
.50286 .46075 L
.50401 .46074 L
.50508 .46072 L
.50754 .46068 L
.51014 .46062 L
.51268 .46055 L
.51504 .46046 L
.5204 .46021 L
.5293 .45963 L
.53882 .45878 L
.54906 .45759 L
.56016 .456 L
.58032 .45228 L
.60019 .44756 L
.62123 .44143 L
.65912 .42745 L
.69946 .4084 L
.73829 .38599 L
.77956 .35777 L
Mistroke
.81932 .32628 L
.85757 .29199 L
.89827 .25118 L
.93745 .20764 L
.97619 .16047 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`00o`3oool[0?ooo`00N`3oool00`3Z^W80VmCo0?ooo`020?ooo`030?ooe02K000007:j00<0
oooo00@0j[Yb000000000000L[[Z0`3oool0103Z^W8000000000LP2jj_nI0?ooo`00N`3oool00`3o
om@0Vi_D0?ooo`080?ooo`050;ZK^P3oool0oooo0;YbV`3Dool00`3oool00`3oe9/0L[[Z0?ooo`03
0?ooo`030000003oool0oooo09<0oooo001l0?ooo`030=BKV`3Dool0oooo00H0oooo00P0oooD09]b
^P3oool0oooo0=BKLP2jj_l0oooD09/00080000000<0001b0;[Zo`3oool00P3oool3000009<0oooo
001l0?ooo`030?oDV`1b^^X0oooo00H0oooo00/0oooD09]b^P3oool0oooo0=BKLP2jj_l0oooo0=BK
002Ke?l0omBK07:jjP040?ooo`030000003oool0oooo09<0oooo001i0?ooo`050?oZ^P1bVm@0oooo
0?ooe02KL[X0203oool02P2jLW80^^[o0?ooe02K09/0e?oo0?ooo`3oom@0V`1b0;ZjV`1b^^X40?oo
o`030000003oool0oooo09<0oooo00090?ooo`030000003oool0oooo06d0oooo00H0onZj07800000
000000000000V`3Dool70?ooo`040?oZ^P1b0000000009_Do`<0oooo00<0onZj0780001b^^X0103o
ool00`000000oooo0?ooo`280?ooo`030000003oool0oooo00P0oooo000:0?ooo`030000003oool0
oooo08L0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo0?ooo`090?ooo`002`3oool00`00
0000oooo0?ooo`260?ooo`800000Q`3oool00`000000oooo0?ooo`0:0?ooo`00303oool00`000000
oooo0?ooo`250?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3oool02P3oool000`0oooo
00<000000?ooo`3oool0Q@3oool00`000000oooo0?ooo`250?ooo`030000003oool0oooo00/0oooo
000=0?ooo`030000003oool0oooo08@0oooo00<000000?ooo`3oool0Q03oool00`000000oooo0?oo
o`0<0?ooo`003P3oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo08<0oooo00<00000
0?ooo`3oool03@3oool000l0oooo00<000000?ooo`3oool0PP3oool2000008<0oooo00<000000?oo
o`3oool03P3oool00100oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`220?ooo`03
0000003oool0oooo00h0oooo000A0?ooo`030000003oool0oooo0800oooo00<000000?ooo`3oool0
P@3oool00`000000oooo0?ooo`0?0?ooo`004P3oool00`000000oooo0?ooo`1o0?ooo`030000003o
ool0oooo0800oooo00<000000?ooo`3oool0403oool00180oooo00<000000?ooo`3oool0O`3oool0
0`000000oooo0?ooo`1o0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo
07h0oooo0P0000200?ooo`030000003oool0oooo0140oooo000D0?ooo`030000003oool0oooo07d0
oooo00<000000?ooo`3oool0OP3oool00`000000oooo0?ooo`0B0?ooo`005@3oool00`000000oooo
0?ooo`1l0?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3oool04`3oool001H0oooo00<0
00000?ooo`3oool0N`3oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo01@0oooo000G
0?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool0N`3oool00`000000oooo0?ooo`0E
0?ooo`00603oool00`000000oooo0?ooo`1i0?ooo`800000N`3oool00`000000oooo0?ooo`0F0?oo
o`00603oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3o
ool05P3oool001T0oooo00<000000?ooo`3oool0N03oool00`000000oooo0?ooo`1i0?ooo`030000
003oool0oooo01L0oooo000J0?ooo`030000003oool0oooo05h0oooo00<0j[Yb09_Do`3oool00P3o
ool00`3oom@0V`00001b^P030?ooo`040>ZjLP000000000007:jjP80oooo00@0j[Yb000000000000
L[[Z103oool00`000000oooo0?ooo`1h0?ooo`030000003oool0oooo01P0oooo000K0?ooo`030000
003oool0oooo05d0oooo00<0oooD09^Ke03oool0203oool01`2jVkX0oooo0?ooo`2jLY/0e?oo0?oZ
^P1bL[X00P3oool00`2jLW80^^[o0?ooo`020?ooo`030000003oool0oooo07L0oooo00<000000?oo
o`3oool06@3oool000T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1M0?ooo`03
0=BKV`3Dool0oooo00H0oooo00H0oooD09]b^P3oool0oooo0=BKLP2jj_l40?ooo`030=BKLP2jj_l0
oooo0080oooo0`00001f0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0203oool0
00X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1L0?ooo`030?oDV`1b^^X0oooo
00H0oooo00P0oooD09]b^P3oool0oooo0=BKLP2jj_l0oooo0=BK0080000000<009_D0?ooo`3oool0
0P3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
2@3oool000/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1H0?ooo`050?oZ^P1b
Vm@0oooo0?ooe02KL[X0203oool0202jLW80^^[o0?ooe02K09/0e?oo0?ooo`3DVg80^^[o1P3oool0
0`000000oooo0?ooo`1e0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool02P3oool0
00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`1H0?ooo`060?oZ^P1b00000000
0000000009/0e?oo1`3oool0103oj[X0LP000000002Ke?l20?ooo`040=BK000000000000002Ke0@0
oooo00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00X0
oooo000<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0LP3oool00`000000oooo
0?ooo`1c0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool02`3oool000d0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`1a0?ooo`800000L`3oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo00`0oooo000>0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0L03oool00`000000oooo0?ooo`1a0?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool03@3oool000l0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1_0?oo
o`030000003oool0oooo0700oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?oo
o`00403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3o
ool0K`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00h0oooo000A0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`1^0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool03`3oool00180oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`1/0?ooo`800000KP3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo000B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0J`3oool0
0`000000oooo0?ooo`1/0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool0
01<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo
06/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`00503oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo06X0oooo00<000000?ooo`3oool0JP3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo000E0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool04`3oool001H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`1X0?ooo`800000J@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01@0oooo000G
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`1W
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool05@3oool001P0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo06H0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0F0?ooo`006@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo06D0oooo00<000000?ooo`3oool0I@3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo01L0oooo000J0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
I03oool00`000000oooo0?ooo`1T0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
603oool000T0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo06<0oooo0P00001T0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`080?ooo`00203oool300000100oooo00<000000?ooo`3oool04@3oool2
000006<0oooo00<000000?ooo`3oool0HP3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
oooo00d0oooo0`0000090?ooo`002@3oool300000100oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`1P0?ooo`030000003oool0oooo0600oooo0P00000D0?ooo`030000003oool0oooo
00d0oooo0`00000:0?ooo`002P3oool300000100oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`160?ooo`030>ZjLP2Ke?l0oooo0080oooo00<0oooD09/00000L[X00`3oool0103Z^W80
00000000001b^^X20?ooo`050?ooe02K000000000000LP2jj_l00`3oool00`000000oooo0?ooo`1O
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03P3oool2000000/0oooo000;0?oo
o`8000004@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo04D0oooo00<0oooD09^K
e03oool0203oool02`2jVkX0oooo0?ooo`2jLY/0e?oo0?ooo`3DV`00VmCo0?ooo`3oom@0e=Co00<0
oooo00<000000?ooo`3oool0GP3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00h0
oooo0P00000<0?ooo`00303oool200000140oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`150?ooo`030=BKV`3Dool0oooo00H0oooo00`0oooD09]b^P3oool0oooo0=BKLP2jj_l0oooD
09/0001b^^X0oooo0>ZjLP2Ke?l30?ooo`<00000G@3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo00h0oooo0`00000<0?ooo`00303oool300000140oooo00<000000?ooo`3oool04P3o
ool2000004D0oooo00<0omBK07:jjP3oool01P3oool02`3oom@0Vg:j0?ooo`3oool0e9]b0;[Zo`3o
ool0^W:K079b0000000007:j00@0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo00h0oooo0`00000=0?ooo`003@3oool300000140oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0o0?ooo`050?oZ^P1bVm@0oooo0?ooe02KL[X0203oool0
202jLW80^^[o0?ooe02K09/0e?oo0?ooo`3oe9/007:j1P3oool00`000000oooo0?ooo`1K0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool03P3oool3000000h0oooo000>0?ooo`<00000
4@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03h0oooo00H0onZj078000000000
00000000V`3Dool70?ooo`040?oZ^P1b0000000009_Do`<0oooo00@0j[Yb000000000000VmCo0`3o
ool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3o
ool2000000l0oooo000?0?ooo`<000004@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo05P0oooo00<000000?ooo`3oool0F03oool2000001D0oooo00<000000?ooo`3oool03`3oool2
00000100oooo000@0?ooo`<000004@3oool00`000000oooo0?ooo`0C0?ooo`800000F03oool20000
05P0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0?0?ooo`<00000403oool00140
oooo0P00000B0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0E@3oool00`000000
oooo0?ooo`1F0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool03`3oool300000140
oooo000B0?ooo`8000004P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo05@0oooo
00<000000?ooo`3oool0E03oool2000001H0oooo00<000000?ooo`3oool0403oool200000180oooo
000B0?ooo`<000004@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo05<0oooo00<0
00000?ooo`3oool0D`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0100oooo0P00
000C0?ooo`004`3oool300000140oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`1B
0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0@
0?ooo`<000004`3oool001@0oooo0`00000A0?ooo`030000003oool0oooo01D0oooo0P00001B0?oo
o`800000D@3oool2000001L0oooo00<000000?ooo`3oool0403oool3000001@0oooo000E0?ooo`<0
00004@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3o
ool0C`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0100oooo0`00000E0?ooo`00
5P3oool300000140oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`1>0?ooo`030000
003oool0oooo04h0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0@0?ooo`<00000
5P3oool001L0oooo0`00000A0?ooo`030000003oool0oooo01H0oooo0P00001>0?ooo`030000003o
ool0oooo04`0oooo0P00000H0?ooo`030000003oool0oooo0100oooo0`00000G0?ooo`00603oool3
00000140oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0
oooo04/0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0@0?ooo`<00000603oool0
01T0oooo0`00000A0?ooo`030000003oool0oooo01L0oooo0P00001;0?ooo`800000B`3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo0100oooo0`00000I0?ooo`006P3oool200000180
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04P0
oooo0P00000I0?ooo`030000003oool0oooo0140oooo0P00000J0?ooo`002@3oool00`000000oooo
0?ooo`0?0?ooo`8000004P3oool2000001T0oooo0P0000180?ooo`030000003oool0oooo04L0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0A0?ooo`800000403oool00`000000oooo
0?ooo`080?ooo`002P3oool00`000000oooo0?ooo`0>0?ooo`<000004`3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?oo
o`0G0?ooo`8000004`3oool3000000l0oooo00<000000?ooo`3oool02@3oool000/0oooo00<00000
0?ooo`3oool03P3oool3000001<0oooo00<000000?ooo`3oool0603oool2000004D0oooo00<00000
0?ooo`3oool0A03oool2000001T0oooo00<000000?ooo`3oool04P3oool3000000l0oooo00<00000
0?ooo`3oool02P3oool000`0oooo00<000000?ooo`3oool03P3oool3000001<0oooo00<000000?oo
o`3oool06@3oool00`000000oooo0?ooo`120?ooo`800000A03oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo0180oooo0`00000@0?ooo`030000003oool0oooo00X0oooo000<0?ooo`03
0000003oool0oooo00l0oooo0`00000C0?ooo`030000003oool0oooo01T0oooo0P0000120?ooo`03
0000003oool0oooo0440oooo0P00000J0?ooo`030000003oool0oooo0180oooo0`00000@0?ooo`03
0000003oool0oooo00/0oooo000=0?ooo`030000003oool0oooo00l0oooo0`00000C0?ooo`800000
6`3oool200000400oooo00<000000?ooo`3oool0?`3oool2000001/0oooo00<000000?ooo`3oool0
4P3oool300000100oooo00<000000?ooo`3oool0303oool000h0oooo00<000000?ooo`3oool03`3o
ool3000001@0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0T0?ooo`030>ZjLP2K
e?l0oooo0080oooo00<0oooD09/00000L[X00`3oool0103Z^W8000000000001b^^X30?ooo`030>Zj
LP2Ke?l0oooo00@0oooo00<000000?ooo`3oool0?@3oool2000001`0oooo00<000000?ooo`3oool0
4P3oool300000100oooo00<000000?ooo`3oool03@3oool000l0oooo00<000000?ooo`3oool03`3o
ool3000001@0oooo00<000000?ooo`3oool06P3oool2000002@0oooo00<0oooD09^Ke03oool0203o
ool01@2jVkX0oooo0?ooo`2jLY/0e?oo0080oooo00<0oooD09^Ke03oool0103oool00`000000oooo
0?ooo`0k0?ooo`8000007@3oool00`000000oooo0?ooo`0B0?ooo`<00000403oool00`000000oooo
0?ooo`0>0?ooo`00403oool00`000000oooo0?ooo`0?0?ooo`<00000503oool00`000000oooo0?oo
o`0K0?ooo`8000008`3oool00`3DVi/0e?oo0?ooo`060?ooo`060?ooe02KL[X0oooo0?ooo`3DVg80
^^[o0`3oool00`3DVi/0e?oo0?ooo`030?ooo`<00000>@3oool2000001h0oooo00<000000?ooo`3o
ool04P3oool300000140oooo00<000000?ooo`3oool03P3oool00140oooo00<000000?ooo`3oool0
3`3oool3000001@0oooo0P00000M0?ooo`8000008@3oool00`3oe9/0L[[Z0?ooo`060?ooo`060?oo
e02KL[X0oooo0?ooo`3DVg80^^[o0`3oool00`3oe9/0L[[Z0?ooo`030?ooo`030000003oool0oooo
03P0oooo00<000000?ooo`3oool0703oool2000001@0oooo0`00000A0?ooo`030000003oool0oooo
00l0oooo000B0?ooo`030000003oool0oooo00l0oooo0`00000E0?ooo`030000003oool0oooo01`0
oooo0P00000L0?ooo`050?oZ^P1bVm@0oooo0?ooe02KL[X0203oool02P2jLW80^^[o0?ooe02K09/0
e?oo0?oZ^P1bVm@0oooo0?ooe02KL[X40?ooo`030000003oool0oooo03H0oooo0P00000N0?ooo`03
0000003oool0oooo01<0oooo0`00000A0?ooo`030000003oool0oooo0100oooo000B0?ooo`030000
003oool0oooo0100oooo0P00000F0?ooo`030000003oool0oooo01d0oooo0P00000J0?ooo`060?oZ
^P1b000000000000000009/0e?oo1`3oool01`3oj[X0LP000000002Ke?l0oooo0?oZ^P1b00000P00
00000`0009/0e?oo0?ooo`020?ooo`030000003oool0oooo03@0oooo0P00000O0?ooo`030000003o
ool0oooo01<0oooo0`00000A0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003oool0
oooo0100oooo0P00000F0?ooo`030000003oool0oooo01h0oooo0P00000c0?ooo`030000003oool0
oooo0380oooo0P00000P0?ooo`030000003oool0oooo01<0oooo0`00000B0?ooo`030000003oool0
oooo0140oooo000D0?ooo`030000003oool0oooo00l0oooo0`00000F0?ooo`030000003oool0oooo
01l0oooo0`00000`0?ooo`800000<@3oool200000240oooo00<000000?ooo`3oool04`3oool30000
0180oooo00<000000?ooo`3oool04P3oool001D0oooo00<000000?ooo`3oool03`3oool3000001H0
oooo0P00000R0?ooo`800000;P3oool00`000000oooo0?ooo`0^0?ooo`8000008@3oool2000001D0
oooo0`00000B0?ooo`030000003oool0oooo01<0oooo000F0?ooo`030000003oool0oooo00l0oooo
0`00000G0?ooo`030000003oool0oooo0240oooo0`00000[0?ooo`030000003oool0oooo02/0oooo
0`00000R0?ooo`030000003oool0oooo01@0oooo0`00000B0?ooo`030000003oool0oooo01@0oooo
000G0?ooo`030000003oool0oooo00l0oooo0`00000G0?ooo`030000003oool0oooo02<0oooo0`00
000X0?ooo`030000003oool0oooo02P0oooo0`00000T0?ooo`030000003oool0oooo01@0oooo0`00
000B0?ooo`030000003oool0oooo01D0oooo000H0?ooo`030000003oool0oooo00l0oooo0`00000G
0?ooo`8000009P3oool2000002H0oooo00<000000?ooo`3oool09P3oool2000002D0oooo0P00000F
0?ooo`<000004P3oool00`000000oooo0?ooo`0F0?ooo`006@3oool00`000000oooo0?ooo`0?0?oo
o`<00000603oool00`000000oooo0?ooo`0U0?ooo`<000008`3oool2000002@0oooo0`00000V0?oo
o`030000003oool0oooo01D0oooo0`00000B0?ooo`030000003oool0oooo01L0oooo000J0?ooo`03
0000003oool0oooo00l0oooo0`00000H0?ooo`800000:03oool300000200oooo00<000000?ooo`3o
ool0803oool3000002L0oooo0P00000G0?ooo`<000004P3oool00`000000oooo0?ooo`0H0?ooo`00
6`3oool00`000000oooo0?ooo`0?0?ooo`@00000603oool00`000000oooo0?ooo`0X0?ooo`800000
7P3oool00`000000oooo0?ooo`0M0?ooo`<00000:@3oool00`000000oooo0?ooo`0F0?ooo`<00000
4P3oool00`000000oooo0?ooo`0I0?ooo`002@3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo0100oooo1000000H0?ooo`800000:P3oool5000001T0oooo00<000000?ooo`3oool06@3o
ool4000002X0oooo0P00000G0?ooo`@000004`3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00P0oooo000:0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool04@3oool3
000001T0oooo00<000000?ooo`3oool0;03oool6000001<0oooo00<000000?ooo`3oool04`3oool6
000002d0oooo00<000000?ooo`3oool05P3oool4000001<0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`090?ooo`002`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
0140oooo0`00000I0?ooo`800000<P3oool4000000l0oooo0P00000?0?ooo`D00000<@3oool20000
01P0oooo0`00000D0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool02P3oool000`0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0A0?ooo`<000006P3oool00`000000
oooo0?ooo`0c0?ooo`P000001`3oool00`000000oooo0?ooo`050?ooo`T00000=@3oool00`000000
oooo0?ooo`0G0?ooo`<00000503oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00X0
oooo000<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool4000001T0oooo
0P00000k0?ooo`l00000?03oool2000001T0oooo0`00000D0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool02`3oool000d0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0A0?ooo`@000006P3oool200000400oooo00<000000?ooo`3oool0?`3oool2000001X0oooo0`00
000D0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0303oool000h0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0B0?ooo`<000006`3oool00`000000oooo0?ooo`0m
0?ooo`030000003oool0oooo03d0oooo0P00000K0?ooo`<00000503oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo00d0oooo000?0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool04P3oool3000001/0oooo0P00000m0?ooo`800000?03oool2000001`0oooo0`00000D0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool03P3oool00100oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0B0?ooo`<00000703oool2000003/0oooo00<000000?ooo`3o
ool0>@3oool2000001`0oooo1000000D0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool03P3oool00140oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0B0?ooo`@00000
703oool2000003T0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0K0?ooo`@00000
503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00l0oooo000B0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool04P3oool4000001d0oooo0P00000N0?ooo`030>ZjLP2K
e?l0oooo0080oooo00<0oooD09/00000L[X00`3oool0103Z^W8000000000001b^^X20?ooo`040=BK
00000000000007:jjP@0oooo00<000000?ooo`3oool0=P3oool2000001d0oooo0`00000E0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00180oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0C0?ooo`<000007P3oool2000001`0oooo00<0oooD09^Ke03oool0
203oool01`2jVkX0oooo0?ooo`2jLY/0e?oo0?ooe02KVm@00P3oool00`2jVkX0oooo0?ooo`020?oo
o`030000003oool0oooo03@0oooo0P00000N0?ooo`<000005@3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0503oool3000001l0oooo0P00000K0?ooo`030=BKV`3Dool0oooo00H0oooo00/0oooD09]b^P3o
ool0oooo0=BKLP2jj_l0oooo0;ZK^P3oool0oooD09^Ke0040?ooo`<00000<P3oool2000001l0oooo
0`00000E0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool001@0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0D0?ooo`@000007`3oool3000001P0oooo00<0
omBK07:jjP3oool01P3oool0203oom@0Vg:j0?ooo`3oool0e9]b0;[Zo`3oool0e9/00P0000000`1b
^^X0oooo0?ooo`020?ooo`030000003oool0oooo0300oooo0P00000O0?ooo`@000005@3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo000E0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0503oool400000240oooo0P00000C0?ooo`050?oZ^P1bVm@0oooo0?oo
e02KL[X0203oool02P2jLW80^^[o0?ooe02K09/0e?oo0?ooe02KL[X0oooo0?ooe02KL[X40?ooo`03
0000003oool0oooo02h0oooo0P00000P0?ooo`@000005@3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo01<0oooo000F0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
5@3oool300000280oooo0`00000@0?ooo`060?oZ^P1b000000000000000009/0e?oo1`3oool0103o
j[X0LP000000002Ke?l20?ooo`040>ZjLP000000000009_Do`@0oooo00<000000?ooo`3oool0:`3o
ool300000240oooo0`00000F0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0503o
ool001L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0E0?ooo`<00000903oool3
000002P0oooo00<000000?ooo`3oool0:03oool300000280oooo1000000F0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool05@3oool001P0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0E0?ooo`@000009@3oool2000002H0oooo0P00000W0?ooo`800000903oool40000
01H0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0F0?ooo`006@3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo01D0oooo1000000V0?ooo`<000008`3oool00`000000
oooo0?ooo`0S0?ooo`<00000903oool4000001L0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0G0?ooo`006P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01H0oooo
1000000W0?ooo`<00000803oool00`000000oooo0?ooo`0P0?ooo`<000009P3oool4000001L0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0H0?ooo`006`3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo01H0oooo1000000Y0?ooo`8000007P3oool00`000000oooo0?oo
o`0M0?ooo`<000009`3oool4000001P0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0I0?ooo`006`3oool00`000000oooo0?ooo`0A0?ooo`800000603oool4000002T0oooo1@00000I
0?ooo`030000003oool0oooo01T0oooo1000000Y0?ooo`@00000603oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo01T0oooo000L0?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool05P3oool4000002d0oooo1P00000C0?ooo`800000503oool6000002/0oooo1000000H0?oo
o`800000503oool00`000000oooo0?ooo`0J0?ooo`007@3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo01L0oooo1000000a0?ooo`@000003`3oool00`000000oooo0?ooo`0>0?ooo`D0
0000<03oool4000001P0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0K0?ooo`00
7P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01L0oooo1@00000c0?ooo`X00000
1@3oool00`000000oooo0?ooo`050?ooo`T00000<`3oool4000001T0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0L0?ooo`007`3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo01P0oooo1000000l0?ooo`d00000>P3oool5000001T0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0M0?ooo`00803oool00`000000oooo0?ooo`0B0?ooo`8000006P3oool4
000003l0oooo00<000000?ooo`3oool0?@3oool5000001X0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`0N0?ooo`008@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
01P0oooo1@00000m0?ooo`800000?@3oool4000001/0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`0O0?ooo`008P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01T0
oooo1@00000k0?ooo`030000003oool0oooo03X0oooo1000000L0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool0803oool002<0oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`0J0?ooo`@00000>P3oool00`000000oooo0?ooo`0h0?ooo`D000006`3oool2000001D0oooo
00<000000?ooo`3oool08@3oool002@0oooo00<000000?ooo`3oool04`3oool2000001`0oooo1000
000h0?ooo`030000003oool0oooo03H0oooo1@00000L0?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool08P3oool002D0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0J
0?ooo`D00000=P3oool00`000000oooo0?ooo`0d0?ooo`D000007@3oool00`000000oooo0?ooo`0D
0?ooo`030000003oool0oooo02<0oooo000V0?ooo`030000003oool0oooo01@0oooo00<000000?oo
o`3oool06`3oool6000003<0oooo0P00000c0?ooo`D000007@3oool2000001H0oooo00<000000?oo
o`3oool0903oool002H0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0L0?ooo`H0
0000<@3oool00`000000oooo0?ooo`0`0?ooo`D000007P3oool00`000000oooo0?ooo`0E0?ooo`03
0000003oool0oooo02D0oooo000W0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
7P3oool6000002h0oooo00<000000?ooo`3oool0;P3oool5000001l0oooo00<000000?ooo`3oool0
5@3oool00`000000oooo0?ooo`0V0?ooo`00:03oool00`000000oooo0?ooo`0E0?ooo`800000803o
ool6000001<0oooo00<0j[Yb09_Do`3oool00P3oool00`3oom@0V`00001b^P030?ooo`040>ZjLP00
0000000007:jjP80oooo00@0^W80000000000000L[[Z103oool00`000000oooo0?ooo`0/0?ooo`D0
00007`3oool2000001L0oooo00<000000?ooo`3oool09`3oool002T0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`0P0?ooo`H00000403oool00`3oom@0Vi_D0?ooo`080?ooo`050;ZK
^P3oool0oooo0;YbV`3Dool0103oool00`2jLY/0e?oo0?ooo`020?ooo`030000003oool0oooo02T0
oooo1P00000P0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0:03oool002X0oooo
00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0Q0?ooo`H000003`3oool00`3DVi/0e?oo
0?ooo`060?ooo`080?ooe02KL[X0oooo0?ooo`3DVg80^^[o0?ooo`3oe9/30000000409_Do`3oool0
oooo0?ooo`<000009P3oool700000240oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0Y0?ooo`00:`3oool00`000000oooo0?ooo`0F0?ooo`800000903oool6000000`0oooo00<0omBK
07:jjP3oool01P3oool0303oom@0Vg:j0?ooo`3oool0e9]b0;[Zo`3oom@0V`2K0=Coo`3oool0j[Yb
09_Do`<0oooo00<000000?ooo`3oool0903oool600000280oooo0P00000H0?ooo`030000003oool0
oooo02X0oooo000/0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool08`3oool70000
00H0oooo00D0onZj07:Ke03oool0oooD09]b^P080?ooo`0;0;YbLP2jj_l0oooD09/0V`3Dool0oooD
09/0V`3Dool0oooo0;YbV`3Dool00`3oool00`000000oooo0?ooo`0Q0?ooo`H00000903oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo02/0oooo000]0?ooo`030000003oool0oooo01L0
oooo0P00000V0?ooo`H00000103oool01P3oj[X0LP00000000000000002K0=Coo`L0oooo00@0onZj
078000000000VmCo0P3oool0103oe9/000000000001b^^X40?ooo`030000003oool0oooo01h0oooo
1`00000U0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0;03oool002h0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0V0?ooo`H00000703oool00`000000oooo0?oo
o`0K0?ooo`L000009P3oool2000001T0oooo00<000000?ooo`3oool0;@3oool002l0oooo0P00000I
0?ooo`800000:03oool:000001H0oooo0P00000F0?ooo`X00000:03oool00`000000oooo0?ooo`0H
0?ooo`030000003oool0oooo02h0oooo000a0?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool0:03oool=00000100oooo00<000000?ooo`3oool03`3oool<000002/0oooo00<000000?oo
o`3oool05`3oool200000340oooo000b0?ooo`030000003oool0oooo01P0oooo0P00000_0?ooo`T0
00003@3oool00`000000oooo0?ooo`0<0?ooo`T00000;`3oool2000001T0oooo00<000000?ooo`3o
ool0<@3oool003<0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0b0?ooo`d00000
0`3oool00`000000oooo0?ooo`020?ooo`h00000<`3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo0380oooo000d0?ooo`030000003oool0oooo01T0oooo0P00000d0?oooah00000=03o
ool2000001X0oooo00<000000?ooo`3oool0<`3oool003D0oooo0P00000K0?ooo`800000?03oool:
000003`0oooo0P00000K0?ooo`030000003oool0oooo03@0oooo000g0?ooo`030000003oool0oooo
01X0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0m0?ooo`800000703oool00`00
0000oooo0?ooo`0e0?ooo`00>03oool00`000000oooo0?ooo`0J0?ooo`800000?@3oool00`000000
oooo0?ooo`0k0?ooo`8000007@3oool00`000000oooo0?ooo`0f0?ooo`009`3oool0103Z^W800000
0000LP2jj_l>0?ooo`030000003oool0oooo01/0oooo0P0000040?ooo`060?oDV`00000000000000
000009/0e?oo<@3oool00`000000oooo0?ooo`0b0?ooo`070?oDV`00000000000000000009/0e?oo
0?ooo`02000001d0oooo0P00000A0?ooo`040>ZjLP000000001b0;[Zob@0oooo000X0?ooo`030?oD
V`1b^^X0oooo00l0oooo0P00000M0?ooo`8000000`3oool00`2jLP00002K0=Coo`0c0?ooo`030000
003oool0oooo03<0oooo00<0^W800000V`3Dool00P3oool00`000000oooo0?ooo`0L0?ooo`030000
003oool0oooo0180oooo00<0omBK07:jjP3oool0903oool002D0oooo00H0oooD09/0000000000000
0000LP2jj_lA0?ooo`030000003oool0oooo01`0oooo0P0000020?ooo`030?oDV`000000VmCo0380
oooo0P00000e0?ooo`040?oDV`0000000000000001h0oooo00<000000?ooo`3oool0403oool01P3o
om@0V`00000000000000001b0;[Zob@0oooo000O0?ooo`030?oDV`00000000000080000000H0VmCo
0?ooo`3DV`00VmCo0?oDV`1b^^XC0?ooo`030000003oool0oooo01L0oooo00<0omBK000000000000
0P0000001P2Ke?l000000000003oool0oooD0=CDoc80oooo00<000000?ooo`3oool0=03oool20000
00030=CDo`3oool0oooo01/0oooo0P00000D0?ooo`040=BK002Ke?l0omBK07:jjRD0oooo000V0?oo
o`040?ooe02K0780^[ZK07:jjQ@0oooo00<000000?ooo`3oool0703oool01P3oj[X0LW:j00000000
0000V`2K0=Cooc40oooo00<000000?ooo`3oool0<P3oool2000000040?ooo`3oom@0V`2K0=Cooa/0
oooo00<000000?ooo`3oool0503oool0103oom@0V`1b0;ZjV`1b^^XU0?ooo`009`3oool00`3oj[X0
LP0007:jjP0E0?ooo`030000003oool0oooo01`0oooo00<0j[Yb0000000000000`00000`0?ooo`03
0000003oool0oooo0300oooo0P0000001@3oool0j[Yb000000000000L[[Z01/0oooo00<000000?oo
o`3oool05P3oool00`3oj[X0LP0007:jjP0U0?ooo`00@03oool200000280oooo0P00000^0?ooo`03
0000003oool0oooo02h0oooo0P00000P0?ooo`800000@@3oool00480oooo00<000000?ooo`3oool0
8@3oool3000002/0oooo0P00000/0?ooo`<000008@3oool00`000000oooo0?ooo`110?ooo`00@`3o
ool00`000000oooo0?ooo`0S0?ooo`<00000:03oool00`000000oooo0?ooo`0X0?ooo`<000008`3o
ool00`000000oooo0?ooo`120?ooo`00A03oool2000002H0oooo0P00000V0?ooo`030000003oool0
oooo02H0oooo0P00000T0?ooo`800000A@3oool004H0oooo00<000000?ooo`3oool09@3oool30000
02<0oooo00<000000?ooo`3oool08`3oool3000002D0oooo00<000000?ooo`3oool0A@3oool004L0
oooo0P00000X0?ooo`<00000803oool00`000000oooo0?ooo`0P0?ooo`<000009`3oool00`000000
oooo0?ooo`160?ooo`000P3ooooo000002H000000`3oool000T0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`060?ooo`8000000`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0203oool5000000/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo1000000:0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool01@000000oooo0?ooo`3oool0000000T0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`080?ooo`00C03oool00`000000oooo0?oo
o`0/0?ooo`H000004`3oool00`000000oooo0?ooo`0C0?ooo`H00000;@3oool00`000000oooo0?oo
o`1:0?ooo`00C@3oool200000380oooo1000000?0?ooo`030000003oool0oooo00h0oooo1@00000a
0?ooo`800000C@3oool004l0oooo00<000000?ooo`3oool0<`3ooolP000003D0oooo00<000000?oo
o`3oool0C@3oool00500oooo0P0000120?ooo`030000003oool0oooo0440oooo0P00001@0?ooo`00
DP3oool200000400oooo00<000000?ooo`3oool0?`3oool200000580oooo001D0?ooo`800000?P3o
ool00`000000oooo0?ooo`0m0?ooo`800000E03oool005H0oooo0P00000l0?ooo`030000003oool0
oooo03/0oooo0P00001F0?ooo`00F03oool2000003X0oooo0P00000j0?ooo`800000F03oool005X0
oooo0P00000h0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0F03oool005`0oooo
0P00000f0?ooo`030000003oool0oooo03H0oooo0P00001K0?ooo`00GP3oool2000003@0oooo00<0
00000?ooo`3oool0=03oool2000005d0oooo001P0?ooo`800000<P3oool00`000000oooo0?ooo`0b
0?ooo`800000G`3oool00680oooo0P00000`0?ooo`800000<@3oool200000640oooo001T0?ooo`80
0000;P3oool00`000000oooo0?ooo`0^0?ooo`800000H`3oool006H0oooo0`00000[0?ooo`030000
003oool0oooo02/0oooo0`00001U0?ooo`00J@3oool3000002P0oooo00<000000?ooo`3oool0:03o
ool3000006P0oooo001/0?ooo`8000009P3oool00`000000oooo0?ooo`0V0?ooo`800000J`3oool0
06h0oooo0`00000S0?ooo`800000903oool3000006d0oooo001a0?ooo`@000007`3oool00`000000
oooo0?ooo`0O0?ooo`@00000L03oool007D0oooo1000000K0?ooo`030000003oool0oooo01X0oooo
1@00001d0?ooo`00N@3oool4000000<0oooo00<0oooD09/00000L[X00P3oool0203oom@0V`000000
00000000001b0;[Zo`3oom@0V`000P0000000`000780^^[o0?ooo`020?ooo`030000003oool0oooo
01L0oooo0`00001i0?ooo`00N`3oool00`3oom@0Vi_D00000003000000H0oooo00<0omBK07:jjP3o
ool00`3oool00`3oe9/0L[[Z0?ooo`040?ooo`030000003oool0oooo01<0oooo1000001l0?ooo`00
O03oool00`3DVi/0e?oo0?ooo`020?ooo`L0000000<0L[[Z0?ooo`3oool00P3oool00`3oe9/0L[[Z
0?ooo`040?ooo`<000002`3oool800000800oooo001l0?ooo`030?oDV`1b^^X0oooo00P0oooo00<0
omBK000000000000600000280?ooo`00N@3oool01@3oj[X0LY_D0?ooo`3oom@0Vg:j00P0oooo00<0
^W:K0=CDV`1b^^X00`3oool00`2jLY/0e=BK07:jjP050?ooo`030000003oool0oooo09<0oooo001i
0?ooo`060?oZ^P1b000000000000000009/0e?oo1`3oool00`3oe9/0000007:jjP030?ooo`030?oD
V`000000L[[Z00D0oooo00<000000?ooo`3oool0T`3oool009@0oooo00<000000?ooo`3oool0T`3o
ool009@0oooo0P00002D0?ooo`00\
\>"],
  ImageRangeCache->{{{137.188, 375.063}, {624.313, 477.75}} -> {-11.5382, \
7.27901, 0.0360393, 0.000403275}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["Clear[y2,y1,y,yp]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["DSolve[{x+y[x]^3*y'[x]==0,y[2]==5},y[x],x]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[BoxData[
    \({{y[x] \[Rule] \((633 - 2\ x\^2)\)\^\(1/4\)}}\)], "Output"],

Cell[BoxData[
    \(Clear[y, y1, y2, x]\)], "Input"]
}, Open  ]],

Cell["\<\
6. Rie\[SHacek]te diferenci\[AAcute]lnu rovnicu y'- 2y/x = (x^3) cos(x). 
    N\[AAcute]jdite partikul\[AAcute]rne rie\[SHacek]enie, ktor\[EAcute] sp\
\:013a\:0148a za\[CHacek]. podmienku 
    \t\ty(2)=5.
   Nakreslite integr\[AAcute]lnu krivku partikul\[AAcute]rneho \
rie\[SHacek]enia.
   Vypo\[CHacek]itajte y(1.2).
------------------------------------------------------------------------------\
---\
\>", "Section",
  PageBreakAbove->True,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Arial CE",
  FontColor->RGBColor[0, 0.500008, 0],
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["r=DSolve[y'[x]-2*y[x]/x==(x^3)*Cos[x],y[x],x]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{y[x] \[Rule] 
          x\^2\ C[1] + x\^2\ \((Cos[x] + x\ Sin[x])\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["y1[x_]=y[x]/.r[[1]]/.C[1]->c", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(c\ x\^2 + x\^2\ \((Cos[x] + x\ Sin[x])\)\)], "Output"]
}, Open  ]],

Cell["Clear[y]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
rp=DSolve[{y'[x]-2*y[x]/x==(x^3)*Cos[x],y[2]==5},
y[x],x]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({{y[x] \[Rule] 
          1\/4\ \((5\ x\^2 - 4\ x\^2\ Cos[2] + 4\ x\^2\ Cos[x] - 
                8\ x\^2\ Sin[2] + 4\ x\^3\ Sin[x])\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["yp[x_]=y[x]/.rp[[1]]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(1\/4\ \((5\ x\^2 - 4\ x\^2\ Cos[2] + 4\ x\^2\ Cos[x] - 
          8\ x\^2\ Sin[2] + 4\ x\^3\ Sin[x])\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
gp=Plot[yp[x],{x,-2Pi,2Pi},
PlotStyle->Thickness[0.008]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0757881 0.472424 0.00391201 [
[.04527 .45992 -6 -9 ]
[.04527 .45992 6 0 ]
[.19685 .45992 -6 -9 ]
[.19685 .45992 6 0 ]
[.34842 .45992 -6 -9 ]
[.34842 .45992 6 0 ]
[.65158 .45992 -3 -9 ]
[.65158 .45992 3 0 ]
[.80315 .45992 -3 -9 ]
[.80315 .45992 3 0 ]
[.95473 .45992 -3 -9 ]
[.95473 .45992 3 0 ]
[.4875 .00298 -24 -4.5 ]
[.4875 .00298 0 4.5 ]
[.4875 .08122 -24 -4.5 ]
[.4875 .08122 0 4.5 ]
[.4875 .15946 -18 -4.5 ]
[.4875 .15946 0 4.5 ]
[.4875 .2377 -18 -4.5 ]
[.4875 .2377 0 4.5 ]
[.4875 .31594 -18 -4.5 ]
[.4875 .31594 0 4.5 ]
[.4875 .39418 -18 -4.5 ]
[.4875 .39418 0 4.5 ]
[.4875 .55066 -12 -4.5 ]
[.4875 .55066 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04527 .47242 m
.04527 .47867 L
s
[(-6)] .04527 .45992 0 1 Mshowa
.19685 .47242 m
.19685 .47867 L
s
[(-4)] .19685 .45992 0 1 Mshowa
.34842 .47242 m
.34842 .47867 L
s
[(-2)] .34842 .45992 0 1 Mshowa
.65158 .47242 m
.65158 .47867 L
s
[(2)] .65158 .45992 0 1 Mshowa
.80315 .47242 m
.80315 .47867 L
s
[(4)] .80315 .45992 0 1 Mshowa
.95473 .47242 m
.95473 .47867 L
s
[(6)] .95473 .45992 0 1 Mshowa
.125 Mabswid
.08317 .47242 m
.08317 .47617 L
s
.12106 .47242 m
.12106 .47617 L
s
.15895 .47242 m
.15895 .47617 L
s
.23474 .47242 m
.23474 .47617 L
s
.27264 .47242 m
.27264 .47617 L
s
.31053 .47242 m
.31053 .47617 L
s
.38632 .47242 m
.38632 .47617 L
s
.42421 .47242 m
.42421 .47617 L
s
.46211 .47242 m
.46211 .47617 L
s
.53789 .47242 m
.53789 .47617 L
s
.57579 .47242 m
.57579 .47617 L
s
.61368 .47242 m
.61368 .47617 L
s
.68947 .47242 m
.68947 .47617 L
s
.72736 .47242 m
.72736 .47617 L
s
.76526 .47242 m
.76526 .47617 L
s
.84105 .47242 m
.84105 .47617 L
s
.87894 .47242 m
.87894 .47617 L
s
.91683 .47242 m
.91683 .47617 L
s
.00738 .47242 m
.00738 .47617 L
s
.99262 .47242 m
.99262 .47617 L
s
.25 Mabswid
0 .47242 m
1 .47242 L
s
.5 .00298 m
.50625 .00298 L
s
[(-120)] .4875 .00298 1 0 Mshowa
.5 .08122 m
.50625 .08122 L
s
[(-100)] .4875 .08122 1 0 Mshowa
.5 .15946 m
.50625 .15946 L
s
[(-80)] .4875 .15946 1 0 Mshowa
.5 .2377 m
.50625 .2377 L
s
[(-60)] .4875 .2377 1 0 Mshowa
.5 .31594 m
.50625 .31594 L
s
[(-40)] .4875 .31594 1 0 Mshowa
.5 .39418 m
.50625 .39418 L
s
[(-20)] .4875 .39418 1 0 Mshowa
.5 .55066 m
.50625 .55066 L
s
[(20)] .4875 .55066 1 0 Mshowa
.125 Mabswid
.5 .02254 m
.50375 .02254 L
s
.5 .0421 m
.50375 .0421 L
s
.5 .06166 m
.50375 .06166 L
s
.5 .10078 m
.50375 .10078 L
s
.5 .12034 m
.50375 .12034 L
s
.5 .1399 m
.50375 .1399 L
s
.5 .17902 m
.50375 .17902 L
s
.5 .19858 m
.50375 .19858 L
s
.5 .21814 m
.50375 .21814 L
s
.5 .25726 m
.50375 .25726 L
s
.5 .27682 m
.50375 .27682 L
s
.5 .29638 m
.50375 .29638 L
s
.5 .3355 m
.50375 .3355 L
s
.5 .35506 m
.50375 .35506 L
s
.5 .37462 m
.50375 .37462 L
s
.5 .41374 m
.50375 .41374 L
s
.5 .4333 m
.50375 .4333 L
s
.5 .45286 m
.50375 .45286 L
s
.5 .49198 m
.50375 .49198 L
s
.5 .51154 m
.50375 .51154 L
s
.5 .5311 m
.50375 .5311 L
s
.5 .57022 m
.50375 .57022 L
s
.5 .58978 m
.50375 .58978 L
s
.5 .60934 m
.50375 .60934 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .60332 m
.04262 .37761 L
.06244 .19899 L
.07286 .13036 L
.08255 .08163 L
.08813 .06002 L
.0932 .04423 L
.096 .03703 L
.09905 .03041 L
.10171 .02562 L
.10458 .02147 L
.10712 .01865 L
.10945 .01674 L
.11057 .01605 L
.11179 .01547 L
.11295 .01507 L
.11402 .01483 L
.11467 .01475 L
.11538 .01472 L
.11666 .01479 L
.11791 .01502 L
.11905 .01539 L
.1203 .01593 L
.12166 .01671 L
.12442 .01883 L
.12716 .02165 L
.12967 .02482 L
.13529 .03387 L
.14545 .05614 L
.16453 .11362 L
.18529 .18898 L
.22607 .33502 L
.24633 .3929 L
.26534 .4345 L
.28351 .46256 L
.29372 .47369 L
.30309 .48127 L
.30783 .48424 L
.31289 .48682 L
.31727 .48861 L
.32201 .4901 L
.32492 .49081 L
.32759 .49134 L
.33015 .49173 L
.33146 .49189 L
.33286 .49204 L
.33413 .49214 L
.33528 .49222 L
.33645 .49228 L
.33755 .49232 L
Mistroke
.33883 .49235 L
.34002 .49236 L
.34133 .49235 L
.34206 .49234 L
.34271 .49232 L
.34392 .49228 L
.34505 .49222 L
.34761 .49205 L
.3501 .49183 L
.35277 .49153 L
.362 .49012 L
.38283 .48568 L
.40268 .48121 L
.41315 .47912 L
.42425 .47723 L
.43411 .47584 L
.44498 .47464 L
.45487 .47382 L
.46414 .47326 L
.46886 .47304 L
.474 .47284 L
.47937 .47268 L
.48437 .47257 L
.48678 .47253 L
.48906 .47249 L
.49114 .47247 L
.49333 .47245 L
.49446 .47244 L
.49572 .47243 L
.49685 .47243 L
.49792 .47243 L
.49917 .47242 L
.50031 .47242 L
.50163 .47243 L
.50288 .47243 L
.50402 .47243 L
.50524 .47244 L
.50746 .47246 L
.5101 .47248 L
.51252 .47252 L
.51751 .47261 L
.52277 .47274 L
.52732 .47289 L
.53156 .47305 L
.54118 .47356 L
.55169 .47434 L
.56161 .47533 L
.58019 .47794 L
.60018 .48182 L
.61863 .48602 L
Mistroke
.62843 .48821 L
.63896 .49029 L
.64406 .49111 L
.64891 .49172 L
.65101 .49193 L
.65325 .49212 L
.65455 .4922 L
.65572 .49226 L
.65689 .49231 L
.658 .49234 L
.65914 .49236 L
.6602 .49236 L
.66136 .49235 L
.66261 .49232 L
.66392 .49226 L
.66515 .49219 L
.66627 .49211 L
.66747 .492 L
.66967 .49175 L
.672 .4914 L
.67619 .49056 L
.68101 .4892 L
.68554 .48751 L
.6905 .48515 L
.69585 .48198 L
.70543 .47447 L
.71591 .46329 L
.72684 .44793 L
.73701 .43004 L
.75749 .38303 L
.77608 .32813 L
.81608 .18382 L
.83441 .11723 L
.84483 .08336 L
.85457 .05611 L
.86416 .03488 L
.86954 .02594 L
.87446 .0199 L
.87714 .01754 L
.87842 .01665 L
.87963 .01597 L
.88032 .01564 L
.88106 .01534 L
.88235 .01496 L
.88309 .01482 L
.88387 .01474 L
.88453 .01472 L
.88526 .01475 L
.88595 .01483 L
.8866 .01495 L
Mistroke
.88782 .01532 L
.88914 .0159 L
.89056 .01675 L
.89313 .0189 L
.89551 .02158 L
.90016 .02889 L
.90517 .0399 L
.9099 .05343 L
.91422 .06858 L
.92479 .11722 L
.93484 .17946 L
.95464 .34918 L
.97302 .56174 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{137.188, 375.063}, {598.938, 452.375}} -> {-14.5393, \
373.537, 0.0454131, 0.879797}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
gvr=Table[Plot[y1[x],{x,-2Pi,2Pi}],
{c,1,3,0.5}]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0757881 0.324581 0.00353027 [
[.04527 .31208 -6 -9 ]
[.04527 .31208 6 0 ]
[.19685 .31208 -6 -9 ]
[.19685 .31208 6 0 ]
[.34842 .31208 -6 -9 ]
[.34842 .31208 6 0 ]
[.65158 .31208 -3 -9 ]
[.65158 .31208 3 0 ]
[.80315 .31208 -3 -9 ]
[.80315 .31208 3 0 ]
[.95473 .31208 -3 -9 ]
[.95473 .31208 3 0 ]
[.4875 .05981 -18 -4.5 ]
[.4875 .05981 0 4.5 ]
[.4875 .14807 -18 -4.5 ]
[.4875 .14807 0 4.5 ]
[.4875 .23632 -18 -4.5 ]
[.4875 .23632 0 4.5 ]
[.4875 .41284 -12 -4.5 ]
[.4875 .41284 0 4.5 ]
[.4875 .50109 -12 -4.5 ]
[.4875 .50109 0 4.5 ]
[.4875 .58935 -12 -4.5 ]
[.4875 .58935 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04527 .32458 m
.04527 .33083 L
s
[(-6)] .04527 .31208 0 1 Mshowa
.19685 .32458 m
.19685 .33083 L
s
[(-4)] .19685 .31208 0 1 Mshowa
.34842 .32458 m
.34842 .33083 L
s
[(-2)] .34842 .31208 0 1 Mshowa
.65158 .32458 m
.65158 .33083 L
s
[(2)] .65158 .31208 0 1 Mshowa
.80315 .32458 m
.80315 .33083 L
s
[(4)] .80315 .31208 0 1 Mshowa
.95473 .32458 m
.95473 .33083 L
s
[(6)] .95473 .31208 0 1 Mshowa
.125 Mabswid
.08317 .32458 m
.08317 .32833 L
s
.12106 .32458 m
.12106 .32833 L
s
.15895 .32458 m
.15895 .32833 L
s
.23474 .32458 m
.23474 .32833 L
s
.27264 .32458 m
.27264 .32833 L
s
.31053 .32458 m
.31053 .32833 L
s
.38632 .32458 m
.38632 .32833 L
s
.42421 .32458 m
.42421 .32833 L
s
.46211 .32458 m
.46211 .32833 L
s
.53789 .32458 m
.53789 .32833 L
s
.57579 .32458 m
.57579 .32833 L
s
.61368 .32458 m
.61368 .32833 L
s
.68947 .32458 m
.68947 .32833 L
s
.72736 .32458 m
.72736 .32833 L
s
.76526 .32458 m
.76526 .32833 L
s
.84105 .32458 m
.84105 .32833 L
s
.87894 .32458 m
.87894 .32833 L
s
.91683 .32458 m
.91683 .32833 L
s
.00738 .32458 m
.00738 .32833 L
s
.99262 .32458 m
.99262 .32833 L
s
.25 Mabswid
0 .32458 m
1 .32458 L
s
.5 .05981 m
.50625 .05981 L
s
[(-75)] .4875 .05981 1 0 Mshowa
.5 .14807 m
.50625 .14807 L
s
[(-50)] .4875 .14807 1 0 Mshowa
.5 .23632 m
.50625 .23632 L
s
[(-25)] .4875 .23632 1 0 Mshowa
.5 .41284 m
.50625 .41284 L
s
[(25)] .4875 .41284 1 0 Mshowa
.5 .50109 m
.50625 .50109 L
s
[(50)] .4875 .50109 1 0 Mshowa
.5 .58935 m
.50625 .58935 L
s
[(75)] .4875 .58935 1 0 Mshowa
.125 Mabswid
.5 .07746 m
.50375 .07746 L
s
.5 .09511 m
.50375 .09511 L
s
.5 .11276 m
.50375 .11276 L
s
.5 .13042 m
.50375 .13042 L
s
.5 .16572 m
.50375 .16572 L
s
.5 .18337 m
.50375 .18337 L
s
.5 .20102 m
.50375 .20102 L
s
.5 .21867 m
.50375 .21867 L
s
.5 .25398 m
.50375 .25398 L
s
.5 .27163 m
.50375 .27163 L
s
.5 .28928 m
.50375 .28928 L
s
.5 .30693 m
.50375 .30693 L
s
.5 .34223 m
.50375 .34223 L
s
.5 .35988 m
.50375 .35988 L
s
.5 .37753 m
.50375 .37753 L
s
.5 .39519 m
.50375 .39519 L
s
.5 .43049 m
.50375 .43049 L
s
.5 .44814 m
.50375 .44814 L
s
.5 .46579 m
.50375 .46579 L
s
.5 .48344 m
.50375 .48344 L
s
.5 .51875 m
.50375 .51875 L
s
.5 .5364 m
.50375 .5364 L
s
.5 .55405 m
.50375 .55405 L
s
.5 .5717 m
.50375 .5717 L
s
.5 .04216 m
.50375 .04216 L
s
.5 .02451 m
.50375 .02451 L
s
.5 .00686 m
.50375 .00686 L
s
.5 .607 m
.50375 .607 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.04262 .3872 L
.06244 .21344 L
.07286 .14513 L
.08255 .09536 L
.0932 .05539 L
.09916 .03931 L
.10458 .02838 L
.10941 .02145 L
.11185 .01891 L
.11325 .01773 L
.11454 .01683 L
.11563 .01618 L
.11682 .01562 L
.11808 .01517 L
.11928 .01489 L
.1204 .01475 L
.12159 .01472 L
.12271 .01481 L
.12373 .01499 L
.12503 .01535 L
.1264 .01589 L
.12887 .01725 L
.13152 .01926 L
.13443 .02208 L
.13964 .02862 L
.14451 .03632 L
.16486 .08136 L
.18342 .13343 L
.22326 .24668 L
.24148 .28876 L
.25186 .30853 L
.26159 .32413 L
.27191 .33752 L
.28137 .34707 L
.29148 .35456 L
.29679 .35745 L
.30238 .35978 L
.30495 .36062 L
.30738 .36129 L
.30958 .36179 L
.31192 .36222 L
.31313 .36241 L
.31447 .36258 L
.31569 .36271 L
.31681 .3628 L
.31813 .36289 L
.31886 .36292 L
.31955 .36295 L
.32078 .36297 L
Mistroke
.32147 .36297 L
.32212 .36297 L
.32327 .36295 L
.32452 .3629 L
.3257 .36284 L
.32679 .36277 L
.32884 .36258 L
.33101 .36233 L
.33553 .36162 L
.34048 .36059 L
.35072 .35782 L
.36003 .35474 L
.38096 .34697 L
.4017 .33954 L
.42086 .33384 L
.43948 .32969 L
.44888 .32812 L
.45924 .32676 L
.46417 .32624 L
.46936 .32578 L
.47862 .32515 L
.48379 .32491 L
.4886 .32474 L
.49136 .32467 L
.49387 .32463 L
.49526 .32461 L
.49599 .3246 L
.49677 .32459 L
.49744 .32459 L
.49819 .32458 L
.49949 .32458 L
.50079 .32458 L
.502 .32459 L
.50332 .32459 L
.50399 .3246 L
.50472 .32461 L
.50728 .32465 L
.50968 .3247 L
.51416 .32483 L
.51898 .32503 L
.52429 .32532 L
.52988 .32572 L
.53989 .32666 L
.54942 .32787 L
.5596 .32952 L
.57796 .33354 L
.59928 .33987 L
.61943 .34712 L
.63772 .35394 L
.64812 .35746 L
Mistroke
.65786 .3602 L
.66277 .36129 L
.66743 .36211 L
.67 .36245 L
.67136 .3626 L
.6728 .36273 L
.67414 .36283 L
.67535 .3629 L
.67657 .36295 L
.67771 .36297 L
.67894 .36297 L
.67963 .36296 L
.68028 .36295 L
.68158 .3629 L
.68231 .36286 L
.68298 .36282 L
.68417 .36272 L
.68547 .36258 L
.68782 .36226 L
.69057 .36176 L
.6935 .36106 L
.69875 .35937 L
.70364 .35724 L
.70813 .3548 L
.71823 .34742 L
.72714 .3386 L
.73652 .32682 L
.75628 .29331 L
.77465 .25194 L
.81371 .14189 L
.83364 .0853 L
.84413 .05929 L
.85523 .03677 L
.86001 .02912 L
.86515 .02254 L
.86809 .0196 L
.87078 .01749 L
.87207 .01668 L
.87348 .01595 L
.87481 .01541 L
.87605 .01504 L
.87726 .01482 L
.87856 .01472 L
.8798 .01476 L
.88093 .01493 L
.88195 .01518 L
.88308 .01558 L
.88425 .01612 L
.88534 .01675 L
.88784 .01864 L
Mistroke
.89012 .02091 L
.89523 .02807 L
.90006 .03753 L
.90518 .05058 L
.91437 .08227 L
.92426 .12894 L
.93515 .19627 L
.95455 .35888 L
.97543 .59362 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{137.188, 375.063}, {206.438, 59.875}} -> {-14.2509, \
-20.4229, 0.0445123, 0.955593}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0757881 0.269581 0.00338148 [
[.04527 .25708 -6 -9 ]
[.04527 .25708 6 0 ]
[.19685 .25708 -6 -9 ]
[.19685 .25708 6 0 ]
[.34842 .25708 -6 -9 ]
[.34842 .25708 6 0 ]
[.65158 .25708 -3 -9 ]
[.65158 .25708 3 0 ]
[.80315 .25708 -3 -9 ]
[.80315 .25708 3 0 ]
[.95473 .25708 -3 -9 ]
[.95473 .25708 3 0 ]
[.4875 .01597 -18 -4.5 ]
[.4875 .01597 0 4.5 ]
[.4875 .10051 -18 -4.5 ]
[.4875 .10051 0 4.5 ]
[.4875 .18504 -18 -4.5 ]
[.4875 .18504 0 4.5 ]
[.4875 .35412 -12 -4.5 ]
[.4875 .35412 0 4.5 ]
[.4875 .43865 -12 -4.5 ]
[.4875 .43865 0 4.5 ]
[.4875 .52319 -12 -4.5 ]
[.4875 .52319 0 4.5 ]
[.4875 .60773 -18 -4.5 ]
[.4875 .60773 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04527 .26958 m
.04527 .27583 L
s
[(-6)] .04527 .25708 0 1 Mshowa
.19685 .26958 m
.19685 .27583 L
s
[(-4)] .19685 .25708 0 1 Mshowa
.34842 .26958 m
.34842 .27583 L
s
[(-2)] .34842 .25708 0 1 Mshowa
.65158 .26958 m
.65158 .27583 L
s
[(2)] .65158 .25708 0 1 Mshowa
.80315 .26958 m
.80315 .27583 L
s
[(4)] .80315 .25708 0 1 Mshowa
.95473 .26958 m
.95473 .27583 L
s
[(6)] .95473 .25708 0 1 Mshowa
.125 Mabswid
.08317 .26958 m
.08317 .27333 L
s
.12106 .26958 m
.12106 .27333 L
s
.15895 .26958 m
.15895 .27333 L
s
.23474 .26958 m
.23474 .27333 L
s
.27264 .26958 m
.27264 .27333 L
s
.31053 .26958 m
.31053 .27333 L
s
.38632 .26958 m
.38632 .27333 L
s
.42421 .26958 m
.42421 .27333 L
s
.46211 .26958 m
.46211 .27333 L
s
.53789 .26958 m
.53789 .27333 L
s
.57579 .26958 m
.57579 .27333 L
s
.61368 .26958 m
.61368 .27333 L
s
.68947 .26958 m
.68947 .27333 L
s
.72736 .26958 m
.72736 .27333 L
s
.76526 .26958 m
.76526 .27333 L
s
.84105 .26958 m
.84105 .27333 L
s
.87894 .26958 m
.87894 .27333 L
s
.91683 .26958 m
.91683 .27333 L
s
.00738 .26958 m
.00738 .27333 L
s
.99262 .26958 m
.99262 .27333 L
s
.25 Mabswid
0 .26958 m
1 .26958 L
s
.5 .01597 m
.50625 .01597 L
s
[(-75)] .4875 .01597 1 0 Mshowa
.5 .10051 m
.50625 .10051 L
s
[(-50)] .4875 .10051 1 0 Mshowa
.5 .18504 m
.50625 .18504 L
s
[(-25)] .4875 .18504 1 0 Mshowa
.5 .35412 m
.50625 .35412 L
s
[(25)] .4875 .35412 1 0 Mshowa
.5 .43865 m
.50625 .43865 L
s
[(50)] .4875 .43865 1 0 Mshowa
.5 .52319 m
.50625 .52319 L
s
[(75)] .4875 .52319 1 0 Mshowa
.5 .60773 m
.50625 .60773 L
s
[(100)] .4875 .60773 1 0 Mshowa
.125 Mabswid
.5 .03288 m
.50375 .03288 L
s
.5 .04978 m
.50375 .04978 L
s
.5 .06669 m
.50375 .06669 L
s
.5 .0836 m
.50375 .0836 L
s
.5 .11741 m
.50375 .11741 L
s
.5 .13432 m
.50375 .13432 L
s
.5 .15123 m
.50375 .15123 L
s
.5 .16814 m
.50375 .16814 L
s
.5 .20195 m
.50375 .20195 L
s
.5 .21886 m
.50375 .21886 L
s
.5 .23577 m
.50375 .23577 L
s
.5 .25267 m
.50375 .25267 L
s
.5 .28649 m
.50375 .28649 L
s
.5 .3034 m
.50375 .3034 L
s
.5 .3203 m
.50375 .3203 L
s
.5 .33721 m
.50375 .33721 L
s
.5 .37103 m
.50375 .37103 L
s
.5 .38793 m
.50375 .38793 L
s
.5 .40484 m
.50375 .40484 L
s
.5 .42175 m
.50375 .42175 L
s
.5 .45556 m
.50375 .45556 L
s
.5 .47247 m
.50375 .47247 L
s
.5 .48938 m
.50375 .48938 L
s
.5 .50628 m
.50375 .50628 L
s
.5 .5401 m
.50375 .5401 L
s
.5 .55701 m
.50375 .55701 L
s
.5 .57391 m
.50375 .57391 L
s
.5 .59082 m
.50375 .59082 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.04262 .39114 L
.06244 .21948 L
.07286 .1514 L
.08255 .10131 L
.0932 .06045 L
.09916 .04363 L
.10458 .03189 L
.10941 .02413 L
.11185 .02114 L
.11454 .01853 L
.11682 .01686 L
.11811 .01614 L
.11928 .01561 L
.12037 .01523 L
.12156 .01493 L
.12268 .01477 L
.12373 .01472 L
.12503 .01477 L
.12577 .01487 L
.12644 .015 L
.12769 .01533 L
.129 .01581 L
.13128 .01695 L
.13379 .01866 L
.13933 .02397 L
.14451 .03067 L
.15496 .04854 L
.16486 .06967 L
.18342 .11599 L
.22175 .21404 L
.24152 .25502 L
.25163 .27199 L
.26253 .28704 L
.27269 .29803 L
.282 .30564 L
.29091 .31083 L
.29538 .31272 L
.30028 .31428 L
.30282 .31489 L
.30557 .31541 L
.30683 .31559 L
.30816 .31576 L
.30932 .31587 L
.31056 .31597 L
.31176 .31604 L
.31285 .31608 L
.31395 .31611 L
.315 .31611 L
.31621 .31609 L
Mistroke
.31734 .31605 L
.31858 .31598 L
.31989 .31589 L
.32261 .31561 L
.32556 .3152 L
.33089 .31417 L
.34084 .31145 L
.36082 .3039 L
.3819 .2948 L
.4018 .28672 L
.41992 .28057 L
.43947 .27556 L
.45022 .27351 L
.4604 .27201 L
.47008 .27094 L
.47496 .27052 L
.48035 .27016 L
.48493 .26992 L
.48733 .26982 L
.48986 .26973 L
.49208 .26967 L
.49326 .26965 L
.49452 .26962 L
.49567 .26961 L
.49673 .2696 L
.49778 .26959 L
.49878 .26958 L
.49994 .26958 L
.50118 .26958 L
.50235 .26959 L
.50342 .2696 L
.50468 .26961 L
.50604 .26963 L
.50853 .26969 L
.51112 .26976 L
.51388 .26987 L
.51883 .27011 L
.52336 .2704 L
.52761 .27073 L
.5373 .27172 L
.54711 .27308 L
.55746 .27492 L
.57595 .27937 L
.59567 .28578 L
.61403 .29306 L
.63274 .30115 L
.65304 .30937 L
.65843 .31122 L
.66413 .31293 L
.66941 .31424 L
Mistroke
.672 .31477 L
.67436 .31518 L
.67657 .31551 L
.67898 .31578 L
.6803 .3159 L
.68153 .31599 L
.6827 .31605 L
.68395 .31609 L
.68467 .3161 L
.68532 .31611 L
.68604 .31611 L
.6868 .31609 L
.68808 .31605 L
.68881 .31601 L
.68949 .31597 L
.69076 .31587 L
.69191 .31575 L
.69451 .31539 L
.6968 .31497 L
.69932 .31439 L
.70443 .31279 L
.70916 .31079 L
.71361 .30844 L
.7236 .30134 L
.73437 .2907 L
.74395 .2785 L
.75443 .26216 L
.77553 .22023 L
.81611 .11722 L
.83486 .07031 L
.84473 .04914 L
.85518 .03112 L
.86047 .02419 L
.86328 .02121 L
.8663 .01859 L
.86906 .01676 L
.87037 .01608 L
.87159 .01557 L
.8728 .01518 L
.87345 .01502 L
.87413 .01489 L
.87539 .01474 L
.87654 .01472 L
.87781 .01483 L
.87844 .01494 L
.87914 .01509 L
.88038 .01548 L
.88153 .01596 L
.88414 .0175 L
.8856 .01865 L
Mistroke
.88693 .01987 L
.89195 .02607 L
.8967 .03436 L
.90131 .04479 L
.90639 .05913 L
.91666 .0978 L
.92618 .14584 L
.9351 .20205 L
.95534 .37088 L
.97386 .57455 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{137.188, 375.063}, {360.375, 213.813}} -> {-14.3663, \
189.07, 0.0448727, 1.00572}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0757881 0.219393 0.00324166 [
[.04527 .20689 -6 -9 ]
[.04527 .20689 6 0 ]
[.19685 .20689 -6 -9 ]
[.19685 .20689 6 0 ]
[.34842 .20689 -6 -9 ]
[.34842 .20689 6 0 ]
[.65158 .20689 -3 -9 ]
[.65158 .20689 3 0 ]
[.80315 .20689 -3 -9 ]
[.80315 .20689 3 0 ]
[.95473 .20689 -3 -9 ]
[.95473 .20689 3 0 ]
[.4875 .05731 -18 -4.5 ]
[.4875 .05731 0 4.5 ]
[.4875 .13835 -18 -4.5 ]
[.4875 .13835 0 4.5 ]
[.4875 .30043 -12 -4.5 ]
[.4875 .30043 0 4.5 ]
[.4875 .38148 -12 -4.5 ]
[.4875 .38148 0 4.5 ]
[.4875 .46252 -12 -4.5 ]
[.4875 .46252 0 4.5 ]
[.4875 .54356 -18 -4.5 ]
[.4875 .54356 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04527 .21939 m
.04527 .22564 L
s
[(-6)] .04527 .20689 0 1 Mshowa
.19685 .21939 m
.19685 .22564 L
s
[(-4)] .19685 .20689 0 1 Mshowa
.34842 .21939 m
.34842 .22564 L
s
[(-2)] .34842 .20689 0 1 Mshowa
.65158 .21939 m
.65158 .22564 L
s
[(2)] .65158 .20689 0 1 Mshowa
.80315 .21939 m
.80315 .22564 L
s
[(4)] .80315 .20689 0 1 Mshowa
.95473 .21939 m
.95473 .22564 L
s
[(6)] .95473 .20689 0 1 Mshowa
.125 Mabswid
.08317 .21939 m
.08317 .22314 L
s
.12106 .21939 m
.12106 .22314 L
s
.15895 .21939 m
.15895 .22314 L
s
.23474 .21939 m
.23474 .22314 L
s
.27264 .21939 m
.27264 .22314 L
s
.31053 .21939 m
.31053 .22314 L
s
.38632 .21939 m
.38632 .22314 L
s
.42421 .21939 m
.42421 .22314 L
s
.46211 .21939 m
.46211 .22314 L
s
.53789 .21939 m
.53789 .22314 L
s
.57579 .21939 m
.57579 .22314 L
s
.61368 .21939 m
.61368 .22314 L
s
.68947 .21939 m
.68947 .22314 L
s
.72736 .21939 m
.72736 .22314 L
s
.76526 .21939 m
.76526 .22314 L
s
.84105 .21939 m
.84105 .22314 L
s
.87894 .21939 m
.87894 .22314 L
s
.91683 .21939 m
.91683 .22314 L
s
.00738 .21939 m
.00738 .22314 L
s
.99262 .21939 m
.99262 .22314 L
s
.25 Mabswid
0 .21939 m
1 .21939 L
s
.5 .05731 m
.50625 .05731 L
s
[(-50)] .4875 .05731 1 0 Mshowa
.5 .13835 m
.50625 .13835 L
s
[(-25)] .4875 .13835 1 0 Mshowa
.5 .30043 m
.50625 .30043 L
s
[(25)] .4875 .30043 1 0 Mshowa
.5 .38148 m
.50625 .38148 L
s
[(50)] .4875 .38148 1 0 Mshowa
.5 .46252 m
.50625 .46252 L
s
[(75)] .4875 .46252 1 0 Mshowa
.5 .54356 m
.50625 .54356 L
s
[(100)] .4875 .54356 1 0 Mshowa
.125 Mabswid
.5 .07352 m
.50375 .07352 L
s
.5 .08973 m
.50375 .08973 L
s
.5 .10593 m
.50375 .10593 L
s
.5 .12214 m
.50375 .12214 L
s
.5 .15456 m
.50375 .15456 L
s
.5 .17077 m
.50375 .17077 L
s
.5 .18698 m
.50375 .18698 L
s
.5 .20318 m
.50375 .20318 L
s
.5 .2356 m
.50375 .2356 L
s
.5 .25181 m
.50375 .25181 L
s
.5 .26802 m
.50375 .26802 L
s
.5 .28423 m
.50375 .28423 L
s
.5 .31664 m
.50375 .31664 L
s
.5 .33285 m
.50375 .33285 L
s
.5 .34906 m
.50375 .34906 L
s
.5 .36527 m
.50375 .36527 L
s
.5 .39768 m
.50375 .39768 L
s
.5 .41389 m
.50375 .41389 L
s
.5 .4301 m
.50375 .4301 L
s
.5 .44631 m
.50375 .44631 L
s
.5 .47873 m
.50375 .47873 L
s
.5 .49493 m
.50375 .49493 L
s
.5 .51114 m
.50375 .51114 L
s
.5 .52735 m
.50375 .52735 L
s
.5 .0411 m
.50375 .0411 L
s
.5 .02489 m
.50375 .02489 L
s
.5 .00869 m
.50375 .00869 L
s
.5 .55977 m
.50375 .55977 L
s
.5 .57598 m
.50375 .57598 L
s
.5 .59218 m
.50375 .59218 L
s
.5 .60839 m
.50375 .60839 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.04262 .39496 L
.06244 .22539 L
.07286 .15759 L
.08255 .10726 L
.0932 .06561 L
.09916 .04813 L
.10458 .03565 L
.10941 .02714 L
.11206 .02348 L
.11454 .02065 L
.11682 .01856 L
.11891 .01705 L
.12123 .01583 L
.12251 .01535 L
.12373 .01502 L
.12503 .0148 L
.12622 .01472 L
.12688 .01472 L
.12759 .01476 L
.12888 .01493 L
.13009 .0152 L
.13137 .01561 L
.13366 .01662 L
.13634 .01826 L
.13883 .02021 L
.14451 .02602 L
.15496 .04109 L
.16486 .05945 L
.18342 .10043 L
.22175 .188 L
.24152 .22428 L
.25163 .23911 L
.26253 .25204 L
.27269 .26125 L
.27714 .26444 L
.282 .26737 L
.28631 .26948 L
.29091 .27127 L
.29345 .27206 L
.29576 .27265 L
.2981 .27314 L
.30028 .2735 L
.30259 .27378 L
.30381 .27389 L
.30513 .27397 L
.30579 .274 L
.3065 .27402 L
.30781 .27405 L
.30908 .27404 L
Mistroke
.31026 .27401 L
.31147 .27395 L
.3126 .27388 L
.31472 .27368 L
.317 .2734 L
.31947 .27301 L
.32474 .27191 L
.3303 .27039 L
.34026 .26691 L
.37829 .24924 L
.39947 .23952 L
.41876 .23213 L
.42836 .2291 L
.43878 .22632 L
.44856 .22418 L
.45772 .22256 L
.46715 .22127 L
.47257 .22069 L
.47754 .22026 L
.48247 .21992 L
.48766 .21965 L
.49036 .21955 L
.49287 .21948 L
.49431 .21945 L
.49562 .21943 L
.49635 .21942 L
.49713 .21941 L
.49787 .2194 L
.49856 .2194 L
.49982 .21939 L
.50101 .21939 L
.50208 .2194 L
.50325 .21941 L
.50451 .21943 L
.50586 .21945 L
.50828 .21951 L
.5105 .21958 L
.51259 .21966 L
.51736 .21991 L
.52254 .22027 L
.52729 .22068 L
.53801 .22194 L
.5478 .22349 L
.55691 .22532 L
.57761 .23093 L
.59804 .23848 L
.61662 .24679 L
.6374 .2569 L
.65657 .26564 L
.66621 .26927 L
Mistroke
.67523 .2719 L
.67976 .27287 L
.6821 .27327 L
.68464 .27361 L
.68608 .27376 L
.68742 .27388 L
.68869 .27396 L
.68941 .27399 L
.69005 .27402 L
.69128 .27404 L
.69197 .27405 L
.6926 .27404 L
.69377 .27402 L
.695 .27396 L
.69622 .27388 L
.69755 .27376 L
.69997 .27347 L
.70232 .27306 L
.70449 .27259 L
.70942 .27116 L
.71465 .26905 L
.72337 .2641 L
.73299 .25644 L
.7431 .24576 L
.75236 .23358 L
.77322 .19808 L
.81286 .10919 L
.83284 .06414 L
.84155 .04717 L
.85099 .03188 L
.85624 .02514 L
.86109 .02028 L
.86348 .01839 L
.86572 .01696 L
.86805 .01583 L
.86929 .01539 L
.87061 .01503 L
.87129 .0149 L
.87201 .0148 L
.8733 .01472 L
.8741 .01473 L
.87484 .01478 L
.87551 .01487 L
.87623 .01501 L
.87688 .01517 L
.87759 .01538 L
.87901 .01593 L
.88034 .0166 L
.88157 .01736 L
.8841 .01934 L
Mistroke
.8864 .02165 L
.89157 .02868 L
.8964 .03767 L
.90152 .04991 L
.91071 .07929 L
.92059 .12227 L
.93149 .18411 L
.95089 .33358 L
.97176 .55034 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{137.188, 375.063}, {514.313, 367.75}} -> {-14.2509, \
410.703, 0.0445123, 1.04067}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0757881 0.173593 0.00311002 [
[.04527 .16109 -6 -9 ]
[.04527 .16109 6 0 ]
[.19685 .16109 -6 -9 ]
[.19685 .16109 6 0 ]
[.34842 .16109 -6 -9 ]
[.34842 .16109 6 0 ]
[.65158 .16109 -3 -9 ]
[.65158 .16109 3 0 ]
[.80315 .16109 -3 -9 ]
[.80315 .16109 3 0 ]
[.95473 .16109 -3 -9 ]
[.95473 .16109 3 0 ]
[.4875 .01809 -18 -4.5 ]
[.4875 .01809 0 4.5 ]
[.4875 .09584 -18 -4.5 ]
[.4875 .09584 0 4.5 ]
[.4875 .25134 -12 -4.5 ]
[.4875 .25134 0 4.5 ]
[.4875 .32909 -12 -4.5 ]
[.4875 .32909 0 4.5 ]
[.4875 .40685 -12 -4.5 ]
[.4875 .40685 0 4.5 ]
[.4875 .4846 -18 -4.5 ]
[.4875 .4846 0 4.5 ]
[.4875 .56235 -18 -4.5 ]
[.4875 .56235 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04527 .17359 m
.04527 .17984 L
s
[(-6)] .04527 .16109 0 1 Mshowa
.19685 .17359 m
.19685 .17984 L
s
[(-4)] .19685 .16109 0 1 Mshowa
.34842 .17359 m
.34842 .17984 L
s
[(-2)] .34842 .16109 0 1 Mshowa
.65158 .17359 m
.65158 .17984 L
s
[(2)] .65158 .16109 0 1 Mshowa
.80315 .17359 m
.80315 .17984 L
s
[(4)] .80315 .16109 0 1 Mshowa
.95473 .17359 m
.95473 .17984 L
s
[(6)] .95473 .16109 0 1 Mshowa
.125 Mabswid
.08317 .17359 m
.08317 .17734 L
s
.12106 .17359 m
.12106 .17734 L
s
.15895 .17359 m
.15895 .17734 L
s
.23474 .17359 m
.23474 .17734 L
s
.27264 .17359 m
.27264 .17734 L
s
.31053 .17359 m
.31053 .17734 L
s
.38632 .17359 m
.38632 .17734 L
s
.42421 .17359 m
.42421 .17734 L
s
.46211 .17359 m
.46211 .17734 L
s
.53789 .17359 m
.53789 .17734 L
s
.57579 .17359 m
.57579 .17734 L
s
.61368 .17359 m
.61368 .17734 L
s
.68947 .17359 m
.68947 .17734 L
s
.72736 .17359 m
.72736 .17734 L
s
.76526 .17359 m
.76526 .17734 L
s
.84105 .17359 m
.84105 .17734 L
s
.87894 .17359 m
.87894 .17734 L
s
.91683 .17359 m
.91683 .17734 L
s
.00738 .17359 m
.00738 .17734 L
s
.99262 .17359 m
.99262 .17734 L
s
.25 Mabswid
0 .17359 m
1 .17359 L
s
.5 .01809 m
.50625 .01809 L
s
[(-50)] .4875 .01809 1 0 Mshowa
.5 .09584 m
.50625 .09584 L
s
[(-25)] .4875 .09584 1 0 Mshowa
.5 .25134 m
.50625 .25134 L
s
[(25)] .4875 .25134 1 0 Mshowa
.5 .32909 m
.50625 .32909 L
s
[(50)] .4875 .32909 1 0 Mshowa
.5 .40685 m
.50625 .40685 L
s
[(75)] .4875 .40685 1 0 Mshowa
.5 .4846 m
.50625 .4846 L
s
[(100)] .4875 .4846 1 0 Mshowa
.5 .56235 m
.50625 .56235 L
s
[(125)] .4875 .56235 1 0 Mshowa
.125 Mabswid
.5 .03364 m
.50375 .03364 L
s
.5 .04919 m
.50375 .04919 L
s
.5 .06474 m
.50375 .06474 L
s
.5 .08029 m
.50375 .08029 L
s
.5 .11139 m
.50375 .11139 L
s
.5 .12694 m
.50375 .12694 L
s
.5 .14249 m
.50375 .14249 L
s
.5 .15804 m
.50375 .15804 L
s
.5 .18914 m
.50375 .18914 L
s
.5 .20469 m
.50375 .20469 L
s
.5 .22024 m
.50375 .22024 L
s
.5 .23579 m
.50375 .23579 L
s
.5 .26689 m
.50375 .26689 L
s
.5 .28244 m
.50375 .28244 L
s
.5 .29799 m
.50375 .29799 L
s
.5 .31354 m
.50375 .31354 L
s
.5 .34464 m
.50375 .34464 L
s
.5 .36019 m
.50375 .36019 L
s
.5 .37575 m
.50375 .37575 L
s
.5 .3913 m
.50375 .3913 L
s
.5 .4224 m
.50375 .4224 L
s
.5 .43795 m
.50375 .43795 L
s
.5 .4535 m
.50375 .4535 L
s
.5 .46905 m
.50375 .46905 L
s
.5 .50015 m
.50375 .50015 L
s
.5 .5157 m
.50375 .5157 L
s
.5 .53125 m
.50375 .53125 L
s
.5 .5468 m
.50375 .5468 L
s
.5 .00254 m
.50375 .00254 L
s
.5 .5779 m
.50375 .5779 L
s
.5 .59345 m
.50375 .59345 L
s
.5 .609 m
.50375 .609 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.04262 .39867 L
.06244 .23118 L
.07286 .16369 L
.08255 .11319 L
.0932 .07085 L
.09916 .05278 L
.10458 .03965 L
.10941 .03045 L
.11206 .02638 L
.11454 .02315 L
.11891 .01879 L
.12123 .01713 L
.12244 .01645 L
.12373 .01585 L
.12511 .01535 L
.12639 .01502 L
.12717 .01487 L
.12791 .01478 L
.12857 .01473 L
.12929 .01472 L
.12993 .01473 L
.13063 .01478 L
.13136 .01487 L
.13205 .01499 L
.13327 .01528 L
.13458 .0157 L
.13725 .01689 L
.13977 .01842 L
.14451 .02229 L
.1491 .02714 L
.15416 .03364 L
.16442 .04978 L
.18284 .0854 L
.20381 .12937 L
.22304 .16677 L
.24189 .19688 L
.25148 .20904 L
.26173 .21948 L
.26705 .22386 L
.27207 .22736 L
.27696 .23017 L
.28147 .23227 L
.28575 .23384 L
.29028 .23507 L
.29263 .23553 L
.29483 .23587 L
.29607 .23602 L
.29725 .23613 L
.29789 .23618 L
Mistroke
.2986 .23623 L
.29984 .23629 L
.30049 .23631 L
.30117 .23632 L
.3024 .23632 L
.30372 .2363 L
.30447 .23627 L
.30517 .23623 L
.30644 .23615 L
.30759 .23605 L
.31018 .23575 L
.31249 .23539 L
.315 .23492 L
.31955 .23384 L
.33046 .23026 L
.34054 .22596 L
.37985 .20541 L
.41766 .18801 L
.43704 .18172 L
.44794 .17904 L
.45791 .17709 L
.46774 .17561 L
.47687 .17462 L
.48213 .1742 L
.4869 .17392 L
.48954 .1738 L
.49093 .17375 L
.4924 .1737 L
.49369 .17367 L
.4951 .17364 L
.49639 .17362 L
.49759 .1736 L
.49885 .1736 L
.49948 .17359 L
.50018 .17359 L
.50142 .1736 L
.50258 .17361 L
.50325 .17361 L
.50395 .17362 L
.5052 .17364 L
.50655 .17367 L
.50802 .17372 L
.5105 .1738 L
.51315 .17392 L
.51792 .17421 L
.52291 .1746 L
.52763 .17507 L
.53647 .17619 L
.54617 .17783 L
.55645 .18005 L
Mistroke
.5749 .18536 L
.59445 .19291 L
.61275 .20158 L
.65155 .22213 L
.66166 .22696 L
.6727 .23142 L
.67774 .23307 L
.68312 .2345 L
.68573 .23506 L
.68819 .2355 L
.69041 .23582 L
.69279 .23608 L
.69405 .23618 L
.6952 .23625 L
.69636 .2363 L
.69745 .23632 L
.69872 .23632 L
.6999 .2363 L
.70119 .23624 L
.70184 .2362 L
.70256 .23615 L
.70513 .23588 L
.70657 .23567 L
.70789 .23544 L
.71288 .23425 L
.71718 .23281 L
.72189 .23075 L
.73136 .22503 L
.74165 .21633 L
.75099 .20613 L
.77194 .17553 L
.81194 .09629 L
.83028 .05936 L
.84069 .04129 L
.84578 .03372 L
.85043 .0277 L
.85502 .02274 L
.86002 .01857 L
.86276 .01688 L
.8641 .01623 L
.86531 .01574 L
.86647 .01535 L
.86774 .01503 L
.86843 .0149 L
.86907 .01481 L
.87032 .01472 L
.87154 .01474 L
.87285 .01488 L
.87409 .01512 L
.87521 .01545 L
Mistroke
.87653 .01596 L
.87796 .01666 L
.88057 .01837 L
.88329 .02077 L
.88618 .02403 L
.89137 .03178 L
.89628 .04152 L
.90077 .05259 L
.91089 .08556 L
.92027 .12671 L
.92919 .17586 L
.94899 .32152 L
.96737 .50207 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{137.188, 375.063}, {668.25, 521.688}} -> {-14.2509, \
651.538, 0.0445123, 1.08472}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0757881 0.131798 0.00298594 [
[.04527 .1193 -6 -9 ]
[.04527 .1193 6 0 ]
[.19685 .1193 -6 -9 ]
[.19685 .1193 6 0 ]
[.34842 .1193 -6 -9 ]
[.34842 .1193 6 0 ]
[.65158 .1193 -3 -9 ]
[.65158 .1193 3 0 ]
[.80315 .1193 -3 -9 ]
[.80315 .1193 3 0 ]
[.95473 .1193 -3 -9 ]
[.95473 .1193 3 0 ]
[.4875 .2811 -12 -4.5 ]
[.4875 .2811 0 4.5 ]
[.4875 .43039 -18 -4.5 ]
[.4875 .43039 0 4.5 ]
[.4875 .57969 -18 -4.5 ]
[.4875 .57969 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04527 .1318 m
.04527 .13805 L
s
[(-6)] .04527 .1193 0 1 Mshowa
.19685 .1318 m
.19685 .13805 L
s
[(-4)] .19685 .1193 0 1 Mshowa
.34842 .1318 m
.34842 .13805 L
s
[(-2)] .34842 .1193 0 1 Mshowa
.65158 .1318 m
.65158 .13805 L
s
[(2)] .65158 .1193 0 1 Mshowa
.80315 .1318 m
.80315 .13805 L
s
[(4)] .80315 .1193 0 1 Mshowa
.95473 .1318 m
.95473 .13805 L
s
[(6)] .95473 .1193 0 1 Mshowa
.125 Mabswid
.08317 .1318 m
.08317 .13555 L
s
.12106 .1318 m
.12106 .13555 L
s
.15895 .1318 m
.15895 .13555 L
s
.23474 .1318 m
.23474 .13555 L
s
.27264 .1318 m
.27264 .13555 L
s
.31053 .1318 m
.31053 .13555 L
s
.38632 .1318 m
.38632 .13555 L
s
.42421 .1318 m
.42421 .13555 L
s
.46211 .1318 m
.46211 .13555 L
s
.53789 .1318 m
.53789 .13555 L
s
.57579 .1318 m
.57579 .13555 L
s
.61368 .1318 m
.61368 .13555 L
s
.68947 .1318 m
.68947 .13555 L
s
.72736 .1318 m
.72736 .13555 L
s
.76526 .1318 m
.76526 .13555 L
s
.84105 .1318 m
.84105 .13555 L
s
.87894 .1318 m
.87894 .13555 L
s
.91683 .1318 m
.91683 .13555 L
s
.00738 .1318 m
.00738 .13555 L
s
.99262 .1318 m
.99262 .13555 L
s
.25 Mabswid
0 .1318 m
1 .1318 L
s
.5 .2811 m
.50625 .2811 L
s
[(50)] .4875 .2811 1 0 Mshowa
.5 .43039 m
.50625 .43039 L
s
[(100)] .4875 .43039 1 0 Mshowa
.5 .57969 m
.50625 .57969 L
s
[(150)] .4875 .57969 1 0 Mshowa
.125 Mabswid
.5 .16166 m
.50375 .16166 L
s
.5 .19152 m
.50375 .19152 L
s
.5 .22138 m
.50375 .22138 L
s
.5 .25124 m
.50375 .25124 L
s
.5 .31095 m
.50375 .31095 L
s
.5 .34081 m
.50375 .34081 L
s
.5 .37067 m
.50375 .37067 L
s
.5 .40053 m
.50375 .40053 L
s
.5 .46025 m
.50375 .46025 L
s
.5 .49011 m
.50375 .49011 L
s
.5 .51997 m
.50375 .51997 L
s
.5 .54983 m
.50375 .54983 L
s
.5 .10194 m
.50375 .10194 L
s
.5 .07208 m
.50375 .07208 L
s
.5 .04222 m
.50375 .04222 L
s
.5 .01236 m
.50375 .01236 L
s
.5 .60955 m
.50375 .60955 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.04262 .40227 L
.06244 .23685 L
.07286 .16972 L
.08255 .1191 L
.0932 .07617 L
.09912 .05769 L
.10458 .04384 L
.10954 .0338 L
.1148 .02563 L
.11734 .02255 L
.12007 .01984 L
.12307 .01755 L
.12453 .01669 L
.12589 .01604 L
.12713 .01555 L
.12846 .01516 L
.12922 .01499 L
.12994 .01487 L
.13058 .01479 L
.13128 .01473 L
.13258 .01472 L
.13323 .01475 L
.13395 .01482 L
.13522 .01502 L
.1364 .0153 L
.13765 .01568 L
.13883 .01613 L
.14105 .01719 L
.14603 .02053 L
.15061 .02467 L
.15568 .03031 L
.16593 .04449 L
.18435 .07604 L
.20533 .1149 L
.22456 .14756 L
.2434 .17326 L
.25288 .18322 L
.26325 .19169 L
.26853 .19504 L
.27352 .1976 L
.278 .19943 L
.28286 .20092 L
.28538 .2015 L
.28815 .20198 L
.28955 .20217 L
.29105 .20232 L
.29177 .20239 L
.29246 .20243 L
.29376 .2025 L
Mistroke
.29496 .20253 L
.29625 .20254 L
.29747 .20252 L
.29856 .20248 L
.29986 .2024 L
.30127 .20229 L
.30381 .202 L
.30619 .20164 L
.30874 .20115 L
.31334 .20004 L
.32378 .19652 L
.33482 .1916 L
.34486 .18636 L
.38476 .16334 L
.40302 .15386 L
.42314 .14528 L
.44295 .13898 L
.4538 .13642 L
.46398 .13457 L
.47383 .13324 L
.47879 .13274 L
.4842 .13232 L
.48884 .13206 L
.49144 .13195 L
.49267 .13191 L
.4938 .13188 L
.49485 .13185 L
.496 .13183 L
.49716 .13181 L
.49839 .1318 L
.49947 .1318 L
.50062 .1318 L
.50172 .1318 L
.50272 .13181 L
.50389 .13183 L
.50499 .13185 L
.50751 .13192 L
.50997 .132 L
.51261 .13213 L
.51739 .13243 L
.52178 .13279 L
.53188 .13396 L
.54253 .1357 L
.55206 .13773 L
.56225 .14042 L
.5806 .14671 L
.60193 .15629 L
.62207 .16719 L
.6605 .18923 L
.67076 .19422 L
Mistroke
.68036 .19807 L
.68559 .19974 L
.69037 .20096 L
.69291 .20148 L
.69568 .20193 L
.6972 .20213 L
.69861 .20228 L
.69995 .20239 L
.7007 .20244 L
.70139 .20248 L
.70263 .20252 L
.70329 .20254 L
.704 .20254 L
.70474 .20254 L
.70544 .20253 L
.70675 .20248 L
.70798 .2024 L
.70912 .20231 L
.71036 .20218 L
.71169 .20201 L
.71442 .20154 L
.71698 .20096 L
.72282 .19913 L
.72788 .19694 L
.73253 .19442 L
.74299 .1869 L
.75281 .17749 L
.76193 .16675 L
.78264 .13595 L
.8217 .0651 L
.83195 .04778 L
.84306 .03186 L
.84816 .02594 L
.85355 .02087 L
.85816 .01764 L
.86077 .0163 L
.86206 .01579 L
.86322 .01541 L
.86447 .01509 L
.86516 .01495 L
.86581 .01485 L
.86696 .01474 L
.8682 .01472 L
.86886 .01474 L
.86958 .01481 L
.87034 .01491 L
.87104 .01504 L
.87229 .01537 L
.87364 .01584 L
.8763 .01716 L
Mistroke
.87881 .0189 L
.88352 .02353 L
.88814 .02989 L
.89241 .03747 L
.90206 .06107 L
.91173 .09443 L
.92078 .13523 L
.9414 .26508 L
.95957 .42347 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{137.188, 375.063}, {206.438, 59.875}} -> {-14.2509, \
40.4176, 0.0445123, 1.1298}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False], ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False], ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False], ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False], ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["gvs=Show[gvr,PlotRange->{-100,50}]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0757881 0.412023 0.00412023 [
[.04527 .39952 -6 -9 ]
[.04527 .39952 6 0 ]
[.19685 .39952 -6 -9 ]
[.19685 .39952 6 0 ]
[.34842 .39952 -6 -9 ]
[.34842 .39952 6 0 ]
[.65158 .39952 -3 -9 ]
[.65158 .39952 3 0 ]
[.80315 .39952 -3 -9 ]
[.80315 .39952 3 0 ]
[.95473 .39952 -3 -9 ]
[.95473 .39952 3 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .0824 -18 -4.5 ]
[.4875 .0824 0 4.5 ]
[.4875 .16481 -18 -4.5 ]
[.4875 .16481 0 4.5 ]
[.4875 .24721 -18 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .32962 -18 -4.5 ]
[.4875 .32962 0 4.5 ]
[.4875 .49443 -12 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .57683 -12 -4.5 ]
[.4875 .57683 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04527 .41202 m
.04527 .41827 L
s
[(-6)] .04527 .39952 0 1 Mshowa
.19685 .41202 m
.19685 .41827 L
s
[(-4)] .19685 .39952 0 1 Mshowa
.34842 .41202 m
.34842 .41827 L
s
[(-2)] .34842 .39952 0 1 Mshowa
.65158 .41202 m
.65158 .41827 L
s
[(2)] .65158 .39952 0 1 Mshowa
.80315 .41202 m
.80315 .41827 L
s
[(4)] .80315 .39952 0 1 Mshowa
.95473 .41202 m
.95473 .41827 L
s
[(6)] .95473 .39952 0 1 Mshowa
.125 Mabswid
.08317 .41202 m
.08317 .41577 L
s
.12106 .41202 m
.12106 .41577 L
s
.15895 .41202 m
.15895 .41577 L
s
.23474 .41202 m
.23474 .41577 L
s
.27264 .41202 m
.27264 .41577 L
s
.31053 .41202 m
.31053 .41577 L
s
.38632 .41202 m
.38632 .41577 L
s
.42421 .41202 m
.42421 .41577 L
s
.46211 .41202 m
.46211 .41577 L
s
.53789 .41202 m
.53789 .41577 L
s
.57579 .41202 m
.57579 .41577 L
s
.61368 .41202 m
.61368 .41577 L
s
.68947 .41202 m
.68947 .41577 L
s
.72736 .41202 m
.72736 .41577 L
s
.76526 .41202 m
.76526 .41577 L
s
.84105 .41202 m
.84105 .41577 L
s
.87894 .41202 m
.87894 .41577 L
s
.91683 .41202 m
.91683 .41577 L
s
.00738 .41202 m
.00738 .41577 L
s
.99262 .41202 m
.99262 .41577 L
s
.25 Mabswid
0 .41202 m
1 .41202 L
s
.5 0 m
.50625 0 L
s
[(-100)] .4875 0 1 0 Mshowa
.5 .0824 m
.50625 .0824 L
s
[(-80)] .4875 .0824 1 0 Mshowa
.5 .16481 m
.50625 .16481 L
s
[(-60)] .4875 .16481 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(-40)] .4875 .24721 1 0 Mshowa
.5 .32962 m
.50625 .32962 L
s
[(-20)] .4875 .32962 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(20)] .4875 .49443 1 0 Mshowa
.5 .57683 m
.50625 .57683 L
s
[(40)] .4875 .57683 1 0 Mshowa
.125 Mabswid
.5 .0206 m
.50375 .0206 L
s
.5 .0412 m
.50375 .0412 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .14421 m
.50375 .14421 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .22661 m
.50375 .22661 L
s
.5 .26781 m
.50375 .26781 L
s
.5 .28842 m
.50375 .28842 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .35022 m
.50375 .35022 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .39142 m
.50375 .39142 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .45322 m
.50375 .45322 L
s
.5 .47383 m
.50375 .47383 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .53563 m
.50375 .53563 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .59743 m
.50375 .59743 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.03271 .61803 m
.04262 .48511 L
.06244 .28231 L
.07286 .20259 L
.08255 .14449 L
.0932 .09785 L
.09916 .07908 L
.10458 .06633 L
.10941 .05824 L
.11185 .05527 L
.11325 .05389 L
.11454 .05284 L
.11563 .05209 L
.11682 .05143 L
.11808 .05091 L
.11928 .05058 L
.1204 .05041 L
.12159 .05038 L
.12271 .05049 L
.12373 .0507 L
.12503 .05112 L
.1264 .05175 L
.12887 .05334 L
.13152 .05568 L
.13443 .05897 L
.13964 .06661 L
.14451 .07559 L
.16486 .12816 L
.18342 .18893 L
.22326 .32111 L
.24148 .37022 L
.25186 .39329 L
.26159 .4115 L
.27191 .42713 L
.28137 .43827 L
.29148 .44701 L
.29679 .45038 L
.30238 .45311 L
.30495 .45409 L
.30738 .45487 L
.30958 .45545 L
.31192 .45596 L
.31313 .45617 L
.31447 .45637 L
.31569 .45652 L
.31681 .45663 L
.31813 .45673 L
.31886 .45677 L
.31955 .4568 L
.32078 .45683 L
Mistroke
.32147 .45683 L
.32212 .45683 L
.32327 .4568 L
.32452 .45675 L
.3257 .45668 L
.32679 .45659 L
.32884 .45637 L
.33101 .45608 L
.33553 .45525 L
.34048 .45406 L
.35072 .45082 L
.36003 .44722 L
.38096 .43815 L
.4017 .42948 L
.42086 .42283 L
.43948 .41799 L
.44888 .41615 L
.45924 .41457 L
.46417 .41396 L
.46936 .41342 L
.47862 .41269 L
.48379 .4124 L
.4886 .41221 L
.49136 .41213 L
.49387 .41208 L
.49526 .41205 L
.49599 .41205 L
.49677 .41204 L
.49744 .41203 L
.49819 .41203 L
.49949 .41202 L
.50079 .41202 L
.502 .41203 L
.50332 .41204 L
.50399 .41205 L
.50472 .41205 L
.50728 .4121 L
.50968 .41216 L
.51416 .41231 L
.51898 .41255 L
.52429 .41289 L
.52988 .41335 L
.53989 .41445 L
.54942 .41586 L
.5596 .41779 L
.57796 .42247 L
.59928 .42987 L
.61943 .43833 L
.63772 .44629 L
.64812 .45039 L
Mistroke
.65786 .4536 L
.66277 .45487 L
.66743 .45582 L
.67 .45622 L
.67136 .4564 L
.6728 .45655 L
.67414 .45667 L
.67535 .45674 L
.67657 .4568 L
.67771 .45683 L
.67894 .45683 L
.67963 .45682 L
.68028 .4568 L
.68158 .45675 L
.68231 .4567 L
.68298 .45665 L
.68417 .45653 L
.68547 .45638 L
.68782 .456 L
.69057 .45542 L
.6935 .4546 L
.69875 .45262 L
.70364 .45014 L
.70813 .44729 L
.71823 .43867 L
.72714 .42838 L
.73652 .41464 L
.75628 .37552 L
.77465 .32725 L
.81371 .1988 L
.83364 .13275 L
.84413 .1024 L
.85523 .07612 L
.86001 .06719 L
.86515 .05951 L
.86809 .05608 L
.87078 .05361 L
.87207 .05266 L
.87348 .05181 L
.87481 .05118 L
.87605 .05076 L
.87726 .05049 L
.87856 .05037 L
.8798 .05043 L
.88093 .05062 L
.88195 .05092 L
.88308 .05138 L
.88425 .05201 L
.88534 .05275 L
.88784 .05495 L
Mistroke
.89012 .05761 L
.89523 .06596 L
.90006 .077 L
.90518 .09223 L
.91437 .12922 L
.92426 .18369 L
.93515 .26226 L
.95455 .45206 L
Mfstroke
.95455 .45206 m
.9672 .61803 L
s
.03841 .61803 m
.04262 .56014 L
.06244 .35098 L
.07286 .26803 L
.08255 .20699 L
.0932 .1572 L
.09916 .13671 L
.10458 .12241 L
.10941 .11295 L
.11185 .10931 L
.11454 .10613 L
.11682 .10409 L
.11811 .10321 L
.11928 .10256 L
.12037 .1021 L
.12156 .10174 L
.12268 .10154 L
.12373 .10148 L
.12503 .10155 L
.12577 .10167 L
.12644 .10182 L
.12769 .10222 L
.129 .10281 L
.13128 .10421 L
.13379 .10628 L
.13933 .11275 L
.14451 .12092 L
.15496 .14269 L
.16486 .16844 L
.18342 .22487 L
.22175 .34435 L
.24152 .39428 L
.25163 .41496 L
.26253 .4333 L
.27269 .44669 L
.282 .45596 L
.29091 .46228 L
.29538 .46459 L
.30028 .46649 L
.30282 .46723 L
.30557 .46786 L
.30683 .46809 L
.30816 .46829 L
.30932 .46843 L
.31056 .46855 L
.31176 .46863 L
.31285 .46869 L
.31395 .46871 L
.315 .46871 L
.31621 .46869 L
Mistroke
.31734 .46864 L
.31858 .46856 L
.31989 .46844 L
.32261 .46811 L
.32556 .4676 L
.33089 .46635 L
.34084 .46304 L
.36082 .45384 L
.3819 .44275 L
.4018 .4329 L
.41992 .42542 L
.43947 .4193 L
.45022 .41681 L
.4604 .41498 L
.47008 .41368 L
.47496 .41317 L
.48035 .41272 L
.48493 .41243 L
.48733 .41231 L
.48986 .41221 L
.49208 .41214 L
.49326 .4121 L
.49452 .41208 L
.49567 .41206 L
.49673 .41204 L
.49778 .41203 L
.49878 .41203 L
.49994 .41202 L
.50118 .41203 L
.50235 .41203 L
.50342 .41204 L
.50468 .41206 L
.50604 .41209 L
.50853 .41215 L
.51112 .41225 L
.51388 .41237 L
.51883 .41267 L
.52336 .41302 L
.52761 .41342 L
.5373 .41463 L
.54711 .41628 L
.55746 .41853 L
.57595 .42395 L
.59567 .43176 L
.61403 .44063 L
.63274 .45049 L
.65304 .46051 L
.65843 .46276 L
.66413 .46484 L
.66941 .46644 L
Mistroke
.672 .46708 L
.67436 .46759 L
.67657 .46798 L
.67898 .46832 L
.6803 .46846 L
.68153 .46857 L
.6827 .46864 L
.68395 .46869 L
.68467 .46871 L
.68532 .46872 L
.68604 .46871 L
.6868 .4687 L
.68808 .46864 L
.68881 .4686 L
.68949 .46855 L
.69076 .46842 L
.69191 .46828 L
.69451 .46784 L
.6968 .46733 L
.69932 .46662 L
.70443 .46467 L
.70916 .46224 L
.71361 .45937 L
.7236 .45072 L
.73437 .43775 L
.74395 .42288 L
.75443 .40298 L
.77553 .35189 L
.81611 .22638 L
.83486 .16921 L
.84473 .14342 L
.85518 .12147 L
.86047 .11302 L
.86328 .10939 L
.8663 .1062 L
.86906 .10396 L
.87037 .10314 L
.87159 .10252 L
.8728 .10205 L
.87345 .10185 L
.87413 .10169 L
.87539 .10151 L
.87654 .10148 L
.87781 .10162 L
.87844 .10175 L
.87914 .10194 L
.88038 .10241 L
.88153 .103 L
.88414 .10487 L
.8856 .10627 L
Mistroke
.88693 .10775 L
.89195 .11531 L
.8967 .12541 L
.90131 .13812 L
.90639 .15559 L
.91666 .20272 L
.92618 .26125 L
.9351 .32974 L
.95534 .53545 L
Mfstroke
.95534 .53545 m
.9615 .61803 L
s
.04419 .61803 m
.06244 .41965 L
.07286 .33347 L
.08255 .2695 L
.0932 .21656 L
.09916 .19434 L
.10458 .17849 L
.10941 .16767 L
.11206 .16301 L
.11454 .15942 L
.11682 .15676 L
.11891 .15484 L
.12123 .15329 L
.12251 .15268 L
.12373 .15226 L
.12503 .15198 L
.12622 .15187 L
.12688 .15188 L
.12759 .15193 L
.12888 .15214 L
.13009 .15249 L
.13137 .15301 L
.13366 .1543 L
.13634 .15638 L
.13883 .15885 L
.14451 .16624 L
.15496 .18539 L
.16486 .20873 L
.18342 .26082 L
.22175 .37212 L
.24152 .41824 L
.25163 .43708 L
.26253 .45352 L
.27269 .46523 L
.27714 .46928 L
.282 .473 L
.28631 .47569 L
.29091 .47796 L
.29345 .47896 L
.29576 .47972 L
.2981 .48034 L
.30028 .4808 L
.30259 .48115 L
.30381 .48128 L
.30513 .48139 L
.30579 .48143 L
.3065 .48146 L
.30781 .48149 L
.30908 .48148 L
.31026 .48144 L
Mistroke
.31147 .48137 L
.3126 .48127 L
.31472 .48103 L
.317 .48067 L
.31947 .48018 L
.32474 .47877 L
.3303 .47684 L
.34026 .47242 L
.37829 .44996 L
.39947 .43761 L
.41876 .42821 L
.42836 .42436 L
.43878 .42083 L
.44856 .41811 L
.45772 .41605 L
.46715 .41441 L
.47257 .41368 L
.47754 .41312 L
.48247 .41269 L
.48766 .41235 L
.49036 .41222 L
.49287 .41213 L
.49431 .41209 L
.49562 .41206 L
.49635 .41205 L
.49713 .41204 L
.49787 .41203 L
.49856 .41203 L
.49982 .41202 L
.50101 .41202 L
.50208 .41203 L
.50325 .41205 L
.50451 .41207 L
.50586 .4121 L
.50828 .41217 L
.5105 .41226 L
.51259 .41237 L
.51736 .41268 L
.52254 .41313 L
.52729 .41366 L
.53801 .41525 L
.5478 .41723 L
.55691 .41956 L
.57761 .42669 L
.59804 .43628 L
.61662 .44685 L
.6374 .45969 L
.65657 .4708 L
.66621 .47542 L
.67523 .47876 L
Mistroke
.67976 .48 L
.6821 .4805 L
.68464 .48094 L
.68608 .48113 L
.68742 .48127 L
.68869 .48138 L
.68941 .48142 L
.69005 .48145 L
.69128 .48148 L
.69197 .48149 L
.6926 .48148 L
.69377 .48145 L
.695 .48138 L
.69622 .48128 L
.69755 .48113 L
.69997 .48075 L
.70232 .48024 L
.70449 .47964 L
.70942 .47782 L
.71465 .47514 L
.72337 .46885 L
.73299 .4591 L
.7431 .44554 L
.75236 .43006 L
.77322 .38493 L
.81286 .27196 L
.83284 .21469 L
.84155 .19312 L
.85099 .17368 L
.85624 .16513 L
.86109 .15894 L
.86348 .15654 L
.86572 .15473 L
.86805 .15329 L
.86929 .15272 L
.87061 .15227 L
.87129 .15211 L
.87201 .15198 L
.8733 .15187 L
.8741 .15189 L
.87484 .15196 L
.87551 .15207 L
.87623 .15225 L
.87688 .15245 L
.87759 .15272 L
.87901 .15342 L
.88034 .15427 L
.88157 .15523 L
.8841 .15775 L
.8864 .16069 L
Mistroke
.89157 .16962 L
.8964 .18105 L
.90152 .1966 L
.91071 .23395 L
.92059 .28857 L
.93149 .36718 L
.95089 .55715 L
Mfstroke
.95089 .55715 m
.9555 .61803 L
s
.05085 .61803 m
.06244 .48832 L
.07286 .39891 L
.08255 .332 L
.0932 .27591 L
.09916 .25197 L
.10458 .23457 L
.10941 .22239 L
.11206 .21699 L
.11454 .21271 L
.11891 .20693 L
.12123 .20474 L
.12244 .20383 L
.12373 .20304 L
.12511 .20238 L
.12639 .20194 L
.12717 .20175 L
.12791 .20162 L
.12857 .20156 L
.12929 .20154 L
.12993 .20156 L
.13063 .20163 L
.13136 .20174 L
.13205 .2019 L
.13327 .20228 L
.13458 .20284 L
.13725 .20442 L
.13977 .20645 L
.14451 .21157 L
.1491 .218 L
.15416 .22661 L
.16442 .24799 L
.18284 .29518 L
.20381 .35343 L
.22304 .40299 L
.24189 .44288 L
.25148 .45898 L
.26173 .47281 L
.26705 .47862 L
.27207 .48325 L
.27696 .48698 L
.28147 .48976 L
.28575 .49184 L
.29028 .49346 L
.29263 .49408 L
.29483 .49453 L
.29607 .49472 L
.29725 .49487 L
.29789 .49494 L
.2986 .495 L
Mistroke
.29984 .49508 L
.30049 .49511 L
.30117 .49513 L
.3024 .49513 L
.30372 .49509 L
.30447 .49506 L
.30517 .49501 L
.30644 .4949 L
.30759 .49476 L
.31018 .49436 L
.31249 .49389 L
.315 .49327 L
.31955 .49184 L
.33046 .48709 L
.34054 .4814 L
.37985 .45417 L
.41766 .43112 L
.43704 .42279 L
.44794 .41923 L
.45791 .41665 L
.46774 .4147 L
.47687 .41338 L
.48213 .41283 L
.4869 .41246 L
.48954 .4123 L
.49093 .41223 L
.4924 .41217 L
.49369 .41212 L
.4951 .41208 L
.49639 .41206 L
.49759 .41204 L
.49885 .41203 L
.49948 .41202 L
.50018 .41202 L
.50142 .41203 L
.50258 .41204 L
.50325 .41205 L
.50395 .41206 L
.5052 .41209 L
.50655 .41213 L
.50802 .41218 L
.5105 .4123 L
.51315 .41246 L
.51792 .41283 L
.52291 .41336 L
.52763 .41397 L
.53647 .41547 L
.54617 .41763 L
.55645 .42057 L
.5749 .42762 L
Mistroke
.59445 .43762 L
.61275 .4491 L
.65155 .47632 L
.66166 .48273 L
.6727 .48863 L
.67774 .49082 L
.68312 .49272 L
.68573 .49346 L
.68819 .49404 L
.69041 .49447 L
.69279 .49481 L
.69405 .49494 L
.6952 .49503 L
.69636 .4951 L
.69745 .49513 L
.69872 .49513 L
.6999 .49509 L
.70119 .49502 L
.70184 .49497 L
.70256 .49489 L
.70513 .49454 L
.70657 .49426 L
.70789 .49396 L
.71288 .49239 L
.71718 .49047 L
.72189 .48775 L
.73136 .48017 L
.74165 .46864 L
.75099 .45512 L
.77194 .41459 L
.81194 .30961 L
.83028 .26069 L
.84069 .23674 L
.84578 .22671 L
.85043 .21874 L
.85502 .21216 L
.86002 .20664 L
.86276 .20441 L
.8641 .20355 L
.86531 .20289 L
.86647 .20238 L
.86774 .20196 L
.86843 .20179 L
.86907 .20167 L
.87032 .20155 L
.87154 .20157 L
.87285 .20175 L
.87409 .20208 L
.87521 .20251 L
.87653 .20318 L
Mistroke
.87796 .20412 L
.88057 .20638 L
.88329 .20956 L
.88618 .21387 L
.89137 .22415 L
.89628 .23706 L
.90077 .25172 L
.91089 .29539 L
.92027 .3499 L
.92919 .41503 L
.94899 .608 L
Mfstroke
.94899 .608 m
.94976 .61803 L
s
.05714 .61803 m
.06244 .55698 L
.07286 .46435 L
.08255 .3945 L
.0932 .33527 L
.09912 .30976 L
.10458 .29065 L
.10954 .27679 L
.1148 .26552 L
.11734 .26127 L
.12007 .25753 L
.12307 .25438 L
.12453 .25319 L
.12589 .25229 L
.12713 .25162 L
.12846 .25108 L
.12922 .25084 L
.12994 .25068 L
.13058 .25057 L
.13128 .25049 L
.13258 .25047 L
.13323 .25051 L
.13395 .25061 L
.13522 .25089 L
.1364 .25127 L
.13765 .2518 L
.13883 .25242 L
.14105 .25388 L
.14603 .25848 L
.15061 .26421 L
.15568 .27198 L
.16593 .29155 L
.18435 .33508 L
.20533 .3887 L
.22456 .43377 L
.2434 .46923 L
.25288 .48298 L
.26325 .49467 L
.26853 .49928 L
.27352 .50283 L
.278 .50535 L
.28286 .5074 L
.28538 .5082 L
.28815 .50887 L
.28955 .50912 L
.29105 .50934 L
.29177 .50942 L
.29246 .50949 L
.29376 .50958 L
.29496 .50963 L
Mistroke
.29625 .50964 L
.29747 .50961 L
.29856 .50955 L
.29986 .50945 L
.30127 .50929 L
.30381 .5089 L
.30619 .50839 L
.30874 .50772 L
.31334 .50619 L
.32378 .50134 L
.33482 .49455 L
.34486 .48731 L
.38476 .45555 L
.40302 .44247 L
.42314 .43062 L
.44295 .42193 L
.4538 .4184 L
.46398 .41585 L
.47383 .41402 L
.47879 .41333 L
.4842 .41274 L
.48884 .41238 L
.49144 .41223 L
.49267 .41218 L
.4938 .41213 L
.49485 .4121 L
.496 .41207 L
.49716 .41205 L
.49839 .41203 L
.49947 .41202 L
.50062 .41202 L
.50172 .41203 L
.50272 .41204 L
.50389 .41207 L
.50499 .41209 L
.50751 .41218 L
.50997 .41231 L
.51261 .41248 L
.51739 .4129 L
.52178 .4134 L
.53188 .415 L
.54253 .4174 L
.55206 .4202 L
.56225 .42392 L
.5806 .4326 L
.60193 .44582 L
.62207 .46087 L
.6605 .49127 L
.67076 .49816 L
.68036 .50347 L
Mistroke
.68559 .50577 L
.69037 .50746 L
.69291 .50817 L
.69568 .5088 L
.6972 .50907 L
.69861 .50928 L
.69995 .50943 L
.7007 .5095 L
.70139 .50955 L
.70263 .50961 L
.70329 .50963 L
.704 .50964 L
.70474 .50964 L
.70544 .50962 L
.70675 .50955 L
.70798 .50945 L
.70912 .50932 L
.71036 .50914 L
.71169 .5089 L
.71442 .50826 L
.71698 .50746 L
.72282 .50494 L
.72788 .50191 L
.73253 .49843 L
.74299 .48805 L
.75281 .47508 L
.76193 .46025 L
.78264 .41776 L
.8217 .31998 L
.83195 .29609 L
.84306 .27412 L
.84816 .26596 L
.85355 .25895 L
.85816 .25449 L
.86077 .25265 L
.86206 .25194 L
.86322 .25142 L
.86447 .25098 L
.86516 .25079 L
.86581 .25065 L
.86696 .2505 L
.8682 .25046 L
.86886 .2505 L
.86958 .25059 L
.87034 .25074 L
.87104 .25092 L
.87229 .25136 L
.87364 .25201 L
.8763 .25384 L
.87881 .25624 L
Mistroke
.88352 .26263 L
.88814 .2714 L
.89241 .28186 L
.90206 .31443 L
.91173 .36046 L
.92078 .41676 L
.9414 .59594 L
Mfstroke
.9414 .59594 m
.94324 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{137.188, 375.063}, {404.375, 257.813}} -> {-14.6097, \
166.726, 0.0456332, 0.839383}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show[gp,gvr]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0757881 0.265219 0.00214104 [
[.04527 .25272 -6 -9 ]
[.04527 .25272 6 0 ]
[.19685 .25272 -6 -9 ]
[.19685 .25272 6 0 ]
[.34842 .25272 -6 -9 ]
[.34842 .25272 6 0 ]
[.65158 .25272 -3 -9 ]
[.65158 .25272 3 0 ]
[.80315 .25272 -3 -9 ]
[.80315 .25272 3 0 ]
[.95473 .25272 -3 -9 ]
[.95473 .25272 3 0 ]
[.4875 .05111 -24 -4.5 ]
[.4875 .05111 0 4.5 ]
[.4875 .15817 -18 -4.5 ]
[.4875 .15817 0 4.5 ]
[.4875 .37227 -12 -4.5 ]
[.4875 .37227 0 4.5 ]
[.4875 .47932 -18 -4.5 ]
[.4875 .47932 0 4.5 ]
[.4875 .58638 -18 -4.5 ]
[.4875 .58638 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04527 .26522 m
.04527 .27147 L
s
[(-6)] .04527 .25272 0 1 Mshowa
.19685 .26522 m
.19685 .27147 L
s
[(-4)] .19685 .25272 0 1 Mshowa
.34842 .26522 m
.34842 .27147 L
s
[(-2)] .34842 .25272 0 1 Mshowa
.65158 .26522 m
.65158 .27147 L
s
[(2)] .65158 .25272 0 1 Mshowa
.80315 .26522 m
.80315 .27147 L
s
[(4)] .80315 .25272 0 1 Mshowa
.95473 .26522 m
.95473 .27147 L
s
[(6)] .95473 .25272 0 1 Mshowa
.125 Mabswid
.08317 .26522 m
.08317 .26897 L
s
.12106 .26522 m
.12106 .26897 L
s
.15895 .26522 m
.15895 .26897 L
s
.23474 .26522 m
.23474 .26897 L
s
.27264 .26522 m
.27264 .26897 L
s
.31053 .26522 m
.31053 .26897 L
s
.38632 .26522 m
.38632 .26897 L
s
.42421 .26522 m
.42421 .26897 L
s
.46211 .26522 m
.46211 .26897 L
s
.53789 .26522 m
.53789 .26897 L
s
.57579 .26522 m
.57579 .26897 L
s
.61368 .26522 m
.61368 .26897 L
s
.68947 .26522 m
.68947 .26897 L
s
.72736 .26522 m
.72736 .26897 L
s
.76526 .26522 m
.76526 .26897 L
s
.84105 .26522 m
.84105 .26897 L
s
.87894 .26522 m
.87894 .26897 L
s
.91683 .26522 m
.91683 .26897 L
s
.00738 .26522 m
.00738 .26897 L
s
.99262 .26522 m
.99262 .26897 L
s
.25 Mabswid
0 .26522 m
1 .26522 L
s
.5 .05111 m
.50625 .05111 L
s
[(-100)] .4875 .05111 1 0 Mshowa
.5 .15817 m
.50625 .15817 L
s
[(-50)] .4875 .15817 1 0 Mshowa
.5 .37227 m
.50625 .37227 L
s
[(50)] .4875 .37227 1 0 Mshowa
.5 .47932 m
.50625 .47932 L
s
[(100)] .4875 .47932 1 0 Mshowa
.5 .58638 m
.50625 .58638 L
s
[(150)] .4875 .58638 1 0 Mshowa
.125 Mabswid
.5 .07253 m
.50375 .07253 L
s
.5 .09394 m
.50375 .09394 L
s
.5 .11535 m
.50375 .11535 L
s
.5 .13676 m
.50375 .13676 L
s
.5 .17958 m
.50375 .17958 L
s
.5 .20099 m
.50375 .20099 L
s
.5 .2224 m
.50375 .2224 L
s
.5 .24381 m
.50375 .24381 L
s
.5 .28663 m
.50375 .28663 L
s
.5 .30804 m
.50375 .30804 L
s
.5 .32945 m
.50375 .32945 L
s
.5 .35086 m
.50375 .35086 L
s
.5 .39368 m
.50375 .39368 L
s
.5 .41509 m
.50375 .41509 L
s
.5 .4365 m
.50375 .4365 L
s
.5 .45791 m
.50375 .45791 L
s
.5 .50073 m
.50375 .50073 L
s
.5 .52214 m
.50375 .52214 L
s
.5 .54355 m
.50375 .54355 L
s
.5 .56497 m
.50375 .56497 L
s
.5 .0297 m
.50375 .0297 L
s
.5 .00829 m
.50375 .00829 L
s
.5 .60779 m
.50375 .60779 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .33686 m
.04262 .21333 L
.06244 .11557 L
.07286 .07801 L
.08255 .05134 L
.08813 .03951 L
.0932 .03087 L
.096 .02693 L
.09905 .0233 L
.10171 .02068 L
.10458 .01841 L
.10712 .01687 L
.10945 .01582 L
.11057 .01545 L
.11179 .01513 L
.11295 .01491 L
.11402 .01478 L
.11467 .01474 L
.11538 .01472 L
.11666 .01475 L
.11791 .01488 L
.11905 .01508 L
.1203 .01538 L
.12166 .0158 L
.12442 .01697 L
.12716 .01851 L
.12967 .02025 L
.13529 .0252 L
.14545 .03739 L
.16453 .06885 L
.18529 .11009 L
.22607 .19002 L
.24633 .22169 L
.26534 .24447 L
.28351 .25982 L
.29372 .26591 L
.30309 .27006 L
.30783 .27169 L
.31289 .2731 L
.31727 .27408 L
.32201 .27489 L
.32492 .27528 L
.32759 .27557 L
.33015 .27578 L
.33146 .27587 L
.33286 .27595 L
.33413 .27601 L
.33528 .27605 L
.33645 .27609 L
.33755 .27611 L
Mistroke
.33883 .27613 L
.34002 .27613 L
.34133 .27613 L
.34206 .27612 L
.34271 .27611 L
.34392 .27608 L
.34505 .27605 L
.34761 .27596 L
.3501 .27584 L
.35277 .27568 L
.362 .2749 L
.38283 .27247 L
.40268 .27003 L
.41315 .26889 L
.42425 .26785 L
.43411 .26709 L
.44498 .26643 L
.45487 .26599 L
.46414 .26568 L
.46886 .26555 L
.474 .26545 L
.47937 .26536 L
.48437 .2653 L
.48678 .26528 L
.48906 .26526 L
.49114 .26524 L
.49333 .26523 L
.49446 .26523 L
.49572 .26522 L
.49685 .26522 L
.49792 .26522 L
.49917 .26522 L
.50031 .26522 L
.50163 .26522 L
.50288 .26522 L
.50402 .26522 L
.50524 .26523 L
.50746 .26524 L
.5101 .26525 L
.51252 .26527 L
.51751 .26532 L
.52277 .26539 L
.52732 .26547 L
.53156 .26556 L
.54118 .26584 L
.55169 .26627 L
.56161 .26681 L
.58019 .26824 L
.60018 .27036 L
.61863 .27266 L
Mistroke
.62843 .27386 L
.63896 .275 L
.64406 .27544 L
.64891 .27578 L
.65101 .2759 L
.65325 .276 L
.65455 .27604 L
.65572 .27608 L
.65689 .2761 L
.658 .27612 L
.65914 .27613 L
.6602 .27613 L
.66136 .27612 L
.66261 .27611 L
.66392 .27608 L
.66515 .27604 L
.66627 .27599 L
.66747 .27594 L
.66967 .2758 L
.672 .27561 L
.67619 .27514 L
.68101 .2744 L
.68554 .27347 L
.6905 .27219 L
.69585 .27045 L
.70543 .26634 L
.71591 .26022 L
.72684 .25182 L
.73701 .24202 L
.75749 .21629 L
.77608 .18624 L
.81608 .10726 L
.83441 .07082 L
.84483 .05228 L
.85457 .03737 L
.86416 .02575 L
.86954 .02086 L
.87446 .01755 L
.87714 .01626 L
.87842 .01578 L
.87963 .0154 L
.88032 .01522 L
.88106 .01506 L
.88235 .01485 L
.88309 .01477 L
.88387 .01473 L
.88453 .01472 L
.88526 .01473 L
.88595 .01478 L
.8866 .01485 L
Mistroke
.88782 .01505 L
.88914 .01536 L
.89056 .01583 L
.89313 .017 L
.89551 .01847 L
.90016 .02247 L
.90517 .0285 L
.9099 .0359 L
.91422 .04419 L
.92479 .07082 L
.93484 .10488 L
.95464 .19777 L
.97302 .3141 L
.97619 .33686 L
Mfstroke
.5 Mabswid
.02381 .43427 m
.04262 .3032 L
.06244 .19782 L
.07286 .15639 L
.08255 .1262 L
.0932 .10196 L
.09916 .09221 L
.10458 .08558 L
.10941 .08138 L
.11185 .07984 L
.11325 .07912 L
.11454 .07857 L
.11563 .07818 L
.11682 .07784 L
.11808 .07757 L
.11928 .0774 L
.1204 .07731 L
.12159 .07729 L
.12271 .07735 L
.12373 .07746 L
.12503 .07768 L
.1264 .07801 L
.12887 .07883 L
.13152 .08005 L
.13443 .08176 L
.13964 .08573 L
.14451 .09039 L
.16486 .11771 L
.18342 .14929 L
.22326 .21798 L
.24148 .2435 L
.25186 .25548 L
.26159 .26495 L
.27191 .27307 L
.28137 .27886 L
.29148 .2834 L
.29679 .28515 L
.30238 .28657 L
.30495 .28708 L
.30738 .28748 L
.30958 .28779 L
.31192 .28805 L
.31313 .28816 L
.31447 .28826 L
.31569 .28834 L
.31681 .2884 L
.31813 .28845 L
.31886 .28847 L
.31955 .28849 L
.32078 .2885 L
Mistroke
.32147 .2885 L
.32212 .2885 L
.32327 .28849 L
.32452 .28846 L
.3257 .28842 L
.32679 .28838 L
.32884 .28827 L
.33101 .28811 L
.33553 .28768 L
.34048 .28706 L
.35072 .28538 L
.36003 .28351 L
.38096 .2788 L
.4017 .27429 L
.42086 .27084 L
.43948 .26832 L
.44888 .26736 L
.45924 .26654 L
.46417 .26623 L
.46936 .26595 L
.47862 .26557 L
.48379 .26542 L
.4886 .26532 L
.49136 .26527 L
.49387 .26525 L
.49526 .26524 L
.49599 .26523 L
.49677 .26523 L
.49744 .26522 L
.49819 .26522 L
.49949 .26522 L
.50079 .26522 L
.502 .26522 L
.50332 .26523 L
.50399 .26523 L
.50472 .26524 L
.50728 .26526 L
.50968 .26529 L
.51416 .26537 L
.51898 .26549 L
.52429 .26567 L
.52988 .26591 L
.53989 .26648 L
.54942 .26721 L
.5596 .26822 L
.57796 .27065 L
.59928 .27449 L
.61943 .27889 L
.63772 .28302 L
.64812 .28516 L
Mistroke
.65786 .28682 L
.66277 .28749 L
.66743 .28798 L
.67 .28819 L
.67136 .28828 L
.6728 .28836 L
.67414 .28842 L
.67535 .28846 L
.67657 .28849 L
.67771 .2885 L
.67894 .2885 L
.67963 .2885 L
.68028 .28849 L
.68158 .28846 L
.68231 .28844 L
.68298 .28841 L
.68417 .28835 L
.68547 .28827 L
.68782 .28807 L
.69057 .28777 L
.6935 .28735 L
.69875 .28632 L
.70364 .28503 L
.70813 .28354 L
.71823 .27907 L
.72714 .27372 L
.73652 .26658 L
.75628 .24625 L
.77465 .22117 L
.81371 .15442 L
.83364 .1201 L
.84413 .10432 L
.85523 .09067 L
.86001 .08603 L
.86515 .08204 L
.86809 .08025 L
.87078 .07897 L
.87207 .07848 L
.87348 .07804 L
.87481 .07771 L
.87605 .07749 L
.87726 .07735 L
.87856 .07729 L
.8798 .07732 L
.88093 .07742 L
.88195 .07758 L
.88308 .07781 L
.88425 .07814 L
.88534 .07852 L
.88784 .07967 L
Mistroke
.89012 .08105 L
.89523 .08539 L
.90006 .09113 L
.90518 .09904 L
.91437 .11826 L
.92426 .14657 L
.93515 .1874 L
.95455 .28602 L
.97543 .42839 L
.97619 .43427 L
Mfstroke
.02381 .47653 m
.04262 .34219 L
.06244 .2335 L
.07286 .19039 L
.08255 .15868 L
.0932 .1328 L
.09916 .12216 L
.10458 .11472 L
.10941 .10981 L
.11185 .10792 L
.11454 .10626 L
.11682 .10521 L
.11811 .10475 L
.11928 .10441 L
.12037 .10417 L
.12156 .10399 L
.12268 .10388 L
.12373 .10385 L
.12503 .10388 L
.12577 .10394 L
.12644 .10403 L
.12769 .10423 L
.129 .10454 L
.13128 .10526 L
.13379 .10634 L
.13933 .1097 L
.14451 .11395 L
.15496 .12526 L
.16486 .13864 L
.18342 .16797 L
.22175 .23005 L
.24152 .256 L
.25163 .26674 L
.26253 .27627 L
.27269 .28324 L
.282 .28805 L
.29091 .29133 L
.29538 .29253 L
.30028 .29352 L
.30282 .29391 L
.30557 .29423 L
.30683 .29435 L
.30816 .29446 L
.30932 .29453 L
.31056 .29459 L
.31176 .29464 L
.31285 .29466 L
.31395 .29468 L
.315 .29468 L
.31621 .29467 L
Mistroke
.31734 .29464 L
.31858 .2946 L
.31989 .29454 L
.32261 .29436 L
.32556 .2941 L
.33089 .29345 L
.34084 .29173 L
.36082 .28695 L
.3819 .28118 L
.4018 .27607 L
.41992 .27218 L
.43947 .269 L
.45022 .26771 L
.4604 .26676 L
.47008 .26608 L
.47496 .26582 L
.48035 .26558 L
.48493 .26543 L
.48733 .26537 L
.48986 .26532 L
.49208 .26528 L
.49326 .26526 L
.49452 .26525 L
.49567 .26524 L
.49673 .26523 L
.49778 .26522 L
.49878 .26522 L
.49994 .26522 L
.50118 .26522 L
.50235 .26522 L
.50342 .26523 L
.50468 .26524 L
.50604 .26525 L
.50853 .26529 L
.51112 .26533 L
.51388 .2654 L
.51883 .26555 L
.52336 .26574 L
.52761 .26595 L
.5373 .26657 L
.54711 .26743 L
.55746 .2686 L
.57595 .27142 L
.59567 .27548 L
.61403 .28009 L
.63274 .28521 L
.65304 .29042 L
.65843 .29158 L
.66413 .29267 L
.66941 .29349 L
Mistroke
.672 .29383 L
.67436 .29409 L
.67657 .2943 L
.67898 .29447 L
.6803 .29455 L
.68153 .2946 L
.6827 .29464 L
.68395 .29467 L
.68467 .29468 L
.68532 .29468 L
.68604 .29468 L
.6868 .29467 L
.68808 .29464 L
.68881 .29462 L
.68949 .29459 L
.69076 .29453 L
.69191 .29445 L
.69451 .29423 L
.6968 .29396 L
.69932 .29359 L
.70443 .29258 L
.70916 .29131 L
.71361 .28982 L
.7236 .28533 L
.73437 .27859 L
.74395 .27086 L
.75443 .26052 L
.77553 .23397 L
.81611 .16875 L
.83486 .13905 L
.84473 .12564 L
.85518 .11423 L
.86047 .10984 L
.86328 .10796 L
.8663 .1063 L
.86906 .10514 L
.87037 .10471 L
.87159 .10439 L
.8728 .10414 L
.87345 .10404 L
.87413 .10396 L
.87539 .10386 L
.87654 .10385 L
.87781 .10392 L
.87844 .10399 L
.87914 .10409 L
.88038 .10433 L
.88153 .10464 L
.88414 .10561 L
.8856 .10634 L
Mistroke
.88693 .10711 L
.89195 .11104 L
.8967 .11628 L
.90131 .12289 L
.90639 .13197 L
.91666 .15645 L
.92618 .18687 L
.9351 .22246 L
.95534 .32936 L
.97386 .45832 L
.97619 .47653 L
Mfstroke
.02381 .51879 m
.04262 .38118 L
.06244 .26918 L
.07286 .2244 L
.08255 .19116 L
.0932 .16365 L
.09916 .1521 L
.10458 .14386 L
.10941 .13824 L
.11206 .13582 L
.11454 .13396 L
.11682 .13257 L
.11891 .13158 L
.12123 .13077 L
.12251 .13045 L
.12373 .13023 L
.12503 .13009 L
.12622 .13004 L
.12688 .13004 L
.12759 .13006 L
.12888 .13018 L
.13009 .13036 L
.13137 .13062 L
.13366 .13129 L
.13634 .13238 L
.13883 .13366 L
.14451 .1375 L
.15496 .14745 L
.16486 .15958 L
.18342 .18665 L
.22175 .24448 L
.24152 .26845 L
.25163 .27824 L
.26253 .28678 L
.27269 .29287 L
.27714 .29497 L
.282 .29691 L
.28631 .2983 L
.29091 .29948 L
.29345 .3 L
.29576 .3004 L
.2981 .30072 L
.30028 .30096 L
.30259 .30114 L
.30381 .30121 L
.30513 .30127 L
.30579 .30129 L
.3065 .3013 L
.30781 .30132 L
.30908 .30131 L
Mistroke
.31026 .30129 L
.31147 .30125 L
.3126 .3012 L
.31472 .30108 L
.317 .30089 L
.31947 .30063 L
.32474 .29991 L
.3303 .2989 L
.34026 .2966 L
.37829 .28493 L
.39947 .27851 L
.41876 .27363 L
.42836 .27163 L
.43878 .26979 L
.44856 .26838 L
.45772 .26731 L
.46715 .26646 L
.47257 .26608 L
.47754 .26579 L
.48247 .26557 L
.48766 .26539 L
.49036 .26532 L
.49287 .26528 L
.49431 .26526 L
.49562 .26524 L
.49635 .26523 L
.49713 .26523 L
.49787 .26522 L
.49856 .26522 L
.49982 .26522 L
.50101 .26522 L
.50208 .26522 L
.50325 .26523 L
.50451 .26524 L
.50586 .26526 L
.50828 .2653 L
.5105 .26534 L
.51259 .2654 L
.51736 .26556 L
.52254 .2658 L
.52729 .26607 L
.53801 .2669 L
.5478 .26793 L
.55691 .26914 L
.57761 .27284 L
.59804 .27782 L
.61662 .28332 L
.6374 .28999 L
.65657 .29576 L
.66621 .29816 L
Mistroke
.67523 .2999 L
.67976 .30054 L
.6821 .3008 L
.68464 .30103 L
.68608 .30113 L
.68742 .3012 L
.68869 .30126 L
.68941 .30128 L
.69005 .3013 L
.69128 .30131 L
.69197 .30132 L
.6926 .30131 L
.69377 .3013 L
.695 .30126 L
.69622 .30121 L
.69755 .30113 L
.69997 .30093 L
.70232 .30067 L
.70449 .30036 L
.70942 .29941 L
.71465 .29802 L
.72337 .29475 L
.73299 .28968 L
.7431 .28264 L
.75236 .27459 L
.77322 .25114 L
.81286 .19243 L
.83284 .16268 L
.84155 .15147 L
.85099 .14137 L
.85624 .13692 L
.86109 .13371 L
.86348 .13246 L
.86572 .13152 L
.86805 .13077 L
.86929 .13048 L
.87061 .13024 L
.87129 .13016 L
.87201 .13009 L
.8733 .13003 L
.8741 .13004 L
.87484 .13008 L
.87551 .13014 L
.87623 .13023 L
.87688 .13033 L
.87759 .13047 L
.87901 .13084 L
.88034 .13128 L
.88157 .13178 L
.8841 .13309 L
Mistroke
.8864 .13461 L
.89157 .13926 L
.8964 .1452 L
.90152 .15328 L
.91071 .17268 L
.92059 .20107 L
.93149 .24192 L
.95089 .34064 L
.97176 .48381 L
.97619 .51879 L
Mfstroke
.02381 .56106 m
.04262 .42017 L
.06244 .30486 L
.07286 .2584 L
.08255 .22363 L
.0932 .19449 L
.09916 .18205 L
.10458 .17301 L
.10941 .16668 L
.11206 .16387 L
.11454 .16165 L
.11891 .15864 L
.12123 .15751 L
.12244 .15704 L
.12373 .15662 L
.12511 .15628 L
.12639 .15605 L
.12717 .15595 L
.12791 .15589 L
.12857 .15585 L
.12929 .15584 L
.12993 .15585 L
.13063 .15589 L
.13136 .15595 L
.13205 .15603 L
.13327 .15623 L
.13458 .15652 L
.13725 .15734 L
.13977 .1584 L
.14451 .16105 L
.1491 .1644 L
.15416 .16887 L
.16442 .17998 L
.18284 .2045 L
.20381 .23477 L
.22304 .26052 L
.24189 .28125 L
.25148 .28962 L
.26173 .29681 L
.26705 .29983 L
.27207 .30223 L
.27696 .30417 L
.28147 .30562 L
.28575 .30669 L
.29028 .30754 L
.29263 .30786 L
.29483 .30809 L
.29607 .30819 L
.29725 .30827 L
.29789 .30831 L
Mistroke
.2986 .30834 L
.29984 .30838 L
.30049 .30839 L
.30117 .3084 L
.3024 .3084 L
.30372 .30839 L
.30447 .30837 L
.30517 .30834 L
.30644 .30828 L
.30759 .30821 L
.31018 .30801 L
.31249 .30776 L
.315 .30744 L
.31955 .30669 L
.33046 .30423 L
.34054 .30127 L
.37985 .28712 L
.41766 .27514 L
.43704 .27082 L
.44794 .26897 L
.45791 .26762 L
.46774 .26661 L
.47687 .26593 L
.48213 .26564 L
.4869 .26544 L
.48954 .26536 L
.49093 .26533 L
.4924 .26529 L
.49369 .26527 L
.4951 .26525 L
.49639 .26524 L
.49759 .26523 L
.49885 .26522 L
.49948 .26522 L
.50018 .26522 L
.50142 .26522 L
.50258 .26523 L
.50325 .26523 L
.50395 .26524 L
.5052 .26525 L
.50655 .26528 L
.50802 .2653 L
.5105 .26536 L
.51315 .26545 L
.51792 .26564 L
.52291 .26591 L
.52763 .26623 L
.53647 .26701 L
.54617 .26813 L
.55645 .26966 L
Mistroke
.5749 .27332 L
.59445 .27852 L
.61275 .28449 L
.65155 .29863 L
.66166 .30196 L
.6727 .30503 L
.67774 .30617 L
.68312 .30715 L
.68573 .30754 L
.68819 .30784 L
.69041 .30806 L
.69279 .30824 L
.69405 .30831 L
.6952 .30836 L
.69636 .30839 L
.69745 .3084 L
.69872 .3084 L
.6999 .30839 L
.70119 .30835 L
.70184 .30832 L
.70256 .30828 L
.70513 .3081 L
.70657 .30795 L
.70789 .3078 L
.71288 .30698 L
.71718 .30598 L
.72189 .30457 L
.73136 .30063 L
.74165 .29464 L
.75099 .28762 L
.77194 .26655 L
.81194 .212 L
.83028 .18658 L
.84069 .17414 L
.84578 .16892 L
.85043 .16478 L
.85502 .16136 L
.86002 .15849 L
.86276 .15734 L
.8641 .15689 L
.86531 .15655 L
.86647 .15628 L
.86774 .15606 L
.86843 .15597 L
.86907 .15591 L
.87032 .15585 L
.87154 .15586 L
.87285 .15595 L
.87409 .15612 L
.87521 .15635 L
Mistroke
.87653 .1567 L
.87796 .15718 L
.88057 .15836 L
.88329 .16001 L
.88618 .16225 L
.89137 .16759 L
.89628 .1743 L
.90077 .18192 L
.91089 .20461 L
.92027 .23294 L
.92919 .26678 L
.94899 .36706 L
.96737 .49136 L
.97619 .56106 L
Mfstroke
.02381 .60332 m
.04262 .45916 L
.06244 .34055 L
.07286 .29241 L
.08255 .25611 L
.0932 .22533 L
.09912 .21208 L
.10458 .20215 L
.10954 .19495 L
.1148 .18909 L
.11734 .18688 L
.12007 .18494 L
.12307 .1833 L
.12453 .18268 L
.12589 .18221 L
.12713 .18187 L
.12846 .18159 L
.12922 .18146 L
.12994 .18138 L
.13058 .18132 L
.13128 .18128 L
.13258 .18127 L
.13323 .18129 L
.13395 .18134 L
.13522 .18149 L
.1364 .18169 L
.13765 .18196 L
.13883 .18228 L
.14105 .18304 L
.14603 .18543 L
.15061 .18841 L
.15568 .19245 L
.16593 .20262 L
.18435 .22524 L
.20533 .2531 L
.22456 .27652 L
.2434 .29495 L
.25288 .30209 L
.26325 .30816 L
.26853 .31056 L
.27352 .31241 L
.278 .31372 L
.28286 .31478 L
.28538 .3152 L
.28815 .31554 L
.28955 .31568 L
.29105 .31579 L
.29177 .31583 L
.29246 .31587 L
.29376 .31592 L
Mistroke
.29496 .31594 L
.29625 .31594 L
.29747 .31593 L
.29856 .3159 L
.29986 .31585 L
.30127 .31576 L
.30381 .31556 L
.30619 .3153 L
.30874 .31495 L
.31334 .31415 L
.32378 .31163 L
.33482 .3081 L
.34486 .30434 L
.38476 .28784 L
.40302 .28104 L
.42314 .27488 L
.44295 .27037 L
.4538 .26854 L
.46398 .26721 L
.47383 .26625 L
.47879 .2659 L
.4842 .26559 L
.48884 .26541 L
.49144 .26533 L
.49267 .2653 L
.4938 .26528 L
.49485 .26526 L
.496 .26524 L
.49716 .26523 L
.49839 .26522 L
.49947 .26522 L
.50062 .26522 L
.50172 .26522 L
.50272 .26523 L
.50389 .26524 L
.50499 .26526 L
.50751 .2653 L
.50997 .26537 L
.51261 .26546 L
.51739 .26567 L
.52178 .26593 L
.53188 .26677 L
.54253 .26801 L
.55206 .26947 L
.56225 .2714 L
.5806 .27591 L
.60193 .28278 L
.62207 .2906 L
.6605 .3064 L
.67076 .30998 L
Mistroke
.68036 .31274 L
.68559 .31394 L
.69037 .31481 L
.69291 .31518 L
.69568 .31551 L
.6972 .31565 L
.69861 .31576 L
.69995 .31584 L
.7007 .31587 L
.70139 .3159 L
.70263 .31593 L
.70329 .31594 L
.704 .31595 L
.70474 .31594 L
.70544 .31593 L
.70675 .3159 L
.70798 .31585 L
.70912 .31578 L
.71036 .31568 L
.71169 .31556 L
.71442 .31523 L
.71698 .31481 L
.72282 .3135 L
.72788 .31193 L
.73253 .31012 L
.74299 .30473 L
.75281 .29799 L
.76193 .29028 L
.78264 .2682 L
.8217 .21739 L
.83195 .20498 L
.84306 .19356 L
.84816 .18932 L
.85355 .18568 L
.85816 .18336 L
.86077 .1824 L
.86206 .18204 L
.86322 .18176 L
.86447 .18153 L
.86516 .18144 L
.86581 .18136 L
.86696 .18128 L
.8682 .18127 L
.86886 .18129 L
.86958 .18133 L
.87034 .18141 L
.87104 .1815 L
.87229 .18173 L
.87364 .18207 L
.8763 .18302 L
Mistroke
.87881 .18427 L
.88352 .18759 L
.88814 .19215 L
.89241 .19758 L
.90206 .21451 L
.91173 .23843 L
.92078 .26768 L
.9414 .36079 L
.95957 .47436 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oU03oool0
0`000000oooo0?ooo`2C0?ooo`00U03oool00`000000oooo0?ooo`2C0?ooo`00U03oool2000009@0
oooo002D0?ooo`030000003oool0oooo0700oooo00<000000?ooo`3oool0803oool00200oooo1@00
001_0?ooo`030000003oool0oooo06d0oooo1@00000Q0?ooo`007P3oool9000006d0oooo00<00000
0?ooo`3oool0J`3oool9000001l0oooo000M0?ooo`D000000P3oool5000006/0oooo00<000000?oo
o`3oool0JP3oool500000080oooo1000000N0?ooo`00703oool3000000L0oooo0`00001[0?ooo`03
0000003oool0oooo06T0oooo0`0000080?ooo`<00000703oool001/0oooo0`00000:0?ooo`800000
JP3oool00`000000oooo0?ooo`1Y0?ooo`8000002@3oool4000001/0oooo000K0?ooo`800000303o
ool2000006T0oooo0P00001Y0?ooo`800000303oool2000001/0oooo000K0?ooo`8000003@3oool2
000006P0oooo00<000000?ooo`3oool0I`3oool2000000d0oooo0P00000K0?ooo`006P3oool20000
00l0oooo00<000000?ooo`3oool0IP3oool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool06@3oool001X0oooo00<000000?ooo`3oool03P3oool2000006L0
oooo00<000000?ooo`3oool0IP3oool2000000l0oooo0P00000J0?ooo`006@3oool200000140oooo
0P00001A0?ooo`080?ooe02K00000000000000000780^^[o0?ooo`3Z^W820000000407:jjP3oool0
oooo0>ZjLP80000000<0L[[Z0?ooo`3oool00P3oool00`000000oooo0?ooo`1U0?ooo`8000004@3o
ool00`000000oooo0?ooo`0H0?ooo`00603oool2000001<0oooo00<000000?ooo`3oool0D@3oool0
0`3oe9/0L[[Z0?ooo`020?ooo`070;ZK^P3oool0oooo0;YbV`3Dool0oooo0;ZK^P020?ooo`030;Yb
V`3Dool0oooo0080oooo00<000000?ooo`3oool0I@3oool00`000000oooo0?ooo`0@0?ooo`800000
6@3oool001P0oooo00<000000?ooo`3oool04P3oool200000580oooo00H0omBK07:jjP3oool0oooo
0?ooe02KL[X20?ooo`040=BKLP2jj_l0oooD09]b^P80oooo00<0e9]b0;[Zo`3oool00P3oool30000
06@0oooo0P00000B0?ooo`8000006@3oool001L0oooo0P00000E0?ooo`800000B@3oool00`3oe9/0
0000000000020000000509_Do`3oool0oooo0?oDV`1b^^X00P3oool0203oom@0Vg:j0?ooo`3oool0
e9]b0;[Zo`3oom@0Vg:j0P3oool00`3DVg80^^[o0?ooo`020?ooo`030000003oool0oooo06@0oooo
00<000000?ooo`3oool04@3oool3000001P0oooo000G0?ooo`8000005P3oool00`000000oooo0?oo
o`1>0?ooo`030;YbV`3De9/0L[[Z00<0oooo00/0^W9b0;[Zo`3oom@0V`2K0=Coo`3oool0^W9b0;[Z
o`3oom@0V`2K0=Coo`030?ooo`030000003oool0oooo06<0oooo0P00000D0?ooo`800000603oool0
01H0oooo0`00000F0?ooo`800000C`3oool00`3oe9/0000007:jjP030?ooo`040?oZ^P1b00000000
09_Do`80oooo00@0onZj078000000000VmCo103oool00`000000oooo0?ooo`1R0?ooo`8000005@3o
ool3000001L0oooo000F0?ooo`800000603oool200000680oooo00<000000?ooo`3oool0HP3oool0
0`000000oooo0?ooo`0E0?ooo`8000005`3oool001D0oooo0`00000I0?ooo`030000003oool0oooo
0600oooo00<000000?ooo`3oool0H@3oool2000001L0oooo0P00000G0?ooo`005@3oool2000001X0
oooo0P00001Q0?ooo`030000003oool0oooo0640oooo00<000000?ooo`3oool05P3oool3000001H0
oooo000E0?ooo`8000006`3oool00`000000oooo0?ooo`1O0?ooo`800000H@3oool2000001T0oooo
0P00000F0?ooo`00503oool3000000X0oooo1P00000;0?ooo`800000H03oool00`000000oooo0?oo
o`1P0?ooo`030000003oool0oooo00P0oooo1P00000:0?ooo`8000005P3oool001@0oooo0P00000:
0?ooo`8000001@3oool2000000X0oooo00<000000?ooo`3oool0GP3oool00`000000oooo0?ooo`1O
0?ooo`8000002@3oool2000000@0oooo0P0000090?ooo`<000005@3oool001@0oooo0P0000090?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool2000005l0oooo00<000000?oo
o`3oool0G`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo0P0000080?oo
o`8000005@3oool001@0oooo0P0000080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`1M0?ooo`030000003oool0oooo05h0oooo0P0000080?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool2000001D0oooo000C0?ooo`<00000
1`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
G@3oool00`000000oooo0?ooo`1M0?ooo`800000203oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00D0oooo0P00000E0?ooo`004`3oool2000000P0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`050?ooo`800000GP3oool2000005h0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00@0oooo0`00000D0?ooo`004`3oool2
000000L0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo05`0oooo00<000000?ooo`3oool0G03oool2000000L0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`040?ooo`800000503oool00180oooo0`0000070?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool01@3oool2000005d0oooo00<000000?ooo`3oool0G03oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0103oool20000
01@0oooo000B0?ooo`8000001`3oool00`000000oooo0?ooo`050?ooo`D000001P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool0F`3oool2000000H0
oooo00<000000?ooo`3oool01@3oool5000000L0oooo00<000000?ooo`3oool00`3oool2000001@0
oooo000B0?ooo`8000001`3oool00`000000oooo0?ooo`030?ooo`8000001@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo0P00001L0?ooo`030000003oool0oooo05/0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`8000001@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo0P00000C0?ooo`004P3oool2000000H0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05X0oooo0P00
00060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool2000000@0oooo00<0
00000?ooo`3oool0103oool2000001<0oooo000A0?ooo`<000001P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00P0oooo0P0000040?ooo`030000003oool0oooo00@0oooo0P00001K
0?ooo`800000F`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo0P00000C
0?ooo`004@3oool2000000H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1I0?oo
o`030000003oool0oooo05T0oooo0P0000060?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo0P00000C0?oo
o`004@3oool2000000H0oooo00D000000?ooo`3oool0oooo0000000?0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00`3oool2000005X0oooo00<000000?ooo`3oool0F@3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0303oool01@00
0000oooo0?ooo`3oool0000000H0oooo0P00000B0?ooo`004@3oool2000000D0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0>0?ooo`050000003oool0oooo0?ooo`0000001P3oool0
0`000000oooo0?ooo`1H0?ooo`030000003oool0oooo05P0oooo0P0000050?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool03P3oool01@000000oooo0?ooo`3oool0000000D0oooo0P00
000B0?ooo`004@3oool2000000D0oooo00D000000?ooo`3oool0oooo0000000B0?ooo`050000003o
ool0oooo0?ooo`0000001@3oool2000005T0oooo00<000000?ooo`3oool0F03oool00`000000oooo
0?ooo`040?ooo`050000003oool0oooo0?ooo`0000004@3oool01@000000oooo0?ooo`3oool00000
00D0oooo0P00000B0?ooo`004@3oool2000000@0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`040?ooo`H000001P3oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?oo
o`3oool0E`3oool00`000000oooo0?ooo`1G0?ooo`8000001@3oool01@000000oooo0?ooo`3oool0
000000H0oooo1`0000060?ooo`040000003oool0oooo000000D0oooo0P00000B0?ooo`00403oool2
000000D0oooo00D000000?ooo`3oool0oooo000000050?ooo`8000001P3oool00`000000oooo0?oo
o`040?ooo`050000003oool0oooo0?ooo`0000001@3oool2000005P0oooo00<000000?ooo`3oool0
E`3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000
oooo0?ooo`030?ooo`8000001@3oool01@000000oooo0?ooo`3oool0000000@0oooo0P00000B0?oo
o`00403oool2000000D0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
00L0oooo0P0000050?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool0EP3oool2
000005L0oooo0P0000050?ooo`050000003oool0oooo0?ooo`0000001@3oool2000000P0oooo0P00
00040?ooo`040000003oool0oooo000000D0oooo0P00000A0?ooo`00403oool2000000@0oooo00D0
00000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
0`3oool010000000oooo0?ooo`0000050?ooo`800000E`3oool00`000000oooo0?ooo`1F0?ooo`03
0000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000050?ooo`8000004@3oool0
0100oooo0P0000040?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?oo
o`1E0?ooo`030000003oool0oooo05D0oooo0P0000050?ooo`050000003oool0oooo0?ooo`000000
103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
0000103oool200000140oooo000@0?ooo`800000103oool010000000oooo0?ooo`0000040?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000050?oo
o`800000EP3oool00`000000oooo0?ooo`1D0?ooo`8000001@3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool03@3oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`3oool00P3oool200000140oooo000@0?ooo`8000000`3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`3oool03`3oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool00`3oool2000004L0oooo00@0j[Yb000000000000L[[Z0P3oool0103Z^W80
00000000001b^^X40?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0103oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo000000040?ooo`8000004@3oool000l0oooo0P0000040?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool01@3oool4000000L0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0A03oool0203oj[X0LW:j0?oo
o`3oool0^W9b0;[Zo`3oool0^Y^j0P3oool00`2jLY/0e?oo0?ooo`020?ooo`030000003oool0oooo
05<0oooo0P0000050?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`05
0?ooo`@000001`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3o
ool200000100oooo000?0?ooo`800000103oool010000000oooo0?ooo`0000030?ooo`030000003o
ool0oooo00@0oooo0`0000030?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo0?ooo`030?ooo`800000B@3oool0103DVg80^^[o0?ooe02KL[X20?ooo`03
0=BKLP2jj_l0oooo0080oooo0`00001C0?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo00@0oooo0P0000030?ooo`8000001P3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool200000100oooo000?0?oo
o`800000103oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool01@3oool2000000H0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo03d0oooo00<0omBK0000000000000P0000000`2Ke?l0oooo0=BK
000200000004002Ke03oool0oooD09]b^P80oooo00<0e9]b0;[Zo`3oool00P3oool00`000000oooo
0?ooo`1B0?ooo`8000001@3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01@3oool2000000D0oooo00L000000?ooo`3oool0oooo0000003oool0
000000@0oooo0P00000@0?ooo`003`3oool2000000<0oooo00@000000?ooo`3oool00000103oool0
10000000oooo0?ooo`3oool2000000X0oooo00<000000?ooo`3oool00`3oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo00<0oooo0P0000150?ooo`030=BKLP2jj_l0oooo00<0oooo
00D0^W9b0;[Zo`3oom@0V`2K0=Coo`030?ooo`030000003oool0oooo0580oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool20000
00X0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00@00000
0?ooo`3oool0oooo0P00000@0?ooo`003`3oool2000000<0oooo00@000000?ooo`3oool000000`3o
ool01@000000oooo0?ooo`3oool0000000d0oooo0P0000040?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`130?ooo`040=BK000000000000002K
e080oooo00@0onZj078000000000VmCo103oool00`000000oooo0?ooo`1A0?ooo`8000001@3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0
0P3oool2000000l0oooo000?0?ooo`8000000`3oool010000000oooo0?ooo`0000030?ooo`050000
003oool0oooo0?ooo`0000003`3oool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?oo
o`3oool000001@3oool200000580oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`03
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool0000000@0
oooo0P00000?0?ooo`003P3oool2000000@0oooo00<000000?ooo`0000000`3oool01@000000oooo
0?ooo`3oool000000140oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000001@3oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo0500oooo0P000005
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0>0?ooo`050000003oool0oooo0?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`80
00003`3oool000h0oooo0P0000030?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3o
ool0oooo0000000B0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`00
00050?ooo`800000D@3oool200000540oooo00<000000?ooo`3oool00`3oool010000000oooo0?oo
o`0000030?ooo`050000003oool0oooo0?ooo`0000004@3oool00`000000oooo0?ooo`020?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool0oooo0P00000?0?ooo`003P3oool20000
00<0oooo00@000000?ooo`3oool000000P3oool01@000000oooo0?ooo`3oool0000000H0oooo1`00
00070?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000001@3oool00`000000
oooo0?ooo`1?0?ooo`030000003oool0oooo04l0oooo0P0000050?ooo`030000003oool0000000<0
oooo00D000000?ooo`3oool0oooo000000070?ooo`H000001P3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`0000000`3oool2000000l0oooo000>0?ooo`8000000`3oool01000
0000oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000001@3oool2000000H0oooo00<0
00000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool0
00001@3oool200000500oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`030?ooo`04
0000003oool0oooo00000080oooo00D000000?ooo`3oool0oooo000000060?ooo`8000001P3oool0
0`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000`3oool010000000oooo0?oo
o`0000030?ooo`8000003P3oool000h0oooo0P0000030?ooo`030000003oool000000080oooo00D0
00000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo00L0oooo0P0000050?ooo`050000
003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo
04h0oooo00<000000?ooo`3oool0CP3oool2000000@0oooo00@000000?ooo`3oool000000`3oool0
10000000oooo0?ooo`0000060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3o
ool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000`3oool2000000h0
oooo000>0?ooo`8000000P3oool010000000oooo0?ooo`0000020?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0000000D0oooo0P00001?0?ooo`030000003oool0
oooo04h0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`050000003o
ool0oooo0?ooo`000000103oool2000000/0oooo0P0000030?ooo`050000003oool0oooo0?ooo`00
00000P3oool010000000oooo0?ooo`0000030?ooo`8000003P3oool000d0oooo0P0000030?ooo`04
0000003oool0oooo00000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00@0
00000?ooo`3oool000001@3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo04d0oooo
0P0000040?ooo`040000003oool0oooo00000080oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`000003
0?ooo`030000003oool0000000<0oooo0P00000>0?ooo`003@3oool2000000<0oooo00<000000?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?oo
o`0000040?ooo`800000CP3oool00`000000oooo0?ooo`1<0?ooo`8000001@3oool00`000000oooo
000000030?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool03P3oool01@000000
oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`02
000000h0oooo000=0?ooo`8000000`3oool00`000000oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`0?0?ooo`050000003oool0oooo0?ooo`0000000`3o
ool01`000000oooo0?ooo`3oool000000?ooo`0000001@3oool2000004d0oooo0P00001=0?ooo`03
0000003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool03`3oool01@000000oooo0?ooo`3oool000000080oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`3oool2000000d0oooo000=0?ooo`800000
0`3oool00`000000oooo000000020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool04@3oool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool0B`3oool2
000000D0oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool0403oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`3oool2000000d0oooo000=0?ooo`8000000`3oool01@000000
oooo0000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000000D0?ooo`050000003oool0
oooo0?ooo`0000000`3oool01P000000oooo0?ooo`000000oooo000000D0oooo0P00001<0?ooo`03
0000003oool0oooo04/0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0B0?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`3oool2000000d0oooo
000<0?ooo`8000000`3oool00`000000oooo000000020?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool0503oool010000000oooo0?ooo`0000030?ooo`070000003oool0oooo0?oo
o`000000oooo000000050?ooo`030000003oool0oooo04X0oooo00<000000?ooo`3oool0BP3oool2
000000D0oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool04`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`000000
0P3oool010000000oooo0?ooo`3oool2000000d0oooo000<0?ooo`8000000`3oool00`000000oooo
000000020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0503oool01@000000
oooo0?ooo`3oool0000000<0oooo00H000000?ooo`3oool000000?ooo`0000050?ooo`800000B`3o
ool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0503oool010000000oooo
0?ooo`0000020?ooo`060000003oool0oooo0000003oool000000`3oool2000000d0oooo000<0?oo
o`8000000`3oool00`000000oooo000000020?ooo`030000003oool0000000<0oooo00<000000?oo
o`3oool05P3oool01@000000oooo0?ooo`3oool0000000<0oooo00H000000?ooo`3oool000000?oo
o`0000050?ooo`800000BP3oool00`000000oooo0?ooo`190?ooo`8000001@3oool00`000000oooo
000000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool05@3oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0oooo0P00
000<0?ooo`00303oool2000000<0oooo00D000000?ooo`000000oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000006@3oool010000000oooo0?ooo`0000030?ooo`070000003oool0oooo0?oo
o`000000oooo000000050?ooo`800000B@3oool2000004T0oooo0P0000050?ooo`030000003oool0
00000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo01L0oooo00H0
00000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo000000<0oooo0P00000<0?oo
o`00303oool2000000030?ooe02K00000000008000000P3oool010000000oooo0?ooo`0000030?oo
o`030000003oool0oooo01P0oooo00H000000?ooo`3oool000000?ooo`3Z^W82000000030;[Zo`3o
ool000000080oooo00<000000?ooo`3oool00P3oool3000001/0oooo00H0omBK0000000000000000
0000V`3DoolW0?ooo`030000003oool0oooo02L0oooo00H0omBK00000000000000000000V`3DoolJ
0?ooo`8000001@3oool00`000000oooo000000020?ooo`090000003oool0oooo0>ZjLP000000001b
0;[Zo`3oool0000001X0oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000020?oo
o`030000003oom@0V`0000<00000303oool000`0oooo0P0000000`3DV`00VmCo0?ooo`0200000080
oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`0I0?ooo`080000003oool0oooo0000
003oool0omBK07:jjP0000020?ooo`040000003oool0oooo000000@0oooo0`00000K0?ooo`030;Yb
000009/0e?oo02T0oooo00<000000?ooo`3oool0:03oool00`2jLP00002K0=Coo`0L0?ooo`030000
003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000omBK
07:jjP80oooo00<000000?ooo`3oool06@3oool020000000oooo0?ooo`000000oooo0000003oool0
00000P3oool010000000e9/009_Do`3oool2000000`0oooo000<0?ooo`80000000D0V`0007:jjP00
0000j[Yb000000020?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooe003000000030000LP000000oooo0080oooo00<000000?ooo`0000001@3oool20000
01`0oooo00<0omBK0000002Ke?l0:03oool00`000000oooo0?ooo`0Y0?ooo`030?oDV`000000VmCo
01X0oooo0P0000040?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oom@00`000000
0`000780^^[o0000000L0?ooo`060000003oool0oooo0000003oool000000P3oool01P000000oooo
0000002K0000L[[Z0?ooo`800000303oool000L0oooo00<0omBK0000000000000`000000203oool0
^W:K079b0000000007:j0000003oool000000P3oool01@000000oooo0?ooo`3oool0000001P0oooo
00<0omBK0000000000000`0000001`3oool0e9/00000003oe9/0L[[Z0?ooo`0000000P3oool01000
0000oooo0?ooo`0000050?ooo`8000004`3oool00`3oe9/00000000000020000000609_Do`3oool0
oooo0?ooo`3oom@0e=Co:03oool00`000000oooo0?ooo`0Z0?ooo`030?ooe03De?l0oooo01P0oooo
0P0000050?ooo`030000003oool000000080oooo00T000000?ooo`3oool0oooo0000002Ke?l0omBK
07:jjP0000007P3oool01@000000oooo0000003oool000000080oooo00D000000?ooo`000000^W:K
079b0003000000`0oooo000;0?ooo`80000000P0oooo0?oDV`00L[X000000?ooo`000000oooo0000
0080oooo00@000000?ooo`3oool000007`3oool01@000000oooD09/0LP000000L[[Z0080oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`<00000603oool01P3oj[X0LW:j
0?ooo`3oom@0V`2K0=CoobL0oooo00<000000?ooo`3oool09`3oool01P3oj[X0LW:j0?ooo`3oom@0
V`2K0=CooaL0oooo0P0000050?ooo`030000003oool0000000<0oooo00P000000?ooo`3oool00000
0?ooe02K0780^[ZK000001l0oooo00P000000?ooo`3oool000000?ooo`000000oooo00000080oooo
00@00000001b^P3oool0oooo0P00000;0?ooo`002`3oool200000080oooo00P0j[Yb000000000000
00000?ooo`000000oooo000000<0oooo00<000000?ooo`3oool07P3oool010000000onZj07800000
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`<00000
603oool0103Z^W8000000000001b^^XX0?ooo`800000:@3oool0103Z^W8000000000001b^^XG0?oo
o`8000001@3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<0
onZj0000001b^^X07`3oool020000000oooo0?ooo`000000oooo0000003oool000000P3oool00`00
0000j[Yb00000003000000/0oooo000;0?ooo`8000000`3oool200000080oooo00<000000?ooo`00
00000P3oool00`000000oooo0?ooo`0O0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool3000004<0oooo00<00000
0?ooo`3oool0@P3oool3000000@0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo01h0oooo00H000000?ooo`3oool000000?ooo`0000020?oo
o`030000003oool0000000<0oooo0P00000;0?ooo`002`3oool2000000<0oooo0P0000001@3oool0
00000?ooo`3oool000000080oooo00<000000?ooo`3oool0803oool010000000oooo0?ooo`000003
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool300000480oooo00<0
00000?ooo`3oool0@@3oool3000000@0oooo00@000000?ooo`3oool000000`3oool010000000oooo
0?ooo`0000030?ooo`030000003oool0oooo0200oooo00D000000?ooo`000000oooo000000020?oo
o`030000003oool0000000<0oooo0P00000;0?ooo`002`3oool200000080oooo00D000000?ooo`00
0000oooo000000020?ooo`030000003oool0000002@0oooo00@000000?ooo`3oool000000`3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo100000100?ooo`030000003o
ool0oooo03l0oooo100000040?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool0
00000`3oool00`000000oooo0?ooo`0Q0?ooo`0:0000003oool0oooo0000003oool000000?ooo`00
0000oooo000000<0oooo0P00000;0?ooo`002P3oool2000000<0oooo00L000000?ooo`000000oooo
0000003oool000000080oooo00<000000?ooo`3oool08`3oool010000000oooo0?ooo`0000030?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool4000003l0oooo00<00000
0?ooo`3oool0?@3oool5000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003o
ool0oooo000000<0oooo00<000000?ooo`3oool08P3oool02P000000oooo0?ooo`000000oooo0000
003oool000000?ooo`0000030?ooo`8000002`3oool000X0oooo0P0000030?ooo`070000003oool0
00000?ooo`000000oooo000000020?ooo`030000003oool0oooo02@0oooo00@000000?ooo`3oool0
00000P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0103oool30000
03h0oooo00<000000?ooo`3oool0>`3oool5000000H0oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo02<0oooo00P000000?ooo`3oool00000
0?ooo`000000oooo00000080oooo00@000000?ooo`3oool0oooo0P00000:0?ooo`002P3oool20000
00<0oooo00@000000?ooo`00000000000P3oool00`000000oooo0000000X0?ooo`040000003oool0
oooo00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo
1000000l0?ooo`030000003oool0oooo03X0oooo100000070?ooo`040000003oool0oooo00000080
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo02@0oooo00<000000?oo
o`3oool00P0000020?ooo`030000003oool0000000<0oooo0P00000:0?ooo`00o`00000[00000000
0P3oool00`000000oooo0?ooo`050?ooo`80000000<0oooo0000003oool00P000000103oool00000
0?ooo`0000020?ooo`030000003oool0000000X0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool0oooo0P0000000`3o
ool000000?ooo`020?ooo`030000003oool0oooo00<000001@3oool6000000X0oooo00<000000?oo
o`3oool0203ooom6000000T0oooo00<000000?ooo`3oool02@3oool5000000H0oooo0`0000020?oo
o`060000003oool0oooo0?ooo`000000oooo0P0000030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo0P00
00020?ooo`060000003oool000000?ooo`000000oooo0P0000020?ooo`8000001`3oool100000040
oooo0@3oool000X0oooo0P0000002@3oool000000000003oool000000?ooo`000000oooo00000002
0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`00
00030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`060?ooo`H00000
1`3oool010000000oooo0?ooo`3ooolG00000180oooo00<000000?ooo`3oool03`3ooolH000000<0
oooo00<000000?ooo`3oool01@3oool6000000T0oooo00D000000?ooo`3oool0oooo000000030?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0P
0?ooo`090000003oool0oooo0000003oool000000?ooo`000000oooo008000000P3oool2000000X0
oooo00090?ooo`8000000`3oool02@000000oooo0000003oool000000?ooo`000000oooo0000000/
0?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0oooo00H0oooo5`0000000`3oool000000000000:000001D0oooo00<000000?ooo`3oool0
4`3ooolT000000P0oooo0P0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000002/0oooo00<000000?ooo`3oool00P000000103oool000000?ooo`000004
0?ooo`8000002@3oool000T0oooo0P0000030?ooo`090000003oool000000?ooo`000000oooo0000
003oool0000002d0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`3oool20000
0080oooo0P00000:0?ooo``00000103oool<000001T0oooo00<000000?ooo`3oool05`3oool=0000
00<0oooo3000000:0?ooo`800000103oool00`000000oooo0?ooo`0200000080oooo00D000000?oo
o`3oool0oooo0000000/0?ooo`030000003oool0oooo008000000P3oool00`000000oooo00000003
0?ooo`8000002@3oool000T0oooo0P0000030?ooo`060000003oool000000000003oool000000P3o
ool00`000000oooo0?ooo`0/0?ooo`040000003oool0oooo000000<0oooo0P0000030?ooo`040000
003oool0oooo0?ooo`8000004`3oool600000080oooo1@00000M0?ooo`030000003oool0oooo01/0
oooo3@00000C0?ooo`800000103oool200000080oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo02/0oooo00<000000?ooo`3oool00P0000020?ooo`030000003oool00000
00<0oooo0P0000090?ooo`002@3oool2000000<0oooo00H000000?ooo`00000000000?ooo`000002
0?ooo`030000003oool0oooo02`0oooo00@000000?ooo`3oool0oooo0P0000030?ooo`040000003o
ool0oooo0?ooo`8000000`3oool6000000H0oooo2P0000020?ooo`D00000803oool2000001l0oooo
4@0000070?ooo`D00000103oool200000080oooo0P0000030?ooo`050000003oool0oooo0?ooo`00
0000;P3oool02P000000oooo0?ooo`000000oooo0000003oool000000?ooo`0000030?ooo`800000
2@3oool000T0oooo0P0000030?ooo`80000000H0oooo0000003oool000000?ooo`00000`0?ooo`03
0000003oool0oooo0080oooo00@000000?ooo`3oool0oooo0P0000030?ooo`<000001@3oool70000
00@0oooo0`0000000`3oool0000000000004000002<0oooo00<000000?ooo`3oool08@3oool;0000
00<0oooo1`0000050?ooo`@000000`3oool010000000oooo0?ooo`3oool2000000<0oooo00<00000
0?ooo`3oool0;@3oool02P000000oooo0?ooo`000000oooo0000003oool000000?ooo`0000030?oo
o`8000002@3oool000T0oooo0P0000020?ooo`090000003oool000000?ooo`000000oooo0000003o
ool000000340oooo00<000000?ooo`3oool00P3oool2000000<0oooo00<000000?ooo`3oool00`3o
oolH000002D0oooo00<000000?ooo`3oool0903oool3000000050?ooo`00000000000000003oool0
3`0000060?ooo`050000003oool0oooo0?ooo`0000000`3oool200000340oooo00<000000?ooo`3o
ool00P0000020?ooo`8000000`3oool2000000T0oooo00080?ooo`8000000`3oool02@000000oooo
0000003oool000000?ooo`000000oooo0000000b0?ooo`030000003oool0oooo00<0oooo00@00000
0?ooo`3oool0oooo0`00000?0?ooo`T000009`3oool00`000000oooo0?ooo`0V0?ooo`<000000P3o
ool3000000l0oooo100000020?ooo`8000000`3oool00`000000oooo0?ooo`0a0?ooo`030000003o
ool0oooo008000000P3oool2000000@0oooo0P0000080?ooo`00203oool2000000<0oooo00@00000
0?ooo`000000oooo0P0000020?ooo`030000003oool0oooo0340oooo0P0000040?ooo`030000003o
ool0oooo00<0oooo4P0000000`3oool000000000000Z0?ooo`030000003oool0oooo02P0oooo1000
00020?ooo`l00000103oool2000000<0oooo0P00000d0?ooo`0:0000003oool0oooo0000003oool0
00000?ooo`000000oooo000000<0oooo0P0000080?ooo`00203oool2000000<0oooo00P000000?oo
o`00000000000?ooo`000000oooo000003H0oooo0P0000030?ooo`<000003P3oool3000000040?oo
o`0000000000000002`0oooo00<000000?ooo`3oool0:P3oool500000100oooo0P0000040?ooo`03
0000003oool0oooo03@0oooo00X000000?ooo`3oool000000?ooo`000000oooo0000003oool00000
0`3oool2000000P0oooo00080?ooo`8000000`3oool020000000oooo000000000000oooo0000003o
ool00000>03oool2000000@0oooo1@0000040?ooo`D000000P3oool2000002l0oooo0P00000]0?oo
o`/000000`3oool5000000@0oooo0P00000h0?ooo`090000003oool000000?ooo`000000oooo0000
003oool0000000<0oooo0P0000080?ooo`00203oool2000000<0oooo00P000000?ooo`0000000000
0?ooo`000000oooo000003X0oooo0P0000070?ooo`@000001@3oool200000340oooo00<000000?oo
o`3oool0;`3oool3000000D0oooo0`0000080?ooo`030000003oool0oooo03P0oooo00<000000?oo
o`3oool00P0000020?ooo`8000000`3oool2000000P0oooo00080?ooo`8000000`3oool200000006
0?ooo`000000oooo0000003oool00000?03oool4000000P0oooo1000000c0?ooo`030000003oool0
oooo0380oooo1@0000070?ooo`@00000>`3oool00`000000oooo0?ooo`0200000080oooo0P000003
0?ooo`800000203oool000L0oooo0P0000030?ooo`060000003oool000000?ooo`000000oooo0P00
00110?ooo`P00000=`3oool00`000000oooo0?ooo`0g0?ooo`L00000?`3oool01`000000oooo0?oo
o`000000oooo0000003oool00P0000040?ooo`8000001`3oool000L0oooo0P0000030?ooo`040000
003oool000000?ooo`80000000<0oooo0000003oool0O`3oool00`000000oooo0?ooo`1m0?ooo`07
0000003oool0oooo0000003oool000000?ooo`02000000@0oooo0P0000070?ooo`001`3oool20000
00<0oooo00@000000?ooo`000000oooo0P0000000`3oool000000?ooo`1o0?ooo`030000003oool0
oooo07h0oooo00D000000?ooo`000000oooo000000020?ooo`8000000`3oool2000000L0oooo0007
0?ooo`8000000`3oool020000000oooo000000000000oooo0000003oool00000P03oool00`000000
oooo0?ooo`1n0?ooo`030000003oool0oooo008000000P3oool2000000<0oooo0P0000070?ooo`00
1`3oool2000000<0oooo00P000000?ooo`00000000000?ooo`000000oooo00000800oooo0P00001o
0?ooo`030000003oool0oooo008000000P3oool2000000<0oooo0P0000070?ooo`001`3oool20000
00<0oooo0P0000000`3oool000000?ooo`0200000840oooo00<000000?ooo`3oool0OP3oool01`00
0000oooo0?ooo`000000oooo0000003oool00P0000030?ooo`8000001`3oool000H0oooo0P000003
0?ooo`060000003oool000000?ooo`000000oooo0P0000210?ooo`030000003oool0oooo07h0oooo
00L000000?ooo`3oool000000?ooo`000000oooo008000000`3oool2000000L0oooo00060?ooo`80
00000`3oool01P000000oooo0000003oool000000?ooo`800000P@3oool00`000000oooo0?ooo`1o
0?ooo`060000003oool000000?ooo`000000oooo0P0000040?ooo`8000001P3oool000/0oooo00@0
00000?ooo`000000oooo0P0000000`3oool000000?ooo`200?ooo`030000003oool0oooo07l0oooo
00<000000?ooo`3oool00P0000020?ooo`030000003oool0oooo00X0oooo000;0?ooo`040000003o
ool000000?ooo`80000000<0oooo0000003oool0P03oool00`000000oooo0?ooo`1o0?ooo`030000
003oool0oooo008000000P3oool2000000/0oooo000;0?ooo`080000003oool000000000003oool0
00000?ooo`0000210?ooo`800000P03oool00`000000oooo0?ooo`0200000080oooo0P00000;0?oo
o`002`3oool01@000000oooo000000000000oooo00800000PP3oool00`000000oooo0?ooo`200?oo
o`060000003oool000000?ooo`000000oooo0P00000;0?ooo`002`3oool2000000030?ooo`000000
oooo00800000PP3oool00`000000oooo0?ooo`200?ooo`060000003oool000000?ooo`000000oooo
0P00000;0?ooo`002P3oool01P000000oooo0000003oool000000?ooo`800000PP3oool00`000000
oooo0?ooo`200?ooo`030000003oool0oooo0080000000<0oooo0000000000002`3oool000X0oooo
00@000000?ooo`000000oooo0P0000000`3oool000000?ooo`210?ooo`030000003oool0oooo0800
oooo00<000000?ooo`3oool00P0000000`3oool000000000000;0?ooo`002P3oool010000000oooo
0000003oool2000000030?ooo`000000oooo07<0oooo00@0j[Yb000000000000L[[Z0P3oool0103Z
^W8000000000001b^^X40?ooo`030000003oool0oooo0800oooo00<000000?ooo`3oool00P000000
0`3oool000000000000;0?ooo`002P3oool020000000oooo000000000000oooo0000003oool00000
L`3oool0203oj[X0LW:j0?ooo`3oool0^W9b0;[Zo`3oool0^Y^j0P3oool00`2jLY/0e?oo0?ooo`02
0?ooo`030000003oool0oooo0840oooo00@000000?ooo`00000000000P3oool2000000X0oooo000:
0?ooo`080000003oool000000000003oool000000?ooo`00001g0?ooo`040=BKLP2jj_l0oooD09]b
^P80oooo00<0e9]b0;[Zo`3oool00P3oool300000840oooo00@000000?ooo`00000000000P3oool2
000000X0oooo000:0?ooo`80000000<0oooo0000003oool00P00001e0?ooo`070=BK000000000000
002Ke03oool0oooD09]b^P020?ooo`030=BKLP2jj_l0oooo0080oooo00<000000?ooo`3oool0P@3o
ool01P000000oooo0000003oool000000?ooo`8000002P3oool000T0oooo00H000000?ooo`000000
oooo0000003oool2000007D0oooo00<0e9]b0;[Zo`3oool00`3oool01@2jLW80^^[o0?ooe02K09/0
e?oo00<0oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`02000000030?ooo`000000
000000X0oooo00090?ooo`060000003oool000000?ooo`000000oooo0P00001e0?ooo`040=BK0000
00000000002Ke080oooo00@0onZj078000000000VmCo103oool00`000000oooo0?ooo`210?ooo`03
0000003oool0oooo0080000000<0oooo0000000000002P3oool000T0oooo00@000000?ooo`000000
oooo0P0000000`3oool000000?ooo`220?ooo`030000003oool0oooo0840oooo00<000000?ooo`3o
ool00P0000000`3oool000000000000:0?ooo`002@3oool010000000oooo0000003oool200000003
0?ooo`000000oooo0880oooo00<000000?ooo`3oool0PP3oool01@000000oooo000000000000oooo
008000002P3oool000T0oooo00P000000?ooo`00000000000?ooo`000000oooo000008<0oooo0P00
00230?ooo`080000003oool000000000003oool000000?ooo`0000090?ooo`002@3oool020000000
oooo000000000000oooo0000003oool00000P`3oool00`000000oooo0?ooo`220?ooo`040000003o
ool0000000000080oooo0P0000090?ooo`002@3oool2000000030?ooo`000000oooo00800000Q03o
ool00`000000oooo0?ooo`220?ooo`060000003oool000000?ooo`000000oooo0P0000090?ooo`00
203oool01P000000oooo0000003oool000000?ooo`800000Q03oool00`000000oooo0?ooo`220?oo
o`060000003oool000000?ooo`000000oooo0P0000090?ooo`00203oool01P000000oooo0000003o
ool000000?ooo`800000Q03oool00`000000oooo0?ooo`220?ooo`030000003oool0oooo00800000
00<0oooo0000000000002@3oool000P0oooo00@000000?ooo`000000oooo0P0000000`3oool00000
0?ooo`230?ooo`030000003oool0oooo08<0oooo00D000000?ooo`00000000000?ooo`02000000T0
oooo00080?ooo`040000003oool000000?ooo`80000000<0oooo0000003oool0P`3oool2000008@0
oooo00D000000?ooo`00000000000?ooo`02000000T0oooo00080?ooo`080000003oool000000000
003oool000000?ooo`0000240?ooo`030000003oool0oooo08<0oooo00P000000?ooo`0000000000
0?ooo`000000oooo000000P0oooo00080?ooo`80000000H0oooo0000003oool000000?ooo`000024
0?ooo`030000003oool0oooo08<0oooo00@000000?ooo`00000000000P3oool2000000P0oooo0007
0?ooo`060000003oool000000?ooo`000000oooo0P0000250?ooo`030000003oool0oooo08<0oooo
00@000000?ooo`00000000000P3oool2000000P0oooo00070?ooo`060000003oool000000?ooo`00
0000oooo0P0000250?ooo`030000003oool0oooo08@0oooo0P0000000`3oool000000?ooo`020000
00P0oooo00070?ooo`060000003oool000000?ooo`000000oooo0P0000250?ooo`030000003oool0
oooo08@0oooo00D000000?ooo`00000000000?ooo`02000000P0oooo00070?ooo`040000003oool0
00000?ooo`80000000<0oooo0000003oool0Q03oool00`000000oooo0?ooo`240?ooo`080000003o
ool000000000003oool000000?ooo`0000070?ooo`002@3oool01P000000oooo000000000000oooo
000008D0oooo0P0000250?ooo`060000003oool000000000003oool000002@3oool000T0oooo0P00
0000103oool000000?ooo`0000250?ooo`030000003oool0oooo08@0oooo00H000000?ooo`000000
00000?ooo`0000090?ooo`00203oool01`000000oooo0000003oool000000?ooo`000000Q@3oool0
0`000000oooo0?ooo`240?ooo`060000003oool000000000003oool000002@3oool000P0oooo00@0
00000?ooo`000000oooo0P0000260?ooo`030000003oool0oooo08D0oooo0`0000020?ooo`030000
003oool0oooo00H0oooo00080?ooo`040000003oool000000?ooo`800000QP3oool00`000000oooo
0?ooo`250?ooo`80000000@0oooo0000003oool00000203oool000P0oooo00@000000?ooo`000000
oooo0P0000260?ooo`030000003oool0oooo08D0oooo00H000000?ooo`00000000000?ooo`000008
0?ooo`00203oool01P000000oooo000000000000oooo000008H0oooo0P0000260?ooo`060000003o
ool000000000003oool00000203oool000P0oooo0P000000103oool000000?ooo`0000260?ooo`03
0000003oool0oooo08D0oooo00H000000?ooo`00000000000?ooo`0000080?ooo`001`3oool01`00
0000oooo0000003oool000000?ooo`000000QP3oool00`000000oooo0?ooo`250?ooo`060000003o
ool000000000003oool00000203oool000L0oooo00L000000?ooo`000000oooo0000003oool00000
08H0oooo00<000000?ooo`3oool0QP3oool300000080oooo00<000000?ooo`3oool01@3oool000L0
oooo00@000000?ooo`000000oooo0P00001b0?ooo`080?ooe02K00000000000000000780^^[o0?oo
o`3Z^W820000000407:jjP3oool0oooo0>ZjLP80000000<0L[[Z0?ooo`3oool00P3oool00`000000
oooo0?ooo`260?ooo`<000000P3oool00`000000oooo0?ooo`050?ooo`001`3oool010000000oooo
0000003oool2000007@0oooo00<0omBK07:jjP3oool00P3oool01`2jVkX0oooo0?ooo`2jLY/0e?oo
0?ooo`2jVkX00P3oool00`2jLY/0e?oo0?ooo`020?ooo`030000003oool0oooo08H0oooo0P000000
103oool000000?ooo`0000070?ooo`002@3oool010000000oooo00000000001d0?ooo`060?oDV`1b
^^X0oooo0?ooo`3oom@0Vg:j0P3oool0103DVg80^^[o0?ooe02KL[X20?ooo`030=BKLP2jj_l0oooo
0080oooo0`0000260?ooo`80000000<0oooo0000003oool0203oool000T0oooo0P0000000`3oool0
00000?ooo`1c0?ooo`060?oDV`1b^^X0oooo0?ooo`3oom@0Vg:j0P3oool0103DVg80^^[o0?ooe02K
L[X20?ooo`030=BKLP2jj_l0oooo0080oooo00<000000?ooo`3oool0QP3oool010000000oooo0000
000000090?ooo`00203oool01@000000oooo0000003oool0000007<0oooo00<0^W:K0=CDV`1b^^X0
0`3oool02`2jLW80^^[o0?ooe02K09/0e?oo0?ooo`2jLW80^^[o0?ooe02K09/0e?oo00<0oooo00<0
00000?ooo`3oool0QP3oool010000000oooo0000000000090?ooo`00203oool01@000000oooo0000
003oool0000007<0oooo00<0omBK0000001b^^X00`3oool0103oj[X0LP000000002Ke?l20?ooo`04
0?oZ^P1b0000000009_Do`@0oooo00<000000?ooo`3oool0Q`3oool3000000T0oooo00080?ooo`05
0000003oool000000?ooo`000000Q`3oool00`000000oooo0?ooo`270?ooo`<000002@3oool000P0
oooo00@000000?ooo`0000000000R03oool00`000000oooo0?ooo`270?ooo`80000000<0oooo0000
003oool01`3oool000P0oooo00@000000?ooo`0000000000R03oool00`000000oooo0?ooo`270?oo
o`80000000<0oooo0000003oool01`3oool000P0oooo00@000000?ooo`0000000000R03oool20000
08P0oooo0P0000000`3oool000000?ooo`070?ooo`00203oool2000000030?ooo`000000oooo08L0
oooo00<000000?ooo`3oool0Q`3oool010000000oooo0000000000080?ooo`001`3oool01@000000
oooo0000003oool0000008P0oooo00<000000?ooo`3oool0Q`3oool010000000oooo000000000008
0?ooo`001`3oool01@000000oooo0000003oool0000008P0oooo00<000000?ooo`3oool0Q`3oool0
1@000000oooo0000003oool0000000L0oooo00070?ooo`050000003oool000000?ooo`000000R03o
ool00`000000oooo0?ooo`280?ooo`80000000<0oooo0000003oool01P3oool000L0oooo00@00000
0?ooo`0000000000R@3oool00`000000oooo0?ooo`280?ooo`80000000<0oooo0000003oool01P3o
ool000T0oooo0P0000290?ooo`800000R@3oool2000000T0oooo00090?ooo`800000R@3oool00`00
0000oooo0?ooo`280?ooo`8000002@3oool000P0oooo00<000000?ooo`000000R@3oool00`000000
oooo0?ooo`280?ooo`030000003oool0000000P0oooo00080?ooo`03